package com.ejie.y41b.dao;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.ExpedienKgest;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.FiltroSanciones;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Recurso;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.Tctipres;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * ExpedienDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class ExpedienDaoImpl implements ExpedienDao {
	private JdbcTemplate jdbcTemplate;

	private RowMapper<Expedien> rwMap = new RowMapper<Expedien>() {
		public Expedien mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Sanexp sanexp = new Sanexp(resultSet.getString("SanexpEXCODIGO"), resultSet.getString("EXCOOR"),
					resultSet.getString("SanexpEXFOLDERID"), resultSet.getString("SanexpEXDESCES"),
					resultSet.getString("SanexpEXDESCEU"), resultSet.getDate("SanexpEXFECPREVFIN"),
					resultSet.getDate("SanexpEXFECFIN"), resultSet.getString("SanexpEXCALIF"),
					resultSet.getString("SanexpEXIMPORTE"), resultSet.getString("SanexpEXRECURSO"),
					resultSet.getString("SanexpEXORDEN"), resultSet.getString("SanexpEXTIPRES"),
					resultSet.getString("SanexpEXCAJA1"), resultSet.getString("SanexpEXCAJA2"),
					resultSet.getString("SanexpEXMOCODIGO"), null, new Fase(),
					resultSet.getString("SanexpEXMOCODIGOULT"), null, resultSet.getDate("SanexpEXFECALTA"),
					resultSet.getDate("SanexpEXFECMODIF"), resultSet.getString("SanexpEXUSUALTA"),
					resultSet.getString("SanexpEXUSUMODIF"), null, null,
					new Santramexp(resultSet.getString("SanexpEXTRPOSCOD")),
					new Santramexp(resultSet.getString("SANEXPEXTRENTIDAD")), null, null, null, null, null, null, null,
					null, null, null);
			sanexp.setExcooractual(resultSet.getString("EXCOORACTUAL"));
			sanexp.setExdestnotifsancionado(resultSet.getString("EXDESTNOTIFSANCIONADO"));
			sanexp.setExverifsanc(resultSet.getString("EXVERIFSANC"));
			sanexp.setExverifinco(resultSet.getString("EXVERIFINCO"));
			return new Expedien(resultSet.getString("expedienEXCODIGO"), resultSet.getString("EXCOOR"),
					resultSet.getBigDecimal("EXNRAN"), resultSet.getBigDecimal("EXNROR"), resultSet.getDate("EXFERE"),
					resultSet.getString("EXCOIT"), resultSet.getString("EXCOES"), resultSet.getDate("EXFEACIN"),
					resultSet.getDate("EXFEEMCA"), resultSet.getDate("EXFEPLCA"), resultSet.getDate("EXFPNOPC"),
					resultSet.getDate("EXFEDE"), resultSet.getDate("EXFECOAL"), resultSet.getDate("EXFENOPR"),
					resultSet.getDate("EXFEPUPR"), resultSet.getString("EXCOOSPR"), resultSet.getDate("EXFEALPR"),
					resultSet.getDate("EXFEEL"), resultSet.getDate("EXFERES"), resultSet.getDate("EXFENORE"),
					resultSet.getDate("EXFEPURE"), resultSet.getString("EXCOOSRE"), resultSet.getString("EXCOTTR"),
					resultSet.getBigDecimal("EXCAMURE"), resultSet.getDate("EXFETA"), resultSet.getString("EXCOTSA"),
					resultSet.getDate("EXFECROI"), resultSet.getDate("EXFEAR"), resultSet.getString("EXCOORIE"),
					resultSet.getString("EXINRE"), resultSet.getString("EXINCOCO"), resultSet.getString("EXINEXVA"),
					resultSet.getDate("EXFECIRC"), resultSet.getDate("EXFENOAI"), resultSet.getDate("EXFECOLM"),
					resultSet.getString("EXNUINLM"), resultSet.getDate("EXFEINMU"), resultSet.getDate("EXFEAVMU"),
					resultSet.getDate("EXFEIMCD"), resultSet.getDate("EXFECEDE"), resultSet.getString("EXCOPS"),
					resultSet.getString("EXCOSE"), sanexp, null, null, null);
		}
	};

	private RowMapper<Expedien> rwMapExpedienSentenciaFirme = new RowMapper<Expedien>() {
		public Expedien mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Sanexp sanexp = new Sanexp();
			sanexp.setEximporte(resultSet.getString("EXIMPORTE"));
			sanexp.setExcodigo(resultSet.getString("expedienEXCODIGO"));
			sanexp.setExcooractual(resultSet.getString("EXCOORACTUAL"));
			Recurso recurso = new Recurso();
			recurso.setRefereor(resultSet.getDate("REFEREOR"));

			return new Expedien(resultSet.getString("expedienEXCODIGO"), resultSet.getString("EXCOOR"),
					resultSet.getBigDecimal("EXNRAN"), resultSet.getBigDecimal("EXNROR"), resultSet.getDate("EXFERE"),
					resultSet.getString("EXCOIT"), resultSet.getString("EXCOES"), resultSet.getDate("EXFEACIN"),
					resultSet.getDate("EXFEEMCA"), resultSet.getDate("EXFEPLCA"), resultSet.getDate("EXFPNOPC"),
					resultSet.getDate("EXFEDE"), resultSet.getDate("EXFECOAL"), resultSet.getDate("EXFENOPR"),
					resultSet.getDate("EXFEPUPR"), resultSet.getString("EXCOOSPR"), resultSet.getDate("EXFEALPR"),
					resultSet.getDate("EXFEEL"), resultSet.getDate("EXFERES"), resultSet.getDate("EXFENORE"),
					resultSet.getDate("EXFEPURE"), resultSet.getString("EXCOOSRE"), resultSet.getString("EXCOTTR"),
					resultSet.getBigDecimal("EXCAMURE"), resultSet.getDate("EXFETA"), resultSet.getString("EXCOTSA"),
					resultSet.getDate("EXFECROI"), resultSet.getDate("EXFEAR"), resultSet.getString("EXCOORIE"),
					resultSet.getString("EXINRE"), resultSet.getString("EXINCOCO"), resultSet.getString("EXINEXVA"),
					resultSet.getDate("EXFECIRC"), resultSet.getDate("EXFENOAI"), resultSet.getDate("EXFECOLM"),
					resultSet.getString("EXNUINLM"), resultSet.getDate("EXFEINMU"), resultSet.getDate("EXFEAVMU"),
					resultSet.getDate("EXFEIMCD"), resultSet.getDate("EXFECEDE"), resultSet.getString("EXCOPS"),
					resultSet.getString("EXCOSE"), sanexp, null, recurso, null);
		}
	};

	private RowMapper<Expedien> rwMapConFase = new RowMapper<Expedien>() {
		public Expedien mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Producto producto = new Producto(resultSet.getString("productoPSCODIGO"),
					resultSet.getString("productoPSNOMBRE"), resultSet.getString("productoPSNOMBREE"));

			Motivo motivo = new Motivo(resultSet.getString("motivoTIRCODIGO"), resultSet.getString("motivoTIRNOMBRE"),
					resultSet.getString("motivoTIRNOMBREE"));
			Sanexp sanexp = new Sanexp(resultSet.getString("SanexpEXCODIGO"), resultSet.getString("EXCOOR"),
					resultSet.getString("SanexpEXFOLDERID"), resultSet.getString("SanexpEXDESCES"),
					resultSet.getString("SanexpEXDESCEU"), resultSet.getDate("SanexpEXFECPREVFIN"),
					resultSet.getDate("SanexpEXFECFIN"), resultSet.getString("SanexpEXCALIF"),
					resultSet.getString("SanexpEXIMPORTE"), resultSet.getString("SanexpEXRECURSO"),
					resultSet.getString("SanexpEXORDEN"), resultSet.getString("SanexpEXTIPRES"),
					resultSet.getString("SanexpEXCAJA1"), resultSet.getString("SanexpEXCAJA2"),
					resultSet.getString("SanexpEXMOCODIGO"), null,
					new Fase(resultSet.getString("fasefcodigo"), resultSet.getString("fasefnombre"),
							resultSet.getString("fasefnombree"), null, null),
					resultSet.getString("SanexpEXMOCODIGOULT"), resultSet.getDate("SanexpEXFECPROPRESO"),
					resultSet.getDate("SanexpEXFECALTA"), resultSet.getDate("SanexpEXFECMODIF"),
					resultSet.getString("SanexpEXUSUALTA"), resultSet.getString("SanexpEXUSUMODIF"),
					resultSet.getString("SanexpEXLIQESTADO"), resultSet.getString("SanexpEXLIQAPREMIO"),
					new Santramexp(resultSet.getString("SanexpEXTRPOSCOD"),
							/*
							 * resultSet.getString("santramexpTROBSERVES" )
							 */null, null),
					new Santramexp(resultSet.getString("SANEXPEXTRENTIDAD")), null, resultSet.getDate("SanexpHDFECHD"),
					null, motivo, null, null, null, null, null, resultSet.getDate("SanexpEXFECPRESCR"));
			sanexp.setExcooractual(resultSet.getString("EXCOORACTUAL"));
			sanexp.setExdestnotifsancionado(resultSet.getString("EXDESTNOTIFSANCIONADO"));
			sanexp.setExverifsanc(resultSet.getString("EXVERIFSANC"));
			sanexp.setExverifinco(resultSet.getString("EXVERIFINCO"));
			sanexp.setExidparticipacionsancionado(resultSet.getString("EXIDPARTICIPACIONSANCIONADO"));
			sanexp.setExhdformanotiforigen(resultSet.getString("EXHDFORMANOTIFORIGEN"));
			return new Expedien(resultSet.getString("EXCODIGO"), resultSet.getString("EXCOOR"),
					resultSet.getBigDecimal("EXNRAN"), resultSet.getBigDecimal("EXNROR"), resultSet.getDate("EXFERE"),
					resultSet.getString("EXCOIT"), resultSet.getString("EXCOES"), resultSet.getDate("EXFEACIN"),
					resultSet.getDate("EXFEEMCA"), resultSet.getDate("EXFEPLCA"), resultSet.getDate("EXFPNOPC"),
					resultSet.getDate("EXFEDE"), resultSet.getDate("EXFECOAL"), resultSet.getDate("EXFENOPR"),
					resultSet.getDate("EXFEPUPR"), resultSet.getString("EXCOOSPR"), resultSet.getDate("EXFEALPR"),
					resultSet.getDate("EXFEEL"), resultSet.getDate("EXFERES"), resultSet.getDate("EXFENORE"),
					resultSet.getDate("EXFEPURE"), resultSet.getString("EXCOOSRE"), resultSet.getString("EXCOTTR"),
					resultSet.getBigDecimal("EXCAMURE"), resultSet.getDate("EXFETA"), resultSet.getString("EXCOTSA"),
					resultSet.getDate("EXFECROI"), resultSet.getDate("EXFEAR"), resultSet.getString("EXCOORIE"),
					resultSet.getString("EXINRE"), resultSet.getString("EXINCOCO"), resultSet.getString("EXINEXVA"),
					resultSet.getDate("EXFECIRC"), resultSet.getDate("EXFENOAI"), resultSet.getDate("EXFECOLM"),
					resultSet.getString("EXNUINLM"), resultSet.getDate("EXFEINMU"), resultSet.getDate("EXFEAVMU"),
					resultSet.getDate("EXFEIMCD"), resultSet.getDate("EXFECEDE"), resultSet.getString("EXCOPS"),
					resultSet.getString("EXCOSE"), sanexp, null, null, producto);
		}
	};

	private RowMapper<ExpedienKgest> rwMapKgest = new RowMapper<ExpedienKgest>() {
		public ExpedienKgest mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			ExpedienKgest expedienKgest = new ExpedienKgest(resultSet.getString("EXCODIGO"),
					resultSet.getString("EXCOOR"), resultSet.getBigDecimal("EXNRAN"), resultSet.getBigDecimal("EXNROR"),
					resultSet.getDate("EXFERE"), resultSet.getString("EXCOIT"), resultSet.getString("EXCOES"),
					resultSet.getDate("EXFEACIN"), resultSet.getDate("EXFEEMCA"), resultSet.getDate("EXFEPLCA"),
					resultSet.getDate("EXFPNOPC"), resultSet.getDate("EXFEDE"), resultSet.getDate("EXFECOAL"),
					resultSet.getDate("EXFENOPR"), resultSet.getDate("EXFEPUPR"), resultSet.getString("OSNOMBREPR"),
					resultSet.getDate("EXFEALPR"), resultSet.getDate("EXFEEL"), resultSet.getDate("EXFERES"),
					resultSet.getDate("EXFENORE"), resultSet.getDate("EXFEPURE"), resultSet.getString("OSNOMBRERE"),
					resultSet.getString("TTRNOMBRE"), resultSet.getString("TTRNOMBREEU"),
					resultSet.getBigDecimal("EXCAMURE"), resultSet.getDate("EXFETA"), resultSet.getString("TSANOMBRE"),
					resultSet.getDate("EXFECROI"), resultSet.getDate("EXFEAR"), resultSet.getString("EXCOORIE"),
					resultSet.getString("EXINRE"), resultSet.getString("EXINCOCO"), resultSet.getString("EXINEXVA"),
					resultSet.getDate("EXFECIRC"), resultSet.getDate("EXFENOAI"), resultSet.getDate("EXFECOLM"),
					resultSet.getString("EXNUINLM"), resultSet.getDate("EXFEINMU"), resultSet.getDate("EXFEAVMU"),
					resultSet.getDate("EXFEIMCD"), resultSet.getDate("EXFECEDE"), resultSet.getString("EXCOPS"),
					resultSet.getString("EXCOSE"), resultSet.getString("ITNOMBRE"), resultSet.getString("ESNOMBRE"),
					resultSet.getString("ESNIF"), resultSet.getString("ESNOCO"), resultSet.getString("ESNODIR"),
					resultSet.getString("ESNOMBRE_LOCALIDAD"), resultSet.getString("ESNOMBRE_MUNICIPIO"),
					resultSet.getDate("REFEREOR"), resultSet.getDate("REFERENP"), resultSet.getDate("REFEPRRO"),
					resultSet.getDate("REFENRO1"), resultSet.getDate("REFERERO"), resultSet.getString("OSNOMBRERO"),
					resultSet.getString("TARNOMBRE"), resultSet.getBigDecimal("RECAMRRO"),
					resultSet.getDate("REFERERE"), resultSet.getString("TMRNOMBRE"), resultSet.getDate("REFEPRRR"),
					resultSet.getDate("REFERERR"), resultSet.getString("OSNOMBRERR"),
					resultSet.getString("TTRNOMBRERR"), resultSet.getDate("REFENRRR"),
					resultSet.getBigDecimal("RECAMRRR"), resultSet.getDate("REFECEDE"),
					resultSet.getString("TTRNOMBRERCA"), resultSet.getString("TTRNOMBRERCAEU"),
					resultSet.getDate("REFEINRC"), resultSet.getDate("REFENORC"), resultSet.getDate("REFERSET"),
					resultSet.getDate("REFESERC"), resultSet.getBigDecimal("RECAMURC"), resultSet.getString("REINRETS"),
					resultSet.getDate("REFEPOCS"), resultSet.getString("ESCODIGO"));

			expedienKgest.setRefenrro(resultSet.getDate("REFENRRO"));
			expedienKgest.setRefenrr1(resultSet.getDate("REFENRR1"));
			return expedienKgest;
		}
	};

	private RowMapper<ExpedienKgest> rwMapPronuncActKgest = new RowMapper<ExpedienKgest>() {
		public ExpedienKgest mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new ExpedienKgest(resultSet.getString("ACCOOR"), resultSet.getBigDecimal("ATNROR"),
					resultSet.getBigDecimal("ACNRAN"), resultSet.getString("ACNROR"), resultSet.getString("ATNOPRSE"),
					resultSet.getString("AICOTTI"), resultSet.getString("TTINOCO"));
		}
	};

	private RowMapper<ExpedienKgest> rwMapPronuncReclKgest = new RowMapper<ExpedienKgest>() {
		public ExpedienKgest mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new ExpedienKgest(resultSet.getString("DECOOR"), resultSet.getBigDecimal("DENROR"),
					resultSet.getBigDecimal("DENRAN"), resultSet.getString("HDNROR"), resultSet.getString("HICOTTI"),
					resultSet.getString("TTINOCO"));
		}
	};

	private RowMapper<ExpedienKgest> rwMapPronuncOtrasKgest = new RowMapper<ExpedienKgest>() {
		public ExpedienKgest mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			ExpedienKgest expedienKgest = new ExpedienKgest();
			expedienKgest.setEicodigo(resultSet.getString("EICODIGO"));
			expedienKgest.setEicotti(resultSet.getString("EICOTTI"));
			expedienKgest.setTtinombre(resultSet.getString("TTINOMBRE"));
			expedienKgest.setEicottp(resultSet.getString("EICOTTP"));
			return expedienKgest;
		}
	};

	private RowMapper<Expedien> rwMapBusqueda = new RowMapper<Expedien>() {
		public Expedien mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Sanexp sanexp = new Sanexp(resultSet.getString("EXCODIGO"), null, null, resultSet.getString("EXDESCES"),
					resultSet.getString("EXDESCEU"), resultSet.getDate("EXFECPREVFIN"), resultSet.getDate("EXFECFIN"),
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null);
			Saninterv saninterv = new Saninterv(resultSet.getBigDecimal("UAIDINTERV"), resultSet.getString("UANOMBRE"),
					resultSet.getString("NOMBRE_MUNICIPIO"));

			return new Expedien(resultSet.getString("EXCODIGO"),
					resultSet.getString("EXCOOR") + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ resultSet.getBigDecimal("EXNROR") + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ resultSet.getBigDecimal("EXNRAN"),
					resultSet.getDate("EXFERE"), sanexp, saninterv, resultSet.getString("EXCOOR"),
					resultSet.getBigDecimal("EXNRAN"), resultSet.getBigDecimal("EXNROR"),
					resultSet.getString("EXCOIT"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Pagination
	 * @return Expedien
	 */
	public Expedien add(Expedien expedien) {
		String query = "INSERT INTO EXPEDIEN (EXCODIGO, EXCOOR, EXNRAN, EXNROR, EXFERE, EXCOIT, EXCOES, EXFEACIN, EXFEEMCA, EXFEPLCA, EXFPNOPC, EXFEDE, EXFECOAL, EXFENOPR, EXFEPUPR, EXCOOSPR, EXFEALPR, EXFEEL, EXFERES, EXFENORE, EXFEPURE, EXCOOSRE, EXCOTTR, EXCAMURE, EXFETA, EXCOTSA, EXFECROI, EXFEAR, EXCOORIE, EXINRE, EXINCOCO, EXINEXVA, EXFECIRC, EXFENOAI, EXFECOLM, EXNUINLM, EXFEINMU, EXFEAVMU, EXFEIMCD, EXFECEDE, EXCOPS, EXCOSE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, expedien.getExcodigo(), expedien.getExcoor(), expedien.getExnran(),
				expedien.getExnror(), expedien.getExfere(), expedien.getExcoit(), expedien.getExcoes(),
				expedien.getExfeacin(), expedien.getExfeemca(), expedien.getExfeplca(), expedien.getExfpnopc(),
				expedien.getExfede(), expedien.getExfecoal(), expedien.getExfenopr(), expedien.getExfepupr(),
				expedien.getExcoospr(), expedien.getExfealpr(), expedien.getExfeel(), expedien.getExferes(),
				expedien.getExfenore(), expedien.getExfepure(), expedien.getExcoosre(), expedien.getExcottr(),
				expedien.getExcamure(), expedien.getExfeta(), expedien.getExcotsa(), expedien.getExfecroi(),
				expedien.getExfear(), expedien.getExcoorie(), expedien.getExinre(), expedien.getExincoco(),
				expedien.getExinexva(), expedien.getExfecirc(), expedien.getExfenoai(), expedien.getExfecolm(),
				expedien.getExnuinlm(), expedien.getExfeinmu(), expedien.getExfeavmu(), expedien.getExfeimcd(),
				expedien.getExfecede(), expedien.getExcops(), expedien.getExcose());
		return expedien;
	}

	/**
	 * Updates a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Pagination
	 * @return Expedien
	 */
	public Expedien update(Expedien expedien) {
		String query = "UPDATE EXPEDIEN SET EXCOOR=?, EXNRAN=?, EXNROR=?, EXFERE=?, EXCOIT=?, EXCOES=?, EXFEACIN=?, EXFEEMCA=?, EXFEPLCA=?, EXFPNOPC=?, EXFEDE=?, EXFECOAL=?, EXFENOPR=?, EXFEPUPR=?, EXCOOSPR=?, EXFEALPR=?, EXFEEL=?, EXFERES=?, EXFENORE=?, EXFEPURE=?, EXCOOSRE=?, EXCOTTR=?, EXCAMURE=?, EXFETA=?, EXCOTSA=?, EXFECROI=?, EXFEAR=?, EXCOORIE=?, EXINRE=?, EXINCOCO=?, EXINEXVA=?, EXFECIRC=?, EXFENOAI=?, EXFECOLM=?, EXNUINLM=?, EXFEINMU=?, EXFEAVMU=?, EXFEIMCD=?, EXFECEDE=?, EXCOPS=?, EXCOSE=? WHERE EXCODIGO=?";
		this.jdbcTemplate.update(query, expedien.getExcoor(), expedien.getExnran(), expedien.getExnror(),
				expedien.getExfere(), expedien.getExcoit(), expedien.getExcoes(), expedien.getExfeacin(),
				expedien.getExfeemca(), expedien.getExfeplca(), expedien.getExfpnopc(), expedien.getExfede(),
				expedien.getExfecoal(), expedien.getExfenopr(), expedien.getExfepupr(), expedien.getExcoospr(),
				expedien.getExfealpr(), expedien.getExfeel(), expedien.getExferes(), expedien.getExfenore(),
				expedien.getExfepure(), expedien.getExcoosre(), expedien.getExcottr(), expedien.getExcamure(),
				expedien.getExfeta(), expedien.getExcotsa(), expedien.getExfecroi(), expedien.getExfear(),
				expedien.getExcoorie(), expedien.getExinre(), expedien.getExincoco(), expedien.getExinexva(),
				expedien.getExfecirc(), expedien.getExfenoai(), expedien.getExfecolm(), expedien.getExnuinlm(),
				expedien.getExfeinmu(), expedien.getExfeavmu(), expedien.getExfeimcd(), expedien.getExfecede(),
				expedien.getExcops(), expedien.getExcose(), expedien.getExcodigo());
		return expedien;
	}

	/**
	 * Updates a single row in the Expedien table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno, String escodigoAfusionar) {
		String query = "UPDATE EXPEDIEN SET EXCOES=? WHERE EXCOES=?";
		this.jdbcTemplate.update(query, escodigoBueno, escodigoAfusionar);
	}

	/**
	 * Finds a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Pagination
	 * @return Expedien
	 */
	@Transactional(readOnly = true)
	public Expedien find(Expedien expedien) {
		String query = "SELECT t1.EXCODIGO EXCODIGO, t1.EXCOOR EXCOOR, t1.EXNRAN EXNRAN, t1.EXNROR EXNROR, t1.EXFERE EXFERE, t1.EXCOIT EXCOIT, t1.EXCOES EXCOES, t1.EXFEACIN EXFEACIN, t1.EXFEEMCA EXFEEMCA, t1.EXFEPLCA EXFEPLCA, t1.EXFPNOPC EXFPNOPC, t1.EXFEDE EXFEDE, t1.EXFECOAL EXFECOAL, t1.EXFENOPR EXFENOPR, t1.EXFEPUPR EXFEPUPR, t1.EXCOOSPR EXCOOSPR, t1.EXFEALPR EXFEALPR, t1.EXFEEL EXFEEL, t1.EXFERES EXFERES, t1.EXFENORE EXFENORE, t1.EXFEPURE EXFEPURE, t1.EXCOOSRE EXCOOSRE, t1.EXCOTTR EXCOTTR, t1.EXCAMURE EXCAMURE, t1.EXFETA EXFETA, t1.EXCOTSA EXCOTSA, t1.EXFECROI EXFECROI, t1.EXFEAR EXFEAR, t1.EXCOORIE EXCOORIE, t1.EXINRE EXINRE, t1.EXINCOCO EXINCOCO, t1.EXINEXVA EXINEXVA, t1.EXFECIRC EXFECIRC, t1.EXFENOAI EXFENOAI, t1.EXFECOLM EXFECOLM, t1.EXNUINLM EXNUINLM, t1.EXFEINMU EXFEINMU, t1.EXFEAVMU EXFEAVMU, t1.EXFEIMCD EXFEIMCD, t1.EXFECEDE EXFECEDE, t1.EXCOPS EXCOPS, t1.EXCOSE EXCOSE, t2.EXCODIGO SANEXPEXCODIGO, t2.EXFOLDERID SANEXPEXFOLDERID, t2.EXDESCES SANEXPEXDESCES, t2.EXDESCEU SANEXPEXDESCEU, t2.EXFECPREVFIN SANEXPEXFECPREVFIN, t2.EXFECFIN SANEXPEXFECFIN, t2.EXCALIF SANEXPEXCALIF, t2.EXIMPORTE SANEXPEXIMPORTE, t2.EXRECURSO SANEXPEXRECURSO, t2.EXORDEN SANEXPEXORDEN, t2.EXTIPRES SANEXPEXTIPRES, t2.EXFECPRESCR SANEXPEXFECPRESCR, t2.EXCAJA1 SANEXPEXCAJA1, t2.EXCAJA2 SANEXPEXCAJA2, t2.EXMOCODIGO SANEXPEXMOCODIGO, t2.EXFCODIGO SANEXPEXFCODIGO, t2.EXMOCODIGOULT SANEXPEXMOCODIGOULT, t2.EXFECALTA SANEXPEXFECALTA, t2.EXFECMODIF SANEXPEXFECMODIF, t2.EXUSUALTA SANEXPEXUSUALTA, t2.EXUSUMODIF SANEXPEXUSUMODIF, t2.EXTRPOSCOD SANEXPEXTRPOSCOD, t2.EXTRENTIDAD SANEXPEXTRENTIDAD, t2.EXLIQESTADO SANEXPEXLIQESTADO, t2.EXLIQAPREMIO SANEXPEXLIQAPREMIO, t2.HDFECHD SANEXPHDFECHD, t2.HDTE SANEXPHDTE, t2.EXCOORACTUAL EXCOORACTUAL, t2.EXDESTNOTIFSANCIONADO EXDESTNOTIFSANCIONADO, t2.EXVERIFSANC EXVERIFSANC, t2.EXVERIFINCO EXVERIFINCO,t2.EXHDFORMANOTIFORIGEN EXHDFORMANOTIFORIGEN, t3.fcodigo fasefcodigo, t3.fnombre fasefnombre, t3.fnombree fasefnombree, /*t4.TROBSERVES santramexpTROBSERVES,*/ T5.PSCODIGO productoPSCODIGO, T5.PSNOMBRE productoPSNOMBRE, T5.PSNOMBREE productoPSNOMBREE, T6.TIRCODIGO motivoTIRCODIGO, T6.TIRNOMBRE motivoTIRNOMBRE, T6.TIRNOMBREE motivoTIRNOMBREE, t2.EXIDPARTICIPACIONSANCIONADO, t2.EXFECPROPRESO SANEXPEXFECPROPRESO "
				+ "FROM EXPEDIEN t1 , SANEXP t2, FASE t3, SANTRAMEXP t4, PRODUCTO t5, MOTIVO T6 "
				+ "WHERE t1.EXCODIGO = ? AND t1.EXCODIGO= t2.EXCODIGO(+) AND t2.exfcodigo = t3.fcodigo(+) AND t2.extrposcod = t4.TRID(+) AND T1.EXCOPS = T5.PSCODIGO(+) AND T2.HDCOTIR = T6.TIRCODIGO(+) ";

		List<Expedien> expedienList = this.jdbcTemplate.query(query, this.rwMapConFase, expedien.getExcodigo());
		return (Expedien) DataAccessUtils.uniqueResult(expedienList);
	}

	/**
	 * Finds a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Pagination
	 * @return Expedien
	 */
	@Transactional(readOnly = true)
	public Expedien findSancionByNumeroExpediente(Expedien expedien) {
		String query = "SELECT t1.EXCODIGO EXCODIGO, t1.EXCOOR EXCOOR, t1.EXNRAN EXNRAN, t1.EXNROR EXNROR, t1.EXFERE EXFERE, t1.EXCOIT EXCOIT, t1.EXCOES EXCOES, t1.EXFEACIN EXFEACIN, t1.EXFEEMCA EXFEEMCA, t1.EXFEPLCA EXFEPLCA, t1.EXFPNOPC EXFPNOPC, t1.EXFEDE EXFEDE, t1.EXFECOAL EXFECOAL, t1.EXFENOPR EXFENOPR, t1.EXFEPUPR EXFEPUPR, t1.EXCOOSPR EXCOOSPR, t1.EXFEALPR EXFEALPR, t1.EXFEEL EXFEEL, t1.EXFERES EXFERES, t1.EXFENORE EXFENORE, t1.EXFEPURE EXFEPURE, t1.EXCOOSRE EXCOOSRE, t1.EXCOTTR EXCOTTR, t1.EXCAMURE EXCAMURE, t1.EXFETA EXFETA, t1.EXCOTSA EXCOTSA, t1.EXFECROI EXFECROI, t1.EXFEAR EXFEAR, t1.EXCOORIE EXCOORIE, t1.EXINRE EXINRE, t1.EXINCOCO EXINCOCO, t1.EXINEXVA EXINEXVA, t1.EXFECIRC EXFECIRC, t1.EXFENOAI EXFENOAI, t1.EXFECOLM EXFECOLM, t1.EXNUINLM EXNUINLM, t1.EXFEINMU EXFEINMU, t1.EXFEAVMU EXFEAVMU, t1.EXFEIMCD EXFEIMCD, t1.EXFECEDE EXFECEDE, t1.EXCOPS EXCOPS, t1.EXCOSE EXCOSE, t2.EXCODIGO SANEXPEXCODIGO, t2.EXFOLDERID SANEXPEXFOLDERID, t2.EXDESCES SANEXPEXDESCES, t2.EXDESCEU SANEXPEXDESCEU, t2.EXFECPREVFIN SANEXPEXFECPREVFIN, t2.EXFECFIN SANEXPEXFECFIN, t2.EXCALIF SANEXPEXCALIF, t2.EXIMPORTE SANEXPEXIMPORTE, t2.EXRECURSO SANEXPEXRECURSO, t2.EXORDEN SANEXPEXORDEN, t2.EXTIPRES SANEXPEXTIPRES, t2.EXFECPRESCR SANEXPEXFECPRESCR, t2.EXCAJA1 SANEXPEXCAJA1, t2.EXCAJA2 SANEXPEXCAJA2, t2.EXMOCODIGO SANEXPEXMOCODIGO, t2.EXFCODIGO SANEXPEXFCODIGO, t2.EXMOCODIGOULT SANEXPEXMOCODIGOULT, t2.EXFECALTA SANEXPEXFECALTA, t2.EXFECMODIF SANEXPEXFECMODIF, t2.EXUSUALTA SANEXPEXUSUALTA, t2.EXUSUMODIF SANEXPEXUSUMODIF, t2.EXTRPOSCOD SANEXPEXTRPOSCOD, t2.EXTRENTIDAD SANEXPEXTRENTIDAD, t2.EXLIQESTADO SANEXPEXLIQESTADO, t2.EXLIQAPREMIO SANEXPEXLIQAPREMIO, t2.HDFECHD SANEXPHDFECHD, t2.HDTE SANEXPHDTE, t2.EXCOORACTUAL EXCOORACTUAL, t2.EXDESTNOTIFSANCIONADO EXDESTNOTIFSANCIONADO, t2.EXVERIFSANC EXVERIFSANC, t2.EXVERIFINCO EXVERIFINCO,t2.EXHDFORMANOTIFORIGEN EXHDFORMANOTIFORIGEN, t3.fcodigo fasefcodigo, t3.fnombre fasefnombre, t3.fnombree fasefnombree,/* t4.TROBSERVES santramexpTROBSERVES,*/ T5.PSCODIGO productoPSCODIGO, T5.PSNOMBRE productoPSNOMBRE, T5.PSNOMBREE productoPSNOMBREE, T6.TIRCODIGO motivoTIRCODIGO, T6.TIRNOMBRE motivoTIRNOMBRE, T6.TIRNOMBREE motivoTIRNOMBREE, t2.EXIDPARTICIPACIONSANCIONADO, t2.EXFECPROPRESO SANEXPEXFECPROPRESO "
				+ "FROM EXPEDIEN t1 , SANEXP t2, FASE t3, SANTRAMEXP t4, PRODUCTO t5, MOTIVO T6   "
				+ "WHERE t1.EXCOOR = ? AND t1.EXNRAN = ? AND t1.EXNROR = ? AND t1.EXCODIGO= t2.EXCODIGO(+) AND t2.exfcodigo = t3.fcodigo(+) AND t2.extrposcod = t4.TRID(+) AND T1.EXCOPS = T5.PSCODIGO(+) AND T2.HDCOTIR = T6.TIRCODIGO(+)";

		List<Expedien> expedienList = this.jdbcTemplate.query(query, this.rwMapConFase, expedien.getExcoor(),
				expedien.getExnran(), expedien.getExnror());
		return (Expedien) DataAccessUtils.uniqueResult(expedienList);
	}

	/*
	 * private RowMapper<ExpedienKgest> rwMapFull = new
	 * RowMapper<ExpedienKgest>() { public ExpedienKgest mapRow(ResultSet
	 * resultSet, int rowNum) throws SQLException { Establecimiento
	 * establecimiento = new Establecimiento( resultSet.getString("EXCOES"),
	 * resultSet.getString("ESNOMBRE"), resultSet.getString("ESNIF"), null,
	 * resultSet.getString("ESNOCO"), resultSet.getString("ESNODIR"), null,
	 * null, null, null, null, null, null, null, null, null, null, null, null,
	 * null, null, null, null, null, null, null, null, null, null, null, null,
	 * null, null, null, null, null, null, null, null, null, null, null, null,
	 * null, null, null, resultSet.getString("ESNOMBRE_MUNICIPIO"), null,
	 * resultSet.getString("ESNOMBRE_LOCALIDAD"), null, null, null, null, null,
	 * null, null, null, null, null); // Instructor instructor = null; // , , ,
	 * , , , // , , , , , , // , , , , , , // , , , , , , // Recurso recurso =
	 * new Recurso(resultSet.getString("EXCODIGO"),
	 * resultSet.getDate("REFEREOR"), resultSet.getDate("REFERENP"),
	 * resultSet.getDate("REFEPRRO"), resultSet.getDate("REFENRO1"),
	 * resultSet.getDate("REFERERO"), resultSet.getString("RECOOS"), null,
	 * resultSet.getString("RECOTTRO"), resultSet.getBigDecimal("RECAMRRO"),
	 * resultSet.getDate("REFERERE"), resultSet.getString("RECOMORR"),
	 * resultSet.getDate("REFEPRRR"), null, resultSet.getDate("REFERERR"),
	 * resultSet.getString("RECOOSRR"), resultSet.getDate("REFENRRR"),
	 * resultSet.getString("RECOTTRR"), resultSet.getBigDecimal("RECAMRRR"),
	 * null, null, null, null, null, resultSet.getDate("REFECEDE"), null, null,
	 * resultSet.getString("RECOTRRC"), resultSet.getDate("REFEINRC"), null,
	 * resultSet.getDate("REFERSET"), resultSet.getDate("REFESERC"),
	 * resultSet.getBigDecimal("RECAMURC"), null, null,
	 * resultSet.getString("REINRETS"), null, null, null); return new
	 * ExpedienKgest(resultSet.getString("EXCODIGO"),
	 * resultSet.getString("EXCOOR"), resultSet.getBigDecimal("EXNRAN"),
	 * resultSet.getBigDecimal("EXNROR"), resultSet.getDate("EXFERE"),
	 * resultSet.getString("EXCOIT"), resultSet.getString("EXCOES"),
	 * resultSet.getDate("EXFEACIN"), resultSet.getDate("EXFEEMCA"),
	 * resultSet.getDate("EXFEPLCA"), resultSet.getDate("EXFPNOPC"),
	 * resultSet.getDate("EXFEDE"), resultSet.getDate("EXFECOAL"),
	 * resultSet.getDate("EXFENOPR"), resultSet.getDate("EXFEPUPR"),
	 * resultSet.getString("EXCOOSPR"), resultSet.getDate("EXFEALPR"),
	 * resultSet.getDate("EXFEEL"), resultSet.getDate("EXFERES"),
	 * resultSet.getDate("EXFENORE"), resultSet.getDate("EXFEPURE"),
	 * resultSet.getString("EXCOOSRE"), resultSet.getString("EXCOTTR"),
	 * resultSet.getBigDecimal("EXCAMURE"), resultSet.getDate("EXFETA"),
	 * resultSet.getString("EXCOTSA"), resultSet.getDate("EXFECROI"),
	 * resultSet.getDate("EXFEAR"), resultSet.getString("EXCOORIE"),
	 * resultSet.getString("EXINRE"), resultSet.getString("EXINCOCO"),
	 * resultSet.getString("EXINEXVA"), resultSet.getDate("EXFECIRC"),
	 * resultSet.getDate("EXFENOAI"), resultSet.getDate("EXFECOLM"),
	 * resultSet.getString("EXNUINLM"), resultSet.getDate("EXFEINMU"),
	 * resultSet.getDate("EXFEAVMU"), resultSet.getDate("EXFEIMCD"),
	 * resultSet.getDate("EXFECEDE"), resultSet.getString("EXCOPS"),
	 * resultSet.getString("EXCOSE"), new
	 * Sanexp(resultSet.getString("SanexpEXCODIGO"), resultSet
	 * .getString("SanexpEXFOLDERID"), resultSet .getString("SanexpEXDESCES"),
	 * resultSet .getString("SanexpEXDESCEU"), resultSet
	 * .getDate("SanexpEXFECPREVFIN"), resultSet .getDate("SanexpEXFECFIN"),
	 * resultSet .getString("SanexpEXCALIF"), resultSet
	 * .getString("SanexpEXIMPORTE"), resultSet .getString("SanexpEXRECURSO"),
	 * resultSet .getString("SanexpEXORDEN"), resultSet
	 * .getString("SanexpEXTIPRES"), resultSet .getString("SanexpEXCAJA1"),
	 * resultSet .getString("SanexpEXCAJA2"), resultSet
	 * .getString("SanexpEXMOCODIGO"), new Fase(resultSet
	 * .getString("fasefcodigo"), resultSet .getString("fasefnombre"), resultSet
	 * .getString("fasefnombree"), null, null), resultSet
	 * .getString("SanexpEXMOCODIGOULT"), resultSet .getDate("SanexpEXFECALTA"),
	 * resultSet .getDate("SanexpEXFECMODIF"), resultSet
	 * .getString("SanexpEXUSUALTA"), resultSet .getString("SanexpEXUSUMODIF"),
	 * resultSet .getString("SanexpEXLIQESTADO"), resultSet
	 * .getString("SanexpEXLIQAPREMIO"), new Santramexp(
	 * resultSet.getBigDecimal("SanexpEXTRPOSCOD"),
	 * resultSet.getString("santramexpTROBSERVES"))), establecimiento, recurso);
	 * } };
	 */

	/**
	 * Finds a single row in the ExpedienKgest table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return ExpedienKgest
	 */

	@Transactional(readOnly = true)
	public ExpedienKgest findKgest(ExpedienKgest expedien) {
		String query = "SELECT t1.EXCODIGO EXCODIGO, t1.EXCOOR EXCOOR, t1.EXNRAN EXNRAN, t1.EXNROR EXNROR, t1.EXFERE EXFERE, t1.EXCOIT EXCOIT, t1.EXCOES EXCOES, t1.EXFEACIN EXFEACIN, t1.EXFEEMCA EXFEEMCA, t1.EXFEPLCA EXFEPLCA, t1.EXFPNOPC EXFPNOPC, t1.EXFEDE EXFEDE, t1.EXFECOAL EXFECOAL, t1.EXFENOPR EXFENOPR, t1.EXFEPUPR EXFEPUPR, t1.EXCOOSPR EXCOOSPR, t1.EXFEALPR EXFEALPR, t1.EXFEEL EXFEEL, t1.EXFERES EXFERES, t1.EXFENORE EXFENORE, t1.EXFEPURE EXFEPURE, t1.EXCOOSRE EXCOOSRE, t1.EXCOTTR EXCOTTR, t1.EXCAMURE EXCAMURE, t1.EXFETA EXFETA, t1.EXCOTSA EXCOTSA, t1.EXFECROI EXFECROI, t1.EXFEAR EXFEAR, t1.EXCOORIE EXCOORIE, t1.EXINRE EXINRE, t1.EXINCOCO EXINCOCO, t1.EXINEXVA EXINEXVA, t1.EXFECIRC EXFECIRC, t1.EXFENOAI EXFENOAI, t1.EXFECOLM EXFECOLM, t1.EXNUINLM EXNUINLM, t1.EXFEINMU EXFEINMU, t1.EXFEAVMU EXFEAVMU, t1.EXFEIMCD EXFEIMCD, t1.EXFECEDE EXFECEDE, t1.EXCOPS EXCOPS, t1.EXCOSE EXCOSE, t2.TTRNOMBRE TTRNOMBRE, t2.TTRNOMBREEU TTRNOMBREEU, t3.TSANOMBRE TSANOMBRE,"
				+ "(SELECT OSNOMBRE FROM ORGANISMO_SANCIONADOR WHERE OSCODIGO = t1.EXCOOSPR) OSNOMBREPR, (SELECT OSNOMBRE FROM ORGANISMO_SANCIONADOR WHERE OSCODIGO = t1.EXCOOSRE) OSNOMBRERE,"
				+ "(SELECT OSNOMBRE FROM ORGANISMO_SANCIONADOR WHERE OSCODIGO = t7.RECOOS) OSNOMBRERO, (SELECT OSNOMBRE FROM ORGANISMO_SANCIONADOR WHERE OSCODIGO = t7.RECOOSRR) OSNOMBRERR,"
				+ "(SELECT TTRNOMBRE FROM TCTIPRES WHERE TTRCODIGO = t7.RECOTTRR) TTRNOMBRERR, (SELECT TTRNOMBRE FROM TCTIPRES WHERE TTRCODIGO = t7.RECOTIFA) TTRNOMBRERCA, (SELECT TTRNOMBREEU FROM TCTIPRES WHERE TTRCODIGO = t7.RECOTIFA) TTRNOMBRERCAEU,"
				+ "t5.ITNOMBRE  ITNOMBRE, t6.ESNOMBRE ESNOMBRE, T6.ESCODIGO ESCODIGO, t6.ESNIF ESNIF, t6.ESNOCO ESNOCO, t6.ESNODIR ESNODIR, t6.ESNOMBRE_MUNICIPIO ESNOMBRE_MUNICIPIO, t6.ESNOMBRE_LOCALIDAD ESNOMBRE_LOCALIDAD, t7.REFEREOR REFEREOR, t7.REFERENP REFERENP, t7.REFEPRRO REFEPRRO, t7.REFERERO REFERERO, t7.RECOOS RECOOS, t7.RECOTTRO RECOTTRO, t7.REFENRO1 REFENRO1, t7.RECAMRRO RECAMRRO, t7.REFERERE REFERERE, t7.RECOMORR RECOMORR, t7.REFEPRRR REFEPRRR, t7.REFERERR REFERERR, t7.RECOOSRR RECOOSRR, t7.RECOTTRR RECOTTRR, t7.REFENRRR REFENRRR, t7.REFECEDE REFECEDE, t7.RECAMRRR RECAMRRR, t7.REFERSET REFERSET, t7.REFEINRC REFEINRC, t7.REFENORC REFENORC, t7.REFESERC REFESERC, t7.RECOTRRC RECOTRRC, t7.RECAMURC RECAMURC, t7.REINRETS REINRETS, t7.REFEPOCS REFEPOCS, t7.REFENRRO REFENRRO, t7.REFENRR1 REFENRR1, t4.TMRNOMBRE TMRNOMBRE, t8.TARNOMBRE TARNOMBRE "
				+ "FROM EXPEDIEN t1, TCTIPRES t2, SANCION_ACCESORIA t3, MOTIVO_RECURSO t4, INSTRUCTOR t5, ESTABLECIMIENTO t6, RECURSO t7, TIPO_ACUERDO_RECURSO t8 "
				+ "WHERE t1.EXCODIGO = ? AND t1.EXCOTTR = T2.TTRCODIGO(+) AND t1.EXCOTSA = t3.TSACODIGO(+) AND t1.EXCOIT = t5.ITCODIGO(+) AND t1.EXCOES = T6.ESCODIGO(+) AND t1.EXCODIGO = t7.RECOEX AND t7.RECOMORR = t4.TMRCODIGO(+) AND t7.RECOTTRO = t8.TARCODIGO(+)";

		List<ExpedienKgest> expedienList = this.jdbcTemplate.query(query, this.rwMapKgest, expedien.getExcodigo());
		return (ExpedienKgest) DataAccessUtils.uniqueResult(expedienList);
	}

	/**
	 * Finds a single row in the ExpedienKgest table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return List
	 */

	@Transactional(readOnly = true)
	public List<ExpedienKgest> findPronunciamientoActKgest(ExpedienKgest expedien) {
		String query = "select t1.ACCOOR ACCOOR, t7.ATNROR ATNROR, t1.ACNRAN ACNRAN, t1.ACNROR ACNROR, t7.ATNOPRSE ATNOPRSE, t4.AICOTTI AICOTTI, t66.TTINOCO TTINOCO "
				+ "from ACTA t1, ACTUACION T7, ACTA_INFRACCION t4, TIP_REQ_NORMATIVO t66, ACTUAC_INFR_EXPDTE t5 "
				+ "where t1.ACCODIGO = t7.ATCOAC and t7.ATCODIGO = t4.AICOAT and t4.AICOTTI = t66.TTICODIGO and t5.AXCOEX = ? and t5.AXCOAI = t4.AICODIGO";

		return (List<ExpedienKgest>) this.jdbcTemplate.query(query.toString(), this.rwMapPronuncActKgest,
				expedien.getExcodigo());
	}

	/**
	 * @param expedien
	 *            ExpedienKgest
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findPronunciamientoActKgestCount(ExpedienKgest expedien) {
		String query = "select COUNT(1) from ACTA t1, ACTUACION T7, ACTA_INFRACCION t4, TIP_REQ_NORMATIVO t66, ACTUAC_INFR_EXPDTE t5 "
				+ "where t1.ACCODIGO = t7.ATCOAC and t7.ATCODIGO = t4.AICOAT and t4.AICOTTI = t66.TTICODIGO and t5.AXCOEX = ? and t5.AXCOAI = t4.AICODIGO";

		List<Object> params = new ArrayList<Object>();
		params.add(expedien.getExcodigo());
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a single row in the ExpedienKgest table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return List
	 */

	@Transactional(readOnly = true)
	public List<ExpedienKgest> findPronunciamientoReclKgest(ExpedienKgest expedien) {
		String query = "select distinct t14.DECOOR DECOOR, t14.DENROR DENROR, t14.DENRAN DENRAN, t24.HDNROR HDNROR, t27.HICOTTI HICOTTI, t66.TTINOCO TTINOCO "
				+ "from DECISION_HECHO_EXPDTE t26, DECISION_HECHO t25, HECHO_DENUNCIADO t24, DENUNCIA t14, INFRACC_HECHO_DEN_EXP_SANC t28, INFRACC_HECHO_DEN t27, TIP_REQ_NORMATIVO t66 "
				+ "where t26.CXCOEX = ? and t26.CXCOHC = t25.HCCODIGO and t25.HCCOHD = t24.HDCODIGO and t24.HDCODE = t14.DECODIGO and t28.DXCOEX = t26.CXCOEX and t28.DXCOHI = t27.HICODIGO and t27.HICOTTI = t66.TTICODIGO";

		return (List<ExpedienKgest>) this.jdbcTemplate.query(query.toString(), this.rwMapPronuncReclKgest,
				expedien.getExcodigo());
	}

	/**
	 * @param expedien
	 *            ExpedienKgest
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findPronunciamientoReclKgestCount(ExpedienKgest expedien) {
		String query = "SELECT COUNT (1) FROM (select t14.DECOOR,t14.DENROR,t14.DENRAN,t24.HDNROR,t27.HICOTTI,t66.TTINOCO from DECISION_HECHO_EXPDTE t26, DECISION_HECHO t25, HECHO_DENUNCIADO t24, DENUNCIA t14, INFRACC_HECHO_DEN_EXP_SANC t28, INFRACC_HECHO_DEN t27, TIP_REQ_NORMATIVO t66 "
				+ "where t26.CXCOEX = ? and t26.CXCOHC = t25.HCCODIGO and t25.HCCOHD = t24.HDCODIGO and t24.HDCODE = t14.DECODIGO and t28.DXCOEX = t26.CXCOEX and t28.DXCOHI = t27.HICODIGO and t27.HICOTTI = t66.TTICODIGO "
				+ "group by t14.DECOOR,t14.DENROR,t14.DENRAN,t24.HDNROR,t27.HICOTTI,t66.TTINOCO)";

		List<Object> params = new ArrayList<Object>();
		params.add(expedien.getExcodigo());
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a single row in the ExpedienKgest table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return List
	 */

	@Transactional(readOnly = true)
	public List<ExpedienKgest> findPronunciamientoOtrasKgest(ExpedienKgest expedien) {
		String query = "select t1.EICODIGO EICODIGO, t1.EICOTTI EICOTTI, t1.EICOTTP EICOTTP, t66.TTINOMBRE TTINOMBRE "
				+ "from EXPINF t1, TIP_REQ_NORMATIVO t66 " + "where t1.EICOEX=? AND t1.EICOTTI=t66.TTICODIGO ";

		return (List<ExpedienKgest>) this.jdbcTemplate.query(query.toString(), this.rwMapPronuncOtrasKgest,
				expedien.getExcodigo());
	}

	/**
	 * @param expedien
	 *            ExpedienKgest
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findPronunciamientoOtrasKgestCount(ExpedienKgest expedien) {
		String query = "select COUNT(1) from EXPINF t1, TIP_REQ_NORMATIVO t66 where t1.EICOEX=? AND t1.EICOTTI=t66.TTICODIGO ";

		List<Object> params = new ArrayList<Object>();
		params.add(expedien.getExcodigo());
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Removes a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Pagination
	 * @return
	 */
	public void remove(Expedien expedien) {
		String query = "DELETE FROM EXPEDIEN WHERE EXCODIGO=?";
		this.jdbcTemplate.update(query, expedien.getExcodigo());
	}

	/**
	 * Finds a List of rows in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Expedien> findAll(Expedien expedien, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.EXCODIGO EXCODIGO, t1.EXFERE EXFERE, t1.EXCOIT, t2.EXFECPREVFIN, t2.EXFECFIN, t2.EXDESCES, t2.EXDESCEU, t3.UANOMBRE, t3.UAIDINTERV, (SELECT DS_O FROM T17I.T17_MUNICIPIO WHERE T3.UAPROV_ID = PROVINCIA_ID AND t3.UAMUN_ID = ID) AS NOMBRE_MUNICIPIO, t1.EXCOOR EXCOOR , t1.EXNRAN EXNRAN, t1.EXNROR EXNROR, t2.EXCOORACTUAL EXCOORACTUAL ");
		query.append(" FROM EXPEDIEN t1 ,SANEXP t2, SANINTERV t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(expedien);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.EXCODIGO= t2.EXCODIGO(+) AND t1.EXCODIGO= t3.UAEXCODIGO(+) AND t3.UATIPOINTERV(+) = '"
						+ Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO + "' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Expedien>) this.jdbcTemplate.query(query.toString(), this.rwMapBusqueda, params.toArray());
	}

	/**
	 * Counts rows in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Expedien expedien) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM EXPEDIEN t1 , SANEXP t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(expedien);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.EXCODIGO= t2.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Expedien table using like.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Expedien> findAllLike(Expedien expedien, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.EXCODIGO expedienEXCODIGO,t1.EXCOOR EXCOOR,t1.EXNRAN EXNRAN,t1.EXNROR EXNROR,t1.EXFERE EXFERE,t1.EXCOIT EXCOIT,t1.EXCOES EXCOES,t1.EXFEACIN EXFEACIN,t1.EXFEEMCA EXFEEMCA,t1.EXFEPLCA EXFEPLCA,t1.EXFPNOPC EXFPNOPC,t1.EXFEDE EXFEDE,t1.EXFECOAL EXFECOAL,t1.EXFENOPR EXFENOPR,t1.EXFEPUPR EXFEPUPR,t1.EXCOOSPR EXCOOSPR,t1.EXFEALPR EXFEALPR,t1.EXFEEL EXFEEL,t1.EXFERES EXFERES,t1.EXFENORE EXFENORE,t1.EXFEPURE EXFEPURE,t1.EXCOOSRE EXCOOSRE,t1.EXCOTTR EXCOTTR,t1.EXCAMURE EXCAMURE,t1.EXFETA EXFETA,t1.EXCOTSA EXCOTSA,t1.EXFECROI EXFECROI,t1.EXFEAR EXFEAR,t1.EXCOORIE EXCOORIE,t1.EXINRE EXINRE,t1.EXINCOCO EXINCOCO,t1.EXINEXVA EXINEXVA,t1.EXFECIRC EXFECIRC,t1.EXFENOAI EXFENOAI,t1.EXFECOLM EXFECOLM,t1.EXNUINLM EXNUINLM,t1.EXFEINMU EXFEINMU,t1.EXFEAVMU EXFEAVMU,t1.EXFEIMCD EXFEIMCD,t1.EXFECEDE EXFECEDE,t1.EXCOPS EXCOPS,t1.EXCOSE EXCOSE,t2.EXCODIGO SANEXPEXCODIGO,t2.EXFOLDERID SANEXPEXFOLDERID,t2.EXDESCES SANEXPEXDESCES,t2.EXDESCEU SANEXPEXDESCEU,t2.EXFECPREVFIN SANEXPEXFECPREVFIN,t2.EXFECFIN SANEXPEXFECFIN,t2.EXCALIF SANEXPEXCALIF,t2.EXIMPORTE SANEXPEXIMPORTE,t2.EXRECURSO SANEXPEXRECURSO,t2.EXORDEN SANEXPEXORDEN,t2.EXTIPRES SANEXPEXTIPRES,t2.EXCAJA1 SANEXPEXCAJA1,t2.EXCAJA2 SANEXPEXCAJA2,t2.EXMOCODIGO SANEXPEXMOCODIGO,t2.EXFCODIGO SANEXPEXFCODIGO,t2.EXMOCODIGOULT SANEXPEXMOCODIGOULT,t2.EXFECALTA SANEXPEXFECALTA,t2.EXFECMODIF SANEXPEXFECMODIF,t2.EXUSUALTA SANEXPEXUSUALTA,t2.EXUSUMODIF SANEXPEXUSUMODIF,t2.EXTRPOSCOD SANEXPEXTRPOSCOD,t2.EXTRENTIDAD SANEXPEXTRENTIDAD,t2.EXCOORACTUAL EXCOORACTUAL,t2.EXDESTNOTIFSANCIONADO EXDESTNOTIFSANCIONADO, t2.EXVERIFSANC EXVERIFSANC, t2.EXVERIFINCO EXVERIFINCO ");
		query.append("FROM EXPEDIEN t1 ,SANEXP t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(expedien, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.EXCODIGO= t2.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Expedien>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Expedien table using like.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Expedien expedien, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM EXPEDIEN t1 ,SANEXP t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(expedien, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.EXCODIGO= t2.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Expedien entity
	 * 
	 * @param expedien
	 *            Expedien Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA
	private Map<String, ?> getWhereMap(Expedien expedien) {

		StringBuilder where = new StringBuilder(ExpedienDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (expedien != null && expedien.getExcodigo() != null) {
			where.append(" AND t1.EXCODIGO = ?");
			params.add(expedien.getExcodigo());
		}
		if (expedien != null && expedien.getExcoor() != null) {
			where.append(" AND t1.EXCOOR = ?");
			params.add(expedien.getExcoor());
		}
		if (expedien != null && expedien.getExnran() != null) {
			where.append(" AND t1.EXNRAN = ?");
			params.add(expedien.getExnran());
		}
		if (expedien != null && expedien.getExnror() != null) {
			where.append(" AND t1.EXNROR = ?");
			params.add(expedien.getExnror());
		}
		if (expedien != null && expedien.getExfere() != null) {
			where.append(" AND t1.EXFERE = ?");
			params.add(expedien.getExfere());
		}
		if (expedien != null && expedien.getExcoit() != null) {
			where.append(" AND t1.EXCOIT = ?");
			params.add(expedien.getExcoit());
		}
		if (expedien != null && expedien.getExcoes() != null) {
			where.append(" AND t1.EXCOES = ?");
			params.add(expedien.getExcoes());
		}
		if (expedien != null && expedien.getExfeacin() != null) {
			where.append(" AND t1.EXFEACIN = ?");
			params.add(expedien.getExfeacin());
		}
		if (expedien != null && expedien.getExfeemca() != null) {
			where.append(" AND t1.EXFEEMCA = ?");
			params.add(expedien.getExfeemca());
		}
		if (expedien != null && expedien.getExfeplca() != null) {
			where.append(" AND t1.EXFEPLCA = ?");
			params.add(expedien.getExfeplca());
		}
		if (expedien != null && expedien.getExfpnopc() != null) {
			where.append(" AND t1.EXFPNOPC = ?");
			params.add(expedien.getExfpnopc());
		}
		if (expedien != null && expedien.getExfede() != null) {
			where.append(" AND t1.EXFEDE = ?");
			params.add(expedien.getExfede());
		}
		if (expedien != null && expedien.getExfecoal() != null) {
			where.append(" AND t1.EXFECOAL = ?");
			params.add(expedien.getExfecoal());
		}
		if (expedien != null && expedien.getExfenopr() != null) {
			where.append(" AND t1.EXFENOPR = ?");
			params.add(expedien.getExfenopr());
		}
		if (expedien != null && expedien.getExfepupr() != null) {
			where.append(" AND t1.EXFEPUPR = ?");
			params.add(expedien.getExfepupr());
		}
		if (expedien != null && expedien.getExcoospr() != null) {
			where.append(" AND t1.EXCOOSPR = ?");
			params.add(expedien.getExcoospr());
		}
		if (expedien != null && expedien.getExfealpr() != null) {
			where.append(" AND t1.EXFEALPR = ?");
			params.add(expedien.getExfealpr());
		}
		if (expedien != null && expedien.getExfeel() != null) {
			where.append(" AND t1.EXFEEL = ?");
			params.add(expedien.getExfeel());
		}
		if (expedien != null && expedien.getExferes() != null) {
			where.append(" AND t1.EXFERES = ?");
			params.add(expedien.getExferes());
		}
		if (expedien != null && expedien.getExfenore() != null) {
			where.append(" AND t1.EXFENORE = ?");
			params.add(expedien.getExfenore());
		}
		if (expedien != null && expedien.getExfepure() != null) {
			where.append(" AND t1.EXFEPURE = ?");
			params.add(expedien.getExfepure());
		}
		if (expedien != null && expedien.getExcoosre() != null) {
			where.append(" AND t1.EXCOOSRE = ?");
			params.add(expedien.getExcoosre());
		}
		if (expedien != null && expedien.getExcottr() != null) {
			where.append(" AND t1.EXCOTTR = ?");
			params.add(expedien.getExcottr());
		}
		if (expedien != null && expedien.getExcamure() != null) {
			where.append(" AND t1.EXCAMURE = ?");
			params.add(expedien.getExcamure());
		}
		if (expedien != null && expedien.getExfeta() != null) {
			where.append(" AND t1.EXFETA = ?");
			params.add(expedien.getExfeta());
		}
		if (expedien != null && expedien.getExcotsa() != null) {
			where.append(" AND t1.EXCOTSA = ?");
			params.add(expedien.getExcotsa());
		}
		if (expedien != null && expedien.getExfecroi() != null) {
			where.append(" AND t1.EXFECROI = ?");
			params.add(expedien.getExfecroi());
		}
		if (expedien != null && expedien.getExfear() != null) {
			where.append(" AND t1.EXFEAR = ?");
			params.add(expedien.getExfear());
		}
		if (expedien != null && expedien.getExcoorie() != null) {
			where.append(" AND t1.EXCOORIE = ?");
			params.add(expedien.getExcoorie());
		}
		if (expedien != null && expedien.getExinre() != null) {
			where.append(" AND t1.EXINRE = ?");
			params.add(expedien.getExinre());
		}
		if (expedien != null && expedien.getExincoco() != null) {
			where.append(" AND t1.EXINCOCO = ?");
			params.add(expedien.getExincoco());
		}
		if (expedien != null && expedien.getExinexva() != null) {
			where.append(" AND t1.EXINEXVA = ?");
			params.add(expedien.getExinexva());
		}
		if (expedien != null && expedien.getExfecirc() != null) {
			where.append(" AND t1.EXFECIRC = ?");
			params.add(expedien.getExfecirc());
		}
		if (expedien != null && expedien.getExfenoai() != null) {
			where.append(" AND t1.EXFENOAI = ?");
			params.add(expedien.getExfenoai());
		}
		if (expedien != null && expedien.getExfecolm() != null) {
			where.append(" AND t1.EXFECOLM = ?");
			params.add(expedien.getExfecolm());
		}
		if (expedien != null && expedien.getExnuinlm() != null) {
			where.append(" AND t1.EXNUINLM = ?");
			params.add(expedien.getExnuinlm());
		}
		if (expedien != null && expedien.getExfeinmu() != null) {
			where.append(" AND t1.EXFEINMU = ?");
			params.add(expedien.getExfeinmu());
		}
		if (expedien != null && expedien.getExfeavmu() != null) {
			where.append(" AND t1.EXFEAVMU = ?");
			params.add(expedien.getExfeavmu());
		}
		if (expedien != null && expedien.getExfeimcd() != null) {
			where.append(" AND t1.EXFEIMCD = ?");
			params.add(expedien.getExfeimcd());
		}
		if (expedien != null && expedien.getExfecede() != null) {
			where.append(" AND t1.EXFECEDE = ?");
			params.add(expedien.getExfecede());
		}
		if (expedien != null && expedien.getExcops() != null) {
			where.append(" AND t1.EXCOPS = ?");
			params.add(expedien.getExcops());
		}
		if (expedien != null && expedien.getExcose() != null) {
			where.append(" AND t1.EXCOSE = ?");
			params.add(expedien.getExcose());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(expedien.getSanexp().getExcodigo());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getSantramexp() != null
				&& expedien.getSanexp().getSantramexp().getTrid() != null) {
			where.append(" AND t2.EXTRPOSCOD = ?");
			params.add(expedien.getSanexp().getSantramexp().getTrid());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExfolderid() != null) {
			where.append(" AND t2.EXFOLDERID = ?");
			params.add(expedien.getSanexp().getExfolderid());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExdesces() != null) {
			where.append(" AND t2.EXDESCES = ?");
			params.add(expedien.getSanexp().getExdesces());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExdesceu() != null) {
			where.append(" AND t2.EXDESCEU = ?");
			params.add(expedien.getSanexp().getExdesceu());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExfecprevfin() != null) {
			where.append(" AND t2.EXFECPREVFIN = ?");
			params.add(expedien.getSanexp().getExfecprevfin());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExfecfin() != null) {
			where.append(" AND t2.EXFECFIN = ?");
			params.add(expedien.getSanexp().getExfecfin());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExcalif() != null) {
			where.append(" AND t2.EXCALIF = ?");
			params.add(expedien.getSanexp().getExcalif());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getEximporte() != null) {
			where.append(" AND t2.EXIMPORTE = ?");
			params.add(expedien.getSanexp().getEximporte());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExrecurso() != null) {
			where.append(" AND t2.EXRECURSO = ?");
			params.add(expedien.getSanexp().getExrecurso());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExorden() != null) {
			where.append(" AND t2.EXORDEN = ?");
			params.add(expedien.getSanexp().getExorden());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExtipres() != null) {
			where.append(" AND t2.EXTIPRES = ?");
			params.add(expedien.getSanexp().getExtipres());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExcaja1() != null) {
			where.append(" AND t2.EXCAJA1 = ?");
			params.add(expedien.getSanexp().getExcaja1());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExcaja2() != null) {
			where.append(" AND t2.EXCAJA2 = ?");
			params.add(expedien.getSanexp().getExcaja2());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExmocodigo() != null) {
			where.append(" AND t2.EXMOCODIGO = ?");
			params.add(expedien.getSanexp().getExmocodigo());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getFase() != null
				&& expedien.getSanexp().getFase().getFcodigo() != null) {
			where.append(" AND t2.EXFCODIGO = ?");
			params.add(expedien.getSanexp().getFase().getFcodigo());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExmocodigoult() != null) {
			where.append(" AND t2.EXMOCODIGOULT = ?");
			params.add(expedien.getSanexp().getExmocodigoult());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExfecalta() != null) {
			where.append(" AND t2.EXFECALTA = ?");
			params.add(expedien.getSanexp().getExfecalta());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExfecmodif() != null) {
			where.append(" AND t2.EXFECMODIF = ?");
			params.add(expedien.getSanexp().getExfecmodif());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExusualta() != null) {
			where.append(" AND t2.EXUSUALTA = ?");
			params.add(expedien.getSanexp().getExusualta());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExusumodif() != null) {
			where.append(" AND t2.EXUSUMODIF = ?");
			params.add(expedien.getSanexp().getExusumodif());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExcooractual() != null) {
			where.append(" AND t2.EXCOORACTUAL = ?");
			params.add(expedien.getSanexp().getExcooractual());
		}
		if (expedien != null && expedien.getSanexp() != null
				&& expedien.getSanexp().getExdestnotifsancionado() != null) {
			where.append(" AND t2.EXDESTNOTIFSANCIONADO = ?");
			params.add(expedien.getSanexp().getExdestnotifsancionado());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExverifsanc() != null) {
			where.append(" AND t2.EXVERIFSANC = ?");
			params.add(expedien.getSanexp().getExverifsanc());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExverifinco() != null) {
			where.append(" AND t2.EXVERIFINCO = ?");
			params.add(expedien.getSanexp().getExverifinco());
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the FiltroSanciones entity
	 * 
	 * @param expedien
	 *            FiltroSanciones Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA
	private Map<String, ?> getWhereMapSanciones(FiltroSanciones filtroSanciones) {

		StringBuilder where = new StringBuilder(ExpedienDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (filtroSanciones != null && filtroSanciones.getExcoor() != null) {
			where.append(" AND t1.EXCOOR = ?");
			params.add(filtroSanciones.getExcoor());
		}
		if (filtroSanciones != null && filtroSanciones.getExnran() != null) {
			where.append(" AND t1.EXNRAN = ?");
			params.add(filtroSanciones.getExnran());
		}
		if (filtroSanciones != null && filtroSanciones.getExnror() != null) {
			where.append(" AND t1.EXNROR = ?");
			params.add(filtroSanciones.getExnror());
		}
		if (filtroSanciones != null && filtroSanciones.getExcoit() != null) {
			where.append(" AND t1.EXCOIT = ?");
			params.add(filtroSanciones.getExcoit());
		}

		/*
		 * Fechas desde hasta del envio de la operacion.
		 */
		if (filtroSanciones != null && filtroSanciones.getFechaIniDesde() != null
				&& filtroSanciones.getFechaIniDesde() instanceof Date) {
			where.append(" AND t1.EXFERE >= ?");
			params.add(filtroSanciones.getFechaIniDesde());
		}
		if (filtroSanciones != null && filtroSanciones.getFechaIniHasta() != null
				&& filtroSanciones.getFechaIniHasta() instanceof Date) {
			where.append(" AND t1.EXFERE <= ?");
			params.add(filtroSanciones.getFechaIniHasta());
		}
		if (filtroSanciones != null && filtroSanciones.getEstadoExpediente() != null) {
			if (Y41bConstantes.FILTROSANCIONES_EXPEDIENTE_ABIERTO.equals(filtroSanciones.getEstadoExpediente())) {
				where.append(" AND t10.TRFECCIERRE IS NULL");
			} else if (Y41bConstantes.FILTROSANCIONES_EXPEDIENTE_CERRADO
					.equals(filtroSanciones.getEstadoExpediente())) {
				where.append(" AND t10.TRFECCIERRE IS NOT NULL");
			}
		}

		if (filtroSanciones != null && filtroSanciones.getCifnif() != null) {
			where.append(" AND t5.ESNIF = ?");
			params.add(filtroSanciones.getCifnif());
		}
		if (filtroSanciones != null && filtroSanciones.getConoco() != null) {
			where.append(" AND t5.ESNOCO = ?");
			params.add(filtroSanciones.getConoco());
		}

		if (filtroSanciones != null && filtroSanciones.getProvinciaId() != null) {
			where.append(" AND t5.ESNORA_PROVINCIA_ID = ?");
			params.add(filtroSanciones.getProvinciaId());
		}
		if (filtroSanciones != null && filtroSanciones.getMunicipioId() != null) {
			where.append(" AND t5.ESNORA_MUNICIPIO_ID = ?");
			params.add(filtroSanciones.getMunicipioId());
		}
		if (filtroSanciones != null && filtroSanciones.getLocalidadId() != null) {
			where.append(" AND t5.ESNORA_LOCALIDAD_ID = ?");
			params.add(filtroSanciones.getLocalidadId());
		}
		if (filtroSanciones != null && filtroSanciones.getFase() != null) {
			where.append(" AND t3.FCODIGO = ?");
			params.add(filtroSanciones.getFase());
		}
		if (filtroSanciones != null && filtroSanciones.getTramite() != null) {
			where.append(" AND t10.TRCODIGO = ?");
			params.add(filtroSanciones.getTramite());
		}
		if (filtroSanciones != null && filtroSanciones.getTipoResolucion() != null) {
			where.append(" AND t10.TRRESOTIPO = ?");
			params.add(filtroSanciones.getTipoResolucion());
		}
		if (filtroSanciones != null && filtroSanciones.getInstructor() != null) {
			where.append(" AND t2.EXMOCODIGO = ?");
			params.add(filtroSanciones.getInstructor());
		}
		if (filtroSanciones != null && filtroSanciones.getFechaTramitacionDesde() != null
				&& filtroSanciones.getFechaTramitacionDesde() instanceof Date) {
			where.append(" AND t10.TRFECINI >= ?");
			params.add(filtroSanciones.getFechaTramitacionDesde());
		}
		if (filtroSanciones != null && filtroSanciones.getFechaTramitacionHasta() != null
				&& filtroSanciones.getFechaTramitacionHasta() instanceof Date) {
			where.append(" AND t10.TRFECINI <= ?");
			params.add(filtroSanciones.getFechaTramitacionHasta());
		}
		if (filtroSanciones != null && true == filtroSanciones.getUltimoTramite()) {
			where.append(" AND t10.TRID = t2.EXTRPOSCOD ");

		}
		if (filtroSanciones != null && true == filtroSanciones.getAcuseRecibo()) {
			where.append(" AND t6.ENTRID = t10.TRID AND t6.ENFECACUSE IS NULL ");
		}

		// para identificar las sanciones abiertas en los trasvases de
		// instructor
		if (filtroSanciones != null && filtroSanciones.getExfecfin() != null
				&& filtroSanciones.getExfecfin() instanceof Date) {
			where.append(" AND t2.EXFECFIN IS NULL ");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Expedien entity
	 * 
	 * @param expedien
	 *            Expedien Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA
	private Map<String, ?> getWhereLikeMap(Expedien expedien, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ExpedienDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (expedien != null && expedien.getExcodigo() != null) {
			where.append(" AND UPPER(t1.EXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCODIGO IS NOT NULL");
		}
		if (expedien != null && expedien.getExcoor() != null) {
			where.append(" AND UPPER(t1.EXCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExcoor().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCOOR IS NOT NULL");
		}
		if (expedien != null && expedien.getExnran() != null) {
			where.append(" AND t1.EXNRAN = ?");
			params.add(expedien.getExnran());
		}
		if (expedien != null && expedien.getExnror() != null) {
			where.append(" AND t1.EXNROR = ?");
			params.add(expedien.getExnror());
		}
		if (expedien != null && expedien.getExfere() != null) {
			where.append(" AND t1.EXFERE = ?");
			params.add(expedien.getExfere());
		}
		if (expedien != null && expedien.getExcoit() != null) {
			where.append(" AND UPPER(t1.EXCOIT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExcoit().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExcoit().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCOIT IS NOT NULL");
		}
		if (expedien != null && expedien.getExcoes() != null) {
			where.append(" AND UPPER(t1.EXCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExcoes().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExcoes().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCOES IS NOT NULL");
		}
		if (expedien != null && expedien.getExfeacin() != null) {
			where.append(" AND t1.EXFEACIN = ?");
			params.add(expedien.getExfeacin());
		}
		if (expedien != null && expedien.getExfeemca() != null) {
			where.append(" AND t1.EXFEEMCA = ?");
			params.add(expedien.getExfeemca());
		}
		if (expedien != null && expedien.getExfeplca() != null) {
			where.append(" AND t1.EXFEPLCA = ?");
			params.add(expedien.getExfeplca());
		}
		if (expedien != null && expedien.getExfpnopc() != null) {
			where.append(" AND t1.EXFPNOPC = ?");
			params.add(expedien.getExfpnopc());
		}
		if (expedien != null && expedien.getExfede() != null) {
			where.append(" AND t1.EXFEDE = ?");
			params.add(expedien.getExfede());
		}
		if (expedien != null && expedien.getExfecoal() != null) {
			where.append(" AND t1.EXFECOAL = ?");
			params.add(expedien.getExfecoal());
		}
		if (expedien != null && expedien.getExfenopr() != null) {
			where.append(" AND t1.EXFENOPR = ?");
			params.add(expedien.getExfenopr());
		}
		if (expedien != null && expedien.getExfepupr() != null) {
			where.append(" AND t1.EXFEPUPR = ?");
			params.add(expedien.getExfepupr());
		}
		if (expedien != null && expedien.getExcoospr() != null) {
			where.append(" AND UPPER(t1.EXCOOSPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExcoospr().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExcoospr().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCOOSPR IS NOT NULL");
		}
		if (expedien != null && expedien.getExfealpr() != null) {
			where.append(" AND t1.EXFEALPR = ?");
			params.add(expedien.getExfealpr());
		}
		if (expedien != null && expedien.getExfeel() != null) {
			where.append(" AND t1.EXFEEL = ?");
			params.add(expedien.getExfeel());
		}
		if (expedien != null && expedien.getExferes() != null) {
			where.append(" AND t1.EXFERES = ?");
			params.add(expedien.getExferes());
		}
		if (expedien != null && expedien.getExfenore() != null) {
			where.append(" AND t1.EXFENORE = ?");
			params.add(expedien.getExfenore());
		}
		if (expedien != null && expedien.getExfepure() != null) {
			where.append(" AND t1.EXFEPURE = ?");
			params.add(expedien.getExfepure());
		}
		if (expedien != null && expedien.getExcoosre() != null) {
			where.append(" AND UPPER(t1.EXCOOSRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExcoosre().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExcoosre().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCOOSRE IS NOT NULL");
		}
		if (expedien != null && expedien.getExcottr() != null) {
			where.append(" AND UPPER(t1.EXCOTTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExcottr().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExcottr().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCOTTR IS NOT NULL");
		}
		if (expedien != null && expedien.getExcamure() != null) {
			where.append(" AND t1.EXCAMURE = ?");
			params.add(expedien.getExcamure());
		}
		if (expedien != null && expedien.getExfeta() != null) {
			where.append(" AND t1.EXFETA = ?");
			params.add(expedien.getExfeta());
		}
		if (expedien != null && expedien.getExcotsa() != null) {
			where.append(" AND UPPER(t1.EXCOTSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExcotsa().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExcotsa().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCOTSA IS NOT NULL");
		}
		if (expedien != null && expedien.getExfecroi() != null) {
			where.append(" AND t1.EXFECROI = ?");
			params.add(expedien.getExfecroi());
		}
		if (expedien != null && expedien.getExfear() != null) {
			where.append(" AND t1.EXFEAR = ?");
			params.add(expedien.getExfear());
		}
		if (expedien != null && expedien.getExcoorie() != null) {
			where.append(" AND UPPER(t1.EXCOORIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExcoorie().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExcoorie().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCOORIE IS NOT NULL");
		}
		if (expedien != null && expedien.getExinre() != null) {
			where.append(" AND UPPER(t1.EXINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExinre().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExinre().toUpperCase() + "%");
			}
			where.append(" AND t1.EXINRE IS NOT NULL");
		}
		if (expedien != null && expedien.getExincoco() != null) {
			where.append(" AND UPPER(t1.EXINCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExincoco().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExincoco().toUpperCase() + "%");
			}
			where.append(" AND t1.EXINCOCO IS NOT NULL");
		}
		if (expedien != null && expedien.getExinexva() != null) {
			where.append(" AND UPPER(t1.EXINEXVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExinexva().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExinexva().toUpperCase() + "%");
			}
			where.append(" AND t1.EXINEXVA IS NOT NULL");
		}
		if (expedien != null && expedien.getExfecirc() != null) {
			where.append(" AND t1.EXFECIRC = ?");
			params.add(expedien.getExfecirc());
		}
		if (expedien != null && expedien.getExfenoai() != null) {
			where.append(" AND t1.EXFENOAI = ?");
			params.add(expedien.getExfenoai());
		}
		if (expedien != null && expedien.getExfecolm() != null) {
			where.append(" AND t1.EXFECOLM = ?");
			params.add(expedien.getExfecolm());
		}
		if (expedien != null && expedien.getExnuinlm() != null) {
			where.append(" AND UPPER(t1.EXNUINLM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExnuinlm().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExnuinlm().toUpperCase() + "%");
			}
			where.append(" AND t1.EXNUINLM IS NOT NULL");
		}
		if (expedien != null && expedien.getExfeinmu() != null) {
			where.append(" AND t1.EXFEINMU = ?");
			params.add(expedien.getExfeinmu());
		}
		if (expedien != null && expedien.getExfeavmu() != null) {
			where.append(" AND t1.EXFEAVMU = ?");
			params.add(expedien.getExfeavmu());
		}
		if (expedien != null && expedien.getExfeimcd() != null) {
			where.append(" AND t1.EXFEIMCD = ?");
			params.add(expedien.getExfeimcd());
		}
		if (expedien != null && expedien.getExfecede() != null) {
			where.append(" AND t1.EXFECEDE = ?");
			params.add(expedien.getExfecede());
		}
		if (expedien != null && expedien.getExcops() != null) {
			where.append(" AND UPPER(t1.EXCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExcops().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExcops().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCOPS IS NOT NULL");
		}
		if (expedien != null && expedien.getExcose() != null) {
			where.append(" AND UPPER(t1.EXCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getExcose().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getExcose().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCOSE IS NOT NULL");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(expedien.getSanexp().getExcodigo());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getSantramexp() != null
				&& expedien.getSanexp().getSantramexp().getTrid() != null) {
			where.append(" AND t2.EXTRPOSCOD = ?");
			params.add(expedien.getSanexp().getSantramexp().getTrid());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExfolderid() != null) {
			where.append(" AND UPPER(t2.EXFOLDERID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getSanexp().getExfolderid().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getSanexp().getExfolderid().toUpperCase() + "%");
			}
			where.append(" AND t2.EXFOLDERID IS NOT NULL");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExdesces() != null) {
			// where.append(" AND UPPER(t2.EXDESCES) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(expedien.getSanexp().getExdesces().toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + expedien.getSanexp().getExdesces().toUpperCase()
			// + "%");
			// }
			// where.append(" AND t2.EXDESCES IS NOT NULL");
			where.append(" AND TRANSLATE(UPPER(t2.EXDESCES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getSanexp().getExdesces().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + expedien.getSanexp().getExdesces().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t2.EXDESCES IS NOT NULL ");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExdesceu() != null) {
			// where.append(" AND UPPER(t2.EXDESCEU) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(expedien.getSanexp().getExdesceu().toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + expedien.getSanexp().getExdesceu().toUpperCase()
			// + "%");
			// }
			// where.append(" AND t2.EXDESCEU IS NOT NULL");
			where.append(" AND TRANSLATE(UPPER(t2.EXDESCEU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getSanexp().getExdesceu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + expedien.getSanexp().getExdesceu().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t2.EXDESCEU IS NOT NULL ");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExfecprevfin() != null) {
			where.append(" AND t2.EXFECPREVFIN = ?");
			params.add(expedien.getSanexp().getExfecprevfin());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExfecfin() != null) {
			where.append(" AND t2.EXFECFIN = ?");
			params.add(expedien.getSanexp().getExfecfin());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExcalif() != null) {
			where.append(" AND UPPER(t2.EXCALIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getSanexp().getExcalif().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getSanexp().getExcalif().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCALIF IS NOT NULL");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getEximporte() != null) {
			where.append(" AND UPPER(t2.EXIMPORTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getSanexp().getEximporte().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getSanexp().getEximporte().toUpperCase() + "%");
			}
			where.append(" AND t2.EXIMPORTE IS NOT NULL");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExrecurso() != null) {
			where.append(" AND UPPER(t2.EXRECURSO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getSanexp().getExrecurso().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getSanexp().getExrecurso().toUpperCase() + "%");
			}
			where.append(" AND t2.EXRECURSO IS NOT NULL");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExorden() != null) {
			where.append(" AND UPPER(t2.EXORDEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getSanexp().getExorden().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getSanexp().getExorden().toUpperCase() + "%");
			}
			where.append(" AND t2.EXORDEN IS NOT NULL");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExtipres() != null) {
			where.append(" AND UPPER(t2.EXTIPRES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getSanexp().getExtipres().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getSanexp().getExtipres().toUpperCase() + "%");
			}
			where.append(" AND t2.EXTIPRES IS NOT NULL");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExcaja1() != null) {
			where.append(" AND UPPER(t2.EXCAJA1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getSanexp().getExcaja1().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getSanexp().getExcaja1().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCAJA1 IS NOT NULL");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExcaja2() != null) {
			where.append(" AND UPPER(t2.EXCAJA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getSanexp().getExcaja2().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getSanexp().getExcaja2().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCAJA2 IS NOT NULL");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExmocodigo() != null) {
			where.append(" AND UPPER(t2.EXMOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getSanexp().getExmocodigo().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getSanexp().getExmocodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.EXMOCODIGO IS NOT NULL");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getFase() != null
				&& expedien.getSanexp().getFase().getFcodigo() != null) {
			where.append(" AND t2.EXFCODIGO = ?");
			params.add(expedien.getSanexp().getFase().getFcodigo());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExmocodigoult() != null) {
			where.append(" AND UPPER(t2.EXMOCODIGOULT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getSanexp().getExmocodigoult().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getSanexp().getExmocodigoult().toUpperCase() + "%");
			}
			where.append(" AND t2.EXMOCODIGOULT IS NOT NULL");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExfecalta() != null) {
			where.append(" AND t2.EXFECALTA = ?");
			params.add(expedien.getSanexp().getExfecalta());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExfecmodif() != null) {
			where.append(" AND t2.EXFECMODIF = ?");
			params.add(expedien.getSanexp().getExfecmodif());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExusualta() != null) {
			where.append(" AND UPPER(t2.EXUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getSanexp().getExusualta().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getSanexp().getExusualta().toUpperCase() + "%");
			}
			where.append(" AND t2.EXUSUALTA IS NOT NULL");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExusumodif() != null) {
			where.append(" AND UPPER(t2.EXUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedien.getSanexp().getExusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + expedien.getSanexp().getExusumodif().toUpperCase() + "%");
			}
			where.append(" AND t2.EXUSUMODIF IS NOT NULL");
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExcooractual() != null) {
			where.append(" AND t2.EXCOORACTUAL = ?");
			params.add(expedien.getSanexp().getExcooractual());
		}
		if (expedien != null && expedien.getSanexp() != null
				&& expedien.getSanexp().getExdestnotifsancionado() != null) {
			where.append(" AND t2.EXDESTNOTIFSANCIONADO = ?");
			params.add(expedien.getSanexp().getExdestnotifsancionado());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExverifsanc() != null) {
			where.append(" AND t2.EXVERIFSANC = ?");
			params.add(expedien.getSanexp().getExverifsanc());
		}
		if (expedien != null && expedien.getSanexp() != null && expedien.getSanexp().getExverifinco() != null) {
			where.append(" AND t2.EXVERIFINCO = ?");
			params.add(expedien.getSanexp().getExverifinco());
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * METODOS DE BUSQUEDA PARA EL FILTRO/BUSQUEDA DE EXPEDIENTES SANCIONADORES
	 */

	private RowMapper<FiltroSanciones> rwMapBusquedaSanciones = new RowMapper<FiltroSanciones>() {
		public FiltroSanciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Fase fase = new Fase(resultSet.getString("fasefcodigo"), resultSet.getString("fasefnombre"),
					resultSet.getString("fasefnombree"), null, null);
			Tramite tramite = new Tramite(resultSet.getString("santramexpTRCODIGO"),
					resultSet.getString("tramiteTRNOMBRE"), resultSet.getString("tramiteTRNOMBREE"));
			Santramexp santramexp = new Santramexp(resultSet.getString("SanexpEXTRPOSCOD"),
					resultSet.getString("santramexpTRCODIGO"),
					/* resultSet.getString("santramexpTROBSERVES") */null, resultSet.getString("santramexpTRNOMTRAMES"),
					null, tramite);
			Santramexp santramexpEntidad = new Santramexp(resultSet.getString("SANEXPEXTRENTIDAD"), null, null);
			CensoMonitor censomonitor = new CensoMonitor(resultSet.getString("monitorMOCODIGO"),
					resultSet.getString("monitorMONOMBRE"), null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null);
			Sanexp sanexp = new Sanexp(resultSet.getString("SanexpEXCODIGO"), null, null,
					resultSet.getString("SanexpEXDESCES"), resultSet.getString("SanexpEXDESCEU"),
					resultSet.getDate("SanexpEXFECPREVFIN"), resultSet.getDate("SanexpEXFECFIN"), null, null, null,
					null, resultSet.getString("SanexpEXTIPRES"), null, null, resultSet.getString("SanexpEXMOCODIGO"),
					null, fase, null, null, null, null, null, null, resultSet.getString("SanexpEXLIQESTADO"),
					resultSet.getString("SanexpEXLIQAPREMIO"), santramexp, santramexpEntidad, null, null, null, null,
					null, null, null, null, null, null);
			sanexp.setExdestnotifsancionado(resultSet.getString("EXDESTNOTIFSANCIONADO"));
			sanexp.setExverifsanc(resultSet.getString("EXVERIFSANC"));
			sanexp.setExverifinco(resultSet.getString("EXVERIFINCO"));

			Establecimiento establecimiento = null;
			/* PARA TRATAR LOS EXPEDIENTES DEL SISTEMA VIEJO */
			// if (resultSet.getString("establESNOMBRE") == null) {
			// establecimiento = new Establecimiento(
			// resultSet.getString("EXCOES"),
			// resultSet.getString("establESNOMBRE_2"), null, null);
			// establecimiento.setEsnombreMunicipio(resultSet
			// .getString("nombre_municipio_2"));
			// } else {
			establecimiento = new Establecimiento(resultSet.getString("EXCOES"), resultSet.getString("establESNOMBRE"),
					null, null);
			establecimiento.setEsnombreMunicipio(resultSet.getString("nombre_municipio"));
			// }

			Tctipres tipoResolucion = null;
			tipoResolucion = new Tctipres();
			tipoResolucion.setTtrcodigo(resultSet.getString("tctipresTTRCODIGO"));
			tipoResolucion.setTtrnombre(resultSet.getString("tctipresTTRNOMBRE"));
			tipoResolucion.setTtrnombreeu(resultSet.getString("tctipresTTRNOMBREEU"));

			return new FiltroSanciones(resultSet.getString("expedienEXCODIGO"), resultSet.getString("EXCOOR"),
					resultSet.getBigDecimal("EXNRAN"), resultSet.getBigDecimal("EXNROR"),
					resultSet.getString("EXCOOR") + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ resultSet.getBigDecimal("EXNROR") + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ resultSet.getBigDecimal("EXNRAN"),
					resultSet.getDate("EXFERE"), resultSet.getString("EXCOIT"), establecimiento,
					resultSet.getString("EXINEXVA"), sanexp, null, censomonitor, santramexp, fase,
					resultSet.getDate("SanexpEXFECFIN"), tipoResolucion);
		}
	};

	/**
	 * METODOS DE BUSQUEDA PARA EL FILTRO/BUSQUEDA DE EXPEDIENTES SANCIONADORES
	 */

	private RowMapper<FiltroSanciones> rwMapBusquedaSancionesFiltro = new RowMapper<FiltroSanciones>() {
		public FiltroSanciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Fase fase = new Fase(resultSet.getString("fasefcodigo"), resultSet.getString("fasefnombre"),
					resultSet.getString("fasefnombree"), null, null);
			Tramite tramite = new Tramite(resultSet.getString("santramexpTRCODIGO"),
					resultSet.getString("tramiteTRNOMBRE"), resultSet.getString("tramiteTRNOMBREE"));
			Santramexp santramexp = new Santramexp(resultSet.getString("SanexpEXTRPOSCOD"),
					resultSet.getString("santramexpTRCODIGO"), null, resultSet.getString("santramexpTRNOMTRAMES"), null,
					tramite);
			Santramexp santramexpEntidad = new Santramexp(resultSet.getString("SANEXPEXTRENTIDAD"), null, null);
			CensoMonitor censomonitor = new CensoMonitor(resultSet.getString("monitorMOCODIGO"),
					resultSet.getString("monitorMONOMBRE"), null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null);
			Sanexp sanexp = new Sanexp(resultSet.getString("SanexpEXCODIGO"), null, null,
					resultSet.getString("SanexpEXDESCES"), resultSet.getString("SanexpEXDESCEU"),
					resultSet.getDate("SanexpEXFECPREVFIN"), resultSet.getDate("SanexpEXFECFIN"), null, null, null,
					null, resultSet.getString("SanexpEXTIPRES"), null, null, resultSet.getString("SanexpEXMOCODIGO"),
					null, fase, null, null, null, null, null, null, resultSet.getString("SanexpEXLIQESTADO"),
					resultSet.getString("SanexpEXLIQAPREMIO"), santramexp, santramexpEntidad, null, null, null, null,
					null, null, null, null, null, null);
			sanexp.setExcooractual(resultSet.getString("EXCOORACTUAL"));
			sanexp.setExdestnotifsancionado(resultSet.getString("EXDESTNOTIFSANCIONADO"));
			sanexp.setExverifsanc(resultSet.getString("EXVERIFSANC"));
			sanexp.setExverifinco(resultSet.getString("EXVERIFINCO"));
			Establecimiento establecimiento = null;
			/* PARA TRATAR LOS EXPEDIENTES DEL SISTEMA VIEJO */
			// if (resultSet.getString("establESNOMBRE") == null) {
			// establecimiento = new Establecimiento(
			// resultSet.getString("EXCOES"),
			// resultSet.getString("establESNOMBRE_2"), null, null);
			// establecimiento.setEsnombreMunicipio(resultSet
			// .getString("nombre_municipio_2"));
			// } else {
			establecimiento = new Establecimiento(resultSet.getString("EXCOES"), resultSet.getString("establESNOMBRE"),
					null, null);
			establecimiento.setEsnombreMunicipio(resultSet.getString("nombre_municipio"));
			// }

			Tctipres tipoResolucion = null;
			tipoResolucion = new Tctipres();
			tipoResolucion.setTtrcodigo(resultSet.getString("tctipresTTRCODIGO"));
			tipoResolucion.setTtrnombre(resultSet.getString("tctipresTTRNOMBRE"));
			tipoResolucion.setTtrnombreeu(resultSet.getString("tctipresTTRNOMBREEU"));

			return new FiltroSanciones(resultSet.getString("expedienEXCODIGO"), resultSet.getString("EXCOOR"),
					resultSet.getBigDecimal("EXNRAN"), resultSet.getBigDecimal("EXNROR"),
					resultSet.getString("EXCOOR") + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ resultSet.getBigDecimal("EXNROR") + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ resultSet.getBigDecimal("EXNRAN"),
					resultSet.getDate("EXFERE"), resultSet.getString("EXCOIT"), establecimiento,
					resultSet.getString("EXINEXVA"), sanexp, null, censomonitor, santramexp, fase,
					resultSet.getDate("SanexpEXFECFIN"), tipoResolucion);
		}
	};

	private RowMapper<FiltroSanciones> rwMapBusquedaSancionesRel = new RowMapper<FiltroSanciones>() {
		public FiltroSanciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			CensoMonitor censomonitor = new CensoMonitor(resultSet.getString("monitorMOCODIGO"),
					resultSet.getString("monitorMONOMBRE"), null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null);
			Sanexp sanexp = new Sanexp(resultSet.getString("SanexpEXCODIGO"), null, null,
					resultSet.getString("SanexpEXDESCES"), resultSet.getString("SanexpEXDESCEU"),
					resultSet.getDate("SanexpEXFECPREVFIN"), resultSet.getDate("SanexpEXFECFIN"), null, null, null,
					null, null, null, null, resultSet.getString("SanexpEXMOCODIGO"), null, null, null, null, null, null,
					null, null, resultSet.getString("SanexpEXLIQESTADO"), resultSet.getString("SanexpEXLIQAPREMIO"),
					null, null, null, resultSet.getDate("SanexpHDFECHD"), null, null, null, null, null, null, null,
					null);
			sanexp.setExcooractual(resultSet.getString("EXCOORACTUAL"));
			sanexp.setExdestnotifsancionado(resultSet.getString("EXDESTNOTIFSANCIONADO"));
			sanexp.setExverifsanc(resultSet.getString("EXVERIFSANC"));
			sanexp.setExverifinco(resultSet.getString("EXVERIFINCO"));
			Establecimiento establecimiento = new Establecimiento(resultSet.getString("EXCOES"));
			return new FiltroSanciones(resultSet.getString("EXCODIGO"), resultSet.getString("EXCOOR"),
					resultSet.getBigDecimal("EXNRAN"), resultSet.getBigDecimal("EXNROR"),
					resultSet.getString("EXCOOR") + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ resultSet.getBigDecimal("EXNROR") + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ resultSet.getBigDecimal("EXNRAN"),
					resultSet.getDate("EXFERE"), resultSet.getString("EXCOIT"), establecimiento,
					resultSet.getString("EXINEXVA"), sanexp, null, censomonitor, null, null,
					resultSet.getDate("SanexpEXFECFIN"), null);
		}
	};

	/**
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @return List<Expedien>
	 */
	public List<Expedien> findAllSanciones(FiltroSanciones filtroSanciones, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.EXCODIGO expedienEXCODIGO, t1.EXCOOR EXCOOR, t1.EXNRAN EXNRAN, t1.EXNROR EXNROR, t1.EXFERE EXFERE, t1.EXCOIT EXCOIT, t1.EXCOES EXCOES, t1.EXINEXVA EXINEXVA,t1.EXFEACIN EXFEACIN, t1.EXFEEMCA EXFEEMCA,t1.EXFEPLCA EXFEPLCA,t1.EXFPNOPC EXFPNOPC,t1.EXFEDE EXFEDE,t1.EXFECOAL EXFECOAL,t1.EXFENOPR EXFENOPR,t1.EXFEPUPR EXFEPUPR,t1.EXCOOSPR EXCOOSPR,t1.EXFEALPR EXFEALPR,t1.EXFEEL EXFEEL,t1.EXFERES EXFERES,t1.EXFENORE EXFENORE,t1.EXFEPURE EXFEPURE,t1.EXCOOSRE EXCOOSRE,t1.EXCOTTR EXCOTTR,t1.EXCAMURE EXCAMURE,t1.EXFETA EXFETA,t1.EXCOTSA EXCOTSA,t1.EXFECROI EXFECROI,t1.EXFEAR EXFEAR,t1.EXCOORIE EXCOORIE,t1.EXINRE EXINRE,t1.EXINCOCO EXINCOCO,t1.EXINEXVA EXINEXVA,t1.EXFECIRC EXFECIRC,t1.EXFENOAI EXFENOAI,t1.EXFECOLM EXFECOLM,t1.EXNUINLM EXNUINLM,t1.EXFEINMU EXFEINMU,t1.EXFEAVMU EXFEAVMU,t1.EXFEIMCD EXFEIMCD,t1.EXFECEDE EXFECEDE,t1.EXCOPS EXCOPS,t1.EXCOSE EXCOSE,t2.EXCODIGO SANEXPEXCODIGO, t2.EXFOLDERID SANEXPEXFOLDERID, t2.EXDESCES SANEXPEXDESCES, t2.EXDESCEU SANEXPEXDESCEU, t2.EXFECPREVFIN SANEXPEXFECPREVFIN, t2.EXFECFIN SANEXPEXFECFIN,t2.EXCALIF SANEXPEXCALIF, t2.EXIMPORTE SANEXPEXIMPORTE, t2.EXRECURSO SANEXPEXRECURSO, t2.EXTIPRES SANEXPEXTIPRES,t2.EXORDEN SANEXPEXORDEN,t2.EXCAJA1 SANEXPEXCAJA1,t2.EXCAJA2 SANEXPEXCAJA2, t2.EXMOCODIGO SANEXPEXMOCODIGO, t2.EXFCODIGO SANEXPEXFCODIGO, t2.EXMOCODIGOULT SANEXPEXMOCODIGOULT, t2.EXTRPOSCOD SANEXPEXTRPOSCOD, t2.EXTRENTIDAD SANEXPEXTRENTIDAD, t2.EXLIQESTADO SANEXPEXLIQESTADO, t2.EXLIQAPREMIO SANEXPEXLIQAPREMIO,t2.EXCOORACTUAL EXCOORACTUAL,t2.EXFECALTA SANEXPEXFECALTA,t2.EXFECMODIF SANEXPEXFECMODIF, t2.EXUSUALTA SANEXPEXUSUALTA,t2.EXUSUMODIF SANEXPEXUSUMODIF,t2.EXDESTNOTIFSANCIONADO EXDESTNOTIFSANCIONADO, t2.EXVERIFSANC EXVERIFSANC, t2.EXVERIFINCO EXVERIFINCO, t3.fcodigo fasefcodigo, t3.fnombre fasefnombre, t3.fnombree fasefnombree, t5.ESNOMBRE establESNOMBRE, t5.ESNORA_MUNICIPIO_ID establUAMUN_ID, (SELECT DS_O FROM T17I.T17_MUNICIPIO WHERE T5.ESNORA_PROVINCIA_ID = PROVINCIA_ID AND t5.ESNORA_MUNICIPIO_ID = ID) AS NOMBRE_MUNICIPIO, t7.MOCODIGO monitorMOCODIGO, t7.MONOMBRE monitorMONOMBRE, t10.TRCODIGO santramexpTRCODIGO, t10.TRNOMBRE tramiteTRNOMBRE, t10.TRNOMBREE tramiteTRNOMBREE, /*t10.TROBSERVES santramexpTROBSERVES,*/ t10.TRNOMTRAMES santramexpTRNOMTRAMES, t14.ttrnombre tctipresTTRNOMBRE, t14.ttrnombreeu tctipresTTRNOMBREEU "
						+ "FROM EXPEDIEN t1 , SANEXP t2, FASE t3, ESTABLECIMIENTO t5, SANENVIO t6, CENSO_MONITOR t7, (SELECT T8.TRID, T9.TRNOMBRE, T9.TRNOMBREE, /*T8.TROBSERVES,*/ T8.TRNOMTRAMES, T8.TRCODIGO, t8.TRFECCIERRE, T8.TRRESOTIPO, T8.TRFECINI FROM SANTRAMEXP T8, TRAMITE T9 WHERE T9.TRCODIGO= T8.TRCODIGO) t10, TCTIPRES t14 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapSanciones(filtroSanciones);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.EXCODIGO= t2.EXCODIGO(+) AND t2.exfcodigo = t3.fcodigo(+) AND t1.EXCOES= t5.ESCODIGO(+) AND t1.EXCODIGO = t6.ENEXID(+) AND t2.EXMOCODIGO = t7.MOCODIGO(+) AND t2.EXTRPOSCOD = t10.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Expedien>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());

	}

	/**
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<FiltroSanciones>
	 */
	public List<FiltroSanciones> findAllLikeSanciones(FiltroSanciones filtroSanciones, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"( SELECT DISTINCT t1.EXCOOR || '" + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t1.EXNROR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
						+ "' || t1.EXNRAN CODCOMPLETO , t1.EXCODIGO expedienEXCODIGO, t1.EXCOOR EXCOOR, t1.EXNRAN EXNRAN, t1.EXNROR EXNROR,  LPAD(T1.EXNROR,12,'0')  CORRELATIVOPAD,t1.EXFERE EXFERE, t1.EXCOIT EXCOIT, t1.EXCOES EXCOES, t1.EXINEXVA EXINEXVA, t2.EXCODIGO SANEXPEXCODIGO, t2.EXDESCES SANEXPEXDESCES, t2.EXDESCEU SANEXPEXDESCEU, t2.EXFECPREVFIN SANEXPEXFECPREVFIN, t2.EXFECFIN SANEXPEXFECFIN, t2.EXTIPRES SANEXPEXTIPRES, t2.EXMOCODIGO SANEXPEXMOCODIGO, t2.EXFCODIGO SANEXPEXFCODIGO, t2.EXMOCODIGOULT SANEXPEXMOCODIGOULT, t2.EXTRPOSCOD SANEXPEXTRPOSCOD, t2.EXTRENTIDAD SANEXPEXTRENTIDAD, t2.EXLIQESTADO SANEXPEXLIQESTADO, t2.EXLIQAPREMIO SANEXPEXLIQAPREMIO, t2.EXCOORACTUAL EXCOORACTUAL, t2.EXDESTNOTIFSANCIONADO EXDESTNOTIFSANCIONADO, t2.EXVERIFSANC EXVERIFSANC, t2.EXVERIFINCO EXVERIFINCO, t3.fcodigo fasefcodigo, t3.fnombre fasefnombre, t3.fnombree fasefnombree, t5.UANOMBRE establESNOMBRE, t5.UAMUN_ID establUAMUN_ID, (SELECT DS_O FROM T17I.T17_MUNICIPIO WHERE T5.UAPROV_ID = PROVINCIA_ID AND t5.UAMUN_ID = ID) AS NOMBRE_MUNICIPIO, t7.MOCODIGO monitorMOCODIGO, t7.MONOMBRE monitorMONOMBRE, t10.TRCODIGO santramexpTRCODIGO, t10.TRNOMBRE tramiteTRNOMBRE, t10.TRNOMBREE tramiteTRNOMBREE, /*t10.TROBSERVES santramexpTROBSERVES,*/ t10.TRNOMTRAMES santramexpTRNOMTRAMES, t14.ttrcodigo tctipresTTRCODIGO, t14.ttrnombre tctipresTTRNOMBRE, t14.ttrnombreeu tctipresTTRNOMBREEU "
						+ getFromBusquedaSanciones());

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapSanciones(filtroSanciones, startsWith);
		StringBuilder where = new StringBuilder(getWhereBusquedaSanciones());

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(")");

		List<?> params = (List<?>) mapaWhere.get("params");

		// Si estamos buscando por fase-tramite, cerrado, ...
		// no deben aparecer los expedientes antiguos porque no tienen
		// tramitacion
		StringBuilder queryDef = new StringBuilder(query);
		if (this.incluirBusquedaViejos(filtroSanciones)) {
			StringBuilder query2 = new StringBuilder(
					"( SELECT DISTINCT t1.EXCOOR || '" + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ "' || t1.EXNROR || '" + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ "' || t1.EXNRAN CODCOMPLETO, t1.EXCODIGO expedienEXCODIGO, t1.EXCOOR EXCOOR, t1.EXNRAN EXNRAN, t1.EXNROR EXNROR,  LPAD(T1.EXNROR,12,'0') CORRELATIVOPAD ,t1.EXFERE EXFERE, t1.EXCOIT EXCOIT, t1.EXCOES EXCOES, t1.EXINEXVA EXINEXVA, null SANEXPEXCODIGO, null SANEXPEXDESCES, null SANEXPEXDESCEU, null SANEXPEXFECPREVFIN, null SANEXPEXFECFIN, null SANEXPEXTIPRES, null SANEXPEXMOCODIGO, null SANEXPEXFCODIGO, null SANEXPEXMOCODIGOULT, null SANEXPEXTRPOSCOD, null SANEXPEXTRENTIDAD, null SANEXPEXLIQESTADO, null SANEXPEXLIQAPREMIO, null EXCOORACTUAL, null EXDESTNOTIFSANCIONADO, null EXVERIFSANC, null EXVERIFINCO, null fasefcodigo, null fasefnombre, null fasefnombree, t5.ESNOMBRE establESNOMBRE, t5.ESNORA_MUNICIPIO_ID establUAMUN_ID, (SELECT DS_O FROM T17I.T17_MUNICIPIO WHERE T5.ESNORA_PROVINCIA_ID = PROVINCIA_ID AND t5.ESNORA_MUNICIPIO_ID = ID) AS NOMBRE_MUNICIPIO, t7.MOCODIGO monitorMOCODIGO, t7.MONOMBRE monitorMONOMBRE, null santramexpTRCODIGO, null tramiteTRNOMBRE, null tramiteTRNOMBREE, /*t10.TROBSERVES santramexpTROBSERVES,*/ null santramexpTRNOMTRAMES, t14.ttrcodigo tctipresTTRCODIGO, t14.ttrnombre tctipresTTRNOMBRE, t14.ttrnombreeu tctipresTTRNOMBREEU  "
							+ getFromBusquedaSancionesHist());

			// Where clause & Params
			Map<String, ?> mapaWhere2 = this.getWhereLikeMapSancionesHistoricas(filtroSanciones, startsWith);
			StringBuilder where2 = new StringBuilder(getWhereBusquedaSancionesHist());
			where2.append(mapaWhere2.get("query"));
			query2.append(where2);
			query2.append(")");

			params.addAll((List) mapaWhere2.get("params"));
			queryDef = queryDef.append(" UNION ").append(query2);
		}

		if (pagination != null) {
			queryDef = pagination.getPaginationQuery(queryDef);
		}

		List<FiltroSanciones> listaSanciones = (List<FiltroSanciones>) this.jdbcTemplate.query(queryDef.toString(),
				this.rwMapBusquedaSancionesFiltro, params.toArray());
		return listaSanciones;

	}

	/**
	 * incluirBusquedaViejos
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @return boolean
	 */
	private boolean incluirBusquedaViejos(FiltroSanciones filtroSanciones) {
		return (filtroSanciones != null && filtroSanciones.getIdFase() == null && filtroSanciones.getTramite() == null
				&& filtroSanciones.getFechaTramitacionDesde() == null
				&& filtroSanciones.getFechaTramitacionHasta() == null && filtroSanciones.getInstructor() == null
				&& !filtroSanciones.getUltimoTramite() && !filtroSanciones.getAcuseRecibo()
				&& !filtroSanciones.getIndPendienteFirma() && filtroSanciones.getPcodigo() == null);
	}

	/**
	 * incluirFiltroNuevos
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @return boolean
	 */
	private boolean incluirFiltroTramites(FiltroSanciones filtroSanciones) {
		return (filtroSanciones != null && (filtroSanciones.getIdFase() != null || filtroSanciones.getTramite() != null
				|| filtroSanciones.getFechaTramitacionDesde() != null
				|| filtroSanciones.getFechaTramitacionHasta() != null || filtroSanciones.getInstructor() != null
				|| filtroSanciones.getUltimoTramite() || filtroSanciones.getAcuseRecibo()
				|| filtroSanciones.getIndPendienteFirma()));
	}

	/**
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<FiltroSanciones>
	 */
	public List<FiltroSanciones> findAllLikeSancionesCombinada(FiltroSanciones filtroSanciones, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"( SELECT DISTINCT t1.EXCOOR || '" + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t1.EXNROR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
						+ "' || t1.EXNRAN CODCOMPLETO , t1.EXCODIGO expedienEXCODIGO, t1.EXCOOR EXCOOR, t1.EXNRAN EXNRAN, t1.EXNROR EXNROR,  LPAD(T1.EXNROR,12,'0')  CORRELATIVOPAD,t1.EXFERE EXFERE, t1.EXCOIT EXCOIT, t1.EXCOES EXCOES, t1.EXINEXVA EXINEXVA, t2.EXCODIGO SANEXPEXCODIGO, t2.EXDESCES SANEXPEXDESCES, t2.EXDESCEU SANEXPEXDESCEU, t2.EXFECPREVFIN SANEXPEXFECPREVFIN, t2.EXFECFIN SANEXPEXFECFIN, t2.EXTIPRES SANEXPEXTIPRES, t2.EXMOCODIGO SANEXPEXMOCODIGO, t2.EXFCODIGO SANEXPEXFCODIGO, t2.EXMOCODIGOULT SANEXPEXMOCODIGOULT, t2.EXTRPOSCOD SANEXPEXTRPOSCOD, t2.EXTRENTIDAD SANEXPEXTRENTIDAD, t2.EXLIQESTADO SANEXPEXLIQESTADO, t2.EXLIQAPREMIO SANEXPEXLIQAPREMIO, t2.EXCOORACTUAL EXCOORACTUAL, t2.EXDESTNOTIFSANCIONADO EXDESTNOTIFSANCIONADO, t2.EXVERIFSANC EXVERIFSANC, t2.EXVERIFINCO EXVERIFINCO, t3.fcodigo fasefcodigo, t3.fnombre fasefnombre, t3.fnombree fasefnombree, t5.UANOMBRE establESNOMBRE, t5.UAMUN_ID establUAMUN_ID, (SELECT DS_O FROM T17I.T17_MUNICIPIO WHERE T5.UAPROV_ID = PROVINCIA_ID AND t5.UAMUN_ID = ID) AS NOMBRE_MUNICIPIO, t7.MOCODIGO monitorMOCODIGO, t7.MONOMBRE monitorMONOMBRE, t10.TRCODIGO santramexpTRCODIGO, t10.TRNOMBRE tramiteTRNOMBRE, t10.TRNOMBREE tramiteTRNOMBREE,/* t10.TROBSERVES santramexpTROBSERVES,*/ t10.TRNOMTRAMES santramexpTRNOMTRAMES, t14.ttrcodigo tctipresTTRCODIGO, t14.ttrnombre tctipresTTRNOMBRE, t14.ttrnombreeu tctipresTTRNOMBREEU  "
						+ getFromBusquedaSanciones());

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapSanciones(filtroSanciones, startsWith);
		StringBuilder where = new StringBuilder(getWhereBusquedaSanciones());

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(")");

		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuilder query2 = new StringBuilder(
				"( SELECT DISTINCT t1.EXCOOR || '" + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t1.EXNROR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
						+ "' || t1.EXNRAN CODCOMPLETO, t1.EXCODIGO expedienEXCODIGO, t1.EXCOOR EXCOOR, t1.EXNRAN EXNRAN, t1.EXNROR EXNROR,  LPAD(T1.EXNROR,12,'0') CORRELATIVOPAD ,t1.EXFERE EXFERE, t1.EXCOIT EXCOIT, t1.EXCOES EXCOES, t1.EXINEXVA EXINEXVA, null SANEXPEXCODIGO, null SANEXPEXDESCES, null SANEXPEXDESCEU, null SANEXPEXFECPREVFIN, null SANEXPEXFECFIN, null SANEXPEXTIPRES, null SANEXPEXMOCODIGO, null SANEXPEXFCODIGO, null SANEXPEXMOCODIGOULT, null SANEXPEXTRPOSCOD, null SANEXPEXTRENTIDAD, null SANEXPEXLIQESTADO, null SANEXPEXLIQAPREMIO, null EXCOORACTUAL, null EXDESTNOTIFSANCIONADO, null EXVERIFSANC, null EXVERIFINCO, null fasefcodigo, null fasefnombre, null fasefnombree, t5.ESNOMBRE establESNOMBRE, t5.ESNORA_MUNICIPIO_ID establUAMUN_ID, (SELECT DS_O FROM T17I.T17_MUNICIPIO WHERE T5.ESNORA_PROVINCIA_ID = PROVINCIA_ID AND t5.ESNORA_MUNICIPIO_ID = ID) AS NOMBRE_MUNICIPIO, t7.MOCODIGO monitorMOCODIGO, t7.MONOMBRE monitorMONOMBRE, null santramexpTRCODIGO, null tramiteTRNOMBRE, null tramiteTRNOMBREE, /*t10.TROBSERVES santramexpTROBSERVES,*/ null santramexpTRNOMTRAMES, t14.ttrcodigo tctipresTTRCODIGO, t14.ttrnombre tctipresTTRNOMBRE, t14.ttrnombreeu tctipresTTRNOMBREEU  "
						+ getFromBusquedaSancionesHist());

		// Where clause & Params
		Map<String, ?> mapaWhere2 = this.getWhereLikeMapSancionesHistoricas(filtroSanciones, startsWith);
		StringBuilder where2 = new StringBuilder(getWhereBusquedaSancionesHist());
		where2.append(mapaWhere2.get("query"));
		query2.append(where2);
		query2.append(")");

		params.addAll((List) mapaWhere2.get("params"));

		StringBuilder queryDef = new StringBuilder(query.append(" UNION ").append(query2));

		if (pagination != null) {
			queryDef = pagination.getPaginationQuery(queryDef);
		}

		return (List<FiltroSanciones>) this.jdbcTemplate.query(queryDef.toString(), this.rwMapBusquedaSanciones,
				params.toArray());

	}

	/**
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeSancionesBusquedaCombinadaCount(FiltroSanciones filtroSanciones, Boolean startsWith) {

		StringBuilder query = new StringBuilder(" ( SELECT COUNT (DISTINCT T1.EXCODIGO) " + getFromBusquedaSanciones());

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapSanciones(filtroSanciones, startsWith);
		StringBuilder where = new StringBuilder(getWhereBusquedaSanciones());

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(")");

		List<?> params = (List<?>) mapaWhere.get("params");

		Long resultado1 = this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
		StringBuilder query2 = new StringBuilder(
				" ( SELECT COUNT (DISTINCT T1.EXCODIGO) " + getFromBusquedaSancionesHist());

		// Where clause & Params
		Map<String, ?> mapaWhere2 = this.getWhereLikeMapSancionesHistoricas(filtroSanciones, startsWith);
		StringBuilder where2 = new StringBuilder(getWhereBusquedaSancionesHist());
		where2.append(mapaWhere2.get("query"));
		query2.append(where2);
		query2.append(")");

		List<?> params2 = ((List<?>) mapaWhere2.get("params"));
		Long resultado2 = this.jdbcTemplate.queryForLong(query2.toString(), params2.toArray());

		return resultado1 + resultado2;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Expedien entity
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacion de codigo de UDA
	private Map<String, ?> getWhereLikeMapSanciones(FiltroSanciones filtroSanciones, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ExpedienDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (filtroSanciones != null && filtroSanciones.getExcoor() != null
				&& filtroSanciones.getExcoor().length() < 6) {
			where.append(" AND UPPER(t1.EXCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getExcoor().toUpperCase() + "%");
			} else {
				params.add("%" + filtroSanciones.getExcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCOOR IS NOT NULL");
		} else if (filtroSanciones != null && filtroSanciones.getExcoor() != null) {
			where.append(" AND UPPER(t1.EXCOOR)=? ");
			params.add(filtroSanciones.getExcoor().toUpperCase());
		}
		if (filtroSanciones != null && filtroSanciones.getExnran() != null) {
			where.append(" AND t1.EXNRAN = ?");
			params.add(filtroSanciones.getExnran().intValue());
		}
		if (filtroSanciones != null && filtroSanciones.getExnror() != null) {
			where.append(" AND t1.EXNROR = ?");
			params.add(filtroSanciones.getExnror());
		}
		if (filtroSanciones != null && filtroSanciones.getResponsable() != null) {
			where.append(" AND t1.EXCOIT = ?");
			params.add(filtroSanciones.getResponsable());
		}
		if (filtroSanciones != null && filtroSanciones.getFechaIniDesde() != null
				&& filtroSanciones.getFechaIniDesde() instanceof Date) {
			where.append(" AND t1.EXFERE >= ?");
			params.add(filtroSanciones.getFechaIniDesde());
		}
		if (filtroSanciones != null && filtroSanciones.getFechaIniHasta() != null
				&& filtroSanciones.getFechaIniHasta() instanceof Date) {
			where.append(" AND t1.EXFERE <= ?");
			params.add(filtroSanciones.getFechaIniHasta());
		}
		if (filtroSanciones != null && filtroSanciones.getEstadoExpediente() != null) {
			if (Y41bConstantes.FILTROSANCIONES_EXPEDIENTE_ABIERTO.equals(filtroSanciones.getEstadoExpediente())) {
				where.append(" AND t1.EXFEAR IS NULL");
			} else if (Y41bConstantes.FILTROSANCIONES_EXPEDIENTE_CERRADO
					.equals(filtroSanciones.getEstadoExpediente())) {
				where.append(" AND t1.EXFEAR IS NOT NULL");
			}
		}

		if (filtroSanciones != null && filtroSanciones.getCifnif() != null) {
			where.append(" AND UPPER(t5.UANIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getCifnif().toUpperCase() + "%");
			} else {
				params.add("%" + filtroSanciones.getCifnif().toUpperCase() + "%");
			}
			where.append(" AND t5.UANIF IS NOT NULL");
		}
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsnif() != null) {
			where.append(" AND UPPER(t5.UANIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getEstablecimiento().getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + filtroSanciones.getEstablecimiento().getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t5.UANIF IS NOT NULL");
		}
		if (filtroSanciones != null && filtroSanciones.getConoco() != null) {
			// where.append(" AND UPPER(t5.UANOMBRE) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getConoco().toUpperCase() + "%");
			// } else {
			// params.add("%" + filtroSanciones.getConoco().toUpperCase()
			// + "%");
			// }
			// where.append(" AND t5.UANOMBRE IS NOT NULL");
			where.append(" AND ((TRANSLATE(UPPER(t5.UANOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getConoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + filtroSanciones.getConoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t5.UANOMBRE IS NOT NULL )");
			where.append(" OR (TRANSLATE(UPPER(t5.UANOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getConoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + filtroSanciones.getConoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t5.UANOCO IS NOT NULL ))");
		}

		/* para la busqueda combinada */
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsnoco() != null) {
			// where.append(" AND UPPER(t5.UANOMBRE) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getEstablecimiento().getEsnoco()
			// .toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + filtroSanciones.getEstablecimiento().getEsnoco()
			// .toUpperCase() + "%");
			// }
			// where.append(" AND t5.UANOMBRE IS NOT NULL");
			where.append(" AND (TRANSLATE(UPPER(t5.UANOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getEstablecimiento().getEsnoco().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroSanciones.getEstablecimiento().getEsnoco().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(") AND t5.UANOCO IS NOT NULL ");
		}

		/* para la busqueda combinada */
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsnombre() != null) {
			// where.append(" AND UPPER(t5.UANOMBRE) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getEstablecimiento().getEsnombre()
			// .toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + filtroSanciones.getEstablecimiento().getEsnombre()
			// .toUpperCase() + "%");
			// }
			// where.append(" AND t5.UANOMBRE IS NOT NULL");
			where.append(" AND TRANSLATE(UPPER(t5.UANOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getEstablecimiento().getEsnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroSanciones.getEstablecimiento().getEsnombre().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t5.UANOMBRE IS NOT NULL ");
		}
		/*
		 * if (filtroSanciones != null && filtroSanciones.getEstablecimiento()
		 * != null && filtroSanciones.getEstablecimiento().getEsnombre() !=
		 * null) { where.append(" AND UPPER(t5.ESNOMBRE) like ? ESCAPE  '\\'");
		 * if (startsWith) {
		 * params.add(filtroSanciones.getEstablecimiento().getEsnombre()
		 * .toUpperCase() + "%"); } else { params.add("%" +
		 * filtroSanciones.getEstablecimiento().getEsnombre() .toUpperCase() +
		 * "%"); } where.append(" AND t5.ESNOMBRE IS NOT NULL"); }
		 */
		if (filtroSanciones != null && filtroSanciones.getProvinciaId() != null) {
			where.append(" AND t5.UAPROV_ID = ?");
			params.add(filtroSanciones.getProvinciaId());
		}
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND t5.UAPROV_ID = ?");
			params.add(filtroSanciones.getEstablecimiento().getEsnoraProvinciaId());
		}
		if (filtroSanciones != null && filtroSanciones.getMunicipioId() != null) {
			where.append(" AND t5.UAMUN_ID = ?");
			params.add(filtroSanciones.getMunicipioId());
		}
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND t5.UAMUN_ID = ?");
			params.add(filtroSanciones.getEstablecimiento().getEsnoraMunicipioId());
		}
		if (filtroSanciones != null && filtroSanciones.getLocalidadId() != null) {
			where.append(" AND t5.UALOC_ID = ?");
			params.add(filtroSanciones.getLocalidadId());
		}
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND t5.UALOC_ID = ?");
			params.add(filtroSanciones.getEstablecimiento().getEsnoraLocalidadId());
		}
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND t5.UAPAIS_ID = ?");
			params.add(filtroSanciones.getEstablecimiento().getEsnoraPaisId());
		}
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsdireccion_nocapv() != null) {
			// where.append(" AND UPPER(t5.UADIRE_NOCAPV) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getEstablecimiento()
			// .getEsdireccion_nocapv().toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + filtroSanciones.getEstablecimiento()
			// .getEsdireccion_nocapv().toUpperCase() + "%");
			// }
			// where.append(" AND t5.UADIRE_NOCAPV IS NOT NULL");
			where.append(" AND TRANSLATE(UPPER(t5.UADIRE_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						filtroSanciones.getEstablecimiento().getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
								+ "%");
			} else {
				params.add("%" + filtroSanciones.getEstablecimiento().getEsdireccion_nocapv().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E").replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U") + "%");
			}
			where.append(" AND t5.UADIRE_NOCAPV IS NOT NULL ");
		}
		/*
		 * if (filtroSanciones != null && filtroSanciones.getEstablecimiento()
		 * != null && filtroSanciones.getEstablecimiento().getEsextranjero() !=
		 * null) { where.append(" AND t5.ESEXTRANJERO = ?");
		 * params.add(filtroSanciones.getEstablecimiento().getEsextranjero()); }
		 */

		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsextranjero() != null
				&& filtroSanciones.getEstablecimiento().getEsextranjero() == Y41bConstantes.VALOR_SI) {
			// Incidencia 64305 - Si el campo pais es nulo se entiende que es
			// Espanya
			where.append(
					" AND (t5.UAPAIS_ID IS NOT NULL AND t5.UAPAIS_ID != '" + Y41bConstantes.COD_PAIS_ESTADO + "')");
		}

		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsestado() != null
				&& filtroSanciones.getEstablecimiento().getEsestado() == Y41bConstantes.VALOR_SI) {
			where.append(" AND t5.UAPAIS_ID = '" + Y41bConstantes.COD_PAIS_ESTADO + "'");
		}
		if (this.incluirFiltroTramites(filtroSanciones)) {
			where.append(" AND EXISTS (SELECT 1 FROM SANTRAMEXP t12 WHERE t12.TREXCODIGO=t1.EXCODIGO ");
			if (filtroSanciones != null && filtroSanciones.getIdFase() != null) {
				where.append(" AND t12.TRFCODIGO = ?");
				params.add(filtroSanciones.getIdFase());
			}
			if (filtroSanciones != null && filtroSanciones.getTramite() != null) {
				where.append(" AND t12.TRCODIGO = ?");
				params.add(filtroSanciones.getTramite());
			}
			if (filtroSanciones != null && filtroSanciones.getFechaTramitacionDesde() != null
					&& filtroSanciones.getFechaTramitacionDesde() instanceof Date) {
				where.append(" AND t12.TRFECINI >= ?");
				params.add(filtroSanciones.getFechaTramitacionDesde());
			}
			if (filtroSanciones != null && filtroSanciones.getFechaTramitacionHasta() != null
					&& filtroSanciones.getFechaTramitacionHasta() instanceof Date) {
				where.append(" AND t12.TRFECINI <= ?");
				params.add(filtroSanciones.getFechaTramitacionHasta());
			}
			if (filtroSanciones != null && true == filtroSanciones.getUltimoTramite()) {
				where.append(" AND t12.TRID = t2.EXTRPOSCOD ");
			}
			if (filtroSanciones != null && true == filtroSanciones.getAcuseRecibo()) {
				// Las comunicaciones dejan registro en envío pero no tienen
				// acuse
				where.append(" AND t6.ENTRID = t12.TRID AND T12.TRCODIGO != '");
				where.append(Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION);
				where.append("' AND t6.ENFECACUSE IS NULL ");
			}
			// Con pendiente firma
			if (filtroSanciones != null && true == filtroSanciones.getIndPendienteFirma()) {
				where.append(" AND t12.TRESTADO = ? ");
				params.add(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
			}

			if (filtroSanciones != null && filtroSanciones.getInstructor() != null) {
				where.append(" AND t12.TRMOCODIGO = ?");
				params.add(filtroSanciones.getInstructor());
			}
			where.append(" ) ");
		}

		if (filtroSanciones != null && filtroSanciones.getTipoResolucion() != null) {
			where.append(" AND t1.EXCOTTR = ?");
			params.add(filtroSanciones.getTipoResolucion());
		}

		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& (filtroSanciones.getConsumidor().getUanif() != null
						|| filtroSanciones.getConsumidor().getUanombre() != null
						|| filtroSanciones.getConsumidor().getUaapellido1() != null
						|| filtroSanciones.getConsumidor().getUaapellido2() != null
						|| filtroSanciones.getConsumidor().getUapaisId() != null
						|| filtroSanciones.getConsumidor().getUaprovId() != null
						|| filtroSanciones.getConsumidor().getUamunId() != null
						|| filtroSanciones.getConsumidor().getUalocId() != null
						|| filtroSanciones.getConsumidor().getUaextranjero() != null
						|| filtroSanciones.getConsumidor().getUaestado() != null
						|| filtroSanciones.getConsumidor().getUadtcodigo() != null)) {
			where.append(" AND t11.UATIPOINTERV = '" + Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO + "'");
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUanif() != null) {

			where.append(" AND UPPER(t11.UANIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getConsumidor().getUanif().toUpperCase() + "%");
			} else {
				params.add("%" + filtroSanciones.getConsumidor().getUanif().toUpperCase() + "%");
			}
			where.append(" AND t11.UANIF IS NOT NULL");
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUanombre() != null) {

			// where.append(" AND UPPER(t11.UANOMBRE) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getConsumidor().getUanombre()
			// .toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + filtroSanciones.getConsumidor().getUanombre()
			// .toUpperCase() + "%");
			// }
			// where.append(" AND t11.UANOMBRE IS NOT NULL");
			where.append(" AND TRANSLATE(UPPER(TRIM(t11.UANOMBRE)),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getConsumidor().getUanombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroSanciones.getConsumidor().getUanombre().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t11.UANOMBRE IS NOT NULL ");
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUaapellido1() != null) {

			// where.append(" AND UPPER(t11.UAAPELLIDO1) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getConsumidor().getUaapellido1()
			// .toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + filtroSanciones.getConsumidor().getUaapellido1()
			// .toUpperCase() + "%");
			// }
			// where.append(" AND t11.UAAPELLIDO1 IS NOT NULL");
			where.append(" AND TRANSLATE(UPPER(TRIM(t11.UAAPELLIDO1)),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getConsumidor().getUaapellido1().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroSanciones.getConsumidor().getUaapellido1().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t11.UAAPELLIDO1 IS NOT NULL ");
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUaapellido2() != null) {

			// where.append(" AND UPPER(t11.UAAPELLIDO2) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getConsumidor().getUaapellido2()
			// .toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + filtroSanciones.getConsumidor().getUaapellido2()
			// .toUpperCase() + "%");
			// }
			// where.append(" AND t11.UAAPELLIDO2 IS NOT NULL");
			where.append(" AND TRANSLATE(UPPER(TRIM(t11.UAAPELLIDO2)),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getConsumidor().getUaapellido2().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + filtroSanciones.getConsumidor().getUaapellido2().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t11.UAAPELLIDO2 IS NOT NULL ");
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUapaisId() != null) {
			where.append(" AND t11.UAPAIS_ID = ?");
			params.add(filtroSanciones.getConsumidor().getUapaisId());
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUaprovId() != null) {
			where.append(" AND t11.UAPROV_ID = ?");
			params.add(filtroSanciones.getConsumidor().getUaprovId());
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUamunId() != null) {
			where.append(" AND t11.UAMUN_ID = ?");
			params.add(filtroSanciones.getConsumidor().getUamunId());
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUalocId() != null) {
			where.append(" AND t11.UALOC_ID = ?");
			params.add(filtroSanciones.getConsumidor().getUalocId());
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUadtcodigo() != null) {
			where.append(" AND t11.UADTCODIGO = ?");
			params.add(filtroSanciones.getConsumidor().getUadtcodigo());
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUaextranjero() != null
				&& filtroSanciones.getConsumidor().getUaextranjero() == Y41bConstantes.VALOR_SI) {
			// Incidencia 64305 - Si el campo pais es nulo se entiende que es
			// Espanya
			where.append(
					" AND (t11.UAPAIS_ID IS NOT NULL AND t11.UAPAIS_ID != '" + Y41bConstantes.COD_PAIS_ESTADO + "')");
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUaestado() != null
				&& filtroSanciones.getConsumidor().getUaestado() == Y41bConstantes.VALOR_SI) {
			where.append(" AND t11.UAPAIS_ID = '" + Y41bConstantes.COD_PAIS_ESTADO + "'");
		}
		// EVOLUTIVO 0135083 2.7
		if (filtroSanciones != null && filtroSanciones.getInfracRelacionadas() != null) {
			where.append(" AND ( ");
			String[] arrayInfr = filtroSanciones.getInfracRelacionadas();
			String codigo = " ";
			for (int i = 0; i < arrayInfr.length; i++) {
				codigo = arrayInfr[i];
				if (i > 0) {
					where.append(" OR ");
				}
				where.append(" t27.HICOTTI='" + codigo + "'");
			}
			where.append(" ) ");
		}
		// EVOLUTIVO 0135083 2.7

		// EVOLUTIVO 0150942
		if (filtroSanciones.getPcodigo() != null) {
			if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(filtroSanciones.getPcodigo())) {
				where.append(
						" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1 WHERE AUX1.RLARBCODREL IS NOT NULL AND AUX1.RLESORIG='S' AND AUX1.RLEXCODIGO=t1.EXCODIGO) ");
			} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(filtroSanciones.getPcodigo())) {
				where.append(
						" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1, HECHO_DENUNCIADO AUX2 WHERE AUX1.RLHDCODREL IS NOT NULL AND AUX1.RLHDCODREL=AUX2.HDCODIGO AND AUX1.RLESORIG='S' AND AUX2.HDTIPODENUNCIANTE IS NULL AND AUX1.RLEXCODIGO=t1.EXCODIGO) ");
			} else if (filtroSanciones.getPcodigo().equals("DEN")) {
				where.append(
						" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1, HECHO_DENUNCIADO AUX2 WHERE AUX1.RLHDCODREL IS NOT NULL AND AUX1.RLHDCODREL=AUX2.HDCODIGO AND AUX1.RLESORIG='S' AND AUX2.HDTIPODENUNCIANTE IS NOT NULL AND AUX1.RLEXCODIGO=t1.EXCODIGO) ");
			} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(filtroSanciones.getPcodigo())) {
				if (filtroSanciones.getAccoororigen() != null) {
					where.append(
							" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1, ACTA AUX6, ACTUACION AUX7 WHERE AUX1.RLINSCODREL IS NOT NULL AND AUX1.RLESORIG='S' AND AUX1.RLEXCODIGO=t1.EXCODIGO AND AUX7.ATCODIGO=AUX1.RLINSCODREL AND AUX6.ACCODIGO=AUX7.ATCOAC ");

					if ("1".equals(filtroSanciones.getAccoororigen())) {
						where.append(" AND AUX7.ATCOCM IS NOT NULL ");
						if (filtroSanciones.getAtcocm() != null) {
							where.append(" AND TRANSLATE(UPPER(AUX7.ATCOCM),'','AEIOU') like ? ESCAPE  '\\' ");
							params.add("%" + filtroSanciones.getAtcocm().toUpperCase().replaceAll("", "A")
									.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
									+ "%");
						}
						where.append(") ");
					} else if ("2".equals(filtroSanciones.getAccoororigen())) {
						where.append(" AND AUX7.ATCOAL IS NOT NULL) ");
					} else if ("3".equals(filtroSanciones.getAccoororigen())) {
						where.append(" AND AUX7.ATIDCOMUNICACIONSOIVRE IS NOT NULL) ");
					} else if ("4".equals(filtroSanciones.getAccoororigen())) {
						where.append(" AND AUX7.ATCOHD IS NOT NULL AND AUX7.ATCOHDDENUNCIA IS NULL) ");
					} else if ("5".equals(filtroSanciones.getAccoororigen())) {
						where.append(" AND AUX7.ATCOHD IS NOT NULL AND AUX7.ATCOHDDENUNCIA IS NOT NULL) ");
					} else if ("6".equals(filtroSanciones.getAccoororigen())) {
						where.append(
								" AND AUX7.ATCOCM IS NULL AND AUX7.ATCOAL IS NULL AND AUX7.ATIDCOMUNICACIONSOIVRE IS NULL AND AUX7.ATCOHD IS NULL AND AUX6.ACTIORORIGEN IS NULL) ");
					} else if ("7".equals(filtroSanciones.getAccoororigen())) {
						where.append(" AND AUX6.ACTIORORIGEN = ?) ");
						params.add(Y41bConstantes.INSPECCION_ORIGEN_COMUNICACION_EXTERNA);
					} else if ("8".equals(filtroSanciones.getAccoororigen())) {
						where.append(" AND AUX6.ACTIORORIGEN = ?) ");
						params.add(Y41bConstantes.INSPECCION_ORIGEN_NOTIFICACION_PRODUCTORES);
					}
				} else {
					where.append(
							" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1 WHERE AUX1.RLINSCODREL IS NOT NULL AND AUX1.RLESORIG='S' AND AUX1.RLEXCODIGO=t1.EXCODIGO) ");
				}
			}
		}
		// EVOLUTIVO 0150942

		// TODO ODEI
		// Direccion NO CAV
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Expedien entity
	 * 
	 * @param expedien
	 *            Expedien Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA
	private Map<String, ?> getWhereLikeMapSancionesHistoricas(FiltroSanciones filtroSanciones, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ExpedienDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (filtroSanciones != null && filtroSanciones.getExcoor() != null
				&& filtroSanciones.getExcoor().length() < 6) {
			where.append(" AND UPPER(t1.EXCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getExcoor().toUpperCase() + "%");
			} else {
				params.add("%" + filtroSanciones.getExcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCOOR IS NOT NULL");
		} else if (filtroSanciones != null && filtroSanciones.getExcoor() != null) {
			where.append(" AND UPPER(t1.EXCOOR)=? ");
			params.add(filtroSanciones.getExcoor().toUpperCase());
		}
		if (filtroSanciones != null && filtroSanciones.getExnran() != null) {
			where.append(" AND t1.EXNRAN = ?");
			params.add(filtroSanciones.getExnran().intValue());
		}
		if (filtroSanciones != null && filtroSanciones.getExnror() != null) {
			where.append(" AND t1.EXNROR = ?");
			params.add(filtroSanciones.getExnror());
		}
		if (filtroSanciones != null && filtroSanciones.getResponsable() != null) {
			where.append(" AND t1.EXCOIT = ?");
			params.add(filtroSanciones.getResponsable());
		}
		if (filtroSanciones != null && filtroSanciones.getFechaIniDesde() != null
				&& filtroSanciones.getFechaIniDesde() instanceof Date) {
			where.append(" AND t1.EXFERE >= ?");
			params.add(filtroSanciones.getFechaIniDesde());
		}
		if (filtroSanciones != null && filtroSanciones.getFechaIniHasta() != null
				&& filtroSanciones.getFechaIniHasta() instanceof Date) {
			where.append(" AND t1.EXFERE <= ?");
			params.add(filtroSanciones.getFechaIniHasta());
		}

		if (filtroSanciones != null && filtroSanciones.getEstadoExpediente() != null) {
			if (Y41bConstantes.FILTROSANCIONES_EXPEDIENTE_ABIERTO.equals(filtroSanciones.getEstadoExpediente())) {
				where.append(" AND t1.EXFEAR IS NULL");
			} else if (Y41bConstantes.FILTROSANCIONES_EXPEDIENTE_CERRADO
					.equals(filtroSanciones.getEstadoExpediente())) {
				where.append(" AND t1.EXFEAR IS NOT NULL");
			}
		}

		/* TABLAS VIEJAS */
		if (filtroSanciones != null && filtroSanciones.getCifnif() != null) {
			where.append(" AND UPPER(t5.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getCifnif().toUpperCase() + "%");
			} else {
				params.add("%" + filtroSanciones.getCifnif().toUpperCase() + "%");
			}
			where.append(" AND t5.ESNIF IS NOT NULL");
		}
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsnif() != null) {
			where.append(" AND UPPER(t5.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getEstablecimiento().getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + filtroSanciones.getEstablecimiento().getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t5.ESNIF IS NOT NULL");
		}
		if (filtroSanciones != null && filtroSanciones.getConoco() != null) {
			// where.append(" AND (( UPPER(t5.ESNOCO) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getConoco().toUpperCase() + "%");
			// } else {
			// params.add("%" + filtroSanciones.getConoco().toUpperCase()
			// + "%");
			// }
			// where.append(" AND t5.ESNOCO IS NOT NULL ");
			where.append(" AND ((TRANSLATE(UPPER(t5.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getConoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + filtroSanciones.getConoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t5.ESNOCO IS NOT NULL ");
			where.append(" ) OR ( ");
			// where.append(" UPPER(t5.ESNOMBRE) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getConoco().toUpperCase() + "%");
			// } else {
			// params.add("%" + filtroSanciones.getConoco().toUpperCase()
			// + "%");
			// }
			// where.append(" AND t5.ESNOMBRE IS NOT NULL ))");
			where.append(" TRANSLATE(UPPER(t5.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getConoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + filtroSanciones.getConoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t5.ESNOMBRE IS NOT NULL ))");
		}

		/* para la busqueda combinada */
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsnombre() != null) {
			// where.append(" AND (( UPPER(t5.ESNOCO) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getEstablecimiento().getEsnombre()
			// .toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + filtroSanciones.getEstablecimiento().getEsnombre()
			// .toUpperCase() + "%");
			// }
			// where.append(" AND t5.ESNOCO IS NOT NULL ");
			where.append(" AND ((TRANSLATE(UPPER(t5.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getEstablecimiento().getEsnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroSanciones.getEstablecimiento().getEsnombre().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t5.ESNOCO IS NOT NULL ");
			where.append(" ) OR ( ");
			// where.append(" UPPER(t5.ESNOMBRE) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getEstablecimiento().getEsnombre()
			// .toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + filtroSanciones.getEstablecimiento().getEsnombre()
			// .toUpperCase() + "%");
			// }
			// where.append(" AND t5.ESNOMBRE IS NOT NULL ))");
			where.append(" TRANSLATE(UPPER(t5.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getEstablecimiento().getEsnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroSanciones.getEstablecimiento().getEsnombre().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t5.ESNOMBRE IS NOT NULL ))");
		}

		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsnoco() != null) {
			// where.append(" AND (( UPPER(t5.ESNOCO) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getEstablecimiento().getEsnoco()
			// .toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + filtroSanciones.getEstablecimiento().getEsnoco()
			// .toUpperCase() + "%");
			// }
			// where.append(" AND t5.ESNOCO IS NOT NULL ");
			where.append(" AND ((TRANSLATE(UPPER(t5.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getEstablecimiento().getEsnoco().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroSanciones.getEstablecimiento().getEsnoco().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t5.ESNOCO IS NOT NULL ");
			where.append(" ) OR ( ");
			// where.append(" UPPER(t5.ESNOMBRE) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getEstablecimiento().getEsnoco()
			// .toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + filtroSanciones.getEstablecimiento().getEsnoco()
			// .toUpperCase() + "%");
			// }
			// where.append(" AND t5.ESNOMBRE IS NOT NULL ))");
			where.append(" TRANSLATE(UPPER(t5.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getEstablecimiento().getEsnoco().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroSanciones.getEstablecimiento().getEsnoco().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t5.ESNOMBRE IS NOT NULL ))");
		}
		if (filtroSanciones != null && filtroSanciones.getProvinciaId() != null) {
			where.append(" AND t5.ESNORA_PROVINCIA_ID = ?");
			params.add(filtroSanciones.getProvinciaId());
		}
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND t5.ESNORA_PROVINCIA_ID = ?");
			params.add(filtroSanciones.getEstablecimiento().getEsnoraProvinciaId());
		}
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t5.ESCODIGO = ?");
			params.add(filtroSanciones.getEstablecimiento().getEscodigo());
		}
		if (filtroSanciones != null && filtroSanciones.getMunicipioId() != null) {
			where.append(" AND t5.ESNORA_MUNICIPIO_ID = ?");
			params.add(filtroSanciones.getMunicipioId());
		}
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND t5.ESNORA_MUNICIPIO_ID = ?");
			params.add(filtroSanciones.getEstablecimiento().getEsnoraMunicipioId());
		}
		if (filtroSanciones != null && filtroSanciones.getLocalidadId() != null) {
			where.append(" AND t5.ESNORA_LOCALIDAD_ID = ?");
			params.add(filtroSanciones.getLocalidadId());
		}
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND t5.ESNORA_LOCALIDAD_ID = ?");
			params.add(filtroSanciones.getEstablecimiento().getEsnoraLocalidadId());
		}
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND t5.ESNORA_PAIS_ID = ?");
			params.add(filtroSanciones.getEstablecimiento().getEsnoraPaisId());
		}
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t5.ESCODIGO = ?");
			params.add(filtroSanciones.getEstablecimiento().getEscodigo());
		}
		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsdireccion_nocapv() != null) {
			// where.append(" AND UPPER(t5.ESDIRECCION_NOCAPV) like ? ESCAPE
			// '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getEstablecimiento()
			// .getEsdireccion_nocapv().toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + filtroSanciones.getEstablecimiento()
			// .getEsdireccion_nocapv().toUpperCase() + "%");
			// }
			// where.append(" AND t5.ESDIRECCION_NOCAPV IS NOT NULL");
			where.append(" AND TRANSLATE(UPPER(t5.ESDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						filtroSanciones.getEstablecimiento().getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
								+ "%");
			} else {
				params.add("%" + filtroSanciones.getEstablecimiento().getEsdireccion_nocapv().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E").replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U") + "%");
			}
			where.append(" AND t5.ESDIRECCION_NOCAPV IS NOT NULL");
		}
		/*
		 * if (filtroSanciones != null && filtroSanciones.getEstablecimiento()
		 * != null && filtroSanciones.getEstablecimiento().getEsextranjero() !=
		 * null) { where.append(" AND t5.ESEXTRANJERO = ?");
		 * params.add(filtroSanciones.getEstablecimiento().getEsextranjero()); }
		 */

		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsextranjero() != null
				&& filtroSanciones.getEstablecimiento().getEsextranjero() == Y41bConstantes.VALOR_SI) {
			// where.append(" AND (t5.ESNORA_PAIS_ID IS NULL OR
			// t5.ESNORA_PAIS_ID != '"
			// + Y41bConstantes.COD_PAIS_ESTADO + "')");
			where.append(" AND t5.ESEXTRANJERO='" + Y41bConstantes.VALOR_SI + "'");
		}

		if (filtroSanciones != null && filtroSanciones.getEstablecimiento() != null
				&& filtroSanciones.getEstablecimiento().getEsestado() != null
				&& filtroSanciones.getEstablecimiento().getEsestado() == Y41bConstantes.VALOR_SI) {
			where.append(" AND t5.ESNORA_PAIS_ID = '" + Y41bConstantes.COD_PAIS_ESTADO + "'");
		}

		/*
		 * if (filtroSanciones != null && filtroSanciones.getIdFase() != null) {
		 * where.append(" AND t3.FCODIGO = ?");
		 * params.add(filtroSanciones.getIdFase()); } if (filtroSanciones !=
		 * null && filtroSanciones.getTramite() != null) {
		 * where.append(" AND t10.TRCODIGO = ?");
		 * params.add(filtroSanciones.getTramite()); }
		 */
		if (filtroSanciones != null && filtroSanciones.getTipoResolucion() != null) {
			where.append(" AND t1.EXCOTTR = ?");
			params.add(filtroSanciones.getTipoResolucion());
		}
		if (filtroSanciones != null && filtroSanciones.getInstructor() != null) {
			// where.append(" AND t2.EXMOCODIGO = ?");
			where.append(" AND t1.EXCOIT = ?");
			params.add(filtroSanciones.getInstructor());
		}
		/*
		 * if (filtroSanciones != null &&
		 * filtroSanciones.getFechaTramitacionDesde() != null &&
		 * filtroSanciones.getFechaTramitacionDesde() instanceof Date) {
		 * where.append(" AND t10.TRFECINI >= ?");
		 * params.add(filtroSanciones.getFechaTramitacionDesde()); } if
		 * (filtroSanciones != null &&
		 * filtroSanciones.getFechaTramitacionHasta() != null &&
		 * filtroSanciones.getFechaTramitacionHasta() instanceof Date) {
		 * where.append(" AND t10.TRFECINI <= ?");
		 * params.add(filtroSanciones.getFechaTramitacionHasta()); } if
		 * (filtroSanciones != null && true ==
		 * filtroSanciones.getUltimoTramite()) {
		 * where.append(" AND t10.TRID = t2.EXTRPOSCOD "); } if (filtroSanciones
		 * != null && true == filtroSanciones.getAcuseRecibo()) { // Las
		 * comunicaciones dejan registro en envío pero no tienen // acuse
		 * where.append(" AND t6.ENTRID = t10.TRID AND t10.TRCODIGO != '");
		 * where.append(Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION);
		 * where.append("' AND t6.ENFECACUSE IS NULL "); } // Con pendiente
		 * firma if (filtroSanciones != null && true ==
		 * filtroSanciones.getIndPendienteFirma()) {
		 * where.append(" AND t10.TRESTADO = ? ");
		 * params.add(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA); }
		 */
		/*
		 * si le he metido el dato del dtcodigo no tiene que salir para la
		 * busqueda combinada de solicitudes
		 */
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUadtcodigo() != null) {
			where.append(" AND 1 = 0");
		}

		/* consumidores */

		// if (filtroSanciones != null
		// && filtroSanciones.getConsumidor() != null
		// && (filtroSanciones.getConsumidor().getUanif() != null
		// || filtroSanciones.getConsumidor().getUanombre() != null
		// || filtroSanciones.getConsumidor().getUaapellido1() != null
		// || filtroSanciones.getConsumidor().getUaApellido2() != null
		// || filtroSanciones.getConsumidor().getUapaisId() != null
		// || filtroSanciones.getConsumidor().getUaprovId() != null
		// || filtroSanciones.getConsumidor().getUamunId() != null
		// || filtroSanciones.getConsumidor().getUalocId() != null
		// || filtroSanciones.getConsumidor().getUaextranjero() != null ||
		// filtroSanciones
		// .getConsumidor().getUaestado() != null)) {
		// where.append(" AND t11.UATIPOINTERV = '"
		// + Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO + "'");
		// }
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUanif() != null) {

			where.append(" AND UPPER(t12.DTNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getConsumidor().getUanif().toUpperCase() + "%");
			} else {
				params.add("%" + filtroSanciones.getConsumidor().getUanif().toUpperCase() + "%");
			}
			where.append(" AND t12.DTNIF IS NOT NULL");
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUanombre() != null) {

			// where.append(" AND UPPER(t12.DTNOMBRE) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getConsumidor().getUanombre()
			// .toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + filtroSanciones.getConsumidor().getUanombre()
			// .toUpperCase() + "%");
			// }
			// where.append(" AND t12.DTNOMBRE IS NOT NULL");
			where.append(" AND TRANSLATE(UPPER(t12.DTNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getConsumidor().getUanombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroSanciones.getConsumidor().getUanombre().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t12.DTNOMBRE IS NOT NULL ");
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUaapellido1() != null) {

			// where.append(" AND UPPER(t12.DTAPELLIDO1) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getConsumidor().getUaapellido1()
			// .toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + filtroSanciones.getConsumidor().getUaapellido1()
			// .toUpperCase() + "%");
			// }
			// where.append(" AND t12.DTAPELLIDO1 IS NOT NULL");
			where.append(" AND TRANSLATE(UPPER(t12.DTAPELLIDO1),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getConsumidor().getUaapellido1().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroSanciones.getConsumidor().getUaapellido1().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t12.DTAPELLIDO1 IS NOT NULL ");
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUaapellido2() != null) {

			// where.append(" AND UPPER(t12.DTAPELLIDO2) like ? ESCAPE '\\'");
			// if (startsWith) {
			// params.add(filtroSanciones.getConsumidor().getUaapellido2()
			// .toUpperCase()
			// + "%");
			// } else {
			// params.add("%"
			// + filtroSanciones.getConsumidor().getUaapellido2()
			// .toUpperCase() + "%");
			// }
			// where.append(" AND t12.DTAPELLIDO2 IS NOT NULL");
			where.append(" AND TRANSLATE(UPPER(t12.DTAPELLIDO2),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroSanciones.getConsumidor().getUaapellido2().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroSanciones.getConsumidor().getUaapellido2().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t12.DTAPELLIDO2 IS NOT NULL ");
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUapaisId() != null) {
			where.append(" AND t12.DTNORA_PAIS_ID = ?");
			params.add(filtroSanciones.getConsumidor().getUapaisId());
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUaprovId() != null) {
			where.append(" AND t12.DTNORA_PROVINCIA_ID = ?");
			params.add(filtroSanciones.getConsumidor().getUaprovId());
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUamunId() != null) {
			where.append(" AND t12.DTNORA_MUNICIPIO_ID = ?");
			params.add(filtroSanciones.getConsumidor().getUamunId());
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUalocId() != null) {
			where.append(" AND t12.DTNORA_LOCALIDAD_ID = ?");
			params.add(filtroSanciones.getConsumidor().getUalocId());
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUaextranjero() != null
				&& filtroSanciones.getConsumidor().getUaextranjero() == Y41bConstantes.VALOR_SI) {
			// where.append(" AND (t12.DTNORA_PAIS_ID IS NULL OR
			// t12.DTNORA_PAIS_ID != '"
			// + Y41bConstantes.COD_PAIS_ESTADO + "')");
			where.append(" AND t12.DTEXTRANJERO='" + Y41bConstantes.VALOR_SI + "'");
		}
		if (filtroSanciones != null && filtroSanciones.getConsumidor() != null
				&& filtroSanciones.getConsumidor().getUaestado() != null
				&& filtroSanciones.getConsumidor().getUaestado() == Y41bConstantes.VALOR_SI) {
			where.append(" AND t12.DTNORA_PAIS_ID = '" + Y41bConstantes.COD_PAIS_ESTADO + "'");
		}
		// EVOLUTIVO 0135083 2.7
		if (filtroSanciones != null && filtroSanciones.getInfracRelacionadas() != null) {
			where.append(" AND ( ");
			String[] arrayInfr = filtroSanciones.getInfracRelacionadas();
			String codigo = " ";
			for (int i = 0; i < arrayInfr.length; i++) {
				codigo = arrayInfr[i];
				if (i > 0) {
					where.append(" OR ");
				}
				where.append(" t27.HICOTTI='" + codigo + "'");
			}
			where.append(" ) ");
		}
		// EVOLUTIVO 0135083 2.7
		// TODO ODEI
		// Direccion NO CAV
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	@Override
	public Long findAllCountSanciones(FiltroSanciones filtroSanciones) {

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM (SELECT DISTINCT t1.EXCODIGO, t1.EXCOOR, t1.EXNRAN, t1.EXNROR, t1.EXFERE, t1.EXCOIT, t1.EXCOES, t1.EXINEXVA, t2.EXCODIGO, t2.EXDESCES, t2.EXDESCEU, t2.EXFECPREVFIN, t2.EXFECFIN, t2.EXTIPRES, t2.EXMOCODIGO, t2.EXFCODIGO, t2.EXMOCODIGOULT, t2.EXTRPOSCOD, t2.EXTRENTIDAD, t2.EXLIQESTADO, t2.EXLIQAPREMIO, t3.fcodigo, t3.fnombre, t3.fnombree, t5.ESNOMBRE, t5.ESNORA_MUNICIPIO_ID, (SELECT DS_O FROM T17I.T17_MUNICIPIO WHERE T5.ESNORA_PROVINCIA_ID = PROVINCIA_ID AND t5.ESNORA_MUNICIPIO_ID = ID), t7.MOCODIGO, t7.MONOMBRE, t10.TRCODIGO, t10.TRNOMBRE, t10.TRNOMBREE, /*t10.TROBSERVES,*/ t10.TRNOMTRAMES FROM EXPEDIEN t1 , SANEXP t2, FASE t3, ESTABLECIMIENTO t5, SANENVIO t6, CENSO_MONITOR t7, (SELECT T8.TRID, T9.TRNOMBRE, T9.TRNOMBREE,/*T8.TROBSERVES,*/ T8.TRNOMTRAMES, T8.TRCODIGO, t8.TRFECCIERRE, T8.TRRESOTIPO, T8.TRFECINI FROM SANTRAMEXP T8, TRAMITE T9 WHERE T9.TRCODIGO= T8.TRCODIGO) t10 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapSanciones(filtroSanciones);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.EXCODIGO= t2.EXCODIGO(+) AND t2.exfcodigo = t3.fcodigo(+) AND t1.EXCOES= t5.ESCODIGO(+) AND t1.EXCODIGO = t6.ENEXID(+) AND t2.EXMOCODIGO = t7.MOCODIGO(+) AND t2.EXTRPOSCOD = t10.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(")");
		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	@Override
	public Long findAllLikeCountSanciones(FiltroSanciones filtroSanciones, Boolean startsWith) {

		StringBuilder query = new StringBuilder("( SELECT COUNT (DISTINCT T1.EXCODIGO) " + getFromBusquedaSanciones());

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapSanciones(filtroSanciones, startsWith);
		StringBuilder where = new StringBuilder(getWhereBusquedaSanciones());

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(")");

		List<?> params = (List<?>) mapaWhere.get("params");

		Long resultado1 = this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
		Long resultado2 = 0L;
		// Si estamos buscando por fase-tramite, cerrado, ...
		// no deben aparecer los expedientes antiguos porque no tienen
		// tramitacion
		if (this.incluirBusquedaViejos(filtroSanciones) && (filtroSanciones.getEstadoExpediente() == null
				|| !Y41bConstantes.FILTROSANCIONES_EXPEDIENTE_CERRADO.equals(filtroSanciones.getEstadoExpediente()))) {
			StringBuilder query2 = new StringBuilder(
					"( SELECT COUNT (DISTINCT T1.EXCODIGO) " + getFromBusquedaSancionesHist());

			// Where clause & Params
			Map<String, ?> mapaWhere2 = this.getWhereLikeMapSancionesHistoricas(filtroSanciones, startsWith);
			StringBuilder where2 = new StringBuilder(getWhereBusquedaSancionesHist());
			where2.append(mapaWhere2.get("query"));
			query2.append(where2);
			query2.append(")");

			List<?> params2 = ((List<?>) mapaWhere2.get("params"));
			resultado2 = this.jdbcTemplate.queryForLong(query2.toString(), params2.toArray());
		}

		return resultado1 + resultado2;
	}

	@Override
	public List<FiltroSanciones> findAllSancionesRelacionar(FiltroSanciones filtroSanciones, String excodigo,
			String relacionados, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.EXCODIGO EXCODIGO, t1.EXCOOR EXCOOR, t1.EXNRAN EXNRAN, t1.EXNROR EXNROR,  LPAD(T1.EXNROR,12,'0')  CORRELATIVOPAD,t1.EXFERE EXFERE, t1.EXCOIT EXCOIT, t1.EXCOES EXCOES, t1.EXINEXVA EXINEXVA, t2.EXCODIGO SANEXPEXCODIGO, t2.HDFECHD SANEXPHDFECHD, t2.EXDESCES SANEXPEXDESCES, t2.EXDESCEU SANEXPEXDESCEU, t2.EXFECPREVFIN SANEXPEXFECPREVFIN, t2.EXFECFIN SANEXPEXFECFIN, t2.EXTIPRES SANEXPEXTIPRES, t2.EXMOCODIGO SANEXPEXMOCODIGO, t2.EXFCODIGO SANEXPEXFCODIGO, t2.EXMOCODIGOULT SANEXPEXMOCODIGOULT, t2.EXTRPOSCOD SANEXPEXTRPOSCOD, t2.EXLIQESTADO SANEXPEXLIQESTADO, t2.EXLIQAPREMIO SANEXPEXLIQAPREMIO,t2.EXCOORACTUAL EXCOORACTUAL, t2.EXDESTNOTIFSANCIONADO EXDESTNOTIFSANCIONADO, t2.EXVERIFSANC EXVERIFSANC, t2.EXVERIFINCO EXVERIFINCO, t3.MOCODIGO monitorMOCODIGO, t3.MONOMBRE monitorMONOMBRE "
						+ "FROM EXPEDIEN t1 , SANEXP t2, CENSO_MONITOR t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapRelacionarExpedientes(filtroSanciones);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.EXCODIGO= t2.EXCODIGO(+) and t1.EXCOIT = t3.MOCODIGO ");
		where.append(" and t1.EXCODIGO <> '").append(excodigo).append("'");
		if (!"".equals(relacionados)) {
			String[] arrayValores = relacionados.split(",");
			for (int i = 0; i < arrayValores.length; i++) {
				where.append("AND t1.EXCODIGO <> '").append(arrayValores[i]).append("'");
			}
		}
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<FiltroSanciones>) this.jdbcTemplate.query(query.toString(), this.rwMapBusquedaSancionesRel,
				params.toArray());

	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Expedien entity
	 * 
	 * @param expedien
	 *            Expedien Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA
	private Map<String, ?> getWhereMapRelacionarExpedientes(FiltroSanciones filtroSanciones) {

		StringBuilder where = new StringBuilder(ExpedienDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (filtroSanciones != null && filtroSanciones.getExcoor() != null) {
			where.append(" AND UPPER(t1.EXCOOR) like ? ESCAPE  '\\'");
			params.add("%" + filtroSanciones.getExcoor().toUpperCase() + "%");
			where.append(" AND t1.EXCOOR IS NOT NULL");
		}
		if (filtroSanciones != null && filtroSanciones.getExnran() != null) {
			where.append(" AND t1.EXNRAN = ?");
			params.add(filtroSanciones.getExnran());
		}
		if (filtroSanciones != null && filtroSanciones.getExnror() != null) {
			where.append(" AND t1.EXNROR = ?");
			params.add(filtroSanciones.getExnror());
		}
		if (filtroSanciones != null && filtroSanciones.getFechaIniDesde() != null
				&& filtroSanciones.getFechaIniDesde() instanceof Date) {
			where.append(" AND t1.EXFERE >= ?");
			params.add(filtroSanciones.getFechaIniDesde());
		}
		if (filtroSanciones != null && filtroSanciones.getFechaIniHasta() != null
				&& filtroSanciones.getFechaIniHasta() instanceof Date) {
			where.append(" AND t1.EXFERE <= ?");
			params.add(filtroSanciones.getFechaIniHasta());
		}

		if (filtroSanciones != null && filtroSanciones.getFechaHechoDesde() != null
				&& filtroSanciones.getFechaHechoDesde() instanceof Date) {
			where.append(" AND t2.HDFECHD >= ?");
			params.add(filtroSanciones.getFechaHechoDesde());
		}
		if (filtroSanciones != null && filtroSanciones.getFechaHechoHasta() != null
				&& filtroSanciones.getFechaHechoHasta() instanceof Date) {
			where.append(" AND t2.HDFECHD <= ?");
			params.add(filtroSanciones.getFechaHechoHasta());
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	@Override
	public Long findAllCountSancionesRelacionar(FiltroSanciones filtroSanciones, String excodigo, String relacionados) {

		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM EXPEDIEN t1 , SANEXP t2, CENSO_MONITOR t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapRelacionarExpedientes(filtroSanciones);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.EXCODIGO= t2.EXCODIGO(+) and t1.EXCOIT = t3.MOCODIGO ");

		where.append(" and t1.EXCODIGO <> '").append(excodigo).append("'");
		if (!"".equals(relacionados)) {
			String[] arrayValores = relacionados.split(",");
			for (int i = 0; i < arrayValores.length; i++) {
				where.append("AND t1.EXCODIGO <> '").append(arrayValores[i]).append("'");
			}
		}
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds EXNROR
	 * 
	 * @param expedien
	 *            Pagination
	 * @return long
	 */
	public long findExnrorSig(Expedien expedien) {
		String query = "SELECT  MAX(t1.EXNROR)+1 " + "FROM EXPEDIEN t1   " + "WHERE t1.EXCOOR = ?   AND t1.EXNRAN= ? ";

		List<Object> params = new ArrayList<Object>();
		params.add(expedien.getExcoor());
		params.add(expedien.getExnran());

		long correlativo = 0;
		correlativo = this.jdbcTemplate.queryForLong(query, params.toArray());

		if (correlativo == 0) {
			correlativo = 1;
		}
		return correlativo;
	}

	/**
	 * Expedientes con recursos.
	 * 
	 * @param expedien
	 *            the expedien
	 * @return the list
	 */
	public int expedientesConRecursos(Expedien expedien, Saninterv saninterv) {
		StringBuilder query = new StringBuilder("SELECT COUNT(T1.EXCODIGO) " + " FROM  EXPEDIEN T1 "
				+ " WHERE T1.EXCODIGO <> ? AND T1.EXCOES = ? "
				+ " AND ((EXISTS ( SELECT REFEREOR FROM RECURSO WHERE RECOEX = T1.EXCODIGO AND REFEREOR IS NOT NULL AND ADD_MONTHS(REFEREOR,12) >= SYSDATE)) OR (ADD_MONTHS(EXFERES,1) <= sysdate AND ADD_MONTHS(EXFERES,12) >= SYSDATE)) ");

		List<Object> params = new ArrayList<Object>();
		params.add(expedien.getExcodigo());
		params.add(saninterv.getUaescodigo());

		return this.jdbcTemplate.queryForInt(query.toString(), params.toArray());

	}

	/**
	 * Expedientes con recursos.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param saninterv
	 *            the saninterv
	 * @param pagination
	 *            the pagination
	 * @return the list
	 */
	public List<Expedien> listExpedientesConRecursos(Expedien expedien, Saninterv saninterv, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.EXCODIGO expedienEXCODIGO,t1.EXCOOR EXCOOR, LPAD(T1.EXNROR,12,'0')  CORRELATIVOPAD, t1.EXNRAN EXNRAN,t1.EXNROR EXNROR,t1.EXFERE EXFERE,t1.EXCOIT EXCOIT,t1.EXCOES EXCOES,t1.EXFEACIN EXFEACIN,t1.EXFEEMCA EXFEEMCA,t1.EXFEPLCA EXFEPLCA,t1.EXFPNOPC EXFPNOPC,t1.EXFEDE EXFEDE,t1.EXFECOAL EXFECOAL,t1.EXFENOPR EXFENOPR,t1.EXFEPUPR EXFEPUPR,t1.EXCOOSPR EXCOOSPR,t1.EXFEALPR EXFEALPR,t1.EXFEEL EXFEEL,t1.EXFERES EXFERES,t1.EXFENORE EXFENORE,t1.EXFEPURE EXFEPURE,t1.EXCOOSRE EXCOOSRE,t1.EXCOTTR EXCOTTR,t1.EXCAMURE EXCAMURE,t1.EXFETA EXFETA,t1.EXCOTSA EXCOTSA,t1.EXFECROI EXFECROI,t1.EXFEAR EXFEAR,t1.EXCOORIE EXCOORIE,t1.EXINRE EXINRE,t1.EXINCOCO EXINCOCO,t1.EXINEXVA EXINEXVA,t1.EXFECIRC EXFECIRC,t1.EXFENOAI EXFENOAI,t1.EXFECOLM EXFECOLM,t1.EXNUINLM EXNUINLM,t1.EXFEINMU EXFEINMU,t1.EXFEAVMU EXFEAVMU,t1.EXFEIMCD EXFEIMCD,t1.EXFECEDE EXFECEDE,t1.EXCOPS EXCOPS,t1.EXCOSE EXCOSE, t2.EXIMPORTE EXIMPORTE, t2.EXCOORACTUAL EXCOORACTUAL, t3.REFEREOR REFEREOR"
						+ " FROM  EXPEDIEN T1, SANEXP T2, RECURSO T3 "
						+ " WHERE T1.EXCODIGO <> ? AND T1.EXCOES = ? AND T1.EXCODIGO = T2.EXCODIGO(+) AND T1.EXCODIGO = T3.RECOEX(+) "
						+ " AND ((EXISTS ( SELECT REFEREOR FROM RECURSO WHERE RECOEX = T1.EXCODIGO AND REFEREOR IS NOT NULL AND ADD_MONTHS(REFEREOR,12) >= SYSDATE)) OR (ADD_MONTHS(EXFERES,1) <= sysdate AND ADD_MONTHS(EXFERES,12) >= SYSDATE)) ");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		List<Object> params = new ArrayList<Object>();
		params.add(expedien.getExcodigo());
		params.add(saninterv.getUaescodigo());
		return (List<Expedien>) this.jdbcTemplate.query(query.toString(), this.rwMapExpedienSentenciaFirme,
				params.toArray());
	}

	// EVOLUTIVO 0135083 2.7 SE ANIADEN LAS TABLAS T27 Y T28 PARA PODER BUSCAR
	// POR INFRACCIONES EN EL BUSCADOR
	private String getWhereBusquedaSanciones() {
		return " WHERE 1=1 AND t1.EXCODIGO= t2.EXCODIGO(+) AND t2.exfcodigo = t3.fcodigo(+) AND T5.UAEXCODIGO = T1.EXCODIGO AND t1.EXCOES= t5.UAESCODIGO(+) AND t1.EXCODIGO = t6.ENEXID(+) AND t2.EXMOCODIGO = t7.MOCODIGO(+) AND t2.EXTRPOSCOD = t10.TRID(+) AND t11.UAEXCODIGO(+) = t1.EXCODIGO AND t1.EXCOTTR = t14.TTRCODIGO(+) and t5.UATIPOINTERV = '"
				+ Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO
				+ "' AND t2.extipres= t13.decodigo(+) AND t1.EXCODIGO = t28.DXCOEX(+)  AND t28.DXCOHI = t27.HICODIGO(+) ";
	}

	private String getFromBusquedaSanciones() {
		return "FROM EXPEDIEN t1 , SANEXP t2, FASE t3, SANINTERV t5, SANENVIO t6, CENSO_MONITOR t7, (SELECT T8.TRID, T9.TRNOMBRE, T9.TRNOMBREE, /*T8.TROBSERVES,*/ T8.TRNOMTRAMES, T8.TRCODIGO, t8.TRFECCIERRE, T8.TRRESOTIPO, T8.TRFECINI FROM SANTRAMEXP T8, TRAMITE T9 WHERE T9.TRCODIGO= T8.TRCODIGO) t10, SANINTERV T11, DECISION t13, TCTIPRES t14, INFRACC_HECHO_DEN_EXP_SANC t28, INFRACC_HECHO_DEN t27";
	}

	private String getWhereBusquedaSancionesHist() {
		return " WHERE 1=1 AND t1.EXCOES= t5.ESCODIGO(+) AND t1.EXCOIT = t7.MOCODIGO(+) "
				+ " AND NOT EXISTS (SELECT UAIDINTERV FROM SANINTERV WHERE UAESCODIGO = t1.EXCOES AND UAEXCODIGO = T1.EXCODIGO) AND t1.EXCODIGO = t11.CODIGOEXPEDIENTE(+) AND t12.DTCODIGO(+) = t11.CODIGODENUNCIANTE   AND T1.EXCOTTR = T14.TTRCODIGO(+) AND t1.EXCODIGO = t28.DXCOEX(+)  AND t28.DXCOHI = t27.HICODIGO(+) ";
	}

	private String getFromBusquedaSancionesHist() {
		return "FROM EXPEDIEN t1 , ESTABLECIMIENTO t5, CENSO_MONITOR t7, EXPEDIEN_DENUNCIANTE t11, CONSUMIDOR t12, DECISION t13, TCTIPRES t14, INFRACC_HECHO_DEN_EXP_SANC t28, INFRACC_HECHO_DEN t27 ";
	}

	/**
	 * Get a New PK (Esperas).
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewEsperaPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT L2123Q00.NEXTVAL FROM DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	private RowMapper<FiltroSanciones> rwMapSancionesViaApremio = new RowMapper<FiltroSanciones>() {
		public FiltroSanciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Establecimiento establecimiento = null;
			establecimiento = new Establecimiento(resultSet.getString("UAESCODIGO"), resultSet.getString("UANOMBRE"),
					resultSet.getString("UANIF"), null);

			FiltroSanciones filtroSanciones = new FiltroSanciones(resultSet.getString("EXCODIGO"),
					resultSet.getString("EXCOOR"), resultSet.getBigDecimal("EXNRAN"), resultSet.getBigDecimal("EXNROR"),
					resultSet.getString("EXCOOR") + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ resultSet.getBigDecimal("EXNROR") + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ resultSet.getBigDecimal("EXNRAN"),
					null, null, establecimiento, null, null, null, null, null, null, null, null);
			filtroSanciones.setExcamure(resultSet.getBigDecimal("EXCAMURE"));
			filtroSanciones.setImportePendiente(resultSet.getBigDecimal("IMPORTEPENDIENTE") == null ? null
					: Y41bUtils.formatearAEuros(resultSet.getBigDecimal("IMPORTEPENDIENTE")));
			filtroSanciones.setFechaEnvioReso(resultSet.getDate("RESOLUCIONENFECENVIO"));
			filtroSanciones.setFechaNotiReso(resultSet.getDate("RESOLUCIONENFECACUSE"));
			filtroSanciones.setFechaPresentacionRA(resultSet.getDate("RECURSOALZADAFECENVIO"));
			filtroSanciones.setFechaNotiRA(resultSet.getDate("ORDENCONSEJEROENFECACUSE"));
			filtroSanciones.setSinLiquidacionesFirmes(resultSet.getBoolean("SINLIQFIRME"));
			filtroSanciones.setResolucionRAes(resultSet.getString("ORDENCONSEJERODENOMBRE"));
			filtroSanciones.setResolucionRAeu(resultSet.getString("ORDENCONSEJERODENOMBREE"));

			return filtroSanciones;
		}
	};

	private StringBuilder getQueryFindAllSancionesViaApremio() {
		StringBuilder query = new StringBuilder("");
		query.append("SELECT DISTINCT t1.EXCOOR EXCOOR,t1.EXNRAN EXNRAN,t1.EXNROR EXNROR, t1.EXCOOR || '");
		query.append(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP);
		query.append("' || t1.EXNROR || '");
		query.append(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP);
		query.append("' || t1.EXNRAN CODCOMPLETO , t1.EXCODIGO EXCODIGO, LPAD(T1.EXNROR,12,'0') CORRELATIVOPAD, ");
		query.append(" t1.EXCAMURE EXCAMURE,t1.EXCAMURE-NVL(PAGADO.IMPORTE,0) IMPORTEPENDIENTE, ");
		query.append(" t2.UANOMBRE UANOMBRE,t2.UANIF UANIF,t2.UAESCODIGO UAESCODIGO, ");
		query.append(" RESOLUCION.ENFECENVIO RESOLUCIONENFECENVIO,RESOLUCION.ENFECACUSE RESOLUCIONENFECACUSE, ");
		query.append(" RECURSOALZADA.TRFECENVIO RECURSOALZADAFECENVIO,");
		query.append(
				" ORDENCONSEJERO.TRRESOTIPO ORDENCONSEJEROTRRESOTIPO,ORDENCONSEJERO.DENOMBRE ORDENCONSEJERODENOMBRE,ORDENCONSEJERO.DENOMBREE ORDENCONSEJERODENOMBREE,ORDENCONSEJERO.ENFECACUSE ORDENCONSEJEROENFECACUSE, CASE WHEN TCONLIQFIRME.CONLIQFIRME=1 THEN 0 ELSE 1 END AS SINLIQFIRME ");
		query.append(" FROM EXPEDIEN t1, SANINTERV t2, (");
		// Incidencia 0142792: Error en el importe de un pago en via de Apremio
		// Incidencia 137945: Correccion de expedientes sancionadores con datos
		// erroneos de via de apremio
		// Solo contaba los pagos de liquidaciones creadas desde la tramitacion,
		// no teniendo en cuenta las nacidas desde la utilidad de via de apremio
		// Ahora se cambia para tener en cuenta todas las liquidaciones pagadas
		// relacionadas con el expediente
		// query.append(" SELECT t3.SGIDEXPEDIENTE,t3.SGREFERENCIAFRACC,
		// SUM(NVL(t3.SGIMPORTE,0)) AS IMPORTE ");
		// query.append(" FROM PAGOS t3 WHERE t3.SGREFERENCIAFRACC IS NOT NULL
		// ");
		// query.append(" AND t3.SGFECHAPAGO IS NOT NULL ");
		// query.append(" GROUP BY t3.SGIDEXPEDIENTE, t3.SGREFERENCIAFRACC ");
		// query.append(" UNION ");
		// query.append(" SELECT t3.SGIDEXPEDIENTE,t3.SGREFERENCIA, t3.SGIMPORTE
		// AS IMPORTE ");
		// query.append(" FROM PAGOS t3 ");
		// query.append(" WHERE t3.SGFECHAPAGO IS NOT NULL AND
		// T3.SGREFERENCIAFRACC IS NULL ");
		// query.append(" SELECT t3.SGIDEXPEDIENTE,SUM(NVL(t3.SGIMPORTE,0)) AS
		// IMPORTE ");
		// query.append(" FROM PAGOS t3 WHERE t3.SGFECHAPAGO IS NOT NULL ");
		// query.append(" GROUP BY SGIDEXPEDIENTE ");
		query.append(" ( ");
		query.append(" SELECT ");
		query.append(" TSG.SGIDEXPEDIENTE AS SGIDEXPEDIENTE, ");
		query.append(" SUM( ");
		query.append(" CASE ");
		query.append(" WHEN TSF.SFTIPOMOV='" + Y41bConstantes.OPERACION_SIPCA_DEVOLUCION + "' ");
		query.append(" THEN -1*NVL(TSH.SHIMPORTE,0) ");
		query.append(" ELSE NVL(TSH.SHIMPORTE,0) ");
		query.append(" END) AS IMPORTE ");
		query.append(" FROM ");
		query.append(" L21.L21SFT00 TSF, ");
		query.append(" L21.L21SHT00 TSH, ");
		query.append(" L21.L21SGT00 TSG ");
		query.append(" WHERE ");
		query.append(" TSH.SHIDMOVIMIENTO=TSF.SFCODIGO ");
		query.append(" AND TSH.SHREFERENCIA=TSG.SGREFERENCIA ");
		query.append(" AND TSF.SFTIPOMOV IN ('" + Y41bConstantes.OPERACION_SIPCA_COBRO + "', ");
		query.append(" '" + Y41bConstantes.OPERACION_SIPCA_DEVOLUCION + "') ");
		query.append(" AND TSF.SFSENTIDO='" + Y41bConstantes.SENTIDO_OPERACION_ENTRADA + "' ");
		query.append(" AND TSG.SGIDEXPEDIENTE IS NOT NULL ");
		query.append(" GROUP BY ");
		query.append(" TSG.SGIDEXPEDIENTE ) ");
		query.append(" UNION ");
		query.append(" ( ");
		query.append(" SELECT ");
		query.append(" t3.SGIDEXPEDIENTE AS TREXCODIGO, ");
		query.append(" SUM(NVL(t3.SGIMPORTE,0)) AS IMPORTE ");
		query.append(" FROM ");
		query.append(" PAGOS t3 ");
		query.append(" WHERE ");
		query.append(" t3.SGFECHAPAGO IS NOT NULL ");
		query.append(" AND NOT EXISTS ( ");
		query.append(" ( ");
		query.append(" SELECT ");
		query.append(" 1 ");
		query.append(" FROM ");
		query.append(" L21.L21SFT00 TSF, ");
		query.append(" L21.L21SHT00 TSH, ");
		query.append(" L21.L21SGT00 TSG ");
		query.append(" WHERE ");
		query.append(" TSH.SHIDMOVIMIENTO=TSF.SFCODIGO ");
		query.append(" AND TSH.SHREFERENCIA=TSG.SGREFERENCIA ");
		query.append(" AND TSF.SFTIPOMOV IN ('" + Y41bConstantes.OPERACION_SIPCA_COBRO + "', ");
		query.append(" '" + Y41bConstantes.OPERACION_SIPCA_DEVOLUCION + "') ");
		query.append(" AND TSF.SFSENTIDO='" + Y41bConstantes.SENTIDO_OPERACION_ENTRADA + "' ");
		query.append(" AND TSG.SGIDEXPEDIENTE IS NOT NULL ");
		query.append(" AND TSG.SGIDEXPEDIENTE = t3.SGIDEXPEDIENTE ) ) ");
		query.append(" GROUP BY ");
		query.append(" SGIDEXPEDIENTE ) ");
		// Fin modificacion Incidencia 137945: Correccion de expedientes
		// sancionadores con datos erroneos de via de apremio
		// Fin Incidencia 0142792: Error en el importe de un pago en via de
		// Apremio
		query.append(" ) PAGADO, (");
		query.append(
				" SELECT A.TRFECENVIO AS TRFECENVIO,B.EXCODIGO AS EXCODIGO FROM SANTRAMEXP A,EXPEDIEN B,(SELECT AUX.TREXCODIGO,MAX(AUX.TRFECFIN) AS MAXFECHA FROM SANTRAMEXP AUX WHERE UPPER(AUX.TRCODIGO)='"
						+ Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA + "' AND UPPER(AUX.TRESTADO)='"
						+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO
						+ "' GROUP BY AUX.TREXCODIGO) TRAMITE WHERE UPPER(A.TRCODIGO)='"
						+ Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA
						+ "' AND A.TRFECFIN=TRAMITE.MAXFECHA AND B.EXCODIGO=A.TREXCODIGO");
		query.append("  ) RECURSOALZADA,(");
		query.append(
				" SELECT ENEXID,ENFECENVIO,ENFECACUSE FROM SANENVIO t0,  SANTRAMEXP t1, SANTRAMEXP t2, (SELECT AUX.TREXCODIGO, MAX(AUX.TRFECFIN) AS MAXFECHA FROM SANTRAMEXP AUX WHERE UPPER(AUX.TRCODIGO)='"
						+ Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION + "' AND UPPER(AUX.TRESTADO)='"
						+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO
						+ "' GROUP BY AUX.TREXCODIGO) TRAMITE, (SELECT TREXCODIGO, TRTRIDREL, TRACUSEREINTENTADO FROM SANTRAMEXP ACUSREIN WHERE ACUSREIN.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO
						+ "') REINTENTADO WHERE t0.ENEXID=t1.TREXCODIGO AND t1.TREXCODIGO=t2.TREXCODIGO AND t2.TRID=t0.ENTRIDACUSE AND t1.TRID=t2.TRTRIDREL AND t1.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION + "' AND t2.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION + "'");
		query.append(" AND t1.TRFECFIN=TRAMITE.MAXFECHA");
		query.append(" AND REINTENTADO.TREXCODIGO=t1.TREXCODIGO");
		query.append(" AND REINTENTADO.TRTRIDREL=t0.ENTRID");
		query.append(" AND (REINTENTADO.TRACUSEREINTENTADO='N' OR REINTENTADO.TRACUSEREINTENTADO IS NULL)");
		query.append(" ) RESOLUCION,(");
		query.append(
				" SELECT ENEXID,ENFECACUSE,t1.TRRESOTIPO,DENOMBRE,DENOMBREE FROM SANENVIO t0, SANTRAMEXP t1, SANTRAMEXP t2, DECISION, (SELECT AUX.TREXCODIGO, MAX(AUX.TRFECFIN) AS MAXFECHA FROM SANTRAMEXP AUX WHERE UPPER(AUX.TRCODIGO)='"
						+ Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO + "' AND UPPER(AUX.TRESTADO)='"
						+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO
						+ "' GROUP BY AUX.TREXCODIGO) TRAMITE, (SELECT TREXCODIGO, TRTRIDREL, TRACUSEREINTENTADO FROM SANTRAMEXP ACUSREIN WHERE ACUSREIN.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO
						+ "') REINTENTADO WHERE t0.ENEXID=t1.TREXCODIGO AND t1.TRRESOTIPO=DECODIGO AND t1.TRID=t2.TRTRIDREL AND t2.TRID=t0.ENTRIDACUSE AND t1.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO + "' AND t2.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION + "' ");
		query.append(" AND t1.TRFECFIN=TRAMITE.MAXFECHA");
		query.append(" AND REINTENTADO.TREXCODIGO=t1.TREXCODIGO");
		query.append(" AND REINTENTADO.TRTRIDREL=t0.ENTRID");
		query.append(" AND (REINTENTADO.TRACUSEREINTENTADO='N' OR REINTENTADO.TRACUSEREINTENTADO IS NULL)");
		query.append(" ) ORDENCONSEJERO, ");
		query.append("(");
		query.append(
				" SELECT DISTINCT SGIDEXPEDIENTE,1 AS CONLIQFIRME FROM PAGOS WHERE SGIDCONCEPTO IN (SELECT SDCODIGO FROM CONCEPTOPAGO WHERE SDCONCEPTOING='");
		query.append(Y41bConstantes.CONCEPTOPAGO_SIPCA_DEVENGOEMISION);
		query.append("') AND SGIDESTADOPAGO NOT IN ('");
		query.append(Y41bConstantes.ESTADO_PAGO_ANULADO);
		query.append("', '");
		query.append(Y41bConstantes.ESTADO_PAGO_ANULADO_FRACCIONAMIENTO);
		query.append("', '");
		query.append(Y41bConstantes.ESTADO_PAGO_SOBRESEIMIENTO);
		query.append("') AND SGREFERENCIAFRACC IS NULL ");
		query.append(") TCONLIQFIRME ");
		query.append(
				" WHERE t1.EXCODIGO=PAGADO.SGIDEXPEDIENTE(+) AND t1.EXCOES=t2.UAESCODIGO AND t1.EXCODIGO=t2.UAEXCODIGO AND t2.UATIPOINTERV='"
						+ Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO + "' ");
		query.append(" AND t1.EXCAMURE is not null ");
		query.append(" AND t1.EXCAMURE-NVL(PAGADO.IMPORTE,0) >0 ");
		query.append(" AND T1.EXCODIGO=RECURSOALZADA.EXCODIGO(+) ");
		query.append(" AND t1.EXCODIGO=RESOLUCION.ENEXID(+) ");
		query.append(" AND t1.EXCODIGO=ORDENCONSEJERO.ENEXID(+) ");
		query.append(" AND t1.EXCODIGO=TCONLIQFIRME.SGIDEXPEDIENTE(+) ");
		query.append(" AND NOT EXISTS (SELECT 1 FROM PAGOS T7 WHERE T7.SGIDEXPEDIENTE=T1.EXCODIGO AND T7.SGVIAAPREMIO='"
				+ Y41bConstantes.VALOR_SI + "') ");
		query.append(
				" AND NOT EXISTS (SELECT 1 FROM PAGOS t9 WHERE t9.SGIDEXPEDIENTE=t1.EXCODIGO AND t9.SGIDESTADOPAGO IN ('"
						+ Y41bConstantes.ESTADO_PAGO_PENDIENTE_PAGO + "') AND t9.SGREFERENCIAFRACC IS NULL) ");
		// INICIO 0105418: Sancionador: procedimiento mal definido .
		// Fraccionamiento y Va de apremio
		// No es exactamente esta incidencia pero se gestiona ahi
		// Se cambia la sql de forma que no se tenga en cuenta las liquidaciones
		// no firmes anuladas por SIPCA cuando existen liquidaciones firmes en
		// la query de seleccion de via de apremio
		// query.append(" AND EXISTS (SELECT 1 FROM PAGOS T7 WHERE
		// T7.SGIDEXPEDIENTE=T1.EXCODIGO AND (T7.SGPRONTOPAGO IS NULL OR
		// T7.SGPRONTOPAGO='"
		// + Y41bConstantes.VALOR_NO + "') AND T7.SGIDESTADOPAGO IN ('");
		// query.append(Y41bConstantes.ESTADO_PAGO_IMPAGADO);
		// query.append("','");
		// query.append(Y41bConstantes.ESTADO_PAGO_ANULADO_VENCIMIENTO);
		// query.append("') )");
		query.append(
				" AND (EXISTS (SELECT 1 FROM PAGOS T7 WHERE T7.SGIDEXPEDIENTE=T1.EXCODIGO AND (T7.SGPRONTOPAGO IS NULL OR T7.SGPRONTOPAGO='"
						+ Y41bConstantes.VALOR_NO + "') AND T7.SGIDESTADOPAGO IN ('");
		query.append(Y41bConstantes.ESTADO_PAGO_IMPAGADO);
		query.append(
				"') ) OR EXISTS (SELECT 1 FROM PAGOS T8 WHERE T8.SGIDEXPEDIENTE=T1.EXCODIGO AND (T8.SGPRONTOPAGO IS NULL OR T8.SGPRONTOPAGO='"
						+ Y41bConstantes.VALOR_NO + "') AND T8.SGIDESTADOPAGO IN ('");
		query.append(Y41bConstantes.ESTADO_PAGO_ANULADO_VENCIMIENTO);
		query.append(
				"') AND NOT EXISTS (SELECT 1 FROM PAGOS T9,CONCEPTOPAGO T10 WHERE T8.SGIDEXPEDIENTE=T9.SGIDEXPEDIENTE AND T9.SGIDCONCEPTO=T10.SDCODIGO AND T10.SDCONCEPTOING='");
		query.append(Y41bConstantes.CONCEPTOPAGO_SIPCA_DEVENGOEMISION);
		query.append("')))");
		// FIN 0105418: Sancionador: procedimiento mal definido .
		// Fraccionamiento y Va de apremio

		return query;
	}

	@Override
	public List<FiltroSanciones> findAllSancionesViaApremio(FiltroSanciones filtroSanciones, Pagination pagination) {
		StringBuilder query = this.getQueryFindAllSancionesViaApremio();

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapSancionesViaApremio(filtroSanciones);
		query.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		List<FiltroSanciones> listaSanciones = (List<FiltroSanciones>) this.jdbcTemplate.query(query.toString(),
				this.rwMapSancionesViaApremio, params.toArray());
		return listaSanciones;

	}

	@Override
	public Long findAllCountSancionesViaApremio(FiltroSanciones filtroSanciones) {
		StringBuilder query = this.getQueryFindAllSancionesViaApremio();

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapSancionesViaApremio(filtroSanciones);
		query.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");

		query.insert(0, "SELECT COUNT(*) FROM (");
		query.append(")");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());

	}

	private Map<String, ?> getWhereMapSancionesViaApremio(FiltroSanciones filtroSanciones) {

		StringBuilder query = new StringBuilder(ExpedienDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		if (filtroSanciones != null && filtroSanciones.getExcodigo() != null) {
			query.append(" AND t1.EXCODIGO=? ");
			params.add(filtroSanciones.getExcodigo());
		}
		if (filtroSanciones != null && filtroSanciones.getExcoor() != null) {
			query.append(" AND UPPER(t1.EXCOOR) like ? ESCAPE  '\\'");
			params.add("%" + filtroSanciones.getExcoor().toUpperCase() + "%");
			query.append(" AND t1.EXCOOR IS NOT NULL");
		}
		if (filtroSanciones != null && filtroSanciones.getExnran() != null) {
			query.append(" AND t1.EXNRAN = ?");
			params.add(filtroSanciones.getExnran().intValue());
		}
		if (filtroSanciones != null && filtroSanciones.getExnror() != null) {
			query.append(" AND t1.EXNROR = ?");
			params.add(filtroSanciones.getExnror());
		}
		if (filtroSanciones != null && !Y41bUtils.esNullOCadenaVacia(filtroSanciones.getEscodigo())) {
			query.append(" AND t2.UAESCODIGO = ? ");
			params.add(filtroSanciones.getEscodigo());
		}
		// Importe
		if (filtroSanciones != null && !Y41bUtils.esNullOCadenaVacia(filtroSanciones.getImporteDesde())) {
			query.append(" AND T1.EXCAMURE-NVL(PAGADO.IMPORTE,0) >= ? ");
			params.add(new BigDecimal(filtroSanciones.getImporteDesde()));
		}
		if (filtroSanciones != null && !Y41bUtils.esNullOCadenaVacia(filtroSanciones.getImporteHasta())) {
			query.append(" AND T1.EXCAMURE-NVL(PAGADO.IMPORTE,0) <= ? ");
			params.add(new BigDecimal(filtroSanciones.getImporteHasta()));
		}
		// Apertura condicion
		query.append(" AND RESOLUCION.ENFECACUSE IS NOT NULL ");

		if (filtroSanciones != null
				&& (filtroSanciones.getSinRecursoAlzada() == true || filtroSanciones.getConRecursoAlzada() == true)) {
			query.append(" AND (");
		}
		if (filtroSanciones != null && filtroSanciones.getSinRecursoAlzada() == true) {
			// sin recurso alzada
			query.append(
					" ( NOT EXISTS (SELECT 1 FROM SANTRAMEXP t5 WHERE t5.TREXCODIGO=t1.EXCODIGO AND t5.TRCODIGO='");
			query.append(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA);
			query.append("' ");
			query.append(" AND t5.TRESTADO='" + Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "') ");
			// con fecha de notificacion de la resolucion anterior a
			if (filtroSanciones != null && filtroSanciones.getFechaNotiReso() != null) {
				query.append(" AND RESOLUCION.ENFECACUSE<= ?");
				params.add(filtroSanciones.getFechaNotiReso());
			}
			query.append(") ");
		}
		if (filtroSanciones != null && filtroSanciones.getSinRecursoAlzada() == true && filtroSanciones != null
				&& filtroSanciones.getConRecursoAlzada() == true) {
			query.append(" OR ( ");
		}
		if (filtroSanciones != null && filtroSanciones.getConRecursoAlzada() == true) {
			// con recurso alzada
			query.append(" EXISTS (SELECT 1 FROM SANTRAMEXP t5 WHERE t5.TREXCODIGO=t1.EXCODIGO AND t5.TRCODIGO='");
			query.append(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA);
			query.append("' ");
			query.append(" AND t5.TRESTADO='" + Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "') ");
			query.append(" AND ORDENCONSEJERO.ENFECACUSE IS NOT NULL ");
			// con fecha de notificacion de la resolucion anterior a
			if (filtroSanciones != null && filtroSanciones.getFechaNotiOrden() != null) {
				query.append(" AND ORDENCONSEJERO.ENFECACUSE<= ?");
				params.add(filtroSanciones.getFechaNotiOrden());
			}
			// con orden del consejero y liquidacion asociada anulada por
			// superarse la fecha de pago
			// query.append(" AND EXISTS (SELECT 1 FROM SANTRAMEXP t5,
			// SANTRAMEXP t6 WHERE t5.TREXCODIGO=t1.EXCODIGO AND
			// t6.TREXCODIGO=t1.EXCODIGO AND t5.TRCODIGO='");
			// query.append(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO);
			// query.append("' AND (t5.TRESTIMACION=");
			// query.append(Y41bConstantes.SAN_ESTIMACION_PARCIAL);
			// query.append(" OR t5.TRESTIMACION=");
			// query.append(Y41bConstantes.SAN_DESESTIMACION);
			// query.append(")");
			// query.append(" AND t6.TRCODIGO='");
			// query.append(Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION);
			// query.append("' AND t6.TRTRIDREL=t5.TRID ");
			// query.append(" AND EXISTS (SELECT 1 FROM SANTRAMEXP t5 WHERE
			// t5.TREXCODIGO=t1.EXCODIGO AND t5.TRCODIGO='");
			// query.append(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO);
			// query.append("' AND (t5.TRESTIMACION=");
			// query.append(Y41bConstantes.SAN_ESTIMACION_PARCIAL);
			// query.append(" OR t5.TRESTIMACION=");
			// query.append(Y41bConstantes.SAN_DESESTIMACION);
			// query.append("))");
			// query.append(" AND EXISTS (SELECT 1 FROM SANTRAMEXP t6 WHERE
			// t6.TREXCODIGO=t1.EXCODIGO AND t6.TRCODIGO='");
			// query.append(Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION);
			// query.append("' AND EXISTS (SELECT 1 FROM PAGOS t7 WHERE
			// t7.SGIDEXPEDIENTE=t6.TREXCODIGO AND
			// t7.SGREFERENCIA||t7.SGDIGITOCONTROL=t6.TRREFERENCIA AND
			// t7.SGIDESTADOPAGO IN ('");
			// query.append(Y41bConstantes.ESTADO_PAGO_IMPAGADO);
			// query.append("','");
			// query.append(Y41bConstantes.ESTADO_PAGO_ANULADO_VENCIMIENTO);
			// query.append("') OR (t7.SGIDESTADOPAGO='");
			// query.append(Y41bConstantes.ESTADO_PAGO_ANULADO_FRACCIONAMIENTO);
			// query.append("' AND EXISTS (SELECT 1 FROM PAGOS t8 WHERE
			// t8.SGIDEXPEDIENTE=t7.SGIDEXPEDIENTE AND
			// t8.SGREFERENCIAFRACC=t7.SGREFERENCIA AND t7.SGIDESTADOPAGO IN
			// ('");
			// query.append(Y41bConstantes.ESTADO_PAGO_IMPAGADO);
			// query.append("','");
			// query.append(Y41bConstantes.ESTADO_PAGO_ANULADO_VENCIMIENTO);
			// query.append("') )))");
			// query.append(")");
		}
		// Cierre condicion
		if (filtroSanciones != null && filtroSanciones.getSinRecursoAlzada() == true && filtroSanciones != null
				&& filtroSanciones.getConRecursoAlzada() == true) {
			query.append(")");
		}
		if (filtroSanciones != null
				&& (filtroSanciones.getSinRecursoAlzada() == true || filtroSanciones.getConRecursoAlzada() == true)) {
			query.append(")");
		}

		if (filtroSanciones != null && filtroSanciones.getSinLiquidacionesFirmes()) {
			query.append(" AND TCONLIQFIRME.CONLIQFIRME IS NULL ");
		}

		// NO EXISTE TRAMITE DE RESOLUCION SIN TRAMITAR
		query.append(" AND (NOT EXISTS(SELECT 1 FROM SANTRAMEXP t5 WHERE t5.TREXCODIGO=t1.EXCODIGO AND t5.TRCODIGO='"
				+ Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION + "' AND t5.TRESTADO<>'"
				+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "') ) ");

		// NO EXISTE TRAMITE DE RECEPCION DE ORDEN DE CONSEJERO SIN TRAMITAR
		query.append(" AND (NOT EXISTS(SELECT 1 FROM SANTRAMEXP t5 WHERE t5.TREXCODIGO=t1.EXCODIGO AND t5.TRCODIGO='"
				+ Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO + "' AND t5.TRESTADO<>'"
				+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "') ) ");

		if (filtroSanciones != null && filtroSanciones.getExexcluido() != null) {
			query.append(
					" AND ( EXISTS(SELECT 1 FROM SANEXP t7 WHERE t7.EXCODIGO=t1.EXCODIGO AND t7.EXEXCLUIDOAPREMIO IS NOT NULL )) ");
		} else if (filtroSanciones != null && (null == filtroSanciones.getExexcluido()
				|| "" == filtroSanciones.getExexcluido() || "N" == filtroSanciones.getExexcluido())) {
			query.append(
					" AND ( EXISTS(SELECT 1 FROM SANEXP t7 WHERE t7.EXCODIGO=t1.EXCODIGO AND t7.EXEXCLUIDOAPREMIO IS NULL )) ");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", query);
		mapWhere.put("params", params);

		return mapWhere;
	}

	@Override
	public FiltroSanciones obtenerDatosEstadoLiquidacion(FiltroSanciones filtroSanciones) {
		StringBuilder query = new StringBuilder("");
		query.append("SELECT DISTINCT t1.EXCOOR EXCOOR,t1.EXNRAN EXNRAN,t1.EXNROR EXNROR, t1.EXCOOR || '");
		query.append(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP);
		query.append("' || t1.EXNROR || '");
		query.append(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP);
		query.append("' || t1.EXNRAN CODCOMPLETO , t1.EXCODIGO EXCODIGO, LPAD(T1.EXNROR,12,'0') CORRELATIVOPAD, ");
		query.append(" NVL(t1.EXCAMURE,0) EXCAMURE, NVL(t1.EXCAMURE,0)-NVL(PAGADO.IMPORTE,0) IMPORTEPENDIENTE, ");
		query.append(" '' UANOMBRE,'' UANIF,'' UAESCODIGO, ");
		query.append(" '' RESOLUCIONENFECENVIO,'' RESOLUCIONENFECACUSE, ");
		query.append(" '' RECURSOALZADAFECENVIO,");
		query.append(
				" '' ORDENCONSEJEROTRRESOTIPO,'' ORDENCONSEJERODENOMBRE,'' ORDENCONSEJERODENOMBREE,'' ORDENCONSEJEROENFECACUSE, '' SINLIQFIRME ");
		query.append(" FROM EXPEDIEN t1, (");
		// Incidencia 0142792: Error en el importe de un pago en via de Apremio
		// Incidencia 137945: Correccion de expedientes sancionadores con datos
		// erroneos de via de apremio
		// Solo contaba los pagos de liquidaciones creadas desde la tramitacion,
		// no teniendo en cuenta las nacidas desde la utilidad de via de apremio
		// Ahora se cambia para tener en cuenta todas las liquidaciones pagadas
		// relacionadas con el expediente
		// query.append(" SELECT t4.TREXCODIGO,SUM(NVL(t3.SGIMPORTE,0)) AS
		// IMPORTE ");
		// query.append(" FROM PAGOS t3,SANTRAMEXP t4 WHERE
		// t4.TREXCODIGO=t3.SGIDEXPEDIENTE AND t3.SGREFERENCIAFRACC IS NOT NULL
		// ");
		// query.append(" AND SUBSTR(t4.TRREFERENCIA,0,11)=t3.SGREFERENCIAFRACC
		// ");
		// // query.append(" AND t3.SGIDESTADOPAGO IN ('DD','DP','GA','PG') ");
		// query.append(" AND t3.SGFECHAPAGO IS NOT NULL ");
		// query.append(" GROUP BY TREXCODIGO ");
		// query.append(" UNION ");
		// query.append(" SELECT t4.TREXCODIGO,t3.SGIMPORTE AS IMPORTE ");
		// query.append(" FROM PAGOS t3,SANTRAMEXP t4 WHERE
		// t4.TREXCODIGO=t3.SGIDEXPEDIENTE ");
		// query.append(" AND SUBSTR(t4.TRREFERENCIA,0,11)=t3.SGREFERENCIA ");
		// // query.append(" AND t3.SGIDESTADOPAGO IN ('DD','DP','GA','PG') ");
		// query.append(" AND t3.SGFECHAPAGO IS NOT NULL ");
		// query.append(" AND NOT EXISTS (SELECT 1 FROM PAGOS T1 WHERE ");
		// query.append(" T1.SGIDEXPEDIENTE=T3.SGIDEXPEDIENTE AND
		// T3.SGREFERENCIA=T1.SGREFERENCIAFRACC)");
		// query.append(" SELECT t3.SGIDEXPEDIENTE AS
		// TREXCODIGO,SUM(NVL(t3.SGIMPORTE,0)) AS IMPORTE ");
		// query.append(" FROM PAGOS t3 WHERE t3.SGFECHAPAGO IS NOT NULL ");
		// query.append(" GROUP BY SGIDEXPEDIENTE ");
		query.append(" ( ");
		query.append(" SELECT ");
		query.append(" TSG.SGIDEXPEDIENTE AS TREXCODIGO, ");
		query.append(" SUM( ");
		query.append(" CASE ");
		query.append(" WHEN TSF.SFTIPOMOV='" + Y41bConstantes.OPERACION_SIPCA_DEVOLUCION + "' ");
		query.append(" THEN -1*NVL(TSH.SHIMPORTE,0) ");
		query.append(" ELSE NVL(TSH.SHIMPORTE,0) ");
		query.append(" END) AS IMPORTE ");
		query.append(" FROM ");
		query.append(" L21.L21SFT00 TSF, ");
		query.append(" L21.L21SHT00 TSH, ");
		query.append(" L21.L21SGT00 TSG ");
		query.append(" WHERE ");
		query.append(" TSH.SHIDMOVIMIENTO=TSF.SFCODIGO ");
		query.append(" AND TSH.SHREFERENCIA=TSG.SGREFERENCIA ");
		query.append(" AND TSF.SFTIPOMOV IN ('" + Y41bConstantes.OPERACION_SIPCA_COBRO + "', ");
		query.append(" '" + Y41bConstantes.OPERACION_SIPCA_DEVOLUCION + "') ");
		query.append(" AND TSF.SFSENTIDO='" + Y41bConstantes.SENTIDO_OPERACION_ENTRADA + "' ");
		query.append(" AND TSG.SGIDEXPEDIENTE IS NOT NULL ");
		query.append(" GROUP BY ");
		query.append(" TSG.SGIDEXPEDIENTE ) ");
		query.append(" UNION ");
		query.append(" ( ");
		query.append(" SELECT ");
		query.append(" t3.SGIDEXPEDIENTE AS TREXCODIGO, ");
		query.append(" SUM(NVL(t3.SGIMPORTE,0)) AS IMPORTE ");
		query.append(" FROM ");
		query.append(" PAGOS t3 ");
		query.append(" WHERE ");
		query.append(" t3.SGFECHAPAGO IS NOT NULL ");
		query.append(" AND NOT EXISTS ( ");
		query.append(" ( ");
		query.append(" SELECT ");
		query.append(" 1 ");
		query.append(" FROM ");
		query.append(" L21.L21SFT00 TSF, ");
		query.append(" L21.L21SHT00 TSH, ");
		query.append(" L21.L21SGT00 TSG ");
		query.append(" WHERE ");
		query.append(" TSH.SHIDMOVIMIENTO=TSF.SFCODIGO ");
		query.append(" AND TSH.SHREFERENCIA=TSG.SGREFERENCIA ");
		query.append(" AND TSF.SFTIPOMOV IN ('" + Y41bConstantes.OPERACION_SIPCA_COBRO + "', ");
		query.append(" '" + Y41bConstantes.OPERACION_SIPCA_DEVOLUCION + "') ");
		query.append(" AND TSF.SFSENTIDO='" + Y41bConstantes.SENTIDO_OPERACION_ENTRADA + "' ");
		query.append(" AND TSG.SGIDEXPEDIENTE IS NOT NULL ");
		query.append(" AND TSG.SGIDEXPEDIENTE = t3.SGIDEXPEDIENTE ) ) ");
		query.append(" GROUP BY ");
		query.append(" SGIDEXPEDIENTE ) ");
		// Fin modificacion Incidencia 137945: Correccion de expedientes
		// sancionadores con datos erroneos de via de apremio
		// Fin Incidencia 0142792: Error en el importe de un pago en via de
		// Apremio
		query.append(" ) PAGADO ");
		query.append(" WHERE t1.EXCODIGO=PAGADO.TREXCODIGO(+) ");
		// query.append(" AND t1.EXCAMURE is not null ");
		query.append(" AND t1.EXCODIGO=? ");
		List<Object> params = new ArrayList<Object>();
		params.add(filtroSanciones.getExcodigo());

		List<FiltroSanciones> listaSanciones = (List<FiltroSanciones>) this.jdbcTemplate.query(query.toString(),
				this.rwMapSancionesViaApremio, params.toArray());
		return (FiltroSanciones) DataAccessUtils.uniqueResult(listaSanciones);

	}

	/**
	 * Updates a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Expedien
	 */
	public Expedien updateInstructor(Expedien expedien) {
		String query = "UPDATE EXPEDIEN SET EXCOIT=? WHERE EXCODIGO=?";
		this.jdbcTemplate.update(query, expedien.getExcoit(), expedien.getExcodigo());
		return expedien;
	}

	/**
	 * Updates a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Expedien
	 */
	public Expedien updatePS(Expedien expedien) {
		String query = "UPDATE EXPEDIEN SET EXCOPS=? WHERE EXCODIGO=?";
		this.jdbcTemplate.update(query, expedien.getExcops(), expedien.getExcodigo());
		return expedien;
	}

	/**
	 * Inserts a single row in the SancionDescriptor table.
	 * 
	 * @param expedin
	 *            Expedien
	 * @return Expedien
	 */
	public Expedien addSancionDescriptor(Expedien expedien) {
		String query = "INSERT INTO SANCION_DESCRIPTOR " + "( EXCODIGO,ID_DESCRIPTOR) " + " values (?, ?)";

		List<Descriptor> descriptorAux = expedien.getDescriptores();
		Iterator<Descriptor> it = descriptorAux.iterator();
		while (it.hasNext()) {
			Descriptor descriptor = (Descriptor) it.next();
			this.jdbcTemplate.update(query, expedien.getExcodigo(), descriptor.getIdDescriptor());
		}
		return expedien;
	}

	/**
	 * Deletes a single row in the SancionDescriptor table.
	 * 
	 * @param expedien
	 *            Expedien
	 */
	public void removeSancionDescriptor(Expedien expedien) {
		String query = "DELETE  FROM SANCION_DESCRIPTOR " + " WHERE EXCODIGO=? AND ID_DESCRIPTOR=?";
		List<Descriptor> descriptorAux = expedien.getDescriptores();
		Iterator<Descriptor> it = descriptorAux.iterator();
		while (it.hasNext()) {
			Descriptor descriptor = (Descriptor) it.next();
			this.jdbcTemplate.update(query, expedien.getExcodigo(), descriptor.getIdDescriptor());
		}
	}

	/**
	 * Deletes a single row in the SancionDescriptor table.
	 * 
	 * @param expedien
	 *            Expedien
	 */
	public void removeAllSancionDescriptor(Expedien expedien) {
		String query = "DELETE  FROM SANCION_DESCRIPTOR " + " WHERE EXCODIGO=? ";
		this.jdbcTemplate.update(query, expedien.getExcodigo());
	}

	/**
	 * Updates a single row in the SancionDescriptor table.
	 * 
	 * @param descriptorAEliminar
	 *            Descriptor
	 * @param descriptorBueno
	 *            Descriptor
	 * @return Descriptor
	 */
	public Descriptor updateSancionDescriptor(Descriptor descriptorAEliminar, Descriptor descriptorBueno) {
		String query = "UPDATE SANCION_DESCRIPTOR SET ID_DESCRIPTOR=? WHERE ID_DESCRIPTOR=?";

		this.jdbcTemplate.update(query, descriptorBueno.getIdDescriptor(), descriptorAEliminar.getIdDescriptor());

		return descriptorAEliminar;
	}

	/**
	 * Find a single row in the SancionDescriptor Many To Many relationship.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Expedien> findAllSancionDescriptores(Expedien expedien, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer("select t1.EXCODIGO EXCODIGO " + "FROM SANCION_DESCRIPTOR t1 ");

		if (expedien != null && expedien.getDescriptores() != null && expedien.getDescriptores().size() > 0) {

			where.append(" AND ( ");
			boolean firstElement = true;

			for (Descriptor e : expedien.getDescriptores()) {

				if (firstElement) {

					where.append("ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
					firstElement = false;

				} else {

					where.append(" OR ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
				}
			}

			where.append(") ");
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Expedien>) this.jdbcTemplate.query(query.toString(), new RowMapper<Expedien>() {
			public Expedien mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Expedien(resultSet.getString("EXCODIGO"));
			}
		}, params.toArray());

	}

	/**
	 * Find a single row in the SancionDescriptor Many To Many relationship.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Descriptor> findAllSancionDescriptor(Expedien expedien, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ID_DESCRIPTOR = t2.ID_DESCRIPTOR AND t1.EXCODIGO=?");

		params.add(expedien.getExcodigo());

		StringBuffer query = new StringBuffer(
				"SELECT t2.ID_DESCRIPTOR IDDESCRIPTOR, t2.NOMBRE NOMBRE FROM SANCION_DESCRIPTOR t1,DESCRIPTOR t2  ");
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY UPPER(" + pagination.getSort() + ") " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Descriptor>) this.jdbcTemplate.query(query.toString(), new RowMapper<Descriptor>() {
			public Descriptor mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Descriptor(resultSet.getString("IDDESCRIPTOR"), resultSet.getString("NOMBRE"));
			}
		}, params.toArray());
	}

}
