package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.ExpedienKgest;
import com.ejie.y41b.model.FiltroSanciones;
import com.ejie.y41b.model.Saninterv;

/**
 * ExpedienDao  
 * 
 *  
 */

public interface ExpedienDao {

	/**
	 * Inserts a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Expedien
	 */
	Expedien add(Expedien expedien);

	/**
	 * Updates a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Expedien
	 */
	Expedien update(Expedien expedien);

	/**
	 * Updates a single row in the Expedien table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno,
			String escodigoAfusionar);

	/**
	 * Finds a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Expedien
	 */
	Expedien find(Expedien expedien);

	/**
	 * Finds a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Pagination
	 * @return Expedien
	 */
	public Expedien findSancionByNumeroExpediente(Expedien expedien);

	/**
	 * Finds a single row in the ExpedienKgest table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return ExpedienKgest
	 */
	ExpedienKgest findKgest(ExpedienKgest expedien);

	/**
	 * Find pronunciamiento act kgest.
	 * 
	 * @param expedien
	 *            the expedien
	 * @return List
	 */
	List<ExpedienKgest> findPronunciamientoActKgest(ExpedienKgest expedien);

	/**
	 * Find pronunciamiento act kgest count.
	 * 
	 * @param expedien
	 *            the expedien
	 * @return List
	 */
	Long findPronunciamientoActKgestCount(ExpedienKgest expedien);

	/**
	 * Find pronunciamiento otras kgest.
	 * 
	 * @param expedien
	 *            the expedien
	 * @return List
	 */
	List<ExpedienKgest> findPronunciamientoOtrasKgest(ExpedienKgest expedien);

	/**
	 * Find pronunciamiento otras kgest count.
	 * 
	 * @param expedien
	 *            the expedien
	 * @return List
	 */
	Long findPronunciamientoOtrasKgestCount(ExpedienKgest expedien);

	/**
	 * Find pronunciamiento recl kgest.
	 * 
	 * @param expedien
	 *            the expedien
	 * @return List
	 */
	List<ExpedienKgest> findPronunciamientoReclKgest(ExpedienKgest expedien);

	/**
	 * Find pronunciamiento recl kgest count.
	 * 
	 * @param expedien
	 *            the expedien
	 * @return List
	 */
	Long findPronunciamientoReclKgestCount(ExpedienKgest expedien);

	/**
	 * Deletes a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return
	 */
	void remove(Expedien expedien);

	/**
	 * Finds a List of rows in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Expedien> findAll(Expedien expedien, Pagination pagination);

	/**
	 * Counts rows in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Long
	 */
	Long findAllCount(Expedien expedien);

	/**
	 * Finds rows in the Expedien table using like.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Expedien> findAllLike(Expedien expedien, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Expedien table using like.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Expedien expedien, Boolean startsWith);

	/**
	 * METODOS DE BUSQUEDA PARA EL FILTRO/BUSQUEDA DE EXPEDIENTES SANCIONADORES
	 */

	/**
	 * Finds a List of rows in the FiltroSanciones table.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Expedien> findAllSanciones(FiltroSanciones filtroSanciones,
			Pagination pagination);

	/**
	 * Counts rows in the FiltroSanciones table.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @return Long
	 */
	Long findAllCountSanciones(FiltroSanciones filtroSanciones);

	/**
	 * Finds rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<FiltroSanciones> findAllLikeSanciones(FiltroSanciones filtroSanciones,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCountSanciones(FiltroSanciones filtroSanciones,
			Boolean startsWith);

	/**
	 * Finds rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param excodigo
	 *            the excodigo
	 * @param relacionados
	 *            the relacionados
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<FiltroSanciones> findAllSancionesRelacionar(
			FiltroSanciones filtroSanciones, String excodigo,
			String relacionados, Pagination pagination);

	/**
	 * Counts rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param excodigo
	 *            the excodigo
	 * @param relacionados
	 *            the relacionados
	 * @return Long
	 */
	Long findAllCountSancionesRelacionar(FiltroSanciones filtroSanciones,
			String excodigo, String relacionados);

	/**
	 * Finds EXNROR
	 * 
	 * @param expedien
	 *            Pagination
	 * @return long
	 */
	long findExnrorSig(Expedien expedien);

	/**
	 * Find all like sanciones combinada.
	 * 
	 * @param filtroSanciones
	 *            the filtro sanciones
	 * @param pagination
	 *            the pagination
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<FiltroSanciones> findAllLikeSancionesCombinada(
			FiltroSanciones filtroSanciones, Pagination pagination,
			Boolean startsWith);

	/**
	 * Find all like sanciones busqueda combinada count.
	 * 
	 * @param filtroSanciones
	 *            the filtro sanciones
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	public Long findAllLikeSancionesBusquedaCombinadaCount(
			FiltroSanciones filtroSanciones, Boolean startsWith);

	/**
	 * Expedientes con recursos.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param saninterv
	 *            the saninterv
	 * @return the list
	 */
	public int expedientesConRecursos(Expedien expedien, Saninterv saninterv);

	/**
	 * Expedientes con recursos.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param saninterv
	 *            the saninterv
	 * @param pagination
	 *            the pagination
	 * @return the list
	 */
	public List<Expedien> listExpedientesConRecursos(Expedien expedien,
			Saninterv saninterv, Pagination pagination);

	/**
	 * Get a New PK (Esperas).
	 * 
	 * @return Long
	 */
	public Long getNewEsperaPK();

	/**
	 * Finds rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<FiltroSanciones> findAllSancionesViaApremio(
			FiltroSanciones filtroSanciones, Pagination pagination);

	/**
	 * Counts rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @return Long
	 */
	Long findAllCountSancionesViaApremio(FiltroSanciones filtroSanciones);

	/**
	 * @param expediente
	 *            Expedien
	 * @return Expedien
	 */
	Expedien updateInstructor(Expedien expediente);

	/**
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @return FiltroSanciones
	 */
	FiltroSanciones obtenerDatosEstadoLiquidacion(
			FiltroSanciones filtroSanciones);

	/**
	 * Updates a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Expedien
	 */
	Expedien updatePS(Expedien expedien);

	/**
	 * Inserts a single row in the SancionDescriptor table.
	 * 
	 * @param expedin
	 *            Expedien
	 * @return Expedien
	 */
	public Expedien addSancionDescriptor(Expedien expedien);

	/**
	 * Deletes a single row in the SancionDescriptor table.
	 * 
	 * @param expedien
	 *            Expedien
	 */
	public void removeSancionDescriptor(Expedien expedien);

	/**
	 * Deletes a single row in the SancionDescriptor table.
	 * 
	 * @param expedien
	 *            Expedien
	 */
	public void removeAllSancionDescriptor(Expedien expedien);

	/**
	 * Updates a single row in the SancionDescriptor table.
	 * 
	 * @param descriptorAEliminar
	 *            Descriptor
	 * @param descriptorBueno
	 *            Descriptor
	 * @return Descriptor
	 */
	public Descriptor updateSancionDescriptor(Descriptor descriptorAEliminar,
			Descriptor descriptorBueno);

	/**
	 * Find a single row in the SancionDescriptor Many To Many relationship.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Expedien> findAllSancionDescriptores(Expedien expedien,
			Pagination pagination);

	/**
	 * Find a single row in the SancionDescriptor Many To Many relationship.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Descriptor> findAllSancionDescriptor(Expedien expedien,
			Pagination pagination);
}