package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.ExcelAdheridas;

/**
 * ExcelAdheridasDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ExcelAdheridasDaoImpl implements ExcelAdheridasDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<ExcelAdheridas> rwMap = new RowMapper<ExcelAdheridas>() {
		public ExcelAdheridas mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new ExcelAdheridas(resultSet.getString("RAZONSOCIAL"), resultSet.getString("NOMBRECOMERCIAL"),
					resultSet.getString("CIF"), resultSet.getString("IDIOMA"), resultSet.getString("WEB"),
					resultSet.getString("COMENTARIOS"), resultSet.getString("DESCRIPTORES"),
					resultSet.getString("SEDE"), resultSet.getString("FECHAADHESION"),
					resultSet.getInt("NUMEROADHESION"), resultSet.getString("TIPOARBITRAJE"),
					resultSet.getString("MEDIACION"), resultSet.getString("ADHESIONINDEFINIDA"),
					resultSet.getString("JUNTAARBITRALID"), resultSet.getString("JUNTAARBITRAL"),
					resultSet.getString("FECHAFINADHESION"), resultSet.getString("FECHABAJAEFECTIVA"),
					resultSet.getString("FECHAPETICIONACTUALIZACION"), resultSet.getString("CODIGOSECTOR"),
					resultSet.getString("NOMBRESECTORCASTELLANO"), resultSet.getString("NOMBRESECTOREUSKERA"),
					resultSet.getString("CODIGOORGEMPRESARIAL"), resultSet.getString("ORGEMPRESARIAL"),
					resultSet.getString("CONTACTO"), resultSet.getString("FECHACIERRE"), resultSet.getString("EMAIL"),
					resultSet.getString("EMAILMULTIPLEC"), resultSet.getString("EMAILMULTIPLEE"),
					resultSet.getString("TELEFONO1"), resultSet.getString("TELEFONO2"),
					resultSet.getString("RESIDENCIAEN"), resultSet.getString("PAIS"), resultSet.getString("PROVINCIA"),
					resultSet.getString("MUNICIPIO"), resultSet.getString("LOCALIDAD"), resultSet.getString("CALLE"),
					resultSet.getString("PORTAL"), resultSet.getString("COMPLEMENTODIRECCION"),
					resultSet.getString("DIRECCIONNOCAPV"), resultSet.getString("CODIGOPOSTAL"),
					resultSet.getString("DIRECCIONANTIGUA"), resultSet.getString("FECHAULTIMAMODIFICACION"),
					resultSet.getString("USUARIOULTIMAMODIFICACION"), resultSet.getString("REPRESENTANTELEGAL"),
					resultSet.getString("NICIFNIEREPRESENTANTE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a List of rows in the ExcelAdheridas table.
	 * 
	 * @param tipoFiltro
	 *            Integer
	 * @param numeroDesde
	 *            Integer
	 * @param numeroHasta
	 *            Integer
	 * @param listaCIF
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ExcelAdheridas> findAll(Integer tipoFiltro, Integer numeroDesde, Integer numeroHasta,
			List<String> listaCIF, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t2.ESNOMBRE RAZONSOCIAL, t2.ESNOCO NOMBRECOMERCIAL, t2.ESNIF CIF, DECODE(t2.ESCOIDCO, 'C','CASTELLANO','V','EUSKERA',NULL,NULL,t2.ESCOIDCO) IDIOMA, t2.ESTEURL WEB, t2.ESTECO COMENTARIOS, t7.NOMBRE_DESC DESCRIPTORES, DECODE(t2.ESSEDE, 'S', 'SI', 'N', 'NO',NULL,NULL, t2.ESSEDE) SEDE, TO_CHAR(t2.ESFEADAR, 'DD/MM/YYYY') FECHAADHESION, t5.AHNRDI NUMEROADHESION, DECODE(t2.ESINTIAR, 'D','DERECHO','E','EQUIDAD',NULL,NULL,t2.ESINTIAR) TIPOARBITRAJE, DECODE(t5.AHMEDIA, 'S', 'SI', 'N', 'NO',NULL,NULL, t5.AHMEDIA) MEDIACION, DECODE(t5.AHINDEF, 'S', 'SI', 'N', 'NO',NULL,NULL, t5.AHINDEF) ADHESIONINDEFINIDA, t5.AHCOJA JUNTAARBITRALID, t6.NOMBRE_ES JUNTAARBITRAL, TO_CHAR(t5.AHFERE, 'DD/MM/YYYY') FECHAFINADHESION, TO_CHAR(t5.AHFEBA, 'DD/MM/YYYY') FECHABAJAEFECTIVA, TO_CHAR(t2.ESFEERD, 'DD/MM/YYYY') FECHAPETICIONACTUALIZACION, t4.SECODIGO CODIGOSECTOR, t4.SENOMBRE NOMBRESECTORCASTELLANO, t4.SENOMBREE NOMBRESECTOREUSKERA, t2.ESCOOE CODIGOORGEMPRESARIAL, t3.NOMBRE_ES ORGEMPRESARIAL, t2.ESNOPECO CONTACTO, TO_CHAR(t2.ESFEBA, 'DD/MM/YYYY') FECHACIERRE, t2.ESCOEM EMAIL, t8.MAIL_C EMAILMULTIPLEC, t8.MAIL_E EMAILMULTIPLEE, t2.ESNRTEL TELEFONO1, t2.ESNRTEL2 TELEFONO2, DECODE(t2.ESEXTRANJERO, 'N','ESTADO','S','EXTRANJERO',NULL,NULL,t2.ESEXTRANJERO) RESIDENCIAEN, t2.ESNORA_PAIS_NOMBRE PAIS, t2.ESNOMBRE_PROVINCIA PROVINCIA, t2.ESNOMBRE_MUNICIPIO MUNICIPIO, t2.ESNOMBRE_LOCALIDAD LOCALIDAD, t2.ESNOMBRE_CALLE CALLE, t2.ESNOMBRE_PORTAL PORTAL, t2.ESNOMBRE_PISO COMPLEMENTODIRECCION, t2.ESDIRECCION_NOCAPV DIRECCIONNOCAPV, t2.ESNOMBRE_CP CODIGOPOSTAL, t2.ESNODIR DIRECCIONANTIGUA, t2.ESFEMOD FECHAULTIMAMODIFICACION, t9.USUARIOXLNET USUARIOULTIMAMODIFICACION, t2.ESNOREP REPRESENTANTELEGAL, t2.ESNIFREP NICIFNIEREPRESENTANTE FROM ( 		SELECT * FROM ESTABLECIM_SECTOR WHERE EAINPRSE='P' AND ROWNUM=1 ) t1, ESTABLECIMIENTO t2 , SECTOR t4, ESTABLECIM_ARBITRA t5, Y42B.ENTIDAD t3, Y42B.ENTIDAD t6, ( SELECT ES_CODIGO, SUBSTR(REGEXP_REPLACE(SYS_CONNECT_BY_PATH(NOMBRE_DESC, ';'), '(;){1,}', ';'),2) NOMBRE_DESC FROM ( SELECT ES_CODIGO, NOMBRE_DESC, ID_DESCRIPTOR, COUNT(*) OVER ( PARTITION BY ES_CODIGO ) CNT, ROW_NUMBER () OVER ( PARTITION BY ES_CODIGO ORDER BY NOMBRE_DESC ASC) SEQ FROM ( SELECT B.ES_CODIGO, D.ID_DESCRIPTOR, D.NOMBRE NOMBRE_DESC FROM ( SELECT ID_DESCRIPTOR ID_DESCRIPTOR, ESCODIGO ES_CODIGO FROM ESTABLECIMIENTO_DESCRIPTOR) B, L21.L21TIT00 D WHERE B.ID_DESCRIPTOR=D.ID_DESCRIPTOR(+) AND B.ES_CODIGO IS NOT NULL) H ) WHERE SEQ=CNT START WITH SEQ=1 CONNECT BY PRIOR SEQ+1=SEQ AND PRIOR ES_CODIGO=ES_CODIGO ) t7, ( SELECT ESCODIGO, SUBSTR(REGEXP_REPLACE(SYS_CONNECT_BY_PATH(MAIL_C, ';'), '(;){1,}', ';'),2) MAIL_C, SUBSTR(REGEXP_REPLACE(SYS_CONNECT_BY_PATH(MAIL_E, ';'), '(;){1,}', ';'),2) MAIL_E FROM ( SELECT ESCODIGO, MAIL_C, MAIL_E, ID_DATOMAIL, COUNT(*) OVER ( PARTITION BY ESCODIGO ) CNT, ROW_NUMBER () OVER ( PARTITION BY ESCODIGO ORDER BY MAIL_C ASC) SEQ FROM ( SELECT D.ESCODIGO, D.ID_DATOMAIL, D.EMAIL || ' (' || D.DESCRIPCION || ')' MAIL_C, D.EMAIL || ' (' || D.DESCRIPCIONE || ')' MAIL_E FROM DATOS_MAIL_ESTABLECIMIENTO D WHERE D.ESCODIGO IS NOT NULL) H ) WHERE SEQ=CNT START WITH SEQ=1 CONNECT BY PRIOR SEQ+1=SEQ AND PRIOR ESCODIGO=ESCODIGO ) t8, CENSO_MONITOR t9 ");
		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t5.AHNRDI is not null AND T2.ESFEBA IS NULL AND t1.EACOES(+)= t2.ESCODIGO AND t1.EACOSE= t4.SECODIGO(+) AND t2.ESCODIGO=t5.AHCOES(+) AND t3.COD_ORG(+)=t2.ESCOOE AND t6.COD_ORG(+)=t5.AHCOJA AND t7.ES_CODIGO(+)=t2.ESCODIGO AND t8.ESCODIGO(+)=t2.ESCODIGO AND t9.MOCODIGO(+)=t2.ESCOZS ");
		List<Object> params = new ArrayList<Object>();
		if (tipoFiltro != null && tipoFiltro.intValue() == 0) {
			if (numeroDesde != null) {
				where.append(" AND t5.AHNRDI >= ? ");
				params.add(numeroDesde);
			}
			if (numeroHasta != null) {
				where.append(" AND t5.AHNRDI <= ? ");
				params.add(numeroHasta);
			}
		} else {
			if (listaCIF != null) {
				StringBuilder builder = new StringBuilder();
				for (int i = 0; i < listaCIF.size(); i++) {
					builder.append("?,");
					params.add(listaCIF.get(i));
				}
				String placeHolders = builder.deleteCharAt(builder.length() - 1).toString();
				where.append(" AND t2.ESNIf IN (").append(placeHolders).append(") ");

			}
		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ExcelAdheridas>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
