package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.ExcelAdheridas;

/**
 * ExcelAdheridasDao  
 * 
 *  
 */

public interface ExcelAdheridasDao {

	/**
	 * Finds a List of rows in the ExcelAdheridas table.
	 * 
	 * @param tipoFiltro
	 *            Integer
	 * @param numeroDesde
	 *            Integer
	 * @param numeroHasta
	 *            Integer
	 * @param listaCIF
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ExcelAdheridas> findAll(Integer tipoFiltro, Integer numeroDesde, Integer numeroHasta,
			List<String> listaCIF, Pagination pagination);

}
