package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Estadopago;

/**
 * EstadopagoDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class EstadopagoDaoImpl implements EstadopagoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Estadopago> rwMap = new RowMapper<Estadopago>() {
		public Estadopago mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Estadopago(resultSet.getString("SACODIGO"),
					resultSet.getString("SADESCES"),
					resultSet.getString("SADESCEU"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Estadopago table.
	 * 
	 * @param estadopago
	 *            Pagination
	 * @return Estadopago
	 */
	public Estadopago add(Estadopago estadopago) {
		String query = "INSERT INTO ESTADOPAGO (SACODIGO, SADESCES, SADESCEU) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, estadopago.getSacodigo(),
				estadopago.getSadesces(), estadopago.getSadesceu());
		return estadopago;
	}

	/**
	 * Updates a single row in the Estadopago table.
	 * 
	 * @param estadopago
	 *            Pagination
	 * @return Estadopago
	 */
	public Estadopago update(Estadopago estadopago) {
		String query = "UPDATE ESTADOPAGO SET SADESCES=?, SADESCEU=? WHERE SACODIGO=?";
		this.jdbcTemplate.update(query, estadopago.getSadesces(),
				estadopago.getSadesceu(), estadopago.getSacodigo());
		return estadopago;
	}

	/**
	 * Finds a single row in the Estadopago table.
	 * 
	 * @param estadopago
	 *            Pagination
	 * @return Estadopago
	 */
	@Transactional(readOnly = true)
	public Estadopago find(Estadopago estadopago) {
		String query = "SELECT t1.SACODIGO SACODIGO, t1.SADESCES SADESCES, t1.SADESCEU SADESCEU FROM ESTADOPAGO t1  WHERE t1.SACODIGO = ?  ";

		List<Estadopago> estadopagoList = this.jdbcTemplate.query(query,
				this.rwMap, estadopago.getSacodigo());
		return (Estadopago) DataAccessUtils.uniqueResult(estadopagoList);
	}

	/**
	 * Removes a single row in the Estadopago table.
	 * 
	 * @param estadopago
	 *            Pagination
	 * @return
	 */
	public void remove(Estadopago estadopago) {
		String query = "DELETE FROM ESTADOPAGO WHERE SACODIGO=?";
		this.jdbcTemplate.update(query, estadopago.getSacodigo());
	}

	/**
	 * Finds a List of rows in the Estadopago table.
	 * 
	 * @param estadopago
	 *            Estadopago
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Estadopago> findAll(Estadopago estadopago, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SACODIGO SACODIGO,t1.SADESCES SADESCES,NVL(t1.SADESCEU,t1.SADESCES) SADESCEU ");
		query.append("FROM ESTADOPAGO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(estadopago);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Estadopago>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Estadopago table.
	 * 
	 * @param estadopago
	 *            Estadopago
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Estadopago estadopago) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ESTADOPAGO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(estadopago);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Estadopago table using like.
	 * 
	 * @param estadopago
	 *            Estadopago
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Estadopago> findAllLike(Estadopago estadopago,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SACODIGO SACODIGO,t1.SADESCES SADESCES,NVL(t1.SADESCEU,t1.SADESCES) SADESCEU ");
		query.append("FROM ESTADOPAGO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(estadopago, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Estadopago>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Estadopago table using like.
	 * 
	 * @param estadopago
	 *            Estadopago
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Estadopago estadopago, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ESTADOPAGO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(estadopago, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Estadopago entity
	 * 
	 * @param estadopago
	 *            Estadopago Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Estadopago estadopago) {

		StringBuilder where = new StringBuilder(
				EstadopagoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (estadopago != null && estadopago.getSacodigo() != null) {
			where.append(" AND t1.SACODIGO = ?");
			params.add(estadopago.getSacodigo());
		}
		if (estadopago != null && estadopago.getSadesces() != null) {
			where.append(" AND t1.SADESCES = ?");
			params.add(estadopago.getSadesces());
		}
		if (estadopago != null && estadopago.getSadesceu() != null) {
			where.append(" AND t1.SADESCEU = ?");
			params.add(estadopago.getSadesceu());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Estadopago entity
	 * 
	 * @param estadopago
	 *            Estadopago Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Estadopago estadopago,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				EstadopagoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (estadopago != null && estadopago.getSacodigo() != null) {
			where.append(" AND UPPER(t1.SACODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(estadopago.getSacodigo().toUpperCase() + "%");
			} else {
				params.add("%" + estadopago.getSacodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.SACODIGO IS NOT NULL");
		}
		if (estadopago != null && estadopago.getSadesces() != null) {
			where.append(" AND UPPER(t1.SADESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(estadopago.getSadesces().toUpperCase() + "%");
			} else {
				params.add("%" + estadopago.getSadesces().toUpperCase() + "%");
			}
			where.append(" AND t1.SADESCES IS NOT NULL");
		}
		if (estadopago != null && estadopago.getSadesceu() != null) {
			where.append(" AND UPPER(t1.SADESCEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(estadopago.getSadesceu().toUpperCase() + "%");
			} else {
				params.add("%" + estadopago.getSadesceu().toUpperCase() + "%");
			}
			where.append(" AND t1.SADESCEU IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
