package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Estadopago;

/**
 * EstadopagoDao  
 *  
 */

public interface EstadopagoDao {
    
    /**
     * Inserts a single row in the Estadopago table.
     *
     * @param estadopago Estadopago
     * @return Estadopago
     */
    Estadopago add(Estadopago estadopago);

    /**
     * Updates a single row in the Estadopago table.
     *
     * @param estadopago Estadopago
     * @return Estadopago
     */
    Estadopago update(Estadopago estadopago);

    /**
     * Finds a single row in the Estadopago table.
     *
     * @param estadopago Estadopago
     * @return Estadopago
     */
    Estadopago find(Estadopago estadopago);

    /**
     * Deletes a single row in the Estadopago table.
     *
     * @param estadopago Estadopago
     * @return 
     */
    void remove(Estadopago estadopago);

    /**
     * Finds a List of rows in the Estadopago table.
     *
     * @param estadopago Estadopago
     * @param pagination Pagination
     * @return List
     */
    List<Estadopago> findAll(Estadopago estadopago, Pagination pagination);

    /**
     * Counts rows in the Estadopago table.
     *
     * @param estadopago Estadopago
     * @return Long
     */
    Long findAllCount(Estadopago estadopago);
	
	/**
     * Finds rows in the Estadopago table using like.
     *
     * @param estadopago Estadopago
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Estadopago> findAllLike(Estadopago estadopago, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Estadopago table using like.
     *
     * @param estadopago Estadopago
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Estadopago estadopago, Boolean startsWith);
}

