package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.arbitrajeWS.DatosEstablecimiento;
import com.ejie.y41b.model.arbitrajeWS.DireccionPostal;
import com.ejie.y41b.model.arbitrajeWS.EstablecimientoWS;
import com.ejie.y41b.utils.config.Y41bConfig;

/**
 * EstablecimientoWSDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class EstablecimientoWSDaoImpl implements EstablecimientoWSDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<DatosEstablecimiento> rwMap = new RowMapper<DatosEstablecimiento>() {
		public DatosEstablecimiento mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			DatosEstablecimiento datosEstablecimiento = new DatosEstablecimiento();
			datosEstablecimiento
					.setRazonSocial(resultSet.getString("ESNOMBRE"));
			datosEstablecimiento.setNombreComercial(resultSet
					.getString("ESNOCO"));
			datosEstablecimiento.setCif(resultSet.getString("ESNIF"));
			datosEstablecimiento.setFechaAltaAdhesion(resultSet
					.getString("ESFEADAR"));
			datosEstablecimiento.setFechaAltaAdhesionEus(resultSet
					.getString("ESFEADAREU"));
			datosEstablecimiento.setNumeroAdhesion(resultSet
					.getString("AHNRDI"));
			DireccionPostal direccionPostal = new DireccionPostal();
			direccionPostal.setCodigoPostal(resultSet.getString("ESNOMBRECP"));
			direccionPostal.setIdPais(resultSet.getString("ESNORAPAISID"));
			direccionPostal.setPais(resultSet.getString("ESNORAPAIS"));
			direccionPostal.setIdProvincia(resultSet
					.getString("ESNORAPROVINCIAID"));
			direccionPostal
					.setProvincia(resultSet.getString("ESNORAPROVINCIA"));
			direccionPostal.setIdMunicipio(resultSet
					.getString("ESNORAMUNICIPIOID"));
			direccionPostal
					.setMunicipio(resultSet.getString("ESNORAMUNICIPIO"));
			direccionPostal.setIdLocalidad(resultSet
					.getString("ESNORALOCALIDADID"));
			direccionPostal
					.setLocalidad(resultSet.getString("ESNORALOCALIDAD"));
			direccionPostal.setIdCalle(resultSet.getString("ESNORACALLEID"));
			direccionPostal.setCalle(resultSet.getString("ESNORACALLE"));
			direccionPostal.setIdPortal(resultSet.getString("ESNORAPORTALID"));
			direccionPostal.setNumeroPortal(resultSet.getString("PORTAL"));
			direccionPostal.setRestoDireccion(resultSet.getString("RESTODIR"));
			datosEstablecimiento.setDireccionPostal(direccionPostal);
			return datosEstablecimiento;
			// return new EstablecimientoWS(resultSet.getString("ESNOMBRE"),
			// resultSet.getString("ESNOCO"),
			// resultSet.getString("ESNIF"),
			// resultSet.getString("ESFEADAR"),
			// resultSet.getString("ESFEADAREU"),
			// resultSet.getInt("AHNRDI"),
			// resultSet.getString("ESNOMBRECP"),
			// resultSet.getString("ESNORAPAISID"),
			// resultSet.getString("ESNORAPAIS"),
			// resultSet.getString("ESNORAPROVINCIAID"),
			// resultSet.getString("ESNORAPROVINCIA"),
			// resultSet.getString("ESNORAMUNICIPIOID"),
			// resultSet.getString("ESNORAMUNICIPIO"),
			// resultSet.getString("ESNORALOCALIDADID"),
			// resultSet.getString("ESNORALOCALIDAD"),
			// resultSet.getString("ESNORACALLEID"),
			// resultSet.getString("ESNORACALLE"),
			// resultSet.getString("ESNORAPORTALID"),
			// resultSet.getString("PORTAL"),
			// resultSet.getString("RESTODIR"));
		}
	};

	private static final String SQL_PARTE_INICIAL = "SELECT LTRIM(A.ESNOMBRE) AS ESNOMBRE, LTRIM(A.ESNOCO) AS ESNOCO, A.ESNIF, CASE WHEN H.AHFEBA IS NOT NULL AND H.AHFEBA < CURRENT_DATE THEN NULL ELSE TO_CHAR(A.ESFEADAR,'DD/MM/YYYY') END AS ESFEADAR, CASE WHEN H.AHFEBA IS NOT NULL AND H.AHFEBA < CURRENT_DATE THEN NULL ELSE TO_CHAR(A.ESFEADAR,'YYYY/MM/DD') END AS ESFEADAREU, CASE WHEN H.AHFEBA IS NOT NULL AND H.AHFEBA < CURRENT_DATE THEN NULL ELSE H.AHNRDI END AS AHNRDI, LTRIM(A.ESNOMBRE_CP) AS ESNOMBRECP, CASE WHEN A.ESNORA_PAIS_ID IS NOT NULL THEN A.ESNORA_PAIS_ID WHEN A.ESNORA_PAIS_ID IS NULL AND B.ID IS NOT NULL THEN '108' END AS ESNORAPAISID, CASE WHEN A.ESNORA_PAIS_ID IS NOT NULL THEN G.DS_O WHEN A.ESNORA_PAIS_ID IS NULL AND B.ID IS NOT NULL THEN (SELECT DS_O FROM T17I.T17_PAIS WHERE ID='108') END AS ESNORAPAIS, A.ESNORA_PROVINCIA_ID AS ESNORAPROVINCIAID, C.DS_O AS ESNORAPROVINCIA, A.ESNORA_MUNICIPIO_ID AS ESNORAMUNICIPIOID, I.DS_O AS ESNORAMUNICIPIO, A.ESNORA_LOCALIDAD_ID AS ESNORALOCALIDADID, J.DS_O AS ESNORALOCALIDAD, A.ESNORA_CALLE_ID AS ESNORACALLEID, K.TIPO_VIA||' '||K.DS_O AS ESNORACALLE, A.ESNORA_PORTAL_ID AS ESNORAPORTALID, L.NUMERO||L.BIS AS PORTAL, LTRIM(A.ESDIRECCION_NOCAPV||' '||A.ESNOMBRE_PISO) AS RESTODIR FROM L21.L2120T00 A, T17I.T17_AUTONOMIA B, T17I.T17_PROVINCIA C, T17I.T17_PAIS G, T17I.T17_MUNICIPIO I, T17I.T17_LOCALIDAD J, T17I.T17_CALLE K, T17I.T17_PORTAL L, L21.L21C9T00 H  ";
	private static final String SQL_PARTE_WHERE = " WHERE A.ESNORA_PROVINCIA_ID=C.ID(+) AND C.AUTONOMIA_ID=B.ID(+) AND A.ESNORA_PAIS_ID=G.ID(+) AND A.ESNORA_MUNICIPIO_ID=I.ID(+) AND A.ESNORA_PROVINCIA_ID=I.PROVINCIA_ID(+) AND A.ESNORA_LOCALIDAD_ID=J.ID(+) AND A.ESNORA_CALLE_ID=K.ID(+) AND A.ESNORA_PORTAL_ID=L.ID(+) AND A.ESCODIGO=H.AHCOES(+) AND (A.ESFEBA IS NULL OR (A.ESFEBA > CURRENT_DATE)) ";
	private static final int MAXIMO_NUMERO_RESULTADOS = 100;
	private static String SQL_PARTE_FINAL = " FETCH FIRST "
			+ EstablecimientoWSDaoImpl.MAXIMO_NUMERO_RESULTADOS + " ROWS ONLY";

	/**
	 * entornoLocal
	 * 
	 * @return boolean
	 */
	private boolean entornoLocal() {
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		String local = (String) prop.getProperty("y41bVistaWar.entorno.local");
		return "true".equals(local);
	}

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds rows in the EstablecimientoWS table using like.
	 * 
	 * @param establecimientoWS
	 *            EstablecimientoWS
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DatosEstablecimiento> findAllLike(
			EstablecimientoWS establecimientoWS, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EstablecimientoWSDaoImpl.SQL_PARTE_INICIAL);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(establecimientoWS,
				startsWith);
		StringBuilder where = new StringBuilder(
				EstablecimientoWSDaoImpl.SQL_PARTE_WHERE);
		where.append(mapaWhere.get("query"));
		query.append(where);

		if (!this.entornoLocal()) {
			query.append(EstablecimientoWSDaoImpl.SQL_PARTE_FINAL);
		}

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<DatosEstablecimiento>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the EstablecimientoWS entity
	 * 
	 * @param establecimientoWS
	 *            EstablecimientoWS Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(EstablecimientoWS establecimientoWS,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				EstablecimientoWSDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (establecimientoWS != null
				&& establecimientoWS.getRazonSocial() != null) {
			where.append(" AND ((UPPER(A.ESNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimientoWS.getRazonSocial().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimientoWS.getRazonSocial().toUpperCase()
						+ "%");
			}
			where.append(" AND A.ESNOMBRE IS NOT NULL)");
			where.append(" OR (UPPER(A.ESNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimientoWS.getRazonSocial().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimientoWS.getRazonSocial().toUpperCase()
						+ "%");
			}
			where.append(" AND A.ESNOCO IS NOT NULL))");
		}
		if (establecimientoWS != null
				&& establecimientoWS.getNombreComercial() != null) {
			where.append(" AND ((UPPER(A.ESNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimientoWS.getNombreComercial().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimientoWS.getNombreComercial().toUpperCase()
						+ "%");
			}
			where.append(" AND A.ESNOMBRE IS NOT NULL)");
			where.append(" OR (UPPER(A.ESNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimientoWS.getNombreComercial().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimientoWS.getNombreComercial().toUpperCase()
						+ "%");
			}
			where.append(" AND A.ESNOCO IS NOT NULL))");
		}
		if (establecimientoWS != null && establecimientoWS.getCif() != null) {
			where.append(" AND UPPER(A.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimientoWS.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + establecimientoWS.getCif().toUpperCase() + "%");
			}
			where.append(" AND A.ESNIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
