package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.EstTipoDoc;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Organismo;

/**
 * * EstablecimientoDaoImpl  
 * 
 *  
 */
@SuppressWarnings(value = { "deprecation" })
@Repository
@Transactional
public class EstablecimientoDaoImpl implements EstablecimientoDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory.getLogger(EstablecimientoDaoImpl.class);

	private RowMapper<Establecimiento> rwMap = new RowMapper<Establecimiento>() {
		public Establecimiento mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Establecimiento establecimiento = new Establecimiento(resultSet.getString("ESCODIGO"),
					resultSet.getString("ESNOMBRE"), resultSet.getString("ESTIPID"), resultSet.getString("ESNIF"),
					resultSet.getString("ESNOAN"), resultSet.getString("ESNOCO"), resultSet.getString("ESNODIR"),
					resultSet.getString("ESCOLO"), resultSet.getString("ESNRCOPO"), resultSet.getString("ESNRTEL"),
					resultSet.getString("ESNRFAX"), resultSet.getString("ESCOPA"), resultSet.getString("ESINCAPR"),
					resultSet.getString("ESINDEMP"), resultSet.getString("ESTECO"), resultSet.getString("ESINADAR"),
					resultSet.getDate("ESFEADAR"), resultSet.getString("ESCOEM"),
					resultSet.getString("ESMAILNOTIFICACION"), resultSet.getString("ESINEMPR"),
					resultSet.getString("ESNRTEL2"), resultSet.getDate("ESFEBA"), resultSet.getString("ESNOAP1"),
					resultSet.getString("ESNOAP2"), resultSet.getString("ESNOLO"), resultSet.getString("ESCOMAPV"),
					resultSet.getString("ESCOCA"), resultSet.getString("ESNOPECO"), resultSet.getString("ESCOIDCO"),
					resultSet.getString("ESINRECO"), resultSet.getString("ESFEMOD"), resultSet.getString("ESINESCO"),
					resultSet.getString("ESNOMU"), resultSet.getString("ESNOREP"), resultSet.getString("ESNIFREP"),
					resultSet.getString("DTTEEMR"), resultSet.getString("ESCAREP"), resultSet.getString("ESTEURL"),
					resultSet.getString("ESCOOE"), resultSet.getString("ESNODECO"), resultSet.getString("ESINTIAR"),
					resultSet.getDate("ESFEPLAD"), resultSet.getString("ESINDEME"), resultSet.getString("ESNORAPAISID"),
					resultSet.getString("ESNORAPAISNOMBRE"), resultSet.getString("ESNORAPROVINCIAID"),
					resultSet.getString("ESNOMBREPROVINCIA"), resultSet.getString("ESNORAMUNICIPIOID"),
					resultSet.getString("ESNOMBREMUNICIPIO"), resultSet.getString("ESNORALOCALIDADID"),
					resultSet.getString("ESNOMBRELOCALIDAD"), resultSet.getString("ESNORACALLEID"),
					resultSet.getString("ESNOMBRECALLE"), resultSet.getString("ESNORACPID"),
					resultSet.getString("ESNOMBRECP"), resultSet.getString("ESNORAPORTALID"),
					resultSet.getString("ESNOMBREPORTAL"), resultSet.getString("ESNOMBREPISO"),
					resultSet.getString("ESDIRECCION_NOCAPV"), resultSet.getString("ESEXTRANJERO"), null,
					resultSet.getString("ESSEDE"),
					new CensoMonitor(resultSet.getString("CensoMonitorMOCODIGO"),
							resultSet.getString("CensoMonitorMONOMBRE"), resultSet.getString("CensoMonitorMOCOEM"),
							resultSet.getString("CensoMonitorMODNI"), resultSet.getString("CensoMonitorUSUARIOXLNET"),
							resultSet.getString("CensoMonitorPUESTOXLNET"), resultSet.getDate("CensoMonitorMOFECBAJA"),
							new Organismo(resultSet.getString("CensoMonitorMOCOOR")), null, null, null, null, null,
							null, null, null, null, null, null, null, null, null));
			establecimiento.setEsfeerd(resultSet.getDate("ESFEERD"));
			// 0149469
			establecimiento.setEsilocalizable(resultSet.getString("ESILOCALIZABLE"));
			establecimiento.setEsnocolabora(resultSet.getString("ESNOCOLABORA"));
			// 0149469
			establecimiento.setAhnrdi(resultSet.getString("AHNRDI"));
			return establecimiento;
		}
	};

	private RowMapper<Establecimiento> rwMap2 = new RowMapper<Establecimiento>() {
		public Establecimiento mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEsnif(resultSet.getString("ESNIF"));
			return establecimiento;
		}
	};

	private RowMapper<EstablecimientoDetalle> rwMapEstablecimientoDetalle = new RowMapper<EstablecimientoDetalle>() {
		public EstablecimientoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			EstablecimientoDetalle establecimiento = new EstablecimientoDetalle(resultSet.getString("ESCODIGO"),
					resultSet.getString("CensoMonitorMOCODIGO"), resultSet.getString("CensoMonitorMONOMBRE"),
					resultSet.getString("CensoMonitorUSUARIOXLNET"), resultSet.getString("ESNOMBRE"),
					resultSet.getString("ESTIPID"), resultSet.getString("ESNIF"), resultSet.getString("ESNOAN"),
					resultSet.getString("ESNOCO"), resultSet.getString("ESNODIR"), resultSet.getString("ESCOLO"),
					resultSet.getString("ESNRCOPO"), resultSet.getString("ESNRTEL"), resultSet.getString("ESNRFAX"),
					resultSet.getString("ESCOPA"), resultSet.getString("ESINCAPR"), resultSet.getString("ESINDEMP"),
					resultSet.getString("ESTECO"), resultSet.getString("ESINADAR"), resultSet.getDate("ESFEADAR"),
					resultSet.getString("ESCOEM"), resultSet.getString("ESMAILNOTIFICACION"),
					resultSet.getString("ESINEMPR"), resultSet.getString("ESNRTEL2"), null, // resultSet.getString("ESINFEBA"),
					resultSet.getDate("ESFEBA"), resultSet.getString("ESNOAP1"), resultSet.getString("ESNOAP2"),
					resultSet.getString("ESNOLO"), resultSet.getString("ESCOMAPV"), resultSet.getString("ESCOCA"),
					resultSet.getString("ESNOPECO"), resultSet.getString("ESCOIDCO"), resultSet.getString("ESINRECO"),
					resultSet.getString("ESFEMOD"), resultSet.getString("ESINESCO"), resultSet.getString("ESNOMU"),
					resultSet.getString("ESNOREP"), resultSet.getString("ESNIFREP"), resultSet.getString("DTTEEMR"),
					resultSet.getString("ESCAREP"), resultSet.getString("ESTEURL"), resultSet.getString("ESCOOE"),
					resultSet.getString("ESNODECO"), resultSet.getString("ESINTIAR"), resultSet.getDate("ESFEPLAD"),
					resultSet.getString("ESINDEME"), resultSet.getString("ESNORAPAISID"),
					resultSet.getString("ESNORAPAISNOMBRE"), resultSet.getString("ESNORAPROVINCIAID"),
					resultSet.getString("ESNOMBREPROVINCIA"), resultSet.getString("ESNORAMUNICIPIOID"),
					resultSet.getString("ESNOMBREMUNICIPIO"), resultSet.getString("ESNORALOCALIDADID"),
					resultSet.getString("ESNOMBRELOCALIDAD"), resultSet.getString("ESNORACALLEID"),
					resultSet.getString("ESNOMBRECALLE"), resultSet.getString("ESNORACPID"),
					resultSet.getString("ESNOMBRECP"), resultSet.getString("ESNORAPORTALID"),
					resultSet.getString("ESNOMBREPORTAL"), resultSet.getString("ESNOMBREPISO"),
					resultSet.getString("ESDIRECCION_NOCAPV"), null, // resultSet.getString("ESDIRECCIONCOMPLETA"),
					null, null, null, null, null, null, null, null, null, resultSet.getString("ESEXTRANJERO"),
					resultSet.getString("ESSEDE"));
			establecimiento.setEsfeerd(resultSet.getDate("ESFEERD"));
			// 0149469
			establecimiento.setEsilocalizable(resultSet.getString("ESILOCALIZABLE"));
			establecimiento.setEsnocolabora(resultSet.getString("ESNOCOLABORA"));
			// 0149469
			return establecimiento;
		}
	};

	// 0145820: Empresas adheridas: falta de incorporar acceso a documentos
	private RowMapper<EstTipoDoc> rwMapEstTipoDoc = new RowMapper<EstTipoDoc>() {
		public EstTipoDoc mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			EstTipoDoc estTipoDoc = new EstTipoDoc();
			estTipoDoc.setEtdid(resultSet.getString("ETDID"));
			estTipoDoc.setidETipodoc(resultSet.getString("ID_ETIPODOC"));
			estTipoDoc.setEtdnombre(resultSet.getString("ETDNOMBRE"));
			estTipoDoc.setEtdnombree(resultSet.getString("ETDNOMBREE"));
			return estTipoDoc;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Pagination
	 * @return Establecimiento
	 */
	public Establecimiento add(Establecimiento establecimiento) {

		String query = "INSERT INTO ESTABLECIMIENTO( ESCODIGO,ESCOZS,ESNOMBRE,ESTIPID,ESNIF,ESNOAN,ESNOCO,ESNODIR,ESCOLO,ESNRCOPO,ESNRTEL,ESNRFAX,ESCOPA,ESINCAPR,ESINDEMP,ESTECO,ESINADAR,ESFEADAR,ESCOEM,ESMAILNOTIFICACION,ESINEMPR,ESNRTEL2,ESFEBA,ESNOAP1,ESNOAP2,ESNOLO,ESCOMAPV,ESCOCA,ESNOPECO,ESCOIDCO,ESINRECO,ESFEMOD,ESINESCO,ESNOMU,ESNOREP,ESNIFREP,DTTEEMR,ESCAREP,ESTEURL,ESCOOE,ESNODECO,ESINTIAR,ESFEPLAD,ESINDEME,ESNORA_PAIS_ID,ESNORA_PAIS_NOMBRE,ESNORA_PROVINCIA_ID,ESNOMBRE_PROVINCIA,ESNORA_MUNICIPIO_ID,ESNOMBRE_MUNICIPIO,ESNORA_LOCALIDAD_ID,ESNOMBRE_LOCALIDAD,ESNORA_CALLE_ID,ESNOMBRE_CALLE,ESNORA_CP_ID,ESNOMBRE_CP,ESNORA_PORTAL_ID,ESNOMBRE_PORTAL,ESNOMBRE_PISO,ESDIRECCION_NOCAPV,ESEXTRANJERO,ESSEDE,ESFEERD)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getCensoMonitorMocodigoAux = null;
		if (establecimiento.getCensoMonitor() != null && establecimiento.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = establecimiento.getCensoMonitor().getMocodigo();
		}
		this.jdbcTemplate.update(query, establecimiento.getEscodigo(), getCensoMonitorMocodigoAux,
				establecimiento.getEsnombre(), establecimiento.getEstipid(), establecimiento.getEsnif(),
				establecimiento.getEsnoan(), establecimiento.getEsnoco(), establecimiento.getEsnodir(),
				establecimiento.getEscolo(), establecimiento.getEsnrcopo(), establecimiento.getEsnrtel(),
				establecimiento.getEsnrfax(), establecimiento.getEscopa(), establecimiento.getEsincapr(),
				establecimiento.getEsindemp(), establecimiento.getEsteco(), establecimiento.getEsinadar(),
				establecimiento.getEsfeadar(), establecimiento.getEscoem(), establecimiento.getEsmailnotificacion(),
				establecimiento.getEsinempr(), establecimiento.getEsnrtel2(), establecimiento.getEsfeba(),
				establecimiento.getEsnoap1(), establecimiento.getEsnoap2(), establecimiento.getEsnolo(),
				establecimiento.getEscomapv(), establecimiento.getEscoca(), establecimiento.getEsnopeco(),
				establecimiento.getEscoidco(), establecimiento.getEsinreco(), establecimiento.getEsfemod(),
				establecimiento.getEsinesco(), establecimiento.getEsnomu(), establecimiento.getEsnorep(),
				establecimiento.getEsnifrep(), establecimiento.getDtteemr(), establecimiento.getEscarep(),
				establecimiento.getEsteurl(), establecimiento.getEscooe(), establecimiento.getEsnodeco(),
				establecimiento.getEsintiar(), establecimiento.getEsfeplad(), establecimiento.getEsindeme(),
				establecimiento.getEsnoraPaisId(), establecimiento.getEsnoraPaisNombre(),
				establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
				establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
				establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
				establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(), establecimiento.getEsnoraCpId(),
				establecimiento.getEsnombreCp(), establecimiento.getEsnoraPortalId(),
				establecimiento.getEsnombrePortal(), establecimiento.getEsnombrePiso(),
				establecimiento.getEsdireccion_nocapv(), establecimiento.getEsextranjero(), establecimiento.getEssede(),
				establecimiento.getEsfeerd());
		return establecimiento;
	}

	/**
	 * Updates a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Pagination
	 * @return Establecimiento
	 */
	public Establecimiento update(Establecimiento establecimiento) {
		String query = "UPDATE ESTABLECIMIENTO SET ESCOZS=?,ESNOMBRE=?,ESTIPID=?,ESNIF=?,ESNOCO=?,ESNRTEL=?,ESTECO=?,ESINADAR=?,ESFEADAR=?,ESCOEM=?,ESMAILNOTIFICACION=?,ESNRTEL2=?,ESFEBA=?,ESNOPECO=?,ESCOIDCO=?,ESFEMOD=?,ESTEURL=?,ESNORA_PAIS_ID=?,ESNORA_PAIS_NOMBRE=?,ESNORA_PROVINCIA_ID=?,ESNOMBRE_PROVINCIA=?,ESNORA_MUNICIPIO_ID=?,ESNOMBRE_MUNICIPIO=?,ESNORA_LOCALIDAD_ID=?,ESNOMBRE_LOCALIDAD=?,ESNORA_CALLE_ID=?,ESNOMBRE_CALLE=?,ESNORA_CP_ID=?,ESNOMBRE_CP=?,ESNORA_PORTAL_ID=?,ESNOMBRE_PORTAL=?,ESNOMBRE_PISO=?,ESDIRECCION_NOCAPV=?,ESEXTRANJERO=?,ESSEDE=?,ESCOOE=?,ESNOREP=?,ESNIFREP=?, ESINTIAR=?, ESFEERD=?, ESILOCALIZABLE=?, ESNOCOLABORA=? WHERE ESCODIGO=?";
		Object getCensoMonitorMocodigoAux = null;
		if (establecimiento.getCensoMonitor() != null && establecimiento.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = establecimiento.getCensoMonitor().getMocodigo();
		}
		this.jdbcTemplate.update(query, getCensoMonitorMocodigoAux, establecimiento.getEsnombre(),
				establecimiento.getEstipid(), establecimiento.getEsnif(), establecimiento.getEsnoco(),
				establecimiento.getEsnrtel(), establecimiento.getEsteco(), establecimiento.getEsinadar(),
				establecimiento.getEsfeadar(), establecimiento.getEscoem(), establecimiento.getEsmailnotificacion(),
				establecimiento.getEsnrtel2(), establecimiento.getEsfeba(), establecimiento.getEsnopeco(),
				establecimiento.getEscoidco(), establecimiento.getEsfemod(), establecimiento.getEsteurl(),
				establecimiento.getEsnoraPaisId(), establecimiento.getEsnoraPaisNombre(),
				establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
				establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
				establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
				establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(), establecimiento.getEsnoraCpId(),
				establecimiento.getEsnombreCp(), establecimiento.getEsnoraPortalId(),
				establecimiento.getEsnombrePortal(), establecimiento.getEsnombrePiso(),
				establecimiento.getEsdireccion_nocapv(), establecimiento.getEsextranjero(), establecimiento.getEssede(),
				establecimiento.getEscooe(), establecimiento.getEsnorep(), establecimiento.getEsnifrep(),
				establecimiento.getEsintiar(), establecimiento.getEsfeerd(), establecimiento.getEsilocalizable(),
				establecimiento.getEsnocolabora(), establecimiento.getEscodigo());
		return establecimiento;
	}

	/**
	 * Updates a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Pagination
	 * @return Establecimiento
	 */
	public Establecimiento updateSede(Establecimiento establecimiento) {
		String query = "UPDATE ESTABLECIMIENTO SET ESSEDE=? WHERE ESCODIGO=?";

		this.jdbcTemplate.update(query, establecimiento.getEssede(), establecimiento.getEscodigo());
		return establecimiento;
	}

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Pagination
	 * @return Establecimiento
	 */
	@Transactional(readOnly = true)
	public Establecimiento find(Establecimiento establecimiento) {
		// 0150111 aniadimos mas opciones X y C al case
		String query = "SELECT t1.ESCODIGO ESCODIGO, t1.ESNOMBRE ESNOMBRE, t1.ESTIPID ESTIPID, t1.ESNIF ESNIF, t1.ESNOAN ESNOAN, t1.ESNOCO ESNOCO, t1.ESNODIR ESNODIR, t1.ESCOLO ESCOLO, t1.ESNRCOPO ESNRCOPO, t1.ESNRTEL ESNRTEL, t1.ESNRFAX ESNRFAX, t1.ESCOPA ESCOPA, t1.ESINCAPR ESINCAPR, t1.ESINDEMP ESINDEMP, t1.ESTECO ESTECO, t1.ESFEADAR ESFEADAR, t1.ESCOEM ESCOEM, t1.ESMAILNOTIFICACION ESMAILNOTIFICACION, t1.ESINEMPR ESINEMPR, t1.ESNRTEL2 ESNRTEL2, t1.ESFEBA ESFEBA, t1.ESNOAP1 ESNOAP1, t1.ESNOAP2 ESNOAP2, t1.ESNOLO ESNOLO, t1.ESCOMAPV ESCOMAPV, t1.ESCOCA ESCOCA, t1.ESNOPECO ESNOPECO, t1.ESCOIDCO ESCOIDCO, t1.ESINRECO ESINRECO, t1.ESFEMOD ESFEMOD, t1.ESINESCO ESINESCO, t1.ESNOMU ESNOMU, t1.ESNOREP ESNOREP, t1.ESNIFREP ESNIFREP, t1.DTTEEMR DTTEEMR, t1.ESCAREP ESCAREP, t1.ESTEURL ESTEURL, t1.ESCOOE ESCOOE, t1.ESNODECO ESNODECO, t1.ESINTIAR ESINTIAR, t1.ESFEPLAD ESFEPLAD, t1.ESINDEME ESINDEME, t1.ESNORA_PAIS_ID ESNORAPAISID, t1.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBRE, t1.ESNORA_PROVINCIA_ID ESNORAPROVINCIAID, t1.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIA, t1.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOID, t1.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIO, t1.ESNORA_LOCALIDAD_ID ESNORALOCALIDADID, t1.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDAD, t1.ESNORA_CALLE_ID ESNORACALLEID, t1.ESNOMBRE_CALLE ESNOMBRECALLE, t1.ESNORA_CP_ID ESNORACPID, t1.ESNOMBRE_CP ESNOMBRECP, t1.ESNORA_PORTAL_ID ESNORAPORTALID, t1.ESNOMBRE_PORTAL ESNOMBREPORTAL, t1.ESNOMBRE_PISO ESNOMBREPISO, t1.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPV, t1.ESEXTRANJERO ESEXTRANJERO, t1.ESSEDE ESSEDE, t2.MOCODIGO CENSOMONITORMOCODIGO, t2.MONOMBRE CENSOMONITORMONOMBRE, t2.MOCOEM CENSOMONITORMOCOEM, t2.MODNI CENSOMONITORMODNI, t2.USUARIOXLNET CENSOMONITORUSUARIOXLNET, t2.PUESTOXLNET CENSOMONITORPUESTOXLNET, t2.MOFECBAJA CENSOMONITORMOFECBAJA, t2.MOCOOR CENSOMONITORMOCOOR, t3.AHNRDI AHNRDI, "
				// Se comenta las nuevas opciones a raiz de lo decidido el dia
				// 14/04/2020 y se vuelve a poner lo que habia antes
				// +
				// "CASE WHEN t1.ESFEADAR IS NULL OR t3.AHCODIGO IS NULL THEN
				// 'N' WHEN t1.ESFEBA IS NOT NULL AND t1.ESFEBA<SYSDATE AND
				// (t1.ESFEADAR IS NULL OR (t1.ESFEADAR IS NOT NULL AND
				// t3.AHFEBA IS NOT NULL AND t3.AHFEBA < t1.ESFEBA)) AND
				// (t1.ESFEADAR IS NULL OR (t1.ESFEADAR IS NOT NULL AND
				// t3.AHFERE IS NOT NULL AND t3.AHFERE < t1.ESFEBA)) THEN 'X'
				// WHEN t1.ESFEBA IS NOT NULL AND t1.ESFEBA<SYSDATE AND
				// (t3.AHFEBA IS NULL OR (t3.AHFEBA IS NOT NULL AND t3.AHFEBA >
				// t1.ESFEBA)) AND (t3.AHFERE IS NULL OR (t3.AHFERE IS NOT NULL
				// AND t3.AHFERE > t1.ESFEBA)) AND t1.ESFEADAR IS NOT NULL AND
				// t3.AHCODIGO IS NOT NULL THEN 'C' WHEN t3.AHCODIGO IS NOT NULL
				// AND t3.AHFEBA IS NOT NULL AND t3.AHFEBA<SYSDATE THEN 'B' ELSE
				// 'A' END ESINADAR, ESFEERD, ESILOCALIZABLE, ESNOCOLABORA "
				// 0153887 aniadimos caso 'S' cuando este cerrado para que no
				// saque icono
				+ "CASE WHEN t1.ESFEBA IS NOT NULL THEN 'S' WHEN t1.ESFEADAR IS NULL OR t3.AHCODIGO IS NULL THEN 'N' "
				+ " WHEN t3.AHCODIGO IS NOT NULL AND t3.AHFEBA IS NOT NULL AND t3.AHFEBA<SYSDATE THEN 'B' "
				// +
				// " WHEN t3.AHCODIGO IS NOT NULL AND t3.AHTELIMI IS NOT NULL
				// THEN 'L' "
				+ " ELSE 'A' END ESINADAR, ESFEERD, ESILOCALIZABLE, ESNOCOLABORA "
				+ "FROM ESTABLECIMIENTO t1 , CENSO_MONITOR t2, ESTABLECIM_ARBITRA t3 "
				+ "WHERE t1.ESCODIGO = ? AND t1.ESCOZS= t2.MOCODIGO(+) AND t1.ESCODIGO = t3.AHCOES(+) ";
		return (Establecimiento) this.jdbcTemplate.queryForObject(query, rwMap, establecimiento.getEscodigo());
	}

	/**
	 * Removes a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Pagination
	 * @return
	 */
	public void remove(Establecimiento establecimiento) {
		String query = "DELETE  FROM ESTABLECIMIENTO WHERE ESCODIGO=?";
		this.jdbcTemplate.update(query, establecimiento.getEscodigo());
	}

	/**
	 * Finds a List of rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	// CHECKSTYLE:OFF
	@Transactional(readOnly = true)
	public List<Establecimiento> findAll(Establecimiento establecimiento, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ESCOZS= t2.MOCODIGO(+) AND t1.ESCODIGO = t3.AHCOES(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ESCODIGO ESCODIGO,t1.ESNOMBRE ESNOMBRE, t1.ESTIPID ESTIPID,t1.ESNIF ESNIF,t1.ESNOAN ESNOAN,t1.ESNOCO ESNOCO,t1.ESNODIR ESNODIR,t1.ESCOLO ESCOLO,t1.ESNRCOPO ESNRCOPO,t1.ESNRTEL ESNRTEL,t1.ESNRFAX ESNRFAX,t1.ESCOPA ESCOPA,t1.ESINCAPR ESINCAPR,t1.ESINDEMP ESINDEMP,t1.ESTECO ESTECO,t1.ESINADAR ESINADAR,t1.ESFEADAR ESFEADAR,t1.ESCOEM ESCOEM, t1.ESMAILNOTIFICACION ESMAILNOTIFICACION, t1.ESINEMPR ESINEMPR,t1.ESNRTEL2 ESNRTEL2,t1.ESFEBA ESFEBA,t1.ESNOAP1 ESNOAP1,t1.ESNOAP2 ESNOAP2,t1.ESNOLO ESNOLO,t1.ESCOMAPV ESCOMAPV,t1.ESCOCA ESCOCA,t1.ESNOPECO ESNOPECO,t1.ESCOIDCO ESCOIDCO,t1.ESINRECO ESINRECO,t1.ESFEMOD ESFEMOD,t1.ESINESCO ESINESCO,t1.ESNOMU ESNOMU,t1.ESNOREP ESNOREP,t1.ESNIFREP ESNIFREP,t1.DTTEEMR DTTEEMR,t1.ESCAREP ESCAREP,t1.ESTEURL ESTEURL,t1.ESCOOE ESCOOE,t1.ESNODECO ESNODECO,t1.ESINTIAR ESINTIAR,t1.ESFEPLAD ESFEPLAD,t1.ESINDEME ESINDEME,t1.ESNORA_PAIS_ID ESNORAPAISID,t1.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBRE,t1.ESNORA_PROVINCIA_ID ESNORAPROVINCIAID,t1.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIA,t1.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOID,t1.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIO,t1.ESNORA_LOCALIDAD_ID ESNORALOCALIDADID,t1.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDAD,t1.ESNORA_CALLE_ID ESNORACALLEID,t1.ESNOMBRE_CALLE ESNOMBRECALLE,t1.ESNORA_CP_ID ESNORACPID,t1.ESNOMBRE_CP ESNOMBRECP,t1.ESNORA_PORTAL_ID ESNORAPORTALID,t1.ESNOMBRE_PORTAL ESNOMBREPORTAL,t1.ESNOMBRE_PISO ESNOMBREPISO, t1.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPV, t1.ESEXTRANJERO ESEXTRANJERO, t1.ESSEDE ESSEDE,t2.MOCODIGO CENSOMONITORMOCODIGO,t2.MONOMBRE CENSOMONITORMONOMBRE,t2.MOCOEM CENSOMONITORMOCOEM, t2.MODNI CENSOMONITORMODNI, t2.USUARIOXLNET CENSOMONITORUSUARIOXLNET, t2.PUESTOXLNET CENSOMONITORPUESTOXLNET,t2.MOFECBAJA CENSOMONITORMOFECBAJA,t2.MOCOOR CENSOMONITORMOCOOR, t1.ESFEERD ESFEERD, t1.ESILOCALIZABLE ESILOCALIZABLE, t1.ESNOCOLABORA ESNOCOLABORA, t3.AHNRDI AHNRDI "
						+ "FROM ESTABLECIMIENTO t1 ,CENSO_MONITOR t2, ESTABLECIM_ARBITRA t3 ");

		if (establecimiento != null && establecimiento.getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(establecimiento.getEscodigo());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO = ?");
			params.add(establecimiento.getCensoMonitor().getMocodigo());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getOrganismo() != null
				&& establecimiento.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.MOCOOR = ?");
			params.add(establecimiento.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t2.MONOMBRE = ?");
			params.add(establecimiento.getCensoMonitor().getMonombre());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t2.MOCOEM = ?");
			params.add(establecimiento.getCensoMonitor().getMocoem());
		}

		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA = ?");
			params.add(establecimiento.getCensoMonitor().getMofecbaja());
		}

		if (establecimiento != null && establecimiento.getEsnombre() != null) {
			where.append(" AND t1.ESNOMBRE = ?");
			params.add(establecimiento.getEsnombre());
		}
		if (establecimiento != null && establecimiento.getEsnif() != null) {
			where.append(" AND t1.ESNIF = ?");
			params.add(establecimiento.getEsnif());
		}
		if (establecimiento != null && establecimiento.getEsnoan() != null) {
			where.append(" AND t1.ESNOAN = ?");
			params.add(establecimiento.getEsnoan());
		}
		if (establecimiento != null && establecimiento.getEsnoco() != null) {
			where.append(" AND t1.ESNOCO = ?");
			params.add(establecimiento.getEsnoco());
		}
		if (establecimiento != null && establecimiento.getEsnodir() != null) {
			where.append(" AND t1.ESNODIR = ?");
			params.add(establecimiento.getEsnodir());
		}
		if (establecimiento != null && establecimiento.getEscolo() != null) {
			where.append(" AND t1.ESCOLO = ?");
			params.add(establecimiento.getEscolo());
		}
		if (establecimiento != null && establecimiento.getEsnrcopo() != null) {
			where.append(" AND t1.ESNRCOPO = ?");
			params.add(establecimiento.getEsnrcopo());
		}
		if (establecimiento != null && establecimiento.getEsnrtel() != null) {
			where.append(" AND t1.ESNRTEL = ?");
			params.add(establecimiento.getEsnrtel());
		}
		if (establecimiento != null && establecimiento.getEsnrfax() != null) {
			where.append(" AND t1.ESNRFAX = ?");
			params.add(establecimiento.getEsnrfax());
		}
		if (establecimiento != null && establecimiento.getEscopa() != null) {
			where.append(" AND t1.ESCOPA = ?");
			params.add(establecimiento.getEscopa());
		}
		if (establecimiento != null && establecimiento.getEsincapr() != null) {
			where.append(" AND t1.ESINCAPR = ?");
			params.add(establecimiento.getEsincapr());
		}
		if (establecimiento != null && establecimiento.getEsindemp() != null) {
			where.append(" AND t1.ESINDEMP = ?");
			params.add(establecimiento.getEsindemp());
		}
		if (establecimiento != null && establecimiento.getEsteco() != null) {
			where.append(" AND t1.ESTECO = ?");
			params.add(establecimiento.getEsteco());
		}
		if (establecimiento != null && establecimiento.getEsinadar() != null) {
			where.append(" AND t1.ESINADAR = ?");
			params.add(establecimiento.getEsinadar());
		}
		if (establecimiento != null && establecimiento.getEsfeadar() != null) {
			where.append(" AND t1.ESFEADAR = ?");
			params.add(establecimiento.getEsfeadar());
		}
		if (establecimiento != null && establecimiento.getEscoem() != null) {
			where.append(" AND t1.ESCOEM = ?");
			params.add(establecimiento.getEscoem());
		}
		if (establecimiento != null && establecimiento.getEsinempr() != null) {
			where.append(" AND t1.ESINEMPR = ?");
			params.add(establecimiento.getEsinempr());
		}
		if (establecimiento != null && establecimiento.getEsnrtel2() != null) {
			where.append(" AND t1.ESNRTEL2 = ?");
			params.add(establecimiento.getEsnrtel2());
		}
		if (establecimiento != null && establecimiento.getEsfeba() != null) {
			where.append(" AND t1.ESFEBA = ?");
			params.add(establecimiento.getEsfeba());
		}
		if (establecimiento != null && establecimiento.getEsnoap1() != null) {
			where.append(" AND t1.ESNOAP1 = ?");
			params.add(establecimiento.getEsnoap1());
		}
		if (establecimiento != null && establecimiento.getEsnoap2() != null) {
			where.append(" AND t1.ESNOAP2 = ?");
			params.add(establecimiento.getEsnoap2());
		}
		if (establecimiento != null && establecimiento.getEsnolo() != null) {
			where.append(" AND t1.ESNOLO = ?");
			params.add(establecimiento.getEsnolo());
		}
		if (establecimiento != null && establecimiento.getEscomapv() != null) {
			where.append(" AND t1.ESCOMAPV = ?");
			params.add(establecimiento.getEscomapv());
		}
		if (establecimiento != null && establecimiento.getEscoca() != null) {
			where.append(" AND t1.ESCOCA = ?");
			params.add(establecimiento.getEscoca());
		}
		if (establecimiento != null && establecimiento.getEsnopeco() != null) {
			where.append(" AND t1.ESNOPECO = ?");
			params.add(establecimiento.getEsnopeco());
		}
		if (establecimiento != null && establecimiento.getEscoidco() != null) {
			where.append(" AND t1.ESCOIDCO = ?");
			params.add(establecimiento.getEscoidco());
		}
		if (establecimiento != null && establecimiento.getEsinreco() != null) {
			where.append(" AND t1.ESINRECO = ?");
			params.add(establecimiento.getEsinreco());
		}
		if (establecimiento != null && establecimiento.getEsfemod() != null) {
			where.append(" AND t1.ESFEMOD = ?");
			params.add(establecimiento.getEsfemod());
		}
		if (establecimiento != null && establecimiento.getEsinesco() != null) {
			where.append(" AND t1.ESINESCO = ?");
			params.add(establecimiento.getEsinesco());
		}
		if (establecimiento != null && establecimiento.getEsnomu() != null) {
			where.append(" AND t1.ESNOMU = ?");
			params.add(establecimiento.getEsnomu());
		}
		if (establecimiento != null && establecimiento.getEsnorep() != null) {
			where.append(" AND t1.ESNOREP = ?");
			params.add(establecimiento.getEsnorep());
		}
		if (establecimiento != null && establecimiento.getEsnifrep() != null) {
			where.append(" AND t1.ESNIFREP = ?");
			params.add(establecimiento.getEsnifrep());
		}
		if (establecimiento != null && establecimiento.getDtteemr() != null) {
			where.append(" AND t1.DTTEEMR = ?");
			params.add(establecimiento.getDtteemr());
		}
		if (establecimiento != null && establecimiento.getEscarep() != null) {
			where.append(" AND t1.ESCAREP = ?");
			params.add(establecimiento.getEscarep());
		}
		if (establecimiento != null && establecimiento.getEsteurl() != null) {
			where.append(" AND t1.ESTEURL = ?");
			params.add(establecimiento.getEsteurl());
		}
		if (establecimiento != null && establecimiento.getEscooe() != null) {
			where.append(" AND t1.ESCOOE = ?");
			params.add(establecimiento.getEscooe());
		}
		if (establecimiento != null && establecimiento.getEsnodeco() != null) {
			where.append(" AND t1.ESNODECO = ?");
			params.add(establecimiento.getEsnodeco());
		}
		if (establecimiento != null && establecimiento.getEsintiar() != null) {
			where.append(" AND t1.ESINTIAR = ?");
			params.add(establecimiento.getEsintiar());
		}
		if (establecimiento != null && establecimiento.getEsfeplad() != null) {
			where.append(" AND t1.ESFEPLAD = ?");
			params.add(establecimiento.getEsfeplad());
		}
		if (establecimiento != null && establecimiento.getEsindeme() != null) {
			where.append(" AND t1.ESINDEME = ?");
			params.add(establecimiento.getEsindeme());
		}
		if (establecimiento != null && establecimiento.getEsnoraPaisId() != null) {
			where.append(" AND t1.ESNORA_PAIS_ID = ?");
			params.add(establecimiento.getEsnoraPaisId());
		}
		if (establecimiento != null && establecimiento.getEsnoraPaisNombre() != null) {
			where.append(" AND t1.ESNORA_PAIS_NOMBRE = ?");
			params.add(establecimiento.getEsnoraPaisNombre());
		}
		if (establecimiento != null && establecimiento.getEsnoraProvinciaId() != null) {
			where.append(" AND t1.ESNORA_PROVINCIA_ID = ?");
			params.add(establecimiento.getEsnoraProvinciaId());
		}
		if (establecimiento != null && establecimiento.getEsnombreProvincia() != null) {
			where.append(" AND t1.ESNOMBRE_PROVINCIA = ?");
			params.add(establecimiento.getEsnombreProvincia());
		}
		if (establecimiento != null && establecimiento.getEsnoraMunicipioId() != null) {
			where.append(" AND t1.ESNORA_MUNICIPIO_ID = ?");
			params.add(establecimiento.getEsnoraMunicipioId());
		}
		if (establecimiento != null && establecimiento.getEsnombreMunicipio() != null) {
			where.append(" AND t1.ESNOMBRE_MUNICIPIO = ?");
			params.add(establecimiento.getEsnombreMunicipio());
		}
		if (establecimiento != null && establecimiento.getEsnoraLocalidadId() != null) {
			where.append(" AND t1.ESNORA_LOCALIDAD_ID = ?");
			params.add(establecimiento.getEsnoraLocalidadId());
		}
		if (establecimiento != null && establecimiento.getEsnombreLocalidad() != null) {
			where.append(" AND t1.ESNOMBRE_LOCALIDAD = ?");
			params.add(establecimiento.getEsnombreLocalidad());
		}
		if (establecimiento != null && establecimiento.getEsnoraCalleId() != null) {
			where.append(" AND t1.ESNORA_CALLE_ID = ?");
			params.add(establecimiento.getEsnoraCalleId());
		}
		if (establecimiento != null && establecimiento.getEsnombreCalle() != null) {
			where.append(" AND t1.ESNOMBRE_CALLE = ?");
			params.add(establecimiento.getEsnombreCalle());
		}
		if (establecimiento != null && establecimiento.getEsnoraCpId() != null) {
			where.append(" AND t1.ESNORA_CP_ID = ?");
			params.add(establecimiento.getEsnoraCpId());
		}
		if (establecimiento != null && establecimiento.getEsnombreCp() != null) {
			where.append(" AND t1.ESNOMBRE_CP = ?");
			params.add(establecimiento.getEsnombreCp());
		}
		if (establecimiento != null && establecimiento.getEsnoraPortalId() != null) {
			where.append(" AND t1.ESNORA_PORTAL_ID = ?");
			params.add(establecimiento.getEsnoraPortalId());
		}
		if (establecimiento != null && establecimiento.getEsnombrePortal() != null) {
			where.append(" AND t1.ESNOMBRE_PORTAL = ?");
			params.add(establecimiento.getEsnombrePortal());
		}
		if (establecimiento != null && establecimiento.getEsnombrePiso() != null) {
			where.append(" AND t1.ESNOMBRE_PISO = ?");
			params.add(establecimiento.getEsnombrePiso());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Establecimiento>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	@Transactional(readOnly = true)
	// CHECKSTYLE:OFF
	public Long findAllCount(Establecimiento establecimiento) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.ESCOZS= t2.MOCODIGO(+) ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ESTABLECIMIENTO t1   ,  CENSO_MONITOR t2  ");
		if (establecimiento != null && establecimiento.getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(establecimiento.getEscodigo());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO = ?");
			params.add(establecimiento.getCensoMonitor().getMocodigo());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getOrganismo() != null
				&& establecimiento.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.MOCOOR = ?");
			params.add(establecimiento.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t2.MONOMBRE = ?");
			params.add(establecimiento.getCensoMonitor().getMonombre());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t2.MOCOEM = ?");
			params.add(establecimiento.getCensoMonitor().getMocoem());
		}

		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA = ?");
			params.add(establecimiento.getCensoMonitor().getMofecbaja());
		}

		if (establecimiento != null && establecimiento.getEsnombre() != null) {
			where.append(" AND t1.ESNOMBRE = ?");
			params.add(establecimiento.getEsnombre());
		}
		if (establecimiento != null && establecimiento.getEsnif() != null) {
			where.append(" AND t1.ESNIF = ?");
			params.add(establecimiento.getEsnif());
		}
		if (establecimiento != null && establecimiento.getEsnoan() != null) {
			where.append(" AND t1.ESNOAN = ?");
			params.add(establecimiento.getEsnoan());
		}
		if (establecimiento != null && establecimiento.getEsnoco() != null) {
			where.append(" AND t1.ESNOCO = ?");
			params.add(establecimiento.getEsnoco());
		}
		if (establecimiento != null && establecimiento.getEsnodir() != null) {
			where.append(" AND t1.ESNODIR = ?");
			params.add(establecimiento.getEsnodir());
		}
		if (establecimiento != null && establecimiento.getEscolo() != null) {
			where.append(" AND t1.ESCOLO = ?");
			params.add(establecimiento.getEscolo());
		}
		if (establecimiento != null && establecimiento.getEsnrcopo() != null) {
			where.append(" AND t1.ESNRCOPO = ?");
			params.add(establecimiento.getEsnrcopo());
		}
		if (establecimiento != null && establecimiento.getEsnrtel() != null) {
			where.append(" AND t1.ESNRTEL = ?");
			params.add(establecimiento.getEsnrtel());
		}
		if (establecimiento != null && establecimiento.getEsnrfax() != null) {
			where.append(" AND t1.ESNRFAX = ?");
			params.add(establecimiento.getEsnrfax());
		}
		if (establecimiento != null && establecimiento.getEscopa() != null) {
			where.append(" AND t1.ESCOPA = ?");
			params.add(establecimiento.getEscopa());
		}
		if (establecimiento != null && establecimiento.getEsincapr() != null) {
			where.append(" AND t1.ESINCAPR = ?");
			params.add(establecimiento.getEsincapr());
		}
		if (establecimiento != null && establecimiento.getEsindemp() != null) {
			where.append(" AND t1.ESINDEMP = ?");
			params.add(establecimiento.getEsindemp());
		}
		if (establecimiento != null && establecimiento.getEsteco() != null) {
			where.append(" AND t1.ESTECO = ?");
			params.add(establecimiento.getEsteco());
		}
		if (establecimiento != null && establecimiento.getEsinadar() != null) {
			where.append(" AND t1.ESINADAR = ?");
			params.add(establecimiento.getEsinadar());
		}
		if (establecimiento != null && establecimiento.getEsfeadar() != null) {
			where.append(" AND t1.ESFEADAR = ?");
			params.add(establecimiento.getEsfeadar());
		}
		if (establecimiento != null && establecimiento.getEscoem() != null) {
			where.append(" AND t1.ESCOEM = ?");
			params.add(establecimiento.getEscoem());
		}
		if (establecimiento != null && establecimiento.getEsinempr() != null) {
			where.append(" AND t1.ESINEMPR = ?");
			params.add(establecimiento.getEsinempr());
		}
		if (establecimiento != null && establecimiento.getEsnrtel2() != null) {
			where.append(" AND t1.ESNRTEL2 = ?");
			params.add(establecimiento.getEsnrtel2());
		}
		if (establecimiento != null && establecimiento.getEsfeba() != null) {
			where.append(" AND t1.ESFEBA = ?");
			params.add(establecimiento.getEsfeba());
		}
		if (establecimiento != null && establecimiento.getEsnoap1() != null) {
			where.append(" AND t1.ESNOAP1 = ?");
			params.add(establecimiento.getEsnoap1());
		}
		if (establecimiento != null && establecimiento.getEsnoap2() != null) {
			where.append(" AND t1.ESNOAP2 = ?");
			params.add(establecimiento.getEsnoap2());
		}
		if (establecimiento != null && establecimiento.getEsnolo() != null) {
			where.append(" AND t1.ESNOLO = ?");
			params.add(establecimiento.getEsnolo());
		}
		if (establecimiento != null && establecimiento.getEscomapv() != null) {
			where.append(" AND t1.ESCOMAPV = ?");
			params.add(establecimiento.getEscomapv());
		}
		if (establecimiento != null && establecimiento.getEscoca() != null) {
			where.append(" AND t1.ESCOCA = ?");
			params.add(establecimiento.getEscoca());
		}
		if (establecimiento != null && establecimiento.getEsnopeco() != null) {
			where.append(" AND t1.ESNOPECO = ?");
			params.add(establecimiento.getEsnopeco());
		}
		if (establecimiento != null && establecimiento.getEscoidco() != null) {
			where.append(" AND t1.ESCOIDCO = ?");
			params.add(establecimiento.getEscoidco());
		}
		if (establecimiento != null && establecimiento.getEsinreco() != null) {
			where.append(" AND t1.ESINRECO = ?");
			params.add(establecimiento.getEsinreco());
		}
		if (establecimiento != null && establecimiento.getEsfemod() != null) {
			where.append(" AND t1.ESFEMOD = ?");
			params.add(establecimiento.getEsfemod());
		}
		if (establecimiento != null && establecimiento.getEsinesco() != null) {
			where.append(" AND t1.ESINESCO = ?");
			params.add(establecimiento.getEsinesco());
		}
		if (establecimiento != null && establecimiento.getEsnomu() != null) {
			where.append(" AND t1.ESNOMU = ?");
			params.add(establecimiento.getEsnomu());
		}
		if (establecimiento != null && establecimiento.getEsnorep() != null) {
			where.append(" AND t1.ESNOREP = ?");
			params.add(establecimiento.getEsnorep());
		}
		if (establecimiento != null && establecimiento.getEsnifrep() != null) {
			where.append(" AND t1.ESNIFREP = ?");
			params.add(establecimiento.getEsnifrep());
		}
		if (establecimiento != null && establecimiento.getDtteemr() != null) {
			where.append(" AND t1.DTTEEMR = ?");
			params.add(establecimiento.getDtteemr());
		}
		if (establecimiento != null && establecimiento.getEscarep() != null) {
			where.append(" AND t1.ESCAREP = ?");
			params.add(establecimiento.getEscarep());
		}
		if (establecimiento != null && establecimiento.getEsteurl() != null) {
			where.append(" AND t1.ESTEURL = ?");
			params.add(establecimiento.getEsteurl());
		}
		if (establecimiento != null && establecimiento.getEscooe() != null) {
			where.append(" AND t1.ESCOOE = ?");
			params.add(establecimiento.getEscooe());
		}
		if (establecimiento != null && establecimiento.getEsnodeco() != null) {
			where.append(" AND t1.ESNODECO = ?");
			params.add(establecimiento.getEsnodeco());
		}
		if (establecimiento != null && establecimiento.getEsintiar() != null) {
			where.append(" AND t1.ESINTIAR = ?");
			params.add(establecimiento.getEsintiar());
		}
		if (establecimiento != null && establecimiento.getEsfeplad() != null) {
			where.append(" AND t1.ESFEPLAD = ?");
			params.add(establecimiento.getEsfeplad());
		}
		if (establecimiento != null && establecimiento.getEsindeme() != null) {
			where.append(" AND t1.ESINDEME = ?");
			params.add(establecimiento.getEsindeme());
		}
		if (establecimiento != null && establecimiento.getEsnoraPaisId() != null) {
			where.append(" AND t1.ESNORA_PAIS_ID = ?");
			params.add(establecimiento.getEsnoraPaisId());
		}
		if (establecimiento != null && establecimiento.getEsnoraPaisNombre() != null) {
			where.append(" AND t1.ESNORA_PAIS_NOMBRE = ?");
			params.add(establecimiento.getEsnoraPaisNombre());
		}
		if (establecimiento != null && establecimiento.getEsnoraProvinciaId() != null) {
			where.append(" AND t1.ESNORA_PROVINCIA_ID = ?");
			params.add(establecimiento.getEsnoraProvinciaId());
		}
		if (establecimiento != null && establecimiento.getEsnombreProvincia() != null) {
			where.append(" AND t1.ESNOMBRE_PROVINCIA = ?");
			params.add(establecimiento.getEsnombreProvincia());
		}
		if (establecimiento != null && establecimiento.getEsnoraMunicipioId() != null) {
			where.append(" AND t1.ESNORA_MUNICIPIO_ID = ?");
			params.add(establecimiento.getEsnoraMunicipioId());
		}
		if (establecimiento != null && establecimiento.getEsnombreMunicipio() != null) {
			where.append(" AND t1.ESNOMBRE_MUNICIPIO = ?");
			params.add(establecimiento.getEsnombreMunicipio());
		}
		if (establecimiento != null && establecimiento.getEsnoraLocalidadId() != null) {
			where.append(" AND t1.ESNORA_LOCALIDAD_ID = ?");
			params.add(establecimiento.getEsnoraLocalidadId());
		}
		if (establecimiento != null && establecimiento.getEsnombreLocalidad() != null) {
			where.append(" AND t1.ESNOMBRE_LOCALIDAD = ?");
			params.add(establecimiento.getEsnombreLocalidad());
		}
		if (establecimiento != null && establecimiento.getEsnoraCalleId() != null) {
			where.append(" AND t1.ESNORA_CALLE_ID = ?");
			params.add(establecimiento.getEsnoraCalleId());
		}
		if (establecimiento != null && establecimiento.getEsnombreCalle() != null) {
			where.append(" AND t1.ESNOMBRE_CALLE = ?");
			params.add(establecimiento.getEsnombreCalle());
		}
		if (establecimiento != null && establecimiento.getEsnoraCpId() != null) {
			where.append(" AND t1.ESNORA_CP_ID = ?");
			params.add(establecimiento.getEsnoraCpId());
		}
		if (establecimiento != null && establecimiento.getEsnombreCp() != null) {
			where.append(" AND t1.ESNOMBRE_CP = ?");
			params.add(establecimiento.getEsnombreCp());
		}
		if (establecimiento != null && establecimiento.getEsnoraPortalId() != null) {
			where.append(" AND t1.ESNORA_PORTAL_ID = ?");
			params.add(establecimiento.getEsnoraPortalId());
		}
		if (establecimiento != null && establecimiento.getEsnombrePortal() != null) {
			where.append(" AND t1.ESNOMBRE_PORTAL = ?");
			params.add(establecimiento.getEsnombrePortal());
		}
		if (establecimiento != null && establecimiento.getEsnombrePiso() != null) {
			where.append(" AND t1.ESNOMBRE_PISO = ?");
			params.add(establecimiento.getEsnombrePiso());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Establecimiento> findAllLike(Establecimiento establecimiento, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ESCOZS= t2.MOCODIGO(+) AND t1.ESCODIGO = t3.AHCOES(+)	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ESCODIGO ESCODIGO,t1.ESNOMBRE ESNOMBRE, t1.ESTIPID ESTIPID,t1.ESNIF ESNIF,t1.ESNOAN ESNOAN,t1.ESNOCO ESNOCO,t1.ESNODIR ESNODIR,t1.ESCOLO ESCOLO,t1.ESNRCOPO ESNRCOPO,t1.ESNRTEL ESNRTEL,t1.ESNRFAX ESNRFAX,t1.ESCOPA ESCOPA,t1.ESINCAPR ESINCAPR,t1.ESINDEMP ESINDEMP,t1.ESTECO ESTECO,t1.ESINADAR ESINADAR,t1.ESFEADAR ESFEADAR,t1.ESCOEM ESCOEM, t1.ESMAILNOTIFICACION ESMAILNOTIFICACION,t1.ESINEMPR ESINEMPR,t1.ESNRTEL2 ESNRTEL2,t1.ESFEBA ESFEBA,t1.ESNOAP1 ESNOAP1,t1.ESNOAP2 ESNOAP2,t1.ESNOLO ESNOLO,t1.ESCOMAPV ESCOMAPV,t1.ESCOCA ESCOCA,t1.ESNOPECO ESNOPECO,t1.ESCOIDCO ESCOIDCO,t1.ESINRECO ESINRECO,t1.ESFEMOD ESFEMOD,t1.ESINESCO ESINESCO,t1.ESNOMU ESNOMU,t1.ESNOREP ESNOREP,t1.ESNIFREP ESNIFREP,t1.DTTEEMR DTTEEMR,t1.ESCAREP ESCAREP,t1.ESTEURL ESTEURL,t1.ESCOOE ESCOOE,t1.ESNODECO ESNODECO,t1.ESINTIAR ESINTIAR,t1.ESFEPLAD ESFEPLAD,t1.ESINDEME ESINDEME,t1.ESNORA_PAIS_ID ESNORAPAISID,t1.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBRE,t1.ESNORA_PROVINCIA_ID ESNORAPROVINCIAID,t1.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIA,t1.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOID,t1.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIO,t1.ESNORA_LOCALIDAD_ID ESNORALOCALIDADID,t1.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDAD,t1.ESNORA_CALLE_ID ESNORACALLEID,t1.ESNOMBRE_CALLE ESNOMBRECALLE,t1.ESNORA_CP_ID ESNORACPID,t1.ESNOMBRE_CP ESNOMBRECP,t1.ESNORA_PORTAL_ID ESNORAPORTALID,t1.ESNOMBRE_PORTAL ESNOMBREPORTAL,t1.ESNOMBRE_PISO ESNOMBREPISO, t1.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPV, t1.ESEXTRANJERO ESEXTRANJERO, t1.ESSEDE ESSEDE, t2.MOCODIGO CENSOMONITORMOCODIGO,t2.MONOMBRE CENSOMONITORMONOMBRE,t2.MOCOEM CENSOMONITORMOCOEM, t2.MODNI CENSOMONITORMODNI, t2.USUARIOXLNET CENSOMONITORUSUARIOXLNET, t2.PUESTOXLNET CENSOMONITORPUESTOXLNET,t2.MOFECBAJA CENSOMONITORMOFECBAJA,t2.MOCOOR CENSOMONITORMOCOOR, t1.ESFEERD ESFEERD, t1.ESILOCALIZABLE ESILOCALIZABLE, t1.ESNOCOLABORA ESNOCOLABORA, t3.AHNRDI AHNRDI "
						+ "FROM ESTABLECIMIENTO t1 ,CENSO_MONITOR t2, ESTABLECIM_ARBITRA t3 ");

		if (establecimiento != null && establecimiento.getEscodigo() != null) {
			where.append(" AND UPPER(t1.ESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscodigo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ESCODIGO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getCensoMonitor().getMocodigo() + "%");
			} else {
				params.add("%" + establecimiento.getCensoMonitor().getMocodigo() + "%");
			}
			where.append(" AND t2.MOCODIGO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getOrganismo() != null
				&& establecimiento.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND UPPER(t2.MOCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getCensoMonitor().getOrganismo().getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getCensoMonitor().getOrganismo().getCodOrg().toUpperCase() + "%");
			}
			where.append(" AND t2.MOCOOR IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMonombre() != null) {
			where.append(" AND UPPER(t2.MONOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getCensoMonitor().getMonombre().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getCensoMonitor().getMonombre().toUpperCase() + "%");
			}
			where.append(" AND t2.MONOMBRE IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocoem() != null) {
			where.append(" AND UPPER(t2.MOCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getCensoMonitor().getMocoem().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getCensoMonitor().getMocoem().toUpperCase() + "%");
			}
			where.append(" AND t2.MOCOEM IS NOT NULL");
		}

		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getCensoMonitor().getMofecbaja() + "%");
			} else {
				params.add("%" + establecimiento.getCensoMonitor().getMofecbaja() + "%");
			}
			where.append(" AND t2.MOFECBAJA IS NOT NULL");
		}

		if (establecimiento != null && establecimiento.getEsnombre() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombre().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOMBRE IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnif() != null) {
			where.append(" AND UPPER(t1.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNIF IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoan() != null) {
			where.append(" AND UPPER(t1.ESNOAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoan().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoan().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOAN IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoco() != null) {
			where.append(" AND UPPER(t1.ESNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoco().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOCO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnodir() != null) {
			where.append(" AND UPPER(t1.ESNODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnodir().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnodir().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNODIR IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscolo() != null) {
			where.append(" AND UPPER(t1.ESCOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscolo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscolo().toUpperCase() + "%");
			}
			where.append(" AND t1.ESCOLO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnrcopo() != null) {
			where.append(" AND UPPER(t1.ESNRCOPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnrcopo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnrcopo().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNRCOPO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnrtel() != null) {
			where.append(" AND UPPER(t1.ESNRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnrtel().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnrtel().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNRTEL IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnrfax() != null) {
			where.append(" AND UPPER(t1.ESNRFAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnrfax().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnrfax().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNRFAX IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscopa() != null) {
			where.append(" AND UPPER(t1.ESCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscopa().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscopa().toUpperCase() + "%");
			}
			where.append(" AND t1.ESCOPA IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsincapr() != null) {
			where.append(" AND UPPER(t1.ESINCAPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsincapr().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsincapr().toUpperCase() + "%");
			}
			where.append(" AND t1.ESINCAPR IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsindemp() != null) {
			where.append(" AND UPPER(t1.ESINDEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsindemp().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsindemp().toUpperCase() + "%");
			}
			where.append(" AND t1.ESINDEMP IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsteco() != null) {
			where.append(" AND UPPER(t1.ESTECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsteco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsteco().toUpperCase() + "%");
			}
			where.append(" AND t1.ESTECO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsinadar() != null) {
			if (Y41bConstantes.SI.equalsIgnoreCase(establecimiento.getEsinadar())) {
				where.append(" AND (t1.ESFEADAR IS NOT NULL");
				where.append(
						" AND (t3.AHFEBA IS NULL OR (t3.AHFEBA IS NOT NULL AND t3.AHFEBA >= SYSDATE)) AND t1.ESFEBA IS NULL");
				where.append(" AND t3.AHCODIGO IS NOT NULL)");
			}
			if (Y41bConstantes.NO.equalsIgnoreCase(establecimiento.getEsinadar())) {
				where.append(" AND !(t1.ESFEADAR IS NOT NULL");
				where.append(
						" AND (t3.AHFEBA IS NULL OR (t3.AHFEBA IS NOT NULL AND t3.AHFEBA >= SYSDATE)) AND t1.ESFEBA IS NULL");
				where.append(" AND t3.AHCODIGO IS NOT NULL)");
			} else {
				where.append(" AND UPPER(t1.ESINADAR) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(establecimiento.getEsinadar().toUpperCase() + "%");
				} else {
					params.add("%" + establecimiento.getEsinadar().toUpperCase() + "%");
				}
				where.append(" AND t1.ESINADAR IS NOT NULL");
			}
		}
		if (establecimiento != null && establecimiento.getEsfeadar() != null) {
			where.append(" AND t1.ESFEADAR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsfeadar() + "%");
			} else {
				params.add("%" + establecimiento.getEsfeadar() + "%");
			}
			where.append(" AND t1.ESFEADAR IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscoem() != null) {
			where.append(" AND UPPER(t1.ESCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscoem().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscoem().toUpperCase() + "%");
			}
			where.append(" AND t1.ESCOEM IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsinempr() != null) {
			where.append(" AND UPPER(t1.ESINEMPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsinempr().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsinempr().toUpperCase() + "%");
			}
			where.append(" AND t1.ESINEMPR IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnrtel2() != null) {
			where.append(" AND UPPER(t1.ESNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnrtel2().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNRTEL2 IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsfeba() != null) {
			where.append(" AND t1.ESFEBA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsfeba() + "%");
			} else {
				params.add("%" + establecimiento.getEsfeba() + "%");
			}
			where.append(" AND t1.ESFEBA IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoap1() != null) {
			where.append(" AND UPPER(t1.ESNOAP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoap1().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoap1().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOAP1 IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoap2() != null) {
			where.append(" AND UPPER(t1.ESNOAP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoap2().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoap2().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOAP2 IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnolo() != null) {
			where.append(" AND UPPER(t1.ESNOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnolo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnolo().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOLO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscomapv() != null) {
			where.append(" AND UPPER(t1.ESCOMAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscomapv().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscomapv().toUpperCase() + "%");
			}
			where.append(" AND t1.ESCOMAPV IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscoca() != null) {
			where.append(" AND UPPER(t1.ESCOCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscoca().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscoca().toUpperCase() + "%");
			}
			where.append(" AND t1.ESCOCA IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnopeco() != null) {
			where.append(" AND UPPER(t1.ESNOPECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnopeco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnopeco().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOPECO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscoidco() != null) {
			where.append(" AND UPPER(t1.ESCOIDCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscoidco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscoidco().toUpperCase() + "%");
			}
			where.append(" AND t1.ESCOIDCO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsinreco() != null) {
			where.append(" AND UPPER(t1.ESINRECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsinreco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsinreco().toUpperCase() + "%");
			}
			where.append(" AND t1.ESINRECO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsfemod() != null) {
			where.append(" AND UPPER(t1.ESFEMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsfemod().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsfemod().toUpperCase() + "%");
			}
			where.append(" AND t1.ESFEMOD IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsinesco() != null) {
			where.append(" AND UPPER(t1.ESINESCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsinesco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsinesco().toUpperCase() + "%");
			}
			where.append(" AND t1.ESINESCO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnomu() != null) {
			where.append(" AND UPPER(t1.ESNOMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnomu().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnomu().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOMU IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnorep() != null) {
			where.append(" AND UPPER(t1.ESNOREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnorep().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnorep().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOREP IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnifrep() != null) {
			where.append(" AND UPPER(t1.ESNIFREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnifrep().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnifrep().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNIFREP IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getDtteemr() != null) {
			where.append(" AND UPPER(t1.DTTEEMR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getDtteemr().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getDtteemr().toUpperCase() + "%");
			}
			where.append(" AND t1.DTTEEMR IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscarep() != null) {
			where.append(" AND UPPER(t1.ESCAREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscarep().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscarep().toUpperCase() + "%");
			}
			where.append(" AND t1.ESCAREP IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsteurl() != null) {
			where.append(" AND UPPER(t1.ESTEURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsteurl().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsteurl().toUpperCase() + "%");
			}
			where.append(" AND t1.ESTEURL IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscooe() != null) {
			where.append(" AND UPPER(t1.ESCOOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscooe().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscooe().toUpperCase() + "%");
			}
			where.append(" AND t1.ESCOOE IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnodeco() != null) {
			where.append(" AND UPPER(t1.ESNODECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnodeco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnodeco().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNODECO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsintiar() != null) {
			where.append(" AND UPPER(t1.ESINTIAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsintiar().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsintiar().toUpperCase() + "%");
			}
			where.append(" AND t1.ESINTIAR IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsfeplad() != null) {
			where.append(" AND t1.ESFEPLAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsfeplad() + "%");
			} else {
				params.add("%" + establecimiento.getEsfeplad() + "%");
			}
			where.append(" AND t1.ESFEPLAD IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsindeme() != null) {
			where.append(" AND UPPER(t1.ESINDEME) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsindeme().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsindeme().toUpperCase() + "%");
			}
			where.append(" AND t1.ESINDEME IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoraPaisId() != null) {
			where.append(" AND UPPER(t1.ESNORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNORA_PAIS_ID IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoraPaisNombre() != null) {
			where.append(" AND UPPER(t1.ESNORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraPaisNombre().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoraPaisNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.ESNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnombreProvincia() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnombreProvincia().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.ESNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnombreMunicipio() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnombreMunicipio().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.ESNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoraLocalidadId().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnombreLocalidad() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnombreLocalidad().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoraCalleId() != null) {
			where.append(" AND UPPER(t1.ESNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNORA_CALLE_ID IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnombreCalle() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOMBRE_CALLE IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoraCpId() != null) {
			where.append(" AND UPPER(t1.ESNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNORA_CP_ID IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnombreCp() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnombreCp().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOMBRE_CP IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoraPortalId() != null) {
			where.append(" AND UPPER(t1.ESNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNORA_PORTAL_ID IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnombrePortal() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOMBRE_PORTAL IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnombrePiso() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOMBRE_PISO IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Establecimiento>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Establecimiento> findAllLikeEstablecimiento(Establecimiento establecimiento,
			EstablecimSector establecimSector, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.ESCOZS= t2.MOCODIGO(+) AND t1.ESCODIGO = t3.EACOES(+) AND t1.ESCODIGO = t4.AHCOES(+) ");
		// 0150111 aniadimos mas opciones X y C al case
		StringBuffer query = new StringBuffer(
				"SELECT  distinct t1.ESCODIGO ESCODIGO,t1.ESNOMBRE ESNOMBRE, t1.ESTIPID ESTIPID,t1.ESNIF ESNIF,t1.ESNOAN ESNOAN,t1.ESNOCO ESNOCO,t1.ESNODIR ESNODIR,t1.ESCOLO ESCOLO,t1.ESNRCOPO ESNRCOPO,t1.ESNRTEL ESNRTEL,t1.ESNRFAX ESNRFAX,t1.ESCOPA ESCOPA,t1.ESINCAPR ESINCAPR,t1.ESINDEMP ESINDEMP,t1.ESTECO ESTECO,t1.ESFEADAR ESFEADAR,t1.ESCOEM ESCOEM, t1.ESMAILNOTIFICACION ESMAILNOTIFICACION,t1.ESINEMPR ESINEMPR,t1.ESNRTEL2 ESNRTEL2,t1.ESFEBA ESFEBA,t1.ESNOAP1 ESNOAP1,t1.ESNOAP2 ESNOAP2,t1.ESNOLO ESNOLO,t1.ESCOMAPV ESCOMAPV,t1.ESCOCA ESCOCA,t1.ESNOPECO ESNOPECO,t1.ESCOIDCO ESCOIDCO,t1.ESINRECO ESINRECO,t1.ESFEMOD ESFEMOD,t1.ESINESCO ESINESCO,t1.ESNOMU ESNOMU,t1.ESNOREP ESNOREP,t1.ESNIFREP ESNIFREP,t1.DTTEEMR DTTEEMR,t1.ESCAREP ESCAREP,t1.ESTEURL ESTEURL,t1.ESCOOE ESCOOE,t1.ESNODECO ESNODECO,t1.ESINTIAR ESINTIAR,t1.ESFEPLAD ESFEPLAD,t1.ESINDEME ESINDEME,t1.ESNORA_PAIS_ID ESNORAPAISID,t1.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBRE,t1.ESNORA_PROVINCIA_ID ESNORAPROVINCIAID,t1.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIA,t1.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOID,t1.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIO,t1.ESNORA_LOCALIDAD_ID ESNORALOCALIDADID,t1.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDAD,t1.ESNORA_CALLE_ID ESNORACALLEID,t1.ESNOMBRE_CALLE ESNOMBRECALLE,t1.ESNORA_CP_ID ESNORACPID,t1.ESNOMBRE_CP ESNOMBRECP,t1.ESNORA_PORTAL_ID ESNORAPORTALID,t1.ESNOMBRE_PORTAL ESNOMBREPORTAL,t1.ESNOMBRE_PISO ESNOMBREPISO, t1.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPV, t1.ESEXTRANJERO ESEXTRANJERO, t1.ESSEDE ESSEDE,t2.MOCODIGO CENSOMONITORMOCODIGO,t2.MONOMBRE CENSOMONITORMONOMBRE,t2.MOCOEM CENSOMONITORMOCOEM, t2.MODNI CENSOMONITORMODNI, t2.USUARIOXLNET CENSOMONITORUSUARIOXLNET, t2.PUESTOXLNET CENSOMONITORPUESTOXLNET,t2.MOFECBAJA CENSOMONITORMOFECBAJA,t2.MOCOOR CENSOMONITORMOCOOR, "
						// Se comenta las nuevas opciones a raiz de lo decidido
						// el dia 14/04/2020 y se vuelve a poner lo que habia
						// antes
						// +
						// "CASE WHEN t1.ESFEADAR IS NULL OR t4.AHCODIGO IS NULL
						// THEN 'N' WHEN t1.ESFEBA IS NOT NULL AND
						// t1.ESFEBA<SYSDATE AND (t1.ESFEADAR IS NULL OR
						// (t1.ESFEADAR IS NOT NULL AND t4.AHFEBA IS NOT NULL
						// AND t4.AHFEBA < t1.ESFEBA)) AND (t1.ESFEADAR IS NULL
						// OR (t1.ESFEADAR IS NOT NULL AND t4.AHFERE IS NOT NULL
						// AND t4.AHFERE < t1.ESFEBA)) THEN 'X' WHEN t1.ESFEBA
						// IS NOT NULL AND t1.ESFEBA<SYSDATE AND (t4.AHFEBA IS
						// NULL OR (t4.AHFEBA IS NOT NULL AND t4.AHFEBA >
						// t1.ESFEBA)) AND (t4.AHFERE IS NULL OR (t4.AHFERE IS
						// NOT NULL AND t4.AHFERE > t1.ESFEBA)) AND t1.ESFEADAR
						// IS NOT NULL AND t4.AHCODIGO IS NOT NULL THEN 'C' WHEN
						// t4.AHCODIGO IS NOT NULL AND t4.AHFEBA IS NOT NULL AND
						// t4.AHFEBA<SYSDATE THEN 'B' ELSE 'A' END ESINADAR,
						// t1.ESFEERD ESFEERD, t1.ESILOCALIZABLE ESILOCALIZABLE,
						// t1.ESNOCOLABORA ESNOCOLABORA, t4.AHNRDI AHNRDI "
						// 0153887 aniadimos caso 'S' cuando este cerrado para
						// que no saque icono
						+ "CASE WHEN t1.ESFEBA IS NOT NULL THEN 'S' WHEN t1.ESFEADAR IS NULL OR t4.AHCODIGO IS NULL THEN 'N' "
						+ " WHEN t4.AHCODIGO IS NOT NULL AND t4.AHFEBA IS NOT NULL AND t4.AHFEBA<SYSDATE THEN 'B' "
						// +
						// " WHEN t4.AHCODIGO IS NOT NULL AND t4.AHTELIMI IS NOT
						// NULL THEN 'L' "
						+ " ELSE 'A' END ESINADAR, t1.ESFEERD ESFEERD, t1.ESILOCALIZABLE ESILOCALIZABLE, t1.ESNOCOLABORA ESNOCOLABORA, t4.AHNRDI AHNRDI "
						+ "FROM ESTABLECIMIENTO t1 ,CENSO_MONITOR t2, ESTABLECIM_SECTOR t3, ESTABLECIM_ARBITRA t4 ");

		if (establecimiento != null && establecimiento.getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(establecimiento.getEscodigo());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO = ?");
			params.add(establecimiento.getCensoMonitor().getMocodigo());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getOrganismo() != null
				&& establecimiento.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.MOCOOR = ?");
			params.add(establecimiento.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t2.MONOMBRE = ?");
			params.add(establecimiento.getCensoMonitor().getMonombre());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t2.MOCOEM = ?");
			params.add(establecimiento.getCensoMonitor().getMocoem());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA = ?");
			params.add(establecimiento.getCensoMonitor().getMofecbaja());
		}
		if (establecimiento != null && establecimiento.getEsnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + establecimiento.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.ESNOMBRE IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t1.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + establecimiento.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.ESNOCO IS NOT NULL)) ");
		}
		if (establecimiento != null && establecimiento.getEsnif() != null) {
			where.append(" AND UPPER(t1.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNIF IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoan() != null) {
			where.append(" AND t1.ESNOAN = ?");
			params.add(establecimiento.getEsnoan());
		}
		if (establecimiento != null && establecimiento.getEsnoco() != null) {
			where.append(" AND t1.ESNOCO = ?");
			params.add(establecimiento.getEsnoco());
		}
		if (establecimiento != null && establecimiento.getEsnodir() != null) {
			where.append(" AND t1.ESNODIR = ?");
			params.add(establecimiento.getEsnodir());
		}
		if (establecimiento != null && establecimiento.getEscolo() != null) {
			where.append(" AND t1.ESCOLO = ?");
			params.add(establecimiento.getEscolo());
		}
		if (establecimiento != null && establecimiento.getEsnrcopo() != null) {
			where.append(" AND t1.ESNRCOPO = ?");
			params.add(establecimiento.getEsnrcopo());
		}
		if (establecimiento != null && establecimiento.getEsnrtel() != null) {
			where.append(" AND (t1.ESNRTEL like ? ESCAPE  '\\' ");
			params.add("%" + establecimiento.getEsnrtel() + "%");
			where.append(" OR t1.ESNRTEL2 like ? ESCAPE  '\\' ) ");
			params.add("%" + establecimiento.getEsnrtel() + "%");
		}
		if (establecimiento != null && establecimiento.getEsnrfax() != null) {
			where.append(" AND t1.ESNRFAX = ?");
			params.add(establecimiento.getEsnrfax());
		}
		if (establecimiento != null && establecimiento.getEscopa() != null) {
			where.append(" AND t1.ESCOPA = ?");
			params.add(establecimiento.getEscopa());
		}
		if (establecimiento != null && establecimiento.getEsincapr() != null) {
			where.append(" AND t1.ESINCAPR = ?");
			params.add(establecimiento.getEsincapr());
		}
		if (establecimiento != null && establecimiento.getEsindemp() != null) {
			where.append(" AND t1.ESINDEMP = ?");
			params.add(establecimiento.getEsindemp());
		}
		if (establecimiento != null && establecimiento.getEsteco() != null) {
			where.append(" AND t1.ESTECO = ?");
			params.add(establecimiento.getEsteco());
		}
		if (establecimiento != null && establecimiento.getEssede() != null) {
			// Sacar solamente las SEDES
			if (Y41bConstantes.SI.equals(establecimiento.getEssede())) {
				where.append(" AND t1.ESSEDE = ?");
				params.add(Y41bConstantes.SI);
			}
		}
		if (establecimiento != null && establecimiento.getEsinadar() != null) {
			// Sacar solamente los ADHERIDOS (que no esten de baja)
			// Para saber si el establecimiento esta adherido, debemos usar la
			// tabla de ADHERIDO_ESTABLECIMIENTO
			if (Y41bConstantes.SI.equals(establecimiento.getEsinadar())) {
				where.append(" AND t4.AHCODIGO IS NOT NULL");
				where.append(" AND (t4.AHFEBA IS NULL");

				where.append(" OR (t4.AHFEBA IS NOT NULL");
				where.append(" AND t4.AHFEBA>=sysdate) )");
			} // 0116048 3.3
			else if ("G".equals(establecimiento.getEsinadar())) {
				where.append(" AND (t4.AHCODIGO IS NULL OR (t4.AHFEBA IS NOT NULL AND t4.AHFEBA<=sysdate ))");
			}
			// 0116048 3.3
		}
		if (establecimiento != null && establecimiento.getEsfeadar() != null) {
			where.append(" AND t1.ESFEADAR = ?");
			params.add(establecimiento.getEsfeadar());
		}
		if (establecimiento != null && establecimiento.getEscoem() != null) {

			where.append(" AND UPPER(t1.ESCOEM) like ? ESCAPE '\\'");
			params.add("%" + establecimiento.getEscoem().toUpperCase() + "%");
		}
		if (establecimiento != null && establecimiento.getEsinempr() != null) {
			where.append(" AND t1.ESINEMPR = ?");
			params.add(establecimiento.getEsinempr());
		}
		if (establecimiento != null && establecimiento.getEsnrtel2() != null) {
			where.append(" AND t1.ESNRTEL2 = ?");
			params.add(establecimiento.getEsnrtel2());
		}
		if (establecimiento != null && establecimiento.getEsfeba() != null) {
			where.append(" AND t1.ESFEBA = ?");
			params.add(establecimiento.getEsfeba());
		}
		if (establecimiento != null && establecimiento.getEsinfeba() == null) {
			where.append(" AND t1.ESFEBA IS NULL");
		}
		// 0150111 mostrar cerrados
		// Se comenta las nuevas opciones a raiz de lo decidido el dia
		// 14/04/2020 y se vuelve a poner lo que habia antes
		// if (establecimiento != null && establecimiento.getEsinfeba() != null)
		// {
		// where.append(" AND t1.ESFEBA IS NOT NULL");
		// }
		// 0150111
		if (establecimiento != null && establecimiento.getEsnoap1() != null) {
			where.append(" AND t1.ESNOAP1 = ?");
			params.add(establecimiento.getEsnoap1());
		}
		if (establecimiento != null && establecimiento.getEsnoap2() != null) {
			where.append(" AND t1.ESNOAP2 = ?");
			params.add(establecimiento.getEsnoap2());
		}
		if (establecimiento != null && establecimiento.getEsnolo() != null) {
			where.append(" AND t1.ESNOLO = ?");
			params.add(establecimiento.getEsnolo());
		}
		if (establecimiento != null && establecimiento.getEscomapv() != null) {
			where.append(" AND t1.ESCOMAPV = ?");
			params.add(establecimiento.getEscomapv());
		}
		if (establecimiento != null && establecimiento.getEscoca() != null) {
			where.append(" AND t1.ESCOCA = ?");
			params.add(establecimiento.getEscoca());
		}
		if (establecimiento != null && establecimiento.getEsnopeco() != null) {
			where.append(" AND t1.ESNOPECO = ?");
			params.add(establecimiento.getEsnopeco());
		}
		if (establecimiento != null && establecimiento.getEscoidco() != null) {
			where.append(" AND t1.ESCOIDCO = ?");
			params.add(establecimiento.getEscoidco());
		}
		if (establecimiento != null && establecimiento.getEsinreco() != null) {
			where.append(" AND t1.ESINRECO = ?");
			params.add(establecimiento.getEsinreco());
		}
		if (establecimiento != null && establecimiento.getEsfemod() != null) {
			where.append(" AND t1.ESFEMOD = ?");
			params.add(establecimiento.getEsfemod());
		}
		if (establecimiento != null && establecimiento.getEsinesco() != null) {
			where.append(" AND t1.ESINESCO = ?");
			params.add(establecimiento.getEsinesco());
		}
		if (establecimiento != null && establecimiento.getEsnomu() != null) {
			where.append(" AND t1.ESNOMU = ?");
			params.add(establecimiento.getEsnomu());
		}
		if (establecimiento != null && establecimiento.getEsnorep() != null) {
			where.append(" AND t1.ESNOREP = ?");
			params.add(establecimiento.getEsnorep());
		}
		if (establecimiento != null && establecimiento.getEsnifrep() != null) {
			where.append(" AND t1.ESNIFREP = ?");
			params.add(establecimiento.getEsnifrep());
		}
		if (establecimiento != null && establecimiento.getDtteemr() != null) {
			where.append(" AND t1.DTTEEMR = ?");
			params.add(establecimiento.getDtteemr());
		}
		if (establecimiento != null && establecimiento.getEscarep() != null) {
			where.append(" AND t1.ESCAREP = ?");
			params.add(establecimiento.getEscarep());
		}
		if (establecimiento != null && establecimiento.getEsteurl() != null) {
			where.append(" AND t1.ESTEURL = ?");
			params.add(establecimiento.getEsteurl());
		}
		if (establecimiento != null && establecimiento.getEscooe() != null) {
			where.append(" AND t1.ESCOOE = ?");
			params.add(establecimiento.getEscooe());
		}
		if (establecimiento != null && establecimiento.getEsnodeco() != null) {
			where.append(" AND t1.ESNODECO = ?");
			params.add(establecimiento.getEsnodeco());
		}
		if (establecimiento != null && establecimiento.getEsintiar() != null) {
			where.append(" AND t1.ESINTIAR = ?");
			params.add(establecimiento.getEsintiar());
		}
		if (establecimiento != null && establecimiento.getEsfeplad() != null) {
			where.append(" AND t1.ESFEPLAD = ?");
			params.add(establecimiento.getEsfeplad());
		}
		if (establecimiento != null && establecimiento.getEsindeme() != null) {
			where.append(" AND t1.ESINDEME = ?");
			params.add(establecimiento.getEsindeme());
		}
		if (establecimiento != null && establecimiento.getEsnoraPaisId() != null) {
			where.append(" AND t1.ESNORA_PAIS_ID = ?");
			params.add(establecimiento.getEsnoraPaisId());
		}
		if (establecimiento != null && establecimiento.getEsnoraPaisNombre() != null) {
			where.append(" AND t1.ESNORA_PAIS_NOMBRE = ?");
			params.add(establecimiento.getEsnoraPaisNombre());
		}
		if (establecimiento != null && establecimiento.getEsnoraProvinciaId() != null) {
			where.append(" AND t1.ESNORA_PROVINCIA_ID = ?");
			params.add(establecimiento.getEsnoraProvinciaId());
		}
		if (establecimiento != null && establecimiento.getEsnombreProvincia() != null) {
			where.append(" AND t1.ESNOMBRE_PROVINCIA = ?");
			params.add(establecimiento.getEsnombreProvincia());
		}
		if (establecimiento != null && establecimiento.getEsnoraMunicipioId() != null) {
			where.append(" AND t1.ESNORA_MUNICIPIO_ID = ?");
			params.add(establecimiento.getEsnoraMunicipioId());
		}
		if (establecimiento != null && establecimiento.getEsnombreMunicipio() != null) {
			where.append(" AND t1.ESNOMBRE_MUNICIPIO = ?");
			params.add(establecimiento.getEsnombreMunicipio());
		}
		if (establecimiento != null && establecimiento.getEsnoraLocalidadId() != null) {
			where.append(" AND t1.ESNORA_LOCALIDAD_ID = ?");
			params.add(establecimiento.getEsnoraLocalidadId());
		}
		if (establecimiento != null && establecimiento.getEsnombreLocalidad() != null) {
			where.append(" AND t1.ESNOMBRE_LOCALIDAD = ?");
			params.add(establecimiento.getEsnombreLocalidad());
		}
		if (establecimiento != null && establecimiento.getEsnoraCalleId() != null) {
			where.append(" AND t1.ESNORA_CALLE_ID = ?");
			params.add(establecimiento.getEsnoraCalleId());
		}
		if (establecimiento != null && establecimiento.getEsnombreCalle() != null) {
			where.append(" AND t1.ESNOMBRE_CALLE = ?");
			params.add(establecimiento.getEsnombreCalle());
		}
		if (establecimiento != null && establecimiento.getEsnoraCpId() != null) {
			where.append(" AND t1.ESNORA_CP_ID = ?");
			params.add(establecimiento.getEsnoraCpId());
		}
		if (establecimiento != null && establecimiento.getEsnombreCp() != null) {
			where.append(" AND t1.ESNOMBRE_CP = ?");
			params.add(establecimiento.getEsnombreCp());
		}
		if (establecimiento != null && establecimiento.getEsnoraPortalId() != null) {
			where.append(" AND t1.ESNORA_PORTAL_ID = ?");
			params.add(establecimiento.getEsnoraPortalId());
		}
		if (establecimiento != null && establecimiento.getEsnombrePortal() != null) {
			where.append(" AND t1.ESNOMBRE_PORTAL = ?");
			params.add(establecimiento.getEsnombrePortal());
		}

		if (establecimiento != null && establecimiento.getEsnombrePiso() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.ESNOMBRE_PISO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombrePiso().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombrePiso().toUpperCase().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.ESNOMBRE_PISO IS NOT NULL) ");
			where.append(" OR (TRANSLATE(UPPER(t1.ESNOMBRE_CALLE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombrePiso().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombrePiso().toUpperCase().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.ESNOMBRE_CALLE IS NOT NULL)");
			where.append(" OR (TRANSLATE(UPPER(t1.ESNODIR),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombrePiso().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombrePiso().toUpperCase().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.ESNODIR IS NOT NULL))");
		}
		if (establecimiento != null && establecimiento.getEsdireccion_nocapv() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ESDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ establecimiento.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.ESDIRECCION_NOCAPV IS NOT NULL");
		}

		if (establecimiento != null && establecimiento.getEsextranjero() != null
				&& establecimiento.getEsestado() == null) {
			where.append(" AND t1.ESEXTRANJERO = ?");
			params.add(Y41bConstantes.SI);
		}
		if (establecimiento != null && establecimiento.getEsestado() != null
				&& establecimiento.getEsextranjero() == null) {
			where.append(" AND t1.ESEXTRANJERO = ?");
			params.add(Y41bConstantes.NO);
		}
		if (establecimSector != null && establecimSector.getSector() != null
				&& establecimSector.getSector().getSecodigo() != null) {
			where.append(" AND UPPER(t3.EACOSE) like ? ESCAPE  '\\'");
			params.add(establecimSector.getSector().getSecodigo().toUpperCase() + "%");
			where.append(" AND t3.EACOSE IS NOT NULL");
		}

		/*
		 * Colección de descriptores a las que pueden pertenecer los
		 * establecimiento
		 */
		if (establecimiento != null && establecimiento.getDescriptores() != null
				&& establecimiento.getDescriptores().size() > 0) {

			where.append(" AND t1.ESCODIGO IN (SELECT ESCODIGO FROM ESTABLECIMIENTO_DESCRIPTOR WHERE ");
			boolean firstElement = true;

			for (Descriptor e : establecimiento.getDescriptores()) {

				if (firstElement) {

					where.append("ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
					firstElement = false;

				} else {

					where.append(" OR ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
				}
			}

			where.append(") ");
		}

		if (establecimiento != null && establecimiento.getBajaAd() != null) {
			// Sacar solamente los DADOS DE BAJA DE ADHERIDOS
			// Para saber si el establecimiento esta adherido, debemos usar la
			// tabla de ADHERIDO_ESTABLECIMIENTO
			if (Y41bConstantes.SI.equals(establecimiento.getBajaAd())) {
				where.append(" AND t4.AHCODIGO IS NOT NULL");
				where.append(" AND t4.AHFEBA IS NOT NULL");
				where.append(" AND t4.AHFEBA<sysdate ");
			}
		}

		if (establecimiento != null && establecimiento.getSinRenuncia() != null) {
			// 0150111 Sacar solamente los DADOS DE BAJA DE ADHERIDOS
			// Para saber si el establecimiento esta adherido, debemos usar la
			// tabla de ADHERIDO_ESTABLECIMIENTO
			if (Y41bConstantes.SI.equals(establecimiento.getSinRenuncia())) {
				where.append(" AND (t4.AHCODIGO IS NULL");
				where.append(" OR t4.AHFEBA IS NULL)");
				// where.append(" AND t4.AHFEBA<sysdate ");
			}
		}

		if (establecimiento != null && establecimiento.getAhnrdi() != null) {
			where.append(" AND t4.AHNRDI=? ");
			params.add(establecimiento.getAhnrdi());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Establecimiento>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EstablecimientoDetalle> findAllLikeEstablecimientoExtendido(Establecimiento establecimiento,
			EstablecimSector establecimSector, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.ESCOZS= t2.MOCODIGO(+) AND t1.ESCODIGO = t3.EACOES(+) AND t1.ESCODIGO = t4.AHCOES(+) ");
		// 0150111 aniadimos mas opciones X y C al case
		StringBuffer query = new StringBuffer(
				"SELECT  distinct t1.ESCODIGO ESCODIGO,t1.ESNOMBRE ESNOMBRE, t1.ESTIPID ESTIPID,t1.ESNIF ESNIF,t1.ESNOAN ESNOAN,t1.ESNOCO ESNOCO,t1.ESNODIR ESNODIR,t1.ESCOLO ESCOLO,t1.ESNRCOPO ESNRCOPO,t1.ESNRTEL ESNRTEL,t1.ESNRFAX ESNRFAX,t1.ESCOPA ESCOPA,t1.ESINCAPR ESINCAPR,t1.ESINDEMP ESINDEMP,t1.ESTECO ESTECO,t1.ESFEADAR ESFEADAR,t1.ESCOEM ESCOEM, t1.ESMAILNOTIFICACION ESMAILNOTIFICACION,t1.ESINEMPR ESINEMPR,t1.ESNRTEL2 ESNRTEL2,t1.ESFEBA ESFEBA,t1.ESNOAP1 ESNOAP1,t1.ESNOAP2 ESNOAP2,t1.ESNOLO ESNOLO,t1.ESCOMAPV ESCOMAPV,t1.ESCOCA ESCOCA,t1.ESNOPECO ESNOPECO,t1.ESCOIDCO ESCOIDCO,t1.ESINRECO ESINRECO,t1.ESFEMOD ESFEMOD,t1.ESINESCO ESINESCO,t1.ESNOMU ESNOMU,t1.ESNOREP ESNOREP,t1.ESNIFREP ESNIFREP,t1.DTTEEMR DTTEEMR,t1.ESCAREP ESCAREP,t1.ESTEURL ESTEURL,t1.ESCOOE ESCOOE,t1.ESNODECO ESNODECO,t1.ESINTIAR ESINTIAR,t1.ESFEPLAD ESFEPLAD,t1.ESINDEME ESINDEME,t1.ESNORA_PAIS_ID ESNORAPAISID,t1.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBRE,t1.ESNORA_PROVINCIA_ID ESNORAPROVINCIAID,t1.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIA,t1.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOID,t1.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIO,t1.ESNORA_LOCALIDAD_ID ESNORALOCALIDADID,t1.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDAD,t1.ESNORA_CALLE_ID ESNORACALLEID,t1.ESNOMBRE_CALLE ESNOMBRECALLE,t1.ESNORA_CP_ID ESNORACPID,t1.ESNOMBRE_CP ESNOMBRECP,t1.ESNORA_PORTAL_ID ESNORAPORTALID,t1.ESNOMBRE_PORTAL ESNOMBREPORTAL,t1.ESNOMBRE_PISO ESNOMBREPISO, t1.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPV, t1.ESEXTRANJERO ESEXTRANJERO, t1.ESSEDE ESSEDE,t2.MOCODIGO CENSOMONITORMOCODIGO,t2.MONOMBRE CENSOMONITORMONOMBRE,t2.MOCOEM CENSOMONITORMOCOEM, t2.MODNI CENSOMONITORMODNI, t2.USUARIOXLNET CENSOMONITORUSUARIOXLNET, t2.PUESTOXLNET CENSOMONITORPUESTOXLNET,t2.MOFECBAJA CENSOMONITORMOFECBAJA,t2.MOCOOR CENSOMONITORMOCOOR,  "
						// Se comenta las nuevas opciones a raiz de lo decidido
						// el dia 14/04/2020 y se vuelve a poner lo que habia
						// antes
						// +
						// "CASE WHEN t1.ESFEADAR IS NULL OR t4.AHCODIGO IS NULL
						// THEN 'N' WHEN t1.ESFEBA IS NOT NULL AND
						// t1.ESFEBA<SYSDATE AND (t1.ESFEADAR IS NULL OR
						// (t1.ESFEADAR IS NOT NULL AND t4.AHFEBA IS NOT NULL
						// AND t4.AHFEBA < t1.ESFEBA)) AND (t1.ESFEADAR IS NULL
						// OR (t1.ESFEADAR IS NOT NULL AND t4.AHFERE IS NOT NULL
						// AND t4.AHFERE < t1.ESFEBA)) THEN 'X' WHEN t1.ESFEBA
						// IS NOT NULL AND t1.ESFEBA<SYSDATE AND (t4.AHFEBA IS
						// NULL OR (t4.AHFEBA IS NOT NULL AND t4.AHFEBA >
						// t1.ESFEBA)) AND (t4.AHFERE IS NULL OR (t4.AHFERE IS
						// NOT NULL AND t4.AHFERE > t1.ESFEBA)) AND t1.ESFEADAR
						// IS NOT NULL AND t4.AHCODIGO IS NOT NULL THEN 'C' WHEN
						// t4.AHCODIGO IS NOT NULL AND t4.AHFEBA IS NOT NULL AND
						// t4.AHFEBA<SYSDATE THEN 'B' ELSE 'A' END ESINADAR,
						// t1.ESFEERD ESFEERD, t1.ESILOCALIZABLE ESILOCALIZABLE,
						// t1.ESNOCOLABORA ESNOCOLABORA "
						// 0153887 aniadimos caso 'S' cuando este cerrado para
						// que no saque icono
						+ "CASE WHEN t1.ESFEBA IS NOT NULL THEN 'S' WHEN t1.ESFEADAR IS NULL OR t4.AHCODIGO IS NULL THEN 'N' "
						+ " WHEN t4.AHCODIGO IS NOT NULL AND t4.AHFEBA IS NOT NULL AND t4.AHFEBA<SYSDATE THEN 'B' "
						// +
						// " WHEN t4.AHCODIGO IS NOT NULL AND t4.AHTELIMI IS NOT
						// NULL THEN 'L' "
						+ " ELSE 'A' END ESINADAR, t1.ESFEERD ESFEERD, t1.ESILOCALIZABLE ESILOCALIZABLE, t1.ESNOCOLABORA ESNOCOLABORA "
						+ "FROM ESTABLECIMIENTO t1 ,CENSO_MONITOR t2, ESTABLECIM_SECTOR t3, ESTABLECIM_ARBITRA t4 ");

		if (establecimiento != null && establecimiento.getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(establecimiento.getEscodigo());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO = ?");
			params.add(establecimiento.getCensoMonitor().getMocodigo());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getOrganismo() != null
				&& establecimiento.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.MOCOOR = ?");
			params.add(establecimiento.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t2.MONOMBRE = ?");
			params.add(establecimiento.getCensoMonitor().getMonombre());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t2.MOCOEM = ?");
			params.add(establecimiento.getCensoMonitor().getMocoem());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA = ?");
			params.add(establecimiento.getCensoMonitor().getMofecbaja());
		}
		if (establecimiento != null && establecimiento.getEsnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + establecimiento.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.ESNOMBRE IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t1.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + establecimiento.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.ESNOCO IS NOT NULL)) ");
		}
		if (establecimiento != null && establecimiento.getEsnif() != null) {
			where.append(" AND UPPER(t1.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNIF IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoan() != null) {
			where.append(" AND t1.ESNOAN = ?");
			params.add(establecimiento.getEsnoan());
		}
		if (establecimiento != null && establecimiento.getEsnoco() != null) {
			where.append(" AND t1.ESNOCO = ?");
			params.add(establecimiento.getEsnoco());
		}
		if (establecimiento != null && establecimiento.getEsnodir() != null) {
			where.append(" AND t1.ESNODIR = ?");
			params.add(establecimiento.getEsnodir());
		}
		if (establecimiento != null && establecimiento.getEscolo() != null) {
			where.append(" AND t1.ESCOLO = ?");
			params.add(establecimiento.getEscolo());
		}
		if (establecimiento != null && establecimiento.getEsnrcopo() != null) {
			where.append(" AND t1.ESNRCOPO = ?");
			params.add(establecimiento.getEsnrcopo());
		}
		if (establecimiento != null && establecimiento.getEsnrtel() != null) {
			where.append(" AND (t1.ESNRTEL like ? ESCAPE  '\\' ");
			params.add("%" + establecimiento.getEsnrtel() + "%");
			where.append(" OR t1.ESNRTEL2 like ? ESCAPE  '\\' ) ");
			params.add("%" + establecimiento.getEsnrtel() + "%");
		}
		if (establecimiento != null && establecimiento.getEsnrfax() != null) {
			where.append(" AND t1.ESNRFAX = ?");
			params.add(establecimiento.getEsnrfax());
		}
		if (establecimiento != null && establecimiento.getEscopa() != null) {
			where.append(" AND t1.ESCOPA = ?");
			params.add(establecimiento.getEscopa());
		}
		if (establecimiento != null && establecimiento.getEsincapr() != null) {
			where.append(" AND t1.ESINCAPR = ?");
			params.add(establecimiento.getEsincapr());
		}
		if (establecimiento != null && establecimiento.getEsindemp() != null) {
			where.append(" AND t1.ESINDEMP = ?");
			params.add(establecimiento.getEsindemp());
		}
		if (establecimiento != null && establecimiento.getEsteco() != null) {
			where.append(" AND t1.ESTECO = ?");
			params.add(establecimiento.getEsteco());
		}
		if (establecimiento != null && establecimiento.getEssede() != null) {
			// Sacar solamente las SEDES
			if (Y41bConstantes.SI.equals(establecimiento.getEssede())) {
				where.append(" AND t1.ESSEDE = ?");
				params.add(Y41bConstantes.SI);
			}
		}
		if (establecimiento != null && establecimiento.getEsinadar() != null) {
			// Sacar solamente los ADHERIDOS (que no esten de baja)
			// Para saber si el establecimiento esta adherido, debemos usar la
			// tabla de ADHERIDO_ESTABLECIMIENTO
			if (Y41bConstantes.SI.equals(establecimiento.getEsinadar())) {
				where.append(" AND t4.AHCODIGO IS NOT NULL");
				where.append(" AND (t4.AHFEBA IS NULL");

				where.append(" OR (t4.AHFEBA IS NOT NULL");
				where.append(" AND t4.AHFEBA>=sysdate) )");
			}
		}
		if (establecimiento != null && establecimiento.getEsfeadar() != null) {
			where.append(" AND t1.ESFEADAR = ?");
			params.add(establecimiento.getEsfeadar());
		}
		if (establecimiento != null && establecimiento.getEscoem() != null) {
			where.append(" AND t1.ESCOEM = ?");
			params.add(establecimiento.getEscoem());
		}
		if (establecimiento != null && establecimiento.getEsinempr() != null) {
			where.append(" AND t1.ESINEMPR = ?");
			params.add(establecimiento.getEsinempr());
		}
		if (establecimiento != null && establecimiento.getEsnrtel2() != null) {
			where.append(" AND t1.ESNRTEL2 = ?");
			params.add(establecimiento.getEsnrtel2());
		}
		if (establecimiento != null && establecimiento.getEsfeba() != null) {
			where.append(" AND t1.ESFEBA = ?");
			params.add(establecimiento.getEsfeba());
		}
		if (establecimiento != null && establecimiento.getEsinfeba() == null) {
			where.append(" AND t1.ESFEBA IS NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoap1() != null) {
			where.append(" AND t1.ESNOAP1 = ?");
			params.add(establecimiento.getEsnoap1());
		}
		if (establecimiento != null && establecimiento.getEsnoap2() != null) {
			where.append(" AND t1.ESNOAP2 = ?");
			params.add(establecimiento.getEsnoap2());
		}
		if (establecimiento != null && establecimiento.getEsnolo() != null) {
			where.append(" AND t1.ESNOLO = ?");
			params.add(establecimiento.getEsnolo());
		}
		if (establecimiento != null && establecimiento.getEscomapv() != null) {
			where.append(" AND t1.ESCOMAPV = ?");
			params.add(establecimiento.getEscomapv());
		}
		if (establecimiento != null && establecimiento.getEscoca() != null) {
			where.append(" AND t1.ESCOCA = ?");
			params.add(establecimiento.getEscoca());
		}
		if (establecimiento != null && establecimiento.getEsnopeco() != null) {
			where.append(" AND t1.ESNOPECO = ?");
			params.add(establecimiento.getEsnopeco());
		}
		if (establecimiento != null && establecimiento.getEscoidco() != null) {
			where.append(" AND t1.ESCOIDCO = ?");
			params.add(establecimiento.getEscoidco());
		}
		if (establecimiento != null && establecimiento.getEsinreco() != null) {
			where.append(" AND t1.ESINRECO = ?");
			params.add(establecimiento.getEsinreco());
		}
		if (establecimiento != null && establecimiento.getEsfemod() != null) {
			where.append(" AND t1.ESFEMOD = ?");
			params.add(establecimiento.getEsfemod());
		}
		if (establecimiento != null && establecimiento.getEsinesco() != null) {
			where.append(" AND t1.ESINESCO = ?");
			params.add(establecimiento.getEsinesco());
		}
		if (establecimiento != null && establecimiento.getEsnomu() != null) {
			where.append(" AND t1.ESNOMU = ?");
			params.add(establecimiento.getEsnomu());
		}
		if (establecimiento != null && establecimiento.getEsnorep() != null) {
			where.append(" AND t1.ESNOREP = ?");
			params.add(establecimiento.getEsnorep());
		}
		if (establecimiento != null && establecimiento.getEsnifrep() != null) {
			where.append(" AND t1.ESNIFREP = ?");
			params.add(establecimiento.getEsnifrep());
		}
		if (establecimiento != null && establecimiento.getDtteemr() != null) {
			where.append(" AND t1.DTTEEMR = ?");
			params.add(establecimiento.getDtteemr());
		}
		if (establecimiento != null && establecimiento.getEscarep() != null) {
			where.append(" AND t1.ESCAREP = ?");
			params.add(establecimiento.getEscarep());
		}
		if (establecimiento != null && establecimiento.getEsteurl() != null) {
			where.append(" AND t1.ESTEURL = ?");
			params.add(establecimiento.getEsteurl());
		}
		if (establecimiento != null && establecimiento.getEscooe() != null) {
			where.append(" AND t1.ESCOOE = ?");
			params.add(establecimiento.getEscooe());
		}
		if (establecimiento != null && establecimiento.getEsnodeco() != null) {
			where.append(" AND t1.ESNODECO = ?");
			params.add(establecimiento.getEsnodeco());
		}
		if (establecimiento != null && establecimiento.getEsintiar() != null) {
			where.append(" AND t1.ESINTIAR = ?");
			params.add(establecimiento.getEsintiar());
		}
		if (establecimiento != null && establecimiento.getEsfeplad() != null) {
			where.append(" AND t1.ESFEPLAD = ?");
			params.add(establecimiento.getEsfeplad());
		}
		if (establecimiento != null && establecimiento.getEsindeme() != null) {
			where.append(" AND t1.ESINDEME = ?");
			params.add(establecimiento.getEsindeme());
		}
		if (establecimiento != null && establecimiento.getEsnoraPaisId() != null) {
			where.append(" AND t1.ESNORA_PAIS_ID = ?");
			params.add(establecimiento.getEsnoraPaisId());
		}
		if (establecimiento != null && establecimiento.getEsnoraPaisNombre() != null) {
			where.append(" AND t1.ESNORA_PAIS_NOMBRE = ?");
			params.add(establecimiento.getEsnoraPaisNombre());
		}
		if (establecimiento != null && establecimiento.getEsnoraProvinciaId() != null) {
			where.append(" AND t1.ESNORA_PROVINCIA_ID = ?");
			params.add(establecimiento.getEsnoraProvinciaId());
		}
		if (establecimiento != null && establecimiento.getEsnombreProvincia() != null) {
			where.append(" AND t1.ESNOMBRE_PROVINCIA = ?");
			params.add(establecimiento.getEsnombreProvincia());
		}
		if (establecimiento != null && establecimiento.getEsnoraMunicipioId() != null) {
			where.append(" AND t1.ESNORA_MUNICIPIO_ID = ?");
			params.add(establecimiento.getEsnoraMunicipioId());
		}
		if (establecimiento != null && establecimiento.getEsnombreMunicipio() != null) {
			where.append(" AND t1.ESNOMBRE_MUNICIPIO = ?");
			params.add(establecimiento.getEsnombreMunicipio());
		}
		if (establecimiento != null && establecimiento.getEsnoraLocalidadId() != null) {
			where.append(" AND t1.ESNORA_LOCALIDAD_ID = ?");
			params.add(establecimiento.getEsnoraLocalidadId());
		}
		if (establecimiento != null && establecimiento.getEsnombreLocalidad() != null) {
			where.append(" AND t1.ESNOMBRE_LOCALIDAD = ?");
			params.add(establecimiento.getEsnombreLocalidad());
		}
		if (establecimiento != null && establecimiento.getEsnoraCalleId() != null) {
			where.append(" AND t1.ESNORA_CALLE_ID = ?");
			params.add(establecimiento.getEsnoraCalleId());
		}
		if (establecimiento != null && establecimiento.getEsnombreCalle() != null) {
			where.append(" AND t1.ESNOMBRE_CALLE = ?");
			params.add(establecimiento.getEsnombreCalle());
		}
		if (establecimiento != null && establecimiento.getEsnoraCpId() != null) {
			where.append(" AND t1.ESNORA_CP_ID = ?");
			params.add(establecimiento.getEsnoraCpId());
		}
		if (establecimiento != null && establecimiento.getEsnombreCp() != null) {
			where.append(" AND t1.ESNOMBRE_CP = ?");
			params.add(establecimiento.getEsnombreCp());
		}
		if (establecimiento != null && establecimiento.getEsnoraPortalId() != null) {
			where.append(" AND t1.ESNORA_PORTAL_ID = ?");
			params.add(establecimiento.getEsnoraPortalId());
		}
		if (establecimiento != null && establecimiento.getEsnombrePortal() != null) {
			where.append(" AND t1.ESNOMBRE_PORTAL = ?");
			params.add(establecimiento.getEsnombrePortal());
		}

		if (establecimiento != null && establecimiento.getEsnombrePiso() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.ESNOMBRE_PISO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombrePiso().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombrePiso().toUpperCase().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.ESNOMBRE_PISO IS NOT NULL) ");
			where.append(" OR (TRANSLATE(UPPER(t1.ESNOMBRE_CALLE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombrePiso().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombrePiso().toUpperCase().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.ESNOMBRE_CALLE IS NOT NULL)");
			where.append(" OR (TRANSLATE(UPPER(t1.ESNODIR),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombrePiso().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombrePiso().toUpperCase().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.ESNODIR IS NOT NULL))");
		}
		if (establecimiento != null && establecimiento.getEsdireccion_nocapv() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ESDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ establecimiento.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.ESDIRECCION_NOCAPV IS NOT NULL");
		}

		if (establecimiento != null && establecimiento.getEsextranjero() != null
				&& establecimiento.getEsestado() == null) {
			where.append(" AND t1.ESEXTRANJERO = ?");
			params.add(Y41bConstantes.SI);
		}
		if (establecimiento != null && establecimiento.getEsestado() != null
				&& establecimiento.getEsextranjero() == null) {
			where.append(" AND t1.ESEXTRANJERO = ?");
			params.add(Y41bConstantes.NO);
		}
		if (establecimSector != null && establecimSector.getSector() != null
				&& establecimSector.getSector().getSecodigo() != null) {
			where.append(" AND UPPER(t3.EACOSE) like ? ESCAPE  '\\'");
			params.add(establecimSector.getSector().getSecodigo().toUpperCase() + "%");
			where.append(" AND t3.EACOSE IS NOT NULL");
		}

		/*
		 * Colección de descriptores a las que pueden pertenecer los
		 * establecimiento
		 */
		if (establecimiento != null && establecimiento.getDescriptores() != null
				&& establecimiento.getDescriptores().size() > 0) {

			where.append(" AND t1.ESCODIGO IN (SELECT ESCODIGO FROM ESTABLECIMIENTO_DESCRIPTOR WHERE ");
			boolean firstElement = true;

			for (Descriptor e : establecimiento.getDescriptores()) {

				if (firstElement) {

					where.append("ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
					firstElement = false;

				} else {

					where.append(" OR ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
				}
			}

			where.append(") ");
		}

		if (establecimiento != null && establecimiento.getBajaAd() != null) {
			// Sacar solamente los DADOS DE BAJA DE ADHERIDOS
			// Para saber si el establecimiento esta adherido, debemos usar la
			// tabla de ADHERIDO_ESTABLECIMIENTO
			if (Y41bConstantes.SI.equals(establecimiento.getBajaAd())) {
				where.append(" AND t4.AHCODIGO IS NOT NULL");
				where.append(" AND t4.AHFEBA IS NOT NULL");
				where.append(" AND t4.AHFEBA<sysdate ");
			}
		}

		if (establecimiento != null && establecimiento.getSinRenuncia() != null) {
			// 0150111 Sacar solamente los DADOS DE BAJA DE ADHERIDOS
			// Para saber si el establecimiento esta adherido, debemos usar la
			// tabla de ADHERIDO_ESTABLECIMIENTO
			if (Y41bConstantes.SI.equals(establecimiento.getSinRenuncia())) {
				where.append(" AND (t4.AHCODIGO IS NULL");
				where.append(" OR t4.AHFEBA IS NULL)");
				// where.append(" AND t4.AHFEBA<sysdate ");
			}
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<EstablecimientoDetalle>) this.jdbcTemplate.query(query.toString(), rwMapEstablecimientoDetalle,
				params.toArray());
	}

	/**
	 * Counts rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeEstablecimientoCount(Establecimiento establecimiento, EstablecimSector establecimSector,
			Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1  and t1.ESCOZS= t2.MOCODIGO(+)  AND t1.ESCODIGO = t3.EACOES(+) AND t1.ESCODIGO = t4.AHCOES(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(distinct t1.ESCODIGO) FROM  ESTABLECIMIENTO t1, CENSO_MONITOR t2, ESTABLECIM_SECTOR t3, ESTABLECIM_ARBITRA t4 ");

		if (establecimiento != null && establecimiento.getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(establecimiento.getEscodigo());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO = ?");
			params.add(establecimiento.getCensoMonitor().getMocodigo());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getOrganismo() != null
				&& establecimiento.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.MOCOOR = ?");
			params.add(establecimiento.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t2.MONOMBRE = ?");
			params.add(establecimiento.getCensoMonitor().getMonombre());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t2.MOCOEM = ?");
			params.add(establecimiento.getCensoMonitor().getMocoem());
		}
		if (establecimiento != null && establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA = ?");
			params.add(establecimiento.getCensoMonitor().getMofecbaja());
		}
		if (establecimiento != null && establecimiento.getEsnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + establecimiento.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.ESNOMBRE IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t1.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + establecimiento.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.ESNOCO IS NOT NULL)) ");
		}
		if (establecimiento != null && establecimiento.getEsnif() != null) {
			where.append(" AND UPPER(t1.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNIF IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoan() != null) {
			where.append(" AND t1.ESNOAN = ?");
			params.add(establecimiento.getEsnoan());
		}
		if (establecimiento != null && establecimiento.getEsnoco() != null) {
			where.append(" AND t1.ESNOCO = ?");
			params.add(establecimiento.getEsnoco());
		}
		if (establecimiento != null && establecimiento.getEsnodir() != null) {
			where.append(" AND t1.ESNODIR = ?");
			params.add(establecimiento.getEsnodir());
		}
		if (establecimiento != null && establecimiento.getEscolo() != null) {
			where.append(" AND t1.ESCOLO = ?");
			params.add(establecimiento.getEscolo());
		}
		if (establecimiento != null && establecimiento.getEsnrcopo() != null) {
			where.append(" AND t1.ESNRCOPO = ?");
			params.add(establecimiento.getEsnrcopo());
		}
		if (establecimiento != null && establecimiento.getEsnrtel() != null) {
			where.append(" AND (t1.ESNRTEL like ? ESCAPE  '\\' ");
			params.add(establecimiento.getEsnrtel());
			where.append(" OR t1.ESNRTEL2 like ? ESCAPE  '\\' ) ");
			params.add(establecimiento.getEsnrtel());
		}
		if (establecimiento != null && establecimiento.getEsnrfax() != null) {
			where.append(" AND t1.ESNRFAX = ?");
			params.add(establecimiento.getEsnrfax());
		}
		if (establecimiento != null && establecimiento.getEscopa() != null) {
			where.append(" AND t1.ESCOPA = ?");
			params.add(establecimiento.getEscopa());
		}
		if (establecimiento != null && establecimiento.getEsincapr() != null) {
			where.append(" AND t1.ESINCAPR = ?");
			params.add(establecimiento.getEsincapr());
		}
		if (establecimiento != null && establecimiento.getEsindemp() != null) {
			where.append(" AND t1.ESINDEMP = ?");
			params.add(establecimiento.getEsindemp());
		}
		if (establecimiento != null && establecimiento.getEsteco() != null) {
			where.append(" AND t1.ESTECO = ?");
			params.add(establecimiento.getEsteco());
		}
		if (establecimiento != null && establecimiento.getEssede() != null) {
			// Sacar solamente las SEDES
			if (Y41bConstantes.SI.equals(establecimiento.getEssede())) {
				where.append(" AND t1.ESSEDE = ?");
				params.add(Y41bConstantes.SI);
			}
		}
		if (establecimiento != null && establecimiento.getEsinadar() != null) {
			// Sacar solamente los ADHERIDOS (que no esten de baja)
			// Para saber si el establecimiento esta adherido, debemos usar la
			// tabla de ADHERIDO_ESTABLECIMIENTO
			if (Y41bConstantes.SI.equals(establecimiento.getEsinadar())) {
				where.append(" AND t4.AHCODIGO IS NOT NULL");
				where.append(" AND (t4.AHFEBA IS NULL");
				where.append(" OR (t4.AHFEBA IS NOT NULL");
				where.append(" AND t4.AHFEBA>=sysdate) )");
			}
		}
		if (establecimiento != null && establecimiento.getEsfeadar() != null) {
			where.append(" AND t1.ESFEADAR = ?");
			params.add(establecimiento.getEsfeadar());
		}
		if (establecimiento != null && establecimiento.getEscoem() != null) {

			where.append(" AND UPPER(t1.ESCOEM) like ? ESCAPE '\\'");
			params.add("%" + establecimiento.getEscoem().toUpperCase() + "%");
		}
		if (establecimiento != null && establecimiento.getEsinempr() != null) {
			where.append(" AND t1.ESINEMPR = ?");
			params.add(establecimiento.getEsinempr());
		}
		if (establecimiento != null && establecimiento.getEsnrtel2() != null) {
			where.append(" AND t1.ESNRTEL2 = ?");
			params.add(establecimiento.getEsnrtel2());
		}
		if (establecimiento != null && establecimiento.getEsfeba() != null) {
			where.append(" AND t1.ESFEBA = ?");
			params.add(establecimiento.getEsfeba());
		}
		if (establecimiento != null && establecimiento.getEsinfeba() == null) {
			where.append(" AND t1.ESFEBA IS NULL");
		}
		// 0150111 mostrar cerrados
		// Se comenta las nuevas opciones a raiz de lo decidido el dia
		// 14/04/2020 y se vuelve a poner lo que habia antes
		// if (establecimiento != null && establecimiento.getEsinfeba() != null)
		// {
		// where.append(" AND t1.ESFEBA IS NOT NULL");
		// }
		// 0150111
		if (establecimiento != null && establecimiento.getEsnoap1() != null) {
			where.append(" AND t1.ESNOAP1 = ?");
			params.add(establecimiento.getEsnoap1());
		}
		if (establecimiento != null && establecimiento.getEsnoap2() != null) {
			where.append(" AND t1.ESNOAP2 = ?");
			params.add(establecimiento.getEsnoap2());
		}
		if (establecimiento != null && establecimiento.getEsnolo() != null) {
			where.append(" AND t1.ESNOLO = ?");
			params.add(establecimiento.getEsnolo());
		}
		if (establecimiento != null && establecimiento.getEscomapv() != null) {
			where.append(" AND t1.ESCOMAPV = ?");
			params.add(establecimiento.getEscomapv());
		}
		if (establecimiento != null && establecimiento.getEscoca() != null) {
			where.append(" AND t1.ESCOCA = ?");
			params.add(establecimiento.getEscoca());
		}
		if (establecimiento != null && establecimiento.getEsnopeco() != null) {
			where.append(" AND t1.ESNOPECO = ?");
			params.add(establecimiento.getEsnopeco());
		}
		if (establecimiento != null && establecimiento.getEscoidco() != null) {
			where.append(" AND t1.ESCOIDCO = ?");
			params.add(establecimiento.getEscoidco());
		}
		if (establecimiento != null && establecimiento.getEsinreco() != null) {
			where.append(" AND t1.ESINRECO = ?");
			params.add(establecimiento.getEsinreco());
		}
		if (establecimiento != null && establecimiento.getEsfemod() != null) {
			where.append(" AND t1.ESFEMOD = ?");
			params.add(establecimiento.getEsfemod());
		}
		if (establecimiento != null && establecimiento.getEsinesco() != null) {
			where.append(" AND t1.ESINESCO = ?");
			params.add(establecimiento.getEsinesco());
		}
		if (establecimiento != null && establecimiento.getEsnomu() != null) {
			where.append(" AND t1.ESNOMU = ?");
			params.add(establecimiento.getEsnomu());
		}
		if (establecimiento != null && establecimiento.getEsnorep() != null) {
			where.append(" AND t1.ESNOREP = ?");
			params.add(establecimiento.getEsnorep());
		}
		if (establecimiento != null && establecimiento.getEsnifrep() != null) {
			where.append(" AND t1.ESNIFREP = ?");
			params.add(establecimiento.getEsnifrep());
		}
		if (establecimiento != null && establecimiento.getDtteemr() != null) {
			where.append(" AND t1.DTTEEMR = ?");
			params.add(establecimiento.getDtteemr());
		}
		if (establecimiento != null && establecimiento.getEscarep() != null) {
			where.append(" AND t1.ESCAREP = ?");
			params.add(establecimiento.getEscarep());
		}
		if (establecimiento != null && establecimiento.getEsteurl() != null) {
			where.append(" AND t1.ESTEURL = ?");
			params.add(establecimiento.getEsteurl());
		}
		if (establecimiento != null && establecimiento.getEscooe() != null) {
			where.append(" AND t1.ESCOOE = ?");
			params.add(establecimiento.getEscooe());
		}
		if (establecimiento != null && establecimiento.getEsnodeco() != null) {
			where.append(" AND t1.ESNODECO = ?");
			params.add(establecimiento.getEsnodeco());
		}
		if (establecimiento != null && establecimiento.getEsintiar() != null) {
			where.append(" AND t1.ESINTIAR = ?");
			params.add(establecimiento.getEsintiar());
		}
		if (establecimiento != null && establecimiento.getEsfeplad() != null) {
			where.append(" AND t1.ESFEPLAD = ?");
			params.add(establecimiento.getEsfeplad());
		}
		if (establecimiento != null && establecimiento.getEsindeme() != null) {
			where.append(" AND t1.ESINDEME = ?");
			params.add(establecimiento.getEsindeme());
		}
		if (establecimiento != null && establecimiento.getEsnoraPaisId() != null) {
			where.append(" AND t1.ESNORA_PAIS_ID = ?");
			params.add(establecimiento.getEsnoraPaisId());
		}
		if (establecimiento != null && establecimiento.getEsnoraPaisNombre() != null) {
			where.append(" AND t1.ESNORA_PAIS_NOMBRE = ?");
			params.add(establecimiento.getEsnoraPaisNombre());
		}
		if (establecimiento != null && establecimiento.getEsnoraProvinciaId() != null) {
			where.append(" AND t1.ESNORA_PROVINCIA_ID = ?");
			params.add(establecimiento.getEsnoraProvinciaId());
		}
		if (establecimiento != null && establecimiento.getEsnombreProvincia() != null) {
			where.append(" AND t1.ESNOMBRE_PROVINCIA = ?");
			params.add(establecimiento.getEsnombreProvincia());
		}
		if (establecimiento != null && establecimiento.getEsnoraMunicipioId() != null) {
			where.append(" AND t1.ESNORA_MUNICIPIO_ID = ?");
			params.add(establecimiento.getEsnoraMunicipioId());
		}
		if (establecimiento != null && establecimiento.getEsnombreMunicipio() != null) {
			where.append(" AND t1.ESNOMBRE_MUNICIPIO = ?");
			params.add(establecimiento.getEsnombreMunicipio());
		}
		if (establecimiento != null && establecimiento.getEsnoraLocalidadId() != null) {
			where.append(" AND t1.ESNORA_LOCALIDAD_ID = ?");
			params.add(establecimiento.getEsnoraLocalidadId());
		}
		if (establecimiento != null && establecimiento.getEsnombreLocalidad() != null) {
			where.append(" AND t1.ESNOMBRE_LOCALIDAD = ?");
			params.add(establecimiento.getEsnombreLocalidad());
		}
		if (establecimiento != null && establecimiento.getEsnoraCalleId() != null) {
			where.append(" AND t1.ESNORA_CALLE_ID = ?");
			params.add(establecimiento.getEsnoraCalleId());
		}
		if (establecimiento != null && establecimiento.getEsnombreCalle() != null) {
			where.append(" AND t1.ESNOMBRE_CALLE = ?");
			params.add(establecimiento.getEsnombreCalle());
		}
		if (establecimiento != null && establecimiento.getEsnoraCpId() != null) {
			where.append(" AND t1.ESNORA_CP_ID = ?");
			params.add(establecimiento.getEsnoraCpId());
		}
		if (establecimiento != null && establecimiento.getEsnombreCp() != null) {
			where.append(" AND t1.ESNOMBRE_CP = ?");
			params.add(establecimiento.getEsnombreCp());
		}
		if (establecimiento != null && establecimiento.getEsnoraPortalId() != null) {
			where.append(" AND t1.ESNORA_PORTAL_ID = ?");
			params.add(establecimiento.getEsnoraPortalId());
		}
		if (establecimiento != null && establecimiento.getEsnombrePortal() != null) {
			where.append(" AND t1.ESNOMBRE_PORTAL = ?");
			params.add(establecimiento.getEsnombrePortal());
		}

		if (establecimiento != null && establecimiento.getEsnombrePiso() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.ESNOMBRE_PISO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombrePiso().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombrePiso().toUpperCase().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.ESNOMBRE_PISO IS NOT NULL) ");
			where.append(" OR (TRANSLATE(UPPER(t1.ESNOMBRE_CALLE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombrePiso().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombrePiso().toUpperCase().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.ESNOMBRE_CALLE IS NOT NULL)");
			where.append(" OR (TRANSLATE(UPPER(t1.ESNODIR),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombrePiso().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombrePiso().toUpperCase().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.ESNODIR IS NOT NULL))");
		}
		if (establecimiento != null && establecimiento.getEsdireccion_nocapv() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.ESDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ establecimiento.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.ESDIRECCION_NOCAPV IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsextranjero() != null
				&& establecimiento.getEsestado() == null) {
			where.append(" AND t1.ESEXTRANJERO = ?");
			params.add(Y41bConstantes.SI);
		}
		if (establecimiento != null && establecimiento.getEsestado() != null
				&& establecimiento.getEsextranjero() == null) {
			where.append(" AND t1.ESEXTRANJERO = ?");
			params.add(Y41bConstantes.NO);
		}
		if (establecimSector != null && establecimSector.getSector() != null
				&& establecimSector.getSector().getSecodigo() != null) {
			where.append(" AND UPPER(t3.EACOSE) like ? ESCAPE  '\\'");
			params.add(establecimSector.getSector().getSecodigo().toUpperCase() + "%");
			where.append(" AND t3.EACOSE IS NOT NULL");
		}

		/*
		 * Colección de descriptores a las que pueden pertenecer los
		 * establecimiento
		 */
		if (establecimiento != null && establecimiento.getDescriptores() != null
				&& establecimiento.getDescriptores().size() > 0) {

			where.append(" AND t1.ESCODIGO IN (SELECT ESCODIGO FROM ESTABLECIMIENTO_DESCRIPTOR WHERE ");
			boolean firstElement = true;

			for (Descriptor e : establecimiento.getDescriptores()) {

				if (firstElement) {

					where.append("ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
					firstElement = false;

				} else {

					where.append(" OR ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
				}
			}

			where.append(") ");
		}

		if (establecimiento != null && establecimiento.getBajaAd() != null) {
			// Sacar solamente los DADOS DE BAJA DE ADHERIDOS
			// Para saber si el establecimiento esta adherido, debemos usar la
			// tabla de ADHERIDO_ESTABLECIMIENTO
			if (Y41bConstantes.SI.equals(establecimiento.getBajaAd())) {
				where.append(" AND t4.AHCODIGO IS NOT NULL");
				where.append(" AND t4.AHFEBA IS NOT NULL");
				where.append(" AND t4.AHFEBA<sysdate ");
			}
		}

		if (establecimiento != null && establecimiento.getAhnrdi() != null) {
			where.append(" AND t4.AHNRDI=? ");
			params.add(establecimiento.getAhnrdi());
		}

		if (establecimiento != null && establecimiento.getSinRenuncia() != null) {
			// 0150111 Sacar solamente los DADOS DE BAJA DE ADHERIDOS
			// Para saber si el establecimiento esta adherido, debemos usar la
			// tabla de ADHERIDO_ESTABLECIMIENTO
			if (Y41bConstantes.SI.equals(establecimiento.getSinRenuncia())) {
				where.append(" AND (t4.AHCODIGO IS NULL");
				where.append(" OR t4.AHFEBA IS NULL)");
				// where.append(" AND t4.AHFEBA<sysdate ");
			}
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Inserts a single row in the EstablecimientoDescriptor table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	public Establecimiento addEstablecimientoDescriptor(Establecimiento establecimiento) {
		String query = "INSERT INTO ESTABLECIMIENTO_DESCRIPTOR " + "( ESCODIGO,ID_DESCRIPTOR) " + " values (?, ?)";

		List<Descriptor> descriptorAux = establecimiento.getDescriptores();
		Iterator<Descriptor> it = descriptorAux.iterator();
		while (it.hasNext()) {
			Descriptor descriptor = (Descriptor) it.next();
			this.jdbcTemplate.update(query, establecimiento.getEscodigo(), descriptor.getIdDescriptor());
		}
		return establecimiento;
	}

	/**
	 * Finds a List of rows in the EstablecimientoDescriptor table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Establecimiento> findAllEstablecimientosDescriptores(Establecimiento establecimiento,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer("select t1.ESCODIGO ESCODIGO " + "FROM ESTABLECIMIENTO_DESCRIPTOR t1 ");

		if (establecimiento != null && establecimiento.getDescriptores() != null
				&& establecimiento.getDescriptores().size() > 0) {

			where.append(" AND ( ");
			boolean firstElement = true;

			for (Descriptor e : establecimiento.getDescriptores()) {

				if (firstElement) {

					where.append("ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
					firstElement = false;

				} else {

					where.append(" OR ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
				}
			}

			where.append(") ");
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Establecimiento>) this.jdbcTemplate.query(query.toString(), new RowMapper<Establecimiento>() {
			public Establecimiento mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Establecimiento(resultSet.getString("ESCODIGO"));
			}
		}, params.toArray());
	}

	/**
	 * Updates a single row in the EstablecimientoDescriptor table.
	 * 
	 * @param descriptorAEliminar
	 *            Descriptor
	 * @param descriptorBueno
	 *            Descriptor
	 * @return Descriptor
	 */
	public Descriptor updateEstablecimientoDescriptor(Descriptor descriptorAEliminar, Descriptor descriptorBueno) {
		String query = "UPDATE ESTABLECIMIENTO_DESCRIPTOR SET ID_DESCRIPTOR=? WHERE ID_DESCRIPTOR=?";

		this.jdbcTemplate.update(query, descriptorBueno.getIdDescriptor(), descriptorAEliminar.getIdDescriptor());

		return descriptorAEliminar;
	}

	/**
	 * Deletes a single row in the EstablecimientoDescriptor table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeEstablecimientoDescriptor(Establecimiento establecimiento) {
		String query = "DELETE  FROM ESTABLECIMIENTO_DESCRIPTOR " + " WHERE ESCODIGO=? AND ID_DESCRIPTOR=?";
		List<Descriptor> descriptorAux = establecimiento.getDescriptores();
		Iterator<Descriptor> it = descriptorAux.iterator();
		while (it.hasNext()) {
			Descriptor descriptor = (Descriptor) it.next();
			this.jdbcTemplate.update(query, establecimiento.getEscodigo(), descriptor.getIdDescriptor());
		}
	}

	/**
	 * Deletes a single row in the EstablecimientoDescriptor table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeAllEstablecimientoDescriptor(Establecimiento establecimiento) {
		String query = "DELETE  FROM ESTABLECIMIENTO_DESCRIPTOR " + " WHERE ESCODIGO=? ";
		this.jdbcTemplate.update(query, establecimiento.getEscodigo());
	}

	/**
	 * Find a single row in the findAllEstablecimientoDescriptor Many To Many
	 * relationship.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Descriptor> findAllEstablecimientoDescriptor(Establecimiento establecimiento, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ID_DESCRIPTOR = t2.ID_DESCRIPTOR AND t1.ESCODIGO=?");

		params.add(establecimiento.getEscodigo());

		StringBuffer query = new StringBuffer(
				"SELECT t2.ID_DESCRIPTOR IDDESCRIPTOR, t2.NOMBRE NOMBRE FROM ESTABLECIMIENTO_DESCRIPTOR t1,DESCRIPTOR t2  ");
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY UPPER(" + pagination.getSort() + ") " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Descriptor>) this.jdbcTemplate.query(query.toString(), new RowMapper<Descriptor>() {
			public Descriptor mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Descriptor(resultSet.getString("IDDESCRIPTOR"), resultSet.getString("NOMBRE"));
			}
		}, params.toArray());
	}

	/**
	 * 
	 * @param relacionadosArb
	 *            String
	 * @param relacionadosSol
	 *            String
	 * @param relacionadosSan
	 *            String
	 * @param relacionadosIns
	 *            String
	 * @param seleccionados
	 *            String
	 * @param tipoproc
	 *            String
	 * @return boolean
	 */
	public List<Establecimiento> findAllEstablecimiento(String relacionadosArb, String relacionadosSol,
			String relacionadosSan, String relacionadosIns, String seleccionados, String tipoproc) {

		StringBuffer codigos = new StringBuffer("");
		List<Object> params = new ArrayList<Object>();

		// Solicitudes
		StringBuffer query = new StringBuffer(
				"SELECT distinct t2.ESNIF ESNIF FROM HECHO_DENUNCIADO t1, ESTABLECIMIENTO t2 ");
		StringBuffer where = new StringBuffer(3000);
		where.append(" WHERE 1=1 AND t1.HDCOES= t2.ESCODIGO(+) ");
		if (!"".equals(relacionadosSol)
				|| (!"".equals(seleccionados) && Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoproc))) {
			where.append(" AND (");
			if (!"".equals(relacionadosSol)) {
				String[] arrayValores = relacionadosSol.split(",");
				for (int i = 0; i < arrayValores.length; i++) {
					if (codigos.length() > 0) {
						codigos.append(" OR ");
					}
					codigos.append(" t1.HDCODIGO = '").append(arrayValores[i]).append("'");
				}

			}

			if (!"".equals(seleccionados) && Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoproc)) {
				String[] arrayValores = seleccionados.split(",");
				for (int i = 0; i < arrayValores.length; i++) {
					if (codigos.length() > 0) {
						codigos.append(" OR ");
					}
					codigos.append(" t1.HDCODIGO = '").append(arrayValores[i]).append("'");
				}
			}
			where.append(codigos);
			where.append(" ) ");
		}
		query.append(where);

		// Arbitraje
		StringBuffer query1 = new StringBuffer(
				"SELECT distinct t2.ESNIF ESNIF FROM SOLARB t1, ESSA t3, ESTABLECIMIENTO t2 ");
		StringBuffer where1 = new StringBuffer(3000);
		where1.append(" WHERE 1=1 AND t1.SACODIGO=t3.MACOSA AND t3.MACOES=t2.ESCODIGO ");
		if (!"".equals(relacionadosArb)
				|| (!"".equals(seleccionados) && Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc))) {
			where1.append(" AND (");
			codigos = new StringBuffer("");
			if (!"".equals(relacionadosArb)) {
				String[] arrayValores = relacionadosArb.split(",");

				for (int i = 0; i < arrayValores.length; i++) {
					if (codigos.length() > 0) {
						codigos.append(" OR ");
					}
					codigos.append(" t1.SACODIGO = '").append(arrayValores[i]).append("'");
				}
			}
			if (!"".equals(seleccionados) && Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc)) {
				String[] arrayValores = seleccionados.split(",");
				for (int i = 0; i < arrayValores.length; i++) {
					if (codigos.length() > 0) {
						codigos.append(" OR ");
					}
					codigos.append(" t1.SACODIGO = '").append(arrayValores[i]).append("'");
				}
			}
			where1.append(codigos);
			where1.append(" ) ");
		}
		query1.append(where1);

		StringBuilder query2 = new StringBuilder(
				"SELECT distinct t4.UANIF ESNIF FROM SOLARB t1, ARBEXP t2,  ARBINTERV t4");
		StringBuilder where2 = new StringBuilder(
				" WHERE t1.SACODIGO=t2.EXCODIGO(+) AND t1.SACODIGO=t4.UAEXCODIGO AND t4.UATIPOINTERV='")
						.append(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO).append("'");
		if (!"".equals(relacionadosArb)
				|| (!"".equals(seleccionados) && Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc))) {
			where2.append(" AND (");
			codigos = new StringBuffer("");
			if (!"".equals(relacionadosArb)) {
				String[] arrayValores = relacionadosArb.split(",");
				for (int i = 0; i < arrayValores.length; i++) {
					if (codigos.length() > 0) {
						codigos.append(" OR ");
					}
					codigos.append(" t1.SACODIGO = '").append(arrayValores[i]).append("'");
				}
			}
			if (!"".equals(seleccionados) && Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc)) {
				String[] arrayValores = seleccionados.split(",");
				for (int i = 0; i < arrayValores.length; i++) {
					if (codigos.length() > 0) {
						codigos.append(" OR ");
					}
					codigos.append(" t1.SACODIGO = '").append(arrayValores[i]).append("'");
				}
			}
			where2.append(codigos);
			where2.append(" ) ");
		}
		query2.append(where2);

		// SANCIONES
		StringBuffer query3 = new StringBuffer("SELECT distinct t2.ESNIF ESNIF FROM EXPEDIEN t1, ESTABLECIMIENTO t2 ");
		StringBuffer where3 = new StringBuffer(3000);
		where3.append(" WHERE 1=1 AND t1.EXCOES= t2.ESCODIGO(+) ");
		if (!"".equals(relacionadosSan)
				|| (!"".equals(seleccionados) && Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoproc))) {
			where3.append(" AND (");
			codigos = new StringBuffer("");
			if (!"".equals(relacionadosSan)) {
				String[] arrayValores = relacionadosSan.split(",");
				for (int i = 0; i < arrayValores.length; i++) {
					if (codigos.length() > 0) {
						codigos.append(" OR ");
					}
					codigos.append(" t1.EXCODIGO = '").append(arrayValores[i]).append("'");
				}
			}
			if (!"".equals(seleccionados) && Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoproc)) {
				String[] arrayValores = seleccionados.split(",");
				for (int i = 0; i < arrayValores.length; i++) {
					if (codigos.length() > 0) {
						codigos.append(" OR ");
					}
					codigos.append(" t1.EXCODIGO = '").append(arrayValores[i]).append("'");
				}
			}
			where3.append(codigos);
			where3.append(" ) ");
		}
		query3.append(where3);

		// INSPECCIONES
		StringBuffer query4 = new StringBuffer(
				"SELECT distinct t3.ESNIF ESNIF FROM ACTUACION t1, ACTA t2, ESTABLECIMIENTO t3 ");
		StringBuffer where4 = new StringBuffer(3000);
		where4.append(" WHERE 1=1 AND t1.ATCOAC = t2.ACCODIGO AND t2.ACCOES = t3.ESCODIGO(+) ");
		if (!"".equals(relacionadosIns)
				|| (!"".equals(seleccionados) && Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc))) {
			where4.append(" AND (");
			codigos = new StringBuffer("");
			if (!"".equals(relacionadosIns)) {
				String[] arrayValores = relacionadosIns.split(",");
				for (int i = 0; i < arrayValores.length; i++) {
					if (codigos.length() > 0) {
						codigos.append(" OR ");
					}
					codigos.append(" t1.ATCODIGO = '").append(arrayValores[i]).append("'");
				}

			}

			if (!"".equals(seleccionados) && Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc)) {
				String[] arrayValores = seleccionados.split(",");
				for (int i = 0; i < arrayValores.length; i++) {
					if (codigos.length() > 0) {
						codigos.append(" OR ");
					}
					codigos.append(" t1.ATCODIGO = '").append(arrayValores[i]).append("'");
				}
			}
			where4.append(codigos);
			where4.append(" ) ");
		}
		query4.append(where4);

		StringBuffer queryFinal = new StringBuffer("");
		if (!"".equals(relacionadosSol)
				|| (!"".equals(seleccionados) && Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoproc))) {
			queryFinal.append(query);
		}
		if (!"".equals(relacionadosArb)
				|| (!"".equals(seleccionados) && Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc))) {
			if (queryFinal.length() > 0) {
				queryFinal.append(" UNION ");
			}
			queryFinal.append(query1).append(" UNION ").append(query2);
		}
		if (!"".equals(relacionadosSan)
				|| (!"".equals(seleccionados) && Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoproc))) {
			if (queryFinal.length() > 0) {
				queryFinal.append(" UNION ");
			}
			queryFinal.append(query3);
		}
		if (!"".equals(relacionadosIns)
				|| (!"".equals(seleccionados) && Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc))) {
			if (queryFinal.length() > 0) {
				queryFinal.append(" UNION ");
			}
			queryFinal.append(query4);
		}
		logger.debug("SQL DE ACUMULACION:" + query.toString() + ".");
		return (List<Establecimiento>) this.jdbcTemplate.query(queryFinal.toString(), rwMap2, params.toArray());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.EstablecimientoDao#findPetActDatos(java.lang.String,
	 * java.lang.String)
	 */
	@Override
	public List<Establecimiento> findAllPetActDatos(String numPetActEst, String mesesPetActEst) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.ESCOZS= t2.MOCODIGO(+) AND t1.ESCODIGO = t3.AHCOES(+) AND t1.ESCOEM is not null AND t1.ESFEADAR IS NOT NULL AND (t3.AHFEBA IS NULL OR t3.AHFEBA>SYSDATE) AND (t1.ESFEBA IS NULL OR t1.ESFEBA>SYSDATE) ");

		StringBuffer query = new StringBuffer("select * from "
				+ "(SELECT t1.ESCODIGO ESCODIGO,t1.ESNOMBRE ESNOMBRE, t1.ESTIPID ESTIPID,t1.ESNIF ESNIF,t1.ESNOAN ESNOAN,t1.ESNOCO ESNOCO,t1.ESNODIR ESNODIR,t1.ESCOLO ESCOLO,t1.ESNRCOPO ESNRCOPO,t1.ESNRTEL ESNRTEL,t1.ESNRFAX ESNRFAX,t1.ESCOPA ESCOPA,t1.ESINCAPR ESINCAPR,t1.ESINDEMP ESINDEMP,t1.ESTECO ESTECO,t1.ESINADAR ESINADAR,t1.ESFEADAR ESFEADAR,t1.ESCOEM ESCOEM, t1.ESMAILNOTIFICACION ESMAILNOTIFICACION,t1.ESINEMPR ESINEMPR,t1.ESNRTEL2 ESNRTEL2,t1.ESFEBA ESFEBA,t1.ESNOAP1 ESNOAP1,t1.ESNOAP2 ESNOAP2,t1.ESNOLO ESNOLO,t1.ESCOMAPV ESCOMAPV,t1.ESCOCA ESCOCA,t1.ESNOPECO ESNOPECO,t1.ESCOIDCO ESCOIDCO,t1.ESINRECO ESINRECO,t1.ESFEMOD ESFEMOD,t1.ESINESCO ESINESCO,t1.ESNOMU ESNOMU,t1.ESNOREP ESNOREP,t1.ESNIFREP ESNIFREP,t1.DTTEEMR DTTEEMR,t1.ESCAREP ESCAREP,t1.ESTEURL ESTEURL,t1.ESCOOE ESCOOE,t1.ESNODECO ESNODECO,t1.ESINTIAR ESINTIAR,t1.ESFEPLAD ESFEPLAD,t1.ESINDEME ESINDEME,t1.ESNORA_PAIS_ID ESNORAPAISID,t1.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBRE,t1.ESNORA_PROVINCIA_ID ESNORAPROVINCIAID,t1.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIA,t1.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOID,t1.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIO,t1.ESNORA_LOCALIDAD_ID ESNORALOCALIDADID,t1.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDAD,t1.ESNORA_CALLE_ID ESNORACALLEID,t1.ESNOMBRE_CALLE ESNOMBRECALLE,t1.ESNORA_CP_ID ESNORACPID,t1.ESNOMBRE_CP ESNOMBRECP,t1.ESNORA_PORTAL_ID ESNORAPORTALID,t1.ESNOMBRE_PORTAL ESNOMBREPORTAL,t1.ESNOMBRE_PISO ESNOMBREPISO, t1.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPV, t1.ESEXTRANJERO ESEXTRANJERO, t1.ESSEDE ESSEDE,t2.MOCODIGO CENSOMONITORMOCODIGO,t2.MONOMBRE CENSOMONITORMONOMBRE,t2.MOCOEM CENSOMONITORMOCOEM, t2.MODNI CENSOMONITORMODNI, t2.USUARIOXLNET CENSOMONITORUSUARIOXLNET, t2.PUESTOXLNET CENSOMONITORPUESTOXLNET,t2.MOFECBAJA CENSOMONITORMOFECBAJA,t2.MOCOOR CENSOMONITORMOCOOR, t1.ESFEERD ESFEERD, t1.ESILOCALIZABLE ESILOCALIZABLE, t1.ESNOCOLABORA ESNOCOLABORA, t3.AHNRDI AHNRDI, NVL(t1.ESFEERD,t1.ESFEADAR) ORDERAUX "
				+ "FROM ESTABLECIMIENTO t1 ,CENSO_MONITOR t2, ESTABLECIM_ARBITRA t3 ");
		Calendar calendar = Calendar.getInstance();
		calendar.add(Calendar.MONTH, -1 * Integer.parseInt(mesesPetActEst));
		// where.append(" AND (t1.ESFEERD is null or t1.ESFEERD <= ?)");
		where.append(" AND ((t1.ESFEERD IS NULL AND t1.ESFEADAR <= ?) OR t1.ESFEERD <= ?)");
		params.add(calendar.getTime());
		params.add(calendar.getTime());
		query.append(where);

		query.append(" ORDER BY ORDERAUX ASC) where rownum<=?");
		params.add(Integer.valueOf(numPetActEst));

		return (List<Establecimiento>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.EstablecimientoDao#findPetActDatos(java.lang.String,
	 * java.lang.String)
	 */
	@Override
	public Long findAllCountPetActDatos(String mesesPetActEst) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.ESCOZS= t2.MOCODIGO(+) AND t1.ESCODIGO = t3.AHCOES(+) AND t1.ESCOEM is not null AND t1.ESFEADAR IS NOT NULL AND (t3.AHFEBA IS NULL OR t3.AHFEBA>SYSDATE) AND (t1.ESFEBA IS NULL OR t1.ESFEBA>SYSDATE) ");

		StringBuffer query = new StringBuffer(
				"SELECT count(t1.ESCODIGO) " + "FROM ESTABLECIMIENTO t1 ,CENSO_MONITOR t2, ESTABLECIM_ARBITRA t3 ");
		Calendar calendar = Calendar.getInstance();
		calendar.add(Calendar.MONTH, -1 * Integer.parseInt(mesesPetActEst));
		// where.append(" AND (t1.ESFEERD is null or t1.ESFEERD <= ?)");
		where.append(" AND ((t1.ESFEERD IS NULL AND t1.ESFEADAR <= ?) OR t1.ESFEERD <= ?)");
		params.add(calendar.getTime());
		params.add(calendar.getTime());
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.EstablecimientoDao#updatePetActDatos(java.lang.String)
	 */
	@Override
	public void updatePetActDatos(String escodigo) {
		String query = "UPDATE ESTABLECIMIENTO SET ESFEERD=sysdate WHERE ESCODIGO=?";

		this.jdbcTemplate.update(query, escodigo);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.EstablecimientoDao#findAllMailingIconoWeb(java.lang.
	 * String, java.lang.String)
	 */
	@Override
	public List<Establecimiento> findAllMailingIconoWeb(String numMailsIconoWeb, String mesesMailsIconoWeb) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.ESCOZS= t2.MOCODIGO(+) AND t1.ESCODIGO = t3.AHCOES(+) AND t1.ESCOEM is not null AND t1.ESFEADAR IS NOT NULL AND (t3.AHFEBA IS NULL OR t3.AHFEBA>SYSDATE) AND (t1.ESFEBA IS NULL OR t1.ESFEBA>SYSDATE) ");

		StringBuffer query = new StringBuffer("select * from "
				+ "(SELECT t1.ESCODIGO ESCODIGO,t1.ESNOMBRE ESNOMBRE, t1.ESTIPID ESTIPID,t1.ESNIF ESNIF,t1.ESNOAN ESNOAN,t1.ESNOCO ESNOCO,t1.ESNODIR ESNODIR,t1.ESCOLO ESCOLO,t1.ESNRCOPO ESNRCOPO,t1.ESNRTEL ESNRTEL,t1.ESNRFAX ESNRFAX,t1.ESCOPA ESCOPA,t1.ESINCAPR ESINCAPR,t1.ESINDEMP ESINDEMP,t1.ESTECO ESTECO,t1.ESINADAR ESINADAR,t1.ESFEADAR ESFEADAR,t1.ESCOEM ESCOEM, t1.ESMAILNOTIFICACION ESMAILNOTIFICACION,t1.ESINEMPR ESINEMPR,t1.ESNRTEL2 ESNRTEL2,t1.ESFEBA ESFEBA,t1.ESNOAP1 ESNOAP1,t1.ESNOAP2 ESNOAP2,t1.ESNOLO ESNOLO,t1.ESCOMAPV ESCOMAPV,t1.ESCOCA ESCOCA,t1.ESNOPECO ESNOPECO,t1.ESCOIDCO ESCOIDCO,t1.ESINRECO ESINRECO,t1.ESFEMOD ESFEMOD,t1.ESINESCO ESINESCO,t1.ESNOMU ESNOMU,t1.ESNOREP ESNOREP,t1.ESNIFREP ESNIFREP,t1.DTTEEMR DTTEEMR,t1.ESCAREP ESCAREP,t1.ESTEURL ESTEURL,t1.ESCOOE ESCOOE,t1.ESNODECO ESNODECO,t1.ESINTIAR ESINTIAR,t1.ESFEPLAD ESFEPLAD,t1.ESINDEME ESINDEME,t1.ESNORA_PAIS_ID ESNORAPAISID,t1.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBRE,t1.ESNORA_PROVINCIA_ID ESNORAPROVINCIAID,t1.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIA,t1.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOID,t1.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIO,t1.ESNORA_LOCALIDAD_ID ESNORALOCALIDADID,t1.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDAD,t1.ESNORA_CALLE_ID ESNORACALLEID,t1.ESNOMBRE_CALLE ESNOMBRECALLE,t1.ESNORA_CP_ID ESNORACPID,t1.ESNOMBRE_CP ESNOMBRECP,t1.ESNORA_PORTAL_ID ESNORAPORTALID,t1.ESNOMBRE_PORTAL ESNOMBREPORTAL,t1.ESNOMBRE_PISO ESNOMBREPISO, t1.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPV, t1.ESEXTRANJERO ESEXTRANJERO, t1.ESSEDE ESSEDE,t2.MOCODIGO CENSOMONITORMOCODIGO,t2.MONOMBRE CENSOMONITORMONOMBRE,t2.MOCOEM CENSOMONITORMOCOEM, t2.MODNI CENSOMONITORMODNI, t2.USUARIOXLNET CENSOMONITORUSUARIOXLNET, t2.PUESTOXLNET CENSOMONITORPUESTOXLNET,t2.MOFECBAJA CENSOMONITORMOFECBAJA,t2.MOCOOR CENSOMONITORMOCOOR, t1.ESFEERD ESFEERD, t1.ESILOCALIZABLE ESILOCALIZABLE, t1.ESNOCOLABORA ESNOCOLABORA, t3.AHNRDI AHNRDI, NVL(t1.ESFEMAILICONOWEB,t1.ESFEADAR) ORDERAUX "
				+ "FROM ESTABLECIMIENTO t1 ,CENSO_MONITOR t2, ESTABLECIM_ARBITRA t3 ");
		Calendar calendar = Calendar.getInstance();
		calendar.add(Calendar.MONTH, -1 * Integer.parseInt(mesesMailsIconoWeb));
		where.append(" AND (t1.ESFEMAILICONOWEB is null or t1.ESFEMAILICONOWEB <= ?)");
		params.add(calendar.getTime());
		query.append(where);

		query.append(" ORDER BY ORDERAUX ASC) where rownum<=?");
		params.add(Integer.valueOf(numMailsIconoWeb));

		return (List<Establecimiento>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.EstablecimientoDao#findPetActDatos(java.lang.String,
	 * java.lang.String)
	 */
	@Override
	public Long findAllCountMailingIconoWeb(String mesesMailsIconoWeb) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.ESCOZS= t2.MOCODIGO(+) AND t1.ESCODIGO = t3.AHCOES(+) AND t1.ESCOEM is not null AND t1.ESFEADAR IS NOT NULL AND (t3.AHFEBA IS NULL OR t3.AHFEBA>SYSDATE) AND (t1.ESFEBA IS NULL OR t1.ESFEBA>SYSDATE) ");

		StringBuffer query = new StringBuffer(
				"SELECT count(t1.ESCODIGO) " + "FROM ESTABLECIMIENTO t1 ,CENSO_MONITOR t2, ESTABLECIM_ARBITRA t3 ");
		Calendar calendar = Calendar.getInstance();
		calendar.add(Calendar.MONTH, -1 * Integer.parseInt(mesesMailsIconoWeb));
		where.append(" AND (t1.ESFEMAILICONOWEB is null or t1.ESFEMAILICONOWEB <= ?)");
		params.add(calendar.getTime());
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.EstablecimientoDao#updatePetActDatos(java.lang.String)
	 */
	@Override
	public void updateMailingIconoWeb(String escodigo) {
		String query = "UPDATE ESTABLECIMIENTO SET ESFEMAILICONOWEB=sysdate WHERE ESCODIGO=?";

		this.jdbcTemplate.update(query, escodigo);
	}

	// 0145820: Empresas adheridas: falta de incorporar acceso a documentos
	@Override
	public List<EstTipoDoc> findAllTipoDocs() {
		StringBuffer query = new StringBuffer("SELECT ETDID,ID_ETIPODOC ,ETDNOMBRE ,ETDNOMBREE FROM L21.L21Z5T00 ");
		return (List<EstTipoDoc>) this.jdbcTemplate.query(query.toString(), rwMapEstTipoDoc);
	}
}
