package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.EstTipoDoc;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;

/**
 * * EstablecimientoDao  
 * 
 *  
 */

public interface EstablecimientoDao {

	/**
	 * Inserts a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	Establecimiento add(Establecimiento establecimiento);

	/**
	 * Updates a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	Establecimiento update(Establecimiento establecimiento);

	/**
	 * Updates a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Pagination
	 * @return Establecimiento
	 */
	public Establecimiento updateSede(Establecimiento establecimiento);

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	Establecimiento find(Establecimiento establecimiento);

	/**
	 * Deletes a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	void remove(Establecimiento establecimiento);

	/**
	 * Finds a List of rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Establecimiento> findAll(Establecimiento establecimiento, Pagination pagination);

	/**
	 * Counts rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return List
	 */
	Long findAllCount(Establecimiento establecimiento);

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Establecimiento> findAllLike(Establecimiento establecimiento, Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Establecimiento> findAllLikeEstablecimiento(Establecimiento establecimiento, EstablecimSector establecimSector,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<EstablecimientoDetalle> findAllLikeEstablecimientoExtendido(Establecimiento establecimiento,
			EstablecimSector establecimSector, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	Long findAllLikeEstablecimientoCount(Establecimiento establecimiento, EstablecimSector establecimSector,
			Boolean startsWith);

	/**
	 * Inserts a single row in the EstablecimientoDescriptor table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	public Establecimiento addEstablecimientoDescriptor(Establecimiento establecimiento);

	/**
	 * Finds a List of rows in the EstablecimientoDescriptor table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Establecimiento> findAllEstablecimientosDescriptores(Establecimiento establecimiento,
			Pagination pagination, Boolean startsWith);

	/**
	 * Updates a single row in the EstablecimientoDescriptor table.
	 * 
	 * @param descriptorAEliminar
	 *            Descriptor
	 * @param descriptorBueno
	 *            Descriptor
	 * @return Descriptor
	 */
	public Descriptor updateEstablecimientoDescriptor(Descriptor descriptorAEliminar, Descriptor descriptorBueno);

	/**
	 * Deletes a single row in the EstablecimientoDescriptor table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeEstablecimientoDescriptor(Establecimiento establecimiento);

	/**
	 * Deletes a single row in the EstablecimientoDescriptor table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeAllEstablecimientoDescriptor(Establecimiento establecimiento);

	/**
	 * Find a single row in the findAllEstablecimientoDescriptor Many To Many
	 * relationship.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Descriptor> findAllEstablecimientoDescriptor(Establecimiento establecimiento, Pagination pagination);

	/**
	 * 
	 * @param relacionadosArb
	 *            String
	 * @param relacionadosSol
	 *            String
	 * @param relacionadosSan
	 *            String
	 * @param relacionadosIns
	 *            String
	 * @param seleccionados
	 *            String
	 * @param tipoproc
	 *            String
	 * @return boolean
	 */
	public List<Establecimiento> findAllEstablecimiento(String relacionadosArb, String relacionadosSol,
			String relacionadosSan, String relacionadosIns, String seleccionados, String tipoproc);

	/**
	 * @param numPetActEst
	 * @param mesesPetActEst
	 * @return
	 */
	List<Establecimiento> findAllPetActDatos(String numPetActEst, String mesesPetActEst);

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.EstablecimientoDao#updatePetActDatos(java.lang.String)
	 */
	void updatePetActDatos(String escodigo);

	/**
	 * @param mesesPetActEst
	 * @return
	 */
	Long findAllCountPetActDatos(String mesesPetActEst);

	/**
	 * @param numMailsIconoWeb
	 * @param mesesMailsIconoWeb
	 * @return
	 */
	public List<Establecimiento> findAllMailingIconoWeb(String numMailsIconoWeb, String mesesMailsIconoWeb);

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.EstablecimientoDao#updatePetActDatos(java.lang.String)
	 */
	void updateMailingIconoWeb(String escodigo);

	/**
	 * @param mesesMailsIconoWeb
	 * @return
	 */
	Long findAllCountMailingIconoWeb(String mesesMailsIconoWeb);

	/**
	 * Busca los tipos de documentos de establecimiento
	 * 
	 * @param
	 * @return
	 */
	List<EstTipoDoc> findAllTipoDocs();
}
