package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.SectorAgrupado;

/**
 * * EstablecimSectorDaoImpl  
 * 
 *  
 */
@SuppressWarnings(value = { "deprecation" })
@Repository
@Transactional
public class EstablecimSectorDaoImpl implements EstablecimSectorDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<EstablecimSector> rwMap = new RowMapper<EstablecimSector>() {
		public EstablecimSector mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			CensoMonitor censoMonitor = new CensoMonitor(resultSet.getString("EsstoESCOZS"), null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null);

			Establecimiento establecimiento = new Establecimiento(resultSet.getString("EsstoESCODIGO"),
					resultSet.getString("EsstoESNOMBRE"), resultSet.getString("EsstoESTIPID"),
					resultSet.getString("EsstoESNIF"), resultSet.getString("EsstoESNOAN"),
					resultSet.getString("EsstoESNOCO"), resultSet.getString("EsstoESNODIR"),
					resultSet.getString("EsstoESCOLO"), resultSet.getString("EsstoESNRCOPO"),
					resultSet.getString("EsstoESNRTEL"), resultSet.getString("EsstoESNRFAX"),
					resultSet.getString("EsstoESCOPA"), resultSet.getString("EsstoESINCAPR"),
					resultSet.getString("EsstoESINDEMP"), resultSet.getString("EsstoESTECO"),
					resultSet.getString("EsstoESINADAR"), resultSet.getDate("EsstoESFEADAR"),
					resultSet.getString("EsstoESCOEM"), null, resultSet.getString("EsstoESINEMPR"),
					resultSet.getString("EsstoESNRTEL2"), resultSet.getDate("EsstoESFEBA"),
					resultSet.getString("EsstoESNOAP1"), resultSet.getString("EsstoESNOAP2"),
					resultSet.getString("EsstoESNOLO"), resultSet.getString("EsstoESCOMAPV"),
					resultSet.getString("EsstoESCOCA"), resultSet.getString("EsstoESNOPECO"),
					resultSet.getString("EsstoESCOIDCO"), resultSet.getString("EsstoESINRECO"),
					resultSet.getString("EsstoESFEMOD"), resultSet.getString("EsstoESINESCO"),
					resultSet.getString("EsstoESNOMU"), resultSet.getString("EsstoESNOREP"),
					resultSet.getString("EsstoESNIFREP"), resultSet.getString("EsstoDTTEEMR"),
					resultSet.getString("EsstoESCAREP"), resultSet.getString("EsstoESTEURL"),
					resultSet.getString("EsstoESCOOE"), resultSet.getString("EsstoESNODECO"),
					resultSet.getString("EsstoESINTIAR"), resultSet.getDate("EsstoESFEPLAD"),
					resultSet.getString("EsstoESINDEME"), resultSet.getString("EsstoESNORAPAISID"),
					resultSet.getString("EsstoESNORAPAISNOMBRE"), resultSet.getString("EsstoESNORAPROVINCIAID"),
					resultSet.getString("EsstoESNOMBREPROVINCIA"), resultSet.getString("EsstoESNORAMUNICIPIOID"),
					resultSet.getString("EsstoESNOMBREMUNICIPIO"), resultSet.getString("EsstoESNORALOCALIDADID"),
					resultSet.getString("EsstoESNOMBRELOCALIDAD"), resultSet.getString("EsstoESNORACALLEID"),
					resultSet.getString("EsstoESNOMBRECALLE"), resultSet.getString("EsstoESNORACPID"),
					resultSet.getString("EsstoESNOMBRECP"), resultSet.getString("EsstoESNORAPORTALID"),
					resultSet.getString("EsstoESNOMBREPORTAL"), null, resultSet.getString("EsstoESDIRECCION_NOCAPV"),
					resultSet.getString("EsstoESEXTRANJERO"), null, null, censoMonitor);

			SectorAgrupado sectorAgrupado = new SectorAgrupado(resultSet.getString("SectorSECOL0"), null, null, null,
					null);
			Actividad actividad = new Actividad(resultSet.getString("ActividadAVCODIGO"),
					resultSet.getString("ActividadAVNOMBRE"), resultSet.getString("ActividadAVNOCO"),
					resultSet.getString("ActividadAVTEDE"), resultSet.getString("ActividadAVCOSE"),
					resultSet.getString("ActividadAVNOMBREE"), resultSet.getString("ActividadAVNOMBREI"),
					resultSet.getString("ActividadAVNOMBREF"), resultSet.getString("ActividadAVNOCOE"),
					resultSet.getString("ActividadAVNOCOI"), resultSet.getString("ActividadAVNOCOF"),
					resultSet.getString("ActividadAVTEDEE"), resultSet.getString("ActividadAVTEDEI"),
					resultSet.getString("ActividadAVTEDEF"), resultSet.getString("ActividadAVNOMBREA"),
					resultSet.getString("ActividadAVNOCOA"), resultSet.getString("ActividadAVTEDEA"));

			return new EstablecimSector(resultSet.getString("EACODIGO"), resultSet.getString("EAINPRSE"),
					establecimiento, actividad,
					new Sector(resultSet.getString("SectorSECODIGO"), resultSet.getString("SectorSENOMBRE"),
							resultSet.getString("SectorSENOCO"), resultSet.getString("SectorSEDESCRI"),
							resultSet.getString("SectorSECOSE"), resultSet.getString("SectorSENOCO2"),
							resultSet.getString("SectorSEINSEL1"), resultSet.getString("SectorSENOMBREE"),
							resultSet.getString("SectorSENOMBREI"), resultSet.getString("SectorSENOMBREF"),
							resultSet.getString("SectorSENOCOE"), resultSet.getString("SectorSENOCOI"),
							resultSet.getString("SectorSENOCOF"), resultSet.getString("SectorSEDESCRIE"),
							resultSet.getString("SectorSEDESCRII"), resultSet.getString("SectorSEDESCRIF"),
							resultSet.getString("SectorSECODGRUPO"), resultSet.getString("SectorSENOMBREA"),
							resultSet.getString("SectorSEDESCRIA"), resultSet.getString("SectorSENOCOA"),
							sectorAgrupado));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the EstablecimSector table.
	 * 
	 * @param establecimsector
	 *            Pagination
	 * @return EstablecimSector
	 */
	public EstablecimSector add(EstablecimSector establecimsector) {

		String query = "INSERT INTO ESTABLECIM_SECTOR( EACODIGO,EACOES,EACOAV,EACOSE,EAINPRSE)" + "VALUES (?,?,?,?,?)";

		Object getEstablecimientoEscodigoAux = null;
		if (establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = establecimsector.getEstablecimiento().getEscodigo();
		}
		Object getActividadAvcodigoAux = null;
		if (establecimsector.getActividad() != null && establecimsector.getActividad().getAvcodigo() != null) {
			getActividadAvcodigoAux = establecimsector.getActividad().getAvcodigo();
		}
		Object getSectorSecodigoAux = null;
		if (establecimsector.getSector() != null && establecimsector.getSector().getSecodigo() != null) {
			getSectorSecodigoAux = establecimsector.getSector().getSecodigo();
		}
		this.jdbcTemplate.update(query, establecimsector.getEacodigo(), getEstablecimientoEscodigoAux,
				getActividadAvcodigoAux, getSectorSecodigoAux, establecimsector.getEainprse());
		return establecimsector;
	}

	/**
	 * Updates a single row in the EstablecimSector table.
	 * 
	 * @param establecimsector
	 *            Pagination
	 * @return EstablecimSector
	 */
	public EstablecimSector update(EstablecimSector establecimsector) {
		String query = "UPDATE ESTABLECIM_SECTOR SET EACOES=?,EACOAV=?,EACOSE=?,EAINPRSE=? WHERE EACODIGO=?";
		Object getEstablecimientoEscodigoAux = null;
		if (establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = establecimsector.getEstablecimiento().getEscodigo();
		}
		Object getActividadAvcodigoAux = null;
		if (establecimsector.getActividad() != null && establecimsector.getActividad().getAvcodigo() != null) {
			getActividadAvcodigoAux = establecimsector.getActividad().getAvcodigo();
		}
		Object getSectorSecodigoAux = null;
		if (establecimsector.getSector() != null && establecimsector.getSector().getSecodigo() != null) {
			getSectorSecodigoAux = establecimsector.getSector().getSecodigo();
		}
		this.jdbcTemplate.update(query, getEstablecimientoEscodigoAux, getActividadAvcodigoAux, getSectorSecodigoAux,
				establecimsector.getEainprse(), establecimsector.getEacodigo());
		return establecimsector;
	}

	/**
	 * Finds a single row in the EstablecimSector table.
	 * 
	 * @param establecimsector
	 *            Pagination
	 * @return EstablecimSector
	 */
	@Transactional(readOnly = true)
	public EstablecimSector find(EstablecimSector establecimsector) {
		String query = "SELECT t1.EACODIGO EACODIGO, t1.EAINPRSE EAINPRSE, t2.ESCODIGO ESSTOESCODIGO, t2.ESNOMBRE ESSTOESNOMBRE, t2.ESTIPID ESSTOESTIPID, t2.ESNIF ESSTOESNIF, t2.ESNOAN ESSTOESNOAN, t2.ESNOCO ESSTOESNOCO, t2.ESNODIR ESSTOESNODIR, t2.ESCOLO ESSTOESCOLO, t2.ESNRCOPO ESSTOESNRCOPO, t2.ESNRTEL ESSTOESNRTEL, t2.ESNRFAX ESSTOESNRFAX, t2.ESCOPA ESSTOESCOPA, t2.ESINCAPR ESSTOESINCAPR, t2.ESINDEMP ESSTOESINDEMP, t2.ESTECO ESSTOESTECO, t2.ESINADAR ESSTOESINADAR, t2.ESFEADAR ESSTOESFEADAR, t2.ESCOEM ESSTOESCOEM, t2.ESINEMPR ESSTOESINEMPR, t2.ESNRTEL2 ESSTOESNRTEL2, t2.ESFEBA ESSTOESFEBA, t2.ESNOAP1 ESSTOESNOAP1, t2.ESNOAP2 ESSTOESNOAP2, t2.ESNOLO ESSTOESNOLO, t2.ESCOMAPV ESSTOESCOMAPV, t2.ESCOCA ESSTOESCOCA, t2.ESNOPECO ESSTOESNOPECO, t2.ESCOIDCO ESSTOESCOIDCO, t2.ESINRECO ESSTOESINRECO, t2.ESFEMOD ESSTOESFEMOD, t2.ESINESCO ESSTOESINESCO, t2.ESNOMU ESSTOESNOMU, t2.ESNOREP ESSTOESNOREP, t2.ESNIFREP ESSTOESNIFREP, t2.DTTEEMR ESSTODTTEEMR, t2.ESCAREP ESSTOESCAREP, t2.ESTEURL ESSTOESTEURL, t2.ESCOOE ESSTOESCOOE, t2.ESNODECO ESSTOESNODECO, t2.ESINTIAR ESSTOESINTIAR, t2.ESFEPLAD ESSTOESFEPLAD, t2.ESINDEME ESSTOESINDEME, t2.ESNORA_PAIS_ID ESSTOESNORAPAISID, t2.ESNORA_PAIS_NOMBRE ESSTOESNORAPAISNOMBRE, t2.ESNORA_PROVINCIA_ID ESSTOESNORAPROVINCIAID, t2.ESNOMBRE_PROVINCIA ESSTOESNOMBREPROVINCIA, t2.ESNORA_MUNICIPIO_ID ESSTOESNORAMUNICIPIOID, t2.ESNOMBRE_MUNICIPIO ESSTOESNOMBREMUNICIPIO, t2.ESNORA_LOCALIDAD_ID ESSTOESNORALOCALIDADID, t2.ESNOMBRE_LOCALIDAD ESSTOESNOMBRELOCALIDAD, t2.ESNORA_CALLE_ID ESSTOESNORACALLEID, t2.ESNOMBRE_CALLE ESSTOESNOMBRECALLE, t2.ESNORA_CP_ID ESSTOESNORACPID, t2.ESNOMBRE_CP ESSTOESNOMBRECP, t2.ESNORA_PORTAL_ID ESSTOESNORAPORTALID, t2.ESNOMBRE_PORTAL ESSTOESNOMBREPORTAL, t2.ESNOMBRE_PISO ESSTOESNOMBREPISO, t2.ESDIRECCION_NOCAPV ESSTOESDIRECCION_NOCAPV, t2.ESEXTRANJERO ESSTOESEXTRANJERO, t3.AVCODIGO ACTIVIDADAVCODIGO, t3.AVNOMBRE ACTIVIDADAVNOMBRE, t3.AVNOCO ACTIVIDADAVNOCO, t3.AVTEDE ACTIVIDADAVTEDE, t3.AVCOSE ACTIVIDADAVCOSE, t3.AVNOMBREE ACTIVIDADAVNOMBREE, t3.AVNOMBREI ACTIVIDADAVNOMBREI, t3.AVNOMBREF ACTIVIDADAVNOMBREF, t3.AVNOCOE ACTIVIDADAVNOCOE, t3.AVNOCOI ACTIVIDADAVNOCOI, t3.AVNOCOF ACTIVIDADAVNOCOF, t3.AVTEDEE ACTIVIDADAVTEDEE, t3.AVTEDEI ACTIVIDADAVTEDEI, t3.AVTEDEF ACTIVIDADAVTEDEF, t3.AVNOMBREA ACTIVIDADAVNOMBREA, t3.AVNOCOA ACTIVIDADAVNOCOA, t3.AVTEDEA ACTIVIDADAVTEDEA, t4.SECODIGO SECTORSECODIGO, t4.SENOMBRE SECTORSENOMBRE, t4.SENOCO SECTORSENOCO, t4.SEDESCRI SECTORSEDESCRI, t4.SECOSE SECTORSECOSE, t4.SENOCO2 SECTORSENOCO2, t4.SEINSEL1 SECTORSEINSEL1, t4.SENOMBREE SECTORSENOMBREE, t4.SENOMBREI SECTORSENOMBREI, t4.SENOMBREF SECTORSENOMBREF, t4.SENOCOE SECTORSENOCOE, t4.SENOCOI SECTORSENOCOI, t4.SENOCOF SECTORSENOCOF, t4.SEDESCRIE SECTORSEDESCRIE, t4.SEDESCRII SECTORSEDESCRII, t4.SEDESCRIF SECTORSEDESCRIF, t4.SECODGRUPO SECTORSECODGRUPO, t4.SENOMBREA SECTORSENOMBREA, t4.SEDESCRIA SECTORSEDESCRIA, t4.SENOCOA SECTORSENOCOA, t2.ESCOZS ESSTOESCOZS, t4.SECOL0 SECTORSECOL0 "
				+ "FROM ESTABLECIM_SECTOR t1 , ESTABLECIMIENTO t2 , ACTIVIDAD t3 , SECTOR t4  "
				+ "WHERE t1.EACODIGO = ?   AND t1.EACOES= t2.ESCODIGO(+) AND t1.EACOAV= t3.AVCODIGO(+) AND t1.EACOSE= t4.SECODIGO(+)  ";
		return (EstablecimSector) this.jdbcTemplate.queryForObject(query, rwMap, establecimsector.getEacodigo());
	}

	/**
	 * Finds a single row in the EstablecimSector table.
	 * 
	 * @param establecimsector
	 *            Pagination
	 * @return EstablecimSector
	 */
	@Transactional(readOnly = true)
	public EstablecimSector findSectorEstablecimiento(EstablecimSector establecimsector) {
		try {
			String query = "SELECT t1.EACODIGO EACODIGO, t1.EAINPRSE EAINPRSE, t2.ESCODIGO ESSTOESCODIGO, t2.ESNOMBRE ESSTOESNOMBRE, t2.ESTIPID ESSTOESTIPID, t2.ESNIF ESSTOESNIF, t2.ESNOAN ESSTOESNOAN, t2.ESNOCO ESSTOESNOCO, t2.ESNODIR ESSTOESNODIR, t2.ESCOLO ESSTOESCOLO, t2.ESNRCOPO ESSTOESNRCOPO, t2.ESNRTEL ESSTOESNRTEL, t2.ESNRFAX ESSTOESNRFAX, t2.ESCOPA ESSTOESCOPA, t2.ESINCAPR ESSTOESINCAPR, t2.ESINDEMP ESSTOESINDEMP, t2.ESTECO ESSTOESTECO, t2.ESINADAR ESSTOESINADAR, t2.ESFEADAR ESSTOESFEADAR, t2.ESCOEM ESSTOESCOEM, t2.ESINEMPR ESSTOESINEMPR, t2.ESNRTEL2 ESSTOESNRTEL2, t2.ESFEBA ESSTOESFEBA, t2.ESNOAP1 ESSTOESNOAP1, t2.ESNOAP2 ESSTOESNOAP2, t2.ESNOLO ESSTOESNOLO, t2.ESCOMAPV ESSTOESCOMAPV, t2.ESCOCA ESSTOESCOCA, t2.ESNOPECO ESSTOESNOPECO, t2.ESCOIDCO ESSTOESCOIDCO, t2.ESINRECO ESSTOESINRECO, t2.ESFEMOD ESSTOESFEMOD, t2.ESINESCO ESSTOESINESCO, t2.ESNOMU ESSTOESNOMU, t2.ESNOREP ESSTOESNOREP, t2.ESNIFREP ESSTOESNIFREP, t2.DTTEEMR ESSTODTTEEMR, t2.ESCAREP ESSTOESCAREP, t2.ESTEURL ESSTOESTEURL, t2.ESCOOE ESSTOESCOOE, t2.ESNODECO ESSTOESNODECO, t2.ESINTIAR ESSTOESINTIAR, t2.ESFEPLAD ESSTOESFEPLAD, t2.ESINDEME ESSTOESINDEME, t2.ESNORA_PAIS_ID ESSTOESNORAPAISID, t2.ESNORA_PAIS_NOMBRE ESSTOESNORAPAISNOMBRE, t2.ESNORA_PROVINCIA_ID ESSTOESNORAPROVINCIAID, t2.ESNOMBRE_PROVINCIA ESSTOESNOMBREPROVINCIA, t2.ESNORA_MUNICIPIO_ID ESSTOESNORAMUNICIPIOID, t2.ESNOMBRE_MUNICIPIO ESSTOESNOMBREMUNICIPIO, t2.ESNORA_LOCALIDAD_ID ESSTOESNORALOCALIDADID, t2.ESNOMBRE_LOCALIDAD ESSTOESNOMBRELOCALIDAD, t2.ESNORA_CALLE_ID ESSTOESNORACALLEID, t2.ESNOMBRE_CALLE ESSTOESNOMBRECALLE, t2.ESNORA_CP_ID ESSTOESNORACPID, t2.ESNOMBRE_CP ESSTOESNOMBRECP, t2.ESNORA_PORTAL_ID ESSTOESNORAPORTALID, t2.ESNOMBRE_PORTAL ESSTOESNOMBREPORTAL, t2.ESNOMBRE_PISO ESSTOESNOMBREPISO, t2.ESDIRECCION_NOCAPV ESSTOESDIRECCION_NOCAPV, t2.ESEXTRANJERO ESSTOESEXTRANJERO, t3.AVCODIGO ACTIVIDADAVCODIGO, t3.AVNOMBRE ACTIVIDADAVNOMBRE, t3.AVNOCO ACTIVIDADAVNOCO, t3.AVTEDE ACTIVIDADAVTEDE, t3.AVCOSE ACTIVIDADAVCOSE, t3.AVNOMBREE ACTIVIDADAVNOMBREE, t3.AVNOMBREI ACTIVIDADAVNOMBREI, t3.AVNOMBREF ACTIVIDADAVNOMBREF, t3.AVNOCOE ACTIVIDADAVNOCOE, t3.AVNOCOI ACTIVIDADAVNOCOI, t3.AVNOCOF ACTIVIDADAVNOCOF, t3.AVTEDEE ACTIVIDADAVTEDEE, t3.AVTEDEI ACTIVIDADAVTEDEI, t3.AVTEDEF ACTIVIDADAVTEDEF, t3.AVNOMBREA ACTIVIDADAVNOMBREA, t3.AVNOCOA ACTIVIDADAVNOCOA, t3.AVTEDEA ACTIVIDADAVTEDEA, t4.SECODIGO SECTORSECODIGO, t4.SENOMBRE SECTORSENOMBRE, t4.SENOCO SECTORSENOCO, t4.SEDESCRI SECTORSEDESCRI, t4.SECOSE SECTORSECOSE, t4.SENOCO2 SECTORSENOCO2, t4.SEINSEL1 SECTORSEINSEL1, t4.SENOMBREE SECTORSENOMBREE, t4.SENOMBREI SECTORSENOMBREI, t4.SENOMBREF SECTORSENOMBREF, t4.SENOCOE SECTORSENOCOE, t4.SENOCOI SECTORSENOCOI, t4.SENOCOF SECTORSENOCOF, t4.SEDESCRIE SECTORSEDESCRIE, t4.SEDESCRII SECTORSEDESCRII, t4.SEDESCRIF SECTORSEDESCRIF, t4.SECODGRUPO SECTORSECODGRUPO, t4.SENOMBREA SECTORSENOMBREA, t4.SEDESCRIA SECTORSEDESCRIA, t4.SENOCOA SECTORSENOCOA, t2.ESCOZS ESSTOESCOZS, t4.SECOL0 SECTORSECOL0 "
					+ "FROM ESTABLECIM_SECTOR t1 , ESTABLECIMIENTO t2 , ACTIVIDAD t3 , SECTOR t4  "
					+ "WHERE t2.ESCODIGO = ?   AND t1.EACOES= t2.ESCODIGO(+) AND t1.EACOAV= t3.AVCODIGO(+) AND t1.EACOSE= t4.SECODIGO(+) AND t1.EAINPRSE = ? AND ROWNUM = 1 ";
			return (EstablecimSector) this.jdbcTemplate.queryForObject(query, rwMap,
					establecimsector.getEstablecimiento().getEscodigo(),
					Y41bConstantes.SECTOR_ESTABLECIMIENTO_PRIMARIO);
		} catch (EmptyResultDataAccessException e) {
			establecimsector = new EstablecimSector();
			Actividad actividad = new Actividad();
			Sector sector = new Sector();
			sector.setSecodigo("");
			sector.setSenombre("");
			sector.setSenombree("");
			establecimsector.setActividad(actividad);
			establecimsector.setSector(sector);

			return establecimsector;
		}
	}

	/**
	 * Removes a single row in the EstablecimSector table.
	 * 
	 * @param establecimsector
	 *            Pagination
	 * @return
	 */
	public void remove(EstablecimSector establecimsector) {
		String query = "DELETE  FROM ESTABLECIM_SECTOR WHERE EACODIGO=?";
		this.jdbcTemplate.update(query, establecimsector.getEacodigo());
	}

	/**
	 * Removes a single row in the EstablecimSector table.
	 * 
	 * @param establecimsector
	 *            Pagination
	 * @return
	 */
	public void removeSectorEstablecimiento(EstablecimSector establecimsector) {
		String query = "DELETE  FROM ESTABLECIM_SECTOR WHERE EACOES=?";
		this.jdbcTemplate.update(query, establecimsector.getEstablecimiento().getEscodigo());
	}

	/**
	 * Finds a List of rows in the EstablecimSector table.
	 * 
	 * @param establecimsector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	// CHECKSTYLE:OFF
	@Transactional(readOnly = true)
	public List<EstablecimSector> findAll(EstablecimSector establecimsector, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.EACOES= t2.ESCODIGO(+) AND t1.EACOAV= t3.AVCODIGO(+) AND t1.EACOSE= t4.SECODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.EACODIGO EACODIGO,t1.EAINPRSE EAINPRSE,t2.ESCODIGO ESSTOESCODIGO,t2.ESNOMBRE ESSTOESNOMBRE, t2.ESTIPID ESSTOESTIPID,t2.ESNIF ESSTOESNIF,t2.ESNOAN ESSTOESNOAN,t2.ESNOCO ESSTOESNOCO,t2.ESNODIR ESSTOESNODIR,t2.ESCOLO ESSTOESCOLO,t2.ESNRCOPO ESSTOESNRCOPO,t2.ESNRTEL ESSTOESNRTEL,t2.ESNRFAX ESSTOESNRFAX,t2.ESCOPA ESSTOESCOPA,t2.ESINCAPR ESSTOESINCAPR,t2.ESINDEMP ESSTOESINDEMP,t2.ESTECO ESSTOESTECO,t2.ESINADAR ESSTOESINADAR,t2.ESFEADAR ESSTOESFEADAR,t2.ESCOEM ESSTOESCOEM,t2.ESINEMPR ESSTOESINEMPR,t2.ESNRTEL2 ESSTOESNRTEL2,t2.ESFEBA ESSTOESFEBA,t2.ESNOAP1 ESSTOESNOAP1,t2.ESNOAP2 ESSTOESNOAP2,t2.ESNOLO ESSTOESNOLO,t2.ESCOMAPV ESSTOESCOMAPV,t2.ESCOCA ESSTOESCOCA,t2.ESNOPECO ESSTOESNOPECO,t2.ESCOIDCO ESSTOESCOIDCO,t2.ESINRECO ESSTOESINRECO,t2.ESFEMOD ESSTOESFEMOD,t2.ESINESCO ESSTOESINESCO,t2.ESNOMU ESSTOESNOMU,t2.ESNOREP ESSTOESNOREP,t2.ESNIFREP ESSTOESNIFREP,t2.DTTEEMR ESSTODTTEEMR,t2.ESCAREP ESSTOESCAREP,t2.ESTEURL ESSTOESTEURL,t2.ESCOOE ESSTOESCOOE,t2.ESNODECO ESSTOESNODECO,t2.ESINTIAR ESSTOESINTIAR,t2.ESFEPLAD ESSTOESFEPLAD,t2.ESINDEME ESSTOESINDEME,t2.ESNORA_PAIS_ID ESSTOESNORAPAISID,t2.ESNORA_PAIS_NOMBRE ESSTOESNORAPAISNOMBRE,t2.ESNORA_PROVINCIA_ID ESSTOESNORAPROVINCIAID,t2.ESNOMBRE_PROVINCIA ESSTOESNOMBREPROVINCIA,t2.ESNORA_MUNICIPIO_ID ESSTOESNORAMUNICIPIOID,t2.ESNOMBRE_MUNICIPIO ESSTOESNOMBREMUNICIPIO,t2.ESNORA_LOCALIDAD_ID ESSTOESNORALOCALIDADID,t2.ESNOMBRE_LOCALIDAD ESSTOESNOMBRELOCALIDAD,t2.ESNORA_CALLE_ID ESSTOESNORACALLEID,t2.ESNOMBRE_CALLE ESSTOESNOMBRECALLE,t2.ESNORA_CP_ID ESSTOESNORACPID,t2.ESNOMBRE_CP ESSTOESNOMBRECP,t2.ESNORA_PORTAL_ID ESSTOESNORAPORTALID,t2.ESNOMBRE_PORTAL ESSTOESNOMBREPORTAL, t2.ESNOMBRE_PISO EstablecimientoESNOMBREPISO, t2.ESDIRECCION_NOCAPV ESSTOESDIRECCION_NOCAPV, t2.ESEXTRANJERO ESSTOESEXTRANJERO, t3.AVCODIGO ACTIVIDADAVCODIGO,t3.AVNOMBRE ACTIVIDADAVNOMBRE,t3.AVNOCO ACTIVIDADAVNOCO,t3.AVTEDE ACTIVIDADAVTEDE,t3.AVCOSE ACTIVIDADAVCOSE,t3.AVNOMBREE ACTIVIDADAVNOMBREE,t3.AVNOMBREI ACTIVIDADAVNOMBREI,t3.AVNOMBREF ACTIVIDADAVNOMBREF,t3.AVNOCOE ACTIVIDADAVNOCOE,t3.AVNOCOI ACTIVIDADAVNOCOI,t3.AVNOCOF ACTIVIDADAVNOCOF,t3.AVTEDEE ACTIVIDADAVTEDEE,t3.AVTEDEI ACTIVIDADAVTEDEI,t3.AVTEDEF ACTIVIDADAVTEDEF,t3.AVNOMBREA ACTIVIDADAVNOMBREA,t3.AVNOCOA ACTIVIDADAVNOCOA,t3.AVTEDEA ACTIVIDADAVTEDEA,t4.SECODIGO SECTORSECODIGO,t4.SENOMBRE SECTORSENOMBRE,t4.SENOCO SECTORSENOCO,t4.SEDESCRI SECTORSEDESCRI,t4.SECOSE SECTORSECOSE,t4.SENOCO2 SECTORSENOCO2,t4.SEINSEL1 SECTORSEINSEL1,t4.SENOMBREE SECTORSENOMBREE,t4.SENOMBREI SECTORSENOMBREI,t4.SENOMBREF SECTORSENOMBREF,t4.SENOCOE SECTORSENOCOE,t4.SENOCOI SECTORSENOCOI,t4.SENOCOF SECTORSENOCOF,t4.SEDESCRIE SECTORSEDESCRIE,t4.SEDESCRII SECTORSEDESCRII,t4.SEDESCRIF SECTORSEDESCRIF,t4.SECODGRUPO SECTORSECODGRUPO,t4.SENOMBREA SECTORSENOMBREA,t4.SEDESCRIA SECTORSEDESCRIA,t4.SENOCOA SECTORSENOCOA,t2.ESCOZS ESSTOESCOZS,t4.SECOL0 SECTORSECOL0 "
						+ "FROM ESTABLECIM_SECTOR t1 ,ESTABLECIMIENTO t2 ,ACTIVIDAD t3 ,SECTOR t4 ");

		if (establecimsector != null && establecimsector.getEacodigo() != null) {
			where.append(" AND t1.EACODIGO = ?");
			params.add(establecimsector.getEacodigo());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t2.ESCODIGO = ?");
			params.add(establecimsector.getEstablecimiento().getEscodigo());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getCensoMonitor() != null
				&& establecimsector.getEstablecimiento().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.ESCOZS = ?");
			params.add(establecimsector.getEstablecimiento().getCensoMonitor().getMocodigo());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND t2.ESNOMBRE = ?");
			params.add(establecimsector.getEstablecimiento().getEsnombre());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnif() != null) {
			where.append(" AND t2.ESNIF = ?");
			params.add(establecimsector.getEstablecimiento().getEsnif());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND t2.ESNOAN = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoan());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND t2.ESNOCO = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoco());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND t2.ESNODIR = ?");
			params.add(establecimsector.getEstablecimiento().getEsnodir());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscolo() != null) {
			where.append(" AND t2.ESCOLO = ?");
			params.add(establecimsector.getEstablecimiento().getEscolo());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND t2.ESNRCOPO = ?");
			params.add(establecimsector.getEstablecimiento().getEsnrcopo());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND t2.ESNRTEL = ?");
			params.add(establecimsector.getEstablecimiento().getEsnrtel());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND t2.ESNRFAX = ?");
			params.add(establecimsector.getEstablecimiento().getEsnrfax());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscopa() != null) {
			where.append(" AND t2.ESCOPA = ?");
			params.add(establecimsector.getEstablecimiento().getEscopa());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND t2.ESINCAPR = ?");
			params.add(establecimsector.getEstablecimiento().getEsincapr());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND t2.ESINDEMP = ?");
			params.add(establecimsector.getEstablecimiento().getEsindemp());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsteco() != null) {
			where.append(" AND t2.ESTECO = ?");
			params.add(establecimsector.getEstablecimiento().getEsteco());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND t2.ESINADAR = ?");
			params.add(establecimsector.getEstablecimiento().getEsinadar());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t2.ESFEADAR = ?");
			params.add(establecimsector.getEstablecimiento().getEsfeadar());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscoem() != null) {
			where.append(" AND t2.ESCOEM = ?");
			params.add(establecimsector.getEstablecimiento().getEscoem());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND t2.ESINEMPR = ?");
			params.add(establecimsector.getEstablecimiento().getEsinempr());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND t2.ESNRTEL2 = ?");
			params.add(establecimsector.getEstablecimiento().getEsnrtel2());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t2.ESFEBA = ?");
			params.add(establecimsector.getEstablecimiento().getEsfeba());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND t2.ESNOAP1 = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoap1());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND t2.ESNOAP2 = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoap2());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND t2.ESNOLO = ?");
			params.add(establecimsector.getEstablecimiento().getEsnolo());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND t2.ESCOMAPV = ?");
			params.add(establecimsector.getEstablecimiento().getEscomapv());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscoca() != null) {
			where.append(" AND t2.ESCOCA = ?");
			params.add(establecimsector.getEstablecimiento().getEscoca());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND t2.ESNOPECO = ?");
			params.add(establecimsector.getEstablecimiento().getEsnopeco());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND t2.ESCOIDCO = ?");
			params.add(establecimsector.getEstablecimiento().getEscoidco());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND t2.ESINRECO = ?");
			params.add(establecimsector.getEstablecimiento().getEsinreco());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND t2.ESFEMOD = ?");
			params.add(establecimsector.getEstablecimiento().getEsfemod());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND t2.ESINESCO = ?");
			params.add(establecimsector.getEstablecimiento().getEsinesco());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND t2.ESNOMU = ?");
			params.add(establecimsector.getEstablecimiento().getEsnomu());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND t2.ESNOREP = ?");
			params.add(establecimsector.getEstablecimiento().getEsnorep());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND t2.ESNIFREP = ?");
			params.add(establecimsector.getEstablecimiento().getEsnifrep());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND t2.DTTEEMR = ?");
			params.add(establecimsector.getEstablecimiento().getDtteemr());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscarep() != null) {
			where.append(" AND t2.ESCAREP = ?");
			params.add(establecimsector.getEstablecimiento().getEscarep());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND t2.ESTEURL = ?");
			params.add(establecimsector.getEstablecimiento().getEsteurl());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscooe() != null) {
			where.append(" AND t2.ESCOOE = ?");
			params.add(establecimsector.getEstablecimiento().getEscooe());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND t2.ESNODECO = ?");
			params.add(establecimsector.getEstablecimiento().getEsnodeco());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND t2.ESINTIAR = ?");
			params.add(establecimsector.getEstablecimiento().getEsintiar());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t2.ESFEPLAD = ?");
			params.add(establecimsector.getEstablecimiento().getEsfeplad());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND t2.ESINDEME = ?");
			params.add(establecimsector.getEstablecimiento().getEsindeme());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND t2.ESNORA_PAIS_ID = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraPaisId());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND t2.ESNORA_PAIS_NOMBRE = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraPaisNombre());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND t2.ESNORA_PROVINCIA_ID = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraProvinciaId());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND t2.ESNOMBRE_PROVINCIA = ?");
			params.add(establecimsector.getEstablecimiento().getEsnombreProvincia());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND t2.ESNORA_MUNICIPIO_ID = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraMunicipioId());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND t2.ESNOMBRE_MUNICIPIO = ?");
			params.add(establecimsector.getEstablecimiento().getEsnombreMunicipio());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND t2.ESNORA_LOCALIDAD_ID = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraLocalidadId());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND t2.ESNOMBRE_LOCALIDAD = ?");
			params.add(establecimsector.getEstablecimiento().getEsnombreLocalidad());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND t2.ESNORA_CALLE_ID = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraCalleId());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND t2.ESNOMBRE_CALLE = ?");
			params.add(establecimsector.getEstablecimiento().getEsnombreCalle());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND t2.ESNORA_CP_ID = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraCpId());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND t2.ESNOMBRE_CP = ?");
			params.add(establecimsector.getEstablecimiento().getEsnombreCp());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND t2.ESNORA_PORTAL_ID = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraPortalId());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND t2.ESNOMBRE_PORTAL = ?");
			params.add(establecimsector.getEstablecimiento().getEsnombrePortal());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvcodigo() != null) {
			where.append(" AND t3.AVCODIGO = ?");
			params.add(establecimsector.getActividad().getAvcodigo());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombre() != null) {
			where.append(" AND t3.AVNOMBRE = ?");
			params.add(establecimsector.getActividad().getAvnombre());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnoco() != null) {
			where.append(" AND t3.AVNOCO = ?");
			params.add(establecimsector.getActividad().getAvnoco());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtede() != null) {
			where.append(" AND t3.AVTEDE = ?");
			params.add(establecimsector.getActividad().getAvtede());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvcose() != null) {
			where.append(" AND t3.AVCOSE = ?");
			params.add(establecimsector.getActividad().getAvcose());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombree() != null) {
			where.append(" AND t3.AVNOMBREE = ?");
			params.add(establecimsector.getActividad().getAvnombree());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombrei() != null) {
			where.append(" AND t3.AVNOMBREI = ?");
			params.add(establecimsector.getActividad().getAvnombrei());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombref() != null) {
			where.append(" AND t3.AVNOMBREF = ?");
			params.add(establecimsector.getActividad().getAvnombref());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnocoe() != null) {
			where.append(" AND t3.AVNOCOE = ?");
			params.add(establecimsector.getActividad().getAvnocoe());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnocoi() != null) {
			where.append(" AND t3.AVNOCOI = ?");
			params.add(establecimsector.getActividad().getAvnocoi());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnocof() != null) {
			where.append(" AND t3.AVNOCOF = ?");
			params.add(establecimsector.getActividad().getAvnocof());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtedee() != null) {
			where.append(" AND t3.AVTEDEE = ?");
			params.add(establecimsector.getActividad().getAvtedee());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtedei() != null) {
			where.append(" AND t3.AVTEDEI = ?");
			params.add(establecimsector.getActividad().getAvtedei());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtedef() != null) {
			where.append(" AND t3.AVTEDEF = ?");
			params.add(establecimsector.getActividad().getAvtedef());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombrea() != null) {
			where.append(" AND t3.AVNOMBREA = ?");
			params.add(establecimsector.getActividad().getAvnombrea());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnocoa() != null) {
			where.append(" AND t3.AVNOCOA = ?");
			params.add(establecimsector.getActividad().getAvnocoa());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtedea() != null) {
			where.append(" AND t3.AVTEDEA = ?");
			params.add(establecimsector.getActividad().getAvtedea());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSecodigo() != null) {
			where.append(" AND t4.SECODIGO = ?");
			params.add(establecimsector.getSector().getSecodigo());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSectorAgrupado() != null
				&& establecimsector.getSector().getSectorAgrupado().getL0codigo() != null) {
			where.append(" AND t4.SECOL0 = ?");
			params.add(establecimsector.getSector().getSectorAgrupado().getL0codigo());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombre() != null) {
			where.append(" AND t4.SENOMBRE = ?");
			params.add(establecimsector.getSector().getSenombre());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenoco() != null) {
			where.append(" AND t4.SENOCO = ?");
			params.add(establecimsector.getSector().getSenoco());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescri() != null) {
			where.append(" AND t4.SEDESCRI = ?");
			params.add(establecimsector.getSector().getSedescri());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSecose() != null) {
			where.append(" AND t4.SECOSE = ?");
			params.add(establecimsector.getSector().getSecose());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenoco2() != null) {
			where.append(" AND t4.SENOCO2 = ?");
			params.add(establecimsector.getSector().getSenoco2());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSeinsel1() != null) {
			where.append(" AND t4.SEINSEL1 = ?");
			params.add(establecimsector.getSector().getSeinsel1());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombree() != null) {
			where.append(" AND t4.SENOMBREE = ?");
			params.add(establecimsector.getSector().getSenombree());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombrei() != null) {
			where.append(" AND t4.SENOMBREI = ?");
			params.add(establecimsector.getSector().getSenombrei());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombref() != null) {
			where.append(" AND t4.SENOMBREF = ?");
			params.add(establecimsector.getSector().getSenombref());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenocoe() != null) {
			where.append(" AND t4.SENOCOE = ?");
			params.add(establecimsector.getSector().getSenocoe());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenocoi() != null) {
			where.append(" AND t4.SENOCOI = ?");
			params.add(establecimsector.getSector().getSenocoi());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenocof() != null) {
			where.append(" AND t4.SENOCOF = ?");
			params.add(establecimsector.getSector().getSenocof());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescrie() != null) {
			where.append(" AND t4.SEDESCRIE = ?");
			params.add(establecimsector.getSector().getSedescrie());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescrii() != null) {
			where.append(" AND t4.SEDESCRII = ?");
			params.add(establecimsector.getSector().getSedescrii());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescrif() != null) {
			where.append(" AND t4.SEDESCRIF = ?");
			params.add(establecimsector.getSector().getSedescrif());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSecodgrupo() != null) {
			where.append(" AND t4.SECODGRUPO = ?");
			params.add(establecimsector.getSector().getSecodgrupo());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombrea() != null) {
			where.append(" AND t4.SENOMBREA = ?");
			params.add(establecimsector.getSector().getSenombrea());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescria() != null) {
			where.append(" AND t4.SEDESCRIA = ?");
			params.add(establecimsector.getSector().getSedescria());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenocoa() != null) {
			where.append(" AND t4.SENOCOA = ?");
			params.add(establecimsector.getSector().getSenocoa());
		}
		if (establecimsector != null && establecimsector.getEainprse() != null) {
			where.append(" AND t1.EAINPRSE = ?");
			params.add(establecimsector.getEainprse());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<EstablecimSector>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the EstablecimSector table.
	 * 
	 * @param establecimsector
	 *            EstablecimSector
	 * @return Long
	 */
	// CHECKSTYLE:OFF
	@Transactional(readOnly = true)
	public Long findAllCount(EstablecimSector establecimsector) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1  and t1.EACOES= t2.ESCODIGO(+) and t1.EACOAV= t3.AVCODIGO(+) and t1.EACOSE= t4.SECODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ESTABLECIM_SECTOR t1   ,  ESTABLECIMIENTO t2   ,  ACTIVIDAD t3   ,  SECTOR t4  ");
		if (establecimsector != null && establecimsector.getEacodigo() != null) {
			where.append(" AND t1.EACODIGO = ?");
			params.add(establecimsector.getEacodigo());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t2.ESCODIGO = ?");
			params.add(establecimsector.getEstablecimiento().getEscodigo());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getCensoMonitor() != null
				&& establecimsector.getEstablecimiento().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.ESCOZS = ?");
			params.add(establecimsector.getEstablecimiento().getCensoMonitor().getMocodigo());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND t2.ESNOMBRE = ?");
			params.add(establecimsector.getEstablecimiento().getEsnombre());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnif() != null) {
			where.append(" AND t2.ESNIF = ?");
			params.add(establecimsector.getEstablecimiento().getEsnif());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND t2.ESNOAN = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoan());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND t2.ESNOCO = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoco());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND t2.ESNODIR = ?");
			params.add(establecimsector.getEstablecimiento().getEsnodir());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscolo() != null) {
			where.append(" AND t2.ESCOLO = ?");
			params.add(establecimsector.getEstablecimiento().getEscolo());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND t2.ESNRCOPO = ?");
			params.add(establecimsector.getEstablecimiento().getEsnrcopo());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND t2.ESNRTEL = ?");
			params.add(establecimsector.getEstablecimiento().getEsnrtel());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND t2.ESNRFAX = ?");
			params.add(establecimsector.getEstablecimiento().getEsnrfax());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscopa() != null) {
			where.append(" AND t2.ESCOPA = ?");
			params.add(establecimsector.getEstablecimiento().getEscopa());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND t2.ESINCAPR = ?");
			params.add(establecimsector.getEstablecimiento().getEsincapr());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND t2.ESINDEMP = ?");
			params.add(establecimsector.getEstablecimiento().getEsindemp());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsteco() != null) {
			where.append(" AND t2.ESTECO = ?");
			params.add(establecimsector.getEstablecimiento().getEsteco());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND t2.ESINADAR = ?");
			params.add(establecimsector.getEstablecimiento().getEsinadar());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t2.ESFEADAR = ?");
			params.add(establecimsector.getEstablecimiento().getEsfeadar());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscoem() != null) {
			where.append(" AND t2.ESCOEM = ?");
			params.add(establecimsector.getEstablecimiento().getEscoem());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND t2.ESINEMPR = ?");
			params.add(establecimsector.getEstablecimiento().getEsinempr());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND t2.ESNRTEL2 = ?");
			params.add(establecimsector.getEstablecimiento().getEsnrtel2());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t2.ESFEBA = ?");
			params.add(establecimsector.getEstablecimiento().getEsfeba());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND t2.ESNOAP1 = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoap1());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND t2.ESNOAP2 = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoap2());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND t2.ESNOLO = ?");
			params.add(establecimsector.getEstablecimiento().getEsnolo());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND t2.ESCOMAPV = ?");
			params.add(establecimsector.getEstablecimiento().getEscomapv());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscoca() != null) {
			where.append(" AND t2.ESCOCA = ?");
			params.add(establecimsector.getEstablecimiento().getEscoca());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND t2.ESNOPECO = ?");
			params.add(establecimsector.getEstablecimiento().getEsnopeco());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND t2.ESCOIDCO = ?");
			params.add(establecimsector.getEstablecimiento().getEscoidco());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND t2.ESINRECO = ?");
			params.add(establecimsector.getEstablecimiento().getEsinreco());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND t2.ESFEMOD = ?");
			params.add(establecimsector.getEstablecimiento().getEsfemod());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND t2.ESINESCO = ?");
			params.add(establecimsector.getEstablecimiento().getEsinesco());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND t2.ESNOMU = ?");
			params.add(establecimsector.getEstablecimiento().getEsnomu());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND t2.ESNOREP = ?");
			params.add(establecimsector.getEstablecimiento().getEsnorep());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND t2.ESNIFREP = ?");
			params.add(establecimsector.getEstablecimiento().getEsnifrep());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND t2.DTTEEMR = ?");
			params.add(establecimsector.getEstablecimiento().getDtteemr());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscarep() != null) {
			where.append(" AND t2.ESCAREP = ?");
			params.add(establecimsector.getEstablecimiento().getEscarep());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND t2.ESTEURL = ?");
			params.add(establecimsector.getEstablecimiento().getEsteurl());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscooe() != null) {
			where.append(" AND t2.ESCOOE = ?");
			params.add(establecimsector.getEstablecimiento().getEscooe());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND t2.ESNODECO = ?");
			params.add(establecimsector.getEstablecimiento().getEsnodeco());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND t2.ESINTIAR = ?");
			params.add(establecimsector.getEstablecimiento().getEsintiar());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t2.ESFEPLAD = ?");
			params.add(establecimsector.getEstablecimiento().getEsfeplad());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND t2.ESINDEME = ?");
			params.add(establecimsector.getEstablecimiento().getEsindeme());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND t2.ESNORA_PAIS_ID = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraPaisId());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND t2.ESNORA_PAIS_NOMBRE = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraPaisNombre());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND t2.ESNORA_PROVINCIA_ID = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraProvinciaId());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND t2.ESNOMBRE_PROVINCIA = ?");
			params.add(establecimsector.getEstablecimiento().getEsnombreProvincia());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND t2.ESNORA_MUNICIPIO_ID = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraMunicipioId());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND t2.ESNOMBRE_MUNICIPIO = ?");
			params.add(establecimsector.getEstablecimiento().getEsnombreMunicipio());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND t2.ESNORA_LOCALIDAD_ID = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraLocalidadId());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND t2.ESNOMBRE_LOCALIDAD = ?");
			params.add(establecimsector.getEstablecimiento().getEsnombreLocalidad());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND t2.ESNORA_CALLE_ID = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraCalleId());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND t2.ESNOMBRE_CALLE = ?");
			params.add(establecimsector.getEstablecimiento().getEsnombreCalle());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND t2.ESNORA_CP_ID = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraCpId());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND t2.ESNOMBRE_CP = ?");
			params.add(establecimsector.getEstablecimiento().getEsnombreCp());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND t2.ESNORA_PORTAL_ID = ?");
			params.add(establecimsector.getEstablecimiento().getEsnoraPortalId());
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND t2.ESNOMBRE_PORTAL = ?");
			params.add(establecimsector.getEstablecimiento().getEsnombrePortal());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvcodigo() != null) {
			where.append(" AND t3.AVCODIGO = ?");
			params.add(establecimsector.getActividad().getAvcodigo());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombre() != null) {
			where.append(" AND t3.AVNOMBRE = ?");
			params.add(establecimsector.getActividad().getAvnombre());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnoco() != null) {
			where.append(" AND t3.AVNOCO = ?");
			params.add(establecimsector.getActividad().getAvnoco());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtede() != null) {
			where.append(" AND t3.AVTEDE = ?");
			params.add(establecimsector.getActividad().getAvtede());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvcose() != null) {
			where.append(" AND t3.AVCOSE = ?");
			params.add(establecimsector.getActividad().getAvcose());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombree() != null) {
			where.append(" AND t3.AVNOMBREE = ?");
			params.add(establecimsector.getActividad().getAvnombree());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombrei() != null) {
			where.append(" AND t3.AVNOMBREI = ?");
			params.add(establecimsector.getActividad().getAvnombrei());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombref() != null) {
			where.append(" AND t3.AVNOMBREF = ?");
			params.add(establecimsector.getActividad().getAvnombref());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnocoe() != null) {
			where.append(" AND t3.AVNOCOE = ?");
			params.add(establecimsector.getActividad().getAvnocoe());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnocoi() != null) {
			where.append(" AND t3.AVNOCOI = ?");
			params.add(establecimsector.getActividad().getAvnocoi());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnocof() != null) {
			where.append(" AND t3.AVNOCOF = ?");
			params.add(establecimsector.getActividad().getAvnocof());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtedee() != null) {
			where.append(" AND t3.AVTEDEE = ?");
			params.add(establecimsector.getActividad().getAvtedee());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtedei() != null) {
			where.append(" AND t3.AVTEDEI = ?");
			params.add(establecimsector.getActividad().getAvtedei());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtedef() != null) {
			where.append(" AND t3.AVTEDEF = ?");
			params.add(establecimsector.getActividad().getAvtedef());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombrea() != null) {
			where.append(" AND t3.AVNOMBREA = ?");
			params.add(establecimsector.getActividad().getAvnombrea());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnocoa() != null) {
			where.append(" AND t3.AVNOCOA = ?");
			params.add(establecimsector.getActividad().getAvnocoa());
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtedea() != null) {
			where.append(" AND t3.AVTEDEA = ?");
			params.add(establecimsector.getActividad().getAvtedea());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSecodigo() != null) {
			where.append(" AND t4.SECODIGO = ?");
			params.add(establecimsector.getSector().getSecodigo());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSectorAgrupado() != null
				&& establecimsector.getSector().getSectorAgrupado().getL0codigo() != null) {
			where.append(" AND t4.SECOL0 = ?");
			params.add(establecimsector.getSector().getSectorAgrupado().getL0codigo());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombre() != null) {
			where.append(" AND t4.SENOMBRE = ?");
			params.add(establecimsector.getSector().getSenombre());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenoco() != null) {
			where.append(" AND t4.SENOCO = ?");
			params.add(establecimsector.getSector().getSenoco());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescri() != null) {
			where.append(" AND t4.SEDESCRI = ?");
			params.add(establecimsector.getSector().getSedescri());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSecose() != null) {
			where.append(" AND t4.SECOSE = ?");
			params.add(establecimsector.getSector().getSecose());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenoco2() != null) {
			where.append(" AND t4.SENOCO2 = ?");
			params.add(establecimsector.getSector().getSenoco2());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSeinsel1() != null) {
			where.append(" AND t4.SEINSEL1 = ?");
			params.add(establecimsector.getSector().getSeinsel1());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombree() != null) {
			where.append(" AND t4.SENOMBREE = ?");
			params.add(establecimsector.getSector().getSenombree());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombrei() != null) {
			where.append(" AND t4.SENOMBREI = ?");
			params.add(establecimsector.getSector().getSenombrei());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombref() != null) {
			where.append(" AND t4.SENOMBREF = ?");
			params.add(establecimsector.getSector().getSenombref());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenocoe() != null) {
			where.append(" AND t4.SENOCOE = ?");
			params.add(establecimsector.getSector().getSenocoe());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenocoi() != null) {
			where.append(" AND t4.SENOCOI = ?");
			params.add(establecimsector.getSector().getSenocoi());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenocof() != null) {
			where.append(" AND t4.SENOCOF = ?");
			params.add(establecimsector.getSector().getSenocof());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescrie() != null) {
			where.append(" AND t4.SEDESCRIE = ?");
			params.add(establecimsector.getSector().getSedescrie());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescrii() != null) {
			where.append(" AND t4.SEDESCRII = ?");
			params.add(establecimsector.getSector().getSedescrii());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescrif() != null) {
			where.append(" AND t4.SEDESCRIF = ?");
			params.add(establecimsector.getSector().getSedescrif());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSecodgrupo() != null) {
			where.append(" AND t4.SECODGRUPO = ?");
			params.add(establecimsector.getSector().getSecodgrupo());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombrea() != null) {
			where.append(" AND t4.SENOMBREA = ?");
			params.add(establecimsector.getSector().getSenombrea());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescria() != null) {
			where.append(" AND t4.SEDESCRIA = ?");
			params.add(establecimsector.getSector().getSedescria());
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenocoa() != null) {
			where.append(" AND t4.SENOCOA = ?");
			params.add(establecimsector.getSector().getSenocoa());
		}
		if (establecimsector != null && establecimsector.getEainprse() != null) {
			where.append(" AND t1.EAINPRSE = ?");
			params.add(establecimsector.getEainprse());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the EstablecimSector table using like.
	 * 
	 * @param establecimsector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	// CHECKSTYLE:OFF
	@Transactional(readOnly = true)
	public List<EstablecimSector> findAllLike(EstablecimSector establecimsector, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.EACOES= t2.ESCODIGO(+) AND t1.EACOAV= t3.AVCODIGO(+) AND t1.EACOSE= t4.SECODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.EACODIGO EACODIGO,t1.EAINPRSE EAINPRSE,t2.ESCODIGO ESTABLECIMIENTOESCODIGO,t2.ESNOMBRE ESTABLECIMIENTOESNOMBRE, t2.ESTIPID ESSTOESTIPID,t2.ESNIF ESTABLECIMIENTOESNIF,t2.ESNOAN ESTABLECIMIENTOESNOAN,t2.ESNOCO ESTABLECIMIENTOESNOCO,t2.ESNODIR ESTABLECIMIENTOESNODIR,t2.ESCOLO ESTABLECIMIENTOESCOLO,t2.ESNRCOPO ESTABLECIMIENTOESNRCOPO,t2.ESNRTEL ESTABLECIMIENTOESNRTEL,t2.ESNRFAX ESTABLECIMIENTOESNRFAX,t2.ESCOPA ESTABLECIMIENTOESCOPA,t2.ESINCAPR ESTABLECIMIENTOESINCAPR,t2.ESINDEMP ESTABLECIMIENTOESINDEMP,t2.ESTECO ESTABLECIMIENTOESTECO,t2.ESINADAR ESTABLECIMIENTOESINADAR,t2.ESFEADAR ESTABLECIMIENTOESFEADAR,t2.ESCOEM ESTABLECIMIENTOESCOEM,t2.ESINEMPR ESTABLECIMIENTOESINEMPR,t2.ESNRTEL2 ESTABLECIMIENTOESNRTEL2,t2.ESFEBA ESTABLECIMIENTOESFEBA,t2.ESNOAP1 ESTABLECIMIENTOESNOAP1,t2.ESNOAP2 ESTABLECIMIENTOESNOAP2,t2.ESNOLO ESTABLECIMIENTOESNOLO,t2.ESCOMAPV ESTABLECIMIENTOESCOMAPV,t2.ESCOCA ESTABLECIMIENTOESCOCA,t2.ESNOPECO ESTABLECIMIENTOESNOPECO,t2.ESCOIDCO ESTABLECIMIENTOESCOIDCO,t2.ESINRECO ESTABLECIMIENTOESINRECO,t2.ESFEMOD ESTABLECIMIENTOESFEMOD,t2.ESINESCO ESTABLECIMIENTOESINESCO,t2.ESNOMU ESTABLECIMIENTOESNOMU,t2.ESNOREP ESTABLECIMIENTOESNOREP,t2.ESNIFREP ESTABLECIMIENTOESNIFREP,t2.DTTEEMR ESTABLECIMIENTODTTEEMR,t2.ESCAREP ESTABLECIMIENTOESCAREP,t2.ESTEURL ESTABLECIMIENTOESTEURL,t2.ESCOOE ESTABLECIMIENTOESCOOE,t2.ESNODECO ESTABLECIMIENTOESNODECO,t2.ESINTIAR ESTABLECIMIENTOESINTIAR,t2.ESFEPLAD ESTABLECIMIENTOESFEPLAD,t2.ESINDEME ESTABLECIMIENTOESINDEME,t2.ESNORA_PAIS_ID ESTABLECIMIENTOESNORAPAISID,t2.ESNORA_PAIS_NOMBRE ESTABLECIMIENTOESNORAPAISNOMBRE,t2.ESNORA_PROVINCIA_ID ESTABLECIMIENTOESNORAPROVINCIAID,t2.ESNOMBRE_PROVINCIA ESTABLECIMIENTOESNOMBREPROVINCIA,t2.ESNORA_MUNICIPIO_ID ESTABLECIMIENTOESNORAMUNICIPIOID,t2.ESNOMBRE_MUNICIPIO ESTABLECIMIENTOESNOMBREMUNICIPIO,t2.ESNORA_LOCALIDAD_ID ESTABLECIMIENTOESNORALOCALIDADID,t2.ESNOMBRE_LOCALIDAD ESTABLECIMIENTOESNOMBRELOCALIDAD,t2.ESNORA_CALLE_ID ESTABLECIMIENTOESNORACALLEID,t2.ESNOMBRE_CALLE ESTABLECIMIENTOESNOMBRECALLE,t2.ESNORA_CP_ID ESTABLECIMIENTOESNORACPID,t2.ESNOMBRE_CP ESTABLECIMIENTOESNOMBRECP,t2.ESNORA_PORTAL_ID ESTABLECIMIENTOESNORAPORTALID,t2.ESNOMBRE_PORTAL ESTABLECIMIENTOESNOMBREPORTAL, t2.ESNOMBRE_PISO EstablecimientoESNOMBREPISO, t2.ESDIRECCION_NOCAPV ESSTOESDIRECCION_NOCAPV, t2.ESEXTRANJERO ESSTOESEXTRANJERO, t3.AVCODIGO ACTIVIDADAVCODIGO,t3.AVNOMBRE ACTIVIDADAVNOMBRE,t3.AVNOCO ACTIVIDADAVNOCO,t3.AVTEDE ACTIVIDADAVTEDE,t3.AVCOSE ACTIVIDADAVCOSE,t3.AVNOMBREE ACTIVIDADAVNOMBREE,t3.AVNOMBREI ACTIVIDADAVNOMBREI,t3.AVNOMBREF ACTIVIDADAVNOMBREF,t3.AVNOCOE ACTIVIDADAVNOCOE,t3.AVNOCOI ACTIVIDADAVNOCOI,t3.AVNOCOF ACTIVIDADAVNOCOF,t3.AVTEDEE ACTIVIDADAVTEDEE,t3.AVTEDEI ACTIVIDADAVTEDEI,t3.AVTEDEF ACTIVIDADAVTEDEF,t3.AVNOMBREA ACTIVIDADAVNOMBREA,t3.AVNOCOA ACTIVIDADAVNOCOA,t3.AVTEDEA ACTIVIDADAVTEDEA,t4.SECODIGO SECTORSECODIGO,t4.SENOMBRE SECTORSENOMBRE,t4.SENOCO SECTORSENOCO,t4.SEDESCRI SECTORSEDESCRI,t4.SECOSE SECTORSECOSE,t4.SENOCO2 SECTORSENOCO2,t4.SEINSEL1 SECTORSEINSEL1,t4.SENOMBREE SECTORSENOMBREE,t4.SENOMBREI SECTORSENOMBREI,t4.SENOMBREF SECTORSENOMBREF,t4.SENOCOE SECTORSENOCOE,t4.SENOCOI SECTORSENOCOI,t4.SENOCOF SECTORSENOCOF,t4.SEDESCRIE SECTORSEDESCRIE,t4.SEDESCRII SECTORSEDESCRII,t4.SEDESCRIF SECTORSEDESCRIF,t4.SECODGRUPO SECTORSECODGRUPO,t4.SENOMBREA SECTORSENOMBREA,t4.SEDESCRIA SECTORSEDESCRIA,t4.SENOCOA SECTORSENOCOA,t2.ESCOZS ESTABLECIMIENTOESCOZS,t4.SECOL0 SECTORSECOL0 "
						+ "FROM ESTABLECIM_SECTOR t1 ,ESTABLECIMIENTO t2 ,ACTIVIDAD t3 ,SECTOR t4 ");

		if (establecimsector != null && establecimsector.getEacodigo() != null) {
			where.append(" AND UPPER(t1.EACODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEacodigo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEacodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.EACODIGO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t2.ESCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEscodigo() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEscodigo() + "%");
			}
			where.append(" AND t2.ESCODIGO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getCensoMonitor() != null
				&& establecimsector.getEstablecimiento().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t2.ESCOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getCensoMonitor().getMocodigo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getCensoMonitor().getMocodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ESCOZS IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND UPPER(t2.ESNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnombre().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnombre().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOMBRE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnif() != null) {
			where.append(" AND UPPER(t2.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNIF IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND UPPER(t2.ESNOAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnoan().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnoan().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOAN IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND UPPER(t2.ESNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnoco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnoco().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOCO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND UPPER(t2.ESNODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnodir().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnodir().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNODIR IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscolo() != null) {
			where.append(" AND UPPER(t2.ESCOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEscolo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEscolo().toUpperCase() + "%");
			}
			where.append(" AND t2.ESCOLO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND UPPER(t2.ESNRCOPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnrcopo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnrcopo().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNRCOPO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND UPPER(t2.ESNRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnrtel().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnrtel().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNRTEL IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND UPPER(t2.ESNRFAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnrfax().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnrfax().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNRFAX IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscopa() != null) {
			where.append(" AND UPPER(t2.ESCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEscopa().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEscopa().toUpperCase() + "%");
			}
			where.append(" AND t2.ESCOPA IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND UPPER(t2.ESINCAPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsincapr().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsincapr().toUpperCase() + "%");
			}
			where.append(" AND t2.ESINCAPR IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND UPPER(t2.ESINDEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsindemp().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsindemp().toUpperCase() + "%");
			}
			where.append(" AND t2.ESINDEMP IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsteco() != null) {
			where.append(" AND UPPER(t2.ESTECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsteco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsteco().toUpperCase() + "%");
			}
			where.append(" AND t2.ESTECO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND UPPER(t2.ESINADAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsinadar().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsinadar().toUpperCase() + "%");
			}
			where.append(" AND t2.ESINADAR IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t2.ESFEADAR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsfeadar() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsfeadar() + "%");
			}
			where.append(" AND t2.ESFEADAR IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscoem() != null) {
			where.append(" AND UPPER(t2.ESCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEscoem().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEscoem().toUpperCase() + "%");
			}
			where.append(" AND t2.ESCOEM IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND UPPER(t2.ESINEMPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsinempr().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsinempr().toUpperCase() + "%");
			}
			where.append(" AND t2.ESINEMPR IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND UPPER(t2.ESNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnrtel2().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNRTEL2 IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t2.ESFEBA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsfeba() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsfeba() + "%");
			}
			where.append(" AND t2.ESFEBA IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND UPPER(t2.ESNOAP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnoap1().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnoap1().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOAP1 IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND UPPER(t2.ESNOAP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnoap2().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnoap2().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOAP2 IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND UPPER(t2.ESNOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnolo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnolo().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOLO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND UPPER(t2.ESCOMAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEscomapv().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEscomapv().toUpperCase() + "%");
			}
			where.append(" AND t2.ESCOMAPV IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscoca() != null) {
			where.append(" AND UPPER(t2.ESCOCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEscoca().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEscoca().toUpperCase() + "%");
			}
			where.append(" AND t2.ESCOCA IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND UPPER(t2.ESNOPECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnopeco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnopeco().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOPECO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND UPPER(t2.ESCOIDCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEscoidco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEscoidco().toUpperCase() + "%");
			}
			where.append(" AND t2.ESCOIDCO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND UPPER(t2.ESINRECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsinreco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsinreco().toUpperCase() + "%");
			}
			where.append(" AND t2.ESINRECO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND UPPER(t2.ESFEMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsfemod().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsfemod().toUpperCase() + "%");
			}
			where.append(" AND t2.ESFEMOD IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND UPPER(t2.ESINESCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsinesco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsinesco().toUpperCase() + "%");
			}
			where.append(" AND t2.ESINESCO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND UPPER(t2.ESNOMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnomu().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnomu().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOMU IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND UPPER(t2.ESNOREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnorep().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnorep().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOREP IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND UPPER(t2.ESNIFREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnifrep().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnifrep().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNIFREP IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND UPPER(t2.DTTEEMR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getDtteemr().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getDtteemr().toUpperCase() + "%");
			}
			where.append(" AND t2.DTTEEMR IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscarep() != null) {
			where.append(" AND UPPER(t2.ESCAREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEscarep().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEscarep().toUpperCase() + "%");
			}
			where.append(" AND t2.ESCAREP IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND UPPER(t2.ESTEURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsteurl().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsteurl().toUpperCase() + "%");
			}
			where.append(" AND t2.ESTEURL IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEscooe() != null) {
			where.append(" AND UPPER(t2.ESCOOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEscooe().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEscooe().toUpperCase() + "%");
			}
			where.append(" AND t2.ESCOOE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND UPPER(t2.ESNODECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnodeco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnodeco().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNODECO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND UPPER(t2.ESINTIAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsintiar().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsintiar().toUpperCase() + "%");
			}
			where.append(" AND t2.ESINTIAR IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t2.ESFEPLAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsfeplad() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsfeplad() + "%");
			}
			where.append(" AND t2.ESFEPLAD IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND UPPER(t2.ESINDEME) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsindeme().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsindeme().toUpperCase() + "%");
			}
			where.append(" AND t2.ESINDEME IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND UPPER(t2.ESNORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNORA_PAIS_ID IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND UPPER(t2.ESNORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnoraPaisNombre().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnoraPaisNombre().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND UPPER(t2.ESNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND UPPER(t2.ESNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnombreProvincia().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND UPPER(t2.ESNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND UPPER(t2.ESNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnombreMunicipio().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND UPPER(t2.ESNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnoraLocalidadId().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND UPPER(t2.ESNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnombreLocalidad().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND UPPER(t2.ESNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNORA_CALLE_ID IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND UPPER(t2.ESNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOMBRE_CALLE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND UPPER(t2.ESNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNORA_CP_ID IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND UPPER(t2.ESNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnombreCp().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOMBRE_CP IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND UPPER(t2.ESNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNORA_PORTAL_ID IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEstablecimiento() != null
				&& establecimsector.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND UPPER(t2.ESNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEstablecimiento().getEsnombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEstablecimiento().getEsnombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t2.ESNOMBRE_PORTAL IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvcodigo() != null) {
			where.append(" AND t3.AVCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvcodigo() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvcodigo() + "%");
			}
			where.append(" AND t3.AVCODIGO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombre() != null) {
			where.append(" AND UPPER(t3.AVNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvnombre().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvnombre().toUpperCase() + "%");
			}
			where.append(" AND t3.AVNOMBRE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnoco() != null) {
			where.append(" AND UPPER(t3.AVNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvnoco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvnoco().toUpperCase() + "%");
			}
			where.append(" AND t3.AVNOCO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtede() != null) {
			where.append(" AND UPPER(t3.AVTEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvtede().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvtede().toUpperCase() + "%");
			}
			where.append(" AND t3.AVTEDE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvcose() != null) {
			where.append(" AND UPPER(t3.AVCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvcose().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvcose().toUpperCase() + "%");
			}
			where.append(" AND t3.AVCOSE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombree() != null) {
			where.append(" AND UPPER(t3.AVNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvnombree().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvnombree().toUpperCase() + "%");
			}
			where.append(" AND t3.AVNOMBREE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombrei() != null) {
			where.append(" AND UPPER(t3.AVNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvnombrei().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvnombrei().toUpperCase() + "%");
			}
			where.append(" AND t3.AVNOMBREI IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombref() != null) {
			where.append(" AND UPPER(t3.AVNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvnombref().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvnombref().toUpperCase() + "%");
			}
			where.append(" AND t3.AVNOMBREF IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnocoe() != null) {
			where.append(" AND UPPER(t3.AVNOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvnocoe().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvnocoe().toUpperCase() + "%");
			}
			where.append(" AND t3.AVNOCOE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnocoi() != null) {
			where.append(" AND UPPER(t3.AVNOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvnocoi().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvnocoi().toUpperCase() + "%");
			}
			where.append(" AND t3.AVNOCOI IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnocof() != null) {
			where.append(" AND UPPER(t3.AVNOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvnocof().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvnocof().toUpperCase() + "%");
			}
			where.append(" AND t3.AVNOCOF IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtedee() != null) {
			where.append(" AND UPPER(t3.AVTEDEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvtedee().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvtedee().toUpperCase() + "%");
			}
			where.append(" AND t3.AVTEDEE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtedei() != null) {
			where.append(" AND UPPER(t3.AVTEDEI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvtedei().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvtedei().toUpperCase() + "%");
			}
			where.append(" AND t3.AVTEDEI IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtedef() != null) {
			where.append(" AND UPPER(t3.AVTEDEF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvtedef().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvtedef().toUpperCase() + "%");
			}
			where.append(" AND t3.AVTEDEF IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnombrea() != null) {
			where.append(" AND UPPER(t3.AVNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvnombrea().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvnombrea().toUpperCase() + "%");
			}
			where.append(" AND t3.AVNOMBREA IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvnocoa() != null) {
			where.append(" AND UPPER(t3.AVNOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvnocoa().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvnocoa().toUpperCase() + "%");
			}
			where.append(" AND t3.AVNOCOA IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getActividad() != null
				&& establecimsector.getActividad().getAvtedea() != null) {
			where.append(" AND UPPER(t3.AVTEDEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getActividad().getAvtedea().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getActividad().getAvtedea().toUpperCase() + "%");
			}
			where.append(" AND t3.AVTEDEA IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSecodigo() != null) {
			where.append(" AND t4.SECODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSecodigo() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSecodigo() + "%");
			}
			where.append(" AND t4.SECODIGO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSectorAgrupado() != null
				&& establecimsector.getSector().getSectorAgrupado().getL0codigo() != null) {
			where.append(" AND UPPER(t4.SECOL0) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSectorAgrupado().getL0codigo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSectorAgrupado().getL0codigo().toUpperCase() + "%");
			}
			where.append(" AND t4.SECOL0 IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombre() != null) {
			where.append(" AND UPPER(t4.SENOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSenombre().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSenombre().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOMBRE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenoco() != null) {
			where.append(" AND UPPER(t4.SENOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSenoco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSenoco().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOCO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescri() != null) {
			where.append(" AND UPPER(t4.SEDESCRI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSedescri().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSedescri().toUpperCase() + "%");
			}
			where.append(" AND t4.SEDESCRI IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSecose() != null) {
			where.append(" AND UPPER(t4.SECOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSecose().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSecose().toUpperCase() + "%");
			}
			where.append(" AND t4.SECOSE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenoco2() != null) {
			where.append(" AND UPPER(t4.SENOCO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSenoco2().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSenoco2().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOCO2 IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSeinsel1() != null) {
			where.append(" AND UPPER(t4.SEINSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSeinsel1().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSeinsel1().toUpperCase() + "%");
			}
			where.append(" AND t4.SEINSEL1 IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombree() != null) {
			where.append(" AND UPPER(t4.SENOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSenombree().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSenombree().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOMBREE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombrei() != null) {
			where.append(" AND UPPER(t4.SENOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSenombrei().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSenombrei().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOMBREI IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombref() != null) {
			where.append(" AND UPPER(t4.SENOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSenombref().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSenombref().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOMBREF IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenocoe() != null) {
			where.append(" AND UPPER(t4.SENOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSenocoe().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSenocoe().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOCOE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenocoi() != null) {
			where.append(" AND UPPER(t4.SENOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSenocoi().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSenocoi().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOCOI IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenocof() != null) {
			where.append(" AND UPPER(t4.SENOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSenocof().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSenocof().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOCOF IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescrie() != null) {
			where.append(" AND UPPER(t4.SEDESCRIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSedescrie().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSedescrie().toUpperCase() + "%");
			}
			where.append(" AND t4.SEDESCRIE IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescrii() != null) {
			where.append(" AND UPPER(t4.SEDESCRII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSedescrii().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSedescrii().toUpperCase() + "%");
			}
			where.append(" AND t4.SEDESCRII IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescrif() != null) {
			where.append(" AND UPPER(t4.SEDESCRIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSedescrif().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSedescrif().toUpperCase() + "%");
			}
			where.append(" AND t4.SEDESCRIF IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSecodgrupo() != null) {
			where.append(" AND UPPER(t4.SECODGRUPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSecodgrupo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSecodgrupo().toUpperCase() + "%");
			}
			where.append(" AND t4.SECODGRUPO IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenombrea() != null) {
			where.append(" AND UPPER(t4.SENOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSenombrea().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSenombrea().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOMBREA IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSedescria() != null) {
			where.append(" AND UPPER(t4.SEDESCRIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSedescria().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSedescria().toUpperCase() + "%");
			}
			where.append(" AND t4.SEDESCRIA IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getSector() != null
				&& establecimsector.getSector().getSenocoa() != null) {
			where.append(" AND UPPER(t4.SENOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getSector().getSenocoa().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getSector().getSenocoa().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOCOA IS NOT NULL");
		}
		if (establecimsector != null && establecimsector.getEainprse() != null) {
			where.append(" AND UPPER(t1.EAINPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimsector.getEainprse().toUpperCase() + "%");
			} else {
				params.add("%" + establecimsector.getEainprse().toUpperCase() + "%");
			}
			where.append(" AND t1.EAINPRSE IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<EstablecimSector>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}
}
