package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.EstablecimArbitra;

/**
 * * EstablecimArbitraDao  
 * 
 *  
 */

public interface EstablecimArbitraDao {

	/**
	 * Inserts a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	EstablecimArbitra add(EstablecimArbitra establecimarbitra);

	/**
	 * Updates a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	EstablecimArbitra update(EstablecimArbitra establecimarbitra);

	/**
	 * Updates a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            Pagination
	 * @return EstablecimArbitra
	 */
	void updateEstablecimiento(String escodigoBueno, String escodigoAfusionar);

	/**
	 * Finds a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	EstablecimArbitra find(EstablecimArbitra establecimarbitra);

	/**
	 * Finds a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	EstablecimArbitra findArbitraje(EstablecimArbitra establecimarbitra);

	/**
	 * Finds a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	EstablecimArbitra findArbitrajeSinExcepcion(
			EstablecimArbitra establecimarbitra);

	/**
	 * Deletes a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            EstablecimArbitra
	 * @return
	 */
	void remove(EstablecimArbitra establecimarbitra);

	/**
	 * Finds a List of rows in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            EstablecimArbitra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EstablecimArbitra> findAll(EstablecimArbitra establecimarbitra,
			Pagination pagination);

	/**
	 * Counts rows in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            EstablecimArbitra
	 * @return List
	 */
	Long findAllCount(EstablecimArbitra establecimarbitra);

	/**
	 * Finds rows in the EstablecimArbitra table using like.
	 * 
	 * @param establecimarbitra
	 *            EstablecimArbitra
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<EstablecimArbitra> findAllLike(EstablecimArbitra establecimarbitra,
			Pagination pagination, Boolean startsWith);
}
