package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.Tcmonola;
import com.ejie.y41b.model.Tcmonono;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Essa;

/**
 * EssaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class EssaDaoImpl implements EssaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Essa> rwMap = new RowMapper<Essa>() {
		public Essa mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Essa(new Establecimiento(resultSet.getString("MACOES")),
					new Solarb(resultSet.getString("MACOSA")),
					resultSet.getString("MAINADAR"),
					resultSet.getDate("MAFENOSA"),
					resultSet.getDate("MAFEFPCO"),
					resultSet.getDate("MAFERESA"),
					resultSet.getDate("MAFENOCT"),
					resultSet.getDate("MAFENOCO"),
					resultSet.getDate("MAFERECO"), new Tcmonono(
							resultSet.getString("MACOT8"), null, null, null),
					resultSet.getDate("MAFERSCO"),
					resultSet.getString("MAINRSCO"),
					resultSet.getBigDecimal("MACNRECO"),
					resultSet.getDate("MAFEREME"),
					resultSet.getDate("MAFEREDE"),
					resultSet.getString("MAINMENC"),
					resultSet.getString("MAINRENC"),
					resultSet.getString("MAINMENC2"),
					resultSet.getString("MAINRENC2"),
					resultSet.getString("MAINMENP"),
					resultSet.getString("MAINRENP"),
					resultSet.getDate("MAFENOLA"),
					resultSet.getString("MAINMELT"),
					resultSet.getString("MAINPUBO"),
					resultSet.getDate("MAFERELA"),
					resultSet.getString("MAINAD"),
					resultSet.getString("MAINADLI"),
					resultSet.getDate("MAFESOAC"),
					resultSet.getDate("MAFEENAC"),
					resultSet.getDate("MAFENOAC"),
					resultSet.getString("MAININPR"),
					resultSet.getString("MANRBOPL"),
					resultSet.getDate("MAFENOAR"),
					resultSet.getDate("MAFEREAR"),
					resultSet.getDate("MAFEALCO"),
					resultSet.getDate("MAFERENA"),
					resultSet.getDate("MAFECONA"), new Tcmonola(
							resultSet.getString("MACOT7"), null, null, null,
							null));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Essa table.
	 * 
	 * @param essa
	 *            Pagination
	 * @return Essa
	 */
	public Essa add(Essa essa) {
		String query = "INSERT INTO ESSA (MACOES, MACOSA, MAINADAR, MAFENOSA, MAFEFPCO, MAFERESA, MAFENOCT, MAFENOCO, MAFERECO, MACOT8, MAFERSCO, MAINRSCO, MACNRECO, MAFEREME, MAFEREDE, MAINMENC, MAINRENC, MAINMENC2, MAINRENC2, MAINMENP, MAINRENP, MAFENOLA, MAINMELT, MAINPUBO, MAFERELA, MAINAD, MAINADLI, MAFESOAC, MAFEENAC, MAFENOAC, MAININPR, MANRBOPL, MAFENOAR, MAFEREAR, MAFEALCO, MAFERENA, MAFECONA, MACOT7) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object SolarbSacodigoAux = null;
		if (essa.getSolarb() != null && essa.getSolarb().getSacodigo() != null) {
			SolarbSacodigoAux = essa.getSolarb().getSacodigo();
		}
		Object escodigoAux = null;
		if (essa.getEstablecimiento() != null
				&& essa.getEstablecimiento().getEscodigo() != null) {
			escodigoAux = essa.getEstablecimiento().getEscodigo();
		}
		Object TcmononoT8codigoAux = null;
		if (essa.getTcmonono() != null
				&& essa.getTcmonono().getT8codigo() != null) {
			TcmononoT8codigoAux = essa.getTcmonono().getT8codigo();
		}
		Object TcmonolaT7codigoAux = null;
		if (essa.getTcmonola() != null
				&& essa.getTcmonola().getT7codigo() != null) {
			TcmonolaT7codigoAux = essa.getTcmonola().getT7codigo();
		}
		this.jdbcTemplate.update(query, escodigoAux, SolarbSacodigoAux,
				essa.getMainadar(), essa.getMafenosa(), essa.getMafefpco(),
				essa.getMaferesa(), essa.getMafenoct(), essa.getMafenoco(),
				essa.getMafereco(), TcmononoT8codigoAux, essa.getMafersco(),
				essa.getMainrsco(), essa.getMacnreco(), essa.getMafereme(),
				essa.getMaferede(), essa.getMainmenc(), essa.getMainrenc(),
				essa.getMainmenc2(), essa.getMainrenc2(), essa.getMainmenp(),
				essa.getMainrenp(), essa.getMafenola(), essa.getMainmelt(),
				essa.getMainpubo(), essa.getMaferela(), essa.getMainad(),
				essa.getMainadli(), essa.getMafesoac(), essa.getMafeenac(),
				essa.getMafenoac(), essa.getMaininpr(), essa.getManrbopl(),
				essa.getMafenoar(), essa.getMaferear(), essa.getMafealco(),
				essa.getMaferena(), essa.getMafecona(), TcmonolaT7codigoAux);
		return essa;
	}

	/**
	 * Updates a single row in the Essa table.
	 * 
	 * @param essa
	 *            Pagination
	 * @return Essa
	 */
	public Essa update(Essa essa) {
		String query = "UPDATE ESSA SET  WHERE MACOES=? AND MACOSA=? AND MAINADAR=? AND MAFENOSA=? AND MAFEFPCO=? AND MAFERESA=? AND MAFENOCT=? AND MAFENOCO=? AND MAFERECO=? AND MACOT8=? AND MAFERSCO=? AND MAINRSCO=? AND MACNRECO=? AND MAFEREME=? AND MAFEREDE=? AND MAINMENC=? AND MAINRENC=? AND MAINMENC2=? AND MAINRENC2=? AND MAINMENP=? AND MAINRENP=? AND MAFENOLA=? AND MAINMELT=? AND MAINPUBO=? AND MAFERELA=? AND MAINAD=? AND MAINADLI=? AND MAFESOAC=? AND MAFEENAC=? AND MAFENOAC=? AND MAININPR=? AND MANRBOPL=? AND MAFENOAR=? AND MAFEREAR=? AND MAFEALCO=? AND MAFERENA=? AND MAFECONA=? AND MACOT7=?";
		Object SolarbSacodigoAux = null;
		if (essa.getSolarb() != null && essa.getSolarb().getSacodigo() != null) {
			SolarbSacodigoAux = essa.getSolarb().getSacodigo();
		}
		Object escodigoAux = null;
		if (essa.getEstablecimiento() != null
				&& essa.getEstablecimiento().getEscodigo() != null) {
			escodigoAux = essa.getEstablecimiento().getEscodigo();
		}
		Object TcmononoT8codigoAux = null;
		if (essa.getTcmonono() != null
				&& essa.getTcmonono().getT8codigo() != null) {
			TcmononoT8codigoAux = essa.getTcmonono().getT8codigo();
		}
		Object TcmonolaT7codigoAux = null;
		if (essa.getTcmonola() != null
				&& essa.getTcmonola().getT7codigo() != null) {
			TcmonolaT7codigoAux = essa.getTcmonola().getT7codigo();
		}
		this.jdbcTemplate.update(query, escodigoAux, SolarbSacodigoAux,
				essa.getMainadar(), essa.getMafenosa(), essa.getMafefpco(),
				essa.getMaferesa(), essa.getMafenoct(), essa.getMafenoco(),
				essa.getMafereco(), TcmononoT8codigoAux, essa.getMafersco(),
				essa.getMainrsco(), essa.getMacnreco(), essa.getMafereme(),
				essa.getMaferede(), essa.getMainmenc(), essa.getMainrenc(),
				essa.getMainmenc2(), essa.getMainrenc2(), essa.getMainmenp(),
				essa.getMainrenp(), essa.getMafenola(), essa.getMainmelt(),
				essa.getMainpubo(), essa.getMaferela(), essa.getMainad(),
				essa.getMainadli(), essa.getMafesoac(), essa.getMafeenac(),
				essa.getMafenoac(), essa.getMaininpr(), essa.getManrbopl(),
				essa.getMafenoar(), essa.getMaferear(), essa.getMafealco(),
				essa.getMaferena(), essa.getMafecona(), TcmonolaT7codigoAux);
		return essa;
	}

	/**
	 * Finds a single row in the Essa table.
	 * 
	 * @param essa
	 *            Pagination
	 * @return Essa
	 */
	@Transactional(readOnly = true)
	public Essa find(Essa essa) {
		String query = "SELECT t1.MACOES MACOES, t1.MACOSA MACOSA, t1.MAINADAR MAINADAR, t1.MAFENOSA MAFENOSA, t1.MAFEFPCO MAFEFPCO, t1.MAFERESA MAFERESA, t1.MAFENOCT MAFENOCT, t1.MAFENOCO MAFENOCO, t1.MAFERECO MAFERECO, t1.MACOT8 MACOT8, t1.MAFERSCO MAFERSCO, t1.MAINRSCO MAINRSCO, t1.MACNRECO MACNRECO, t1.MAFEREME MAFEREME, t1.MAFEREDE MAFEREDE, t1.MAINMENC MAINMENC, t1.MAINRENC MAINRENC, t1.MAINMENC2 MAINMENC2, t1.MAINRENC2 MAINRENC2, t1.MAINMENP MAINMENP, t1.MAINRENP MAINRENP, t1.MAFENOLA MAFENOLA, t1.MAINMELT MAINMELT, t1.MAINPUBO MAINPUBO, t1.MAFERELA MAFERELA, t1.MAINAD MAINAD, t1.MAINADLI MAINADLI, t1.MAFESOAC MAFESOAC, t1.MAFEENAC MAFEENAC, t1.MAFENOAC MAFENOAC, t1.MAININPR MAININPR, t1.MANRBOPL MANRBOPL, t1.MAFENOAR MAFENOAR, t1.MAFEREAR MAFEREAR, t1.MAFEALCO MAFEALCO, t1.MAFERENA MAFERENA, t1.MAFECONA MAFECONA, t1.MACOT7 MACOT7 FROM ESSA t1  WHERE t1.MACOES = ?   AND t1.MACOSA = ?   AND t1.MAINADAR = ?   AND t1.MAFENOSA = ?   AND t1.MAFEFPCO = ?   AND t1.MAFERESA = ?   AND t1.MAFENOCT = ?   AND t1.MAFENOCO = ?   AND t1.MAFERECO = ?   AND t1.MACOT8 = ?   AND t1.MAFERSCO = ?   AND t1.MAINRSCO = ?   AND t1.MACNRECO = ?   AND t1.MAFEREME = ?   AND t1.MAFEREDE = ?   AND t1.MAINMENC = ?   AND t1.MAINRENC = ?   AND t1.MAINMENC2 = ?   AND t1.MAINRENC2 = ?   AND t1.MAINMENP = ?   AND t1.MAINRENP = ?   AND t1.MAFENOLA = ?   AND t1.MAINMELT = ?   AND t1.MAINPUBO = ?   AND t1.MAFERELA = ?   AND t1.MAINAD = ?   AND t1.MAINADLI = ?   AND t1.MAFESOAC = ?   AND t1.MAFEENAC = ?   AND t1.MAFENOAC = ?   AND t1.MAININPR = ?   AND t1.MANRBOPL = ?   AND t1.MAFENOAR = ?   AND t1.MAFEREAR = ?   AND t1.MAFEALCO = ?   AND t1.MAFERENA = ?   AND t1.MAFECONA = ?   AND t1.MACOT7 = ?  ";

		List<Essa> essaList = this.jdbcTemplate.query(query, this.rwMap, essa
				.getEstablecimiento().getEscodigo(), essa.getSolarb()
				.getSacodigo(), essa.getMainadar(), essa.getMafenosa(), essa
				.getMafefpco(), essa.getMaferesa(), essa.getMafenoct(), essa
				.getMafenoco(), essa.getMafereco(), essa.getTcmonono()
				.getT8codigo(), essa.getMafersco(), essa.getMainrsco(), essa
				.getMacnreco(), essa.getMafereme(), essa.getMaferede(), essa
				.getMainmenc(), essa.getMainrenc(), essa.getMainmenc2(), essa
				.getMainrenc2(), essa.getMainmenp(), essa.getMainrenp(), essa
				.getMafenola(), essa.getMainmelt(), essa.getMainpubo(), essa
				.getMaferela(), essa.getMainad(), essa.getMainadli(), essa
				.getMafesoac(), essa.getMafeenac(), essa.getMafenoac(), essa
				.getMaininpr(), essa.getManrbopl(), essa.getMafenoar(), essa
				.getMaferear(), essa.getMafealco(), essa.getMaferena(), essa
				.getMafecona(), essa.getTcmonola().getT7codigo());
		return (Essa) DataAccessUtils.uniqueResult(essaList);
	}

	/**
	 * Removes a single row in the Essa table.
	 * 
	 * @param essa
	 *            Pagination
	 * @return
	 */
	public void remove(Essa essa) {
		String query = "DELETE FROM ESSA WHERE MACOSA=?";
		this.jdbcTemplate.update(query, essa.getSolarb().getSacodigo());
	}

	/**
	 * Finds a List of rows in the Essa table.
	 * 
	 * @param essa
	 *            Essa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Essa> findAll(Essa essa, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.MACOES MACOES,t1.MACOSA MACOSA,t1.MAINADAR MAINADAR,t1.MAFENOSA MAFENOSA,t1.MAFEFPCO MAFEFPCO,t1.MAFERESA MAFERESA,t1.MAFENOCT MAFENOCT,t1.MAFENOCO MAFENOCO,t1.MAFERECO MAFERECO,t1.MACOT8 MACOT8,t1.MAFERSCO MAFERSCO,t1.MAINRSCO MAINRSCO,t1.MACNRECO MACNRECO,t1.MAFEREME MAFEREME,t1.MAFEREDE MAFEREDE,t1.MAINMENC MAINMENC,t1.MAINRENC MAINRENC,t1.MAINMENC2 MAINMENC2,t1.MAINRENC2 MAINRENC2,t1.MAINMENP MAINMENP,t1.MAINRENP MAINRENP,t1.MAFENOLA MAFENOLA,t1.MAINMELT MAINMELT,t1.MAINPUBO MAINPUBO,t1.MAFERELA MAFERELA,t1.MAINAD MAINAD,t1.MAINADLI MAINADLI,t1.MAFESOAC MAFESOAC,t1.MAFEENAC MAFEENAC,t1.MAFENOAC MAFENOAC,t1.MAININPR MAININPR,t1.MANRBOPL MANRBOPL,t1.MAFENOAR MAFENOAR,t1.MAFEREAR MAFEREAR,t1.MAFEALCO MAFEALCO,t1.MAFERENA MAFERENA,t1.MAFECONA MAFECONA,t1.MACOT7 MACOT7 ");
		query.append("FROM ESSA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(essa);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Essa>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Essa table.
	 * 
	 * @param essa
	 *            Essa
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Essa essa) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ESSA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(essa);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Essa table using like.
	 * 
	 * @param essa
	 *            Essa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Essa> findAllLike(Essa essa, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.MACOES MACOES,t1.MACOSA MACOSA,t1.MAINADAR MAINADAR,t1.MAFENOSA MAFENOSA,t1.MAFEFPCO MAFEFPCO,t1.MAFERESA MAFERESA,t1.MAFENOCT MAFENOCT,t1.MAFENOCO MAFENOCO,t1.MAFERECO MAFERECO,t1.MACOT8 MACOT8,t1.MAFERSCO MAFERSCO,t1.MAINRSCO MAINRSCO,t1.MACNRECO MACNRECO,t1.MAFEREME MAFEREME,t1.MAFEREDE MAFEREDE,t1.MAINMENC MAINMENC,t1.MAINRENC MAINRENC,t1.MAINMENC2 MAINMENC2,t1.MAINRENC2 MAINRENC2,t1.MAINMENP MAINMENP,t1.MAINRENP MAINRENP,t1.MAFENOLA MAFENOLA,t1.MAINMELT MAINMELT,t1.MAINPUBO MAINPUBO,t1.MAFERELA MAFERELA,t1.MAINAD MAINAD,t1.MAINADLI MAINADLI,t1.MAFESOAC MAFESOAC,t1.MAFEENAC MAFEENAC,t1.MAFENOAC MAFENOAC,t1.MAININPR MAININPR,t1.MANRBOPL MANRBOPL,t1.MAFENOAR MAFENOAR,t1.MAFEREAR MAFEREAR,t1.MAFEALCO MAFEALCO,t1.MAFERENA MAFERENA,t1.MAFECONA MAFECONA,t1.MACOT7 MACOT7 ");
		query.append("FROM ESSA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(essa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Essa>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Essa table using like.
	 * 
	 * @param essa
	 *            Essa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Essa essa, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ESSA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(essa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Essa entity
	 * 
	 * @param essa
	 *            Essa Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Essa essa) {

		StringBuilder where = new StringBuilder(EssaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (essa != null && essa.getEstablecimiento() != null
				&& essa.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t1.MACOES = ?");
			params.add(essa.getEstablecimiento().getEscodigo());
		}
		if (essa != null && essa.getSolarb() != null
				&& essa.getSolarb().getSacodigo() != null) {
			where.append(" AND t1.MACOSA = ?");
			params.add(essa.getSolarb().getSacodigo());
		}
		if (essa != null && essa.getMainadar() != null) {
			where.append(" AND t1.MAINADAR = ?");
			params.add(essa.getMainadar());
		}
		if (essa != null && essa.getMafenosa() != null) {
			where.append(" AND t1.MAFENOSA = ?");
			params.add(essa.getMafenosa());
		}
		if (essa != null && essa.getMafefpco() != null) {
			where.append(" AND t1.MAFEFPCO = ?");
			params.add(essa.getMafefpco());
		}
		if (essa != null && essa.getMaferesa() != null) {
			where.append(" AND t1.MAFERESA = ?");
			params.add(essa.getMaferesa());
		}
		if (essa != null && essa.getMafenoct() != null) {
			where.append(" AND t1.MAFENOCT = ?");
			params.add(essa.getMafenoct());
		}
		if (essa != null && essa.getMafenoco() != null) {
			where.append(" AND t1.MAFENOCO = ?");
			params.add(essa.getMafenoco());
		}
		if (essa != null && essa.getMafereco() != null) {
			where.append(" AND t1.MAFERECO = ?");
			params.add(essa.getMafereco());
		}
		if (essa != null && essa.getTcmonono() != null
				&& essa.getTcmonono().getT8codigo() != null) {
			where.append(" AND t1.MACOT8 = ?");
			params.add(essa.getTcmonono().getT8codigo());
		}
		if (essa != null && essa.getMafersco() != null) {
			where.append(" AND t1.MAFERSCO = ?");
			params.add(essa.getMafersco());
		}
		if (essa != null && essa.getMainrsco() != null) {
			where.append(" AND t1.MAINRSCO = ?");
			params.add(essa.getMainrsco());
		}
		if (essa != null && essa.getMacnreco() != null) {
			where.append(" AND t1.MACNRECO = ?");
			params.add(essa.getMacnreco());
		}
		if (essa != null && essa.getMafereme() != null) {
			where.append(" AND t1.MAFEREME = ?");
			params.add(essa.getMafereme());
		}
		if (essa != null && essa.getMaferede() != null) {
			where.append(" AND t1.MAFEREDE = ?");
			params.add(essa.getMaferede());
		}
		if (essa != null && essa.getMainmenc() != null) {
			where.append(" AND t1.MAINMENC = ?");
			params.add(essa.getMainmenc());
		}
		if (essa != null && essa.getMainrenc() != null) {
			where.append(" AND t1.MAINRENC = ?");
			params.add(essa.getMainrenc());
		}
		if (essa != null && essa.getMainmenc2() != null) {
			where.append(" AND t1.MAINMENC2 = ?");
			params.add(essa.getMainmenc2());
		}
		if (essa != null && essa.getMainrenc2() != null) {
			where.append(" AND t1.MAINRENC2 = ?");
			params.add(essa.getMainrenc2());
		}
		if (essa != null && essa.getMainmenp() != null) {
			where.append(" AND t1.MAINMENP = ?");
			params.add(essa.getMainmenp());
		}
		if (essa != null && essa.getMainrenp() != null) {
			where.append(" AND t1.MAINRENP = ?");
			params.add(essa.getMainrenp());
		}
		if (essa != null && essa.getMafenola() != null) {
			where.append(" AND t1.MAFENOLA = ?");
			params.add(essa.getMafenola());
		}
		if (essa != null && essa.getMainmelt() != null) {
			where.append(" AND t1.MAINMELT = ?");
			params.add(essa.getMainmelt());
		}
		if (essa != null && essa.getMainpubo() != null) {
			where.append(" AND t1.MAINPUBO = ?");
			params.add(essa.getMainpubo());
		}
		if (essa != null && essa.getMaferela() != null) {
			where.append(" AND t1.MAFERELA = ?");
			params.add(essa.getMaferela());
		}
		if (essa != null && essa.getMainad() != null) {
			where.append(" AND t1.MAINAD = ?");
			params.add(essa.getMainad());
		}
		if (essa != null && essa.getMainadli() != null) {
			where.append(" AND t1.MAINADLI = ?");
			params.add(essa.getMainadli());
		}
		if (essa != null && essa.getMafesoac() != null) {
			where.append(" AND t1.MAFESOAC = ?");
			params.add(essa.getMafesoac());
		}
		if (essa != null && essa.getMafeenac() != null) {
			where.append(" AND t1.MAFEENAC = ?");
			params.add(essa.getMafeenac());
		}
		if (essa != null && essa.getMafenoac() != null) {
			where.append(" AND t1.MAFENOAC = ?");
			params.add(essa.getMafenoac());
		}
		if (essa != null && essa.getMaininpr() != null) {
			where.append(" AND t1.MAININPR = ?");
			params.add(essa.getMaininpr());
		}
		if (essa != null && essa.getManrbopl() != null) {
			where.append(" AND t1.MANRBOPL = ?");
			params.add(essa.getManrbopl());
		}
		if (essa != null && essa.getMafenoar() != null) {
			where.append(" AND t1.MAFENOAR = ?");
			params.add(essa.getMafenoar());
		}
		if (essa != null && essa.getMaferear() != null) {
			where.append(" AND t1.MAFEREAR = ?");
			params.add(essa.getMaferear());
		}
		if (essa != null && essa.getMafealco() != null) {
			where.append(" AND t1.MAFEALCO = ?");
			params.add(essa.getMafealco());
		}
		if (essa != null && essa.getMaferena() != null) {
			where.append(" AND t1.MAFERENA = ?");
			params.add(essa.getMaferena());
		}
		if (essa != null && essa.getMafecona() != null) {
			where.append(" AND t1.MAFECONA = ?");
			params.add(essa.getMafecona());
		}
		if (essa != null && essa.getTcmonola() != null
				&& essa.getTcmonola().getT7codigo() != null) {
			where.append(" AND t1.MACOT7 = ?");
			params.add(essa.getTcmonola().getT7codigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Essa entity
	 * 
	 * @param essa
	 *            Essa Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Essa essa, Boolean startsWith) {

		StringBuilder where = new StringBuilder(EssaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (essa != null && essa.getEstablecimiento() != null
				&& essa.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND UPPER(t1.MACOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getEstablecimiento().getEscodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ essa.getEstablecimiento().getEscodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MACOES IS NOT NULL");
		}
		if (essa != null && essa.getSolarb().getSacodigo() != null) {
			where.append(" AND UPPER(t1.MACOSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getSolarb().getSacodigo().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getSolarb().getSacodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MACOSA IS NOT NULL");
		}
		if (essa != null && essa.getMainadar() != null) {
			where.append(" AND UPPER(t1.MAINADAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getMainadar().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getMainadar().toUpperCase() + "%");
			}
			where.append(" AND t1.MAINADAR IS NOT NULL");
		}
		if (essa != null && essa.getMafenosa() != null) {
			where.append(" AND t1.MAFENOSA = ?");
			params.add(essa.getMafenosa());
		}
		if (essa != null && essa.getMafefpco() != null) {
			where.append(" AND t1.MAFEFPCO = ?");
			params.add(essa.getMafefpco());
		}
		if (essa != null && essa.getMaferesa() != null) {
			where.append(" AND t1.MAFERESA = ?");
			params.add(essa.getMaferesa());
		}
		if (essa != null && essa.getMafenoct() != null) {
			where.append(" AND t1.MAFENOCT = ?");
			params.add(essa.getMafenoct());
		}
		if (essa != null && essa.getMafenoco() != null) {
			where.append(" AND t1.MAFENOCO = ?");
			params.add(essa.getMafenoco());
		}
		if (essa != null && essa.getMafereco() != null) {
			where.append(" AND t1.MAFERECO = ?");
			params.add(essa.getMafereco());
		}
		if (essa != null && essa.getTcmonono().getT8codigo() != null) {
			where.append(" AND UPPER(t1.MACOT8) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getTcmonono().getT8codigo().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getTcmonono().getT8codigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MACOT8 IS NOT NULL");
		}
		if (essa != null && essa.getMafersco() != null) {
			where.append(" AND t1.MAFERSCO = ?");
			params.add(essa.getMafersco());
		}
		if (essa != null && essa.getMainrsco() != null) {
			where.append(" AND UPPER(t1.MAINRSCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getMainrsco().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getMainrsco().toUpperCase() + "%");
			}
			where.append(" AND t1.MAINRSCO IS NOT NULL");
		}
		if (essa != null && essa.getMacnreco() != null) {
			where.append(" AND t1.MACNRECO = ?");
			params.add(essa.getMacnreco());
		}
		if (essa != null && essa.getMafereme() != null) {
			where.append(" AND t1.MAFEREME = ?");
			params.add(essa.getMafereme());
		}
		if (essa != null && essa.getMaferede() != null) {
			where.append(" AND t1.MAFEREDE = ?");
			params.add(essa.getMaferede());
		}
		if (essa != null && essa.getMainmenc() != null) {
			where.append(" AND UPPER(t1.MAINMENC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getMainmenc().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getMainmenc().toUpperCase() + "%");
			}
			where.append(" AND t1.MAINMENC IS NOT NULL");
		}
		if (essa != null && essa.getMainrenc() != null) {
			where.append(" AND UPPER(t1.MAINRENC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getMainrenc().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getMainrenc().toUpperCase() + "%");
			}
			where.append(" AND t1.MAINRENC IS NOT NULL");
		}
		if (essa != null && essa.getMainmenc2() != null) {
			where.append(" AND UPPER(t1.MAINMENC2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getMainmenc2().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getMainmenc2().toUpperCase() + "%");
			}
			where.append(" AND t1.MAINMENC2 IS NOT NULL");
		}
		if (essa != null && essa.getMainrenc2() != null) {
			where.append(" AND UPPER(t1.MAINRENC2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getMainrenc2().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getMainrenc2().toUpperCase() + "%");
			}
			where.append(" AND t1.MAINRENC2 IS NOT NULL");
		}
		if (essa != null && essa.getMainmenp() != null) {
			where.append(" AND UPPER(t1.MAINMENP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getMainmenp().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getMainmenp().toUpperCase() + "%");
			}
			where.append(" AND t1.MAINMENP IS NOT NULL");
		}
		if (essa != null && essa.getMainrenp() != null) {
			where.append(" AND UPPER(t1.MAINRENP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getMainrenp().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getMainrenp().toUpperCase() + "%");
			}
			where.append(" AND t1.MAINRENP IS NOT NULL");
		}
		if (essa != null && essa.getMafenola() != null) {
			where.append(" AND t1.MAFENOLA = ?");
			params.add(essa.getMafenola());
		}
		if (essa != null && essa.getMainmelt() != null) {
			where.append(" AND UPPER(t1.MAINMELT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getMainmelt().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getMainmelt().toUpperCase() + "%");
			}
			where.append(" AND t1.MAINMELT IS NOT NULL");
		}
		if (essa != null && essa.getMainpubo() != null) {
			where.append(" AND UPPER(t1.MAINPUBO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getMainpubo().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getMainpubo().toUpperCase() + "%");
			}
			where.append(" AND t1.MAINPUBO IS NOT NULL");
		}
		if (essa != null && essa.getMaferela() != null) {
			where.append(" AND t1.MAFERELA = ?");
			params.add(essa.getMaferela());
		}
		if (essa != null && essa.getMainad() != null) {
			where.append(" AND UPPER(t1.MAINAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getMainad().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getMainad().toUpperCase() + "%");
			}
			where.append(" AND t1.MAINAD IS NOT NULL");
		}
		if (essa != null && essa.getMainadli() != null) {
			where.append(" AND UPPER(t1.MAINADLI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getMainadli().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getMainadli().toUpperCase() + "%");
			}
			where.append(" AND t1.MAINADLI IS NOT NULL");
		}
		if (essa != null && essa.getMafesoac() != null) {
			where.append(" AND t1.MAFESOAC = ?");
			params.add(essa.getMafesoac());
		}
		if (essa != null && essa.getMafeenac() != null) {
			where.append(" AND t1.MAFEENAC = ?");
			params.add(essa.getMafeenac());
		}
		if (essa != null && essa.getMafenoac() != null) {
			where.append(" AND t1.MAFENOAC = ?");
			params.add(essa.getMafenoac());
		}
		if (essa != null && essa.getMaininpr() != null) {
			where.append(" AND UPPER(t1.MAININPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getMaininpr().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getMaininpr().toUpperCase() + "%");
			}
			where.append(" AND t1.MAININPR IS NOT NULL");
		}
		if (essa != null && essa.getManrbopl() != null) {
			where.append(" AND UPPER(t1.MANRBOPL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getManrbopl().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getManrbopl().toUpperCase() + "%");
			}
			where.append(" AND t1.MANRBOPL IS NOT NULL");
		}
		if (essa != null && essa.getMafenoar() != null) {
			where.append(" AND t1.MAFENOAR = ?");
			params.add(essa.getMafenoar());
		}
		if (essa != null && essa.getMaferear() != null) {
			where.append(" AND t1.MAFEREAR = ?");
			params.add(essa.getMaferear());
		}
		if (essa != null && essa.getMafealco() != null) {
			where.append(" AND t1.MAFEALCO = ?");
			params.add(essa.getMafealco());
		}
		if (essa != null && essa.getMaferena() != null) {
			where.append(" AND t1.MAFERENA = ?");
			params.add(essa.getMaferena());
		}
		if (essa != null && essa.getMafecona() != null) {
			where.append(" AND t1.MAFECONA = ?");
			params.add(essa.getMafecona());
		}
		if (essa != null && essa.getTcmonola().getT7codigo() != null) {
			where.append(" AND UPPER(t1.MACOT7) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(essa.getTcmonola().getT7codigo().toUpperCase() + "%");
			} else {
				params.add("%" + essa.getTcmonola().getT7codigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MACOT7 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
