package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Essa;

/**
 * EssaDao  
 *  
 */

public interface EssaDao {
    
    /**
     * Inserts a single row in the Essa table.
     *
     * @param essa Essa
     * @return Essa
     */
    Essa add(Essa essa);

    /**
     * Updates a single row in the Essa table.
     *
     * @param essa Essa
     * @return Essa
     */
    Essa update(Essa essa);

    /**
     * Finds a single row in the Essa table.
     *
     * @param essa Essa
     * @return Essa
     */
    Essa find(Essa essa);

    /**
     * Deletes a single row in the Essa table.
     *
     * @param essa Essa
     * @return 
     */
    void remove(Essa essa);

    /**
     * Finds a List of rows in the Essa table.
     *
     * @param essa Essa
     * @param pagination Pagination
     * @return List
     */
    List<Essa> findAll(Essa essa, Pagination pagination);

    /**
     * Counts rows in the Essa table.
     *
     * @param essa Essa
     * @return Long
     */
    Long findAllCount(Essa essa);
	
	/**
     * Finds rows in the Essa table using like.
     *
     * @param essa Essa
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Essa> findAllLike(Essa essa, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Essa table using like.
     *
     * @param essa Essa
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Essa essa, Boolean startsWith);
}

