package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.EsCanalPrioritario;
import com.ejie.y41b.model.EstTipoDoc;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Organismo;

/**
 * * EsCanalPrioritarioDaoImpl  
 * 
 *  
 */
@SuppressWarnings(value = { "deprecation" })
@Repository
@Transactional
public class EsCanalPrioritarioDaoImpl implements EsCanalPrioritarioDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory.getLogger(EsCanalPrioritarioDaoImpl.class);

	private RowMapper<EsCanalPrioritario> rwMap = new RowMapper<EsCanalPrioritario>() {
		public EsCanalPrioritario mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			EsCanalPrioritario esCanalPrioritario = new EsCanalPrioritario(resultSet.getString("YGIDCANAL"),
					resultSet.getString("YGCIF"), resultSet.getString("YGCANAL"));
			return esCanalPrioritario;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the EsCanalPrioritario table.
	 * 
	 * @param esCanalPrioritario
	 *            Pagination
	 * @return EsCanalPrioritario
	 */
	@Transactional(readOnly = true)
	public EsCanalPrioritario findEsCanalPrioritario(EsCanalPrioritario esCanalPrioritario) {
		try {
			String query = "SELECT t1.YGIDCANAL YGIDCANAL, t1.YGCIF YGCIF, t1.YGCANAL YGCANAL "
					+ "FROM ES_CANAL_PRIORITARIO t1 " + "WHERE t1.YGCIF = ? ";
			return (EsCanalPrioritario) this.jdbcTemplate.queryForObject(query, rwMap, esCanalPrioritario.getYgcif());
		} catch (Exception e) {
			return new EsCanalPrioritario();
		}
	}

	/**
	 * Counts rows in the EsCanalPrioritario table using like.
	 * 
	 * @param esCanalPrioritario
	 *            EsCanalPrioritario
	 * 
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public List<EsCanalPrioritario> findAllLikeEsCanalPrioritario(EsCanalPrioritario esCanalPrioritario,
			Pagination pagination, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.YGIDCANAL YGIDCANAL, t1.YGCIF YGCIF, t1.YGCANAL YGCANAL FROM  ES_CANAL_PRIORITARIO t1 ");

		if (esCanalPrioritario != null && esCanalPrioritario.getYgidcanal() != null) {
			where.append(" AND t1.YGIDCANAL = ?");
			params.add(esCanalPrioritario.getYgidcanal());
		}

		if (esCanalPrioritario != null && esCanalPrioritario.getYgcif() != null) {
			where.append(" AND t1.YGCIF = ?");
			params.add(esCanalPrioritario.getYgcif());
		}

		if (esCanalPrioritario != null && esCanalPrioritario.getYgcanal() != null) {
			where.append(" AND t1.YGCANAL = ?");
			params.add(esCanalPrioritario.getYgcanal());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}

		return (List<EsCanalPrioritario>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());

	}

	/**
	 * Counts rows in the EsCanalPrioritario table using like.
	 * 
	 * @param esCanalPrioritario
	 *            EsCanalPrioritario
	 * 
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeEsCanalPrioritarioCount(EsCanalPrioritario esCanalPrioritario, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer("SELECT  COUNT(1) FROM  ES_CANAL_PRIORITARIO t1 ");

		if (esCanalPrioritario != null && esCanalPrioritario.getYgidcanal() != null) {
			where.append(" AND t1.YGIDCANAL = ?");
			params.add(esCanalPrioritario.getYgidcanal());
		}

		if (esCanalPrioritario != null && esCanalPrioritario.getYgcif() != null) {
			where.append(" AND t1.YGCIF = ?");
			params.add(esCanalPrioritario.getYgcif());
		}

		if (esCanalPrioritario != null && esCanalPrioritario.getYgcanal() != null) {
			where.append(" AND t1.YGCANAL = ?");
			params.add(esCanalPrioritario.getYgcanal());
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Inserts a single row in the EsCanalPrioritario table.
	 * 
	 * @param esCanalPrioritario
	 *            EsCanalPrioritario
	 * @return EsCanalPrioritario
	 */
	public EsCanalPrioritario addEsCanalPrioritario(EsCanalPrioritario esCanalPrioritario) {

		String query = "INSERT INTO ES_CANAL_PRIORITARIO (YGIDCANAL, YGCIF, YGCANAL) VALUES (?,?,?)";

		this.jdbcTemplate.update(query, esCanalPrioritario.getYgidcanal(), esCanalPrioritario.getYgcif(),
				esCanalPrioritario.getYgcanal());

		return esCanalPrioritario;
	}

	/**
	 * Updates a single row in the EsCanalPrioritario table.
	 * 
	 * @param esCanalPrioritario
	 *            EsCanalPrioritario
	 * @return EsCanalPrioritario
	 */
	public EsCanalPrioritario updateEsCanalPrioritario(EsCanalPrioritario esCanalPrioritario) {
		String query = "UPDATE ES_CANAL_PRIORITARIO SET YGCANAL=? WHERE YGCIF=?";
		Object getCensoMonitorMocodigoAux = null;

		this.jdbcTemplate.update(query, esCanalPrioritario.getYgcanal(), esCanalPrioritario.getYgcif());

		return esCanalPrioritario;
	}

	/**
	 * Removes a single row in the EsCanalPrioritario table.
	 * 
	 * @param esCanalPrioritario
	 *            EsCanalPrioritario
	 * @return
	 */
	public void remove(EsCanalPrioritario esCanalPrioritario) {
		String query = "DELETE  FROM ES_CANAL_PRIORITARIO WHERE YGCIF=?";
		this.jdbcTemplate.update(query, esCanalPrioritario.getYgcif());
	}

}
