package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Errores;
import com.ejie.y41b.model.Movimientos;
import com.ejie.y41b.model.Tipomovimientos;
import com.ejie.y41b.model.Tiposerrores;

/**
 * ErroresDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class ErroresDaoImpl implements ErroresDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Errores> rwMap = new RowMapper<Errores>() {
		public Errores mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Errores(
					resultSet.getString("SICODIGO"),
					resultSet.getString("SIREFERENCIA"),
					resultSet.getString("SIIDTIPOMOV"),
					resultSet.getDate("SIFECHAERROR"),
					resultSet.getString("SIFICHEROSIPCA"),
					resultSet.getString("SIDATOERRONEO"),
					resultSet.getInt("SILINEA"),
					resultSet.getString("SILINEAERROR"),
					new Tiposerrores(resultSet
							.getString("TiposerroresSJCODIGO"), resultSet
							.getString("TiposerroresSJCONSTANTE"), resultSet
							.getString("TiposerroresSJTEXTOES"), resultSet
							.getString("TiposerroresSJTEXTOEU"), resultSet
							.getString("TiposerroresSJEXPLICACIONES"),
							resultSet.getString("TiposerroresSJEXPLICACIONEU")),
					new Movimientos(resultSet.getString("MovimientosSFCODIGO"),
							resultSet.getString("MovimientosSFREFERENCIA"),
							resultSet.getString("MovimientosSFTIPOMOV"),
							resultSet.getString("MovimientosSFPERIODO"),
							resultSet.getString("MovimientosSFSENTIDO"),
							resultSet.getDate("MovimientosSFFECHAOPERACION"),
							resultSet.getString("MovimientosSFESTADOMOV"),
							resultSet.getString("MovimientosSFDETALLE")),
					new Tipomovimientos(resultSet
							.getString("TipomovimientosSECODIGO"), resultSet
							.getString("TipomovimientosSEDESCES"), resultSet
							.getString("TipomovimientosSEDESCEU")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Errores table.
	 * 
	 * @param errores
	 *            Pagination
	 * @return Errores
	 */
	public Errores add(Errores errores) {
		String query = "INSERT INTO ERRORES (SICODIGO, SICODIGOERROR, SIIDMOVIMIENTO, SIREFERENCIA, SIIDTIPOMOV, SIFECHAERROR, SIFICHEROSIPCA, SIDATOERRONEO, SILINEA, SILINEAERROR) VALUES (?,?,?,?,?,?,?,?,?,?)";
		Object getTiposerroresSjcodigoAux = null;
		if (errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjcodigo() != null) {
			getTiposerroresSjcodigoAux = errores.getTiposerrores()
					.getSjcodigo();
		}
		Object getMovimientosSfcodigoAux = null;
		if (errores.getMovimientos() != null
				&& errores.getMovimientos().getSfcodigo() != null) {
			getMovimientosSfcodigoAux = errores.getMovimientos().getSfcodigo();
		}
		this.jdbcTemplate.update(query, errores.getSicodigo(),
				getTiposerroresSjcodigoAux, getMovimientosSfcodigoAux,
				errores.getSireferencia(), errores.getSiidtipomov(),
				errores.getSifechaerror(), errores.getSificherosipca(),
				errores.getSidatoerroneo(), errores.getSilinea(),
				errores.getSilineaerror());
		return errores;
	}

	/**
	 * Updates a single row in the Errores table.
	 * 
	 * @param errores
	 *            Pagination
	 * @return Errores
	 */
	public Errores update(Errores errores) {
		String query = "UPDATE ERRORES SET SICODIGOERROR=?, SIIDMOVIMIENTO=?, SIREFERENCIA=?, SIIDTIPOMOV=?, SIFECHAERROR=?, SIFICHEROSIPCA=?, SIDATOERRONEO=?, SILINEA=?, SILINEAERROR=? WHERE SICODIGO=?";
		Object getTiposerroresSjcodigoAux = null;
		if (errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjcodigo() != null) {
			getTiposerroresSjcodigoAux = errores.getTiposerrores()
					.getSjcodigo();
		}
		Object getMovimientosSfcodigoAux = null;
		if (errores.getMovimientos() != null
				&& errores.getMovimientos().getSfcodigo() != null) {
			getMovimientosSfcodigoAux = errores.getMovimientos().getSfcodigo();
		}
		this.jdbcTemplate.update(query, getTiposerroresSjcodigoAux,
				getMovimientosSfcodigoAux, errores.getSireferencia(),
				errores.getSiidtipomov(), errores.getSifechaerror(),
				errores.getSificherosipca(), errores.getSidatoerroneo(),
				errores.getSilinea(), errores.getSilineaerror(),
				errores.getSicodigo());
		return errores;
	}

	/**
	 * Finds a single row in the Errores table.
	 * 
	 * @param errores
	 *            Pagination
	 * @return Errores
	 */
	@Transactional(readOnly = true)
	public Errores find(Errores errores) {
		String query = "SELECT t1.SICODIGO SICODIGO, t1.SIREFERENCIA SIREFERENCIA, t1.SIIDTIPOMOV SIIDTIPOMOV, t1.SIFECHAERROR SIFECHAERROR, t1.SIFICHEROSIPCA SIFICHEROSIPCA, t1.SIDATOERRONEO SIDATOERRONEO, t1.SILINEA SILINEA, t1.SILINEAERROR SILINEAERROR, t2.SJCODIGO TIPOSERRORESSJCODIGO, t2.SJCONSTANTE TIPOSERRORESSJCONSTANTE, t2.SJTEXTOES TIPOSERRORESSJTEXTOES, t2.SJTEXTOEU TIPOSERRORESSJTEXTOEU, t2.SJEXPLICACIONES TIPOSERRORESSJEXPLICACIONES, t2.SJEXPLICACIONEU TIPOSERRORESSJEXPLICACIONEU, t3.SFCODIGO MOVIMIENTOSSFCODIGO, t3.SFREFERENCIA MOVIMIENTOSSFREFERENCIA, t3.SFTIPOMOV MOVIMIENTOSSFTIPOMOV, t3.SFPERIODO MOVIMIENTOSSFPERIODO, t3.SFSENTIDO MOVIMIENTOSSFSENTIDO, t3.SFFECHAOPERACION MOVIMIENTOSSFFECHAOPERACION, t3.SFESTADOMOV MOVIMIENTOSSFESTADOMOV, t3.SFDETALLE MOVIMIENTOSSFDETALLE, t4.SECODIGO TIPOMOVIMIENTOSSECODIGO, t4.SEDESCES TIPOMOVIMIENTOSSEDESCES, t4.SEDESCEU TIPOMOVIMIENTOSSEDESCEU FROM ERRORES t1 , TIPOSERRORES t2 , MOVIMIENTOS t3, TIPOMOVIMIENTOS t4  WHERE t1.SICODIGO = ?   AND t1.SICODIGOERROR= t2.SJCODIGO(+) AND t1.SIIDMOVIMIENTO= t3.SFCODIGO(+) AND t1.SIIDTIPOMOV=t4.SECODIGO(+) ";

		List<Errores> erroresList = this.jdbcTemplate.query(query, this.rwMap,
				errores.getSicodigo());
		return (Errores) DataAccessUtils.uniqueResult(erroresList);
	}

	/**
	 * Removes a single row in the Errores table.
	 * 
	 * @param errores
	 *            Pagination
	 * @return
	 */
	public void remove(Errores errores) {
		String query = "DELETE FROM ERRORES WHERE SICODIGO=?";
		this.jdbcTemplate.update(query, errores.getSicodigo());
	}

	/**
	 * Finds a List of rows in the Errores table.
	 * 
	 * @param errores
	 *            Errores
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Errores> findAll(Errores errores, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SICODIGO SICODIGO,t1.SIREFERENCIA SIREFERENCIA,t1.SIIDTIPOMOV SIIDTIPOMOV,t1.SIFECHAERROR SIFECHAERROR,t1.SIFICHEROSIPCA SIFICHEROSIPCA,t1.SIDATOERRONEO SIDATOERRONEO,t1.SILINEA SILINEA,t1.SILINEAERROR SILINEAERROR,t2.SJCODIGO TIPOSERRORESSJCODIGO,t2.SJCONSTANTE TIPOSERRORESSJCONSTANTE,t2.SJTEXTOES TIPOSERRORESSJTEXTOES,t2.SJTEXTOEU TIPOSERRORESSJTEXTOEU,t2.SJEXPLICACIONES TIPOSERRORESSJEXPLICACIONES,t2.SJEXPLICACIONEU TIPOSERRORESSJEXPLICACIONEU,t3.SFCODIGO MOVIMIENTOSSFCODIGO,t3.SFREFERENCIA MOVIMIENTOSSFREFERENCIA,t3.SFTIPOMOV MOVIMIENTOSSFTIPOMOV,t3.SFPERIODO MOVIMIENTOSSFPERIODO,t3.SFSENTIDO MOVIMIENTOSSFSENTIDO,t3.SFFECHAOPERACION MOVIMIENTOSSFFECHAOPERACION,t3.SFESTADOMOV MOVIMIENTOSSFESTADOMOV,t3.SFDETALLE MOVIMIENTOSSFDETALLE, t4.SECODIGO TIPOMOVIMIENTOSSECODIGO, t4.SEDESCES TIPOMOVIMIENTOSSEDESCES, t4.SEDESCEU TIPOMOVIMIENTOSSEDESCEU ");
		query.append("FROM ERRORES t1 ,TIPOSERRORES t2 ,MOVIMIENTOS t3, TIPOMOVIMIENTOS t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(errores);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SICODIGOERROR= t2.SJCODIGO(+) AND t1.SIIDMOVIMIENTO= t3.SFCODIGO(+) AND t1.SIIDTIPOMOV=t4.SECODIGO(+)");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Errores>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Errores table.
	 * 
	 * @param errores
	 *            Errores
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Errores errores) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ERRORES t1 , TIPOSERRORES t2 , MOVIMIENTOS t3, TIPOMOVIMIENTOS t4  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(errores);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SICODIGOERROR= t2.SJCODIGO(+) AND t1.SIIDMOVIMIENTO= t3.SFCODIGO(+) AND t1.SIIDTIPOMOV=t4.SECODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Errores table using like.
	 * 
	 * @param errores
	 *            Errores
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Errores> findAllLike(Errores errores, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SICODIGO SICODIGO,t1.SIREFERENCIA SIREFERENCIA,t1.SIIDTIPOMOV SIIDTIPOMOV,t1.SIFECHAERROR SIFECHAERROR,t1.SIFICHEROSIPCA SIFICHEROSIPCA,t1.SIDATOERRONEO SIDATOERRONEO,t1.SILINEA SILINEA,t1.SILINEAERROR SILINEAERROR,t2.SJCODIGO TIPOSERRORESSJCODIGO,t2.SJCONSTANTE TIPOSERRORESSJCONSTANTE,t2.SJTEXTOES TIPOSERRORESSJTEXTOES,t2.SJTEXTOEU TIPOSERRORESSJTEXTOEU,t2.SJEXPLICACIONES TIPOSERRORESSJEXPLICACIONES,t2.SJEXPLICACIONEU TIPOSERRORESSJEXPLICACIONEU,t3.SFCODIGO MOVIMIENTOSSFCODIGO,t3.SFREFERENCIA MOVIMIENTOSSFREFERENCIA,t3.SFTIPOMOV MOVIMIENTOSSFTIPOMOV,t3.SFPERIODO MOVIMIENTOSSFPERIODO,t3.SFSENTIDO MOVIMIENTOSSFSENTIDO,t3.SFFECHAOPERACION MOVIMIENTOSSFFECHAOPERACION,t3.SFESTADOMOV MOVIMIENTOSSFESTADOMOV,t3.SFDETALLE MOVIMIENTOSSFDETALLE, t4.SECODIGO TIPOMOVIMIENTOSSECODIGO, t4.SEDESCES TIPOMOVIMIENTOSSEDESCES, t4.SEDESCEU TIPOMOVIMIENTOSSEDESCEU  ");
		query.append("FROM ERRORES t1 ,TIPOSERRORES t2 ,MOVIMIENTOS t3, TIPOMOVIMIENTOS t4  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(errores, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SICODIGOERROR= t2.SJCODIGO(+) AND t1.SIIDMOVIMIENTO= t3.SFCODIGO(+) AND t1.SIIDTIPOMOV=t4.SECODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Errores>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Errores table using like.
	 * 
	 * @param errores
	 *            Errores
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Errores errores, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ERRORES t1 ,TIPOSERRORES t2 ,MOVIMIENTOS t3, TIPOMOVIMIENTOS t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(errores, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SICODIGOERROR= t2.SJCODIGO(+) AND t1.SIIDMOVIMIENTO= t3.SFCODIGO(+) AND t1.SIIDTIPOMOV=t4.SECODIGO(+)  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Errores entity
	 * 
	 * @param errores
	 *            Errores Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Errores errores) {

		StringBuilder where = new StringBuilder(
				ErroresDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (errores != null && errores.getSicodigo() != null) {
			where.append(" AND t1.SICODIGO = ?");
			params.add(errores.getSicodigo());
		}
		if (errores != null && errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjcodigo() != null) {
			where.append(" AND t2.SJCODIGO = ?");
			params.add(errores.getTiposerrores().getSjcodigo());
		}
		if (errores != null && errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjconstante() != null) {
			where.append(" AND t2.SJCONSTANTE = ?");
			params.add(errores.getTiposerrores().getSjconstante());
		}
		if (errores != null && errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjtextoes() != null) {
			where.append(" AND t2.SJTEXTOES = ?");
			params.add(errores.getTiposerrores().getSjtextoes());
		}
		if (errores != null && errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjtextoeu() != null) {
			where.append(" AND t2.SJTEXTOEU = ?");
			params.add(errores.getTiposerrores().getSjtextoeu());
		}
		if (errores != null && errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjexplicaciones() != null) {
			where.append(" AND t2.SJEXPLICACIONES = ?");
			params.add(errores.getTiposerrores().getSjexplicaciones());
		}
		if (errores != null && errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjexplicacioneu() != null) {
			where.append(" AND t2.SJEXPLICACIONEU = ?");
			params.add(errores.getTiposerrores().getSjexplicacioneu());
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSfcodigo() != null) {
			where.append(" AND t3.SFCODIGO = ?");
			params.add(errores.getMovimientos().getSfcodigo());
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSfreferencia() != null) {
			where.append(" AND t3.SFREFERENCIA = ?");
			params.add(errores.getMovimientos().getSfreferencia());
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSftipomov() != null) {
			where.append(" AND t3.SFTIPOMOV = ?");
			params.add(errores.getMovimientos().getSftipomov());
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSfperiodo() != null) {
			where.append(" AND t3.SFPERIODO = ?");
			params.add(errores.getMovimientos().getSfperiodo());
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSfsentido() != null) {
			where.append(" AND t3.SFSENTIDO = ?");
			params.add(errores.getMovimientos().getSfsentido());
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSffechaoperacion() != null) {
			where.append(" AND t3.SFFECHAOPERACION = ?");
			params.add(errores.getMovimientos().getSffechaoperacion());
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSfestadomov() != null) {
			where.append(" AND t3.SFESTADOMOV = ?");
			params.add(errores.getMovimientos().getSfestadomov());
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSfdetalle() != null) {
			where.append(" AND t3.SFDETALLE = ?");
			params.add(errores.getMovimientos().getSfdetalle());
		}
		if (errores != null && errores.getSireferencia() != null) {
			where.append(" AND t1.SIREFERENCIA = ?");
			params.add(errores.getSireferencia());
		}
		if (errores != null && errores.getSiidtipomov() != null) {
			where.append(" AND t1.SIIDTIPOMOV = ?");
			params.add(errores.getSiidtipomov());
		}
		if (errores != null && errores.getSifechaerror() != null) {
			where.append(" AND t1.SIFECHAERROR = ?");
			params.add(errores.getSifechaerror());
		}
		if (errores != null && errores.getSificherosipca() != null) {
			where.append(" AND t1.SIFICHEROSIPCA = ?");
			params.add(errores.getSificherosipca());
		}
		if (errores != null && errores.getSidatoerroneo() != null) {
			where.append(" AND t1.SIDATOERRONEO = ?");
			params.add(errores.getSidatoerroneo());
		}
		if (errores != null && errores.getSilinea() != null) {
			where.append(" AND t1.SILINEA = ?");
			params.add(errores.getSilinea());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Errores entity
	 * 
	 * @param errores
	 *            Errores Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Errores errores, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ErroresDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (errores != null && errores.getSicodigo() != null) {
			where.append(" AND UPPER(t1.SICODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getSicodigo().toUpperCase() + "%");
			} else {
				params.add("%" + errores.getSicodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.SICODIGO IS NOT NULL");
		}
		// Diferencia entre errores de diseo y ejecucin
		if (errores != null && errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjcodigo() != null) {
			// Errores de diseo
			where.append(" AND t2.SJCODIGO = ?");
			params.add(errores.getTiposerrores().getSjcodigo());
		} else if (errores != null && errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjcodigo() == null) {
			// Errores de ejecucin
			where.append(" AND ( T2.SJCODIGO is null or t2.SJCODIGO != ? )");
			params.add(Y41bConstantes.ESTADO_PAGO_ERRORFICHERO);
		}
		if (errores != null && errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjconstante() != null) {
			where.append(" AND UPPER(t2.SJCONSTANTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getTiposerrores().getSjconstante()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ errores.getTiposerrores().getSjconstante()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.SJCONSTANTE IS NOT NULL");
		}
		if (errores != null && errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjtextoes() != null) {
			where.append(" AND UPPER(t2.SJTEXTOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getTiposerrores().getSjtextoes()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ errores.getTiposerrores().getSjtextoes()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.SJTEXTOES IS NOT NULL");
		}
		if (errores != null && errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjtextoeu() != null) {
			where.append(" AND UPPER(t2.SJTEXTOEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getTiposerrores().getSjtextoeu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ errores.getTiposerrores().getSjtextoeu()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.SJTEXTOEU IS NOT NULL");
		}
		if (errores != null && errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjexplicaciones() != null) {
			where.append(" AND UPPER(t2.SJEXPLICACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getTiposerrores().getSjexplicaciones()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ errores.getTiposerrores().getSjexplicaciones()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.SJEXPLICACIONES IS NOT NULL");
		}
		if (errores != null && errores.getTiposerrores() != null
				&& errores.getTiposerrores().getSjexplicacioneu() != null) {
			where.append(" AND UPPER(t2.SJEXPLICACIONEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getTiposerrores().getSjexplicacioneu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ errores.getTiposerrores().getSjexplicacioneu()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.SJEXPLICACIONEU IS NOT NULL");
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSfcodigo() != null) {
			where.append(" AND t3.SFCODIGO = ?");
			params.add(errores.getMovimientos().getSfcodigo());
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSfreferencia() != null) {
			where.append(" AND UPPER(t3.SFREFERENCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getMovimientos().getSfreferencia()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ errores.getMovimientos().getSfreferencia()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.SFREFERENCIA IS NOT NULL");
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSftipomov() != null) {
			where.append(" AND UPPER(t3.SFTIPOMOV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getMovimientos().getSftipomov()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ errores.getMovimientos().getSftipomov().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.SFTIPOMOV IS NOT NULL");
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSfperiodo() != null) {
			where.append(" AND UPPER(t3.SFPERIODO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getMovimientos().getSfperiodo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ errores.getMovimientos().getSfperiodo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.SFPERIODO IS NOT NULL");
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSfsentido() != null) {
			where.append(" AND UPPER(t3.SFSENTIDO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getMovimientos().getSfsentido()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ errores.getMovimientos().getSfsentido().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.SFSENTIDO IS NOT NULL");
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSffechaoperacion() != null) {
			where.append(" AND t3.SFFECHAOPERACION = ?");
			params.add(errores.getMovimientos().getSffechaoperacion());
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSfestadomov() != null) {
			where.append(" AND UPPER(t3.SFESTADOMOV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getMovimientos().getSfestadomov()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ errores.getMovimientos().getSfestadomov()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.SFESTADOMOV IS NOT NULL");
		}
		if (errores != null && errores.getMovimientos() != null
				&& errores.getMovimientos().getSfdetalle() != null) {
			where.append(" AND UPPER(t3.SFDETALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getMovimientos().getSfdetalle()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ errores.getMovimientos().getSfdetalle().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.SFDETALLE IS NOT NULL");
		}
		if (errores != null && errores.getSireferencia() != null) {
			where.append(" AND UPPER(t1.SIREFERENCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getSireferencia().toUpperCase() + "%");
			} else {
				params.add("%" + errores.getSireferencia().toUpperCase() + "%");
			}
			where.append(" AND t1.SIREFERENCIA IS NOT NULL");
		}
		if (errores != null && errores.getSiidtipomov() != null) {
			where.append(" AND UPPER(t1.SIIDTIPOMOV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getSiidtipomov().toUpperCase() + "%");
			} else {
				params.add("%" + errores.getSiidtipomov().toUpperCase() + "%");
			}
			where.append(" AND t1.SIIDTIPOMOV IS NOT NULL");
		}
		if (errores != null && errores.getSifechaerror() != null) {
			where.append(" AND t1.SIFECHAERROR = ?");
			params.add(errores.getSifechaerror());
		}
		if (errores != null && errores.getSifechaerrorDesde() != null) {
			where.append(" AND t1.SIFECHAERROR >= ?");
			params.add(errores.getSifechaerrorDesde());
		}
		if (errores != null && errores.getSifechaerrorHasta() != null) {
			where.append(" AND t1.SIFECHAERROR <= ?");
			params.add(errores.getSifechaerrorHasta());
		}
		if (errores != null && errores.getSificherosipca() != null) {
			where.append(" AND UPPER(t1.SIFICHEROSIPCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getSificherosipca().toUpperCase() + "%");
			} else {
				params.add("%" + errores.getSificherosipca().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SIFICHEROSIPCA IS NOT NULL");
		}
		if (errores != null && errores.getSidatoerroneo() != null) {
			where.append(" AND UPPER(t1.SIDATOERRONEO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(errores.getSidatoerroneo().toUpperCase() + "%");
			} else {
				params.add("%" + errores.getSidatoerroneo().toUpperCase() + "%");
			}
			where.append(" AND t1.SIDATOERRONEO IS NOT NULL");
		}
		if (errores != null && errores.getSilinea() != null) {
			where.append(" AND t1.SILINEA = ?");
			params.add(errores.getSilinea());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
