/**
 * 
 */
package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.EnviosPorRemesa;
import com.ejie.y41b.utils.jdbc.Y41bJdbcUtils;

/**
 *  
 * 
 */
@Repository
@Transactional
public class EnviosPorRemesaDaoImpl implements EnviosPorRemesaDao {
	private JdbcTemplate jdbcTemplate;

	private RowMapper<EnviosPorRemesa> rwMap = new RowMapper<EnviosPorRemesa>() {
		public EnviosPorRemesa mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EnviosPorRemesa(resultSet.getInt("ENVCIDENVIO"),
					resultSet.getString("EHCODIGO"),
					resultSet.getString("ENVCCODENVIO"),
					resultSet.getString("ENVCCODBARRAS"), null,
					resultSet.getString("ENVCESTADO"),
					resultSet.getString("ENVCDESERRORES"),
					resultSet.getString("ENVCDESERROREU"),
					resultSet.getString("ENVCCODSITCORREOS"),
					resultSet.getString("ENVCDESSITCORREOSES"),
					resultSet.getString("ENVCDESSITCORREOSEU"),
					resultSet.getString("ENVCCOMOEJECUCION"),
					resultSet.getDate("ENVFECHAACTUALIZACION"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return EnviosPorRemesa
	 */
	@Override
	public EnviosPorRemesa add(EnviosPorRemesa enviosPorRemesa) {
		String query = "INSERT INTO ENVIOS_POR_REMESA (ENVC_ID_ENVIO, EHCODIGO, ENVC_COD_ENVIO, ENVCCODBARRAS, ENVCCODBARRASFILE, ENVCESTADO, ENVCDESERRORES, ENVCDESERROREU, ENVCCOD_SIT_CORREOS, ENVCDES_SIT_CORREOS_ES, ENVCDES_SIT_CORREOS_EU, ENVCCOMOEJECUCION) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		this.jdbcTemplate.update(query, enviosPorRemesa.getEnvcIdEnvio(),
				enviosPorRemesa.getEhcodigo(), enviosPorRemesa
						.getEnvcCodEnvio(), enviosPorRemesa.getEnvccodbarras(),
				Y41bJdbcUtils.ConvertBlobToByte(enviosPorRemesa
						.getEnvccodbarrasfile()), enviosPorRemesa
						.getEnvcestado(), enviosPorRemesa.getEnvcdeserrores(),
				enviosPorRemesa.getEnvcdeserroreu(), enviosPorRemesa
						.getEnvccodSitCorreos(), enviosPorRemesa
						.getEnvcdesSitCorreosEs(), enviosPorRemesa
						.getEnvcdesSitCorreosEu(), enviosPorRemesa
						.getEnvccomoejecucion());
		return enviosPorRemesa;
	}

	/**
	 * Updates a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return EnviosPorRemesa
	 */
	@Override
	public EnviosPorRemesa update(EnviosPorRemesa enviosPorRemesa) {
		String query = "UPDATE ENVIOS_POR_REMESA SET EHCODIGO = ?, ENVC_COD_ENVIO = ?, ENVCCODBARRAS = ?, ENVCCODBARRASFILE = ?, ENVCESTADO = ?, ENVCDESERRORES = ?, ENVCDESERROREU = ?, ENVCCOD_SIT_CORREOS = ?, ENVCDES_SIT_CORREOS_ES = ?, ENVCDES_SIT_CORREOS_EU = ?, ENVCCOMOEJECUCION = ? WHERE ENVC_ID_ENVIO = ?";
		this.jdbcTemplate.update(query, enviosPorRemesa.getEhcodigo(),
				enviosPorRemesa.getEnvcCodEnvio(),
				enviosPorRemesa.getEnvccodbarras(),
				enviosPorRemesa.getEnvccodbarrasfile(),
				enviosPorRemesa.getEnvcestado(),
				enviosPorRemesa.getEnvcdeserrores(),
				enviosPorRemesa.getEnvcdeserroreu(),
				enviosPorRemesa.getEnvccodSitCorreos(),
				enviosPorRemesa.getEnvcdesSitCorreosEs(),
				enviosPorRemesa.getEnvcdesSitCorreosEu(),
				enviosPorRemesa.getEnvccomoejecucion(),
				enviosPorRemesa.getEnvcIdEnvio());
		return enviosPorRemesa;
	}

	/**
	 * Updates a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return EnviosPorRemesa
	 */
	@Override
	// TODO
	public EnviosPorRemesa updateSitCorreos(EnviosPorRemesa enviosPorRemesa) {
		String query = "UPDATE ENVIOS_POR_REMESA SET ENVCESTADO = ?, ENVCCOD_SIT_CORREOS = ?, ENVCDES_SIT_CORREOS_ES = ?, ENVCDES_SIT_CORREOS_EU = ?, ENVCDESERRORES = ?, ENVCDESERROREU = ? WHERE ENVC_ID_ENVIO = ?";
		this.jdbcTemplate.update(query, enviosPorRemesa.getEnvcestado(),
				enviosPorRemesa.getEnvccodSitCorreos(),
				enviosPorRemesa.getEnvcdesSitCorreosEs(),
				enviosPorRemesa.getEnvcdesSitCorreosEu(),
				enviosPorRemesa.getEnvcdeserrores(),
				enviosPorRemesa.getEnvcdeserroreu(),
				enviosPorRemesa.getEnvcIdEnvio());
		return enviosPorRemesa;
	}

	/**
	 * Updates a few columns of a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return EnviosPorRemesa
	 */
	@Override
	public EnviosPorRemesa updateError(EnviosPorRemesa enviosPorRemesa) {
		enviosPorRemesa
				.setEnvcestado(Y41bConstantes.AA66_ENVIO_SITUACION_ERROR);
		String query = "UPDATE ENVIOS_POR_REMESA SET ENVCDESERRORES = ?, ENVCDESERROREU = ?, ENVCESTADO = ? WHERE ENVC_ID_ENVIO = ?";
		this.jdbcTemplate
				.update(query,
						enviosPorRemesa.getEnvcdeserrores() == null ? ""
								: enviosPorRemesa.getEnvcdeserrores().length() <= 1000 ? enviosPorRemesa
										.getEnvcdeserrores() : enviosPorRemesa
										.getEnvcdeserrores().substring(0, 999),
						enviosPorRemesa.getEnvcdeserroreu() == null ? ""
								: enviosPorRemesa.getEnvcdeserroreu().length() <= 1000 ? enviosPorRemesa
										.getEnvcdeserroreu() : enviosPorRemesa
										.getEnvcdeserroreu().substring(0, 999),
						enviosPorRemesa.getEnvcestado(), enviosPorRemesa
								.getEnvcIdEnvio());
		return enviosPorRemesa;
	}

	/**
	 * Updates a few columns of a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return EnviosPorRemesa
	 */
	@Override
	public EnviosPorRemesa updateFechaActualizacionEnvioRemesa(
			EnviosPorRemesa enviosPorRemesa) {
		String query = "UPDATE ENVIOS_POR_REMESA SET ENVFECHAACTUALIZACION = SYSDATE WHERE ENVC_ID_ENVIO = ?";
		this.jdbcTemplate.update(query, enviosPorRemesa.getEnvcIdEnvio());
		return enviosPorRemesa;
	}

	/**
	 * Finds a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return EnviosPorRemesa
	 */
	@Override
	public EnviosPorRemesa findWithoutBlobByEhCodigo(
			EnviosPorRemesa enviosPorRemesa) {
		String query = "SELECT ENVC_ID_ENVIO ENVCIDENVIO, EHCODIGO, ENVCCOMOEJECUCION, ENVCDESERRORES, ENVCDESERROREU, ENVCCOD_SIT_CORREOS ENVCCODSITCORREOS, "
				+ "ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU, ENVCCODBARRAS, ENVC_COD_ENVIO ENVCCODENVIO, ENVCESTADO, ENVFECHAACTUALIZACION "
				+ "FROM ENVIOS_POR_REMESA WHERE EHCODIGO = ?";
		List<EnviosPorRemesa> enviosPorRemesaList = this.jdbcTemplate.query(
				query, this.rwMap, enviosPorRemesa.getEhcodigo());
		return (EnviosPorRemesa) DataAccessUtils
				.uniqueResult(enviosPorRemesaList);
	}

	/**
	 * Finds a List of rows in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Override
	public List<EnviosPorRemesa> findAll(EnviosPorRemesa enviosPorRemesa,
			Pagination pagination) {
		// TODO Cuando se necesite se desarrollar.
		return null;
	}

	/**
	 * Counts rows in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return Long
	 */
	@Override
	public Long findAllCount(EnviosPorRemesa enviosPorRemesa) {
		// TODO Cuando se necesite se desarrollar.
		return null;
	}

	/**
	 * Finds rows in the EnviosPorRemesa table using like.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Override
	public List<EnviosPorRemesa> findAllLike(EnviosPorRemesa enviosPorRemesa,
			Pagination pagination, Boolean startsWith) {
		// TODO Cuando se necesite se desarrollar.
		return null;
	}

	/**
	 * Counts rows in the EnviosPorRemesa table using like.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Override
	public Long findAllLikeCount(EnviosPorRemesa enviosPorRemesa,
			Boolean startsWith) {
		// TODO Cuando se necesite se desarrollar.
		return null;
	}

	/**
	 * Deletes a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return
	 */
	@Override
	public void remove(EnviosPorRemesa enviosPorRemesa) {
		this.jdbcTemplate.update(
				"DELETE FROM ENVIOS_POR_REMESA WHERE ENVC_ID_ENVIO = ?",
				enviosPorRemesa.getEnvcIdEnvio());
	}

	/**
	 * Deletes multiple rows in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesaList
	 *            List
	 * @return
	 */
	@Override
	public void removeMultiple(List<EnviosPorRemesa> enviosPorRemesaList) {
		// TODO Cuando se necesite se desarrollar.

	}

}
