package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.EnlacesDocumento;

/**
 * EnlacesDocumentoDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class EnlacesDocumentoDaoImpl implements EnlacesDocumentoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<EnlacesDocumento> rwMap = new RowMapper<EnlacesDocumento>() {
		public EnlacesDocumento mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EnlacesDocumento(resultSet.getString("ZRNTABLA"),
					resultSet.getString("ZRNCAMPO"),
					resultSet.getString("ZRVCAMPO"),
					resultSet.getString("ZROBJETO"),
					resultSet.getString("ZRDESCRI"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            Pagination
	 * @return EnlacesDocumento
	 */
	public EnlacesDocumento add(EnlacesDocumento enlacesDocumento) {
		String query = "INSERT INTO ENLACESDOCUMENTO (ZRNTABLA, ZRNCAMPO, ZRVCAMPO, ZROBJETO, ZRDESCRI) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, enlacesDocumento.getZrntabla(),
				enlacesDocumento.getZrncampo(), enlacesDocumento.getZrvcampo(),
				enlacesDocumento.getZrobjeto(), enlacesDocumento.getZrdescri());
		return enlacesDocumento;
	}

	/**
	 * Updates a single row in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            Pagination
	 * @return EnlacesDocumento
	 */
	public EnlacesDocumento update(EnlacesDocumento enlacesDocumento) {
		String query = "UPDATE ENLACESDOCUMENTO SET  WHERE ZRNTABLA=? AND ZRNCAMPO=? AND ZRVCAMPO=? AND ZROBJETO=? AND ZRDESCRI=?";
		this.jdbcTemplate.update(query, enlacesDocumento.getZrntabla(),
				enlacesDocumento.getZrncampo(), enlacesDocumento.getZrvcampo(),
				enlacesDocumento.getZrobjeto(), enlacesDocumento.getZrdescri());
		return enlacesDocumento;
	}

	/**
	 * Finds a single row in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            Pagination
	 * @return EnlacesDocumento
	 */
	@Transactional(readOnly = true)
	public EnlacesDocumento find(EnlacesDocumento enlacesDocumento) {
		String query = "SELECT t1.ZRNTABLA ZRNTABLA, t1.ZRNCAMPO ZRNCAMPO, t1.ZRVCAMPO ZRVCAMPO, t1.ZROBJETO ZROBJETO, t1.ZRDESCRI ZRDESCRI FROM ENLACESDOCUMENTO t1  WHERE t1.ZRNTABLA = ?   AND t1.ZRNCAMPO = ?   AND t1.ZRVCAMPO = ?   AND t1.ZROBJETO = ?   AND t1.ZRDESCRI = ?  ";

		List<EnlacesDocumento> enlacesDocumentoList = this.jdbcTemplate.query(
				query, this.rwMap, enlacesDocumento.getZrntabla(),
				enlacesDocumento.getZrncampo(), enlacesDocumento.getZrvcampo(),
				enlacesDocumento.getZrobjeto(), enlacesDocumento.getZrdescri());
		return (EnlacesDocumento) DataAccessUtils
				.uniqueResult(enlacesDocumentoList);
	}

	/**
	 * Removes a single row in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            Pagination
	 * @return
	 */
	public void remove(EnlacesDocumento enlacesDocumento) {
		String query = "DELETE FROM ENLACESDOCUMENTO WHERE ZRNTABLA=? AND ZRNCAMPO=? AND ZRVCAMPO=? AND ZROBJETO=? AND ZRDESCRI=?";
		this.jdbcTemplate.update(query, enlacesDocumento.getZrntabla(),
				enlacesDocumento.getZrncampo(), enlacesDocumento.getZrvcampo(),
				enlacesDocumento.getZrobjeto(), enlacesDocumento.getZrdescri());
	}

	/**
	 * Finds a List of rows in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EnlacesDocumento> findAll(EnlacesDocumento enlacesDocumento,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ZRNTABLA ZRNTABLA,t1.ZRNCAMPO ZRNCAMPO,t1.ZRVCAMPO ZRVCAMPO,t1.ZROBJETO ZROBJETO,t1.ZRDESCRI ZRDESCRI ");
		query.append("FROM ENLACESDOCUMENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(enlacesDocumento);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<EnlacesDocumento>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(EnlacesDocumento enlacesDocumento) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ENLACESDOCUMENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(enlacesDocumento);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the EnlacesDocumento table using like.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EnlacesDocumento> findAllLike(
			EnlacesDocumento enlacesDocumento, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ZRNTABLA ZRNTABLA,t1.ZRNCAMPO ZRNCAMPO,t1.ZRVCAMPO ZRVCAMPO,t1.ZROBJETO ZROBJETO,t1.ZRDESCRI ZRDESCRI ");
		query.append("FROM ENLACESDOCUMENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(enlacesDocumento,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<EnlacesDocumento>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the EnlacesDocumento table using like.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(EnlacesDocumento enlacesDocumento,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ENLACESDOCUMENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(enlacesDocumento,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the EnlacesDocumento entity
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(EnlacesDocumento enlacesDocumento) {

		StringBuilder where = new StringBuilder(
				EnlacesDocumentoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (enlacesDocumento != null && enlacesDocumento.getZrntabla() != null) {
			where.append(" AND t1.ZRNTABLA = ?");
			params.add(enlacesDocumento.getZrntabla());
		}
		if (enlacesDocumento != null && enlacesDocumento.getZrncampo() != null) {
			where.append(" AND t1.ZRNCAMPO = ?");
			params.add(enlacesDocumento.getZrncampo());
		}
		if (enlacesDocumento != null && enlacesDocumento.getZrvcampo() != null) {
			where.append(" AND t1.ZRVCAMPO = ?");
			params.add(enlacesDocumento.getZrvcampo());
		}
		if (enlacesDocumento != null && enlacesDocumento.getZrobjeto() != null) {
			where.append(" AND t1.ZROBJETO = ?");
			params.add(enlacesDocumento.getZrobjeto());
		}
		if (enlacesDocumento != null && enlacesDocumento.getZrdescri() != null) {
			where.append(" AND t1.ZRDESCRI = ?");
			params.add(enlacesDocumento.getZrdescri());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the EnlacesDocumento entity
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(EnlacesDocumento enlacesDocumento,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				EnlacesDocumentoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (enlacesDocumento != null && enlacesDocumento.getZrntabla() != null) {
			where.append(" AND UPPER(t1.ZRNTABLA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(enlacesDocumento.getZrntabla().toUpperCase() + "%");
			} else {
				params.add("%" + enlacesDocumento.getZrntabla().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ZRNTABLA IS NOT NULL");
		}
		if (enlacesDocumento != null && enlacesDocumento.getZrncampo() != null) {
			where.append(" AND UPPER(t1.ZRNCAMPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(enlacesDocumento.getZrncampo().toUpperCase() + "%");
			} else {
				params.add("%" + enlacesDocumento.getZrncampo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ZRNCAMPO IS NOT NULL");
		}
		if (enlacesDocumento != null && enlacesDocumento.getZrvcampo() != null) {
			where.append(" AND UPPER(t1.ZRVCAMPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(enlacesDocumento.getZrvcampo().toUpperCase() + "%");
			} else {
				params.add("%" + enlacesDocumento.getZrvcampo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ZRVCAMPO IS NOT NULL");
		}
		if (enlacesDocumento != null && enlacesDocumento.getZrobjeto() != null) {
			where.append(" AND UPPER(t1.ZROBJETO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(enlacesDocumento.getZrobjeto().toUpperCase() + "%");
			} else {
				params.add("%" + enlacesDocumento.getZrobjeto().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ZROBJETO IS NOT NULL");
		}
		if (enlacesDocumento != null && enlacesDocumento.getZrdescri() != null) {
			where.append(" AND UPPER(t1.ZRDESCRI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(enlacesDocumento.getZrdescri().toUpperCase() + "%");
			} else {
				params.add("%" + enlacesDocumento.getZrdescri().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ZRDESCRI IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
