package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.EnlacesDocumento;

/**
 * EnlacesDocumentoDao  
 * 
 *  
 */

public interface EnlacesDocumentoDao {

	/**
	 * Inserts a single row in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @return EnlacesDocumento
	 */
	EnlacesDocumento add(EnlacesDocumento enlacesDocumento);

	/**
	 * Updates a single row in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @return EnlacesDocumento
	 */
	EnlacesDocumento update(EnlacesDocumento enlacesDocumento);

	/**
	 * Finds a single row in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @return EnlacesDocumento
	 */
	EnlacesDocumento find(EnlacesDocumento enlacesDocumento);

	/**
	 * Deletes a single row in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @return
	 */
	void remove(EnlacesDocumento enlacesDocumento);

	/**
	 * Finds a List of rows in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EnlacesDocumento> findAll(EnlacesDocumento enlacesDocumento,
			Pagination pagination);

	/**
	 * Counts rows in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @return Long
	 */
	Long findAllCount(EnlacesDocumento enlacesDocumento);

	/**
	 * Finds rows in the EnlacesDocumento table using like.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<EnlacesDocumento> findAllLike(EnlacesDocumento enlacesDocumento,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the EnlacesDocumento table using like.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(EnlacesDocumento enlacesDocumento, Boolean startsWith);
}
