package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Empper;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * EmpperDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class EmpperDaoImpl implements EmpperDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Empper> rwMap = new RowMapper<Empper>() {
		public Empper mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Empper empper = new Empper(resultSet.getString("PECODIGO"),
					resultSet.getString("PECIF"),
					resultSet.getString("PENOMBRE"),
					resultSet.getString("PENODIR"),
					resultSet.getString("PECOLO"),
					resultSet.getString("PENOLO"),
					resultSet.getString("PENRCOPO"),
					resultSet.getString("PECOPV"),
					resultSet.getString("PENOPV"),
					resultSet.getString("PENRTEL"),
					resultSet.getString("PENRTEL2"),
					resultSet.getString("PENRFAX"),
					resultSet.getString("PETEEM"),
					resultSet.getString("PETEURL"),
					resultSet.getString("PECOES"), resultSet.getDate("PEFEBA"),
					resultSet.getString("PETEOBS"),
					resultSet.getString("PECOJA"),
					resultSet.getString("PECOZS"),
					resultSet.getString("PEFEMOD"),
					resultSet.getString("PEPROVID"),
					resultSet.getString("PEMUNID"),
					resultSet.getString("PELOCID"),
					resultSet.getString("PECALLEID"),
					resultSet.getString("PEPORTALID"),
					resultSet.getDate("PEFECALTA"),
					resultSet.getString("PEUSUALTA"));
			empper.setPeThActs(resultSet.getString("PETHACTS"));
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEsnombre(resultSet
					.getString("EstablecimientoESNOMBRE"));
			establecimiento.setEscodigo(resultSet
					.getString("EstablecimientoESCODIGO"));
			empper.setEstablecimiento(establecimiento);
			empper.setPenombrePiso(resultSet.getString("PENOMBRE_PISO"));
			empper.setPenombreCp(resultSet.getString("PENOMBRE_CP"));
			return empper;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Empper table.
	 * 
	 * @param empper
	 *            Pagination
	 * @return Empper
	 */
	public Empper add(Empper empper) {
		String query = "INSERT INTO EMPPER (PECODIGO, PECIF, PENOMBRE, PENODIR, PECOLO, PENOLO, PENRCOPO, PECOPV, PENOPV, PENRTEL, PENRTEL2, PENRFAX, PETEEM, PETEURL, PECOES, PEFEBA, PETEOBS, PECOJA, PEPROV_ID, PEMUN_ID, PELOC_ID, PECALLE_ID, PEPORTAL_ID,PENOMBRE_PISO,PENOMBRE_CP) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, empper.getPecodigo(),
				empper.getPecif(), empper.getPenombre(), empper.getPenodir(),
				empper.getPecolo(), empper.getPenolo(), empper.getPenrcopo(),
				empper.getPecopv(), empper.getPenopv(), empper.getPenrtel(),
				empper.getPenrtel2(), empper.getPenrfax(), empper.getPeteem(),
				empper.getPeteurl(), empper.getPecoes(), empper.getPefeba(),
				empper.getPeteobs(), empper.getPecoja(), empper.getPeprovId(),
				empper.getPemunId(), empper.getPelocId(),
				empper.getPecalleId(), empper.getPeportalId(),
				empper.getPenombrePiso(), empper.getPenombreCp());
		return empper;
	}

	/**
	 * Updates a single row in the Empper table.
	 * 
	 * @param empper
	 *            Pagination
	 * @return Empper
	 */
	public Empper update(Empper empper) {
		String query = "UPDATE EMPPER SET PECIF=?, PENOMBRE=?, /*PENODIR=?, PECOLO=?, PENOLO=?, PENRCOPO=?, PECOPV=?, PENOPV=?,*/ PENRTEL=?, PENRTEL2=?, PENRFAX=?, PETEEM=?, PETEURL=?, PECOES=?, PEFEBA=?, PETEOBS=?, PECOJA=?, PEPROV_ID=?, PEMUN_ID=?, PELOC_ID=?, PECALLE_ID=?, PEPORTAL_ID=?, PENOMBRE_PISO=?, PENOMBRE_CP=? WHERE PECODIGO=?";
		this.jdbcTemplate.update(query, empper.getPecif(),
				empper.getPenombre(),/*
									 * empper.getPenodir(), empper.getPecolo(),
									 * empper.getPenolo(), empper.getPenrcopo(),
									 * empper.getPecopv(), empper.getPenopv(),
									 */empper.getPenrtel(),
				empper.getPenrtel2(), empper.getPenrfax(), empper.getPeteem(),
				empper.getPeteurl(), empper.getPecoes(), empper.getPefeba(),
				empper.getPeteobs(), empper.getPecoja(), empper.getPeprovId(),
				empper.getPemunId(), empper.getPelocId(),
				empper.getPecalleId(), empper.getPeportalId(),
				empper.getPenombrePiso(), empper.getPenombreCp(),
				empper.getPecodigo());
		return empper;
	}

	/**
	 * Finds a single row in the Empper table.
	 * 
	 * @param empper
	 *            Pagination
	 * @return Empper
	 */
	@Transactional(readOnly = true)
	public Empper find(Empper empper) {
		String query = "SELECT t1.PECODIGO PECODIGO, t1.PECIF PECIF, t1.PENOMBRE PENOMBRE, t1.PENODIR PENODIR, t1.PECOLO PECOLO, t1.PENOLO PENOLO, t1.PENRCOPO PENRCOPO, t1.PECOPV PECOPV, t1.PENOPV PENOPV, t1.PENRTEL PENRTEL, t1.PENRTEL2 PENRTEL2, t1.PENRFAX PENRFAX, t1.PETEEM PETEEM, t1.PETEURL PETEURL, t1.PECOES PECOES, t1.PEFEBA PEFEBA, t1.PETEOBS PETEOBS, t1.PECOJA PECOJA, t2.USUARIOXLNET PECOZS, t1.PEFEMOD PEFEMOD, t1.PEPROV_ID PEPROVID, t1.PEMUN_ID PEMUNID, t1.PELOC_ID PELOCID, t1.PECALLE_ID PECALLEID, t1.PEPORTAL_ID PEPORTALID, t1.PEFECALTA PEFECALTA, t1.PEUSUALTA PEUSUALTA,PENOMBRE_PISO,PENOMBRE_CP, '' PETHACTS, '' EstablecimientoESNOMBRE, t3.ESCODIGO EstablecimientoESCODIGO FROM EMPPER t1,CENSO_MONITOR t2, ESTABLECIMIENTO t3  WHERE t1.PECOZS=t2.MOCODIGO(+) AND t1.PECOES=t3.ESCODIGO(+) AND t1.PECODIGO = ?  ";

		List<Empper> empperList = this.jdbcTemplate.query(query, this.rwMap,
				empper.getPecodigo());
		return (Empper) DataAccessUtils.uniqueResult(empperList);
	}

	/**
	 * Removes a single row in the Empper table.
	 * 
	 * @param empper
	 *            Pagination
	 * @return
	 */
	public void remove(Empper empper) {
		String query = "DELETE FROM EMPPER WHERE PECODIGO=?";
		this.jdbcTemplate.update(query, empper.getPecodigo());
	}

	/**
	 * Finds a List of rows in the Empper table.
	 * 
	 * @param empper
	 *            Empper
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Empper> findAll(Empper empper, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  DISTINCT t1.PECODIGO PECODIGO,t1.PECIF PECIF,t1.PENOMBRE PENOMBRE,t1.PENODIR PENODIR,t1.PECOLO PECOLO,t1.PENOLO PENOLO,t1.PENRCOPO PENRCOPO,t1.PECOPV PECOPV,t1.PENOPV PENOPV,t1.PENRTEL PENRTEL,t1.PENRTEL2 PENRTEL2,t1.PENRFAX PENRFAX,t1.PETEEM PETEEM,t1.PETEURL PETEURL,t1.PECOES PECOES,t1.PEFEBA PEFEBA,t1.PETEOBS PETEOBS,t1.PECOJA PECOJA,t1.PECOZS PECOZS,t1.PEFEMOD PEFEMOD,t1.PEPROV_ID PEPROVID,t1.PEMUN_ID PEMUNID,t1.PELOC_ID PELOCID,t1.PECALLE_ID PECALLEID,t1.PEPORTAL_ID PEPORTALID,t1.PEFECALTA PEFECALTA,t1.PEUSUALTA PEUSUALTA,PENOMBRE_PISO,PENOMBRE_CP ");
		query.append(", t4.ESCODIGO EstablecimientoESCODIGO, t4.ESNOMBRE EstablecimientoESNOMBRE ");
		query.append(",CASE WHEN t6.TA1NOMBRE!='-' then replace('<ul style=\"list-style:disc inside none\"><li>'||replace(CASE WHEN instr(t6.TA1NOMBRE,'@',-1,1)=length(t6.TA1NOMBRE) THEN substr(t6.TA1NOMBRE,0,length(t6.TA1NOMBRE)-2) ELSE t6.TA1NOMBRE END,'@','</li><li>')||'</li></ul>','<ul><li></li></ul>','') else ' ' end PETHACTS");
		query.append(" FROM EMPPER t1, PESE t2, PETA1 t3, ESTABLECIMIENTO t4, ESTABLECIM_SECTOR t5 ");
		query.append(" ,( SELECT M7COPE, ");
		query.append(" SUBSTR(REGEXP_REPLACE(SYS_CONNECT_BY_PATH(TA1NOMBRE, '@'), '(@){1,}', '@'),2) TA1NOMBRE ");
		query.append(" FROM (select M7COPE,TA1NOMBRE, ");
		query.append(" count(*) OVER ( partition by M7COPE ) cnt, ");
		query.append(" ROW_NUMBER () OVER ( partition by M7COPE order by TA1NOMBRE asc) seq  ");
		query.append(" from (SELECT M7COPE, TA1NOMBRE ");
		query.append(" FROM PETA1, TCTERRIT ");
		query.append(" where M7COTA1=TA1CODIGO) H ) ");
		query.append(" where seq=cnt start with seq=1 connect by prior seq+1=seq and prior M7COPE=M7COPE) t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(empper);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PECODIGO=t2.M8COPE(+) AND t1.PECODIGO=t3.M7COPE(+) AND t1.PECOES=t4.ESCODIGO(+) AND t1.PECOES=t5.EACOES(+) AND t1.PECODIGO=t6.M7COPE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Empper>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Empper table.
	 * 
	 * @param empper
	 *            Empper
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Empper empper) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(DISTINCT PECODIGO) FROM EMPPER t1 , PESE t2, PETA1 t3, ESTABLECIMIENTO t4, ESTABLECIM_SECTOR t5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(empper);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PECODIGO=t2.M8COPE(+) AND t1.PECODIGO=t3.M7COPE(+) AND t1.PECOES=t4.ESCODIGO(+) AND t1.PECOES=t5.EACOES(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Empper table using like.
	 * 
	 * @param empper
	 *            Empper
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Empper> findAllLike(Empper empper, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PECODIGO PECODIGO,t1.PECIF PECIF,t1.PENOMBRE PENOMBRE,t1.PENODIR PENODIR,t1.PECOLO PECOLO,t1.PENOLO PENOLO,t1.PENRCOPO PENRCOPO,t1.PECOPV PECOPV,t1.PENOPV PENOPV,t1.PENRTEL PENRTEL,t1.PENRTEL2 PENRTEL2,t1.PENRFAX PENRFAX,t1.PETEEM PETEEM,t1.PETEURL PETEURL,t1.PECOES PECOES,t1.PEFEBA PEFEBA,t1.PETEOBS PETEOBS,t1.PECOJA PECOJA,t1.PECOZS PECOZS,t1.PEFEMOD PEFEMOD,t1.PEPROV_ID PEPROVID,t1.PEMUN_ID PEMUNID,t1.PELOC_ID PELOCID,t1.PECALLE_ID PECALLEID,t1.PEPORTAL_ID PEPORTALID,t1.PEFECALTA PEFECALTA,t1.PEUSUALTA PEUSUALTA,PENOMBRE_PISO,PENOMBRE_CP ");
		query.append(", '' PETHACTS, '' EstablecimientoESCODIGO, '' EstablecimientoESNOMBRE ");
		query.append("FROM EMPPER t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(empper, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Empper>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Empper table using like.
	 * 
	 * @param empper
	 *            Empper
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Empper empper, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM EMPPER t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(empper, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Empper entity
	 * 
	 * @param empper
	 *            Empper Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Empper empper) {

		StringBuilder where = new StringBuilder(
				EmpperDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (empper != null && !Y41bUtils.esNullOCadenaVacia(empper.getPecif())) {
			where.append(" AND TRANSLATE(UPPER(t1.PECIF),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ empper.getPecif().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I")
							.replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.PECIF is not null");
		}
		if (empper != null
				&& !Y41bUtils.esNullOCadenaVacia(empper.getPenombre())) {
			where.append(" AND TRANSLATE(UPPER(t1.PENOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ empper.getPenombre().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I")
							.replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.PENOMBRE is not null");
		}
		// Sector
		if (empper != null
				&& !Y41bUtils.esNullOCadenaVacia(empper.getPesecodigo())) {
			where.append(" AND (t2.M8COSE = ? OR t5.EACOSE = ? ) ");
			params.add(empper.getPesecodigo());
			params.add(empper.getPesecodigo());
		}
		// Territorio de actuacion
		if (empper != null
				&& (!Y41bUtils.esNullOCadenaVacia(empper.getPeThActAraba())
						|| !Y41bUtils.esNullOCadenaVacia(empper
								.getPeThActBizkaia()) || !Y41bUtils
						.esNullOCadenaVacia(empper.getPeThActGipuzkoa()))) {
			where.append(" AND ( ");
			if (empper != null
					&& !Y41bUtils.esNullOCadenaVacia(empper.getPeThActAraba())) {
				where.append(" t3.M7COTA1 = ? ");
				params.add(empper.getPeThActAraba());
			}
			if (empper != null
					&& !Y41bUtils
							.esNullOCadenaVacia(empper.getPeThActBizkaia())) {
				if (empper != null
						&& !Y41bUtils.esNullOCadenaVacia(empper
								.getPeThActAraba())) {
					where.append(" OR ");
				}
				where.append(" t3.M7COTA1 = ? ");
				params.add(empper.getPeThActBizkaia());
			}
			if (empper != null
					&& !Y41bUtils.esNullOCadenaVacia(empper
							.getPeThActGipuzkoa())) {
				if (empper != null
						&& (!Y41bUtils.esNullOCadenaVacia(empper
								.getPeThActAraba()) || !Y41bUtils
								.esNullOCadenaVacia(empper.getPeThActBizkaia()))) {
					where.append(" OR ");
				}
				where.append(" t3.M7COTA1 = ? ");
				params.add(empper.getPeThActGipuzkoa());
			}
			where.append(" ) ");
		}

		if (empper != null && empper.getBaja() != null) {
			if (Y41bConstantes.VALOR_NO.equals(empper.getBaja())) {
				where.append(" AND (t1.PEFEBA IS NULL OR ( t1.PEFEBA IS NOT NULL AND t1.PEFEBA >sysdate)) ");
			} else if (Y41bConstantes.VALOR_SI.equals(empper.getBaja())) {
				where.append(" AND (t1.PEFEBA IS NOT NULL AND t1.PEFEBA <=sysdate) ");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Empper entity
	 * 
	 * @param empper
	 *            Empper Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Empper empper, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				EmpperDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (empper != null && empper.getPecodigo() != null) {
			where.append(" AND UPPER(t1.PECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PECODIGO IS NOT NULL");
		}
		if (empper != null && empper.getPecif() != null) {
			where.append(" AND UPPER(t1.PECIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPecif().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPecif().toUpperCase() + "%");
			}
			where.append(" AND t1.PECIF IS NOT NULL");
		}
		if (empper != null && empper.getPenombre() != null) {
			where.append(" AND UPPER(t1.PENOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPenombre().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPenombre().toUpperCase() + "%");
			}
			where.append(" AND t1.PENOMBRE IS NOT NULL");
		}
		if (empper != null && empper.getPenodir() != null) {
			where.append(" AND UPPER(t1.PENODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPenodir().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPenodir().toUpperCase() + "%");
			}
			where.append(" AND t1.PENODIR IS NOT NULL");
		}
		if (empper != null && empper.getPecolo() != null) {
			where.append(" AND UPPER(t1.PECOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPecolo().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPecolo().toUpperCase() + "%");
			}
			where.append(" AND t1.PECOLO IS NOT NULL");
		}
		if (empper != null && empper.getPenolo() != null) {
			where.append(" AND UPPER(t1.PENOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPenolo().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPenolo().toUpperCase() + "%");
			}
			where.append(" AND t1.PENOLO IS NOT NULL");
		}
		if (empper != null && empper.getPenrcopo() != null) {
			where.append(" AND UPPER(t1.PENRCOPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPenrcopo().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPenrcopo().toUpperCase() + "%");
			}
			where.append(" AND t1.PENRCOPO IS NOT NULL");
		}
		if (empper != null && empper.getPecopv() != null) {
			where.append(" AND UPPER(t1.PECOPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPecopv().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPecopv().toUpperCase() + "%");
			}
			where.append(" AND t1.PECOPV IS NOT NULL");
		}
		if (empper != null && empper.getPenopv() != null) {
			where.append(" AND UPPER(t1.PENOPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPenopv().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPenopv().toUpperCase() + "%");
			}
			where.append(" AND t1.PENOPV IS NOT NULL");
		}
		if (empper != null && empper.getPenrtel() != null) {
			where.append(" AND UPPER(t1.PENRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPenrtel().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPenrtel().toUpperCase() + "%");
			}
			where.append(" AND t1.PENRTEL IS NOT NULL");
		}
		if (empper != null && empper.getPenrtel2() != null) {
			where.append(" AND UPPER(t1.PENRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPenrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPenrtel2().toUpperCase() + "%");
			}
			where.append(" AND t1.PENRTEL2 IS NOT NULL");
		}
		if (empper != null && empper.getPenrfax() != null) {
			where.append(" AND UPPER(t1.PENRFAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPenrfax().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPenrfax().toUpperCase() + "%");
			}
			where.append(" AND t1.PENRFAX IS NOT NULL");
		}
		if (empper != null && empper.getPeteem() != null) {
			where.append(" AND UPPER(t1.PETEEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPeteem().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPeteem().toUpperCase() + "%");
			}
			where.append(" AND t1.PETEEM IS NOT NULL");
		}
		if (empper != null && empper.getPeteurl() != null) {
			where.append(" AND UPPER(t1.PETEURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPeteurl().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPeteurl().toUpperCase() + "%");
			}
			where.append(" AND t1.PETEURL IS NOT NULL");
		}
		if (empper != null && empper.getPecoes() != null) {
			where.append(" AND UPPER(t1.PECOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPecoes().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPecoes().toUpperCase() + "%");
			}
			where.append(" AND t1.PECOES IS NOT NULL");
		}
		if (empper != null && empper.getPefeba() != null) {
			where.append(" AND t1.PEFEBA = ?");
			params.add(empper.getPefeba());
		}
		if (empper != null && empper.getPeteobs() != null) {
			where.append(" AND UPPER(t1.PETEOBS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPeteobs().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPeteobs().toUpperCase() + "%");
			}
			where.append(" AND t1.PETEOBS IS NOT NULL");
		}
		if (empper != null && empper.getPecoja() != null) {
			where.append(" AND UPPER(t1.PECOJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPecoja().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPecoja().toUpperCase() + "%");
			}
			where.append(" AND t1.PECOJA IS NOT NULL");
		}
		if (empper != null && empper.getPecozs() != null) {
			where.append(" AND UPPER(t1.PECOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPecozs().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPecozs().toUpperCase() + "%");
			}
			where.append(" AND t1.PECOZS IS NOT NULL");
		}
		if (empper != null && empper.getPefemod() != null) {
			where.append(" AND UPPER(t1.PEFEMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPefemod().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPefemod().toUpperCase() + "%");
			}
			where.append(" AND t1.PEFEMOD IS NOT NULL");
		}
		if (empper != null && empper.getPeprovId() != null) {
			where.append(" AND UPPER(t1.PEPROV_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPeprovId().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPeprovId().toUpperCase() + "%");
			}
			where.append(" AND t1.PEPROV_ID IS NOT NULL");
		}
		if (empper != null && empper.getPemunId() != null) {
			where.append(" AND UPPER(t1.PEMUN_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPemunId().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPemunId().toUpperCase() + "%");
			}
			where.append(" AND t1.PEMUN_ID IS NOT NULL");
		}
		if (empper != null && empper.getPelocId() != null) {
			where.append(" AND UPPER(t1.PELOC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPelocId().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPelocId().toUpperCase() + "%");
			}
			where.append(" AND t1.PELOC_ID IS NOT NULL");
		}
		if (empper != null && empper.getPecalleId() != null) {
			where.append(" AND UPPER(t1.PECALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPecalleId().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPecalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.PECALLE_ID IS NOT NULL");
		}
		if (empper != null && empper.getPeportalId() != null) {
			where.append(" AND UPPER(t1.PEPORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPeportalId().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPeportalId().toUpperCase() + "%");
			}
			where.append(" AND t1.PEPORTAL_ID IS NOT NULL");
		}
		if (empper != null && empper.getPefecalta() != null) {
			where.append(" AND t1.PEFECALTA = ?");
			params.add(empper.getPefecalta());
		}
		if (empper != null && empper.getPeusualta() != null) {
			where.append(" AND UPPER(t1.PEUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(empper.getPeusualta().toUpperCase() + "%");
			} else {
				params.add("%" + empper.getPeusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.PEUSUALTA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT L21C7Q00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
