package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Empper;

/**
 * EmpperDao  
 * 
 *  
 */

public interface EmpperDao {

	/**
	 * Inserts a single row in the Empper table.
	 * 
	 * @param empper
	 *            Empper
	 * @return Empper
	 */
	Empper add(Empper empper);

	/**
	 * Updates a single row in the Empper table.
	 * 
	 * @param empper
	 *            Empper
	 * @return Empper
	 */
	Empper update(Empper empper);

	/**
	 * Finds a single row in the Empper table.
	 * 
	 * @param empper
	 *            Empper
	 * @return Empper
	 */
	Empper find(Empper empper);

	/**
	 * Deletes a single row in the Empper table.
	 * 
	 * @param empper
	 *            Empper
	 * @return
	 */
	void remove(Empper empper);

	/**
	 * Finds a List of rows in the Empper table.
	 * 
	 * @param empper
	 *            Empper
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Empper> findAll(Empper empper, Pagination pagination);

	/**
	 * Counts rows in the Empper table.
	 * 
	 * @param empper
	 *            Empper
	 * @return Long
	 */
	Long findAllCount(Empper empper);

	/**
	 * Finds rows in the Empper table using like.
	 * 
	 * @param empper
	 *            Empper
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Empper> findAllLike(Empper empper, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Empper table using like.
	 * 
	 * @param empper
	 *            Empper
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Empper empper, Boolean startsWith);

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	Long getNewPK();
}
