package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.Solarb;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Dtsa;

/**
 * DtsaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DtsaDaoImpl implements DtsaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Dtsa> rwMap = new RowMapper<Dtsa>() {
		public Dtsa mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Dtsa(new Consumidor(resultSet.getString("M9CODT")),
					new Solarb(resultSet.getString("M9COSA")),
					resultSet.getString("M9INREDT"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Pagination
	 * @return Dtsa
	 */
	public Dtsa add(Dtsa dtsa) {
		String query = "INSERT INTO DTSA (M9CODT, M9COSA, M9INREDT) VALUES (?,?,?)";
		Object SolarbSacodigoAux = null;
		Object ConsumidorDtcodigoAux = null;
		if (dtsa.getSolarb() != null && dtsa.getSolarb().getSacodigo() != null) {
			SolarbSacodigoAux = dtsa.getSolarb().getSacodigo();
		}
		if (dtsa.getConsumidor() != null
				&& dtsa.getConsumidor().getDtcodigo() != null) {
			ConsumidorDtcodigoAux = dtsa.getConsumidor().getDtcodigo();
		}
		this.jdbcTemplate.update(query, ConsumidorDtcodigoAux,
				SolarbSacodigoAux, dtsa.getM9inredt());
		return dtsa;
	}

	/**
	 * Updates a single row in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Pagination
	 * @return Dtsa
	 */
	public Dtsa update(Dtsa dtsa) {
		String query = "UPDATE DTSA SET  WHERE M9CODT=? AND M9COSA=? AND M9INREDT=?";
		Object SolarbSacodigoAux = null;
		Object ConsumidorDtcodigoAux = null;
		if (dtsa.getSolarb() != null && dtsa.getSolarb().getSacodigo() != null) {
			SolarbSacodigoAux = dtsa.getSolarb().getSacodigo();
		}
		if (dtsa.getConsumidor() != null
				&& dtsa.getConsumidor().getDtcodigo() != null) {
			ConsumidorDtcodigoAux = dtsa.getConsumidor().getDtcodigo();
		}
		this.jdbcTemplate.update(query, ConsumidorDtcodigoAux,
				SolarbSacodigoAux, dtsa.getM9inredt());
		return dtsa;
	}

	/**
	 * Finds a single row in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Pagination
	 * @return Dtsa
	 */
	@Transactional(readOnly = true)
	public Dtsa find(Dtsa dtsa) {
		String query = "SELECT t1.M9CODT M9CODT, t1.M9COSA M9COSA, t1.M9INREDT M9INREDT FROM DTSA t1  WHERE t1.M9CODT = ?   AND t1.M9COSA = ?   AND t1.M9INREDT = ?  ";

		List<Dtsa> dtsaList = this.jdbcTemplate.query(query, this.rwMap, dtsa
				.getConsumidor().getDtcodigo(), dtsa.getSolarb().getSacodigo(),
				dtsa.getM9inredt());
		return (Dtsa) DataAccessUtils.uniqueResult(dtsaList);
	}

	/**
	 * Finds a List of rows in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Dtsa> findConsumidorGrid(Dtsa dtsa) {
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT t1.M9CODT M9CODT, t1.M9COSA M9COSA, t1.M9INREDT M9INREDT FROM DTSA t1 WHERE t1.M9COSA = ?");

		params.add(dtsa.getSolarb().getSacodigo());

		List<Dtsa> lista = this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());

		return lista;
	}

	/**
	 * Removes a single row in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Pagination
	 * @return
	 */
	public void remove(Dtsa dtsa) {
		String query = "DELETE FROM DTSA WHERE M9COSA=? ";
		this.jdbcTemplate.update(query, dtsa.getSolarb().getSacodigo());
	}

	/**
	 * Finds a List of rows in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Dtsa> findAll(Dtsa dtsa, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M9CODT M9CODT,t1.M9COSA M9COSA,t1.M9INREDT M9INREDT ");
		query.append("FROM DTSA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(dtsa);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Dtsa>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Dtsa dtsa) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM DTSA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(dtsa);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Dtsa table using like.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Dtsa> findAllLike(Dtsa dtsa, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M9CODT M9CODT,t1.M9COSA M9COSA,t1.M9INREDT M9INREDT ");
		query.append("FROM DTSA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(dtsa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Dtsa>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Dtsa table using like.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Dtsa dtsa, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM DTSA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(dtsa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Dtsa entity
	 * 
	 * @param dtsa
	 *            Dtsa Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Dtsa dtsa) {

		StringBuilder where = new StringBuilder(DtsaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (dtsa != null && dtsa.getConsumidor() != null
				&& dtsa.getConsumidor().getDtcodigo() != null) {
			where.append(" AND t1.M9CODT = ?");
			params.add(dtsa.getConsumidor().getDtcodigo());
		}
		if (dtsa != null && dtsa.getSolarb().getSacodigo() != null) {
			where.append(" AND t1.M9COSA = ?");
			params.add(dtsa.getSolarb().getSacodigo());
		}
		if (dtsa != null && dtsa.getM9inredt() != null) {
			where.append(" AND t1.M9INREDT = ?");
			params.add(dtsa.getM9inredt());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Dtsa entity
	 * 
	 * @param dtsa
	 *            Dtsa Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Dtsa dtsa, Boolean startsWith) {

		StringBuilder where = new StringBuilder(DtsaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (dtsa != null && dtsa.getConsumidor().getDtcodigo() != null) {
			where.append(" AND UPPER(t1.M9CODT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(dtsa.getConsumidor().getDtcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ dtsa.getConsumidor().getDtcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M9CODT IS NOT NULL");
		}
		if (dtsa != null && dtsa.getSolarb().getSacodigo() != null) {
			where.append(" AND UPPER(t1.M9COSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(dtsa.getSolarb().getSacodigo().toUpperCase() + "%");
			} else {
				params.add("%" + dtsa.getSolarb().getSacodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M9COSA IS NOT NULL");
		}
		if (dtsa != null && dtsa.getM9inredt() != null) {
			where.append(" AND UPPER(t1.M9INREDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(dtsa.getM9inredt().toUpperCase() + "%");
			} else {
				params.add("%" + dtsa.getM9inredt().toUpperCase() + "%");
			}
			where.append(" AND t1.M9INREDT IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
