package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.DocumentoSolicitudTelematicaEventos;
import com.ejie.y41b.model.SolicitudTelematicaEventos;

/**
 * DocumentosSolicitudesTelematicasEventosDaoImpl  
 * 9:38:26.
 * 
 *  
 */

@Repository
@Transactional
public class DocumentosSolicitudesTelematicasEventosDaoImpl implements DocumentosSolicitudesTelematicasEventosDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<DocumentoSolicitudTelematicaEventos> rwMap = new RowMapper<DocumentoSolicitudTelematicaEventos>() {
		public DocumentoSolicitudTelematicaEventos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DocumentoSolicitudTelematicaEventos(resultSet.getString("OID_DOKUSI"),
					resultSet.getString("NO_FILE"), resultSet.getString("COD_TIPODOC"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the SolicitudesTelematicasEventos table.
	 * 
	 * @param filterSolicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * 
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	@Transactional(readOnly = true)
	public List<DocumentoSolicitudTelematicaEventos> findAllDocumentosSTE(
			DocumentoSolicitudTelematicaEventos filterDocumentoSolicitudTelematicaEventos, Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.OID_DOKUSI OID_DOKUSI, t1.NO_FILE NO_FILE,  t1.COD_TIPODOC COD_TIPODOC ");
		query.append(
				"FROM DOCUMENTO_SOLICITUD t1, SOLICITUD_TELEMATICA t2 WHERE (1=1) AND t1.ID_SOLICITUD_TELEMATICA = t2.ID_SOLICITUD_TELEMATICA ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();

		if (filterDocumentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos() != null
				&& filterDocumentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos()
						.getStTipoExpediente() != null) {
			where.append(" AND t2.TIPO_EXPEDIENTE= ? ");
			params.add(
					filterDocumentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos().getStTipoExpediente());
		}

		if (filterDocumentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos() != null
				&& filterDocumentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos().getStCodigo() != null) {
			where.append(" AND t2.ID_SOLICITUD_TELEMATICA= ? ");
			params.add(filterDocumentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos().getStCodigo());
		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoSolicitudTelematicaEventos>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoSolicitudTelematicaEventos>() {
					public DocumentoSolicitudTelematicaEventos mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new DocumentoSolicitudTelematicaEventos(resultSet.getString("OID_DOKUSI"),
								resultSet.getString("NO_FILE"), resultSet.getString("COD_TIPODOC"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the SolicitudesTelematicasEventos table.
	 * 
	 * @param filterDocumentoSolicitudTelematicaEventos
	 *            DocumentoSolicitudTelematicaEventos
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosSTECount(
			DocumentoSolicitudTelematicaEventos filterDocumentoSolicitudTelematicaEventos) {

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOCUMENTO_SOLICITUD t1, SOLICITUD_TELEMATICA t2 WHERE (1=1) AND t1.ID_SOLICITUD_TELEMATICA = t2.ID_SOLICITUD_TELEMATICA ");
		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();

		if (filterDocumentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos() != null
				&& filterDocumentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos()
						.getStTipoExpediente() != null) {
			where.append(" AND t2.TIPO_EXPEDIENTE= ? ");
			params.add(
					filterDocumentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos().getStTipoExpediente());
		}

		if (filterDocumentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos() != null
				&& filterDocumentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos().getStCodigo() != null) {
			where.append(" AND t2.ID_SOLICITUD_TELEMATICA= ? ");
			params.add(filterDocumentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos().getStCodigo());
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Inserts a single row in the DocumentoSolicitud table.
	 * 
	 * @param documentosolicitud
	 *            DocumentoSolicitud
	 * @return DocumentoSolicitud
	 */
	public DocumentoSolicitudTelematicaEventos add(
			DocumentoSolicitudTelematicaEventos documentoSolicitudTelematicaEventos) {
		String query = "INSERT INTO DOCUMENTO_SOLICITUD (OID_DOKUSI, NO_FILE, COD_TIPODOC,ID_SOLICITUD_TELEMATICA) VALUES (?,?,?,?)";
		Object getSolicitudIdsolicitudAux = null;
		if (documentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos() != null
				&& documentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos().getStCodigo() != null) {
			getSolicitudIdsolicitudAux = documentoSolicitudTelematicaEventos.getDsSolicitudTelematicaEventos()
					.getStCodigo();
		}
		this.jdbcTemplate.update(query, documentoSolicitudTelematicaEventos.getDsOIDDokusi(),
				documentoSolicitudTelematicaEventos.getDsNoFile(),
				documentoSolicitudTelematicaEventos.getDsCodTipoDoc(), getSolicitudIdsolicitudAux);

		return documentoSolicitudTelematicaEventos;
	}

	/**
	 * Removes all rows in the DocumentoSolicitudTelematicaEventos from
	 * SolicitudTelematicaEventos.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return
	 */
	public void removeDocumentosSolicitudTelematicaEventos(SolicitudTelematicaEventos solicitudTelematicaEventos) {
		String query = "DELETE FROM DOCUMENTO_SOLICITUD WHERE ID_SOLICITUD_TELEMATICA=?";
		this.jdbcTemplate.update(query, solicitudTelematicaEventos.getStCodigo());
	}

}
