package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;

import com.ejie.y41b.model.DocumentosFirmaArbitrosTemp;

/**
 * DocumentosFirmaArbitrosDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DocumentosFirmaArbitrosTempDaoImpl implements
		DocumentosFirmaArbitrosTempDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<DocumentosFirmaArbitrosTemp> rwMap = new RowMapper<DocumentosFirmaArbitrosTemp>() {
		public DocumentosFirmaArbitrosTemp mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {
			return new DocumentosFirmaArbitrosTemp(
					resultSet.getString("iddocumentosfirmaarbtemp"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the DocumentosFirmaArbitrosTemp table.
	 * 
	 * @param DocumentosFirmaArbitrosTemp
	 *            Pagination
	 * @return DocumentosFirmaArbitrosTemp
	 */
	public DocumentosFirmaArbitrosTemp add(
			DocumentosFirmaArbitrosTemp DocumentosFirmaArbitrosTemp) {
		String query = "INSERT INTO DOCUMENTOSFIRMAARBTEMP (IDDOCUMENTOSFIRMAARBTEMP) VALUES (?)";

		this.jdbcTemplate.update(query,
				DocumentosFirmaArbitrosTemp.getIddocumentosfirmaarbtemp());
		return DocumentosFirmaArbitrosTemp;
	}

	/**
	 * Updates a single row in the DocumentosFirmaArbitrosTemp table.
	 * 
	 * @param DocumentosFirmaArbitrosTemp
	 *            Pagination
	 * @return DocumentosFirmaArbitrosTemp
	 */
	public DocumentosFirmaArbitrosTemp update(
			DocumentosFirmaArbitrosTemp DocumentosFirmaArbitrosTemp) {
		String query = "UPDATE DOCUMENTOSFIRMAARBTEMP SET  WHERE IDDOCUMENTOSFIRMAARBTEMP=?";

		this.jdbcTemplate.update(query,
				DocumentosFirmaArbitrosTemp.getIddocumentosfirmaarbtemp());
		return DocumentosFirmaArbitrosTemp;
	}

	/**
	 * Finds a single row in the DocumentosFirmaArbitrosTemp table.
	 * 
	 * @param DocumentosFirmaArbitrosTemp
	 *            Pagination
	 * @return DocumentosFirmaArbitrosTemp
	 */
	@Transactional(readOnly = true)
	public DocumentosFirmaArbitrosTemp find(
			DocumentosFirmaArbitrosTemp DocumentosFirmaArbitrosTemp) {
		String query = "SELECT t1.IDDOCUMENTOSFIRMAARBTEMP IDDOCUMENTOSFIRMAARBTEMP FROM DOCUMENTOSFIRMAARBTEMP t1 WHERE t1.IDDOCUMENTOSFIRMAARBTEMP = ? ";

		List<DocumentosFirmaArbitrosTemp> DocumentosFirmaArbitrosList = this.jdbcTemplate
				.query(query, this.rwMap, DocumentosFirmaArbitrosTemp
						.getIddocumentosfirmaarbtemp());
		return (DocumentosFirmaArbitrosTemp) DataAccessUtils
				.uniqueResult(DocumentosFirmaArbitrosList);
	}

	/**
	 * Removes a single row in the DocumentosFirmaArbitrosTemp table.
	 * 
	 * @param DocumentosFirmaArbitrosTemp
	 *            Pagination
	 * @return
	 */
	public void remove(DocumentosFirmaArbitrosTemp DocumentosFirmaArbitrosTemp) {
		String query = "DELETE FROM DOCUMENTOSFIRMAARBTEMP WHERE IDDOCUMENTOSFIRMAARBTEMP=?";
		this.jdbcTemplate.update(query,
				DocumentosFirmaArbitrosTemp.getIddocumentosfirmaarbtemp());
	}

	/**
	 * Finds a List of rows in the DocumentosFirmaArbitrosTemp table.
	 * 
	 * @param DocumentosFirmaArbitrosTemp
	 *            DocumentosFirmaArbitrosTemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentosFirmaArbitrosTemp> findAll(
			DocumentosFirmaArbitrosTemp DocumentosFirmaArbitrosTemp,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDDOCUMENTOSFIRMAARBTEMP IDDOCUMENTOSFIRMAARBTEMP ");
		query.append("FROM DOCUMENTOSFIRMAARBTEMP t1");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereMap(DocumentosFirmaArbitrosTemp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentosFirmaArbitrosTemp>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DocumentosFirmaArbitrosTemp table.
	 * 
	 * @param DocumentosFirmaArbitrosTemp
	 *            DocumentosFirmaArbitrosTemp
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(
			DocumentosFirmaArbitrosTemp DocumentosFirmaArbitrosTemp) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOCUMENTOSFIRMAARBTEMP t1");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereMap(DocumentosFirmaArbitrosTemp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the DocumentosFirmaArbitrosTemp table using like.
	 * 
	 * @param DocumentosFirmaArbitrosTemp
	 *            DocumentosFirmaArbitrosTemp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentosFirmaArbitrosTemp> findAllLike(
			DocumentosFirmaArbitrosTemp DocumentosFirmaArbitrosTemp,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDDOCUMENTOSFIRMAARBTEMP IDDOCUMENTOSFIRMAARBTEMP ");
		query.append("FROM DOCUMENTOSFIRMAARBTEMP t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				DocumentosFirmaArbitrosTemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentosFirmaArbitrosTemp>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DocumentosFirmaArbitrosTemp table using like.
	 * 
	 * @param DocumentosFirmaArbitrosTemp
	 *            DocumentosFirmaArbitrosTemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(
			DocumentosFirmaArbitrosTemp DocumentosFirmaArbitrosTemp,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOCUMENTOSFIRMAARBTEMP t1");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				DocumentosFirmaArbitrosTemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DocumentosFirmaArbitrosTemp entity
	 * 
	 * @param DocumentosFirmaArbitrosTemp
	 *            DocumentosFirmaArbitrosTemp Bean with the criteria values to
	 *            filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			DocumentosFirmaArbitrosTemp DocumentosFirmaArbitrosTemp) {

		StringBuilder where = new StringBuilder(
				DocumentosFirmaArbitrosTempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (DocumentosFirmaArbitrosTemp != null
				&& DocumentosFirmaArbitrosTemp.getIddocumentosfirmaarbtemp() != null) {
			where.append(" AND t1.IDDOCUMENTOSFIRMAARBTEMP = ?");
			params.add(DocumentosFirmaArbitrosTemp
					.getIddocumentosfirmaarbtemp());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DocumentosFirmaArbitrosTemp entity
	 * 
	 * @param DocumentosFirmaArbitrosTemp
	 *            DocumentosFirmaArbitrosTemp Bean with the criteria values to
	 *            filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			DocumentosFirmaArbitrosTemp DocumentosFirmaArbitrosTemp,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DocumentosFirmaArbitrosTempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (DocumentosFirmaArbitrosTemp != null
				&& DocumentosFirmaArbitrosTemp.getIddocumentosfirmaarbtemp() != null) {
			where.append(" AND UPPER(t1.IDDOCUMENTOSFIRMAARBTEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(DocumentosFirmaArbitrosTemp
						.getIddocumentosfirmaarbtemp().toUpperCase() + "%");
			} else {
				params.add("%"
						+ DocumentosFirmaArbitrosTemp
								.getIddocumentosfirmaarbtemp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.IDDOCUMENTOSFIRMAARBTEMP IS NOT NULL");

		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public List<DocumentosFirmaArbitrosTemp> insertarTemporales(String idTramite) {
		// TODO Auto-generated method stub
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT THCODOCUMENTO AS IDDOCUMENTOSFIRMAARBTEMP ");
		query.append("FROM ADJUNTARDOCS , BANDEJA_FIRMA_ARBITROS");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(idTramite);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND IDTRAMITEHECHO = THID_TRAMITE AND CODOCUMENTO = THCODOCUMENTO AND THCODOCUMENTO NOT IN ( SELECT T1.IDDOCUMENTOSFIRMAARBTEMP FROM DOCUMENTOSFIRMAARBTEMP T1)");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<DocumentosFirmaArbitrosTemp>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	private Map<String, ?> getWhereLikeMap(String id) {

		StringBuilder where = new StringBuilder(
				DocumentosFirmaArbitrosTempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (id != null && id != "") {
			where.append(" AND THID_TRAMITE = ?");
			params.add(id);

		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
}
