package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;

import com.ejie.y41b.model.DocumentosFirmaArbitros;

/**
 * DocumentosFirmaArbitrosDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DocumentosFirmaArbitrosDaoImpl implements
		DocumentosFirmaArbitrosDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<DocumentosFirmaArbitros> rwMap = new RowMapper<DocumentosFirmaArbitros>() {
		public DocumentosFirmaArbitros mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DocumentosFirmaArbitros(
					resultSet.getString("iddocumentosfirmaarb"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the DocumentosFirmaArbitros table.
	 * 
	 * @param DocumentosFirmaArbitros
	 *            Pagination
	 * @return DocumentosFirmaArbitros
	 */
	public DocumentosFirmaArbitros add(
			DocumentosFirmaArbitros DocumentosFirmaArbitros) {
		String query = "INSERT INTO DOCUMENTOSFIRMAARB (IDDOCUMENTOSFIRMAARB) VALUES (?)";

		this.jdbcTemplate.update(query,
				DocumentosFirmaArbitros.getIddocumentosfirmaarb());
		return DocumentosFirmaArbitros;
	}

	/**
	 * Updates a single row in the DocumentosFirmaArbitros table.
	 * 
	 * @param DocumentosFirmaArbitros
	 *            Pagination
	 * @return DocumentosFirmaArbitros
	 */
	public DocumentosFirmaArbitros update(
			DocumentosFirmaArbitros DocumentosFirmaArbitros) {
		String query = "UPDATE DOCUMENTOSFIRMAARB SET  WHERE IDDOCUMENTOSFIRMAARB=?";

		this.jdbcTemplate.update(query,
				DocumentosFirmaArbitros.getIddocumentosfirmaarb());
		return DocumentosFirmaArbitros;
	}

	/**
	 * Finds a single row in the DocumentosFirmaArbitros table.
	 * 
	 * @param DocumentosFirmaArbitros
	 *            Pagination
	 * @return DocumentosFirmaArbitros
	 */
	@Transactional(readOnly = true)
	public DocumentosFirmaArbitros find(
			DocumentosFirmaArbitros DocumentosFirmaArbitros) {
		String query = "SELECT t1.IDDOCUMENTOSFIRMAARB IDDOCUMENTOSFIRMAARB FROM DOCUMENTOSFIRMAARB t1 WHERE t1.IDDOCUMENTOSFIRMAARB = ?";

		List<DocumentosFirmaArbitros> DocumentosFirmaArbitrosList = this.jdbcTemplate
				.query(query, this.rwMap,
						DocumentosFirmaArbitros.getIddocumentosfirmaarb());
		return (DocumentosFirmaArbitros) DataAccessUtils
				.uniqueResult(DocumentosFirmaArbitrosList);
	}

	/**
	 * Removes a single row in the DocumentosFirmaArbitros table.
	 * 
	 * @param DocumentosFirmaArbitros
	 *            Pagination
	 * @return
	 */
	public void remove(DocumentosFirmaArbitros DocumentosFirmaArbitros) {
		String query = "DELETE FROM DOCUMENTOSFIRMAARB WHERE IDDOCUMENTOSFIRMAARB=?";
		this.jdbcTemplate.update(query,
				DocumentosFirmaArbitros.getIddocumentosfirmaarb());
	}

	/**
	 * Finds a List of rows in the DocumentosFirmaArbitros table.
	 * 
	 * @param DocumentosFirmaArbitros
	 *            DocumentosFirmaArbitros
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentosFirmaArbitros> findAll(
			DocumentosFirmaArbitros DocumentosFirmaArbitros,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDDOCUMENTOSFIRMAARB IDDOCUMENTOSFIRMAARB ");
		query.append("FROM DOCUMENTOSFIRMAARB t1");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(DocumentosFirmaArbitros);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentosFirmaArbitros>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DocumentosFirmaArbitros table.
	 * 
	 * @param DocumentosFirmaArbitros
	 *            DocumentosFirmaArbitros
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DocumentosFirmaArbitros DocumentosFirmaArbitros) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOCUMENTOSFIRMAARB t1");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(DocumentosFirmaArbitros);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the DocumentosFirmaArbitros table using like.
	 * 
	 * @param DocumentosFirmaArbitros
	 *            DocumentosFirmaArbitros
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentosFirmaArbitros> findAllLike(
			DocumentosFirmaArbitros DocumentosFirmaArbitros,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDDOCUMENTOSFIRMAARB IDDOCUMENTOSFIRMAARB,t1.IDEXPEDIENTE IDEXPEDIENTE,t1.EXPEDIENTE EXPEDIENTE,t1.PCODIGO PCODIGO,t1.HCCOOR HCCOOR,t1.IDTRAMITEHECHO IDTRAMITEHECHO,t1.TRCODIGO TRCODIGO,t1.CODOCUMENTO CODOCUMENTO,t1.IDDOCUMENTUM IDDOCUMENTUM,t1.NOFILE NOFILE, DECODE(t1.DESFILE, null,t1.NOFILE,t1.DESFILE) DESFILE,t1.FECHALIMFIRMA FECHALIMFIRMA,t1.COMOFIRMA COMOFIRMA, t1.ID_PERFILFIRMA ID_PERFILFIRMA,t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO ");
		query.append("FROM DOCUMENTOSFIRMAARB t1 ,FASE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				DocumentosFirmaArbitros, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentosFirmaArbitros>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DocumentosFirmaArbitros table using like.
	 * 
	 * @param DocumentosFirmaArbitros
	 *            DocumentosFirmaArbitros
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(
			DocumentosFirmaArbitros DocumentosFirmaArbitros, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOCUMENTOSFIRMAARB t1 ,FASE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				DocumentosFirmaArbitros, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DocumentosFirmaArbitros entity
	 * 
	 * @param DocumentosFirmaArbitros
	 *            DocumentosFirmaArbitros Bean with the criteria values to
	 *            filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			DocumentosFirmaArbitros DocumentosFirmaArbitros) {

		StringBuilder where = new StringBuilder(
				DocumentosFirmaArbitrosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (DocumentosFirmaArbitros != null
				&& DocumentosFirmaArbitros.getIddocumentosfirmaarb() != null) {
			where.append(" AND t1.IDDOCUMENTOSFIRMAARB = ?");
			params.add(DocumentosFirmaArbitros.getIddocumentosfirmaarb());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DocumentosFirmaArbitros entity
	 * 
	 * @param DocumentosFirmaArbitros
	 *            DocumentosFirmaArbitros Bean with the criteria values to
	 *            filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			DocumentosFirmaArbitros DocumentosFirmaArbitros, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DocumentosFirmaArbitrosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (DocumentosFirmaArbitros != null
				&& DocumentosFirmaArbitros.getIddocumentosfirmaarb() != null) {
			where.append(" AND UPPER(t1.IDDOCUMENTOSFIRMAARB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(DocumentosFirmaArbitros.getIddocumentosfirmaarb()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ DocumentosFirmaArbitros.getIddocumentosfirmaarb()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.IDDOCUMENTOSFIRMAARB IS NOT NULL");

		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
