package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AsientoRegistral;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.DocumentoAsientoRegistral;
import com.ejie.y41b.model.SolicitudArbitraje;
import com.ejie.y41b.model.SolicitudArbitrajeDetalle;

/**
 * DocumentosSolicitudesTelematicasEventosDaoImpl  
 * 9:38:26.
 * 
 *  
 */

@Repository
@Transactional
public class DocumentosAsientoRegistralDaoImpl implements DocumentosAsientoRegistralDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<DocumentoAsientoRegistral> rwMap = new RowMapper<DocumentoAsientoRegistral>() {
		public DocumentoAsientoRegistral mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DocumentoAsientoRegistral(resultSet.getString("OID_DOKUSI"), resultSet.getString("TIPO_DOC"),
					resultSet.getString("LITERAL_TIPO_DOC"), resultSet.getString("DESC_DOC"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the SolicitudesTelematicasEventos table.
	 * 
	 * @param filterDocumentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * 
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	@Transactional(readOnly = true)
	public List<DocumentoAsientoRegistral> findAllDocumentosAR(
			DocumentoAsientoRegistral filterDocumentoAsientoRegistral, Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.OID_DOKUSI OID_DOKUSI, t1.TIPO_DOC TIPO_DOC,t1.LITERAL_TIPO_DOC LITERAL_TIPO_DOC,t1.DESC_DOC DESC_DOC ");
		query.append(
				"FROM DOCUMENTOS_ASIENTO_REGISTRAL t1, ASIENTO_REGISTRAL t2 WHERE (1=1) AND t1.ID_ASIENTO_REGISTRAL = t2.ID_ASIENTO_REGISTRAL ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();

		if (filterDocumentoAsientoRegistral.getAsientoRegistral() != null
				&& filterDocumentoAsientoRegistral.getAsientoRegistral().getPcodigo() != null) {
			where.append(" AND t2.PCODIGO= ? ");
			params.add(filterDocumentoAsientoRegistral.getAsientoRegistral().getPcodigo());
		}

		if (filterDocumentoAsientoRegistral.getAsientoRegistral() != null
				&& filterDocumentoAsientoRegistral.getAsientoRegistral().getIdAsiento() != null) {
			where.append(" AND t2.ID_ASIENTO_REGISTRAL= ? ");
			params.add(filterDocumentoAsientoRegistral.getAsientoRegistral().getIdAsiento());
		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoAsientoRegistral>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoAsientoRegistral>() {
					public DocumentoAsientoRegistral mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new DocumentoAsientoRegistral(resultSet.getString("OID_DOKUSI"),
								resultSet.getString("TIPO_DOC"), resultSet.getString("LITERAL_TIPO_DOC"),
								resultSet.getString("DESC_DOC"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the DocumentoAsientoRegistral table.
	 * 
	 * @param filterDocumentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosARCount(DocumentoAsientoRegistral filterDocumentoAsientoRegistral) {

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOCUMENTOS_ASIENTO_REGISTRAL t1, ASIENTO_REGISTRAL t2 WHERE (1=1) AND t1.ID_ASIENTO_REGISTRAL = t2.ID_ASIENTO_REGISTRAL ");
		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();

		if (filterDocumentoAsientoRegistral.getAsientoRegistral() != null
				&& filterDocumentoAsientoRegistral.getAsientoRegistral().getPcodigo() != null) {
			where.append(" AND t2.PCODIGO= ? ");
			params.add(filterDocumentoAsientoRegistral.getAsientoRegistral().getPcodigo());
		}

		if (filterDocumentoAsientoRegistral.getAsientoRegistral() != null
				&& filterDocumentoAsientoRegistral.getAsientoRegistral().getIdAsiento() != null) {
			where.append(" AND t2.ID_ASIENTO_REGISTRAL= ? ");
			params.add(filterDocumentoAsientoRegistral.getAsientoRegistral().getIdAsiento());
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Inserts a single row in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * @return DocumentoAsientoRegistral
	 */
	public DocumentoAsientoRegistral add(DocumentoAsientoRegistral documentoAsientoRegistral) {
		String query = "INSERT INTO DOCUMENTOS_ASIENTO_REGISTRAL (OID_DOKUSI, TIPO_DOC, LITERAL_TIPO_DOC, DESC_DOC,ID_ASIENTO_REGISTRAL) VALUES (?,?,?,?,?)";
		Object getAsientoRegistralIdAsientoAux = null;
		if (documentoAsientoRegistral.getAsientoRegistral() != null
				&& documentoAsientoRegistral.getAsientoRegistral().getIdAsiento() != null) {
			getAsientoRegistralIdAsientoAux = documentoAsientoRegistral.getAsientoRegistral().getIdAsiento();
		}
		this.jdbcTemplate.update(query, documentoAsientoRegistral.getOidDokusi(),
				documentoAsientoRegistral.getTipoDoc(), documentoAsientoRegistral.getLiteralTipoDoc(),
				documentoAsientoRegistral.getDescDoc(), getAsientoRegistralIdAsientoAux);

		return documentoAsientoRegistral;
	}

	/**
	 * Removes all rows in the DocumentoAsientoRegistral from
	 * SolicitudTelematicaEventos.
	 * 
	 * @param solicitudTelematicaEventos
	 *            asientoRegistral
	 * @return
	 */
	public void removeDocumentosAsientoRegistral(AsientoRegistral asientoRegistral) {
		String query = "DELETE FROM DOCUMENTOS_ASIENTO_REGISTRAL WHERE ID_ASIENTO_REGISTRAL=?";
		this.jdbcTemplate.update(query, asientoRegistral.getIdAsiento());
	}

	/**
	 * Finds a row in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * 
	 * 
	 * @return DocumentoAsientoRegistral
	 */

	@Transactional(readOnly = true)
	public DocumentoAsientoRegistral findDocumentoAR(DocumentoAsientoRegistral documentoAsientoRegistral) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.OID_DOKUSI OID_DOKUSI, t1.TIPO_DOC TIPO_DOC, t1.LITERAL_TIPO_DOC LITERAL_TIPO_DOC, t1.DESC_DOC DESC_DOC ");
		query.append(
				"FROM DOCUMENTOS_ASIENTO_REGISTRAL t1, ASIENTO_REGISTRAL t2 WHERE (1=1) AND t1.ID_ASIENTO_REGISTRAL = t2.ID_ASIENTO_REGISTRAL ");

		query.append("AND t1.OID_DOKUSI= ? ");

		return (DocumentoAsientoRegistral) this.jdbcTemplate.queryForObject(query.toString(), rwMap,
				documentoAsientoRegistral.getOidDokusi());

	}

	/**
	 * Updates a single row in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * @return DocumentoAsientoRegistral
	 */
	public DocumentoAsientoRegistral update(DocumentoAsientoRegistral documentoAsientoRegistral) {
		String query = "UPDATE DOCUMENTOS_ASIENTO_REGISTRAL SET TIPO_DOC=?,LITERAL_TIPO_DOC=?,DESC_DOC=? WHERE OID_DOKUSI=?";

		this.jdbcTemplate.update(query, documentoAsientoRegistral.getTipoDoc(),
				documentoAsientoRegistral.getLiteralTipoDoc(), documentoAsientoRegistral.getDescDoc(),
				documentoAsientoRegistral.getOidDokusi());
		return documentoAsientoRegistral;
	}

	/**
	 * Counts rows in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * 
	 * 
	 * @return Long
	 */

	@Transactional(readOnly = true)
	public Long countDocsSinRellenar(DocumentoAsientoRegistral documentoAsientoRegistral) {

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOCUMENTOS_ASIENTO_REGISTRAL t1, ASIENTO_REGISTRAL t2 WHERE (1=1) "
						+ "AND t1.ID_ASIENTO_REGISTRAL = t2.ID_ASIENTO_REGISTRAL "
						+ "AND (t1.TIPO_DOC IS NULL	OR t1.DESC_DOC IS NULL) AND t1.ID_ASIENTO_REGISTRAL = ?");

		return this.jdbcTemplate.queryForLong(query.toString(),
				documentoAsientoRegistral.getAsientoRegistral().getIdAsiento());

	}

	/**
	 * Resets to null doumental type and desc fields for every document of the
	 * asientoregistral identified by idAsiento
	 * 
	 * @param idAsiento
	 *            String
	 * 
	 */

	public void reseteaDocsAsiento(String idAsiento) {
		// Fase 2. Punto 4. no borrar la desc si viene ya precargada solo
		// obligar a que meta el tipo documental
		// String query = "UPDATE DOCUMENTOS_ASIENTO_REGISTRAL SET TIPO_DOC =
		// NULL,LITERAL_TIPO_DOC = NULL, DESC_DOC = NULL WHERE
		// ID_ASIENTO_REGISTRAL = ?";
		String query = "UPDATE DOCUMENTOS_ASIENTO_REGISTRAL SET TIPO_DOC = NULL,LITERAL_TIPO_DOC = NULL WHERE ID_ASIENTO_REGISTRAL = ?";
		this.jdbcTemplate.update(query, idAsiento);
	}
}
