package com.ejie.y41b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AsientoRegistral;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.DocumentoAsientoRegistral;

/**
 * BandejaSolicitudesDao  
 * 
 *  
 */

public interface DocumentosAsientoRegistralDao {

	/**
	 * Finds a List of rows in the DocumentoAsientoRegistral table.
	 * 
	 * @param filterDocumentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * 
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<DocumentoAsientoRegistral> findAllDocumentosAR(
			DocumentoAsientoRegistral filterDocumentoAsientoRegistral, Pagination pagination);

	/**
	 * Counts rows in the DocumentoAsientoRegistral table.
	 * 
	 * @param filterDocumentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * 
	 * @return Long
	 */
	public Long findAllDocumentosARCount(DocumentoAsientoRegistral filterDocumentoAsientoRegistral);

	/**
	 * Inserts a single row in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * @return DocumentoAsientoRegistral
	 */
	DocumentoAsientoRegistral add(DocumentoAsientoRegistral documentoAsientoRegistral);

	/**
	 * Removes all rows in the DocumentoAsientoRegistral from AsientoRegistral.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @return
	 */
	public void removeDocumentosAsientoRegistral(AsientoRegistral asientoRegistral);

	/**
	 * Finds a row in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * 
	 * 
	 * @return DocumentoAsientoRegistral
	 */
	public DocumentoAsientoRegistral findDocumentoAR(DocumentoAsientoRegistral documentoAsientoRegistral);

	/**
	 * Updates a single row in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * @return DocumentoAsientoRegistral
	 */
	DocumentoAsientoRegistral update(DocumentoAsientoRegistral documentoAsientoRegistral);

	/**
	 * Counts rows in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * 
	 * 
	 * @return Long
	 */
	public Long countDocsSinRellenar(DocumentoAsientoRegistral documentoAsientoRegistral);

	/**
	 * Resets to null doumental type and desc fields for every document of the
	 * asientoregistral identified by idAsiento
	 * 
	 * @param idAsiento
	 *            String
	 * 
	 */

	public void reseteaDocsAsiento(String idAsiento);

}
