package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ComunicacionSoivre;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoTramiteHecho;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.jdbc.Y41bJdbcUtils;

/**
 * * DocumentoHechoDaoImpl  
 * 
 *  
 */
// CHECKSTYLE:OFF
@SuppressWarnings(value = { "deprecation" })
@Repository
@Transactional
public class DocumentoHechoDaoImpl implements DocumentoHechoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<DocumentoHecho> rwMap = new RowMapper<DocumentoHecho>() {
		public DocumentoHecho mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DocumentoHecho(resultSet.getString("Q5CODOCUMENTO"), resultSet.getString("Q5HDCODIGO"),
					resultSet.getString("Q5NOFILE"), resultSet.getBlob("Q5DATAFILE"), resultSet.getInt("Q5SIZEFILE"),
					resultSet.getString("Q5TEDESFILE"), resultSet.getString("Q5ORIGEN"),
					resultSet.getString("Q5TRAMITE"), resultSet.getDate("Q5FECHA"), resultSet.getString("Q5INDMAIL"),
					resultSet.getString("Q5TRMAIL"), resultSet.getString("Q5CONTENTTYPEFILE"),
					resultSet.getString("Q5IDDOCUMENTUM"), resultSet.getDate("Q5FECHAAPORTACION"),
					resultSet.getDate("Q5FECHAENTRADA"), resultSet.getString("Q5NUMREGISTROENTRADA"),
					resultSet.getString("Q5IDPERFILFIRMA"), resultSet.getString("Q5ESTADODOCUMENTO"),
					resultSet.getDate("Q5FECHASOLFIRMA"), resultSet.getDate("Q5FECHALIMFIRMA"),
					resultSet.getDate("Q5FECHAFIRMA"), resultSet.getString("Q5COMOFIRMA"),
					resultSet.getString("Q5IDTIPODOC"), resultSet.getString("Q5DESTINO"),
					resultSet.getTimestamp("Q5FECHASOLLOCALIZADOR"), resultSet.getString("Q5PTCODIGO"),
					resultSet.getString("PCODIGO"), resultSet.getString("Q5HASHFILE"),
					resultSet.getDate("Q5FECHAREGISTROORIGEN"), resultSet.getString("Q5NUMREGISTROORIGEN"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho add(DocumentoHecho documentoHecho) {
		String query = "INSERT INTO DOCUMENTO_HECHO (Q5CODOCUMENTO, Q5HDCODIGO, Q5NOFILE, Q5DATAFILE, Q5SIZEFILE, Q5TEDESFILE, Q5ORIGEN, Q5TRAMITE, Q5FECHA, Q5INDMAIL, Q5TRMAIL, Q5CONTENTTYPEFILE, Q5IDDOCUMENTUM, Q5FECHAAPORTACION, Q5FECHAENTRADA, Q5NUMREGISTROENTRADA, Q5ID_PERFILFIRMA, Q5ESTADODOCUMENTO, Q5FECHASOLFIRMA, Q5FECHALIMFIRMA, Q5FECHAFIRMA, Q5COMOFIRMA, Q5ID_TIPODOC, Q5DESTINO, Q5PTCODIGO, Q5IDINTERVINIENTE, Q5HASHFILE, Q5FECHAREGISTROORIGEN, Q5NUMREGISTROORIGEN) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, documentoHecho.getQ5codocumento(), documentoHecho.getQ5hdcodigo(),
				documentoHecho.getQ5nofile(), Y41bJdbcUtils.ConvertBlobToByte(documentoHecho.getQ5datafile()),
				documentoHecho.getQ5sizefile(), documentoHecho.getQ5tedesfile(), documentoHecho.getQ5origen(),
				documentoHecho.getQ5tramite(), documentoHecho.getQ5fecha(), documentoHecho.getQ5indmail(),
				documentoHecho.getQ5trmail(), documentoHecho.getQ5contenttypefile(), documentoHecho.getQ5iddocumentum(),
				documentoHecho.getQ5fechaaportacion(), documentoHecho.getQ5fechaentrada(),
				documentoHecho.getQ5numregistroentrada(), documentoHecho.getQ5idPerfilfirma(),
				documentoHecho.getQ5estadodocumento(), documentoHecho.getQ5fechasolfirma(),
				documentoHecho.getQ5fechalimfirma(), documentoHecho.getQ5fechafirma(), documentoHecho.getQ5comofirma(),
				documentoHecho.getQ5idTipodoc(), documentoHecho.getQ5destino(), documentoHecho.getQ5ptcodigo(),
				documentoHecho.getQ5idinterviniente(), documentoHecho.getQ5hashfile(),
				documentoHecho.getQ5FechaRegistroOrigen(), documentoHecho.getQ5NumRegistroOrigen());
		return documentoHecho;
	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 */
	public void enviarDocumentosSolicitudTelematica(SolicitudDetalle solicitudDetalle) {

		String query = "INSERT INTO DOCUMENTO_HECHO (Q5CODOCUMENTO, Q5HDCODIGO, Q5NOFILE, Q5DATAFILE, Q5SIZEFILE, Q5TEDESFILE, Q5ORIGEN, Q5TRAMITE, Q5FECHA, Q5INDMAIL, Q5TRMAIL, Q5CONTENTTYPEFILE, Q5IDDOCUMENTUM, Q5FECHAAPORTACION, Q5FECHAENTRADA, Q5NUMREGISTROENTRADA, Q5ID_PERFILFIRMA, Q5ESTADODOCUMENTO, Q5FECHASOLFIRMA, Q5FECHALIMFIRMA, Q5FECHAFIRMA, Q5COMOFIRMA, Q5ID_TIPODOC, Q5DESTINO) SELECT TGCODOCUMENTO, TGHDCODIGO, TGNOFILE, TGDATAFILE, TGSIZEFILE, TGTEDESFILE, TGORIGEN, TGTRAMITE, TGFECHA, TGINDMAIL, TGTRMAIL, TGCONTENTTYPEFILE, TGIDDOCUMENTUM, TGFECHAAPORTACION, TGFECHAENTRADA, TGNUMREGISTROENTRADA, TGID_PERFILFIRMA, TGESTADODOCUMENTO, TGFECHASOLFIRMA, TGFECHALIMFIRMA, TGFECHAFIRMA, TGCOMOFIRMA, TGID_TIPODOC, TGDESTINO FROM DOC_HECHO_TELE WHERE TGHDCODIGO = ? ";
		this.jdbcTemplate.update(query, solicitudDetalle.getHdcodigo());
	}

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return
	 */
	public void removeDocumentosSolicitudTelematica(SolicitudDetalle solicitudDetalle) {
		String query = "DELETE  FROM DOC_HECHO_TELE WHERE TGHDCODIGO=?";
		this.jdbcTemplate.update(query, solicitudDetalle.getHdcodigo());
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho update(DocumentoHecho documentoHecho) {
		String query = "UPDATE DOCUMENTO_HECHO SET Q5HDCODIGO=?, Q5NOFILE=?, Q5DATAFILE=?, Q5SIZEFILE=?, Q5TEDESFILE=?, Q5ORIGEN=?, Q5TRAMITE=?, Q5FECHA=?, Q5INDMAIL=?, Q5TRMAIL=?, Q5CONTENTTYPEFILE=?, Q5IDDOCUMENTUM=?, Q5FECHAAPORTACION=?, Q5FECHAENTRADA=?, Q5NUMREGISTROENTRADA=?, Q5ID_PERFILFIRMA=?, Q5ESTADODOCUMENTO=?, Q5FECHASOLFIRMA=?, Q5FECHALIMFIRMA=?, Q5FECHAFIRMA=?, Q5COMOFIRMA=?, Q5ID_TIPODOC=?, Q5DESTINO=?, Q5PTCODIGO=?, Q5HASHFILE=? WHERE Q5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getQ5hdcodigo(), documentoHecho.getQ5nofile(),
				Y41bJdbcUtils.ConvertBlobToByte(documentoHecho.getQ5datafile()), documentoHecho.getQ5sizefile(),
				documentoHecho.getQ5tedesfile(), documentoHecho.getQ5origen(), documentoHecho.getQ5tramite(),
				documentoHecho.getQ5fecha(), documentoHecho.getQ5indmail(), documentoHecho.getQ5trmail(),
				documentoHecho.getQ5contenttypefile(), documentoHecho.getQ5iddocumentum(),
				documentoHecho.getQ5fechaaportacion(), documentoHecho.getQ5fechaentrada(),
				documentoHecho.getQ5numregistroentrada(), documentoHecho.getQ5idPerfilfirma(),
				documentoHecho.getQ5estadodocumento(), documentoHecho.getQ5fechasolfirma(),
				documentoHecho.getQ5fechalimfirma(), documentoHecho.getQ5fechafirma(), documentoHecho.getQ5comofirma(),
				documentoHecho.getQ5idTipodoc(), documentoHecho.getQ5destino(), documentoHecho.getQ5ptcodigo(),
				documentoHecho.getQ5hashfile(), documentoHecho.getQ5codocumento());
		return documentoHecho;
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return int
	 */
	public int updateDocumentoHecho(DocumentoHecho documentoHecho) {
		String query = "UPDATE DOCUMENTO_HECHO SET Q5NOFILE=?,Q5DATAFILE=?, Q5SIZEFILE=?, Q5CONTENTTYPEFILE=? WHERE Q5IDDOCUMENTUM=?";
		return this.jdbcTemplate.update(query, documentoHecho.getQ5nofile(),
				Y41bJdbcUtils.ConvertBlobToByte(documentoHecho.getQ5datafile()), documentoHecho.getQ5sizefile(),
				documentoHecho.getQ5contenttypefile(), documentoHecho.getQ5iddocumentum());
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateHashByOIDDokusi(DocumentoHecho documentoHecho) {
		String query = "UPDATE DOCUMENTO_HECHO SET Q5HASHFILE=? WHERE Q5IDDOCUMENTUM=?";
		this.jdbcTemplate.update(query, documentoHecho.getQ5hashfile(), documentoHecho.getQ5iddocumentum());
		return documentoHecho;
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateDatosFirma(DocumentoHecho documentoHecho) {
		String query = "UPDATE DOCUMENTO_HECHO SET Q5ESTADODOCUMENTO=?, Q5FECHAFIRMA=?, Q5COMOFIRMA=? WHERE Q5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getQ5estadodocumento(), documentoHecho.getQ5fechafirma(),
				documentoHecho.getQ5comofirma(), documentoHecho.getQ5codocumento());
		return documentoHecho;
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateTramite(DocumentoHecho documentoHecho) {
		String query = "UPDATE DOCUMENTO_HECHO SET Q5TRAMITE=? WHERE Q5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getQ5tramite(), documentoHecho.getQ5codocumento());
		return documentoHecho;
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateOIDDokusi(DocumentoHecho documentoHecho) {
		String query = "UPDATE DOCUMENTO_HECHO SET Q5IDDOCUMENTUM=? WHERE Q5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getQ5iddocumentum(), documentoHecho.getQ5codocumento());
		return documentoHecho;
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateHash(DocumentoHecho documentoHecho) {
		String query = "UPDATE DOCUMENTO_HECHO SET Q5HASHFILE=? WHERE Q5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getQ5hashfile(), documentoHecho.getQ5codocumento());
		return documentoHecho;
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho removeBlobFromOIDDokusi(DocumentoHecho documentoHecho) {
		String query = "UPDATE DOCUMENTO_HECHO SET Q5DATAFILE=null WHERE Q5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getQ5codocumento());
		return documentoHecho;
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateFechaLocalizacion(DocumentoHecho documentoHecho) {
		String query = "UPDATE DOCUMENTO_HECHO SET Q5FECHASOLLOCALIZADOR=SYSDATE WHERE Q5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getQ5codocumento());
		return documentoHecho;
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateOrigen(DocumentoHecho documentoHecho) {
		String query = "UPDATE DOCUMENTO_HECHO SET Q5ORIGEN=? WHERE Q5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getQ5origen(), documentoHecho.getQ5codocumento());
		return documentoHecho;
	}

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	@Transactional(readOnly = true)
	public DocumentoHecho find(DocumentoHecho documentoHecho) {
		String query = "SELECT t1.Q5CODOCUMENTO Q5CODOCUMENTO, t1.Q5HDCODIGO Q5HDCODIGO, t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE, t1.Q5SIZEFILE Q5SIZEFILE, t1.Q5TEDESFILE Q5TEDESFILE, t1.Q5ORIGEN Q5ORIGEN, t1.Q5TRAMITE Q5TRAMITE, t1.Q5FECHA Q5FECHA, t1.Q5INDMAIL Q5INDMAIL, t1.Q5TRMAIL Q5TRMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE, t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM, t1.Q5FECHAAPORTACION Q5FECHAAPORTACION, t1.Q5FECHAENTRADA Q5FECHAENTRADA, t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t1.Q5ID_PERFILFIRMA Q5IDPERFILFIRMA, t1.Q5ESTADODOCUMENTO Q5ESTADODOCUMENTO, t1.Q5FECHASOLFIRMA Q5FECHASOLFIRMA, t1.Q5FECHALIMFIRMA Q5FECHALIMFIRMA, t1.Q5FECHAFIRMA Q5FECHAFIRMA, t1.Q5COMOFIRMA Q5COMOFIRMA, t1.Q5ID_TIPODOC Q5IDTIPODOC, t1.Q5DESTINO Q5DESTINO, t1.Q5FECHASOLLOCALIZADOR Q5FECHASOLLOCALIZADOR, t1.Q5PTCODIGO Q5PTCODIGO, t1.Q5HASHFILE Q5HASHFILE, t1.Q5FECHAREGISTROORIGEN Q5FECHAREGISTROORIGEN, t1.Q5NUMREGISTROORIGEN Q5NUMREGISTROORIGEN,t2.PCODIGO PCODIGO FROM DOCUMENTO_HECHO t1, DOC_TRAMITE_HECHO t2  WHERE t1.Q5CODOCUMENTO=t2.CODOCUMENTO AND t1.Q5CODOCUMENTO = ?  ";

		List<DocumentoHecho> documentoHechoList = this.jdbcTemplate.query(query, this.rwMap,
				documentoHecho.getQ5codocumento());
		return (DocumentoHecho) DataAccessUtils.uniqueResult(documentoHechoList);
	}

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	@Transactional(readOnly = true)
	public DocumentoHecho findDoc(DocumentoHecho documentoHecho) {
		String query = "SELECT t1.Q5CODOCUMENTO Q5CODOCUMENTO, t1.Q5HDCODIGO Q5HDCODIGO, t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE, t1.Q5SIZEFILE Q5SIZEFILE, t1.Q5TEDESFILE Q5TEDESFILE, t1.Q5ORIGEN Q5ORIGEN, t1.Q5TRAMITE Q5TRAMITE, t1.Q5FECHA Q5FECHA, t1.Q5INDMAIL Q5INDMAIL, t1.Q5TRMAIL Q5TRMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE, t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM, t1.Q5FECHAAPORTACION Q5FECHAAPORTACION, t1.Q5FECHAENTRADA Q5FECHAENTRADA, t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t1.Q5ID_PERFILFIRMA Q5IDPERFILFIRMA, t1.Q5ESTADODOCUMENTO Q5ESTADODOCUMENTO, t1.Q5FECHASOLFIRMA Q5FECHASOLFIRMA, t1.Q5FECHALIMFIRMA Q5FECHALIMFIRMA, t1.Q5FECHAFIRMA Q5FECHAFIRMA, t1.Q5COMOFIRMA Q5COMOFIRMA, t1.Q5ID_TIPODOC Q5IDTIPODOC, t1.Q5DESTINO Q5DESTINO, t1.Q5FECHASOLLOCALIZADOR Q5FECHASOLLOCALIZADOR, t1.Q5PTCODIGO Q5PTCODIGO, t1.Q5HASHFILE Q5HASHFILE, t1.Q5FECHAREGISTROORIGEN Q5FECHAREGISTROORIGEN, t1.Q5NUMREGISTROORIGEN Q5NUMREGISTROORIGEN, t2.PCODIGO PCODIGO FROM DOCUMENTO_HECHO t1, DOC_TRAMITE_HECHO t2  WHERE t1.Q5CODOCUMENTO=t2.CODOCUMENTO AND t1.Q5TRAMITE=t2.EHCODIGO AND t1.Q5CODOCUMENTO = ? ";

		List<DocumentoHecho> documentoHechoList = this.jdbcTemplate.query(query, this.rwMap,
				documentoHecho.getQ5codocumento());
		return (DocumentoHecho) DataAccessUtils.uniqueResult(documentoHechoList);
	}

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	@Transactional(readOnly = true)
	public DocumentoHecho findDocumentoTraslado(DocumentoHecho documentoHecho) {
		String query = "SELECT t1.Q5CODOCUMENTO Q5CODOCUMENTO, t1.Q5HDCODIGO Q5HDCODIGO, t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE, t1.Q5SIZEFILE Q5SIZEFILE, t1.Q5TEDESFILE Q5TEDESFILE, t1.Q5ORIGEN Q5ORIGEN, t1.Q5TRAMITE Q5TRAMITE, t1.Q5FECHA Q5FECHA, t1.Q5INDMAIL Q5INDMAIL, t1.Q5TRMAIL Q5TRMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE, t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM, t1.Q5FECHAAPORTACION Q5FECHAAPORTACION, t1.Q5FECHAENTRADA Q5FECHAENTRADA, t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t1.Q5ID_PERFILFIRMA Q5IDPERFILFIRMA, t1.Q5ESTADODOCUMENTO Q5ESTADODOCUMENTO, t1.Q5FECHASOLFIRMA Q5FECHASOLFIRMA, t1.Q5FECHALIMFIRMA Q5FECHALIMFIRMA, t1.Q5FECHAFIRMA Q5FECHAFIRMA, t1.Q5COMOFIRMA Q5COMOFIRMA, t1.Q5ID_TIPODOC Q5IDTIPODOC, t1.Q5DESTINO Q5DESTINO, t1.Q5FECHASOLLOCALIZADOR Q5FECHASOLLOCALIZADOR, t1.Q5PTCODIGO Q5PTCODIGO, t1.Q5HASHFILE Q5HASHFILE, t1.Q5FECHAREGISTROORIGEN Q5FECHAREGISTROORIGEN, t1.Q5NUMREGISTROORIGEN Q5NUMREGISTROORIGEN, t2.PCODIGO PCODIGO FROM DOCUMENTO_HECHO t1, DOC_TRAMITE_HECHO t2  WHERE t1.Q5CODOCUMENTO=t2.CODOCUMENTO AND t1.Q5TRAMITE = ?  ";

		List<DocumentoHecho> documentoHechoList = this.jdbcTemplate.query(query, this.rwMap,
				documentoHecho.getQ5tramite());
		return (DocumentoHecho) DataAccessUtils.uniqueResult(documentoHechoList);
	}

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return
	 */
	public void remove(DocumentoHecho documentoHecho) {
		String query = "DELETE FROM DOCUMENTO_HECHO WHERE Q5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getQ5codocumento());
	}

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param documentoTramiteHecho
	 *            DocumentoTramiteHecho
	 */
	public void removeDocsExpediente(DocumentoHecho documentoHecho) {
		String query = "DELETE FROM DOCUMENTO_HECHO WHERE Q5HDCODIGO = ?";
		this.jdbcTemplate.update(query, documentoHecho.getQ5hdcodigo());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoHecho> findAll(DocumentoHecho documentoHecho, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5HDCODIGO Q5HDCODIGO,t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE,t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN,t1.Q5TRAMITE Q5TRAMITE,t1.Q5FECHA Q5FECHA,t1.Q5INDMAIL Q5INDMAIL,t1.Q5TRMAIL Q5TRMAIL,t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t1.Q5FECHAAPORTACION Q5FECHAAPORTACION,t1.Q5FECHAENTRADA Q5FECHAENTRADA,t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA,t1.Q5ID_PERFILFIRMA Q5IDPERFILFIRMA,t1.Q5ESTADODOCUMENTO Q5ESTADODOCUMENTO,t1.Q5FECHASOLFIRMA Q5FECHASOLFIRMA,t1.Q5FECHALIMFIRMA Q5FECHALIMFIRMA,t1.Q5FECHAFIRMA Q5FECHAFIRMA,t1.Q5COMOFIRMA Q5COMOFIRMA,t1.Q5ID_TIPODOC Q5IDTIPODOC,t1.Q5DESTINO Q5DESTINO, t1.Q5FECHASOLLOCALIZADOR Q5FECHASOLLOCALIZADOR, t1.Q5PTCODIGO Q5PTCODIGO, null PCODIGO, t1.Q5HASHFILE Q5HASHFILE, t1.Q5FECHAREGISTROORIGEN Q5FECHAREGISTROORIGEN, t1.Q5NUMREGISTROORIGEN Q5NUMREGISTROORIGEN ");
		query.append("FROM DOCUMENTO_HECHO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(documentoHecho);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoHecho>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DocumentoHecho documentoHecho) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM DOCUMENTO_HECHO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(documentoHecho);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosAportadosIntervinienteCount(DocumentoHecho documentoHecho) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM DOCUMENTO_HECHO t1 ");

		StringBuilder where = new StringBuilder();
		where.append(" WHERE 1=1 ");

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ? ");
		params.add(documentoHecho.getQ5hdcodigo());

		where.append(" AND t1.Q5IDINTERVINIENTE = ? ");
		params.add(documentoHecho.getQ5idinterviniente());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoHecho> findAllDocumentosTramite(TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5HDCODIGO Q5HDCODIGO,t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE,t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN,t1.Q5TRAMITE Q5TRAMITE,t1.Q5FECHA Q5FECHA,t1.Q5INDMAIL Q5INDMAIL,t1.Q5TRMAIL Q5TRMAIL,t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t1.Q5FECHAAPORTACION Q5FECHAAPORTACION,t1.Q5FECHAENTRADA Q5FECHAENTRADA,t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA,t1.Q5ID_PERFILFIRMA Q5IDPERFILFIRMA,t1.Q5ESTADODOCUMENTO Q5ESTADODOCUMENTO,t1.Q5FECHASOLFIRMA Q5FECHASOLFIRMA,t1.Q5FECHALIMFIRMA Q5FECHALIMFIRMA,t1.Q5FECHAFIRMA Q5FECHAFIRMA,t1.Q5COMOFIRMA Q5COMOFIRMA,t1.Q5ID_TIPODOC Q5IDTIPODOC,t1.Q5DESTINO Q5DESTINO, t1.Q5FECHASOLLOCALIZADOR Q5FECHASOLLOCALIZADOR, t1.Q5PTCODIGO Q5PTCODIGO, t2.PCODIGO PCODIGO, t1.Q5HASHFILE Q5HASHFILE, t1.Q5FECHAREGISTROORIGEN Q5FECHAREGISTROORIGEN, t1.Q5NUMREGISTROORIGEN Q5NUMREGISTROORIGEN ");
		query.append("FROM DOCUMENTO_HECHO t1, DOC_TRAMITE_HECHO t2  WHERE t1.Q5CODOCUMENTO=t2.CODOCUMENTO ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t2.EHCODIGO = ? ");
		params.add(tramiteComun.getIdTramite());

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoHecho>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosTramiteCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOCUMENTO_HECHO t1, DOC_TRAMITE_HECHO t2  WHERE t1.Q5CODOCUMENTO=t2.CODOCUMENTO ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t2.EHCODIGO = ? ");
		params.add(tramiteComun.getIdTramite());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosHecho(TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5HDCODIGO Q5HDCODIGO,t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE,t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN, NVL (Q5FECHAREGISTROORIGEN, NVL (t1.Q5FECHAENTRADA, t1.Q5FECHA)) Q5FECHA,t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t1.Q5FECHAAPORTACION Q5FECHAAPORTACION,t1.Q5FECHAENTRADA Q5FECHAENTRADA,t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE, t1.Q5HASHFILE Q5HASHFILE ");
		query.append("FROM DOCUMENTO_HECHO t1,TIPO_DOCUMENTO t2 WHERE t1.Q5ID_TIPODOC = t2.ID_TIPODOC(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoExpediente>() {
					public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new DocumentoExpediente(resultSet.getString("Q5CODOCUMENTO"),
								resultSet.getString("Q5HDCODIGO"), resultSet.getString("Q5NOFILE"),
								resultSet.getBlob("Q5DATAFILE"), resultSet.getInt("Q5SIZEFILE"),
								resultSet.getString("Q5CONTENTTYPEFILE"), resultSet.getString("Q5TEDESFILE"),
								resultSet.getString("Q5ORIGEN"), resultSet.getDate("Q5FECHA"),
								resultSet.getString("Q5IDDOCUMENTUM"), resultSet.getDate("Q5FECHAAPORTACION"),
								resultSet.getDate("Q5FECHAENTRADA"), resultSet.getString("Q5NUMREGISTROENTRADA"),
								resultSet.getString("IDTIPODOC"), resultSet.getString("TDNOMBRE"),
								resultSet.getString("TDNOMBREE"), null, null, null, null, null, null, null, null);
					}
				}, params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param ids
	 *            List<String>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosHechoByIds(TramiteComun tramiteComun, List<String> ids,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5HDCODIGO Q5HDCODIGO,t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE,t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN, NVL (Q5FECHAREGISTROORIGEN, NVL (t1.Q5FECHAENTRADA, t1.Q5FECHA)) Q5FECHA,t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t1.Q5FECHAAPORTACION Q5FECHAAPORTACION,t1.Q5FECHAENTRADA Q5FECHAENTRADA,t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");
		query.append("FROM DOCUMENTO_HECHO t1,TIPO_DOCUMENTO t2 WHERE t1.Q5ID_TIPODOC = t2.ID_TIPODOC(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		StringBuffer idsdocumentos = new StringBuffer();
		for (int posId = 0; posId < ids.size(); posId++) {
			if (posId > 0) {
				idsdocumentos.append(",");
			}
			idsdocumentos.append("'").append((String) ids.get(posId)).append("'");
		}
		where.append(" AND  t1.Q5CODOCUMENTO IN (" + idsdocumentos.toString() + ")");

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoExpediente>() {
					public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new DocumentoExpediente(resultSet.getString("Q5CODOCUMENTO"),
								resultSet.getString("Q5HDCODIGO"), resultSet.getString("Q5NOFILE"),
								resultSet.getBlob("Q5DATAFILE"), resultSet.getInt("Q5SIZEFILE"),
								resultSet.getString("Q5CONTENTTYPEFILE"), resultSet.getString("Q5TEDESFILE"),
								resultSet.getString("Q5ORIGEN"), resultSet.getDate("Q5FECHA"),
								resultSet.getString("Q5IDDOCUMENTUM"), resultSet.getDate("Q5FECHAAPORTACION"),
								resultSet.getDate("Q5FECHAENTRADA"), resultSet.getString("Q5NUMREGISTROENTRADA"),
								resultSet.getString("IDTIPODOC"), resultSet.getString("TDNOMBRE"),
								resultSet.getString("TDNOMBREE"), null, null, null, null, null, null, null, null);
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosHechoCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOCUMENTO_HECHO t1,TIPO_DOCUMENTO t2 WHERE t1.Q5ID_TIPODOC = t2.ID_TIPODOC(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosHechoInspeccion(TramiteComun tramiteComun,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5HDCODIGO Q5HDCODIGO,t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE,t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN, NVL (Q5FECHAREGISTROORIGEN, NVL (t1.Q5FECHAENTRADA, t1.Q5FECHA)) Q5FECHA,t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t1.Q5FECHAAPORTACION Q5FECHAAPORTACION,t1.Q5FECHAENTRADA Q5FECHAENTRADA,t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");
		query.append(
				"FROM DOCUMENTO_HECHO t1, INSPECCIONES_TIPO_DOCUMENTO t2 WHERE t1.Q5ID_TIPODOC = t2.ID_TIPODOC(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoExpediente>() {
					public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new DocumentoExpediente(resultSet.getString("Q5CODOCUMENTO"),
								resultSet.getString("Q5HDCODIGO"), resultSet.getString("Q5NOFILE"),
								resultSet.getBlob("Q5DATAFILE"), resultSet.getInt("Q5SIZEFILE"),
								resultSet.getString("Q5CONTENTTYPEFILE"), resultSet.getString("Q5TEDESFILE"),
								resultSet.getString("Q5ORIGEN"), resultSet.getDate("Q5FECHA"),
								resultSet.getString("Q5IDDOCUMENTUM"), resultSet.getDate("Q5FECHAAPORTACION"),
								resultSet.getDate("Q5FECHAENTRADA"), resultSet.getString("Q5NUMREGISTROENTRADA"),
								resultSet.getString("IDTIPODOC"), resultSet.getString("TDNOMBRE"),
								resultSet.getString("TDNOMBREE"), null, null, null, null, null, null, null, null);
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosHechoInspeccionCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOCUMENTO_HECHO t1, INSPECCIONES_TIPO_DOCUMENTO t2 WHERE t1.Q5ID_TIPODOC = t2.ID_TIPODOC(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosMisGestiones(TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5HDCODIGO Q5HDCODIGO,t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE,t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN, t1.Q5FECHA Q5FECHA,t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t1.Q5FECHAAPORTACION Q5FECHAAPORTACION,t1.Q5FECHAENTRADA Q5FECHAENTRADA,t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");
		query.append("FROM DOCUMENTO_HECHO t1,TIPO_DOCUMENTO t2 WHERE t1.Q5ID_TIPODOC = t2.ID_TIPODOC(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		where.append(" AND t1.Q5ORIGEN = ? ");
		params.add(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE);

		where.append(" AND t1.Q5IDDOCUMENTUM IS NOT NULL ");

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoExpediente>() {
					public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new DocumentoExpediente(resultSet.getString("Q5CODOCUMENTO"),
								resultSet.getString("Q5HDCODIGO"), resultSet.getString("Q5NOFILE"),
								resultSet.getBlob("Q5DATAFILE"), resultSet.getInt("Q5SIZEFILE"),
								resultSet.getString("Q5CONTENTTYPEFILE"), resultSet.getString("Q5TEDESFILE"),
								resultSet.getString("Q5ORIGEN"), resultSet.getDate("Q5FECHA"),
								resultSet.getString("Q5IDDOCUMENTUM"), resultSet.getDate("Q5FECHAAPORTACION"),
								resultSet.getDate("Q5FECHAENTRADA"), resultSet.getString("Q5NUMREGISTROENTRADA"),
								resultSet.getString("IDTIPODOC"), resultSet.getString("TDNOMBRE"),
								resultSet.getString("TDNOMBREE"), null, null, null, null, null, null, null, null);
					}
				}, params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosHechoComunicacion(TramiteComun tramiteComun,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5HDCODIGO Q5HDCODIGO,t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE,t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN, NVL (Q5FECHAREGISTROORIGEN, NVL (t1.Q5FECHAENTRADA, t1.Q5FECHA)) Q5FECHA,t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t1.Q5FECHAAPORTACION Q5FECHAAPORTACION,t1.Q5FECHAENTRADA Q5FECHAENTRADA,t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");
		query.append("FROM DOCUMENTO_HECHO t1,TIPO_DOCUMENTO t2 WHERE t1.Q5ID_TIPODOC = t2.ID_TIPODOC(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		// Cuando el tipo de tramite es K51 y viene de adjuntar documento,
		// solo hay que sacar los tipos documentales de este tipo tramite
		if (Y41bConstantes.TRAMITE_RESPUESTA_COLABORACION.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t2.ID_TIPODOC = '" + Y41bConstantes.TIPO_DOC_RESP_SOL_COLABORACION + "'");
		}

		where.append(
				" AND (t1.Q5TRAMITE IN (SELECT tt1.EHCODIGO FROM TRAMITE_HECHO tt1 WHERE tt1.EHCOHD=? AND (tt1.EHESTADOTRAMITE=? OR tt1.EHESTADOTRAMITE IS NULL))");
		params.add(tramiteComun.getIdExpediente());
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		where.append(" OR t1.Q5TRAMITE IS NULL)");
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoExpediente>() {
					public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new DocumentoExpediente(resultSet.getString("Q5CODOCUMENTO"),
								resultSet.getString("Q5HDCODIGO"), resultSet.getString("Q5NOFILE"),
								resultSet.getBlob("Q5DATAFILE"), resultSet.getInt("Q5SIZEFILE"),
								resultSet.getString("Q5CONTENTTYPEFILE"), resultSet.getString("Q5TEDESFILE"),
								resultSet.getString("Q5ORIGEN"), resultSet.getDate("Q5FECHA"),
								resultSet.getString("Q5IDDOCUMENTUM"), resultSet.getDate("Q5FECHAAPORTACION"),
								resultSet.getDate("Q5FECHAENTRADA"), resultSet.getString("Q5NUMREGISTROENTRADA"),
								resultSet.getString("IDTIPODOC"), resultSet.getString("TDNOMBRE"),
								resultSet.getString("TDNOMBREE"), null, null, null, null, null, null, null, null);
					}
				}, params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosHechoInspeccionComunicacion(TramiteComun tramiteComun,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5HDCODIGO Q5HDCODIGO,t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE,t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN, NVL (Q5FECHAREGISTROORIGEN, NVL (t1.Q5FECHAENTRADA, t1.Q5FECHA)) Q5FECHA,t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t1.Q5FECHAAPORTACION Q5FECHAAPORTACION,t1.Q5FECHAENTRADA Q5FECHAENTRADA,t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");
		query.append(
				"FROM DOCUMENTO_HECHO t1,INSPECCIONES_TIPO_DOCUMENTO t2 WHERE t1.Q5ID_TIPODOC = t2.ID_TIPODOC(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		if (Y41bConstantes.TRAMITE_INSPECCIONES_RESULTADO_ENSAYOS.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t2.ID_TIPODOC = '" + Y41bConstantes.TIPO_DOC_INFORME + "'");
		} else if (Y41bConstantes.TRAMITE_INSPECCIONES_INFORME_VALORACION.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND (t2.ID_TIPODOC = '" + Y41bConstantes.TIPO_DOC_INS_INFORME_INSPECCION + "'");
			where.append(" OR t2.ID_TIPODOC = '" + Y41bConstantes.TIPO_DOC_ACTA_INSP + "')");
		}

		where.append(
				" AND (t1.Q5TRAMITE IN (SELECT tt1.TICODIGO FROM TRAMITE_INSPECCION tt1 WHERE tt1.TIATCODIGO=? AND (tt1.TIESTADOTRAMITE=? OR tt1.TIESTADOTRAMITE IS NULL))");
		params.add(tramiteComun.getIdExpediente());
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		where.append(" OR ((SELECT COUNT(1) FROM TRAMITE_INSPECCION tt2 WHERE tt2.TIACCODIGO = t1.Q5TRAMITE) > 0) ");

		where.append(" OR t1.Q5TRAMITE IS NULL)");
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoExpediente>() {
					public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new DocumentoExpediente(resultSet.getString("Q5CODOCUMENTO"),
								resultSet.getString("Q5HDCODIGO"), resultSet.getString("Q5NOFILE"),
								resultSet.getBlob("Q5DATAFILE"), resultSet.getInt("Q5SIZEFILE"),
								resultSet.getString("Q5CONTENTTYPEFILE"), resultSet.getString("Q5TEDESFILE"),
								resultSet.getString("Q5ORIGEN"), resultSet.getDate("Q5FECHA"),
								resultSet.getString("Q5IDDOCUMENTUM"), resultSet.getDate("Q5FECHAAPORTACION"),
								resultSet.getDate("Q5FECHAENTRADA"), resultSet.getString("Q5NUMREGISTROENTRADA"),
								resultSet.getString("IDTIPODOC"), resultSet.getString("TDNOMBRE"),
								resultSet.getString("TDNOMBREE"), null, null, null, null, null, null, null, null);
					}
				}, params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosHechoInspeccionComunicacionOrigenExpediente(
			TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5HDCODIGO Q5HDCODIGO,t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE,t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN, NVL (Q5FECHAREGISTROORIGEN, NVL (t1.Q5FECHAENTRADA, t1.Q5FECHA)) Q5FECHA,t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t1.Q5FECHAAPORTACION Q5FECHAAPORTACION,t1.Q5FECHAENTRADA Q5FECHAENTRADA,t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");
		query.append(
				"FROM DOCUMENTO_HECHO t1,INSPECCIONES_TIPO_DOCUMENTO t2 WHERE t1.Q5ID_TIPODOC = t2.ID_TIPODOC(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoExpediente>() {
					public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new DocumentoExpediente(resultSet.getString("Q5CODOCUMENTO"),
								resultSet.getString("Q5HDCODIGO"), resultSet.getString("Q5NOFILE"),
								resultSet.getBlob("Q5DATAFILE"), resultSet.getInt("Q5SIZEFILE"),
								resultSet.getString("Q5CONTENTTYPEFILE"), resultSet.getString("Q5TEDESFILE"),
								resultSet.getString("Q5ORIGEN"), resultSet.getDate("Q5FECHA"),
								resultSet.getString("Q5IDDOCUMENTUM"), resultSet.getDate("Q5FECHAAPORTACION"),
								resultSet.getDate("Q5FECHAENTRADA"), resultSet.getString("Q5NUMREGISTROENTRADA"),
								resultSet.getString("IDTIPODOC"), resultSet.getString("TDNOMBRE"),
								resultSet.getString("TDNOMBREE"), null, null, null, null, null, null, null, null);
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosAdjuntosOrigenExpedienteCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOCUMENTO_HECHO t1,INSPECCIONES_TIPO_DOCUMENTO t2 WHERE t1.Q5ID_TIPODOC = t2.ID_TIPODOC(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosHechoInspeccionComunicacionCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOCUMENTO_HECHO t1,INSPECCIONES_TIPO_DOCUMENTO t2 WHERE t1.Q5ID_TIPODOC = t2.ID_TIPODOC(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		if (Y41bConstantes.TRAMITE_INSPECCIONES_RESULTADO_ENSAYOS.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t2.ID_TIPODOC = '" + Y41bConstantes.TIPO_DOC_INFORME + "'");
		} else if (Y41bConstantes.TRAMITE_INSPECCIONES_INFORME_VALORACION.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND (t2.ID_TIPODOC = '" + Y41bConstantes.TIPO_DOC_INS_INFORME_INSPECCION + "'");
			where.append(" OR t2.ID_TIPODOC = '" + Y41bConstantes.TIPO_DOC_ACTA_INSP + "')");
		}

		where.append(
				" AND (t1.Q5TRAMITE IN (SELECT tt1.TICODIGO FROM TRAMITE_INSPECCION tt1 WHERE tt1.TIATCODIGO=? AND (tt1.TIESTADOTRAMITE=? OR tt1.TIESTADOTRAMITE IS NULL))");

		params.add(tramiteComun.getIdExpediente());
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		where.append(" OR ((SELECT COUNT(1) FROM TRAMITE_INSPECCION tt2 WHERE tt2.TIACCODIGO = t1.Q5TRAMITE) > 0) ");

		where.append(" OR t1.Q5TRAMITE IS NULL)");

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosHechoExpedientesRelacionados(TramiteComun tramiteComun,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct PCODIGO,Q5CODOCUMENTO,Q5HDCODIGO,Q5NOFILE,Q5SIZEFILE,Q5TEDESFILE,Q5ORIGEN,Q5TRAMITE,Q5FECHA,Q5INDMAIL,Q5TRMAIL,Q5CONTENTTYPEFILE,Q5ID_TIPODOC,Q5FECHAAPORTACION,Q5FECHAENTRADA,Q5NUMREGISTROENTRADA,Q5ID_PERFILFIRMA,Q5ESTADODOCUMENTO,Q5FECHASOLFIRMA,Q5FECHALIMFIRMA,Q5FECHAFIRMA,Q5COMOFIRMA,Q5IDDOCUMENTUM,Q5DESTINO,Q5FECHASOLLOCALIZADOR,Q5PTCODIGO,Q5NUMREGISTROORIGEN,Q5FECHAREGISTROORIGEN ");
		query.append("FROM DOCUMENTO_HECHO t1, DOC_TRAMITE_HECHO t2  WHERE 1=1 AND t1.Q5CODOCUMENTO=t2.CODOCUMENTO ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();

		where.append(
				" AND ((Q5TRAMITE IN (SELECT tt1.EHCODIGO FROM TRAMITE_HECHO tt1 WHERE tt1.EHCOHD=Q5HDCODIGO AND (tt1.EHESTADOTRAMITE=? OR tt1.EHESTADOTRAMITE IS NULL)) OR Q5TRAMITE IS NULL)");
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		where.append(
				" OR Q5TRAMITE IN (SELECT TO_CHAR(tt1.TRID) FROM SANTRAMEXP tt1 WHERE tt1.TREXCODIGO=Q5HDCODIGO AND (tt1.TRESTADO=?))");
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		where.append(
				" OR Q5TRAMITE IN (SELECT TO_CHAR(tt1.TRID) FROM ARBTRAMEXP tt1 WHERE tt1.TREXCODIGO=Q5HDCODIGO AND (tt1.TRESTADO=?))");
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		where.append(
				" OR Q5TRAMITE IN (SELECT tt1.TICODIGO FROM TRAMITE_INSPECCION tt1 WHERE tt1.TIATCODIGO = Q5HDCODIGO AND (tt1.TIESTADOTRAMITE =? OR tt1.TIESTADOTRAMITE IS NULL))");
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		where.append(" OR ((SELECT COUNT(1) FROM TRAMITE_INSPECCION tt2 WHERE tt2.TIACCODIGO = t1.Q5TRAMITE) > 0) ");

		where.append(")");
		where.append(" AND Q5HDCODIGO = ?");
		params.add(tramiteComun.getIdExpediente());

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoExpediente>() {
					public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new DocumentoExpediente(resultSet.getString("Q5CODOCUMENTO"),
								resultSet.getString("Q5HDCODIGO"), resultSet.getString("Q5NOFILE"), null,
								resultSet.getInt("Q5SIZEFILE"), resultSet.getString("Q5CONTENTTYPEFILE"),
								resultSet.getString("Q5TEDESFILE"), resultSet.getString("Q5ORIGEN"),
								resultSet.getDate("Q5FECHA"), resultSet.getString("Q5IDDOCUMENTUM"),
								resultSet.getDate("Q5FECHAAPORTACION"), resultSet.getDate("Q5FECHAENTRADA"),
								resultSet.getString("Q5NUMREGISTROENTRADA"), resultSet.getString("Q5ID_TIPODOC"), null,
								null, null, null, null, null, null, null, null, resultSet.getString("PCODIGO"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosHechoExpedientesRelacionadosCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(distinct Q5CODOCUMENTO) FROM DOCUMENTO_HECHO t1, DOC_TRAMITE_HECHO t2  WHERE 1=1 AND t1.Q5CODOCUMENTO=t2.CODOCUMENTO ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();

		where.append(
				" AND ((Q5TRAMITE IN (SELECT tt1.EHCODIGO FROM TRAMITE_HECHO tt1 WHERE tt1.EHCOHD=Q5HDCODIGO AND (tt1.EHESTADOTRAMITE=? OR tt1.EHESTADOTRAMITE IS NULL)) OR Q5TRAMITE IS NULL)");
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		where.append(
				" OR Q5TRAMITE IN (SELECT TO_CHAR(tt1.TRID) FROM SANTRAMEXP tt1 WHERE tt1.TREXCODIGO=Q5HDCODIGO AND (tt1.TRESTADO=?))");
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		where.append(
				" OR Q5TRAMITE IN (SELECT TO_CHAR(tt1.TRID) FROM ARBTRAMEXP tt1 WHERE tt1.TREXCODIGO=Q5HDCODIGO AND (tt1.TRESTADO=?))");
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		where.append(
				" OR Q5TRAMITE IN (SELECT tt1.TICODIGO FROM TRAMITE_INSPECCION tt1 WHERE tt1.TIATCODIGO = Q5HDCODIGO AND (tt1.TIESTADOTRAMITE =? OR tt1.TIESTADOTRAMITE IS NULL))");
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		where.append(" OR ((SELECT COUNT(1) FROM TRAMITE_INSPECCION tt2 WHERE tt2.TIACCODIGO = t1.Q5TRAMITE) > 0) ");

		where.append(")");

		where.append(" AND Q5HDCODIGO = ?");
		params.add(tramiteComun.getIdExpediente());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOCUMENTO_HECHO t1,TIPO_DOCUMENTO t2 WHERE t1.Q5ID_TIPODOC = t2.ID_TIPODOC(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		// Cuando el tipo de tramite es K51 y viene de adjuntar documento,
		// solo hay que sacar los tipos documentales de este tipo tramite
		if (Y41bConstantes.TRAMITE_RESPUESTA_COLABORACION.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t2.ID_TIPODOC = '" + Y41bConstantes.TIPO_DOC_RESP_SOL_COLABORACION + "'");
		}

		where.append(
				" AND (t1.Q5TRAMITE IN (SELECT tt1.EHCODIGO FROM TRAMITE_HECHO tt1 WHERE tt1.EHCOHD=? AND (tt1.EHESTADOTRAMITE=? OR tt1.EHESTADOTRAMITE IS NULL))");
		params.add(tramiteComun.getIdExpediente());
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		where.append(" OR t1.Q5TRAMITE IS NULL)");

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the DocumentoHecho table using like.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoHecho> findAllLike(DocumentoHecho documentoHecho, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5HDCODIGO Q5HDCODIGO,t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE,t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN,t1.Q5TRAMITE Q5TRAMITE,t1.Q5FECHA Q5FECHA,t1.Q5INDMAIL Q5INDMAIL,t1.Q5TRMAIL Q5TRMAIL,t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t1.Q5FECHAAPORTACION Q5FECHAAPORTACION,t1.Q5FECHAENTRADA Q5FECHAENTRADA,t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA,t1.Q5ID_PERFILFIRMA Q5IDPERFILFIRMA,t1.Q5ESTADODOCUMENTO Q5ESTADODOCUMENTO,t1.Q5FECHASOLFIRMA Q5FECHASOLFIRMA,t1.Q5FECHALIMFIRMA Q5FECHALIMFIRMA,t1.Q5FECHAFIRMA Q5FECHAFIRMA,t1.Q5COMOFIRMA Q5COMOFIRMA,t1.Q5ID_TIPODOC Q5IDTIPODOC,t1.Q5DESTINO Q5DESTINO, t1.Q5FECHASOLLOCALIZADOR Q5FECHASOLLOCALIZADOR, t1.Q5PTCODIGO Q5PTCODIGO, null PCODIGO, t1.Q5HASHFILE Q5HASHFILE, t1.Q5FECHAREGISTROORIGEN Q5FECHAREGISTROORIGEN, t1.Q5NUMREGISTROORIGEN Q5NUMREGISTROORIGEN ");
		query.append("FROM DOCUMENTO_HECHO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(documentoHecho, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoHecho>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DocumentoHecho table using like.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DocumentoHecho documentoHecho, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM DOCUMENTO_HECHO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(documentoHecho, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DocumentoHecho entity
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DocumentoHecho documentoHecho) {

		StringBuilder where = new StringBuilder(DocumentoHechoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (documentoHecho != null && documentoHecho.getQ5codocumento() != null) {
			where.append(" AND t1.Q5CODOCUMENTO = ?");
			params.add(documentoHecho.getQ5codocumento());
		}
		if (documentoHecho != null && documentoHecho.getQ5hdcodigo() != null) {
			where.append(" AND t1.Q5HDCODIGO = ?");
			params.add(documentoHecho.getQ5hdcodigo());
		}
		if (documentoHecho != null && documentoHecho.getQ5nofile() != null) {
			where.append(" AND t1.Q5NOFILE = ?");
			params.add(documentoHecho.getQ5nofile());
		}
		if (documentoHecho != null && documentoHecho.getQ5sizefile() != null) {
			where.append(" AND t1.Q5SIZEFILE = ?");
			params.add(documentoHecho.getQ5sizefile());
		}
		if (documentoHecho != null && documentoHecho.getQ5tedesfile() != null) {
			where.append(" AND t1.Q5TEDESFILE = ?");
			params.add(documentoHecho.getQ5tedesfile());
		}
		if (documentoHecho != null && documentoHecho.getQ5origen() != null) {
			where.append(" AND t1.Q5ORIGEN = ?");
			params.add(documentoHecho.getQ5origen());
		}
		if (documentoHecho != null && documentoHecho.getQ5tramite() != null) {
			where.append(" AND t1.Q5TRAMITE = ?");
			params.add(documentoHecho.getQ5tramite());
		}
		if (documentoHecho != null && documentoHecho.getQ5fecha() != null) {
			where.append(" AND t1.Q5FECHA = ?");
			params.add(documentoHecho.getQ5fecha());
		}
		if (documentoHecho != null && documentoHecho.getQ5indmail() != null) {
			where.append(" AND t1.Q5INDMAIL = ?");
			params.add(documentoHecho.getQ5indmail());
		}
		if (documentoHecho != null && documentoHecho.getQ5trmail() != null) {
			where.append(" AND t1.Q5TRMAIL = ?");
			params.add(documentoHecho.getQ5trmail());
		}
		if (documentoHecho != null && documentoHecho.getQ5contenttypefile() != null) {
			where.append(" AND t1.Q5CONTENTTYPEFILE = ?");
			params.add(documentoHecho.getQ5contenttypefile());
		}
		if (documentoHecho != null && documentoHecho.getQ5iddocumentum() != null) {
			where.append(" AND t1.Q5IDDOCUMENTUM = ?");
			params.add(documentoHecho.getQ5iddocumentum());
		}
		if (documentoHecho != null && documentoHecho.getQ5fechaaportacion() != null) {
			where.append(" AND t1.Q5FECHAAPORTACION = ?");
			params.add(documentoHecho.getQ5fechaaportacion());
		}
		if (documentoHecho != null && documentoHecho.getQ5fechaentrada() != null) {
			where.append(" AND t1.Q5FECHAENTRADA = ?");
			params.add(documentoHecho.getQ5fechaentrada());
		}
		if (documentoHecho != null && documentoHecho.getQ5numregistroentrada() != null) {
			where.append(" AND t1.Q5NUMREGISTROENTRADA = ?");
			params.add(documentoHecho.getQ5numregistroentrada());
		}
		if (documentoHecho != null && documentoHecho.getQ5idPerfilfirma() != null) {
			where.append(" AND t1.Q5ID_PERFILFIRMA = ?");
			params.add(documentoHecho.getQ5idPerfilfirma());
		}
		if (documentoHecho != null && documentoHecho.getQ5estadodocumento() != null) {
			where.append(" AND t1.Q5ESTADODOCUMENTO = ?");
			params.add(documentoHecho.getQ5estadodocumento());
		}
		if (documentoHecho != null && documentoHecho.getQ5fechasolfirma() != null) {
			where.append(" AND t1.Q5FECHASOLFIRMA = ?");
			params.add(documentoHecho.getQ5fechasolfirma());
		}
		if (documentoHecho != null && documentoHecho.getQ5fechalimfirma() != null) {
			where.append(" AND t1.Q5FECHALIMFIRMA = ?");
			params.add(documentoHecho.getQ5fechalimfirma());
		}
		if (documentoHecho != null && documentoHecho.getQ5fechafirma() != null) {
			where.append(" AND t1.Q5FECHAFIRMA = ?");
			params.add(documentoHecho.getQ5fechafirma());
		}
		if (documentoHecho != null && documentoHecho.getQ5comofirma() != null) {
			where.append(" AND t1.Q5COMOFIRMA = ?");
			params.add(documentoHecho.getQ5comofirma());
		}
		if (documentoHecho != null && documentoHecho.getQ5idTipodoc() != null) {
			where.append(" AND t1.Q5ID_TIPODOC = ?");
			params.add(documentoHecho.getQ5idTipodoc());
		}
		if (documentoHecho != null && documentoHecho.getQ5destino() != null) {
			where.append(" AND t1.Q5DESTINO = ?");
			params.add(documentoHecho.getQ5destino());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DocumentoHecho entity
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(DocumentoHecho documentoHecho, Boolean startsWith) {

		StringBuilder where = new StringBuilder(DocumentoHechoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (documentoHecho != null && documentoHecho.getQ5codocumento() != null) {
			where.append(" AND t1.Q5CODOCUMENTO = ?");
			params.add(documentoHecho.getQ5codocumento());
		}
		if (documentoHecho != null && documentoHecho.getQ5hdcodigo() != null) {
			where.append(" AND UPPER(t1.Q5HDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5hdcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5hdcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5HDCODIGO IS NOT NULL");
		}
		if (documentoHecho != null && documentoHecho.getQ5nofile() != null) {
			where.append(" AND UPPER(t1.Q5NOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5nofile().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5nofile().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5NOFILE IS NOT NULL");
		}
		if (documentoHecho != null && documentoHecho.getQ5sizefile() != null) {
			where.append(" AND t1.Q5SIZEFILE = ?");
			params.add(documentoHecho.getQ5sizefile());
		}
		if (documentoHecho != null && documentoHecho.getQ5tedesfile() != null) {
			where.append(" AND UPPER(t1.Q5TEDESFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5tedesfile().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5tedesfile().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5TEDESFILE IS NOT NULL");
		}
		if (documentoHecho != null && documentoHecho.getQ5origen() != null) {
			where.append(" AND UPPER(t1.Q5ORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5origen().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5origen().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5ORIGEN IS NOT NULL");
		}
		if (documentoHecho != null && documentoHecho.getQ5tramite() != null) {
			where.append(" AND UPPER(t1.Q5TRAMITE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5tramite().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5tramite().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5TRAMITE IS NOT NULL");
		}
		if (documentoHecho != null && documentoHecho.getQ5fecha() != null) {
			where.append(" AND t1.Q5FECHA = ?");
			params.add(documentoHecho.getQ5fecha());
		}
		if (documentoHecho != null && documentoHecho.getQ5indmail() != null) {
			where.append(" AND UPPER(t1.Q5INDMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5indmail().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5indmail().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5INDMAIL IS NOT NULL");
		}
		if (documentoHecho != null && documentoHecho.getQ5trmail() != null) {
			where.append(" AND UPPER(t1.Q5TRMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5trmail().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5trmail().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5TRMAIL IS NOT NULL");
		}
		if (documentoHecho != null && documentoHecho.getQ5contenttypefile() != null) {
			where.append(" AND UPPER(t1.Q5CONTENTTYPEFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5contenttypefile().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5contenttypefile().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5CONTENTTYPEFILE IS NOT NULL");
		}
		if (documentoHecho != null && documentoHecho.getQ5iddocumentum() != null) {
			where.append(" AND UPPER(t1.Q5IDDOCUMENTUM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5iddocumentum().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5iddocumentum().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5IDDOCUMENTUM IS NOT NULL");
		}
		if (documentoHecho != null && documentoHecho.getQ5fechaaportacion() != null) {
			where.append(" AND t1.Q5FECHAAPORTACION = ?");
			params.add(documentoHecho.getQ5fechaaportacion());
		}
		if (documentoHecho != null && documentoHecho.getQ5fechaentrada() != null) {
			where.append(" AND t1.Q5FECHAENTRADA = ?");
			params.add(documentoHecho.getQ5fechaentrada());
		}
		if (documentoHecho != null && documentoHecho.getQ5numregistroentrada() != null) {
			where.append(" AND UPPER(t1.Q5NUMREGISTROENTRADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5numregistroentrada().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5numregistroentrada().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5NUMREGISTROENTRADA IS NOT NULL");
		}
		if (documentoHecho != null && documentoHecho.getQ5idPerfilfirma() != null) {
			where.append(" AND UPPER(t1.Q5ID_PERFILFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5idPerfilfirma().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5idPerfilfirma().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5ID_PERFILFIRMA IS NOT NULL");
		}
		if (documentoHecho != null && documentoHecho.getQ5estadodocumento() != null) {
			where.append(" AND UPPER(t1.Q5ESTADODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5estadodocumento().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5estadodocumento().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5ESTADODOCUMENTO IS NOT NULL");
		}
		if (documentoHecho != null && documentoHecho.getQ5fechasolfirma() != null) {
			where.append(" AND t1.Q5FECHASOLFIRMA = ?");
			params.add(documentoHecho.getQ5fechasolfirma());
		}
		if (documentoHecho != null && documentoHecho.getQ5fechalimfirma() != null) {
			where.append(" AND t1.Q5FECHALIMFIRMA = ?");
			params.add(documentoHecho.getQ5fechalimfirma());
		}
		if (documentoHecho != null && documentoHecho.getQ5fechafirma() != null) {
			where.append(" AND t1.Q5FECHAFIRMA = ?");
			params.add(documentoHecho.getQ5fechafirma());
		}
		if (documentoHecho != null && documentoHecho.getQ5comofirma() != null) {
			where.append(" AND UPPER(t1.Q5COMOFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5comofirma().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5comofirma().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5COMOFIRMA IS NOT NULL");
		}
		if (documentoHecho != null && documentoHecho.getQ5idTipodoc() != null) {
			where.append(" AND UPPER(t1.Q5ID_TIPODOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5idTipodoc().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5idTipodoc().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5ID_TIPODOC IS NOT NULL");
		}
		if (documentoHecho != null && documentoHecho.getQ5destino() != null) {
			where.append(" AND UPPER(t1.Q5DESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentoHecho.getQ5destino().toUpperCase() + "%");
			} else {
				params.add("%" + documentoHecho.getQ5destino().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5DESTINO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	@Transactional(readOnly = true)
	public DocumentoHecho findDocumentoHecho(DocumentoHecho documentohecho) {
		String query = "SELECT t1.Q5CODOCUMENTO Q5CODOCUMENTO, t1.Q5HDCODIGO Q5HDCODIGO, t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE, t1.Q5SIZEFILE Q5SIZEFILE, t1.Q5TEDESFILE Q5TEDESFILE, t1.Q5ORIGEN Q5ORIGEN, t1.Q5TRAMITE Q5TRAMITE, t1.Q5FECHA Q5FECHA, t1.Q5INDMAIL Q5INDMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE, t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM, t1.Q5DESTINO Q5DESTINO, t1.Q5FECHASOLLOCALIZADOR Q5FECHASOLLOCALIZADOR, t1.Q5PTCODIGO Q5PTCODIGO, t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t1.Q5FECHAENTRADA Q5FECHAENTRADA, t1.Q5HASHFILE Q5HASHFILE, t1.Q5FECHAREGISTROORIGEN Q5FECHAREGISTROORIGEN, t1.Q5NUMREGISTROORIGEN Q5NUMREGISTROORIGEN "
				+ "FROM DOCUMENTO_HECHO t1  " + "WHERE t1.Q5CODOCUMENTO = ? ";

		return (DocumentoHecho) this.jdbcTemplate.queryForObject(query, new RowMapper<DocumentoHecho>() {
			public DocumentoHecho mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new DocumentoHecho(resultSet.getString("Q5CODOCUMENTO"), resultSet.getString("Q5HDCODIGO"),
						resultSet.getString("Q5NOFILE"), resultSet.getBlob("Q5DATAFILE"),
						resultSet.getInt("Q5SIZEFILE"), resultSet.getString("Q5TEDESFILE"),
						resultSet.getString("Q5ORIGEN"), resultSet.getString("Q5TRAMITE"), resultSet.getDate("Q5FECHA"),
						resultSet.getString("Q5INDMAIL"), null, resultSet.getString("Q5CONTENTTYPEFILE"),
						resultSet.getString("Q5IDDOCUMENTUM"), null, resultSet.getTimestamp("Q5FECHAENTRADA"),
						resultSet.getString("Q5NUMREGISTROENTRADA"), null, null, null, null, null, null, null,
						resultSet.getString("Q5DESTINO"), resultSet.getTimestamp("Q5FECHASOLLOCALIZADOR"),
						resultSet.getString("Q5PTCODIGO"), null, resultSet.getString("Q5HASHFILE"),
						resultSet.getDate("Q5FECHAREGISTROORIGEN"), resultSet.getString("Q5NUMREGISTROORIGEN"));
			}
		}, documentohecho.getQ5codocumento());
	}

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	@Transactional(readOnly = true)
	public DocumentoHecho findDocumentoHechoByOIDDokusi(DocumentoHecho documentohecho) {
		try {
			String query = "SELECT t1.Q5CODOCUMENTO Q5CODOCUMENTO, t1.Q5NOFILE Q5NOFILE, t1.Q5SIZEFILE Q5SIZEFILE, t1.Q5TEDESFILE Q5TEDESFILE, t1.Q5ORIGEN Q5ORIGEN, t1.Q5FECHA Q5FECHA, t1.Q5INDMAIL Q5INDMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE, t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM, t1.Q5DESTINO Q5DESTINO, t1.Q5PTCODIGO Q5PTCODIGO, t1.Q5HASHFILE Q5HASHFILE,t1.Q5FECHAREGISTROORIGEN Q5FECHAREGISTROORIGEN, t1.Q5NUMREGISTROORIGEN Q5NUMREGISTROORIGEN "
					+ "FROM DOCUMENTO_HECHO t1  " + "WHERE t1.Q5IDDOCUMENTUM = ? ";
			return (DocumentoHecho) this.jdbcTemplate.queryForObject(query, new RowMapper<DocumentoHecho>() {
				public DocumentoHecho mapRow(ResultSet resultSet, int rowNum) throws SQLException {
					return new DocumentoHecho(resultSet.getString("Q5CODOCUMENTO"), null,
							resultSet.getString("Q5NOFILE"), null, resultSet.getInt("Q5SIZEFILE"),
							resultSet.getString("Q5TEDESFILE"), resultSet.getString("Q5ORIGEN"), null,
							resultSet.getDate("Q5FECHA"), resultSet.getString("Q5INDMAIL"), null,
							resultSet.getString("Q5CONTENTTYPEFILE"), resultSet.getString("Q5IDDOCUMENTUM"), null, null,
							null, null, null, null, null, null, null, null, resultSet.getString("Q5DESTINO"), null,
							resultSet.getString("Q5PTCODIGO"), null, resultSet.getString("Q5HASHFILE"),
							resultSet.getDate("Q5FECHAREGISTROORIGEN"), resultSet.getString("Q5NUMREGISTROORIGEN"));
				}
			}, documentohecho.getQ5iddocumentum());
		} catch (EmptyResultDataAccessException e) {
			return new DocumentoHecho();
		}
	}

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarDocs(TramiteComun tramiteComun) {

		String query = "INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, THPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO, THNUMREGISTROORIGEN, THFECHAREGISTROORIGEN, THIDINTERVINIENTE, THHASHFILE) SELECT t1.Q5CODOCUMENTO Q5CODOCUMENTO, t2.PCODIGO,  t1.Q5ID_PERFILFIRMA Q5IDPERFILFIRMA, t1.Q5ID_TIPODOC Q5IDTIPODOC, t1.Q5HDCODIGO Q5HDCODIGO, t2.EHCODIGO, t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE, t1.Q5SIZEFILE Q5SIZEFILE, t1.Q5TEDESFILE Q5TEDESFILE, t1.Q5ORIGEN Q5ORIGEN, t1.Q5TRAMITE Q5TRAMITE, t1.Q5FECHA Q5FECHA, t1.Q5INDMAIL Q5INDMAIL, t1.Q5TRMAIL Q5TRMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE, t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM, t1.Q5FECHAAPORTACION Q5FECHAAPORTACION, t1.Q5FECHAENTRADA Q5FECHAENTRADA, t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t1.Q5ESTADODOCUMENTO Q5ESTADODOCUMENTO, t1.Q5FECHASOLFIRMA Q5FECHASOLFIRMA, t1.Q5FECHALIMFIRMA Q5FECHALIMFIRMA, t1.Q5FECHAFIRMA Q5FECHAFIRMA, t1.Q5COMOFIRMA Q5COMOFIRMA, t1.Q5DESTINO Q5DESTINO, t1.Q5FECHASOLLOCALIZADOR Q5FECHASOLLOCALIZADOR, t1.Q5PTCODIGO Q5PTCODIGO, t1.Q5NUMREGISTROORIGEN Q5NUMREGISTROORIGEN, t1.Q5FECHAREGISTROORIGEN Q5FECHAREGISTROORIGEN, t1.Q5IDINTERVINIENTE Q5IDINTERVINIENTE, t1.Q5HASHFILE Q5HASHFILE FROM DOCUMENTO_HECHO t1, DOC_TRAMITE_HECHO t2  WHERE t1.Q5CODOCUMENTO=t2.CODOCUMENTO AND t2.EHCODIGO = ?";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite());
	}

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param claveTablaMaestra
	 *            String
	 */
	public void addAdjuntarDocs(String claveTablaMaestra) {

		String query = "INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, THPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO, THNUMREGISTROORIGEN, THFECHAREGISTROORIGEN, THHASHFILE) SELECT t1.Q5CODOCUMENTO Q5CODOCUMENTO, 'INS',  t1.Q5ID_PERFILFIRMA Q5IDPERFILFIRMA, t1.Q5ID_TIPODOC Q5IDTIPODOC, t1.Q5HDCODIGO Q5HDCODIGO, t1.Q5TRAMITE Q5TRAMITE, t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE, t1.Q5SIZEFILE Q5SIZEFILE, t1.Q5TEDESFILE Q5TEDESFILE, t1.Q5ORIGEN Q5ORIGEN, t1.Q5TRAMITE Q5TRAMITE, t1.Q5FECHA Q5FECHA, t1.Q5INDMAIL Q5INDMAIL, t1.Q5TRMAIL Q5TRMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE, t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM, t1.Q5FECHAAPORTACION Q5FECHAAPORTACION, t1.Q5FECHAENTRADA Q5FECHAENTRADA, t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t1.Q5ESTADODOCUMENTO Q5ESTADODOCUMENTO, t1.Q5FECHASOLFIRMA Q5FECHASOLFIRMA, t1.Q5FECHALIMFIRMA Q5FECHALIMFIRMA, t1.Q5FECHAFIRMA Q5FECHAFIRMA, t1.Q5COMOFIRMA Q5COMOFIRMA, t1.Q5DESTINO Q5DESTINO, t1.Q5FECHASOLLOCALIZADOR Q5FECHASOLLOCALIZADOR, t1.Q5PTCODIGO Q5PTCODIGO, t1.Q5NUMREGISTROORIGEN Q5NUMREGISTROORIGEN, t1.Q5FECHAREGISTROORIGEN Q5FECHAREGISTROORIGEN, t1.Q5HASHFILE Q5HASHFILE FROM DOCUMENTO_HECHO t1  WHERE t1.Q5HDCODIGO = ?";
		this.jdbcTemplate.update(query, claveTablaMaestra);
	}

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarDoc(DocumentoHecho documentoHecho, TramiteComun tramiteComun) {

		String query = "INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, THPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO, THNUMREGISTROORIGEN, THFECHAREGISTROORIGEN, THHASHFILE) SELECT t1.Q5CODOCUMENTO Q5CODOCUMENTO, '"
				+ documentoHecho.getQ5pcodigo()
				+ "',  t1.Q5ID_PERFILFIRMA Q5IDPERFILFIRMA, t1.Q5ID_TIPODOC Q5IDTIPODOC, t1.Q5HDCODIGO Q5HDCODIGO, '"
				+ tramiteComun.getIdTramite()
				+ "', t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE, t1.Q5SIZEFILE Q5SIZEFILE, t1.Q5TEDESFILE Q5TEDESFILE, t1.Q5ORIGEN Q5ORIGEN, t1.Q5TRAMITE Q5TRAMITE, t1.Q5FECHA Q5FECHA, t1.Q5INDMAIL Q5INDMAIL, t1.Q5TRMAIL Q5TRMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE, t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM, t1.Q5FECHAAPORTACION Q5FECHAAPORTACION, t1.Q5FECHAENTRADA Q5FECHAENTRADA, t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t1.Q5ESTADODOCUMENTO Q5ESTADODOCUMENTO, t1.Q5FECHASOLFIRMA Q5FECHASOLFIRMA, t1.Q5FECHALIMFIRMA Q5FECHALIMFIRMA, t1.Q5FECHAFIRMA Q5FECHAFIRMA, t1.Q5COMOFIRMA Q5COMOFIRMA, t1.Q5DESTINO Q5DESTINO, t1.Q5FECHASOLLOCALIZADOR Q5FECHASOLLOCALIZADOR, t1.Q5PTCODIGO Q5PTCODIGO, t1.Q5NUMREGISTROORIGEN Q5NUMREGISTROORIGEN, t1.Q5FECHAREGISTROORIGEN Q5FECHAREGISTROORIGEN, t1.Q5HASHFILE Q5HASHFILE FROM DOCUMENTO_HECHO t1 WHERE t1.Q5CODOCUMENTO = ?";
		this.jdbcTemplate.update(query, documentoHecho.getQ5codocumento());
	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarDocsTramiteHecho(TramiteComun tramiteComun) {

		String query = "INSERT INTO DOC_TRAMITE_HECHO (EHCODIGO, CODOCUMENTO, PCODIGO) SELECT THID_TRAMITE,THCODOCUMENTO,THPCODIGO FROM ADJUNTARDOCS WHERE THID_TRAMITE=? ";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite());
	}

	/**
	 * Inserts a single row in the DocumentoTramiteHecho table.
	 * 
	 * @param documentoTramiteHecho
	 *            DocumentoTramiteHecho
	 */
	public void addDocsTramiteHecho(DocumentoTramiteHecho documentoTramiteHecho) {
		String query = "INSERT INTO DOC_TRAMITE_HECHO (EHCODIGO, CODOCUMENTO, PCODIGO) VALUES (?,?,?) ";
		this.jdbcTemplate.update(query, documentoTramiteHecho.getEhcodigo(), documentoTramiteHecho.getCodocumento(),
				documentoTramiteHecho.getPcodigo());
	}

	/**
	 * Removes a single row in the DocumentoTramiteHecho table.
	 * 
	 * @param documentoTramiteHecho
	 *            DocumentoTramiteHecho
	 */
	public void removeDocsTramiteHecho(DocumentoTramiteHecho documentoTramiteHecho) {
		String query = "DELETE FROM DOC_TRAMITE_HECHO WHERE EHCODIGO = ?";
		this.jdbcTemplate.update(query, documentoTramiteHecho.getEhcodigo());
	}

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void removeAdjuntarDocsTramiteHecho(TramiteComun tramiteComun) {
		String query = "DELETE FROM DOC_TRAMITE_HECHO WHERE EHCODIGO = ?";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite());
	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param claveTablaMaestra
	 *            String
	 * @param claveTablaMaestraAlta
	 *            String
	 */
	public void addAllDocumentosAdjuntarDocs(String claveTablaMaestra, String claveTablaMaestraAlta) {

		String query = "INSERT INTO DOCUMENTO_HECHO	(Q5CODOCUMENTO, Q5HDCODIGO, Q5NOFILE, Q5DATAFILE, Q5SIZEFILE, Q5TEDESFILE, Q5ORIGEN, Q5TRAMITE, Q5FECHA, Q5INDMAIL, Q5TRMAIL, Q5CONTENTTYPEFILE, Q5IDDOCUMENTUM, Q5FECHAAPORTACION, Q5FECHAENTRADA, Q5NUMREGISTROENTRADA, Q5ID_PERFILFIRMA, Q5ESTADODOCUMENTO, Q5FECHASOLFIRMA, Q5FECHALIMFIRMA, Q5FECHAFIRMA, Q5COMOFIRMA, Q5ID_TIPODOC, Q5DESTINO, Q5FECHASOLLOCALIZADOR,Q5PTCODIGO,Q5NUMREGISTROORIGEN,Q5FECHAREGISTROORIGEN,Q5HASHFILE) SELECT THCODOCUMENTO, ?, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THID_TRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THID_PERFILFIRMA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THID_TIPODOC, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO,THNUMREGISTROORIGEN,THFECHAREGISTROORIGEN,THHASHFILE FROM ADJUNTARDOCS WHERE (1=1) AND THID_EXPEDIENTE=?";
		this.jdbcTemplate.update(query, claveTablaMaestra, claveTablaMaestraAlta);
	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun) {

		String query = "INSERT INTO DOCUMENTO_HECHO	(Q5CODOCUMENTO, Q5HDCODIGO, Q5NOFILE, Q5DATAFILE, Q5SIZEFILE, Q5TEDESFILE, Q5ORIGEN, Q5TRAMITE, Q5FECHA, Q5INDMAIL, Q5TRMAIL, Q5CONTENTTYPEFILE, Q5IDDOCUMENTUM, Q5FECHAAPORTACION, Q5FECHAENTRADA, Q5NUMREGISTROENTRADA, Q5ID_PERFILFIRMA, Q5ESTADODOCUMENTO, Q5FECHASOLFIRMA, Q5FECHALIMFIRMA, Q5FECHAFIRMA, Q5COMOFIRMA, Q5ID_TIPODOC, Q5DESTINO, Q5FECHASOLLOCALIZADOR,Q5PTCODIGO,Q5NUMREGISTROORIGEN,Q5FECHAREGISTROORIGEN, Q5IDINTERVINIENTE,Q5HASHFILE) SELECT THCODOCUMENTO, THID_EXPEDIENTE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THID_TRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THID_PERFILFIRMA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THID_TIPODOC, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO,THNUMREGISTROORIGEN,THFECHAREGISTROORIGEN, THIDINTERVINIENTE, THHASHFILE FROM ADJUNTARDOCS WHERE (1=1) AND THCODOCUMENTO NOT IN (SELECT Q5CODOCUMENTO FROM DOCUMENTO_HECHO) AND THID_TRAMITE=?";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite());
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void updateDocumentosHechoAdjuntarDocs(Adjuntardocs adjuntardocs, TramiteComun tramiteComun) {
		String query = "UPDATE DOCUMENTO_HECHO SET (Q5NOFILE, Q5DATAFILE, Q5SIZEFILE, Q5TEDESFILE, Q5ORIGEN, Q5FECHA, Q5INDMAIL, Q5TRMAIL, Q5CONTENTTYPEFILE, Q5IDDOCUMENTUM, Q5FECHAAPORTACION, Q5FECHAENTRADA, Q5NUMREGISTROENTRADA, Q5ID_PERFILFIRMA, Q5ESTADODOCUMENTO, Q5FECHASOLFIRMA, Q5FECHALIMFIRMA, Q5FECHAFIRMA, Q5COMOFIRMA, Q5ID_TIPODOC, Q5DESTINO, Q5FECHASOLLOCALIZADOR, Q5PTCODIGO,Q5NUMREGISTROORIGEN,Q5FECHAREGISTROORIGEN,Q5IDINTERVINIENTE,Q5HASHFILE) = (SELECT THNOFILE Q5NOFILE, THDATAFILE Q5DATAFILE, THSIZEFILE Q5SIZEFILE, THTEDESFILE Q5TEDESFILE, THORIGEN Q5ORIGEN, THFECHA Q5FECHA, THINDMAIL Q5INDMAIL, THTRMAIL Q5TRMAIL, THCONTENTTYPEFILE Q5CONTENTTYPEFILE, THIDDOCUMENTUM Q5IDDOCUMENTUM, THFECHAAPORTACION Q5FECHAAPORTACION, THFECHAENTRADA Q5FECHAENTRADA, THNUMREGISTROENTRADA Q5NUMREGISTROENTRADA, THID_PERFILFIRMA Q5ID_PERFILFIRMA, THESTADODOCUMENTO Q5ESTADODOCUMENTO, THFECHASOLFIRMA Q5FECHASOLFIRMA, THFECHALIMFIRMA Q5FECHALIMFIRMA, THFECHAFIRMA Q5FECHAFIRMA, THCOMOFIRMA Q5COMOFIRMA, THID_TIPODOC Q5ID_TIPODOC, THDESTINO Q5DESTINO, THFECHASOLLOCALIZADOR Q5FECHASOLLOCALIZADOR, THPTCODIGO Q5PTCODIGO,THNUMREGISTROORIGEN Q5NUMREGISTROORIGEN,THFECHAREGISTROORIGEN Q5FECHAREGISTROORIGEN, THIDINTERVINIENTE Q5IDINTERVINIENTE, THHASHFILE Q5HASHFILE FROM ADJUNTARDOCS WHERE (1=1) AND THCODOCUMENTO=? AND THID_TRAMITE=?) WHERE Q5CODOCUMENTO=?";

		this.jdbcTemplate.update(query, adjuntardocs.getThcodocumento(), tramiteComun.getIdTramite(),
				adjuntardocs.getThcodocumento());
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		try {
			List<Object> params = new ArrayList<Object>();

			StringBuffer query = new StringBuffer("SELECT SEQ_L21Q5T00.NEXTVAL FROM  DUAL ");
			return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
		} catch (Throwable e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosEliminados(TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.Q5CODOCUMENTO Q5CODOCUMENTO, t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM ");
		query.append("FROM DOCUMENTO_HECHO t1 WHERE 1=1 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5TRAMITE = ? ");
		params.add(tramiteComun.getIdTramite());

		where.append(
				" AND t1.Q5CODOCUMENTO NOT IN (SELECT tt1.THCODOCUMENTO FROM ADJUNTARDOCS tt1 WHERE tt1.THTRAMITE = ?)");
		params.add(tramiteComun.getIdTramite());

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoExpediente>() {
					public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new DocumentoExpediente(resultSet.getString("Q5CODOCUMENTO"),
								resultSet.getString("Q5IDDOCUMENTUM"));
					}
				}, params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosGeneradosTramite(TramiteComun tramiteComun,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.Q5CODOCUMENTO Q5CODOCUMENTO, t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM ");
		query.append("FROM DOCUMENTO_HECHO t1 WHERE 1=1 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5TRAMITE = ? ");
		params.add(tramiteComun.getIdTramite());

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoExpediente>() {
					public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new DocumentoExpediente(resultSet.getString("Q5CODOCUMENTO"),
								resultSet.getString("Q5IDDOCUMENTUM"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocTramiteHechoCount(DocumentoHecho documentoHecho) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM DOC_TRAMITE_HECHO WHERE 1=1 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND CODOCUMENTO = ? ");
		params.add(documentoHecho.getQ5codocumento());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	@Transactional(readOnly = true)
	public DocumentoHecho findActa(DocumentoHecho documentoHecho) {
		String query = "SELECT t1.Q5CODOCUMENTO Q5CODOCUMENTO, t1.Q5HDCODIGO Q5HDCODIGO, t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE, t1.Q5SIZEFILE Q5SIZEFILE, t1.Q5TEDESFILE Q5TEDESFILE, t1.Q5ORIGEN Q5ORIGEN, t1.Q5TRAMITE Q5TRAMITE, t1.Q5FECHA Q5FECHA, t1.Q5INDMAIL Q5INDMAIL, t1.Q5TRMAIL Q5TRMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE, t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM, t1.Q5FECHAAPORTACION Q5FECHAAPORTACION, t1.Q5FECHAENTRADA Q5FECHAENTRADA, t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t1.Q5ID_PERFILFIRMA Q5IDPERFILFIRMA, t1.Q5ESTADODOCUMENTO Q5ESTADODOCUMENTO, t1.Q5FECHASOLFIRMA Q5FECHASOLFIRMA, t1.Q5FECHALIMFIRMA Q5FECHALIMFIRMA, t1.Q5FECHAFIRMA Q5FECHAFIRMA, t1.Q5COMOFIRMA Q5COMOFIRMA, t1.Q5ID_TIPODOC Q5IDTIPODOC, t1.Q5DESTINO Q5DESTINO, t1.Q5FECHASOLLOCALIZADOR Q5FECHASOLLOCALIZADOR, t1.Q5PTCODIGO Q5PTCODIGO, t1.Q5HASHFILE Q5HASHFILE,t1.Q5FECHAREGISTROORIGEN Q5FECHAREGISTROORIGEN, t1.Q5NUMREGISTROORIGEN Q5NUMREGISTROORIGEN FROM DOCUMENTO_HECHO t1 WHERE t1.Q5ID_TIPODOC = ? AND t1.Q5TRAMITE = ?";

		List<DocumentoHecho> documentoHechoList = this.jdbcTemplate.query(query, new RowMapper<DocumentoHecho>() {
			public DocumentoHecho mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new DocumentoHecho(resultSet.getString("Q5CODOCUMENTO"), resultSet.getString("Q5HDCODIGO"),
						resultSet.getString("Q5NOFILE"), resultSet.getBlob("Q5DATAFILE"),
						resultSet.getInt("Q5SIZEFILE"), resultSet.getString("Q5TEDESFILE"),
						resultSet.getString("Q5ORIGEN"), resultSet.getString("Q5TRAMITE"), resultSet.getDate("Q5FECHA"),
						resultSet.getString("Q5INDMAIL"), resultSet.getString("Q5TRMAIL"),
						resultSet.getString("Q5CONTENTTYPEFILE"), resultSet.getString("Q5IDDOCUMENTUM"),
						resultSet.getDate("Q5FECHAAPORTACION"), resultSet.getDate("Q5FECHAENTRADA"),
						resultSet.getString("Q5NUMREGISTROENTRADA"), resultSet.getString("Q5IDPERFILFIRMA"),
						resultSet.getString("Q5ESTADODOCUMENTO"), resultSet.getDate("Q5FECHASOLFIRMA"),
						resultSet.getDate("Q5FECHALIMFIRMA"), resultSet.getDate("Q5FECHAFIRMA"),
						resultSet.getString("Q5COMOFIRMA"), resultSet.getString("Q5IDTIPODOC"),
						resultSet.getString("Q5DESTINO"), resultSet.getTimestamp("Q5FECHASOLLOCALIZADOR"),
						resultSet.getString("Q5PTCODIGO"), null, resultSet.getString("Q5HASHFILE"),
						resultSet.getDate("Q5FECHAREGISTROORIGEN"), resultSet.getString("Q5NUMREGISTROORIGEN"));
			}
		}, Y41bConstantes.TIPO_DOC_ACTA_INSP, documentoHecho.getQ5tramite());
		return (DocumentoHecho) DataAccessUtils.uniqueResult(documentoHechoList);
	}

	/////
	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocsMovilidad(InspeccionDetalle inspeccionDetalle, Pagination pagination,
			Campanha campanha, Alerta alerta, ComunicacionSoivre comunicacionSoivre, SolicitudDetalle solDetalle) {
		StringBuilder query = new StringBuilder(
				"SELECT  '1' as DE, t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5HDCODIGO Q5HDCODIGO,t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE,t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN, NVL (Q5FECHAREGISTROORIGEN, NVL (t1.Q5FECHAENTRADA, t1.Q5FECHA)) Q5FECHA,t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t1.Q5FECHAAPORTACION Q5FECHAAPORTACION,t1.Q5FECHAENTRADA Q5FECHAENTRADA,t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA,t1.Q5ATABLET Q5ATABLET, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");
		query.append(
				"FROM DOCUMENTO_HECHO t1,INSPECCIONES_TIPO_DOCUMENTO t2 WHERE t1.Q5ID_TIPODOC = t2.ID_TIPODOC(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ? ");
		params.add(inspeccionDetalle.getAtcodigo());

		query.append(where);

		if (campanha != null && campanha.getCmcodigo() != null) {
			query.append("UNION ALL ");
			query.append(
					"SELECT  '2' as DE, t3.Q5CODOCUMENTO Q5CODOCUMENTO,t3.Q5HDCODIGO Q5HDCODIGO,t3.Q5NOFILE Q5NOFILE, t3.Q5DATAFILE Q5DATAFILE,t3.Q5SIZEFILE Q5SIZEFILE,t3.Q5TEDESFILE Q5TEDESFILE,t3.Q5ORIGEN Q5ORIGEN, NVL (Q5FECHAREGISTROORIGEN, NVL (t3.Q5FECHAENTRADA, t3.Q5FECHA)) Q5FECHA,t3.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t3.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t3.Q5FECHAAPORTACION Q5FECHAAPORTACION,t3.Q5FECHAENTRADA Q5FECHAENTRADA,t3.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA,t3.Q5ATABLET Q5ATABLET, t4.ID_TIPODOC IDTIPODOC, t4.TDNOMBRE TDNOMBRE, t4.TDNOMBREE TDNOMBREE ");
			query.append(
					"FROM DOCUMENTO_HECHO t3,INSPECCIONES_TIPO_DOCUMENTO t4 WHERE t3.Q5ID_TIPODOC = t4.ID_TIPODOC(+) ");
			query.append(" AND t3.Q5HDCODIGO = ? ");
			params.add(campanha.getCmcodigo());
		}

		if (alerta != null && alerta.getAlcodigo() != null) {
			query.append("UNION ALL ");
			query.append(
					"SELECT  '3' as DE, t5.Q5CODOCUMENTO Q5CODOCUMENTO,t5.Q5HDCODIGO Q5HDCODIGO,t5.Q5NOFILE Q5NOFILE, t5.Q5DATAFILE Q5DATAFILE,t5.Q5SIZEFILE Q5SIZEFILE,t5.Q5TEDESFILE Q5TEDESFILE,t5.Q5ORIGEN Q5ORIGEN, NVL (Q5FECHAREGISTROORIGEN, NVL (t5.Q5FECHAENTRADA, t5.Q5FECHA)) Q5FECHA,t5.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t5.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t5.Q5FECHAAPORTACION Q5FECHAAPORTACION,t5.Q5FECHAENTRADA Q5FECHAENTRADA,t5.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA,t5.Q5ATABLET Q5ATABLET,  t6.ID_TIPODOC IDTIPODOC, t6.TDNOMBRE TDNOMBRE, t6.TDNOMBREE TDNOMBREE ");
			query.append(
					"FROM DOCUMENTO_HECHO t5,INSPECCIONES_TIPO_DOCUMENTO t6 WHERE t5.Q5ID_TIPODOC = t6.ID_TIPODOC(+) ");
			query.append(" AND t5.Q5HDCODIGO = ? ");
			params.add(alerta.getAlcodigo());
		}

		if (comunicacionSoivre != null && comunicacionSoivre.getIdcomunicacionsoivre() != null) {
			query.append("UNION ALL ");
			query.append(
					"SELECT  '4' as DE, t7.Q5CODOCUMENTO Q5CODOCUMENTO,t7.Q5HDCODIGO Q5HDCODIGO,t7.Q5NOFILE Q5NOFILE, t7.Q5DATAFILE Q5DATAFILE,t7.Q5SIZEFILE Q5SIZEFILE,t7.Q5TEDESFILE Q5TEDESFILE,t7.Q5ORIGEN Q5ORIGEN, NVL (Q5FECHAREGISTROORIGEN, NVL (t7.Q5FECHAENTRADA, t7.Q5FECHA)) Q5FECHA,t7.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t7.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t7.Q5FECHAAPORTACION Q5FECHAAPORTACION,t7.Q5FECHAENTRADA Q5FECHAENTRADA,t7.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA,t7.Q5ATABLET Q5ATABLET,  t8.ID_TIPODOC IDTIPODOC, t8.TDNOMBRE TDNOMBRE, t8.TDNOMBREE TDNOMBREE ");
			query.append(
					"FROM DOCUMENTO_HECHO t7,INSPECCIONES_TIPO_DOCUMENTO t8 WHERE t7.Q5ID_TIPODOC = t8.ID_TIPODOC(+) ");
			query.append(" AND t7.Q5HDCODIGO = ? ");
			params.add(comunicacionSoivre.getIdcomunicacionsoivre());
		}

		if (solDetalle != null && solDetalle.getHdcodigo() != null) {
			query.append("UNION ALL ");
			query.append(
					"SELECT  '5' as DE, t9.Q5CODOCUMENTO Q5CODOCUMENTO,t9.Q5HDCODIGO Q5HDCODIGO,t9.Q5NOFILE Q5NOFILE, t9.Q5DATAFILE Q5DATAFILE,t9.Q5SIZEFILE Q5SIZEFILE,t9.Q5TEDESFILE Q5TEDESFILE,t9.Q5ORIGEN Q5ORIGEN, NVL (Q5FECHAREGISTROORIGEN, NVL (t9.Q5FECHAENTRADA, t9.Q5FECHA)) Q5FECHA,t9.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t9.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t9.Q5FECHAAPORTACION Q5FECHAAPORTACION,t9.Q5FECHAENTRADA Q5FECHAENTRADA,t9.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA,t9.Q5ATABLET Q5ATABLET,  t10.ID_TIPODOC IDTIPODOC, t10.TDNOMBRE TDNOMBRE, t10.TDNOMBREE TDNOMBREE ");
			query.append(
					"FROM DOCUMENTO_HECHO t9,INSPECCIONES_TIPO_DOCUMENTO t10 WHERE t9.Q5ID_TIPODOC = t10.ID_TIPODOC(+) ");
			query.append(" AND t9.Q5HDCODIGO = ? ");
			params.add(solDetalle.getHdcodigo());
		}

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoExpediente>() {
					public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new DocumentoExpediente(resultSet.getString("DE"), resultSet.getString("Q5CODOCUMENTO"),
								resultSet.getString("Q5HDCODIGO"), resultSet.getString("Q5NOFILE"),
								resultSet.getBlob("Q5DATAFILE"), resultSet.getInt("Q5SIZEFILE"),
								resultSet.getString("Q5CONTENTTYPEFILE"), resultSet.getString("Q5TEDESFILE"),
								resultSet.getString("Q5ORIGEN"), resultSet.getDate("Q5FECHA"),
								resultSet.getString("Q5IDDOCUMENTUM"), resultSet.getDate("Q5FECHAAPORTACION"),
								resultSet.getDate("Q5FECHAENTRADA"), resultSet.getString("Q5NUMREGISTROENTRADA"),
								resultSet.getString("Q5ATABLET"), resultSet.getString("IDTIPODOC"),
								resultSet.getString("TDNOMBRE"), resultSet.getString("TDNOMBREE"), null, null, null,
								null, null, null, null, null);
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocsMovilidadCount(InspeccionDetalle inspeccionDetalle, Campanha campanha, Alerta alerta,
			ComunicacionSoivre comunicacionSoivre, SolicitudDetalle solDetalle) {

		StringBuilder query = new StringBuilder("SELECT SUM(T.CANTIDAD) FROM ( ");

		query.append(
				"(SELECT COUNT(1) AS CANTIDAD FROM DOCUMENTO_HECHO t1,INSPECCIONES_TIPO_DOCUMENTO t2 WHERE t1.Q5ID_TIPODOC = t2.ID_TIPODOC(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5HDCODIGO = ?) ");
		params.add(inspeccionDetalle.getAtcodigo());
		query.append(where);

		if (campanha != null && campanha.getCmcodigo() != null) {
			query.append("UNION ALL ");
			query.append(
					"(SELECT COUNT(1) AS CANTIDAD FROM DOCUMENTO_HECHO t3,INSPECCIONES_TIPO_DOCUMENTO t4 WHERE t3.Q5ID_TIPODOC = t4.ID_TIPODOC(+) ");
			query.append(" AND t3.Q5HDCODIGO = ?) ");
			params.add(campanha.getCmcodigo());
		}

		if (alerta != null && alerta.getAlcodigo() != null) {
			query.append("UNION ALL ");
			query.append(
					"(SELECT COUNT(1) AS CANTIDAD FROM DOCUMENTO_HECHO t5,INSPECCIONES_TIPO_DOCUMENTO t6 WHERE t5.Q5ID_TIPODOC = t6.ID_TIPODOC(+) ");
			query.append(" AND t5.Q5HDCODIGO = ?) ");
			params.add(alerta.getAlcodigo());
		}

		if (comunicacionSoivre != null && comunicacionSoivre.getIdcomunicacionsoivre() != null) {
			query.append("UNION ALL ");
			query.append(
					"(SELECT COUNT(1) AS CANTIDAD FROM DOCUMENTO_HECHO t7,INSPECCIONES_TIPO_DOCUMENTO t8 WHERE t7.Q5ID_TIPODOC = t8.ID_TIPODOC(+) ");
			query.append(" AND t7.Q5HDCODIGO = ?) ");
			params.add(comunicacionSoivre.getIdcomunicacionsoivre());
		}

		if (solDetalle != null && solDetalle.getHdcodigo() != null) {
			query.append("UNION ALL ");
			query.append(
					"(SELECT COUNT(1) AS CANTIDAD FROM DOCUMENTO_HECHO t9,INSPECCIONES_TIPO_DOCUMENTO t10 WHERE t9.Q5ID_TIPODOC = t10.ID_TIPODOC(+) ");
			query.append(" AND t9.Q5HDCODIGO = ?) ");
			params.add(solDetalle.getHdcodigo());
		}

		query.append(")  T ");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Checks rows in the DocumentoHecho table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return Long
	 */
	public void marcarDocsParaTablet(List<String> idsdocumentosList) {

		StringBuffer idsdocumentos = new StringBuffer();
		for (int posId = 0; posId < idsdocumentosList.size(); posId++) {
			if (posId > 0) {
				idsdocumentos.append(",");
			}
			idsdocumentos.append("'").append((String) idsdocumentosList.get(posId)).append("'");
		}

		String query = "UPDATE DOCUMENTO_HECHO SET Q5ATABLET='S' WHERE Q5CODOCUMENTO IN (" + idsdocumentos.toString()
				+ ")";

		this.jdbcTemplate.update(query);

	}

	/**
	 * UnChecks rows in the DocumentoHecho table.
	 * 
	 * 
	 * @param hdcodigo
	 *            String
	 */
	public void desmarcarDocsParaTablet(String hdcodigo) {
		String query = "UPDATE DOCUMENTO_HECHO SET Q5ATABLET='N' WHERE Q5HDCODIGO = ? ";

		this.jdbcTemplate.update(query, hdcodigo);

	}

	/**
	 * Find rows in the L21Y5T00 table.
	 * 
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	public Long findSincronizacion(CensoMonitor censoMonitor) {
		String query = "SELECT COUNT(1) FROM SINCRONIZACION_MOVILIDAD WHERE CODUSUARIO=? ";
		return this.jdbcTemplate.queryForLong(query.toString(), censoMonitor.getMocodigo());
	}

	/**
	 * adds rows in the L21Y5T00 table.
	 * 
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	public void addTablaSincronizacion(CensoMonitor censoMonitor) {
		String query = "INSERT INTO SINCRONIZACION_MOVILIDAD (CODUSUARIO, FECHAMODIFICACIONINSP) VALUES (?,SYSDATE)";
		this.jdbcTemplate.update(query, censoMonitor.getMocodigo());
	}

	/**
	 * adds rows in the L21Y5T00 table.
	 * 
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	public void updateTablaSincronizacion(CensoMonitor censoMonitor) {
		String query = "UPDATE SINCRONIZACION_MOVILIDAD SET FECHAMODIFICACIONINSP=SYSDATE WHERE CODUSUARIO=? ";
		this.jdbcTemplate.update(query, censoMonitor.getMocodigo());
	}
	////

}
