package com.ejie.y41b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ComunicacionSoivre;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoTramiteHecho;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TramiteComun;

/**
 * * DocumentoHechoDao  
 * 
 *  
 */

public interface DocumentoHechoDao {

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho add(DocumentoHecho documentoHecho);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 */
	public void enviarDocumentosSolicitudTelematica(SolicitudDetalle solicitudDetalle);

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return
	 */
	public void removeDocumentosSolicitudTelematica(SolicitudDetalle solicitudDetalle);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho update(DocumentoHecho documentoHecho);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return int
	 */
	public int updateDocumentoHecho(DocumentoHecho documentoHecho);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateOIDDokusi(DocumentoHecho documentoHecho);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateHash(DocumentoHecho documentoHecho);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateHashByOIDDokusi(DocumentoHecho documentoHecho);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho removeBlobFromOIDDokusi(DocumentoHecho documentoHecho);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateFechaLocalizacion(DocumentoHecho documentoHecho);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateOrigen(DocumentoHecho documentoHecho);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateDatosFirma(DocumentoHecho documentoHecho);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateTramite(DocumentoHecho documentoHecho);

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho find(DocumentoHecho documentoHecho);

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho findDoc(DocumentoHecho documentoHecho);

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho findDocumentoTraslado(DocumentoHecho documentoHecho);

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return
	 */
	public void remove(DocumentoHecho documentoHecho);

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 */
	public void removeDocsExpediente(DocumentoHecho documentoHecho);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoHecho> findAll(DocumentoHecho documentoHecho, Pagination pagination);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return Long
	 */
	public Long findAllCount(DocumentoHecho documentoHecho);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return Long
	 */
	public Long findAllDocumentosAportadosIntervinienteCount(DocumentoHecho documentoHecho);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoHecho> findAllDocumentosTramite(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosTramiteCount(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHecho(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param ids
	 *            List<String>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoByIds(TramiteComun tramiteComun, List<String> ids,
			Pagination pagination);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoCount(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosHechoInspeccion(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosHechoInspeccionCount(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosMisGestiones(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoComunicacion(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosHechoInspeccionComunicacion(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosHechoInspeccionComunicacionCount(TramiteComun tramiteComun);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun);

	/**
	 * Finds rows in the DocumentoHecho table using like.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<DocumentoHecho> findAllLike(DocumentoHecho documentoHecho, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the DocumentoHecho table using like.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(DocumentoHecho documentoHecho, Boolean startsWith);

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho findDocumentoHecho(DocumentoHecho documentohecho);

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho findDocumentoHechoByOIDDokusi(DocumentoHecho documentohecho);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarDoc(DocumentoHecho documentoHecho, TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarDocsTramiteHecho(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the DocumentoTramiteHecho table.
	 * 
	 * @param documentoTramiteHecho
	 *            DocumentoTramiteHecho
	 */
	public void addDocsTramiteHecho(DocumentoTramiteHecho documentoTramiteHecho);

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param claveTablaMaestra
	 *            String
	 */
	public void addAdjuntarDocs(String claveTablaMaestra);

	/**
	 * Removes a single row in the DocumentoTramiteHecho table.
	 * 
	 * @param documentoTramiteHecho
	 *            DocumentoTramiteHecho
	 */
	public void removeDocsTramiteHecho(DocumentoTramiteHecho documentoTramiteHecho);

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void removeAdjuntarDocsTramiteHecho(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param claveTablaMaestra
	 *            String
	 * @param claveTablaMaestraAlta
	 *            String
	 */
	public void addAllDocumentosAdjuntarDocs(String claveTablaMaestra, String claveTablaMaestraAlta);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void updateDocumentosHechoAdjuntarDocs(Adjuntardocs adjuntardocs, TramiteComun tramiteComun);

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosEliminados(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosGeneradosTramite(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return Long
	 */
	public Long findAllDocTramiteHechoCount(DocumentoHecho documentoHecho);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoExpedientesRelacionados(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoExpedientesRelacionadosCount(TramiteComun tramiteComun);

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho findActa(DocumentoHecho documentoHecho);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoInspeccionComunicacionOrigenExpediente(
			TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosAdjuntosOrigenExpedienteCount(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocsMovilidad(InspeccionDetalle inspeccionDetalle, Pagination pagination,
			Campanha campanha, Alerta alerta, ComunicacionSoivre comunicacionSoivre, SolicitudDetalle solDetalle);

	/**
	 * Finds rows in the DocumentoHecho table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return Long
	 */
	public Long findAllDocsMovilidadCount(InspeccionDetalle inspeccionDetalle, Campanha campanha, Alerta alerta,
			ComunicacionSoivre comunicacionSoivre, SolicitudDetalle solDetalle);

	/**
	 * Checks rows in the DocumentoHecho table.
	 * 
	 * 
	 * @param idsdocumentosList
	 *            List<String>
	 * @return Long
	 */
	public void marcarDocsParaTablet(List<String> idsdocumentosList);

	/**
	 * UnChecks rows in the DocumentoHecho table.
	 * 
	 * 
	 * @param hdcodigo
	 *            String
	 */
	public void desmarcarDocsParaTablet(String hdcodigo);

	/**
	 * Find rows in the L21Y5T00 table.
	 * 
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	public Long findSincronizacion(CensoMonitor censoMonitor);

	/**
	 * adds rows in the L21Y5T00 table.
	 * 
	 * 
	 * @param hdcodigo
	 *            String
	 */
	public void addTablaSincronizacion(CensoMonitor censoMonitor);

	/**
	 * Update rows in the L21Y5T00 table.
	 * 
	 * 
	 * @param hdcodigo
	 *            String
	 */
	public void updateTablaSincronizacion(CensoMonitor censoMonitor);

}
