package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.DocCensoTemp;
import com.ejie.y41b.utils.jdbc.Y41bJdbcUtils;

/**
 * DocCensoTempDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class DocCensoTempDaoImpl implements DocCensoTempDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<DocCensoTemp> rwMap = new RowMapper<DocCensoTemp>() {
		public DocCensoTemp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DocCensoTemp(resultSet.getLong("EACODOCUMENTO"), resultSet.getString("EACOENTIDAD"),
					resultSet.getString("EATIPOENTIDAD"), resultSet.getString("EANOFILE"), null,
					resultSet.getInt("EASIZEFILE"), resultSet.getString("EATEDESFILE"),
					resultSet.getString("EACONTTYPE"), resultSet.getString("EAIDDOCUMENTUM"),
					resultSet.getDate("EAFECALTA"), resultSet.getDate("EAFECMODIF"), resultSet.getString("EAUSUALTA"),
					resultSet.getString("EAUSUMODIF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the DocCensoTemp table.
	 * 
	 * @param doccensotemp
	 *            Pagination
	 * @return DocCensoTemp
	 */
	public DocCensoTemp add(DocCensoTemp doccensotemp) {
		String query = "INSERT INTO Y41BEAT00 (EACODOCUMENTO, EACOENTIDAD, EATIPOENTIDAD, EANOFILE, EADATAFILE, EASIZEFILE, EATEDESFILE, EACONTTYPE, EAIDDOCUMENTUM, EAFECALTA, EAFECMODIF, EAUSUALTA, EAUSUMODIF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, doccensotemp.getEacodocumento(), doccensotemp.getEacoentidad(),
				doccensotemp.getEatipoentidad(), doccensotemp.getEanofile(),
				Y41bJdbcUtils.ConvertBlobToByte(doccensotemp.getEadatafile()), doccensotemp.getEasizefile(),
				doccensotemp.getEatedesfile(), doccensotemp.getEaconttype(), doccensotemp.getEaiddocumentum(),
				doccensotemp.getEafecalta(), doccensotemp.getEafecmodif(), doccensotemp.getEausualta(),
				doccensotemp.getEausumodif());
		return doccensotemp;
	}

	/**
	 * Updates a single row in the DocCensoTemp table.
	 * 
	 * @param doccensotemp
	 *            Pagination
	 * @return DocCensoTemp
	 */
	public DocCensoTemp update(DocCensoTemp doccensotemp) {
		String query = "UPDATE Y41BEAT00 SET EACOENTIDAD=?, EATIPOENTIDAD=?, EANOFILE=?, EADATAFILE=?, EASIZEFILE=?, EATEDESFILE=?, EACONTTYPE=?, EAIDDOCUMENTUM=?, EAFECALTA=?, EAFECMODIF=?, EAUSUALTA=?, EAUSUMODIF=? WHERE EACODOCUMENTO=?";
		this.jdbcTemplate.update(query, doccensotemp.getEacoentidad(), doccensotemp.getEatipoentidad(),
				doccensotemp.getEanofile(), doccensotemp.getEadatafile(), doccensotemp.getEasizefile(),
				doccensotemp.getEatedesfile(), doccensotemp.getEaconttype(), doccensotemp.getEaiddocumentum(),
				doccensotemp.getEafecalta(), doccensotemp.getEafecmodif(), doccensotemp.getEausualta(),
				doccensotemp.getEausumodif(), doccensotemp.getEacodocumento());
		return doccensotemp;
	}

	/**
	 * Finds a single row in the DocCensoTemp table.
	 * 
	 * @param doccensotemp
	 *            Pagination
	 * @return DocCensoTemp
	 */
	@Transactional(readOnly = true)
	public DocCensoTemp find(DocCensoTemp doccensotemp) {
		String query = "SELECT t1.EACODOCUMENTO EACODOCUMENTO, t1.EACOENTIDAD EACOENTIDAD, t1.EATIPOENTIDAD EATIPOENTIDAD, t1.EANOFILE EANOFILE, t1.EASIZEFILE EASIZEFILE, t1.EATEDESFILE EATEDESFILE, t1.EACONTTYPE EACONTTYPE, t1.EAIDDOCUMENTUM EAIDDOCUMENTUM, t1.EAFECALTA EAFECALTA, t1.EAFECMODIF EAFECMODIF, t1.EAUSUALTA EAUSUALTA, t1.EAUSUMODIF EAUSUMODIF FROM Y41BEAT00 t1  WHERE t1.EACODOCUMENTO = ?  ";

		List<DocCensoTemp> doccensotempList = this.jdbcTemplate.query(query, this.rwMap,
				doccensotemp.getEacodocumento());
		return (DocCensoTemp) DataAccessUtils.uniqueResult(doccensotempList);
	}

	/**
	 * Removes a single row in the DocCensoTemp table.
	 * 
	 * @param doccensotemp
	 *            Pagination
	 * @return
	 */
	public void remove(DocCensoTemp doccensotemp) {
		String query = "DELETE FROM Y41BEAT00 WHERE EACODOCUMENTO=? ";
		this.jdbcTemplate.update(query, doccensotemp.getEacodocumento());
	}

	/**
	 * Removes a single row in the DocCensoTemp table.
	 * 
	 * @param doccensotemp
	 *            Pagination
	 * @return
	 */
	public void removeByEntidad(DocCensoTemp doccensotemp) {
		String query = "DELETE FROM Y41BEAT00 WHERE EACOENTIDAD=? AND EATIPOENTIDAD=? ";
		this.jdbcTemplate.update(query, doccensotemp.getEacoentidad(), doccensotemp.getEatipoentidad());
	}

	/**
	 * Finds a List of rows in the DocCensoTemp table.
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocCensoTemp> findAll(DocCensoTemp doccensotemp, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.EACODOCUMENTO EACODOCUMENTO,t1.EACOENTIDAD EACOENTIDAD,t1.EATIPOENTIDAD EATIPOENTIDAD,t1.EANOFILE EANOFILE,t1.EASIZEFILE EASIZEFILE,t1.EATEDESFILE EATEDESFILE,t1.EACONTTYPE EACONTTYPE,t1.EAIDDOCUMENTUM EAIDDOCUMENTUM,t1.EAFECALTA EAFECALTA,t1.EAFECMODIF EAFECMODIF,t1.EAUSUALTA EAUSUALTA,t1.EAUSUMODIF EAUSUMODIF ");
		query.append("FROM Y41BEAT00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(doccensotemp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocCensoTemp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DocCensoTemp table.
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DocCensoTemp doccensotemp) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM Y41BEAT00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(doccensotemp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the DocCensoTemp table using like.
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocCensoTemp> findAllLike(DocCensoTemp doccensotemp, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.EACODOCUMENTO EACODOCUMENTO,t1.EACOENTIDAD EACOENTIDAD,t1.EATIPOENTIDAD EATIPOENTIDAD,t1.EANOFILE EANOFILE,t1.EASIZEFILE EASIZEFILE,t1.EATEDESFILE EATEDESFILE,t1.EACONTTYPE EACONTTYPE,t1.EAIDDOCUMENTUM EAIDDOCUMENTUM,t1.EAFECALTA EAFECALTA,t1.EAFECMODIF EAFECMODIF,t1.EAUSUALTA EAUSUALTA,t1.EAUSUMODIF EAUSUMODIF ");
		query.append("FROM Y41BEAT00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(doccensotemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocCensoTemp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DocCensoTemp table using like.
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DocCensoTemp doccensotemp, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM Y41BEAT00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(doccensotemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DocCensoTemp entity
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DocCensoTemp doccensotemp) {

		StringBuilder where = new StringBuilder(DocCensoTempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (doccensotemp != null && doccensotemp.getEacodocumento() != null) {
			where.append(" AND t1.EACODOCUMENTO = ?");
			params.add(doccensotemp.getEacodocumento());
		}
		if (doccensotemp != null && doccensotemp.getEacoentidad() != null) {
			where.append(" AND t1.EACOENTIDAD = ?");
			params.add(doccensotemp.getEacoentidad());
		}
		if (doccensotemp != null && doccensotemp.getEatipoentidad() != null) {
			where.append(" AND t1.EATIPOENTIDAD = ?");
			params.add(doccensotemp.getEatipoentidad());
		}
		if (doccensotemp != null && doccensotemp.getEanofile() != null) {
			where.append(" AND t1.EANOFILE = ?");
			params.add(doccensotemp.getEanofile());
		}
		if (doccensotemp != null && doccensotemp.getEasizefile() != null) {
			where.append(" AND t1.EASIZEFILE = ?");
			params.add(doccensotemp.getEasizefile());
		}
		if (doccensotemp != null && doccensotemp.getEatedesfile() != null) {
			where.append(" AND t1.EATEDESFILE = ?");
			params.add(doccensotemp.getEatedesfile());
		}
		if (doccensotemp != null && doccensotemp.getEaconttype() != null) {
			where.append(" AND t1.EACONTTYPE = ?");
			params.add(doccensotemp.getEaconttype());
		}
		if (doccensotemp != null && doccensotemp.getEaiddocumentum() != null) {
			where.append(" AND t1.EAIDDOCUMENTUM = ?");
			params.add(doccensotemp.getEaiddocumentum());
		}
		if (doccensotemp != null && doccensotemp.getEafecalta() != null) {
			where.append(" AND t1.EAFECALTA = ?");
			params.add(doccensotemp.getEafecalta());
		}
		if (doccensotemp != null && doccensotemp.getEafecmodif() != null) {
			where.append(" AND t1.EAFECMODIF = ?");
			params.add(doccensotemp.getEafecmodif());
		}
		if (doccensotemp != null && doccensotemp.getEausualta() != null) {
			where.append(" AND t1.EAUSUALTA = ?");
			params.add(doccensotemp.getEausualta());
		}
		if (doccensotemp != null && doccensotemp.getEausumodif() != null) {
			where.append(" AND t1.EAUSUMODIF = ?");
			params.add(doccensotemp.getEausumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DocCensoTemp entity
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(DocCensoTemp doccensotemp, Boolean startsWith) {

		StringBuilder where = new StringBuilder(DocCensoTempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (doccensotemp != null && doccensotemp.getEacodocumento() != null) {
			where.append(" AND t1.EACODOCUMENTO = ?");
			params.add(doccensotemp.getEacodocumento());
		}
		if (doccensotemp != null && doccensotemp.getEacoentidad() != null) {
			where.append(" AND UPPER(t1.EACOENTIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccensotemp.getEacoentidad().toUpperCase() + "%");
			} else {
				params.add("%" + doccensotemp.getEacoentidad().toUpperCase() + "%");
			}
			where.append(" AND t1.EACOENTIDAD IS NOT NULL");
		}
		if (doccensotemp != null && doccensotemp.getEatipoentidad() != null) {
			where.append(" AND UPPER(t1.EATIPOENTIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccensotemp.getEatipoentidad().toUpperCase() + "%");
			} else {
				params.add("%" + doccensotemp.getEatipoentidad().toUpperCase() + "%");
			}
			where.append(" AND t1.EATIPOENTIDAD IS NOT NULL");
		}
		if (doccensotemp != null && doccensotemp.getEanofile() != null) {
			where.append(" AND UPPER(t1.EANOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccensotemp.getEanofile().toUpperCase() + "%");
			} else {
				params.add("%" + doccensotemp.getEanofile().toUpperCase() + "%");
			}
			where.append(" AND t1.EANOFILE IS NOT NULL");
		}
		if (doccensotemp != null && doccensotemp.getEasizefile() != null) {
			where.append(" AND t1.EASIZEFILE = ?");
			params.add(doccensotemp.getEasizefile());
		}
		if (doccensotemp != null && doccensotemp.getEatedesfile() != null) {
			where.append(" AND UPPER(t1.EATEDESFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccensotemp.getEatedesfile().toUpperCase() + "%");
			} else {
				params.add("%" + doccensotemp.getEatedesfile().toUpperCase() + "%");
			}
			where.append(" AND t1.EATEDESFILE IS NOT NULL");
		}
		if (doccensotemp != null && doccensotemp.getEaconttype() != null) {
			where.append(" AND UPPER(t1.EACONTTYPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccensotemp.getEaconttype().toUpperCase() + "%");
			} else {
				params.add("%" + doccensotemp.getEaconttype().toUpperCase() + "%");
			}
			where.append(" AND t1.EACONTTYPE IS NOT NULL");
		}
		if (doccensotemp != null && doccensotemp.getEaiddocumentum() != null) {
			where.append(" AND UPPER(t1.EAIDDOCUMENTUM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccensotemp.getEaiddocumentum().toUpperCase() + "%");
			} else {
				params.add("%" + doccensotemp.getEaiddocumentum().toUpperCase() + "%");
			}
			where.append(" AND t1.EAIDDOCUMENTUM IS NOT NULL");
		}
		if (doccensotemp != null && doccensotemp.getEafecalta() != null) {
			where.append(" AND t1.EAFECALTA = ?");
			params.add(doccensotemp.getEafecalta());
		}
		if (doccensotemp != null && doccensotemp.getEafecmodif() != null) {
			where.append(" AND t1.EAFECMODIF = ?");
			params.add(doccensotemp.getEafecmodif());
		}
		if (doccensotemp != null && doccensotemp.getEausualta() != null) {
			where.append(" AND UPPER(t1.EAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccensotemp.getEausualta().toUpperCase() + "%");
			} else {
				params.add("%" + doccensotemp.getEausualta().toUpperCase() + "%");
			}
			where.append(" AND t1.EAUSUALTA IS NOT NULL");
		}
		if (doccensotemp != null && doccensotemp.getEausumodif() != null) {
			where.append(" AND UPPER(t1.EAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccensotemp.getEausumodif().toUpperCase() + "%");
			} else {
				params.add("%" + doccensotemp.getEausumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.EAUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Volcado de los documentos a la tabla temporal
	 * 
	 * @param eacoentidad
	 *            String
	 * @param eatipoentidad
	 *            String
	 */
	public void addTemporalFromCensoDoc(String eacoentidad, String eatipoentidad) {
		// primero lo borro por si existe
		String query = "DELETE FROM Y41BEAT00 WHERE EACOENTIDAD = ? AND EATIPOENTIDAD = ? ";

		this.jdbcTemplate.update(query, eacoentidad, eatipoentidad);

		query = "INSERT INTO Y41BEAT00 SELECT t1.EACODOCUMENTO EACODOCUMENTO,t1.EACOENTIDAD EACOENTIDAD,t1.EATIPOENTIDAD EATIPOENTIDAD,t1.EANOFILE EANOFILE,t1.EADATAFILE EADATAFILE,t1.EASIZEFILE EASIZEFILE,t1.EATEDESFILE EATEDESFILE,t1.EACONTTYPE EACONTTYPE,t1.EAIDDOCUMENTUM EAIDDOCUMENTUM,t1.EAFECALTA EAFECALTA,t1.EAFECMODIF EAFECMODIF,t1.EAUSUALTA EAUSUALTA,t1.EAUSUMODIF EAUSUMODIF FROM DOC_CENSO t1 WHERE t1.EACOENTIDAD = ? AND t1.EATIPOENTIDAD = ? ";

		this.jdbcTemplate.update(query, eacoentidad, eatipoentidad);

	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	public DocCensoTemp addLobTablaTemporal(DocCensoTemp docCensoTemp) {

		// primero lo borro por si existe
		String query = "DELETE FROM Y41BEAT00 WHERE EACODOCUMENTO = ?";

		this.jdbcTemplate.update(query, docCensoTemp.getEacodocumento());

		query = "INSERT INTO Y41BEAT00 SELECT EACODOCUMENTO,EADATAFILE FROM DOC_CENSO WHERE EACODOCUMENTO = ?";

		this.jdbcTemplate.update(query, docCensoTemp.getEacodocumento());
		return docCensoTemp;
	}

	/**
	 * Finds a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	@Transactional(readOnly = true)
	public DocCensoTemp findLobTablaTemporal(DocCensoTemp docCensoTemp) {
		String query = "SELECT EACODOCUMENTO, EADATAFILE FROM Y41BEAT00 WHERE EACODOCUMENTO = ? AND ROWNUM = 1 ";
		return (DocCensoTemp) this.jdbcTemplate.queryForObject(query, new RowMapper<DocCensoTemp>() {
			public DocCensoTemp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new DocCensoTemp(resultSet.getLong("EACODOCUMENTO"), resultSet.getBlob("EADATAFILE"));
			}
		}, docCensoTemp.getEacodocumento());
	}

	/**
	 * Removes a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 */
	public void removeLobTablaTemporal(DocCensoTemp docCensoTemp) {
		String query = "DELETE FROM Y41BEAT00 WHERE EACODOCUMENTO=?";
		this.jdbcTemplate.update(query, docCensoTemp.getEacodocumento());
	}

	/**
	 * Inserts a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 */
	public void addDocCensoFromTemporal(DocCensoTemp docCensoTemp) {
		String query = "INSERT INTO DOC_CENSO (EACODOCUMENTO, EACOENTIDAD, EATIPOENTIDAD, EANOFILE, EADATAFILE, EASIZEFILE, EATEDESFILE, EACONTTYPE, EAIDDOCUMENTUM, EAFECALTA, EAFECMODIF, EAUSUALTA, EAUSUMODIF)"
				+ " SELECT EACODOCUMENTO, EACOENTIDAD, EATIPOENTIDAD, EANOFILE, EADATAFILE, EASIZEFILE, EATEDESFILE, EACONTTYPE, EAIDDOCUMENTUM, EAFECALTA, EAFECMODIF, EAUSUALTA, EAUSUMODIF  "
				+ " FROM Y41BEAT00 WHERE EACOENTIDAD = ? AND EATIPOENTIDAD=? AND NOT EXISTS (SELECT 1 FROM DOC_CENSO WHERE DOC_CENSO.EACODOCUMENTO=Y41BEAT00.EACODOCUMENTO)";

		this.jdbcTemplate.update(query, docCensoTemp.getEacoentidad(), docCensoTemp.getEatipoentidad());
	}

}
