package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.util.List;

import com.ejie.y41b.model.DocCensoTemp;

/**
 * DocCensoTempDao  
 * 
 *  
 */

public interface DocCensoTempDao {

	/**
	 * Inserts a single row in the DocCensoTemp table.
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	DocCensoTemp add(DocCensoTemp doccensotemp);

	/**
	 * Updates a single row in the DocCensoTemp table.
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	DocCensoTemp update(DocCensoTemp doccensotemp);

	/**
	 * Finds a single row in the DocCensoTemp table.
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	DocCensoTemp find(DocCensoTemp doccensotemp);

	/**
	 * Deletes a single row in the DocCensoTemp table.
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp
	 * @return
	 */
	void remove(DocCensoTemp doccensotemp);

	/**
	 * Deletes a single row in the DocCensoTemp table.
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp
	 * @return
	 */
	void removeByEntidad(DocCensoTemp doccensotemp);

	/**
	 * Finds a List of rows in the DocCensoTemp table.
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocCensoTemp> findAll(DocCensoTemp doccensotemp, Pagination pagination);

	/**
	 * Counts rows in the DocCensoTemp table.
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp
	 * @return Long
	 */
	Long findAllCount(DocCensoTemp doccensotemp);

	/**
	 * Finds rows in the DocCensoTemp table using like.
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<DocCensoTemp> findAllLike(DocCensoTemp doccensotemp,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the DocCensoTemp table using like.
	 * 
	 * @param doccensotemp
	 *            DocCensoTemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(DocCensoTemp doccensotemp, Boolean startsWith);

	/**
	 * Volcado de los documentos a la tabla temporal
	 * 
	 * @param eacoentidad
	 *            String
	 * @param eatipoentidad
	 *            String
	 */
	void addTemporalFromCensoDoc(String eacoentidad, String eatipoentidad);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	DocCensoTemp addLobTablaTemporal(DocCensoTemp docCensoTemp);

	/**
	 * Finds a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	DocCensoTemp findLobTablaTemporal(DocCensoTemp docCensoTemp);

	/**
	 * Removes a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 */
	void removeLobTablaTemporal(DocCensoTemp docCensoTemp);

	/**
	 * Inserts a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 */
	void addDocCensoFromTemporal(DocCensoTemp docCensoTemp);
}
