package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.DocCenso;

/**
 * DocCensoDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class DocCensoDaoImpl implements DocCensoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<DocCenso> rwMap = new RowMapper<DocCenso>() {
		public DocCenso mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DocCenso(resultSet.getLong("EACODOCUMENTO"),
					resultSet.getString("EACOENTIDAD"),
					resultSet.getString("EATIPOENTIDAD"),
					resultSet.getString("EANOFILE"),
					resultSet.getBlob("EADATAFILE"),
					resultSet.getInt("EASIZEFILE"),
					resultSet.getString("EATEDESFILE"),
					resultSet.getString("EACONTTYPE"),
					resultSet.getString("EAIDDOCUMENTUM"),
					resultSet.getDate("EAFECALTA"),
					resultSet.getDate("EAFECMODIF"),
					resultSet.getString("EAUSUALTA"),
					resultSet.getString("EAUSUMODIF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the DocCenso table.
	 * 
	 * @param doccenso
	 *            Pagination
	 * @return DocCenso
	 */
	public DocCenso add(DocCenso doccenso) {
		String query = "INSERT INTO DOC_CENSO (EACODOCUMENTO, EACOENTIDAD, EATIPOENTIDAD, EANOFILE, EADATAFILE, EASIZEFILE, EATEDESFILE, EACONTTYPE, EAIDDOCUMENTUM, EAFECALTA, EAFECMODIF, EAUSUALTA, EAUSUMODIF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, doccenso.getEacodocumento(),
				doccenso.getEacoentidad(), doccenso.getEatipoentidad(),
				doccenso.getEanofile(), doccenso.getEadatafile(),
				doccenso.getEasizefile(), doccenso.getEatedesfile(),
				doccenso.getEaconttype(), doccenso.getEaiddocumentum(),
				doccenso.getEafecalta(), doccenso.getEafecmodif(),
				doccenso.getEausualta(), doccenso.getEausumodif());
		return doccenso;
	}

	/**
	 * Updates a single row in the DocCenso table.
	 * 
	 * @param doccenso
	 *            Pagination
	 * @return DocCenso
	 */
	public DocCenso update(DocCenso doccenso) {
		String query = "UPDATE DOC_CENSO SET EACOENTIDAD=?, EATIPOENTIDAD=?, EANOFILE=?, EADATAFILE=?, EASIZEFILE=?, EATEDESFILE=?, EACONTTYPE=?, EAIDDOCUMENTUM=?, EAFECALTA=?, EAFECMODIF=?, EAUSUALTA=?, EAUSUMODIF=? WHERE EACODOCUMENTO=?";
		this.jdbcTemplate.update(query, doccenso.getEacoentidad(),
				doccenso.getEatipoentidad(), doccenso.getEanofile(),
				doccenso.getEadatafile(), doccenso.getEasizefile(),
				doccenso.getEatedesfile(), doccenso.getEaconttype(),
				doccenso.getEaiddocumentum(), doccenso.getEafecalta(),
				doccenso.getEafecmodif(), doccenso.getEausualta(),
				doccenso.getEausumodif(), doccenso.getEacodocumento());
		return doccenso;
	}

	/**
	 * Finds a single row in the DocCenso table.
	 * 
	 * @param doccenso
	 *            Pagination
	 * @return DocCenso
	 */
	@Transactional(readOnly = true)
	public DocCenso find(DocCenso doccenso) {
		String query = "SELECT t1.EACODOCUMENTO EACODOCUMENTO, t1.EACOENTIDAD EACOENTIDAD, t1.EATIPOENTIDAD EATIPOENTIDAD, t1.EANOFILE EANOFILE, t1.EADATAFILE EADATAFILE, t1.EASIZEFILE EASIZEFILE, t1.EATEDESFILE EATEDESFILE, t1.EACONTTYPE EACONTTYPE, t1.EAIDDOCUMENTUM EAIDDOCUMENTUM, t1.EAFECALTA EAFECALTA, t1.EAFECMODIF EAFECMODIF, t1.EAUSUALTA EAUSUALTA, t1.EAUSUMODIF EAUSUMODIF FROM DOC_CENSO t1  WHERE t1.EACODOCUMENTO = ?  ";

		List<DocCenso> doccensoList = this.jdbcTemplate.query(query,
				this.rwMap, doccenso.getEacodocumento());
		return (DocCenso) DataAccessUtils.uniqueResult(doccensoList);
	}

	/**
	 * Removes a single row in the DocCenso table.
	 * 
	 * @param doccenso
	 *            Pagination
	 * @return
	 */
	public void remove(DocCenso doccenso) {
		String query = "DELETE FROM DOC_CENSO WHERE EACOENTIDAD=? AND EATIPOENTIDAD=?";
		this.jdbcTemplate.update(query, doccenso.getEacoentidad(),
				doccenso.getEatipoentidad());
	}

	/**
	 * Finds a List of rows in the DocCenso table.
	 * 
	 * @param doccenso
	 *            DocCenso
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocCenso> findAll(DocCenso doccenso, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.EACODOCUMENTO EACODOCUMENTO,t1.EACOENTIDAD EACOENTIDAD,t1.EATIPOENTIDAD EATIPOENTIDAD,t1.EANOFILE EANOFILE,t1.EADATAFILE EADATAFILE,t1.EASIZEFILE EASIZEFILE,t1.EATEDESFILE EATEDESFILE,t1.EACONTTYPE EACONTTYPE,t1.EAIDDOCUMENTUM EAIDDOCUMENTUM,t1.EAFECALTA EAFECALTA,t1.EAFECMODIF EAFECMODIF,t1.EAUSUALTA EAUSUALTA,t1.EAUSUMODIF EAUSUMODIF ");
		query.append("FROM DOC_CENSO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(doccenso);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocCenso>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DocCenso table.
	 * 
	 * @param doccenso
	 *            DocCenso
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DocCenso doccenso) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOC_CENSO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(doccenso);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the DocCenso table using like.
	 * 
	 * @param doccenso
	 *            DocCenso
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocCenso> findAllLike(DocCenso doccenso, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.EACODOCUMENTO EACODOCUMENTO,t1.EACOENTIDAD EACOENTIDAD,t1.EATIPOENTIDAD EATIPOENTIDAD,t1.EANOFILE EANOFILE,t1.EADATAFILE EADATAFILE,t1.EASIZEFILE EASIZEFILE,t1.EATEDESFILE EATEDESFILE,t1.EACONTTYPE EACONTTYPE,t1.EAIDDOCUMENTUM EAIDDOCUMENTUM,t1.EAFECALTA EAFECALTA,t1.EAFECMODIF EAFECMODIF,t1.EAUSUALTA EAUSUALTA,t1.EAUSUMODIF EAUSUMODIF ");
		query.append("FROM DOC_CENSO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(doccenso, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DocCenso>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DocCenso table using like.
	 * 
	 * @param doccenso
	 *            DocCenso
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DocCenso doccenso, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOC_CENSO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(doccenso, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DocCenso entity
	 * 
	 * @param doccenso
	 *            DocCenso Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DocCenso doccenso) {

		StringBuilder where = new StringBuilder(
				DocCensoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (doccenso != null && doccenso.getEacodocumento() != null) {
			where.append(" AND t1.EACODOCUMENTO = ?");
			params.add(doccenso.getEacodocumento());
		}
		if (doccenso != null && doccenso.getEacoentidad() != null) {
			where.append(" AND t1.EACOENTIDAD = ?");
			params.add(doccenso.getEacoentidad());
		}
		if (doccenso != null && doccenso.getEatipoentidad() != null) {
			where.append(" AND t1.EATIPOENTIDAD = ?");
			params.add(doccenso.getEatipoentidad());
		}
		if (doccenso != null && doccenso.getEanofile() != null) {
			where.append(" AND t1.EANOFILE = ?");
			params.add(doccenso.getEanofile());
		}
		if (doccenso != null && doccenso.getEasizefile() != null) {
			where.append(" AND t1.EASIZEFILE = ?");
			params.add(doccenso.getEasizefile());
		}
		if (doccenso != null && doccenso.getEatedesfile() != null) {
			where.append(" AND t1.EATEDESFILE = ?");
			params.add(doccenso.getEatedesfile());
		}
		if (doccenso != null && doccenso.getEaconttype() != null) {
			where.append(" AND t1.EACONTTYPE = ?");
			params.add(doccenso.getEaconttype());
		}
		if (doccenso != null && doccenso.getEaiddocumentum() != null) {
			where.append(" AND t1.EAIDDOCUMENTUM = ?");
			params.add(doccenso.getEaiddocumentum());
		}
		if (doccenso != null && doccenso.getEafecalta() != null) {
			where.append(" AND t1.EAFECALTA = ?");
			params.add(doccenso.getEafecalta());
		}
		if (doccenso != null && doccenso.getEafecmodif() != null) {
			where.append(" AND t1.EAFECMODIF = ?");
			params.add(doccenso.getEafecmodif());
		}
		if (doccenso != null && doccenso.getEausualta() != null) {
			where.append(" AND t1.EAUSUALTA = ?");
			params.add(doccenso.getEausualta());
		}
		if (doccenso != null && doccenso.getEausumodif() != null) {
			where.append(" AND t1.EAUSUMODIF = ?");
			params.add(doccenso.getEausumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DocCenso entity
	 * 
	 * @param doccenso
	 *            DocCenso Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(DocCenso doccenso, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DocCensoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (doccenso != null && doccenso.getEacodocumento() != null) {
			where.append(" AND t1.EACODOCUMENTO = ?");
			params.add(doccenso.getEacodocumento());
		}
		if (doccenso != null && doccenso.getEacoentidad() != null) {
			where.append(" AND UPPER(t1.EACOENTIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccenso.getEacoentidad().toUpperCase() + "%");
			} else {
				params.add("%" + doccenso.getEacoentidad().toUpperCase() + "%");
			}
			where.append(" AND t1.EACOENTIDAD IS NOT NULL");
		}
		if (doccenso != null && doccenso.getEatipoentidad() != null) {
			where.append(" AND UPPER(t1.EATIPOENTIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccenso.getEatipoentidad().toUpperCase() + "%");
			} else {
				params.add("%" + doccenso.getEatipoentidad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.EATIPOENTIDAD IS NOT NULL");
		}
		if (doccenso != null && doccenso.getEanofile() != null) {
			where.append(" AND UPPER(t1.EANOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccenso.getEanofile().toUpperCase() + "%");
			} else {
				params.add("%" + doccenso.getEanofile().toUpperCase() + "%");
			}
			where.append(" AND t1.EANOFILE IS NOT NULL");
		}
		if (doccenso != null && doccenso.getEasizefile() != null) {
			where.append(" AND t1.EASIZEFILE = ?");
			params.add(doccenso.getEasizefile());
		}
		if (doccenso != null && doccenso.getEatedesfile() != null) {
			where.append(" AND UPPER(t1.EATEDESFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccenso.getEatedesfile().toUpperCase() + "%");
			} else {
				params.add("%" + doccenso.getEatedesfile().toUpperCase() + "%");
			}
			where.append(" AND t1.EATEDESFILE IS NOT NULL");
		}
		if (doccenso != null && doccenso.getEaconttype() != null) {
			where.append(" AND UPPER(t1.EACONTTYPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccenso.getEaconttype().toUpperCase() + "%");
			} else {
				params.add("%" + doccenso.getEaconttype().toUpperCase() + "%");
			}
			where.append(" AND t1.EACONTTYPE IS NOT NULL");
		}
		if (doccenso != null && doccenso.getEaiddocumentum() != null) {
			where.append(" AND UPPER(t1.EAIDDOCUMENTUM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccenso.getEaiddocumentum().toUpperCase() + "%");
			} else {
				params.add("%" + doccenso.getEaiddocumentum().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.EAIDDOCUMENTUM IS NOT NULL");
		}
		if (doccenso != null && doccenso.getEafecalta() != null) {
			where.append(" AND t1.EAFECALTA = ?");
			params.add(doccenso.getEafecalta());
		}
		if (doccenso != null && doccenso.getEafecmodif() != null) {
			where.append(" AND t1.EAFECMODIF = ?");
			params.add(doccenso.getEafecmodif());
		}
		if (doccenso != null && doccenso.getEausualta() != null) {
			where.append(" AND UPPER(t1.EAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccenso.getEausualta().toUpperCase() + "%");
			} else {
				params.add("%" + doccenso.getEausualta().toUpperCase() + "%");
			}
			where.append(" AND t1.EAUSUALTA IS NOT NULL");
		}
		if (doccenso != null && doccenso.getEausumodif() != null) {
			where.append(" AND UPPER(t1.EAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(doccenso.getEausumodif().toUpperCase() + "%");
			} else {
				params.add("%" + doccenso.getEausumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.EAUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT L21EAQ00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
