package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.DocCenso;

/**
 * DocCensoDao  
 * 
 *  
 */

public interface DocCensoDao {

	/**
	 * Inserts a single row in the DocCenso table.
	 * 
	 * @param doccenso
	 *            DocCenso
	 * @return DocCenso
	 */
	DocCenso add(DocCenso doccenso);

	/**
	 * Updates a single row in the DocCenso table.
	 * 
	 * @param doccenso
	 *            DocCenso
	 * @return DocCenso
	 */
	DocCenso update(DocCenso doccenso);

	/**
	 * Finds a single row in the DocCenso table.
	 * 
	 * @param doccenso
	 *            DocCenso
	 * @return DocCenso
	 */
	DocCenso find(DocCenso doccenso);

	/**
	 * Deletes a single row in the DocCenso table.
	 * 
	 * @param doccenso
	 *            DocCenso
	 * @return
	 */
	void remove(DocCenso doccenso);

	/**
	 * Finds a List of rows in the DocCenso table.
	 * 
	 * @param doccenso
	 *            DocCenso
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocCenso> findAll(DocCenso doccenso, Pagination pagination);

	/**
	 * Counts rows in the DocCenso table.
	 * 
	 * @param doccenso
	 *            DocCenso
	 * @return Long
	 */
	Long findAllCount(DocCenso doccenso);

	/**
	 * Finds rows in the DocCenso table using like.
	 * 
	 * @param doccenso
	 *            DocCenso
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<DocCenso> findAllLike(DocCenso doccenso, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the DocCenso table using like.
	 * 
	 * @param doccenso
	 *            DocCenso
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(DocCenso doccenso, Boolean startsWith);

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	Long getNewPK();
}
