package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AdjuntarDistribuidor;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.Distribuidor;
import com.ejie.y41b.model.NaturalezaPeligro;

/**
 * DistribuidorDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DistribuidorDaoImpl implements DistribuidorDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Distribuidor> rwMap = new RowMapper<Distribuidor>() {
		public Distribuidor mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Distribuidor(resultSet.getString("RDCODIGO"),
					resultSet.getString("RDCOES"),
					resultSet.getString("RDFABRICANTE"),
					resultSet.getString("RDIDINTERVINIENTE"), new Alerta(
							resultSet.getString("AlertaALCODIGO"),
							resultSet.getString("AlertaALCOOR"),
							resultSet.getLong("AlertaALNRAN"),
							resultSet.getString("AlertaALNROR"),
							resultSet.getDate("AlertaALFEEN"),
							resultSet.getDate("AlertaALFEPLRR"),
							resultSet.getString("AlertaALCOPS"), null, null,
							resultSet.getString("AlertaALNOPRSE"),
							resultSet.getString("AlertaALNRLOPS"),
							resultSet.getString("AlertaALNOMAPS"),
							resultSet.getString("AlertaALNOMOPS"),
							resultSet.getDate("AlertaALFEDUMI"),
							resultSet.getString("AlertaALCOCA"),
							resultSet.getString("AlertaALCOPA"),
							resultSet.getString("AlertaALCOTOP"),
							resultSet.getString("AlertaALTEIN"),
							resultSet.getString("AlertaALCOES"),
							resultSet.getDate("AlertaALFERRIN"),
							resultSet.getString("AlertaALINRE"),
							resultSet.getDate("AlertaALFECOOR"),
							resultSet.getString("AlertaALCOTMO"),
							resultSet.getString("AlertaALAECOSAN"),
							resultSet.getString("AlertaALACTIVA"),
							resultSet.getString("AlertaALANULADA"),
							resultSet.getDate("AlertaALFECHAANULACION"),
							resultSet.getString("AlertaALINDICACIONES"),
							resultSet.getString("AlertaALCODIGOBARRAS"),
							resultSet.getString("AlertaALORIGENPRODUCTO"),
							resultSet.getString("AlertaALCCAAPRODUCTO"),
							resultSet.getString("AlertaALPAISPRODUCTO"),
							new Alerta(
									resultSet.getString("AlertaALCODIGOREL"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null),
							new NaturalezaPeligro(resultSet
									.getString("AlertaALIDNATURALEZAPELIGRO"),
									null, null, null), null));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Distribuidor table.
	 * 
	 * @param distribuidor
	 *            Pagination
	 * @return Distribuidor
	 */
	public Distribuidor add(Distribuidor distribuidor) {
		String query = "INSERT INTO DISTRIBUIDOR (RDCODIGO, RDCOAL, RDCOES, RDFABRICANTE, RDIDINTERVINIENTE) VALUES (?,?,?,?,?)";
		Object getAlertaAlcodigoAux = null;
		if (distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcodigo() != null) {
			getAlertaAlcodigoAux = distribuidor.getAlerta().getAlcodigo();
		}
		this.jdbcTemplate.update(query, distribuidor.getRdcodigo(),
				getAlertaAlcodigoAux, distribuidor.getRdcoes(),
				distribuidor.getRdfabricante(),
				distribuidor.getRdidinterviniente());
		return distribuidor;
	}

	/**
	 * Updates a single row in the Distribuidor table.
	 * 
	 * @param distribuidor
	 *            Pagination
	 * @return Distribuidor
	 */
	public Distribuidor update(Distribuidor distribuidor) {
		String query = "UPDATE DISTRIBUIDOR SET RDCOAL=?, RDCOES=?, RDFABRICANTE=?, RDIDINTERVINIENTE=? WHERE RDCODIGO=?";
		Object getAlertaAlcodigoAux = null;
		if (distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcodigo() != null) {
			getAlertaAlcodigoAux = distribuidor.getAlerta().getAlcodigo();
		}
		this.jdbcTemplate
				.update(query, getAlertaAlcodigoAux, distribuidor.getRdcoes(),
						distribuidor.getRdfabricante(),
						distribuidor.getRdidinterviniente(),
						distribuidor.getRdcodigo());
		return distribuidor;
	}

	/**
	 * Finds a single row in the Distribuidor table.
	 * 
	 * @param distribuidor
	 *            Pagination
	 * @return Distribuidor
	 */
	@Transactional(readOnly = true)
	public Distribuidor find(Distribuidor distribuidor) {
		String query = "SELECT t1.RDCODIGO RDCODIGO, t1.RDCOES RDCOES, t1.RDFABRICANTE RDFABRICANTE, t1.RDIDINTERVINIENTE RDIDINTERVINIENTE, t2.ALCODIGO ALERTAALCODIGO, t2.ALCOOR ALERTAALCOOR, t2.ALNRAN ALERTAALNRAN, t2.ALNROR ALERTAALNROR, t2.ALFEEN ALERTAALFEEN, t2.ALFEPLRR ALERTAALFEPLRR, t2.ALCOPS ALERTAALCOPS, t2.ALNOPRSE ALERTAALNOPRSE, t2.ALNRLOPS ALERTAALNRLOPS, t2.ALNOMAPS ALERTAALNOMAPS, t2.ALNOMOPS ALERTAALNOMOPS, t2.ALFEDUMI ALERTAALFEDUMI, t2.ALCOCA ALERTAALCOCA, t2.ALCOPA ALERTAALCOPA, t2.ALCOTOP ALERTAALCOTOP, t2.ALTEIN ALERTAALTEIN, t2.ALCOES ALERTAALCOES, t2.ALFERRIN ALERTAALFERRIN, t2.ALINRE ALERTAALINRE, t2.ALFECOOR ALERTAALFECOOR, t2.ALCOTMO ALERTAALCOTMO, t2.ALAECOSAN ALERTAALAECOSAN, t2.ALACTIVA ALERTAALACTIVA, t2.ALANULADA ALERTAALANULADA, t2.ALFECHAANULACION ALERTAALFECHAANULACION, t2.ALINDICACIONES ALERTAALINDICACIONES, t2.ALCODIGOBARRAS ALERTAALCODIGOBARRAS, t2.ALORIGENPRODUCTO ALERTAALORIGENPRODUCTO, t2.ALCCAAPRODUCTO ALERTAALCCAAPRODUCTO, t2.ALPAISPRODUCTO ALERTAALPAISPRODUCTO, t2.ALCODIGOREL ALERTAALCODIGOREL, t2.ALIDNATURALEZAPELIGRO ALERTAALIDNATURALEZAPELIGRO FROM DISTRIBUIDOR t1 , ALERTA t2  WHERE t1.RDCODIGO = ?   AND t1.RDCOAL= t2.ALCODIGO(+)";

		List<Distribuidor> distribuidorList = this.jdbcTemplate.query(query,
				this.rwMap, distribuidor.getRdcodigo());
		return (Distribuidor) DataAccessUtils.uniqueResult(distribuidorList);
	}

	/**
	 * Removes a single row in the Distribuidor table.
	 * 
	 * @param distribuidor
	 *            Pagination
	 * @return
	 */
	public void remove(Distribuidor distribuidor) {
		String query = "DELETE FROM DISTRIBUIDOR WHERE RDCODIGO=?";
		this.jdbcTemplate.update(query, distribuidor.getRdcodigo());
	}

	/**
	 * Finds a List of rows in the Distribuidor table.
	 * 
	 * @param distribuidor
	 *            Distribuidor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Distribuidor> findAll(Distribuidor distribuidor,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.RDCODIGO RDCODIGO,t1.RDCOES RDCOES,t1.RDFABRICANTE RDFABRICANTE,t1.RDIDINTERVINIENTE RDIDINTERVINIENTE,t2.ALCODIGO ALERTAALCODIGO,t2.ALCOOR ALERTAALCOOR,t2.ALNRAN ALERTAALNRAN,t2.ALNROR ALERTAALNROR,t2.ALFEEN ALERTAALFEEN,t2.ALFEPLRR ALERTAALFEPLRR,t2.ALCOPS ALERTAALCOPS,t2.ALNOPRSE ALERTAALNOPRSE,t2.ALNRLOPS ALERTAALNRLOPS,t2.ALNOMAPS ALERTAALNOMAPS,t2.ALNOMOPS ALERTAALNOMOPS,t2.ALFEDUMI ALERTAALFEDUMI,t2.ALCOCA ALERTAALCOCA,t2.ALCOPA ALERTAALCOPA,t2.ALCOTOP ALERTAALCOTOP,t2.ALTEIN ALERTAALTEIN,t2.ALCOES ALERTAALCOES,t2.ALFERRIN ALERTAALFERRIN,t2.ALINRE ALERTAALINRE,t2.ALFECOOR ALERTAALFECOOR,t2.ALCOTMO ALERTAALCOTMO,t2.ALAECOSAN ALERTAALAECOSAN,t2.ALACTIVA ALERTAALACTIVA,t2.ALANULADA ALERTAALANULADA,t2.ALFECHAANULACION ALERTAALFECHAANULACION,t2.ALINDICACIONES ALERTAALINDICACIONES,t2.ALCODIGOBARRAS ALERTAALCODIGOBARRAS,t2.ALORIGENPRODUCTO ALERTAALORIGENPRODUCTO,t2.ALCCAAPRODUCTO ALERTAALCCAAPRODUCTO,t2.ALPAISPRODUCTO ALERTAALPAISPRODUCTO,t2.ALCODIGOREL ALERTAALCODIGOREL,t2.ALIDNATURALEZAPELIGRO ALERTAALIDNATURALEZAPELIGRO ");
		query.append("FROM DISTRIBUIDOR t1 ,ALERTA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(distribuidor);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RDCOAL= t2.ALCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Distribuidor>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Distribuidor table.
	 * 
	 * @param distribuidor
	 *            Distribuidor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Distribuidor distribuidor) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DISTRIBUIDOR t1 , ALERTA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(distribuidor);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RDCOAL= t2.ALCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Distribuidor table using like.
	 * 
	 * @param distribuidor
	 *            Distribuidor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Distribuidor> findAllLike(Distribuidor distribuidor,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.RDCODIGO RDCODIGO,t1.RDCOES RDCOES,t1.RDFABRICANTE RDFABRICANTE,t1.RDIDINTERVINIENTE RDIDINTERVINIENTE,t2.ALCODIGO ALERTAALCODIGO,t2.ALCOOR ALERTAALCOOR,t2.ALNRAN ALERTAALNRAN,t2.ALNROR ALERTAALNROR,t2.ALFEEN ALERTAALFEEN,t2.ALFEPLRR ALERTAALFEPLRR,t2.ALCOPS ALERTAALCOPS,t2.ALNOPRSE ALERTAALNOPRSE,t2.ALNRLOPS ALERTAALNRLOPS,t2.ALNOMAPS ALERTAALNOMAPS,t2.ALNOMOPS ALERTAALNOMOPS,t2.ALFEDUMI ALERTAALFEDUMI,t2.ALCOCA ALERTAALCOCA,t2.ALCOPA ALERTAALCOPA,t2.ALCOTOP ALERTAALCOTOP,t2.ALTEIN ALERTAALTEIN,t2.ALCOES ALERTAALCOES,t2.ALFERRIN ALERTAALFERRIN,t2.ALINRE ALERTAALINRE,t2.ALFECOOR ALERTAALFECOOR,t2.ALCOTMO ALERTAALCOTMO,t2.ALAECOSAN ALERTAALAECOSAN,t2.ALACTIVA ALERTAALACTIVA,t2.ALANULADA ALERTAALANULADA,t2.ALFECHAANULACION ALERTAALFECHAANULACION,t2.ALINDICACIONES ALERTAALINDICACIONES,t2.ALCODIGOBARRAS ALERTAALCODIGOBARRAS,t2.ALORIGENPRODUCTO ALERTAALORIGENPRODUCTO,t2.ALCCAAPRODUCTO ALERTAALCCAAPRODUCTO,t2.ALPAISPRODUCTO ALERTAALPAISPRODUCTO,t2.ALCODIGOREL ALERTAALCODIGOREL,t2.ALIDNATURALEZAPELIGRO ALERTAALIDNATURALEZAPELIGRO ");
		query.append("FROM DISTRIBUIDOR t1 ,ALERTA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(distribuidor,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RDCOAL= t2.ALCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Distribuidor>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Distribuidor table using like.
	 * 
	 * @param distribuidor
	 *            Distribuidor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Distribuidor distribuidor, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DISTRIBUIDOR t1 ,ALERTA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(distribuidor,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RDCOAL= t2.ALCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Distribuidor entity
	 * 
	 * @param distribuidor
	 *            Distribuidor Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Distribuidor distribuidor) {

		StringBuilder where = new StringBuilder(
				DistribuidorDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (distribuidor != null && distribuidor.getRdcodigo() != null) {
			where.append(" AND t1.RDCODIGO = ?");
			params.add(distribuidor.getRdcodigo());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGO = ?");
			params.add(distribuidor.getAlerta().getAlcodigo());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlerta() != null
				&& distribuidor.getAlerta().getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGOREL = ?");
			params.add(distribuidor.getAlerta().getAlerta().getAlcodigo());
		}
		if (distribuidor != null
				&& distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getNaturalezaPeligro() != null
				&& distribuidor.getAlerta().getNaturalezaPeligro()
						.getIdnaturalezapeligro() != null) {
			where.append(" AND t2.ALIDNATURALEZAPELIGRO = ?");
			params.add(distribuidor.getAlerta().getNaturalezaPeligro()
					.getIdnaturalezapeligro());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcoor() != null) {
			where.append(" AND t2.ALCOOR = ?");
			params.add(distribuidor.getAlerta().getAlcoor());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlnran() != null) {
			where.append(" AND t2.ALNRAN = ?");
			params.add(distribuidor.getAlerta().getAlnran());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlnror() != null) {
			where.append(" AND t2.ALNROR = ?");
			params.add(distribuidor.getAlerta().getAlnror());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlfeen() != null) {
			where.append(" AND t2.ALFEEN = ?");
			params.add(distribuidor.getAlerta().getAlfeen());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t2.ALFEPLRR = ?");
			params.add(distribuidor.getAlerta().getAlfeplrr());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcops() != null) {
			where.append(" AND t2.ALCOPS = ?");
			params.add(distribuidor.getAlerta().getAlcops());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlnoprse() != null) {
			where.append(" AND t2.ALNOPRSE = ?");
			params.add(distribuidor.getAlerta().getAlnoprse());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlnrlops() != null) {
			where.append(" AND t2.ALNRLOPS = ?");
			params.add(distribuidor.getAlerta().getAlnrlops());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlnomaps() != null) {
			where.append(" AND t2.ALNOMAPS = ?");
			params.add(distribuidor.getAlerta().getAlnomaps());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlnomops() != null) {
			where.append(" AND t2.ALNOMOPS = ?");
			params.add(distribuidor.getAlerta().getAlnomops());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlfedumi() != null) {
			where.append(" AND t2.ALFEDUMI = ?");
			params.add(distribuidor.getAlerta().getAlfedumi());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcoca() != null) {
			where.append(" AND t2.ALCOCA = ?");
			params.add(distribuidor.getAlerta().getAlcoca());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcopa() != null) {
			where.append(" AND t2.ALCOPA = ?");
			params.add(distribuidor.getAlerta().getAlcopa());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcotop() != null) {
			where.append(" AND t2.ALCOTOP = ?");
			params.add(distribuidor.getAlerta().getAlcotop());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAltein() != null) {
			where.append(" AND t2.ALTEIN = ?");
			params.add(distribuidor.getAlerta().getAltein());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcoes() != null) {
			where.append(" AND t2.ALCOES = ?");
			params.add(distribuidor.getAlerta().getAlcoes());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlferrin() != null) {
			where.append(" AND t2.ALFERRIN = ?");
			params.add(distribuidor.getAlerta().getAlferrin());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlinre() != null) {
			where.append(" AND t2.ALINRE = ?");
			params.add(distribuidor.getAlerta().getAlinre());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlfecoor() != null) {
			where.append(" AND t2.ALFECOOR = ?");
			params.add(distribuidor.getAlerta().getAlfecoor());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcotmo() != null) {
			where.append(" AND t2.ALCOTMO = ?");
			params.add(distribuidor.getAlerta().getAlcotmo());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlaecosan() != null) {
			where.append(" AND t2.ALAECOSAN = ?");
			params.add(distribuidor.getAlerta().getAlaecosan());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlactiva() != null) {
			where.append(" AND t2.ALACTIVA = ?");
			params.add(distribuidor.getAlerta().getAlactiva());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlanulada() != null) {
			where.append(" AND t2.ALANULADA = ?");
			params.add(distribuidor.getAlerta().getAlanulada());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlfechaanulacion() != null) {
			where.append(" AND t2.ALFECHAANULACION = ?");
			params.add(distribuidor.getAlerta().getAlfechaanulacion());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcodigobarras() != null) {
			where.append(" AND t2.ALCODIGOBARRAS = ?");
			params.add(distribuidor.getAlerta().getAlcodigobarras());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlorigenproducto() != null) {
			where.append(" AND t2.ALORIGENPRODUCTO = ?");
			params.add(distribuidor.getAlerta().getAlorigenproducto());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlccaaproducto() != null) {
			where.append(" AND t2.ALCCAAPRODUCTO = ?");
			params.add(distribuidor.getAlerta().getAlccaaproducto());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlpaisproducto() != null) {
			where.append(" AND t2.ALPAISPRODUCTO = ?");
			params.add(distribuidor.getAlerta().getAlpaisproducto());
		}
		if (distribuidor != null && distribuidor.getRdcoes() != null) {
			where.append(" AND t1.RDCOES = ?");
			params.add(distribuidor.getRdcoes());
		}
		if (distribuidor != null && distribuidor.getRdfabricante() != null) {
			where.append(" AND t1.RDFABRICANTE = ?");
			params.add(distribuidor.getRdfabricante());
		}
		if (distribuidor != null && distribuidor.getRdidinterviniente() != null) {
			where.append(" AND t1.RDIDINTERVINIENTE = ?");
			params.add(distribuidor.getRdidinterviniente());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Distribuidor entity
	 * 
	 * @param distribuidor
	 *            Distribuidor Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Distribuidor distribuidor,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DistribuidorDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (distribuidor != null && distribuidor.getRdcodigo() != null) {
			where.append(" AND UPPER(t1.RDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getRdcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + distribuidor.getRdcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.RDCODIGO IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGO = ?");
			params.add(distribuidor.getAlerta().getAlcodigo());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlerta() != null
				&& distribuidor.getAlerta().getAlerta().getAlcodigo() != null) {
			where.append(" AND UPPER(t2.ALCODIGOREL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlerta().getAlcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlerta().getAlcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCODIGOREL IS NOT NULL");
		}
		if (distribuidor != null
				&& distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getNaturalezaPeligro() != null
				&& distribuidor.getAlerta().getNaturalezaPeligro()
						.getIdnaturalezapeligro() != null) {
			where.append(" AND UPPER(t2.ALIDNATURALEZAPELIGRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getNaturalezaPeligro()
						.getIdnaturalezapeligro().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getNaturalezaPeligro()
								.getIdnaturalezapeligro().toUpperCase() + "%");
			}
			where.append(" AND t2.ALIDNATURALEZAPELIGRO IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcoor() != null) {
			where.append(" AND UPPER(t2.ALCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlcoor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlcoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOOR IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlnran() != null) {
			where.append(" AND t2.ALNRAN = ?");
			params.add(distribuidor.getAlerta().getAlnran());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlnror() != null) {
			where.append(" AND UPPER(t2.ALNROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlnror().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlnror().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNROR IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlfeen() != null) {
			where.append(" AND t2.ALFEEN = ?");
			params.add(distribuidor.getAlerta().getAlfeen());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t2.ALFEPLRR = ?");
			params.add(distribuidor.getAlerta().getAlfeplrr());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcops() != null) {
			where.append(" AND UPPER(t2.ALCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlcops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlcops().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOPS IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlnoprse() != null) {
			where.append(" AND UPPER(t2.ALNOPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlnoprse().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlnoprse().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNOPRSE IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlnrlops() != null) {
			where.append(" AND UPPER(t2.ALNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlnrlops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlnrlops().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNRLOPS IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlnomaps() != null) {
			where.append(" AND UPPER(t2.ALNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlnomaps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlnomaps().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNOMAPS IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlnomops() != null) {
			where.append(" AND UPPER(t2.ALNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlnomops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlnomops().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNOMOPS IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlfedumi() != null) {
			where.append(" AND t2.ALFEDUMI = ?");
			params.add(distribuidor.getAlerta().getAlfedumi());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcoca() != null) {
			where.append(" AND UPPER(t2.ALCOCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlcoca().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlcoca().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOCA IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcopa() != null) {
			where.append(" AND UPPER(t2.ALCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlcopa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlcopa().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOPA IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcotop() != null) {
			where.append(" AND UPPER(t2.ALCOTOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlcotop().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlcotop().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOTOP IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAltein() != null) {
			where.append(" AND UPPER(t2.ALTEIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAltein().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAltein().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALTEIN IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcoes() != null) {
			where.append(" AND UPPER(t2.ALCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlcoes().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlcoes().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOES IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlferrin() != null) {
			where.append(" AND t2.ALFERRIN = ?");
			params.add(distribuidor.getAlerta().getAlferrin());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlinre() != null) {
			where.append(" AND UPPER(t2.ALINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlinre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlinre().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALINRE IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlfecoor() != null) {
			where.append(" AND t2.ALFECOOR = ?");
			params.add(distribuidor.getAlerta().getAlfecoor());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcotmo() != null) {
			where.append(" AND UPPER(t2.ALCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlcotmo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlcotmo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOTMO IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlaecosan() != null) {
			where.append(" AND UPPER(t2.ALAECOSAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlaecosan()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlaecosan().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALAECOSAN IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlactiva() != null) {
			where.append(" AND UPPER(t2.ALACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlactiva().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlactiva().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALACTIVA IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlanulada() != null) {
			where.append(" AND UPPER(t2.ALANULADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlanulada()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlanulada().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALANULADA IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlfechaanulacion() != null) {
			where.append(" AND t2.ALFECHAANULACION = ?");
			params.add(distribuidor.getAlerta().getAlfechaanulacion());
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlcodigobarras() != null) {
			where.append(" AND UPPER(t2.ALCODIGOBARRAS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlcodigobarras()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlcodigobarras()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCODIGOBARRAS IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlorigenproducto() != null) {
			where.append(" AND UPPER(t2.ALORIGENPRODUCTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlorigenproducto()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlorigenproducto()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALORIGENPRODUCTO IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlccaaproducto() != null) {
			where.append(" AND UPPER(t2.ALCCAAPRODUCTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlccaaproducto()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlccaaproducto()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCCAAPRODUCTO IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getAlerta() != null
				&& distribuidor.getAlerta().getAlpaisproducto() != null) {
			where.append(" AND UPPER(t2.ALPAISPRODUCTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getAlerta().getAlpaisproducto()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getAlerta().getAlpaisproducto()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALPAISPRODUCTO IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getRdcoes() != null) {
			where.append(" AND UPPER(t1.RDCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getRdcoes().toUpperCase() + "%");
			} else {
				params.add("%" + distribuidor.getRdcoes().toUpperCase() + "%");
			}
			where.append(" AND t1.RDCOES IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getRdfabricante() != null) {
			where.append(" AND UPPER(t1.RDFABRICANTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getRdfabricante().toUpperCase() + "%");
			} else {
				params.add("%" + distribuidor.getRdfabricante().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RDFABRICANTE IS NOT NULL");
		}
		if (distribuidor != null && distribuidor.getRdidinterviniente() != null) {
			where.append(" AND UPPER(t1.RDIDINTERVINIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(distribuidor.getRdidinterviniente().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ distribuidor.getRdidinterviniente().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RDIDINTERVINIENTE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the Distribuidor table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Distribuidor> findAllDistribuidoresEliminados(Alerta alerta,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.RDCODIGO RDCODIGO,t1.RDCOES RDCOES,t1.RDFABRICANTE RDFABRICANTE,t1.RDIDINTERVINIENTE RDIDINTERVINIENTE,t2.ALCODIGO ALERTAALCODIGO,t2.ALCOOR ALERTAALCOOR,t2.ALNRAN ALERTAALNRAN,t2.ALNROR ALERTAALNROR,t2.ALFEEN ALERTAALFEEN,t2.ALFEPLRR ALERTAALFEPLRR,t2.ALCOPS ALERTAALCOPS,t2.ALNOPRSE ALERTAALNOPRSE,t2.ALNRLOPS ALERTAALNRLOPS,t2.ALNOMAPS ALERTAALNOMAPS,t2.ALNOMOPS ALERTAALNOMOPS,t2.ALFEDUMI ALERTAALFEDUMI,t2.ALCOCA ALERTAALCOCA,t2.ALCOPA ALERTAALCOPA,t2.ALCOTOP ALERTAALCOTOP,t2.ALTEIN ALERTAALTEIN,t2.ALCOES ALERTAALCOES,t2.ALFERRIN ALERTAALFERRIN,t2.ALINRE ALERTAALINRE,t2.ALFECOOR ALERTAALFECOOR,t2.ALCOTMO ALERTAALCOTMO,t2.ALAECOSAN ALERTAALAECOSAN,t2.ALACTIVA ALERTAALACTIVA,t2.ALANULADA ALERTAALANULADA,t2.ALFECHAANULACION ALERTAALFECHAANULACION,t2.ALINDICACIONES ALERTAALINDICACIONES,t2.ALCODIGOBARRAS ALERTAALCODIGOBARRAS,t2.ALORIGENPRODUCTO ALERTAALORIGENPRODUCTO,t2.ALCCAAPRODUCTO ALERTAALCCAAPRODUCTO,t2.ALPAISPRODUCTO ALERTAALPAISPRODUCTO,t2.ALCODIGOREL ALERTAALCODIGOREL,t2.ALIDNATURALEZAPELIGRO ALERTAALIDNATURALEZAPELIGRO ");
		query.append("FROM DISTRIBUIDOR t1 ,ALERTA t2 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RDCOAL= t2.ALCODIGO(+) AND RDCODIGO NOT IN (SELECT RDCODIGO FROM ADJUNTAR_DISTRIBUIDOR) AND RDCOAL=? ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(alerta.getAlcodigo());

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Distribuidor>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Inserts a single row in the Distribuidor table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param codAlertaAlta
	 *            String
	 */
	public void addAllAlertaDistribuidor(Alerta alerta, String codAlertaAlta) {

		String query = "INSERT INTO DISTRIBUIDOR(RDCODIGO, RDCOAL, RDCOES, RDFABRICANTE, RDIDINTERVINIENTE) SELECT RDCODIGO, ?, RDCOES, RDFABRICANTE, RDIDINTERVINIENTE FROM ADJUNTAR_DISTRIBUIDOR WHERE RDCODIGO NOT IN (SELECT RDCODIGO FROM DISTRIBUIDOR) AND RDCOAL = ? ";
		this.jdbcTemplate.update(query, alerta.getAlcodigo(), codAlertaAlta);
	}

	/**
	 * Deletes a single row in the Distribuidor table.
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void removeAllAlertaDistribuidor(Alerta alerta) {
		String query = "DELETE  FROM DISTRIBUIDOR WHERE 1=1 AND RDCODIGO NOT IN (SELECT RDCODIGO FROM ADJUNTAR_DISTRIBUIDOR) AND RDCOAL=?";

		this.jdbcTemplate.update(query, alerta.getAlcodigo());
	}

	/**
	 * Deletes a single row in the Distribuidor table.
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void removeAlertaDistribuidor(Alerta alerta) {
		String query = "DELETE  FROM DISTRIBUIDOR WHERE 1=1 AND RDCOAL=?";

		this.jdbcTemplate.update(query, alerta.getAlcodigo());
	}

	/**
	 * Updates a single row in the Distribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            Pagination
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor updateRemoveAllFabricante(
			AdjuntarDistribuidor adjuntardistribuidor) {
		String query = "UPDATE DISTRIBUIDOR SET RDFABRICANTE=? WHERE RDCOAL=?";
		this.jdbcTemplate.update(query, Y41bConstantes.VALOR_NO,
				adjuntardistribuidor.getRdcoal());
		return adjuntardistribuidor;
	}

	/**
	 * Updates a single row in the Distribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            Pagination
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor updateAlertaFabricanteDistribuidor(
			AdjuntarDistribuidor adjuntardistribuidor) {
		String query = "UPDATE DISTRIBUIDOR SET RDFABRICANTE=? WHERE RDCODIGO=?";
		this.jdbcTemplate.update(query, Y41bConstantes.VALOR_SI,
				adjuntardistribuidor.getRdcodigo());
		return adjuntardistribuidor;
	}

	/**
	 * Updates a single row in the Distribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            Pagination
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor updateAlertaFabricanteInterviniente(
			AdjuntarDistribuidor adjuntardistribuidor) {
		String query = "UPDATE DISTRIBUIDOR SET RDIDINTERVINIENTE=? WHERE RDCODIGO=?";
		this.jdbcTemplate.update(query,
				adjuntardistribuidor.getRdidinterviniente(),
				adjuntardistribuidor.getRdcodigo());
		return adjuntardistribuidor;
	}
}
