package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarDistribuidor;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.Distribuidor;

/**
 * DistribuidorDao  
 * 
 *  
 */

public interface DistribuidorDao {

	/**
	 * Inserts a single row in the Distribuidor table.
	 * 
	 * @param distribuidor
	 *            Distribuidor
	 * @return Distribuidor
	 */
	Distribuidor add(Distribuidor distribuidor);

	/**
	 * Updates a single row in the Distribuidor table.
	 * 
	 * @param distribuidor
	 *            Distribuidor
	 * @return Distribuidor
	 */
	Distribuidor update(Distribuidor distribuidor);

	/**
	 * Finds a single row in the Distribuidor table.
	 * 
	 * @param distribuidor
	 *            Distribuidor
	 * @return Distribuidor
	 */
	Distribuidor find(Distribuidor distribuidor);

	/**
	 * Deletes a single row in the Distribuidor table.
	 * 
	 * @param distribuidor
	 *            Distribuidor
	 * @return
	 */
	void remove(Distribuidor distribuidor);

	/**
	 * Finds a List of rows in the Distribuidor table.
	 * 
	 * @param distribuidor
	 *            Distribuidor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Distribuidor> findAll(Distribuidor distribuidor, Pagination pagination);

	/**
	 * Counts rows in the Distribuidor table.
	 * 
	 * @param distribuidor
	 *            Distribuidor
	 * @return Long
	 */
	Long findAllCount(Distribuidor distribuidor);

	/**
	 * Finds rows in the Distribuidor table using like.
	 * 
	 * @param distribuidor
	 *            Distribuidor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Distribuidor> findAllLike(Distribuidor distribuidor,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Distribuidor table using like.
	 * 
	 * @param distribuidor
	 *            Distribuidor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Distribuidor distribuidor, Boolean startsWith);

	/**
	 * Inserts a single row in the Distribuidor table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param codAlertaAlta
	 *            String
	 */
	public void addAllAlertaDistribuidor(Alerta alerta, String codAlertaAlta);

	/**
	 * Deletes a single row in the Distribuidor table.
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void removeAllAlertaDistribuidor(Alerta alerta);

	/**
	 * Deletes a single row in the Distribuidor table.
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void removeAlertaDistribuidor(Alerta alerta);

	/**
	 * Updates a single row in the Distribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            Pagination
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor updateRemoveAllFabricante(
			AdjuntarDistribuidor adjuntardistribuidor);

	/**
	 * Updates a single row in the Distribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            Pagination
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor updateAlertaFabricanteDistribuidor(
			AdjuntarDistribuidor adjuntardistribuidor);

	/**
	 * Updates a single row in the Distribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            Pagination
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor updateAlertaFabricanteInterviniente(
			AdjuntarDistribuidor adjuntardistribuidor);

	/**
	 * Finds a List of rows in the Distribuidor table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Distribuidor> findAllDistribuidoresEliminados(Alerta alerta,
			Pagination pagination);
}
