package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.model.Comunicacion;
import com.ejie.y41b.model.DestComunicacion;
import com.ejie.y41b.model.Organismo;

/**
 * * DestComunicacionDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DestComunicacionDaoImpl implements DestComunicacionDao {
	private static final Logger logger = LoggerFactory
			.getLogger(DestComunicacionDaoImpl.class);

	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<DestComunicacion> rwMap = new RowMapper<DestComunicacion>() {
		public DestComunicacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DestComunicacion(new Organismo(
					resultSet.getString("OrganismoCODORG"),
					resultSet.getString("OrganismoENTIDADID"),
					resultSet.getString("OrganismoNOMBREES"),
					resultSet.getString("OrganismoNOMBREEU"),
					resultSet.getString("OrganismoACTIVA"),
					resultSet.getString("OrganismoISKONTSUMOGEST"),
					resultSet.getString("OrganismoISKONTSUMONET"),
					resultSet.getString("OrganismoISOFERTAFORM"),
					resultSet.getString("OrganismoISCONSULTASWEB"),
					resultSet.getString("OrganismoISNACIONAL"),
					resultSet.getString("OrganismoOBSERVACIONES"),
					resultSet.getString("OrganismoTELEFONO"),
					resultSet.getString("OrganismoFAX"),
					resultSet.getString("OrganismoEMAIL"),
					resultSet.getString("OrganismoURL"),
					resultSet.getString("OrganismoUSUARIO"),
					resultSet.getString("OrganismoPASSWORD"),
					resultSet.getString("OrganismoNORAPAISID"),
					resultSet.getString("OrganismoNOMBREPAIS"),
					resultSet.getString("OrganismoNORAPROVINCIAID"),
					resultSet.getString("OrganismoNOMBREPROVINCIA"),
					resultSet.getString("OrganismoNORAMUNICIPIOID"),
					resultSet.getString("OrganismoNOMBREMUNICIPIO"),
					resultSet.getString("OrganismoNORALOCALIDADID"),
					resultSet.getString("OrganismoNOMBRELOCALIDAD"),
					resultSet.getString("OrganismoNORACALLEID"),
					resultSet.getString("OrganismoNOMBRECALLE"),
					resultSet.getString("OrganismoNORACPID"),
					resultSet.getString("OrganismoNOMBRECP"),
					resultSet.getString("OrganismoNORAPORTALID"),
					resultSet.getString("OrganismoNOMBREPORTAL"),
					resultSet.getString("OrganismoUSUULTMOD"),
					resultSet.getDate("OrganismoFECULTMOD")), new Comunicacion(
					resultSet.getLong("M5COCOMU"), null, null, null, null,
					null, null, null, null, null, null, null, null, null),
					resultSet.getDate("M5FELEIDO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the DestComunicacion table.
	 * 
	 * @param destcomunicacion
	 *            Pagination
	 * @return DestComunicacion
	 */
	public DestComunicacion add(DestComunicacion destcomunicacion) {

		String query = "INSERT INTO DEST_COMUNICACION( M5COOR,M5COCOMU,M5FELEIDO)"
				+ "VALUES (?,?,?)";

		Object getOrganismoCodOrgAux = null;
		if (destcomunicacion.getOrganismo() != null
				&& destcomunicacion.getOrganismo().getCodOrg() != null) {
			getOrganismoCodOrgAux = destcomunicacion.getOrganismo().getCodOrg();
		}

		Object ComunicacionM4cocomuAux = null;
		if (destcomunicacion.getComunicacion() != null
				&& destcomunicacion.getComunicacion().getM4cocomu() != null) {
			ComunicacionM4cocomuAux = destcomunicacion.getComunicacion()
					.getM4cocomu();
		}
		this.jdbcTemplate.update(query, getOrganismoCodOrgAux,
				ComunicacionM4cocomuAux, destcomunicacion.getM5feleido());
		return destcomunicacion;
	}

	/**
	 * Updates a single row in the DestComunicacion table.
	 * 
	 * @param destcomunicacion
	 *            Pagination
	 * @return DestComunicacion
	 */
	public DestComunicacion update(DestComunicacion destcomunicacion) {
		String query = "UPDATE DEST_COMUNICACION SET M5FELEIDO=? WHERE M5COOR=? AND M5COCOMU=?";

		Object getOrganismoCodOrgAux = null;
		if (destcomunicacion.getOrganismo() != null
				&& destcomunicacion.getOrganismo().getCodOrg() != null) {
			getOrganismoCodOrgAux = destcomunicacion.getOrganismo().getCodOrg();
		}

		Object ComunicacionM4cocomuAux = null;
		if (destcomunicacion.getComunicacion() != null
				&& destcomunicacion.getComunicacion().getM4cocomu() != null) {
			ComunicacionM4cocomuAux = destcomunicacion.getComunicacion()
					.getM4cocomu();
		}
		this.jdbcTemplate.update(query, destcomunicacion.getM5feleido(),
				getOrganismoCodOrgAux, ComunicacionM4cocomuAux);
		return destcomunicacion;
	}

	/**
	 * Finds a single row in the DestComunicacion table.
	 * 
	 * @param destcomunicacion
	 *            Pagination
	 * @return DestComunicacion
	 */
	@Transactional(readOnly = true)
	public DestComunicacion find(DestComunicacion destcomunicacion) {
		String query = "SELECT t1.M5COOR M5COOR, t1.M5COCOMU M5COCOMU, t1.M5FELEIDO M5FELEIDO "
				+ "FROM DEST_COMUNICACION t1  "
				+ "WHERE t1.M5COOR = ?   AND t1.M5COCOMU = ?    ";
		return (DestComunicacion) this.jdbcTemplate.queryForObject(query,
				rwMap, destcomunicacion.getOrganismo().getCodOrg(),
				destcomunicacion.getComunicacion().getM4cocomu());
	}

	/**
	 * Removes a single row in the DestComunicacion table.
	 * 
	 * @param destcomunicacion
	 *            Pagination
	 * @return
	 */
	public void remove(DestComunicacion destcomunicacion) {
		String query = "DELETE  FROM DEST_COMUNICACION WHERE M5COOR=? AND M5COCOMU=?";
		this.jdbcTemplate.update(query, destcomunicacion.getOrganismo()
				.getCodOrg(), destcomunicacion.getComunicacion().getM4cocomu());
	}

	/**
	 * Finds a List of rows in the DestComunicacion table.
	 * 
	 * @param destcomunicacion
	 *            DestComunicacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DestComunicacion> findAll(DestComunicacion destcomunicacion,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.M5COOR= t2.COD_ORG(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.M5COCOMU M5COCOMU,t1.M5FELEIDO M5FELEIDO,t2.COD_ORG ORGANISMOCODORG,t2.ENTIDAD_ID ORGANISMOENTIDADID,t2.NOMBRE_ES ORGANISMONOMBREES,t2.NOMBRE_EU ORGANISMONOMBREEU,t2.ACTIVA ORGANISMOACTIVA,t2.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST,t2.ISKONTSUMONET ORGANISMOISKONTSUMONET,t2.ISOFERTAFORM ORGANISMOISOFERTAFORM,t2.ISCONSULTASWEB ORGANISMOISCONSULTASWEB,t2.ISNACIONAL ORGANISMOISNACIONAL,t2.OBSERVACIONES ORGANISMOOBSERVACIONES,t2.TELEFONO ORGANISMOTELEFONO,t2.FAX ORGANISMOFAX,t2.EMAIL ORGANISMOEMAIL,t2.URL ORGANISMOURL,t2.USUARIO ORGANISMOUSUARIO,t2.PASSWORD ORGANISMOPASSWORD,t2.NORA_PAIS_ID ORGANISMONORAPAISID,t2.NOMBRE_PAIS ORGANISMONOMBREPAIS,t2.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID,t2.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA,t2.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID,t2.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO,t2.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID,t2.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD,t2.NORA_CALLE_ID ORGANISMONORACALLEID,t2.NOMBRE_CALLE ORGANISMONOMBRECALLE,t2.NORA_CP_ID ORGANISMONORACPID,t2.NOMBRE_CP ORGANISMONOMBRECP,t2.NORA_PORTAL_ID ORGANISMONORAPORTALID,t2.NOMBRE_PORTAL ORGANISMONOMBREPORTAL,t2.USUULTMOD ORGANISMOUSUULTMOD,t2.FECULTMOD ORGANISMOFECULTMOD "
						+ "FROM DEST_COMUNICACION t1 ,ORGANISMO t2 ");

		if (destcomunicacion != null && destcomunicacion.getOrganismo() != null
				&& destcomunicacion.getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.COD_ORG = ?");
			params.add(destcomunicacion.getOrganismo().getCodOrg());
		}
		if (destcomunicacion != null
				&& destcomunicacion.getComunicacion().getM4cocomu() != null) {
			where.append(" AND t1.M5COCOMU = ?");
			params.add(destcomunicacion.getComunicacion().getM4cocomu());
		}
		if (destcomunicacion != null && destcomunicacion.getM5feleido() != null) {
			where.append(" AND t1.M5FELEIDO = ?");
			params.add(destcomunicacion.getM5feleido());
		}
		query.append(where);

		logger.warn("Query: " + query.toString());

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());

	}

	/**
	 * Counts rows in the DestComunicacion table.
	 * 
	 * @param destcomunicacion
	 *            DestComunicacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DestComunicacion destcomunicacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.M5COOR= t2.COD_ORG(+)	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  DEST_COMUNICACION t1  ,ORGANISMO t2 ");
		if (destcomunicacion != null && destcomunicacion.getOrganismo() != null
				&& destcomunicacion.getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.COD_ORG = ?");
			params.add(destcomunicacion.getOrganismo().getCodOrg());
		}
		if (destcomunicacion != null
				&& destcomunicacion.getComunicacion().getM4cocomu() != null) {
			where.append(" AND t1.M5COCOMU = ?");
			params.add(destcomunicacion.getComunicacion().getM4cocomu());
		}
		if (destcomunicacion != null && destcomunicacion.getM5feleido() != null) {
			where.append(" AND t1.M5FELEIDO = ?");
			params.add(destcomunicacion.getM5feleido());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the DestComunicacion table.
	 * 
	 * @param destcomunicacion
	 *            DestComunicacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLeidoCount(DestComunicacion destcomunicacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.M5COOR= t2.COD_ORG(+)	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  DEST_COMUNICACION t1  ,ORGANISMO t2 ");
		if (destcomunicacion != null && destcomunicacion.getOrganismo() != null
				&& destcomunicacion.getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.COD_ORG = ?");
			params.add(destcomunicacion.getOrganismo().getCodOrg());
		}
		if (destcomunicacion != null
				&& destcomunicacion.getComunicacion().getM4cocomu() != null) {
			where.append(" AND t1.M5COCOMU = ?");
			params.add(destcomunicacion.getComunicacion().getM4cocomu());
		}

		where.append(" AND t1.M5FELEIDO IS NOT NULL");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the DestComunicacion table using like.
	 * 
	 * @param destcomunicacion
	 *            DestComunicacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DestComunicacion> findAllLike(
			DestComunicacion destcomunicacion, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.M5COOR= t2.COD_ORG(+)	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.M5COCOMU M5COCOMU,t1.M5FELEIDO M5FELEIDO,t2.COD_ORG ORGANISMOCODORG,t2.ENTIDAD_ID ORGANISMOENTIDADID,t2.NOMBRE_ES ORGANISMONOMBREES,t2.NOMBRE_EU ORGANISMONOMBREEU,t2.ACTIVA ORGANISMOACTIVA,t2.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST,t2.ISKONTSUMONET ORGANISMOISKONTSUMONET,t2.ISOFERTAFORM ORGANISMOISOFERTAFORM,t2.ISCONSULTASWEB ORGANISMOISCONSULTASWEB,t2.ISNACIONAL ORGANISMOISNACIONAL,t2.OBSERVACIONES ORGANISMOOBSERVACIONES,t2.TELEFONO ORGANISMOTELEFONO,t2.FAX ORGANISMOFAX,t2.EMAIL ORGANISMOEMAIL,t2.URL ORGANISMOURL,t2.USUARIO ORGANISMOUSUARIO,t2.PASSWORD ORGANISMOPASSWORD,t2.NORA_PAIS_ID ORGANISMONORAPAISID,t2.NOMBRE_PAIS ORGANISMONOMBREPAIS,t2.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID,t2.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA,t2.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID,t2.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO,t2.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID,t2.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD,t2.NORA_CALLE_ID ORGANISMONORACALLEID,t2.NOMBRE_CALLE ORGANISMONOMBRECALLE,t2.NORA_CP_ID ORGANISMONORACPID,t2.NOMBRE_CP ORGANISMONOMBRECP,t2.NORA_PORTAL_ID ORGANISMONORAPORTALID,t2.NOMBRE_PORTAL ORGANISMONOMBREPORTAL,t2.USUULTMOD ORGANISMOUSUULTMOD,t2.FECULTMOD ORGANISMOFECULTMOD "
						+ "FROM DEST_COMUNICACION t1  ,ORGANISMO t2 ");

		if (destcomunicacion != null && destcomunicacion.getOrganismo() != null
				&& destcomunicacion.getOrganismo().getCodOrg() != null) {
			where.append(" AND UPPER(t2.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(destcomunicacion.getOrganismo().getCodOrg()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ destcomunicacion.getOrganismo().getCodOrg()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.COD_ORG IS NOT NULL");
		}
		if (destcomunicacion != null
				&& destcomunicacion.getComunicacion().getM4cocomu() != null) {
			where.append(" AND t1.M4COCOMU like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(destcomunicacion.getComunicacion().getM4cocomu()
						+ "%");
			} else {
				params.add("%"
						+ destcomunicacion.getComunicacion().getM4cocomu()
						+ "%");
			}
			where.append(" AND t1.M4COCOMU IS NOT NULL");
		}
		if (destcomunicacion != null && destcomunicacion.getM5feleido() != null) {
			where.append(" AND t1.M5FELEIDO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(destcomunicacion.getM5feleido() + "%");
			} else {
				params.add("%" + destcomunicacion.getM5feleido() + "%");
			}
			where.append(" AND t1.M5FELEIDO IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<DestComunicacion>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());

	}
}
