package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.model.Descriptor;

/**
 * * DescriptorDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DescriptorDaoImpl implements DescriptorDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Descriptor> rwMap = new RowMapper<Descriptor>() {
		public Descriptor mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Descriptor(resultSet.getString("IDDESCRIPTOR"),
					resultSet.getString("NOMBRE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Pagination
	 * @return Descriptor
	 */
	public Descriptor add(Descriptor descriptor) {

		String query = "INSERT INTO DESCRIPTOR( ID_DESCRIPTOR,NOMBRE)"
				+ "VALUES (?,?)";

		this.jdbcTemplate.update(query, descriptor.getIdDescriptor(),
				descriptor.getNombre());
		return descriptor;
	}

	/**
	 * Updates a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Pagination
	 * @return Descriptor
	 */
	public Descriptor update(Descriptor descriptor) {
		String query = "UPDATE DESCRIPTOR SET NOMBRE=? WHERE ID_DESCRIPTOR=?";
		this.jdbcTemplate.update(query, descriptor.getNombre(),
				descriptor.getIdDescriptor());
		return descriptor;
	}

	/**
	 * Finds a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Pagination
	 * @return Descriptor
	 */
	@Transactional(readOnly = true)
	public Descriptor find(Descriptor descriptor) {
		String query = "SELECT t1.ID_DESCRIPTOR IDDESCRIPTOR, t1.NOMBRE NOMBRE "
				+ "FROM DESCRIPTOR t1  " + "WHERE t1.ID_DESCRIPTOR = ?    ";
		return (Descriptor) this.jdbcTemplate.queryForObject(query, rwMap,
				descriptor.getIdDescriptor());
	}

	/**
	 * Removes a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Pagination
	 * @return
	 */
	public void remove(Descriptor descriptor) {
		String query = "DELETE  FROM DESCRIPTOR WHERE ID_DESCRIPTOR=?";
		this.jdbcTemplate.update(query, descriptor.getIdDescriptor());
	}

	/**
	 * Finds a List of rows in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Descriptor> findAll(Descriptor descriptor, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_DESCRIPTOR IDDESCRIPTOR,t1.NOMBRE NOMBRE "
						+ "FROM DESCRIPTOR t1 ");

		if (descriptor != null && descriptor.getIdDescriptor() != null) {
			where.append(" AND t1.ID_DESCRIPTOR = ?");
			params.add(descriptor.getIdDescriptor());
		}
		if (descriptor != null && descriptor.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			params.add("%" + descriptor.getNombre().toUpperCase() + "%");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY UPPER(" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<Descriptor>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Descriptor descriptor) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  DESCRIPTOR t1  ");
		if (descriptor != null && descriptor.getIdDescriptor() != null) {
			where.append(" AND t1.ID_DESCRIPTOR = ?");
			params.add(descriptor.getIdDescriptor());
		}
		if (descriptor != null && descriptor.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			params.add("%" + descriptor.getNombre().toUpperCase() + "%");
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Descriptor table using like.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Descriptor> findAllLike(Descriptor descriptor,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_DESCRIPTOR IDDESCRIPTOR,t1.NOMBRE NOMBRE "
						+ "FROM DESCRIPTOR t1 ");

		if (descriptor != null && descriptor.getIdDescriptor() != null) {
			where.append(" AND UPPER(t1.ID_DESCRIPTOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(descriptor.getIdDescriptor().toUpperCase() + "%");
			} else {
				params.add("%" + descriptor.getIdDescriptor().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ID_DESCRIPTOR IS NOT NULL");
		}
		if (descriptor != null && descriptor.getNombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE),'','AEIOU')  like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(descriptor.getNombre().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ descriptor.getNombre().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY UPPER(" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Descriptor>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Descriptor descriptor, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  DESCRIPTOR t1  ");
		if (descriptor != null && descriptor.getIdDescriptor() != null) {
			where.append(" AND UPPER(t1.ID_DESCRIPTOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(descriptor.getIdDescriptor().toUpperCase() + "%");
			} else {
				params.add("%" + descriptor.getIdDescriptor().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ID_DESCRIPTOR IS NOT NULL");
		}
		if (descriptor != null && descriptor.getNombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE),'','AEIOU')  like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(descriptor.getNombre().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ descriptor.getNombre().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllNombreDescriptorCount(Descriptor descriptor) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  DESCRIPTOR t1  ");

		if (descriptor != null && descriptor.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) = ? ");
			params.add(descriptor.getNombre().toUpperCase());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
