package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Descriptor;

/**
 * * DescriptorDao  
 * 
 *  
 */

public interface DescriptorDao {

	/**
	 * Inserts a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	Descriptor add(Descriptor descriptor);

	/**
	 * Updates a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	Descriptor update(Descriptor descriptor);

	/**
	 * Finds a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	Descriptor find(Descriptor descriptor);

	/**
	 * Deletes a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return
	 */
	void remove(Descriptor descriptor);

	/**
	 * Finds a List of rows in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Descriptor> findAll(Descriptor descriptor, Pagination pagination);

	/**
	 * Counts rows in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return List
	 */
	Long findAllCount(Descriptor descriptor);

	/**
	 * Finds rows in the Descriptor table using like.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Descriptor> findAllLike(Descriptor descriptor, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Descriptor descriptor, Boolean startsWith);

	/**
	 * Counts rows in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Long
	 */
	public Long findAllNombreDescriptorCount(Descriptor descriptor);
}
