package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.model.CampahnaRecibBusqueda;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.DenunciaRecib;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.TipoReclamacion;

/**
 * * DenunciaRecibDaoImpl  
 * 
 *  
 */
// CHECKSTYLE:OFF
@SuppressWarnings(value = { "deprecation" })
@Repository
@Transactional
public class DenunciaRecibDaoImpl implements DenunciaRecibDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<DenunciaRecib> rwMap = new RowMapper<DenunciaRecib>() {
		public DenunciaRecib mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DenunciaRecib(resultSet.getString("S6CODIGO"), resultSet.getString("S6CODORGANISMO"),
					resultSet.getDate("S6FECCOMUNICACION"), resultSet.getDate("S6FECFINALIZACION"),
					resultSet.getInt("S6CANTIDADACTUACIONES"),
					new HechoDenunciado(resultSet.getString("HechoDenunciadoHDCODIGO"),
							resultSet.getLong("HechoDenunciadoHDNROR"), resultSet.getString("HechoDenunciadoHDTE"),
							resultSet.getString("HechoDenunciadoHDTEDOAD"),
							resultSet.getString("HechoDenunciadoHDCOAV"), resultSet.getString("HechoDenunciadoHDNOPS"),
							resultSet.getString("HechoDenunciadoHDNOMAPS"),
							resultSet.getString("HechoDenunciadoHDNOMOPS"),
							resultSet.getString("HechoDenunciadoHDNRLOPS"), null,
							resultSet.getDate("HechoDenunciadoHDFEDMPS"),
							resultSet.getString("HechoDenunciadoHDINSOTR"),
							resultSet.getString("HechoDenunciadoHDINSOMA"),
							resultSet.getBigDecimal("HechoDenunciadoHDCAPTSO"),
							resultSet.getString("HechoDenunciadoHDTESO"), resultSet.getDate("HechoDenunciadoHDFEARDT"),
							resultSet.getDate("HechoDenunciadoHDFEIOHD"),
							resultSet.getString("HechoDenunciadoHDINININ"),
							resultSet.getDate("HechoDenunciadoHDFEIOPC"), resultSet.getDate("HechoDenunciadoHDFEROPC"),
							resultSet.getString("HechoDenunciadoHDCOREPC"),
							resultSet.getDate("HechoDenunciadoHDFEIORP"), resultSet.getDate("HechoDenunciadoHDFERORP"),
							resultSet.getString("HechoDenunciadoHDCOREAP"),
							resultSet.getDate("HechoDenunciadoHDFEIORA"),
							resultSet.getString("HechoDenunciadoHDTEACPA"),
							resultSet.getDate("HechoDenunciadoHDFECEAC"),
							resultSet.getString("HechoDenunciadoHDHOCEAC"),
							resultSet.getDate("HechoDenunciadoHDFEIOCA"),
							resultSet.getString("HechoDenunciadoHDTEACDE"),
							resultSet.getDate("HechoDenunciadoHDFEIOAC"), resultSet.getDate("HechoDenunciadoHDFEIOFC"),
							resultSet.getString("HechoDenunciadoHDCOTRA"), resultSet.getString("HechoDenunciadoHDTE02"),
							resultSet.getString("HechoDenunciadoHDTE03"), resultSet.getString("HechoDenunciadoHDTE04"),
							resultSet.getString("HechoDenunciadoHDTE05"), resultSet.getString("HechoDenunciadoHDTE06"),
							resultSet.getString("HechoDenunciadoHDTE07"), resultSet.getString("HechoDenunciadoHDTE08"),
							resultSet.getString("HechoDenunciadoHDTE09"), resultSet.getString("HechoDenunciadoHDTE10"),
							resultSet.getString("HechoDenunciadoHDCOSC"), resultSet.getString("HechoDenunciadoHDIDAL"),
							resultSet.getDate("HechoDenunciadoHDFEROAD"), resultSet.getDate("HechoDenunciadoHDFEROAT"),
							resultSet.getString("HechoDenunciadoHDTEALDT"),
							resultSet.getString("HechoDenunciadoHDTEDEAT"),
							resultSet.getDate("HechoDenunciadoHDFEDEAT"), resultSet.getDate("HechoDenunciadoHDFEHD"),
							resultSet.getString("HechoDenunciadoHDTEDOADE"),
							resultSet.getString("HechoDenunciadoHDTEDOADI"),
							resultSet.getString("HechoDenunciadoHDTEDOADF"),
							resultSet.getString("HechoDenunciadoHDTEDOADA"),
							resultSet.getString("HechoDenunciadoHDNOPSE"),
							resultSet.getString("HechoDenunciadoHDNOPSI"),
							resultSet.getString("HechoDenunciadoHDNOPSF"),
							resultSet.getString("HechoDenunciadoHDNOPSA"),
							resultSet.getString("HechoDenunciadoHDCOCODIGO"), null, null, null, null, null, null, null,
							resultSet.getString("HechoDenunciadoHDINTERESADO"),
							new Denuncia(resultSet.getString("HechoDenunciadoHDCODE"), null, null, null, null, null,
									null, null, null, null, null, null, null, null),
							new Establecimiento(resultSet.getString("HechoDenunciadoHDCOES"), null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null),
							new Sector(resultSet.getString("HechoDenunciadoHDCOSE"), null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null),
							new CensoMonitor(resultSet.getString("HechoDenunciadoHDCOMO"), null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null),
							new Producto(resultSet.getString("HechoDenunciadoHDCOPS"), null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null),
							new TipoReclamacion(resultSet.getString("HechoDenunciadoHDCOTSR"), null, null, null, null,
									null, null),
							new Motivo(resultSet.getString("HechoDenunciadoHDCOTIR"), null, null)));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the DenunciaRecib table.
	 * 
	 * @param denunciarecib
	 *            Pagination
	 * @return DenunciaRecib
	 */
	public DenunciaRecib add(DenunciaRecib denunciarecib) {

		String query = "INSERT INTO DENUNCIA_RECIB( S6CODIGO,S6CODHECDEN,S6CODORGANISMO,S6FECCOMUNICACION,S6FECFINALIZACION,S6CANTIDADACTUACIONES)"
				+ "VALUES (?,?,?,?,?,?)";

		Object getHechoDenunciadoHdcodigoAux = null;
		if (denunciarecib.getHechoDenunciado() != null && denunciarecib.getHechoDenunciado().getHdcodigo() != null) {
			getHechoDenunciadoHdcodigoAux = denunciarecib.getHechoDenunciado().getHdcodigo();
		}
		this.jdbcTemplate.update(query, denunciarecib.getS6codigo(), getHechoDenunciadoHdcodigoAux,
				denunciarecib.getS6codorganismo(), denunciarecib.getS6feccomunicacion(),
				denunciarecib.getS6fecfinalizacion(), denunciarecib.getS6cantidadactuaciones());
		return denunciarecib;
	}

	/**
	 * Updates a single row in the DenunciaRecib table.
	 * 
	 * @param denunciarecib
	 *            Pagination
	 * @return DenunciaRecib
	 */
	public DenunciaRecib update(DenunciaRecib denunciarecib) {
		String query = "UPDATE DENUNCIA_RECIB SET S6CODHECDEN=?,S6CODORGANISMO=?,S6FECCOMUNICACION=?,S6FECFINALIZACION=?,S6CANTIDADACTUACIONES=? WHERE S6CODIGO=?";
		Object getHechoDenunciadoHdcodigoAux = null;
		if (denunciarecib.getHechoDenunciado() != null && denunciarecib.getHechoDenunciado().getHdcodigo() != null) {
			getHechoDenunciadoHdcodigoAux = denunciarecib.getHechoDenunciado().getHdcodigo();
		}
		this.jdbcTemplate.update(query, getHechoDenunciadoHdcodigoAux, denunciarecib.getS6codorganismo(),
				denunciarecib.getS6feccomunicacion(), denunciarecib.getS6fecfinalizacion(),
				denunciarecib.getS6cantidadactuaciones(), denunciarecib.getS6codigo());
		return denunciarecib;
	}

	/**
	 * Updates a single row in the DenunciaRecib table.
	 * 
	 * @param campahnaRecibBusqueda
	 *            CampahnaRecibBusqueda
	 * @return CampahnaRecibBusqueda
	 */
	public CampahnaRecibBusqueda updateFinalizada(CampahnaRecibBusqueda campahnaRecibBusqueda) {
		String query = "UPDATE DENUNCIA_RECIB SET S6FECFINALIZACION=SYSDATE WHERE S6CODIGO=?";

		this.jdbcTemplate.update(query, campahnaRecibBusqueda.getCodigoRecibida());
		return campahnaRecibBusqueda;
	}

	/**
	 * Finds a single row in the DenunciaRecib table.
	 * 
	 * @param denunciarecib
	 *            Pagination
	 * @return DenunciaRecib
	 */
	@Transactional(readOnly = true)
	public DenunciaRecib find(DenunciaRecib denunciarecib) {
		String query = "SELECT t1.S6CODIGO S6CODIGO, t1.S6CODORGANISMO S6CODORGANISMO, t1.S6FECCOMUNICACION S6FECCOMUNICACION, t1.S6FECFINALIZACION S6FECFINALIZACION, t1.S6CANTIDADACTUACIONES S6CANTIDADACTUACIONES, t2.HDCODIGO HECHODENUNCIADOHDCODIGO, t2.HDNROR HECHODENUNCIADOHDNROR, t2.HDTE HECHODENUNCIADOHDTE, t2.HDTEDOAD HECHODENUNCIADOHDTEDOAD, t2.HDCOAV HECHODENUNCIADOHDCOAV, t2.HDNOPS HECHODENUNCIADOHDNOPS, t2.HDNOMAPS HECHODENUNCIADOHDNOMAPS, t2.HDNOMOPS HECHODENUNCIADOHDNOMOPS, t2.HDNRLOPS HECHODENUNCIADOHDNRLOPS, t2.HDFEDMPS HECHODENUNCIADOHDFEDMPS, t2.HDINSOTR HECHODENUNCIADOHDINSOTR, t2.HDINSOMA HECHODENUNCIADOHDINSOMA, t2.HDCAPTSO HECHODENUNCIADOHDCAPTSO, t2.HDTESO HECHODENUNCIADOHDTESO, t2.HDFEARDT HECHODENUNCIADOHDFEARDT, t2.HDFEIOHD HECHODENUNCIADOHDFEIOHD, t2.HDINININ HECHODENUNCIADOHDINININ, t2.HDFEIOPC HECHODENUNCIADOHDFEIOPC, t2.HDFEROPC HECHODENUNCIADOHDFEROPC, t2.HDCOREPC HECHODENUNCIADOHDCOREPC, t2.HDFEIORP HECHODENUNCIADOHDFEIORP, t2.HDFERORP HECHODENUNCIADOHDFERORP, t2.HDCOREAP HECHODENUNCIADOHDCOREAP, t2.HDFEIORA HECHODENUNCIADOHDFEIORA, t2.HDTEACPA HECHODENUNCIADOHDTEACPA, t2.HDFECEAC HECHODENUNCIADOHDFECEAC, t2.HDHOCEAC HECHODENUNCIADOHDHOCEAC, t2.HDFEIOCA HECHODENUNCIADOHDFEIOCA, t2.HDTEACDE HECHODENUNCIADOHDTEACDE, t2.HDFEIOAC HECHODENUNCIADOHDFEIOAC, t2.HDFEIOFC HECHODENUNCIADOHDFEIOFC, t2.HDCOTRA HECHODENUNCIADOHDCOTRA, t2.HDTE02 HECHODENUNCIADOHDTE02, t2.HDTE03 HECHODENUNCIADOHDTE03, t2.HDTE04 HECHODENUNCIADOHDTE04, t2.HDTE05 HECHODENUNCIADOHDTE05, t2.HDTE06 HECHODENUNCIADOHDTE06, t2.HDTE07 HECHODENUNCIADOHDTE07, t2.HDTE08 HECHODENUNCIADOHDTE08, t2.HDTE09 HECHODENUNCIADOHDTE09, t2.HDTE10 HECHODENUNCIADOHDTE10, t2.HDCOSC HECHODENUNCIADOHDCOSC, t2.HDIDAL HECHODENUNCIADOHDIDAL, t2.HDFEROAD HECHODENUNCIADOHDFEROAD, t2.HDFEROAT HECHODENUNCIADOHDFEROAT, t2.HDTEALDT HECHODENUNCIADOHDTEALDT, t2.HDTEDEAT HECHODENUNCIADOHDTEDEAT, t2.HDFEDEAT HECHODENUNCIADOHDFEDEAT, t2.HDFEHD HECHODENUNCIADOHDFEHD, t2.HDTEDOADE HECHODENUNCIADOHDTEDOADE, t2.HDTEDOADI HECHODENUNCIADOHDTEDOADI, t2.HDTEDOADF HECHODENUNCIADOHDTEDOADF, t2.HDTEDOADA HECHODENUNCIADOHDTEDOADA, t2.HDNOPSE HECHODENUNCIADOHDNOPSE, t2.HDNOPSI HECHODENUNCIADOHDNOPSI, t2.HDNOPSF HECHODENUNCIADOHDNOPSF, t2.HDNOPSA HECHODENUNCIADOHDNOPSA, t2.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO, t2.HDCODE HECHODENUNCIADOHDCODE, t2.HDCOES HECHODENUNCIADOHDCOES, t2.HDCOSE HECHODENUNCIADOHDCOSE, t2.HDCOMO HECHODENUNCIADOHDCOMO, t2.HDCOPS HECHODENUNCIADOHDCOPS, t2.HDCOTSR HECHODENUNCIADOHDCOTSR, t2.HDCOTIR HECHODENUNCIADOHDCOTIR "
				+ "FROM DENUNCIA_RECIB t1 , HECHO_DENUNCIADO t2  "
				+ "WHERE t1.S6CODIGO = ?   AND t1.S6CODHECDEN= t2.HDCODIGO(+)  ";
		return (DenunciaRecib) this.jdbcTemplate.queryForObject(query, rwMap, denunciarecib.getS6codigo());
	}

	/**
	 * Removes a single row in the DenunciaRecib table.
	 * 
	 * @param denunciarecib
	 *            Pagination
	 * @return
	 */
	public void remove(DenunciaRecib denunciarecib) {
		String query = "DELETE  FROM DENUNCIA_RECIB WHERE S6CODIGO=?";
		this.jdbcTemplate.update(query, denunciarecib.getS6codigo());
	}

	/**
	 * Finds a List of rows in the DenunciaRecib table.
	 * 
	 * @param denunciarecib
	 *            DenunciaRecib
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DenunciaRecib> findAll(DenunciaRecib denunciarecib, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.S6CODHECDEN= t2.HDCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.S6CODIGO S6CODIGO,t1.S6CODORGANISMO S6CODORGANISMO,t1.S6FECCOMUNICACION S6FECCOMUNICACION,t1.S6FECFINALIZACION S6FECFINALIZACION,t1.S6CANTIDADACTUACIONES S6CANTIDADACTUACIONES,t2.HDCODIGO HECHODENUNCIADOHDCODIGO,t2.HDNROR HECHODENUNCIADOHDNROR,t2.HDTE HECHODENUNCIADOHDTE,t2.HDTEDOAD HECHODENUNCIADOHDTEDOAD,t2.HDCOAV HECHODENUNCIADOHDCOAV,t2.HDNOPS HECHODENUNCIADOHDNOPS,t2.HDNOMAPS HECHODENUNCIADOHDNOMAPS,t2.HDNOMOPS HECHODENUNCIADOHDNOMOPS,t2.HDNRLOPS HECHODENUNCIADOHDNRLOPS,t2.HDFEDMPS HECHODENUNCIADOHDFEDMPS,t2.HDINSOTR HECHODENUNCIADOHDINSOTR,t2.HDINSOMA HECHODENUNCIADOHDINSOMA,t2.HDCAPTSO HECHODENUNCIADOHDCAPTSO,t2.HDTESO HECHODENUNCIADOHDTESO,t2.HDFEARDT HECHODENUNCIADOHDFEARDT,t2.HDFEIOHD HECHODENUNCIADOHDFEIOHD,t2.HDINININ HECHODENUNCIADOHDINININ,t2.HDFEIOPC HECHODENUNCIADOHDFEIOPC,t2.HDFEROPC HECHODENUNCIADOHDFEROPC,t2.HDCOREPC HECHODENUNCIADOHDCOREPC,t2.HDFEIORP HECHODENUNCIADOHDFEIORP,t2.HDFERORP HECHODENUNCIADOHDFERORP,t2.HDCOREAP HECHODENUNCIADOHDCOREAP,t2.HDFEIORA HECHODENUNCIADOHDFEIORA,t2.HDTEACPA HECHODENUNCIADOHDTEACPA,t2.HDFECEAC HECHODENUNCIADOHDFECEAC,t2.HDHOCEAC HECHODENUNCIADOHDHOCEAC,t2.HDFEIOCA HECHODENUNCIADOHDFEIOCA,t2.HDTEACDE HECHODENUNCIADOHDTEACDE,t2.HDFEIOAC HECHODENUNCIADOHDFEIOAC,t2.HDFEIOFC HECHODENUNCIADOHDFEIOFC,t2.HDCOTRA HECHODENUNCIADOHDCOTRA,t2.HDTE02 HECHODENUNCIADOHDTE02,t2.HDTE03 HECHODENUNCIADOHDTE03,t2.HDTE04 HECHODENUNCIADOHDTE04,t2.HDTE05 HECHODENUNCIADOHDTE05,t2.HDTE06 HECHODENUNCIADOHDTE06,t2.HDTE07 HECHODENUNCIADOHDTE07,t2.HDTE08 HECHODENUNCIADOHDTE08,t2.HDTE09 HECHODENUNCIADOHDTE09,t2.HDTE10 HECHODENUNCIADOHDTE10,t2.HDCOSC HECHODENUNCIADOHDCOSC,t2.HDIDAL HECHODENUNCIADOHDIDAL,t2.HDFEROAD HECHODENUNCIADOHDFEROAD,t2.HDFEROAT HECHODENUNCIADOHDFEROAT,t2.HDTEALDT HECHODENUNCIADOHDTEALDT,t2.HDTEDEAT HECHODENUNCIADOHDTEDEAT,t2.HDFEDEAT HECHODENUNCIADOHDFEDEAT,t2.HDFEHD HECHODENUNCIADOHDFEHD,t2.HDTEDOADE HECHODENUNCIADOHDTEDOADE,t2.HDTEDOADI HECHODENUNCIADOHDTEDOADI,t2.HDTEDOADF HECHODENUNCIADOHDTEDOADF,t2.HDTEDOADA HECHODENUNCIADOHDTEDOADA,t2.HDNOPSE HECHODENUNCIADOHDNOPSE,t2.HDNOPSI HECHODENUNCIADOHDNOPSI,t2.HDNOPSF HECHODENUNCIADOHDNOPSF,t2.HDNOPSA HECHODENUNCIADOHDNOPSA,t2.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO,t2.HDCODE HECHODENUNCIADOHDCODE,t2.HDCOES HECHODENUNCIADOHDCOES,t2.HDCOSE HECHODENUNCIADOHDCOSE,t2.HDCOMO HECHODENUNCIADOHDCOMO,t2.HDCOPS HECHODENUNCIADOHDCOPS,t2.HDCOTSR HECHODENUNCIADOHDCOTSR,t2.HDCOTIR HECHODENUNCIADOHDCOTIR "
						+ "FROM DENUNCIA_RECIB t1 ,HECHO_DENUNCIADO t2 ");

		if (denunciarecib != null && denunciarecib.getS6codigo() != null) {
			where.append(" AND t1.S6CODIGO = ?");
			params.add(denunciarecib.getS6codigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t2.HDCODIGO = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getDenuncia() != null
				&& denunciarecib.getHechoDenunciado().getDenuncia().getDecodigo() != null) {
			where.append(" AND t2.HDCODE = ?");
			params.add(denunciarecib.getHechoDenunciado().getDenuncia().getDecodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getEstablecimiento() != null
				&& denunciarecib.getHechoDenunciado().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t2.HDCOES = ?");
			params.add(denunciarecib.getHechoDenunciado().getEstablecimiento().getEscodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getSector() != null
				&& denunciarecib.getHechoDenunciado().getSector().getSecodigo() != null) {
			where.append(" AND t2.HDCOSE = ?");
			params.add(denunciarecib.getHechoDenunciado().getSector().getSecodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getCensoMonitor() != null
				&& denunciarecib.getHechoDenunciado().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.HDCOMO = ?");
			params.add(denunciarecib.getHechoDenunciado().getCensoMonitor().getMocodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getProducto() != null
				&& denunciarecib.getHechoDenunciado().getProducto().getPscodigo() != null) {
			where.append(" AND t2.HDCOPS = ?");
			params.add(denunciarecib.getHechoDenunciado().getProducto().getPscodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getTipoReclamacion() != null
				&& denunciarecib.getHechoDenunciado().getTipoReclamacion().getTsrcodigo() != null) {
			where.append(" AND t2.HDCOTSR = ?");
			params.add(denunciarecib.getHechoDenunciado().getTipoReclamacion().getTsrcodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getMotivo() != null
				&& denunciarecib.getHechoDenunciado().getMotivo().getTircodigo() != null) {
			where.append(" AND t2.HDCOTIR = ?");
			params.add(denunciarecib.getHechoDenunciado().getMotivo().getTircodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t2.HDNROR = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnror());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte() != null) {
			where.append(" AND t2.HDTE = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND t2.HDTEDOAD = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdtedoad());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND t2.HDCOAV = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcoav());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND t2.HDNOPS = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnops());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND t2.HDNOMAPS = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnomaps());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND t2.HDNOMOPS = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnomops());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND t2.HDNRLOPS = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnrlops());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t2.HDFEDMPS = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfedmps());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND t2.HDINSOTR = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdinsotr());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND t2.HDINSOMA = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdinsoma());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t2.HDCAPTSO = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcaptso());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND t2.HDTESO = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdteso());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t2.HDFEARDT = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeardt());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t2.HDFEIOHD = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeiohd());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND t2.HDINININ = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdininin());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t2.HDFEIOPC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeiopc());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t2.HDFEROPC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdferopc());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND t2.HDCOREPC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcorepc());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t2.HDFEIORP = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeiorp());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t2.HDFERORP = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdferorp());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND t2.HDCOREAP = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcoreap());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t2.HDFEIORA = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeiora());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND t2.HDTEACPA = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdteacpa());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t2.HDFECEAC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeceac());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND t2.HDHOCEAC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdhoceac());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t2.HDFEIOCA = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeioca());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND t2.HDTEACDE = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdteacde());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t2.HDFEIOAC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeioac());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t2.HDFEIOFC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeiofc());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND t2.HDCOTRA = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcotra());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND t2.HDTE02 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte02());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND t2.HDTE03 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte03());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND t2.HDTE04 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte04());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND t2.HDTE05 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte05());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND t2.HDTE06 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte06());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND t2.HDTE07 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte07());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND t2.HDTE08 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte08());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND t2.HDTE09 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte09());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND t2.HDTE10 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte10());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND t2.HDCOSC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcosc());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND t2.HDIDAL = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdidal());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t2.HDFEROAD = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdferoad());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t2.HDFEROAT = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdferoat());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND t2.HDTEALDT = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdtealdt());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND t2.HDTEDEAT = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdtedeat());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t2.HDFEDEAT = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfedeat());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t2.HDFEHD = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfehd());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND t2.HDTEDOADE = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdtedoade());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND t2.HDTEDOADI = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdtedoadi());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND t2.HDTEDOADF = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdtedoadf());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND t2.HDTEDOADA = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdtedoada());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND t2.HDNOPSE = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnopse());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND t2.HDNOPSI = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnopsi());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND t2.HDNOPSF = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnopsf());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND t2.HDNOPSA = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnopsa());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND t2.HDCOCODIGO = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcocodigo());
		}
		if (denunciarecib != null && denunciarecib.getS6codorganismo() != null) {
			where.append(" AND t1.S6CODORGANISMO = ?");
			params.add(denunciarecib.getS6codorganismo());
		}
		if (denunciarecib != null && denunciarecib.getS6feccomunicacion() != null) {
			where.append(" AND t1.S6FECCOMUNICACION = ?");
			params.add(denunciarecib.getS6feccomunicacion());
		}
		if (denunciarecib != null && denunciarecib.getS6fecfinalizacion() != null) {
			where.append(" AND t1.S6FECFINALIZACION = ?");
			params.add(denunciarecib.getS6fecfinalizacion());
		}
		if (denunciarecib != null && denunciarecib.getS6cantidadactuaciones() != null) {
			where.append(" AND t1.S6CANTIDADACTUACIONES = ?");
			params.add(denunciarecib.getS6cantidadactuaciones());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<DenunciaRecib>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DenunciaRecib table.
	 * 
	 * @param denunciarecib
	 *            DenunciaRecib
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DenunciaRecib denunciarecib) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.S6CODHECDEN= t2.HDCODIGO(+) ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  DENUNCIA_RECIB t1   ,  HECHO_DENUNCIADO t2  ");
		if (denunciarecib != null && denunciarecib.getS6codigo() != null) {
			where.append(" AND t1.S6CODIGO = ?");
			params.add(denunciarecib.getS6codigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t2.HDCODIGO = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getDenuncia() != null
				&& denunciarecib.getHechoDenunciado().getDenuncia().getDecodigo() != null) {
			where.append(" AND t2.HDCODE = ?");
			params.add(denunciarecib.getHechoDenunciado().getDenuncia().getDecodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getEstablecimiento() != null
				&& denunciarecib.getHechoDenunciado().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t2.HDCOES = ?");
			params.add(denunciarecib.getHechoDenunciado().getEstablecimiento().getEscodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getSector() != null
				&& denunciarecib.getHechoDenunciado().getSector().getSecodigo() != null) {
			where.append(" AND t2.HDCOSE = ?");
			params.add(denunciarecib.getHechoDenunciado().getSector().getSecodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getCensoMonitor() != null
				&& denunciarecib.getHechoDenunciado().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.HDCOMO = ?");
			params.add(denunciarecib.getHechoDenunciado().getCensoMonitor().getMocodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getProducto() != null
				&& denunciarecib.getHechoDenunciado().getProducto().getPscodigo() != null) {
			where.append(" AND t2.HDCOPS = ?");
			params.add(denunciarecib.getHechoDenunciado().getProducto().getPscodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getTipoReclamacion() != null
				&& denunciarecib.getHechoDenunciado().getTipoReclamacion().getTsrcodigo() != null) {
			where.append(" AND t2.HDCOTSR = ?");
			params.add(denunciarecib.getHechoDenunciado().getTipoReclamacion().getTsrcodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getMotivo() != null
				&& denunciarecib.getHechoDenunciado().getMotivo().getTircodigo() != null) {
			where.append(" AND t2.HDCOTIR = ?");
			params.add(denunciarecib.getHechoDenunciado().getMotivo().getTircodigo());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t2.HDNROR = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnror());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte() != null) {
			where.append(" AND t2.HDTE = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND t2.HDTEDOAD = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdtedoad());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND t2.HDCOAV = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcoav());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND t2.HDNOPS = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnops());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND t2.HDNOMAPS = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnomaps());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND t2.HDNOMOPS = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnomops());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND t2.HDNRLOPS = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnrlops());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t2.HDFEDMPS = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfedmps());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND t2.HDINSOTR = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdinsotr());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND t2.HDINSOMA = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdinsoma());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t2.HDCAPTSO = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcaptso());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND t2.HDTESO = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdteso());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t2.HDFEARDT = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeardt());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t2.HDFEIOHD = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeiohd());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND t2.HDINININ = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdininin());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t2.HDFEIOPC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeiopc());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t2.HDFEROPC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdferopc());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND t2.HDCOREPC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcorepc());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t2.HDFEIORP = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeiorp());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t2.HDFERORP = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdferorp());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND t2.HDCOREAP = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcoreap());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t2.HDFEIORA = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeiora());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND t2.HDTEACPA = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdteacpa());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t2.HDFECEAC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeceac());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND t2.HDHOCEAC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdhoceac());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t2.HDFEIOCA = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeioca());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND t2.HDTEACDE = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdteacde());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t2.HDFEIOAC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeioac());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t2.HDFEIOFC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfeiofc());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND t2.HDCOTRA = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcotra());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND t2.HDTE02 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte02());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND t2.HDTE03 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte03());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND t2.HDTE04 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte04());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND t2.HDTE05 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte05());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND t2.HDTE06 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte06());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND t2.HDTE07 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte07());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND t2.HDTE08 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte08());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND t2.HDTE09 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte09());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND t2.HDTE10 = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdte10());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND t2.HDCOSC = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcosc());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND t2.HDIDAL = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdidal());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t2.HDFEROAD = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdferoad());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t2.HDFEROAT = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdferoat());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND t2.HDTEALDT = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdtealdt());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND t2.HDTEDEAT = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdtedeat());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t2.HDFEDEAT = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfedeat());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t2.HDFEHD = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdfehd());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND t2.HDTEDOADE = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdtedoade());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND t2.HDTEDOADI = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdtedoadi());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND t2.HDTEDOADF = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdtedoadf());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND t2.HDTEDOADA = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdtedoada());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND t2.HDNOPSE = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnopse());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND t2.HDNOPSI = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnopsi());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND t2.HDNOPSF = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnopsf());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND t2.HDNOPSA = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdnopsa());
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND t2.HDCOCODIGO = ?");
			params.add(denunciarecib.getHechoDenunciado().getHdcocodigo());
		}
		if (denunciarecib != null && denunciarecib.getS6codorganismo() != null) {
			where.append(" AND t1.S6CODORGANISMO = ?");
			params.add(denunciarecib.getS6codorganismo());
		}
		if (denunciarecib != null && denunciarecib.getS6feccomunicacion() != null) {
			where.append(" AND t1.S6FECCOMUNICACION = ?");
			params.add(denunciarecib.getS6feccomunicacion());
		}
		if (denunciarecib != null && denunciarecib.getS6fecfinalizacion() != null) {
			where.append(" AND t1.S6FECFINALIZACION = ?");
			params.add(denunciarecib.getS6fecfinalizacion());
		}
		if (denunciarecib != null && denunciarecib.getS6cantidadactuaciones() != null) {
			where.append(" AND t1.S6CANTIDADACTUACIONES = ?");
			params.add(denunciarecib.getS6cantidadactuaciones());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the DenunciaRecib table using like.
	 * 
	 * @param denunciarecib
	 *            DenunciaRecib
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DenunciaRecib> findAllLike(DenunciaRecib denunciarecib, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.S6CODHECDEN= t2.HDCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.S6CODIGO S6CODIGO,t1.S6CODORGANISMO S6CODORGANISMO,t1.S6FECCOMUNICACION S6FECCOMUNICACION,t1.S6FECFINALIZACION S6FECFINALIZACION,t1.S6CANTIDADACTUACIONES S6CANTIDADACTUACIONES,t2.HDCODIGO HECHODENUNCIADOHDCODIGO,t2.HDNROR HECHODENUNCIADOHDNROR,t2.HDTE HECHODENUNCIADOHDTE,t2.HDTEDOAD HECHODENUNCIADOHDTEDOAD,t2.HDCOAV HECHODENUNCIADOHDCOAV,t2.HDNOPS HECHODENUNCIADOHDNOPS,t2.HDNOMAPS HECHODENUNCIADOHDNOMAPS,t2.HDNOMOPS HECHODENUNCIADOHDNOMOPS,t2.HDNRLOPS HECHODENUNCIADOHDNRLOPS,t2.HDFEDMPS HECHODENUNCIADOHDFEDMPS,t2.HDINSOTR HECHODENUNCIADOHDINSOTR,t2.HDINSOMA HECHODENUNCIADOHDINSOMA,t2.HDCAPTSO HECHODENUNCIADOHDCAPTSO,t2.HDTESO HECHODENUNCIADOHDTESO,t2.HDFEARDT HECHODENUNCIADOHDFEARDT,t2.HDFEIOHD HECHODENUNCIADOHDFEIOHD,t2.HDINININ HECHODENUNCIADOHDINININ,t2.HDFEIOPC HECHODENUNCIADOHDFEIOPC,t2.HDFEROPC HECHODENUNCIADOHDFEROPC,t2.HDCOREPC HECHODENUNCIADOHDCOREPC,t2.HDFEIORP HECHODENUNCIADOHDFEIORP,t2.HDFERORP HECHODENUNCIADOHDFERORP,t2.HDCOREAP HECHODENUNCIADOHDCOREAP,t2.HDFEIORA HECHODENUNCIADOHDFEIORA,t2.HDTEACPA HECHODENUNCIADOHDTEACPA,t2.HDFECEAC HECHODENUNCIADOHDFECEAC,t2.HDHOCEAC HECHODENUNCIADOHDHOCEAC,t2.HDFEIOCA HECHODENUNCIADOHDFEIOCA,t2.HDTEACDE HECHODENUNCIADOHDTEACDE,t2.HDFEIOAC HECHODENUNCIADOHDFEIOAC,t2.HDFEIOFC HECHODENUNCIADOHDFEIOFC,t2.HDCOTRA HECHODENUNCIADOHDCOTRA,t2.HDTE02 HECHODENUNCIADOHDTE02,t2.HDTE03 HECHODENUNCIADOHDTE03,t2.HDTE04 HECHODENUNCIADOHDTE04,t2.HDTE05 HECHODENUNCIADOHDTE05,t2.HDTE06 HECHODENUNCIADOHDTE06,t2.HDTE07 HECHODENUNCIADOHDTE07,t2.HDTE08 HECHODENUNCIADOHDTE08,t2.HDTE09 HECHODENUNCIADOHDTE09,t2.HDTE10 HECHODENUNCIADOHDTE10,t2.HDCOSC HECHODENUNCIADOHDCOSC,t2.HDIDAL HECHODENUNCIADOHDIDAL,t2.HDFEROAD HECHODENUNCIADOHDFEROAD,t2.HDFEROAT HECHODENUNCIADOHDFEROAT,t2.HDTEALDT HECHODENUNCIADOHDTEALDT,t2.HDTEDEAT HECHODENUNCIADOHDTEDEAT,t2.HDFEDEAT HECHODENUNCIADOHDFEDEAT,t2.HDFEHD HECHODENUNCIADOHDFEHD,t2.HDTEDOADE HECHODENUNCIADOHDTEDOADE,t2.HDTEDOADI HECHODENUNCIADOHDTEDOADI,t2.HDTEDOADF HECHODENUNCIADOHDTEDOADF,t2.HDTEDOADA HECHODENUNCIADOHDTEDOADA,t2.HDNOPSE HECHODENUNCIADOHDNOPSE,t2.HDNOPSI HECHODENUNCIADOHDNOPSI,t2.HDNOPSF HECHODENUNCIADOHDNOPSF,t2.HDNOPSA HECHODENUNCIADOHDNOPSA,t2.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO,t2.HDCODE HECHODENUNCIADOHDCODE,t2.HDCOES HECHODENUNCIADOHDCOES,t2.HDCOSE HECHODENUNCIADOHDCOSE,t2.HDCOMO HECHODENUNCIADOHDCOMO,t2.HDCOPS HECHODENUNCIADOHDCOPS,t2.HDCOTSR HECHODENUNCIADOHDCOTSR,t2.HDCOTIR HECHODENUNCIADOHDCOTIR "
						+ "FROM DENUNCIA_RECIB t1 ,HECHO_DENUNCIADO t2 ");

		if (denunciarecib != null && denunciarecib.getS6codigo() != null) {
			where.append(" AND UPPER(t1.S6CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getS6codigo().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getS6codigo().toUpperCase() + "%");
			}
			where.append(" AND t1.S6CODIGO IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t2.HDCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdcodigo() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdcodigo() + "%");
			}
			where.append(" AND t2.HDCODIGO IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getDenuncia() != null
				&& denunciarecib.getHechoDenunciado().getDenuncia().getDecodigo() != null) {
			where.append(" AND UPPER(t2.HDCODE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getDenuncia().getDecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getDenuncia().getDecodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCODE IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getEstablecimiento() != null
				&& denunciarecib.getHechoDenunciado().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND UPPER(t2.HDCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getEstablecimiento().getEscodigo().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getEstablecimiento().getEscodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.HDCOES IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getSector() != null
				&& denunciarecib.getHechoDenunciado().getSector().getSecodigo() != null) {
			where.append(" AND UPPER(t2.HDCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getSector().getSecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getSector().getSecodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOSE IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getCensoMonitor() != null
				&& denunciarecib.getHechoDenunciado().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t2.HDCOMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getCensoMonitor().getMocodigo().toUpperCase() + "%");
			} else {
				params.add(
						"%" + denunciarecib.getHechoDenunciado().getCensoMonitor().getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOMO IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getProducto() != null
				&& denunciarecib.getHechoDenunciado().getProducto().getPscodigo() != null) {
			where.append(" AND UPPER(t2.HDCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getProducto().getPscodigo().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getProducto().getPscodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOPS IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getTipoReclamacion() != null
				&& denunciarecib.getHechoDenunciado().getTipoReclamacion().getTsrcodigo() != null) {
			where.append(" AND UPPER(t2.HDCOTSR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getTipoReclamacion().getTsrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getTipoReclamacion().getTsrcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.HDCOTSR IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getMotivo() != null
				&& denunciarecib.getHechoDenunciado().getMotivo().getTircodigo() != null) {
			where.append(" AND UPPER(t2.HDCOTIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getMotivo().getTircodigo().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getMotivo().getTircodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOTIR IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t2.HDNROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdnror() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdnror() + "%");
			}
			where.append(" AND t2.HDNROR IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte() != null) {
			where.append(" AND UPPER(t2.HDTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdte().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdte().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND UPPER(t2.HDTEDOAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdtedoad().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdtedoad().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOAD IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND UPPER(t2.HDCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdcoav().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdcoav().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOAV IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND UPPER(t2.HDNOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdnops().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdnops().toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPS IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND UPPER(t2.HDNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdnomaps().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdnomaps().toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOMAPS IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND UPPER(t2.HDNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdnomops().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdnomops().toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOMOPS IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND UPPER(t2.HDNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdnrlops().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdnrlops().toUpperCase() + "%");
			}
			where.append(" AND t2.HDNRLOPS IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t2.HDFEDMPS like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdfedmps() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdfedmps() + "%");
			}
			where.append(" AND t2.HDFEDMPS IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND UPPER(t2.HDINSOTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdinsotr().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdinsotr().toUpperCase() + "%");
			}
			where.append(" AND t2.HDINSOTR IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND UPPER(t2.HDINSOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdinsoma().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdinsoma().toUpperCase() + "%");
			}
			where.append(" AND t2.HDINSOMA IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t2.HDCAPTSO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdcaptso() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdcaptso() + "%");
			}
			where.append(" AND t2.HDCAPTSO IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND UPPER(t2.HDTESO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdteso().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdteso().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTESO IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t2.HDFEARDT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdfeardt() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdfeardt() + "%");
			}
			where.append(" AND t2.HDFEARDT IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t2.HDFEIOHD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdfeiohd() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdfeiohd() + "%");
			}
			where.append(" AND t2.HDFEIOHD IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND UPPER(t2.HDINININ) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdininin().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdininin().toUpperCase() + "%");
			}
			where.append(" AND t2.HDINININ IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t2.HDFEIOPC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdfeiopc() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdfeiopc() + "%");
			}
			where.append(" AND t2.HDFEIOPC IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t2.HDFEROPC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdferopc() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdferopc() + "%");
			}
			where.append(" AND t2.HDFEROPC IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND UPPER(t2.HDCOREPC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdcorepc().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdcorepc().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOREPC IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t2.HDFEIORP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdfeiorp() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdfeiorp() + "%");
			}
			where.append(" AND t2.HDFEIORP IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t2.HDFERORP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdferorp() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdferorp() + "%");
			}
			where.append(" AND t2.HDFERORP IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND UPPER(t2.HDCOREAP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdcoreap().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdcoreap().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOREAP IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t2.HDFEIORA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdfeiora() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdfeiora() + "%");
			}
			where.append(" AND t2.HDFEIORA IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND UPPER(t2.HDTEACPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdteacpa().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdteacpa().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEACPA IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t2.HDFECEAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdfeceac() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdfeceac() + "%");
			}
			where.append(" AND t2.HDFECEAC IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND UPPER(t2.HDHOCEAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdhoceac().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdhoceac().toUpperCase() + "%");
			}
			where.append(" AND t2.HDHOCEAC IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t2.HDFEIOCA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdfeioca() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdfeioca() + "%");
			}
			where.append(" AND t2.HDFEIOCA IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND UPPER(t2.HDTEACDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdteacde().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdteacde().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEACDE IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t2.HDFEIOAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdfeioac() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdfeioac() + "%");
			}
			where.append(" AND t2.HDFEIOAC IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t2.HDFEIOFC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdfeiofc() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdfeiofc() + "%");
			}
			where.append(" AND t2.HDFEIOFC IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND UPPER(t2.HDCOTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdcotra().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdcotra().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOTRA IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND UPPER(t2.HDTE02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdte02().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdte02().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE02 IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND UPPER(t2.HDTE03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdte03().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdte03().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE03 IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND UPPER(t2.HDTE04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdte04().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdte04().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE04 IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND UPPER(t2.HDTE05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdte05().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdte05().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE05 IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND UPPER(t2.HDTE06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdte06().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdte06().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE06 IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND UPPER(t2.HDTE07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdte07().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdte07().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE07 IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND UPPER(t2.HDTE08) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdte08().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdte08().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE08 IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND UPPER(t2.HDTE09) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdte09().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdte09().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE09 IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND UPPER(t2.HDTE10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdte10().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdte10().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE10 IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND UPPER(t2.HDCOSC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdcosc().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdcosc().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOSC IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND UPPER(t2.HDIDAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdidal().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdidal().toUpperCase() + "%");
			}
			where.append(" AND t2.HDIDAL IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t2.HDFEROAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdferoad() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdferoad() + "%");
			}
			where.append(" AND t2.HDFEROAD IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t2.HDFEROAT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdferoat() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdferoat() + "%");
			}
			where.append(" AND t2.HDFEROAT IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND UPPER(t2.HDTEALDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdtealdt().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdtealdt().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEALDT IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND UPPER(t2.HDTEDEAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdtedeat().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdtedeat().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDEAT IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t2.HDFEDEAT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdfedeat() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdfedeat() + "%");
			}
			where.append(" AND t2.HDFEDEAT IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t2.HDFEHD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdfehd() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdfehd() + "%");
			}
			where.append(" AND t2.HDFEHD IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND UPPER(t2.HDTEDOADE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdtedoade().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdtedoade().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOADE IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND UPPER(t2.HDTEDOADI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdtedoadi().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdtedoadi().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOADI IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND UPPER(t2.HDTEDOADF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdtedoadf().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdtedoadf().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOADF IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND UPPER(t2.HDTEDOADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdtedoada().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdtedoada().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOADA IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND UPPER(t2.HDNOPSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdnopse().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdnopse().toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPSE IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND UPPER(t2.HDNOPSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdnopsi().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdnopsi().toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPSI IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND UPPER(t2.HDNOPSF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdnopsf().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdnopsf().toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPSF IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND UPPER(t2.HDNOPSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdnopsa().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdnopsa().toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPSA IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getHechoDenunciado() != null
				&& denunciarecib.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND UPPER(t2.HDCOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getHechoDenunciado().getHdcocodigo().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getHechoDenunciado().getHdcocodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOCODIGO IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getS6codorganismo() != null) {
			where.append(" AND UPPER(t1.S6CODORGANISMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getS6codorganismo().toUpperCase() + "%");
			} else {
				params.add("%" + denunciarecib.getS6codorganismo().toUpperCase() + "%");
			}
			where.append(" AND t1.S6CODORGANISMO IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getS6feccomunicacion() != null) {
			where.append(" AND t1.S6FECCOMUNICACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getS6feccomunicacion() + "%");
			} else {
				params.add("%" + denunciarecib.getS6feccomunicacion() + "%");
			}
			where.append(" AND t1.S6FECCOMUNICACION IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getS6fecfinalizacion() != null) {
			where.append(" AND t1.S6FECFINALIZACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getS6fecfinalizacion() + "%");
			} else {
				params.add("%" + denunciarecib.getS6fecfinalizacion() + "%");
			}
			where.append(" AND t1.S6FECFINALIZACION IS NOT NULL");
		}
		if (denunciarecib != null && denunciarecib.getS6cantidadactuaciones() != null) {
			where.append(" AND t1.S6CANTIDADACTUACIONES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denunciarecib.getS6cantidadactuaciones() + "%");
			} else {
				params.add("%" + denunciarecib.getS6cantidadactuaciones() + "%");
			}
			where.append(" AND t1.S6CANTIDADACTUACIONES IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<DenunciaRecib>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}
}
