package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.CampahnaRecibBusqueda;
import com.ejie.y41b.model.DenunciaRecib;

/**
 * * DenunciaRecibDao  
 * 
 *  
 */

public interface DenunciaRecibDao {

	/**
	 * Inserts a single row in the DenunciaRecib table.
	 * 
	 * @param denunciarecib
	 *            DenunciaRecib
	 * @return DenunciaRecib
	 */
	DenunciaRecib add(DenunciaRecib denunciarecib);

	/**
	 * Updates a single row in the DenunciaRecib table.
	 * 
	 * @param denunciarecib
	 *            DenunciaRecib
	 * @return DenunciaRecib
	 */
	DenunciaRecib update(DenunciaRecib denunciarecib);

	/**
	 * Updates a single row in the DenunciaRecib table.
	 * 
	 * @param campahnaRecibBusqueda
	 *            CampahnaRecibBusqueda
	 * @return CampahnaRecibBusqueda
	 */
	CampahnaRecibBusqueda updateFinalizada(
			CampahnaRecibBusqueda campahnaRecibBusqueda);

	/**
	 * Finds a single row in the DenunciaRecib table.
	 * 
	 * @param denunciarecib
	 *            DenunciaRecib
	 * @return DenunciaRecib
	 */
	DenunciaRecib find(DenunciaRecib denunciarecib);

	/**
	 * Deletes a single row in the DenunciaRecib table.
	 * 
	 * @param denunciarecib
	 *            DenunciaRecib
	 * @return
	 */
	void remove(DenunciaRecib denunciarecib);

	/**
	 * Finds a List of rows in the DenunciaRecib table.
	 * 
	 * @param denunciarecib
	 *            DenunciaRecib
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DenunciaRecib> findAll(DenunciaRecib denunciarecib,
			Pagination pagination);

	/**
	 * Counts rows in the DenunciaRecib table.
	 * 
	 * @param denunciarecib
	 *            DenunciaRecib
	 * @return List
	 */
	Long findAllCount(DenunciaRecib denunciarecib);

	/**
	 * Finds rows in the DenunciaRecib table using like.
	 * 
	 * @param denunciarecib
	 *            DenunciaRecib
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<DenunciaRecib> findAllLike(DenunciaRecib denunciarecib,
			Pagination pagination, Boolean startsWith);
}
