package com.ejie.y41b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.SolicitudEnvios;

/**
 * * DenunciaDao  
 * 
 *  
 */

public interface DenunciaDao {

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia add(Denuncia denuncia);

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return Denuncia
	 */
	Denuncia addDenuncia(Denuncia denuncia);

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 */
	public void enviarDenunciaTelematica(SolicitudDetalle solicitudDetalle);

	/**
	 * Removes a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return
	 */
	public void removeDenunciaTelematica(SolicitudDetalle solicitudDetalle);

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia update(Denuncia denuncia);

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return Denuncia
	 */
	public Denuncia updateConsumidor(Denuncia denuncia);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia find(Denuncia denuncia);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia findDenunciaPropARB(Denuncia denuncia);

	/**
	 * Deletes a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return
	 */
	void remove(Denuncia denuncia);

	/**
	 * Removes a single row in the Denuncia table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return
	 */
	public void removeDenunciaExpediente(HechoDenunciado hechodenunciado);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Denuncia> findAll(Denuncia denuncia, Pagination pagination);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return List
	 */
	Long findAllCount(Denuncia denuncia);

	/**
	 * Finds rows in the Denuncia table using like.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Denuncia> findAllLike(Denuncia denuncia, Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Denuncia> findAllDenunciaConsumidor(Denuncia denuncia, Pagination pagination);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param hechoDenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SolicitudEnvios> findAllSolicitudEnvios(HechoDenunciado hechoDenunciado, Pagination pagination);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param hechoDenunciado
	 *            HechoDenunciado
	 * @return Long
	 */
	public Long findAllSolicitudEnviosCount(HechoDenunciado hechoDenunciado);

}
