package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.DecisionL21;

/**
 * DecisionL21DaoImpl  
 *  
 */
 
@Repository
@Transactional
public class DecisionL21DaoImpl implements DecisionL21Dao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<DecisionL21> rwMap = new RowMapper<DecisionL21>() {
		public DecisionL21 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new DecisionL21(
               resultSet.getString("TTDCODIGO"), resultSet.getString("TTDNOMBRE"), resultSet.getString("TTDNOMBREE"), resultSet.getString("TTDNOMBREI"), resultSet.getString("TTDNOMBREF"), resultSet.getString("TTDNOMBREA"), resultSet.getString("TTDCOE9")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the DecisionL21 table.
     *
     * @param decisionl21 Pagination
     * @return DecisionL21
     */
	public DecisionL21 add(DecisionL21 decisionl21) {
    	String query = "INSERT INTO DECISION_L21 (TTDCODIGO, TTDNOMBRE, TTDNOMBREE, TTDNOMBREI, TTDNOMBREF, TTDNOMBREA, TTDCOE9) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, decisionl21.getTtdcodigo(), decisionl21.getTtdnombre(), decisionl21.getTtdnombree(), decisionl21.getTtdnombrei(), decisionl21.getTtdnombref(), decisionl21.getTtdnombrea(), decisionl21.getTtdcoe9());
		return decisionl21;
	}

    /**
     * Updates a single row in the DecisionL21 table.
     *
     * @param decisionl21 Pagination
     * @return DecisionL21
     */
    public DecisionL21 update(DecisionL21 decisionl21) {
		String query = "UPDATE DECISION_L21 SET TTDNOMBRE=?, TTDNOMBREE=?, TTDNOMBREI=?, TTDNOMBREF=?, TTDNOMBREA=?, TTDCOE9=? WHERE TTDCODIGO=?";
		this.jdbcTemplate.update(query, decisionl21.getTtdnombre(), decisionl21.getTtdnombree(), decisionl21.getTtdnombrei(), decisionl21.getTtdnombref(), decisionl21.getTtdnombrea(), decisionl21.getTtdcoe9(), decisionl21.getTtdcodigo());
		return decisionl21;
	}

    /**
     * Finds a single row in the DecisionL21 table.
     *
     * @param decisionl21 Pagination
     * @return DecisionL21
     */
    @Transactional (readOnly = true)
    public DecisionL21 find(DecisionL21 decisionl21) {
		String query = "SELECT t1.TTDCODIGO TTDCODIGO, t1.TTDNOMBRE TTDNOMBRE, t1.TTDNOMBREE TTDNOMBREE, t1.TTDNOMBREI TTDNOMBREI, t1.TTDNOMBREF TTDNOMBREF, t1.TTDNOMBREA TTDNOMBREA, t1.TTDCOE9 TTDCOE9 FROM DECISION_L21 t1  WHERE t1.TTDCODIGO = ?  ";
		
		List<DecisionL21> decisionl21List = this.jdbcTemplate.query(query, this.rwMap, decisionl21.getTtdcodigo());
		return (DecisionL21) DataAccessUtils.uniqueResult(decisionl21List);
    }

    /**
     * Removes a single row in the DecisionL21 table.
     *
     * @param decisionl21 Pagination
     * @return
     */
    public void remove(DecisionL21 decisionl21) {
		String query = "DELETE FROM DECISION_L21 WHERE TTDCODIGO=?";
		this.jdbcTemplate.update(query, decisionl21.getTtdcodigo());
    }
    
   /**
    * Finds a List of rows in the DecisionL21 table.
    * 
    * @param decisionl21 DecisionL21
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<DecisionL21> findAll(DecisionL21 decisionl21, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.TTDCODIGO TTDCODIGO,t1.TTDNOMBRE TTDNOMBRE,t1.TTDNOMBREE TTDNOMBREE,t1.TTDNOMBREI TTDNOMBREI,t1.TTDNOMBREF TTDNOMBREF,t1.TTDNOMBREA TTDNOMBREA,t1.TTDCOE9 TTDCOE9 "); 
		query.append("FROM DECISION_L21 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(decisionl21); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<DecisionL21>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the DecisionL21 table.
     * 
     * @param decisionl21 DecisionL21
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(DecisionL21 decisionl21) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM DECISION_L21 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(decisionl21); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the DecisionL21 table using like.
     * 
     * @param decisionl21 DecisionL21
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<DecisionL21> findAllLike(DecisionL21 decisionl21, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.TTDCODIGO TTDCODIGO,t1.TTDNOMBRE TTDNOMBRE,t1.TTDNOMBREE TTDNOMBREE,t1.TTDNOMBREI TTDNOMBREI,t1.TTDNOMBREF TTDNOMBREF,t1.TTDNOMBREA TTDNOMBREA,t1.TTDCOE9 TTDCOE9 "); 
        query.append("FROM DECISION_L21 t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(decisionl21,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<DecisionL21>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the DecisionL21 table using like.
     * 
     * @param decisionl21 DecisionL21
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(DecisionL21 decisionl21, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM DECISION_L21 t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(decisionl21,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the DecisionL21 entity 
	 * 
	 * @param decisionl21 DecisionL21
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (DecisionL21 decisionl21){
		
		StringBuilder where = new StringBuilder(DecisionL21DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (decisionl21  != null  && decisionl21.getTtdcodigo() != null ) {
			where.append(" AND t1.TTDCODIGO = ?");
			params.add(decisionl21.getTtdcodigo());
		}
		if (decisionl21  != null  && decisionl21.getTtdnombre() != null ) {
			where.append(" AND t1.TTDNOMBRE = ?");
			params.add(decisionl21.getTtdnombre());
		}
		if (decisionl21  != null  && decisionl21.getTtdnombree() != null ) {
			where.append(" AND t1.TTDNOMBREE = ?");
			params.add(decisionl21.getTtdnombree());
		}
		if (decisionl21  != null  && decisionl21.getTtdnombrei() != null ) {
			where.append(" AND t1.TTDNOMBREI = ?");
			params.add(decisionl21.getTtdnombrei());
		}
		if (decisionl21  != null  && decisionl21.getTtdnombref() != null ) {
			where.append(" AND t1.TTDNOMBREF = ?");
			params.add(decisionl21.getTtdnombref());
		}
		if (decisionl21  != null  && decisionl21.getTtdnombrea() != null ) {
			where.append(" AND t1.TTDNOMBREA = ?");
			params.add(decisionl21.getTtdnombrea());
		}
		if (decisionl21  != null  && decisionl21.getTtdcoe9() != null ) {
			where.append(" AND t1.TTDCOE9 = ?");
			params.add(decisionl21.getTtdcoe9());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the DecisionL21 entity 
	 * 
	 * @param decisionl21 DecisionL21
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (DecisionL21 decisionl21, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(DecisionL21DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (decisionl21  != null  && decisionl21.getTtdcodigo() != null ) {
			where.append(" AND UPPER(t1.TTDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(decisionl21.getTtdcodigo().toUpperCase() +"%");
			}else{
				params.add("%"+decisionl21.getTtdcodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.TTDCODIGO IS NOT NULL");
	     }			
		if (decisionl21  != null  && decisionl21.getTtdnombre() != null ) {
			where.append(" AND UPPER(t1.TTDNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(decisionl21.getTtdnombre().toUpperCase() +"%");
			}else{
				params.add("%"+decisionl21.getTtdnombre().toUpperCase() +"%");
			}
			where.append(" AND t1.TTDNOMBRE IS NOT NULL");
	     }			
		if (decisionl21  != null  && decisionl21.getTtdnombree() != null ) {
			where.append(" AND UPPER(t1.TTDNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(decisionl21.getTtdnombree().toUpperCase() +"%");
			}else{
				params.add("%"+decisionl21.getTtdnombree().toUpperCase() +"%");
			}
			where.append(" AND t1.TTDNOMBREE IS NOT NULL");
	     }			
		if (decisionl21  != null  && decisionl21.getTtdnombrei() != null ) {
			where.append(" AND UPPER(t1.TTDNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(decisionl21.getTtdnombrei().toUpperCase() +"%");
			}else{
				params.add("%"+decisionl21.getTtdnombrei().toUpperCase() +"%");
			}
			where.append(" AND t1.TTDNOMBREI IS NOT NULL");
	     }			
		if (decisionl21  != null  && decisionl21.getTtdnombref() != null ) {
			where.append(" AND UPPER(t1.TTDNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(decisionl21.getTtdnombref().toUpperCase() +"%");
			}else{
				params.add("%"+decisionl21.getTtdnombref().toUpperCase() +"%");
			}
			where.append(" AND t1.TTDNOMBREF IS NOT NULL");
	     }			
		if (decisionl21  != null  && decisionl21.getTtdnombrea() != null ) {
			where.append(" AND UPPER(t1.TTDNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(decisionl21.getTtdnombrea().toUpperCase() +"%");
			}else{
				params.add("%"+decisionl21.getTtdnombrea().toUpperCase() +"%");
			}
			where.append(" AND t1.TTDNOMBREA IS NOT NULL");
	     }			
		if (decisionl21  != null  && decisionl21.getTtdcoe9() != null ) {
			where.append(" AND UPPER(t1.TTDCOE9) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(decisionl21.getTtdcoe9().toUpperCase() +"%");
			}else{
				params.add("%"+decisionl21.getTtdcoe9().toUpperCase() +"%");
			}
			where.append(" AND t1.TTDCOE9 IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

