package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Decision;
import com.ejie.y41b.model.DecisionHecho;
import com.ejie.y41b.model.DecisionHechoDetalle;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.PlantillaTramiteDecisionDetalle;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.TipoReclamacion;

/**
 * * DecisionHechoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DecisionHechoDaoImpl implements DecisionHechoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<DecisionHecho> rwMap = new RowMapper<DecisionHecho>() {
		public DecisionHecho mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DecisionHecho(resultSet.getString("HCCODIGO"), resultSet.getString("HCCOOR"),
					resultSet.getDate("HCFEDE"), resultSet.getDate("HCFECODE"), resultSet.getString("HCCOORPROP"),
					new HechoDenunciado(resultSet.getString("HechoDenunciadoHDCODIGO"),
							resultSet.getLong("HechoDenunciadoHDNROR"), resultSet.getString("HechoDenunciadoHDTE"),
							resultSet.getString("HechoDenunciadoHDTEDOAD"),
							resultSet.getString("HechoDenunciadoHDCOAV"), resultSet.getString("HechoDenunciadoHDNOPS"),
							resultSet.getString("HechoDenunciadoHDNOMAPS"),
							resultSet.getString("HechoDenunciadoHDNOMOPS"),
							resultSet.getString("HechoDenunciadoHDNRLOPS"),
							resultSet.getString("HechoDenunciadoHDCODIGOBARRAS"),
							resultSet.getDate("HechoDenunciadoHDFEDMPS"),
							resultSet.getString("HechoDenunciadoHDINSOTR"),
							resultSet.getString("HechoDenunciadoHDINSOMA"),
							resultSet.getBigDecimal("HechoDenunciadoHDCAPTSO"),
							resultSet.getString("HechoDenunciadoHDTESO"), resultSet.getDate("HechoDenunciadoHDFEARDT"),
							resultSet.getDate("HechoDenunciadoHDFEIOHD"),
							resultSet.getString("HechoDenunciadoHDINININ"),
							resultSet.getDate("HechoDenunciadoHDFEIOPC"), resultSet.getDate("HechoDenunciadoHDFEROPC"),
							resultSet.getString("HechoDenunciadoHDCOREPC"),
							resultSet.getDate("HechoDenunciadoHDFEIORP"), resultSet.getDate("HechoDenunciadoHDFERORP"),
							resultSet.getString("HechoDenunciadoHDCOREAP"),
							resultSet.getDate("HechoDenunciadoHDFEIORA"),
							resultSet.getString("HechoDenunciadoHDTEACPA"),
							resultSet.getDate("HechoDenunciadoHDFECEAC"),
							resultSet.getString("HechoDenunciadoHDHOCEAC"),
							resultSet.getDate("HechoDenunciadoHDFEIOCA"),
							resultSet.getString("HechoDenunciadoHDTEACDE"),
							resultSet.getDate("HechoDenunciadoHDFEIOAC"), resultSet.getDate("HechoDenunciadoHDFEIOFC"),
							resultSet.getString("HechoDenunciadoHDCOTRA"), resultSet.getString("HechoDenunciadoHDTE02"),
							resultSet.getString("HechoDenunciadoHDTE03"), resultSet.getString("HechoDenunciadoHDTE04"),
							resultSet.getString("HechoDenunciadoHDTE05"), resultSet.getString("HechoDenunciadoHDTE06"),
							resultSet.getString("HechoDenunciadoHDTE07"), resultSet.getString("HechoDenunciadoHDTE08"),
							resultSet.getString("HechoDenunciadoHDTE09"), resultSet.getString("HechoDenunciadoHDTE10"),
							resultSet.getString("HechoDenunciadoHDCOSC"), resultSet.getString("HechoDenunciadoHDIDAL"),
							resultSet.getDate("HechoDenunciadoHDFEROAD"), resultSet.getDate("HechoDenunciadoHDFEROAT"),
							resultSet.getString("HechoDenunciadoHDTEALDT"),
							resultSet.getString("HechoDenunciadoHDTEDEAT"),
							resultSet.getDate("HechoDenunciadoHDFEDEAT"), resultSet.getDate("HechoDenunciadoHDFEHD"),
							resultSet.getString("HechoDenunciadoHDTEDOADE"),
							resultSet.getString("HechoDenunciadoHDTEDOADI"),
							resultSet.getString("HechoDenunciadoHDTEDOADF"),
							resultSet.getString("HechoDenunciadoHDTEDOADA"),
							resultSet.getString("HechoDenunciadoHDNOPSE"),
							resultSet.getString("HechoDenunciadoHDNOPSI"),
							resultSet.getString("HechoDenunciadoHDNOPSF"),
							resultSet.getString("HechoDenunciadoHDNOPSA"),
							resultSet.getString("HechoDenunciadoHDCOCODIGO"), null, null, null, null, null, null, null,
							resultSet.getString("HechoDenunciadoHDINTERESADO"),
							new Denuncia(resultSet.getString("HechoDenunciadoHDCODE"), null, null, null, null, null,
									null, null, null, null, null, null, null, null),
							new Establecimiento(resultSet.getString("HechoDenunciadoHDCOES"), null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null),
							new Sector(resultSet.getString("HechoDenunciadoHDCOSE"), null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null),
							new CensoMonitor(resultSet.getString("HechoDenunciadoHDCOMO"), null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null),
							new Producto(resultSet.getString("HechoDenunciadoHDCOPS"), null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null),
							new TipoReclamacion(resultSet.getString("HechoDenunciadoHDCOTSR"), null, null, null, null,
									null, null),
							new Motivo(resultSet.getString("HechoDenunciadoHDCOTIR"), null, null)),
					new Decision(resultSet.getString("DecisionDECODIGO"), resultSet.getString("DecisionDENOMBRE"),
							resultSet.getString("DecisionDENOMBREE"), null, resultSet.getDate("DecisionDEBAJA"),
							resultSet.getString("DecisionPCODIGO"), null));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	public DecisionHecho add(DecisionHecho decisionhecho) {

		String query = "INSERT INTO DECISION_HECHO( HCCODIGO,HCCOHD,HCCOTTD,HCCOOR,HCFEDE,HCFECODE,HCCOORPROP)"
				+ "VALUES (?,?,?,?,?,?,?)";

		Object getHechoDenunciadoHdcodigoAux = null;
		if (decisionhecho.getHechoDenunciado() != null && decisionhecho.getHechoDenunciado().getHdcodigo() != null) {
			getHechoDenunciadoHdcodigoAux = decisionhecho.getHechoDenunciado().getHdcodigo();
		}
		Object getDecisionDecodigoAux = null;
		if (decisionhecho.getDecision() != null && decisionhecho.getDecision().getDecodigo() != null) {
			getDecisionDecodigoAux = decisionhecho.getDecision().getDecodigo();
		}
		this.jdbcTemplate.update(query, decisionhecho.getHccodigo(), getHechoDenunciadoHdcodigoAux,
				getDecisionDecodigoAux, decisionhecho.getHccoor(), decisionhecho.getHcfede(),
				decisionhecho.getHcfecode(), decisionhecho.getHccoorprop());
		return decisionhecho;
	}

	/**
	 * Updates a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	public DecisionHecho update(DecisionHecho decisionhecho) {
		String query = "UPDATE DECISION_HECHO SET HCCOHD=?,HCCOTTD=?,HCCOOR=?,HCFEDE=?,HCFECODE=?,HCCOORPROP=? WHERE HCCODIGO=?";
		Object getHechoDenunciadoHdcodigoAux = null;
		if (decisionhecho.getHechoDenunciado() != null && decisionhecho.getHechoDenunciado().getHdcodigo() != null) {
			getHechoDenunciadoHdcodigoAux = decisionhecho.getHechoDenunciado().getHdcodigo();
		}
		Object getDecisionDecodigoAux = null;
		if (decisionhecho.getDecision() != null && decisionhecho.getDecision().getDecodigo() != null) {
			getDecisionDecodigoAux = decisionhecho.getDecision().getDecodigo();
		}
		this.jdbcTemplate.update(query, getHechoDenunciadoHdcodigoAux, getDecisionDecodigoAux,
				decisionhecho.getHccoor(), decisionhecho.getHcfede(), decisionhecho.getHcfecode(),
				decisionhecho.getHccoorprop(), decisionhecho.getHccodigo());
		return decisionhecho;
	}

	/**
	 * Updates a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	public DecisionHecho updateDecision(DecisionHecho decisionhecho) {
		String query = "UPDATE DECISION_HECHO SET HCCOTTD=?, HCFEDE=? WHERE HCCODIGO=?";
		Object getDecisionDecodigoAux = null;
		if (decisionhecho.getDecision() != null && decisionhecho.getDecision().getDecodigo() != null) {
			getDecisionDecodigoAux = decisionhecho.getDecision().getDecodigo();
		}
		this.jdbcTemplate.update(query, getDecisionDecodigoAux, decisionhecho.getHcfede(), decisionhecho.getHccodigo());
		return decisionhecho;
	}

	/**
	 * Updates a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	public DecisionHecho updateOrganismoTraslado(DecisionHecho decisionhecho) {
		String query = "UPDATE DECISION_HECHO SET HCCOOR=? WHERE HCCODIGO=?";
		this.jdbcTemplate.update(query, decisionhecho.getHccoor(), decisionhecho.getHccodigo());
		return decisionhecho;
	}

	/**
	 * Finds a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	@Transactional(readOnly = true)
	public DecisionHecho find(DecisionHecho decisionhecho) {
		String query = "SELECT t1.HCCODIGO HCCODIGO, t1.HCCOOR HCCOOR, t1.HCFEDE HCFEDE, t1.HCFECODE HCFECODE, t1.HCCOORPROP HCCOORPROP, t2.HDCODIGO HECHODENUNCIADOHDCODIGO, t2.HDNROR HECHODENUNCIADOHDNROR, t2.HDTE HECHODENUNCIADOHDTE, t2.HDTEDOAD HECHODENUNCIADOHDTEDOAD, t2.HDCOAV HECHODENUNCIADOHDCOAV, t2.HDNOPS HECHODENUNCIADOHDNOPS, t2.HDNOMAPS HECHODENUNCIADOHDNOMAPS, t2.HDNOMOPS HECHODENUNCIADOHDNOMOPS, t2.HDNRLOPS HECHODENUNCIADOHDNRLOPS, t2.HDCODIGOBARRAS HECHODENUNCIADOHDCODIGOBARRAS, t2.HDINTERESADO HECHODENUNCIADOHDINTERESADO, t2.HDFEDMPS HECHODENUNCIADOHDFEDMPS, t2.HDINSOTR HECHODENUNCIADOHDINSOTR, t2.HDINSOMA HECHODENUNCIADOHDINSOMA, t2.HDCAPTSO HECHODENUNCIADOHDCAPTSO, t2.HDTESO HECHODENUNCIADOHDTESO, t2.HDFEARDT HECHODENUNCIADOHDFEARDT, t2.HDFEIOHD HECHODENUNCIADOHDFEIOHD, t2.HDINININ HECHODENUNCIADOHDINININ, t2.HDFEIOPC HECHODENUNCIADOHDFEIOPC, t2.HDFEROPC HECHODENUNCIADOHDFEROPC, t2.HDCOREPC HECHODENUNCIADOHDCOREPC, t2.HDFEIORP HECHODENUNCIADOHDFEIORP, t2.HDFERORP HECHODENUNCIADOHDFERORP, t2.HDCOREAP HECHODENUNCIADOHDCOREAP, t2.HDFEIORA HECHODENUNCIADOHDFEIORA, t2.HDTEACPA HECHODENUNCIADOHDTEACPA, t2.HDFECEAC HECHODENUNCIADOHDFECEAC, t2.HDHOCEAC HECHODENUNCIADOHDHOCEAC, t2.HDFEIOCA HECHODENUNCIADOHDFEIOCA, t2.HDTEACDE HECHODENUNCIADOHDTEACDE, t2.HDFEIOAC HECHODENUNCIADOHDFEIOAC, t2.HDFEIOFC HECHODENUNCIADOHDFEIOFC, t2.HDCOTRA HECHODENUNCIADOHDCOTRA, t2.HDTE02 HECHODENUNCIADOHDTE02, t2.HDTE03 HECHODENUNCIADOHDTE03, t2.HDTE04 HECHODENUNCIADOHDTE04, t2.HDTE05 HECHODENUNCIADOHDTE05, t2.HDTE06 HECHODENUNCIADOHDTE06, t2.HDTE07 HECHODENUNCIADOHDTE07, t2.HDTE08 HECHODENUNCIADOHDTE08, t2.HDTE09 HECHODENUNCIADOHDTE09, t2.HDTE10 HECHODENUNCIADOHDTE10, t2.HDCOSC HECHODENUNCIADOHDCOSC, t2.HDIDAL HECHODENUNCIADOHDIDAL, t2.HDFEROAD HECHODENUNCIADOHDFEROAD, t2.HDFEROAT HECHODENUNCIADOHDFEROAT, t2.HDTEALDT HECHODENUNCIADOHDTEALDT, t2.HDTEDEAT HECHODENUNCIADOHDTEDEAT, t2.HDFEDEAT HECHODENUNCIADOHDFEDEAT, t2.HDFEHD HECHODENUNCIADOHDFEHD, t2.HDTEDOADE HECHODENUNCIADOHDTEDOADE, t2.HDTEDOADI HECHODENUNCIADOHDTEDOADI, t2.HDTEDOADF HECHODENUNCIADOHDTEDOADF, t2.HDTEDOADA HECHODENUNCIADOHDTEDOADA, t2.HDNOPSE HECHODENUNCIADOHDNOPSE, t2.HDNOPSI HECHODENUNCIADOHDNOPSI, t2.HDNOPSF HECHODENUNCIADOHDNOPSF, t2.HDNOPSA HECHODENUNCIADOHDNOPSA, t2.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO, t3.DECODIGO DECISIONDECODIGO, t3.DENOMBRE DECISIONDENOMBRE, t3.DENOMBREE DECISIONDENOMBREE, t3.DEBAJA DECISIONDEBAJA, t3.PCODIGO DECISIONPCODIGO, t2.HDCODE HECHODENUNCIADOHDCODE, t2.HDCOES HECHODENUNCIADOHDCOES, t2.HDCOSE HECHODENUNCIADOHDCOSE, t2.HDCOMO HECHODENUNCIADOHDCOMO, t2.HDCOPS HECHODENUNCIADOHDCOPS, t2.HDCOTSR HECHODENUNCIADOHDCOTSR, t2.HDCOTIR HECHODENUNCIADOHDCOTIR "
				+ "FROM DECISION_HECHO t1 , HECHO_DENUNCIADO t2 , DECISION t3  "
				+ "WHERE t1.HCCODIGO = ?   AND t1.HCCOHD= t2.HDCODIGO(+) AND t1.HCCOTTD= t3.DECODIGO(+)  ";
		return (DecisionHecho) this.jdbcTemplate.queryForObject(query, rwMap, decisionhecho.getHccodigo());
	}

	/**
	 * Finds a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	@Transactional(readOnly = true)
	public DecisionHechoDetalle findDecisionHecho(DecisionHechoDetalle decisionHechoDetalle) {
		String query = "SELECT t1.HCCODIGO HCCODIGO, t1.HCCOOR HCCOOR, t1.HCFEDE HCFEDE, t1.HCFECODE HCFECODE, t1.HCCOORPROP HCCOORPROP, t2.HDCODIGO HDCODIGO, t3.DECODIGO DECODIGO, t3.DENOMBRE DENOMBRE, t3.DENOMBREE DENOMBREE, t3.DEBAJA DEBAJA "
				+ "FROM DECISION_HECHO t1 , HECHO_DENUNCIADO t2 , DECISION t3 "
				+ "WHERE t1.HCCOHD = ? AND t1.HCCOHD= t2.HDCODIGO(+) AND t1.HCCOTTD= t3.DECODIGO(+) ";
		return (DecisionHechoDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<DecisionHechoDetalle>() {
			public DecisionHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new DecisionHechoDetalle(resultSet.getString("HCCODIGO"), resultSet.getString("HCCOOR"),
						resultSet.getDate("HCFEDE"), resultSet.getDate("HCFECODE"), resultSet.getString("HCCOORPROP"),
						resultSet.getString("HDCODIGO"), resultSet.getString("DECODIGO"),
						resultSet.getString("DENOMBRE"), resultSet.getString("DENOMBREE"), resultSet.getDate("DEBAJA"),
						null, null, null, null, null, null, null, null, null, null, null);
			}
		}, decisionHechoDetalle.getHdcodigo());
	}

	/**
	 * Finds a single row in the DecisionHecho table.
	 * 
	 * @param plantillaTramiteDecisionDetalle
	 *            PlantillaTramiteDecisionDetalle
	 * @return PlantillaTramiteDecisionDetalle
	 */
	@Transactional(readOnly = true)
	public PlantillaTramiteDecisionDetalle findPlantillaTramiteDecision(
			PlantillaTramiteDecisionDetalle plantillaTramiteDecisionDetalle) {

		String query = "SELECT t1.DECODIGO DECODIGO, t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE, t2.HDCODIGO HDCODIGO, t2.HDNROR HDNROR, "
				+ "t3.ESCODIGO ESCODIGO, t3.NOMBRE ESNOMBRE, t3.NIF ESNIF, t3.ESNOCO ESNOCO, t3.INADAR ESINADAR, t3.NORA_PROVINCIA_ID ESNORAPROVINCIAID, "
				+ "t3.NOMBRE_PROVINCIA ESNOMBREPROVINCIA, t3.NORA_MUNICIPIO_ID ESNORAMUNICIPIOID, t3.NOMBRE_MUNICIPIO ESNOMBREMUNICIPIO, t3.NORA_LOCALIDAD_ID ESNORALOCALIDADID, "
				+ "t3.NOMBRE_LOCALIDAD ESNOMBRELOCALIDAD, t3.NORA_CALLE_ID ESNORACALLEID, t3.NOMBRE_CALLE ESNOMBRECALLE, t3.NORA_CP_ID ESNORACPID, t3.NOMBRE_CP ESNOMBRECP, "
				+ "t3.NORA_PORTAL_ID ESNORAPORTALID, t3.NOMBRE_PORTAL ESNOMBREPORTAL, t3.NOMBRE_PISO ESNOMBREPISO, '' ESNOLO, '' ESNODIR, '' ESNRCOPO, t3.DIRECCION_NOCAPV ESDIRECCION_NOCAPV, "
				+ "t3.NORA_PAIS_ID ESNORAPAISID, t3.NOMBRE_PAIS ESNOMBRE_PAIS, "
				+ "t4.DTCODIGO DTCODIGO, t4.NOMBRE || ' ' || NVL(t4.APELLIDO1,'') || ' ' || NVL(t4.APELLIDO2,'') DTNOMBRE, t4.NIF DTNIF, t4.NORA_PROVINCIA_ID DTNORAPROVINCIAID, "
				+ "t4.NOMBRE_PROVINCIA DTNOMBREPROVINCIA, t4.NORA_MUNICIPIO_ID DTNORAMUNICIPIOID, t4.NOMBRE_MUNICIPIO DTNOMBREMUNICIPIO, "
				+ "t4.NORA_LOCALIDAD_ID DTNORALOCALIDADID, t4.NOMBRE_LOCALIDAD DTNOMBRELOCALIDAD, t4.NORA_CALLE_ID DTNORACALLEID, t4.NOMBRE_CALLE DTNOMBRECALLE, "
				+ "t4.NORA_CP_ID DTNORACPID, t4.NOMBRE_CP DTNOMBRECP, t4.NORA_PORTAL_ID DTNORAPORTALID, t4.NOMBRE_PORTAL DTNOMBREPORTAL, t4.NOMBRE_PISO DTNOMBREPISO, '' DTNOLO, '' DTNODIR, '' DTNRCOPO, t4.DIRECCION_NOCAPV DTDIRECCION_NOCAPV, "
				+ "t4.NORA_PAIS_ID DTNORAPAISID, t4.NOMBRE_PAIS DTNOMBRE_PAIS, "
				+ "t6.COD_ORG CODORG, t6.NOMBRE_ES NOMBREES, t6.NOMBRE_EU NOMBREEU,  t6.NORA_PROVINCIA_ID NORAPROVINCIAID, t6.NOMBRE_PROVINCIA NOMBREPROVINCIA, t6.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t6.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, "
				+ "t6.NORA_LOCALIDAD_ID NORALOCALIDADID, t6.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t6.NORA_CALLE_ID NORACALLEID, t6.NOMBRE_CALLE NOMBRECALLE, t6.NORA_CP_ID NORACPID, t6.NOMBRE_CP NOMBRECP, t6.NORA_PORTAL_ID NORAPORTALID, "
				+ "t6.NOMBRE_PORTAL NOMBREPORTAL,t6.TELEFONO TELEFONOORGANISMO, t6.FAX FAXORGANISMO, t6.EMAIL EMAILORGANISMO, t6.URL WEBORGANISMO, t5.HCCODIGO HCCODIGO, t5.HCFEDE HCFEDE, t8.COD_ORG CODORGTRASPASO, "
				+ "t8.NOMBRE_ES NOMBREESTRASPASO, t8.NOMBRE_EU NOMBREEUTRASPASO,  t8.NORA_PROVINCIA_ID NORAPROVINCIAIDTRASPASO, t8.NOMBRE_PROVINCIA NOMBREPROVINCIATRASPASO, t8.NORA_MUNICIPIO_ID NORAMUNICIPIOIDTRASPASO, "
				+ "t8.NOMBRE_MUNICIPIO NOMBREMUNICIPIOTRASPASO, t8.NORA_LOCALIDAD_ID NORALOCALIDADIDTRASPASO, t8.NOMBRE_LOCALIDAD NOMBRELOCALIDADTRASPASO, t8.NORA_CALLE_ID NORACALLEIDTRASPASO, t8.NOMBRE_CALLE NOMBRECALLETRASPASO, "
				+ "t8.NORA_CP_ID NORACPIDTRASPASO, t8.NOMBRE_CP NOMBRECPTRASPASO, t8.NORA_PORTAL_ID NORAPORTALIDTRASPASO, t8.NOMBRE_PORTAL NOMBREPORTALTRASPASO, t7.EHFECHARESOLUCION EHFECHARESOLUCION, t9.MONOMBRE NBMONITOR, "
				+ "t10.PSNOMBRE PSNOMBRE, t10.PSNOMBREE PSNOMBREE, t2.HDNOMAPS HDNOMAPS, t2.HDNOMOPS HDNOMOPS, t2.HDNRLOPS HDNRLOPS, t2.HDCODIGOBARRAS HDCODIGOBARRAS "
				+ "FROM DENUNCIA t1 ,HECHO_DENUNCIADO t2,INTERVINIENTES t3, INTERVINIENTES t4, DECISION_HECHO t5, ORGANISMO t6,TRAMITE_HECHO t7, ORGANISMO t8, CENSO_MONITOR t9, PRODUCTO t10 "
				+ "WHERE 1=1 AND t1.DECODIGO= t2.HDCODE(+)  AND t2.HDCODIGO= t3.HDCODIGO(+) AND t3.TIPO_INTERVINIENTE(+)='D' AND t2.HDCODIGO= t4.HDCODIGO(+) AND t4.TIPO_INTERVINIENTE(+)='I' AND t2.HDCODIGO = t5.HCCOHD(+) AND t5.HCCOOR= t6.COD_ORG(+) AND t2.HDCODIGO = t7.EHCOHD(+) AND t7.EHCOORTRASPASO = t8.COD_ORG(+) AND t5.HCCODIGO = ? "
				+ "AND t7.EHCODIGO IN (SELECT tr1.EHCODIGO EHCODIGO FROM TRAMITE_HECHO tr1 WHERE EHFECHA = (SELECT MAX(EHFECHA) FROM TRAMITE_HECHO tr2 WHERE tr2.EHCOHD=t2.HDCODIGO ) AND NVL(EHHORA, 0) = (SELECT NVL(MAX(EHHORA), 0) FROM TRAMITE_HECHO tr3 WHERE tr1.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD=t2.HDCODIGO)) AND t2.HDCOMO = t9.MOCODIGO(+) AND t2.HDCOPS = t10.PSCODIGO(+) ";

		return (PlantillaTramiteDecisionDetalle) this.jdbcTemplate.queryForObject(query,
				new RowMapper<PlantillaTramiteDecisionDetalle>() {
					public PlantillaTramiteDecisionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {

						return new PlantillaTramiteDecisionDetalle(resultSet.getString("DECODIGO"),
								resultSet.getString("DECOOR"), resultSet.getBigDecimal("DENRAN"),
								resultSet.getBigDecimal("DENROR"), resultSet.getDate("DEFEDE"),
								resultSet.getString("HDCODIGO"), resultSet.getBigDecimal("HDNROR"),
								resultSet.getString("DTCODIGO"), resultSet.getString("DTNOMBRE"),
								resultSet.getString("DTNIF"), resultSet.getString("DTNORAPROVINCIAID"),
								resultSet.getString("DTNOMBREPROVINCIA"), resultSet.getString("DTNORAMUNICIPIOID"),
								resultSet.getString("DTNOMBREMUNICIPIO"), resultSet.getString("DTNORALOCALIDADID"),
								resultSet.getString("DTNOMBRELOCALIDAD"), resultSet.getString("DTNORACALLEID"),
								resultSet.getString("DTNOMBRECALLE"), resultSet.getString("DTNORACPID"),
								resultSet.getString("DTNOMBRECP"), resultSet.getString("DTNORAPORTALID"),
								resultSet.getString("DTNOMBREPORTAL"), resultSet.getString("DTNOMBREPISO"),
								resultSet.getString("DTNOLO"), resultSet.getString("DTNODIR"),
								resultSet.getString("DTNRCOPO"), resultSet.getString("DTDIRECCION_NOCAPV"),
								resultSet.getString("DTNORAPAISID"), resultSet.getString("DTNOMBRE_PAIS"),
								resultSet.getString("ESCODIGO"), resultSet.getString("ESNOMBRE"),
								resultSet.getString("ESNIF"), resultSet.getString("ESNOCO"),
								resultSet.getString("ESINADAR"), resultSet.getString("ESNORAPROVINCIAID"),
								resultSet.getString("ESNOMBREPROVINCIA"), resultSet.getString("ESNORAMUNICIPIOID"),
								resultSet.getString("ESNOMBREMUNICIPIO"), resultSet.getString("ESNORALOCALIDADID"),
								resultSet.getString("ESNOMBRELOCALIDAD"), resultSet.getString("ESNORACALLEID"),
								resultSet.getString("ESNOMBRECALLE"), resultSet.getString("ESNORACPID"),
								resultSet.getString("ESNOMBRECP"), resultSet.getString("ESNORAPORTALID"),
								resultSet.getString("ESNOMBREPORTAL"), resultSet.getString("ESNOMBREPISO"),
								resultSet.getString("ESNOLO"), resultSet.getString("ESNODIR"),
								resultSet.getString("ESNRCOPO"), resultSet.getString("ESDIRECCION_NOCAPV"),
								resultSet.getString("ESNORAPAISID"), resultSet.getString("ESNOMBRE_PAIS"),
								resultSet.getString("CODORG"), resultSet.getString("NOMBREES"),
								resultSet.getString("NOMBREEU"), resultSet.getString("NORAPROVINCIAID"),
								resultSet.getString("NOMBREPROVINCIA"), resultSet.getString("NORAMUNICIPIOID"),
								resultSet.getString("NOMBREMUNICIPIO"), resultSet.getString("NORALOCALIDADID"),
								resultSet.getString("NOMBRELOCALIDAD"), resultSet.getString("NORACALLEID"),
								resultSet.getString("NOMBRECALLE"), resultSet.getString("NORACPID"),
								resultSet.getString("NOMBRECP"), resultSet.getString("NORAPORTALID"),
								resultSet.getString("NOMBREPORTAL"),

								resultSet.getString("TELEFONOORGANISMO"), resultSet.getString("FAXORGANISMO"),
								resultSet.getString("EMAILORGANISMO"), resultSet.getString("WEBORGANISMO"),

								resultSet.getString("HCCODIGO"), resultSet.getDate("HCFEDE"),
								resultSet.getString("CODORGTRASPASO"), resultSet.getString("NOMBREESTRASPASO"),
								resultSet.getString("NOMBREEUTRASPASO"), resultSet.getString("NORAPROVINCIAIDTRASPASO"),
								resultSet.getString("NOMBREPROVINCIATRASPASO"),
								resultSet.getString("NORAMUNICIPIOIDTRASPASO"),
								resultSet.getString("NOMBREMUNICIPIOTRASPASO"),
								resultSet.getString("NORALOCALIDADIDTRASPASO"),
								resultSet.getString("NOMBRELOCALIDADTRASPASO"),
								resultSet.getString("NORACALLEIDTRASPASO"), resultSet.getString("NOMBRECALLETRASPASO"),
								resultSet.getString("NORACPIDTRASPASO"), resultSet.getString("NOMBRECPTRASPASO"),
								resultSet.getString("NORAPORTALIDTRASPASO"),
								resultSet.getString("NOMBREPORTALTRASPASO"), resultSet.getDate("EHFECHARESOLUCION"),
								resultSet.getString("NBMONITOR"), resultSet.getString("PSNOMBRE"),
								resultSet.getString("PSNOMBREE"), resultSet.getString("HDNOMAPS"),
								resultSet.getString("HDNOMOPS"), resultSet.getString("HDNRLOPS"),
								resultSet.getString("HDCODIGOBARRAS"));
					}
				}, plantillaTramiteDecisionDetalle.getHccodigo());
	}

	/**
	 * Removes a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return
	 */
	public void remove(DecisionHecho decisionhecho) {
		String query = "DELETE  FROM DECISION_HECHO WHERE HCCODIGO=?";
		this.jdbcTemplate.update(query, decisionhecho.getHccodigo());
	}

	/**
	 * Removes all decision of the Solicitud.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return
	 */
	public void removeDecisionSolicitud(DecisionHecho decisionhecho) {
		String query = "DELETE  FROM DECISION_HECHO WHERE HCCOHD=?";
		this.jdbcTemplate.update(query, decisionhecho.getHechoDenunciado().getHdcodigo());
	}
}
