package com.ejie.y41b.dao;

import com.ejie.y41b.model.DecisionHecho;
import com.ejie.y41b.model.DecisionHechoDetalle;
import com.ejie.y41b.model.PlantillaTramiteDecisionDetalle;

/**
 * * DecisionHechoDao  
 * 
 *  
 */

public interface DecisionHechoDao {

	/**
	 * Inserts a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            DecisionHecho
	 * @return DecisionHecho
	 */
	DecisionHecho add(DecisionHecho decisionhecho);

	/**
	 * Updates a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            DecisionHecho
	 * @return DecisionHecho
	 */
	DecisionHecho update(DecisionHecho decisionhecho);

	/**
	 * Updates a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	DecisionHecho updateDecision(DecisionHecho decisionhecho);

	/**
	 * Updates a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	DecisionHecho updateOrganismoTraslado(DecisionHecho decisionhecho);

	/**
	 * Finds a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            DecisionHecho
	 * @return DecisionHecho
	 */
	DecisionHecho find(DecisionHecho decisionhecho);

	/**
	 * Finds a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	DecisionHechoDetalle findDecisionHecho(
			DecisionHechoDetalle decisionHechoDetalle);

	/**
	 * Finds a single row in the DecisionHecho table.
	 * 
	 * @param plantillaTramiteDecisionDetalle
	 *            PlantillaTramiteDecisionDetalle
	 * @return PlantillaTramiteDecisionDetalle
	 */
	PlantillaTramiteDecisionDetalle findPlantillaTramiteDecision(
			PlantillaTramiteDecisionDetalle plantillaTramiteDecisionDetalle);

	/**
	 * Deletes a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            DecisionHecho
	 * @return
	 */
	void remove(DecisionHecho decisionhecho);

	/**
	 * Removes all decision of the Solicitud.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return
	 */
	void removeDecisionSolicitud(DecisionHecho decisionhecho);
}
