package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Decision;

/**
 * * DecisionDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DecisionDaoImpl implements DecisionDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Decision> rwMap = new RowMapper<Decision>() {
		public Decision mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Decision(resultSet.getString("DECODIGO"), resultSet.getString("DENOMBRE"),
					resultSet.getString("DENOMBREE"), resultSet.getString("DEMEDIACION"), resultSet.getDate("DEBAJA"),
					resultSet.getString("PCODIGO"), resultSet.getString("DETIPOSOLICITUD"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Decision table.
	 * 
	 * @param decision
	 *            Pagination
	 * @return Decision
	 */
	public Decision add(Decision decision) {

		String query = "INSERT INTO DECISION( DECODIGO,DENOMBRE,DENOMBREE,DEMEDIACION,DEBAJA,PCODIGO,DETIPOSOLICITUD)"
				+ "VALUES (?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, decision.getDecodigo(), decision.getDenombre(), decision.getDenombree(),
				decision.getDemediacion(), decision.getDebaja(), decision.getPcodigo(), decision.getDetiposolicitud());
		return decision;
	}

	/**
	 * Updates a single row in the Decision table.
	 * 
	 * @param decision
	 *            Pagination
	 * @return Decision
	 */
	public Decision update(Decision decision) {
		String query = "UPDATE DECISION SET DENOMBRE=?,DENOMBREE=?,DEMEDIACION=?,DEBAJA=?,PCODIGO=?,DETIPOSOLICITUD=? WHERE DECODIGO=?";
		this.jdbcTemplate.update(query, decision.getDenombre(), decision.getDenombree(), decision.getDemediacion(),
				decision.getDebaja(), decision.getPcodigo(), decision.getDetiposolicitud(), decision.getDecodigo());
		return decision;
	}

	/**
	 * Updates a single row in the Decision table.
	 * 
	 * @param decision
	 *            Pagination
	 * @return Decision
	 */
	public Decision updateFecha(Decision decision) {
		String query = "UPDATE DECISION SET DEBAJA=? WHERE DECODIGO=?";
		this.jdbcTemplate.update(query, decision.getDebaja(), decision.getDecodigo());
		return decision;
	}

	/**
	 * Finds a single row in the Decision table.
	 * 
	 * @param decision
	 *            Pagination
	 * @return Decision
	 */
	@Transactional(readOnly = true)
	public Decision find(Decision decision) {
		String query = "SELECT t1.DECODIGO DECODIGO, t1.DENOMBRE DENOMBRE, t1.DENOMBREE DENOMBREE,t1.DEMEDIACION DEMEDIACION, t1.DEBAJA DEBAJA, t1.PCODIGO PCODIGO, t1.DETIPOSOLICITUD DETIPOSOLICITUD "
				+ "FROM DECISION t1  " + "WHERE t1.DECODIGO = ?    ";
		return (Decision) this.jdbcTemplate.queryForObject(query, rwMap, decision.getDecodigo());
	}

	/**
	 * Removes a single row in the Decision table.
	 * 
	 * @param decision
	 *            Pagination
	 * @return
	 */
	public void remove(Decision decision) {
		String query = "DELETE  FROM DECISION WHERE DECODIGO=?";
		this.jdbcTemplate.update(query, decision.getDecodigo());
	}

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Decision> findAll(Decision decision, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.DECODIGO DECODIGO,t1.DENOMBRE DENOMBRE,NVL(t1.DENOMBREE,t1.DENOMBRE) DENOMBREE,t1.DEMEDIACION DEMEDIACION,t1.DEBAJA DEBAJA, t1.PCODIGO PCODIGO, t1.DETIPOSOLICITUD DETIPOSOLICITUD "
						+ "FROM DECISION t1 ");

		if (decision != null && decision.getDecodigo() != null) {
			where.append(" AND t1.DECODIGO = ?");
			params.add(decision.getDecodigo());
		}
		if (decision != null && decision.getDenombre() != null) {
			where.append(" AND t1.DENOMBRE = ?");
			params.add(decision.getDenombre());
		}
		if (decision != null && decision.getDenombree() != null) {
			where.append(" AND t1.DENOMBREE = ?");
			params.add(decision.getDenombree());
		}
		if (decision != null && decision.getDemediacion() != null) {
			where.append(" AND t1.DEMEDIACION = ?");
			params.add(decision.getDemediacion());
		}
		if (decision != null && decision.getDebaja() != null) {
			where.append(" AND t1.DEBAJA = ?");
			params.add(decision.getDebaja());
		}
		if (decision != null && decision.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO = ?");
			params.add(decision.getPcodigo());
		}
		if (decision != null && decision.getDetiposolicitud() != null) {
			where.append(" AND t1.DETIPOSOLICITUD = ?");
			params.add(decision.getDetiposolicitud());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Decision>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Decision> findAllDecisionBusquedaSolicitud(Decision decision, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer(

				"SELECT  t1.DECODIGO DECODIGO,t1.DENOMBRE DENOMBRE,NVL(t1.DENOMBREE,t1.DENOMBRE) DENOMBREE,t1.DEMEDIACION DEMEDIACION,t1.DEBAJA DEBAJA, t1.PCODIGO PCODIGO, t1.DETIPOSOLICITUD DETIPOSOLICITUD "
						+ "FROM DECISION t1 ");

		where.append(" AND t1.PCODIGO = ?");
		params.add(decision.getPcodigo());

		if (decision != null && decision.getDetiposolicitud() != null) {
			where.append(" AND t1.DETIPOSOLICITUD = ?");
			params.add(decision.getDetiposolicitud());
		} else {
			where.append(
					" AND t1.DECODIGO IN ( SELECT MIN(t2.DECODIGO) DECODIGO FROM DECISION t2 WHERE 1=1 AND t2.PCODIGO = ? GROUP BY t2.DENOMBRE) ");
			params.add(decision.getPcodigo());
		}

		// where.append(" WHERE 1=1 AND t1.DECODIGO = t2.DECODIGO(+) ");
		//
		// StringBuffer query = new StringBuffer(
		// "SELECT t1.DECODIGO DECODIGO,t1.DENOMBRE
		// DENOMBRE,NVL(t1.DENOMBREE,t1.DENOMBRE) DENOMBREE,t1.DEMEDIACION
		// DEMEDIACION,t1.DEBAJA DEBAJA, t1.PCODIGO PCODIGO, t1.DETIPOSOLICITUD
		// DETIPOSOLICITUD "
		// +
		// "FROM DECISION t1, (SELECT MIN(t1.DECODIGO) DECODIGO FROM DECISION t1
		// WHERE 1=1 AND t1.PCODIGO = ? GROUP BY t1.DENOMBRE) t2 ");
		//
		// params.add(decision.getPcodigo());
		// where.append(" AND t1.PCODIGO = ?");
		// params.add(decision.getPcodigo());
		//
		// if (decision != null && decision.getDetiposolicitud() != null) {
		// where.append(" AND t1.DETIPOSOLICITUD = ?");
		// params.add(decision.getDetiposolicitud());
		// }

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Decision>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Decision> findAllActivos(Decision decision, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.DECODIGO DECODIGO,t1.DENOMBRE DENOMBRE,NVL(t1.DENOMBREE,t1.DENOMBRE) DENOMBREE,t1.DEMEDIACION DEMEDIACION,t1.DEBAJA DEBAJA, t1.PCODIGO PCODIGO, t1.DETIPOSOLICITUD DETIPOSOLICITUD "
						+ "FROM DECISION t1 ");

		if (decision != null && decision.getDecodigo() != null) {
			where.append(" AND t1.DECODIGO = ?");
			params.add(decision.getDecodigo());
		}
		if (decision != null && decision.getDenombre() != null) {
			where.append(" AND t1.DENOMBRE = ?");
			params.add(decision.getDenombre());
		}
		if (decision != null && decision.getDenombree() != null) {
			where.append(" AND t1.DENOMBREE = ?");
			params.add(decision.getDenombree());
		}
		if (decision != null && decision.getDemediacion() != null) {
			where.append(" AND t1.DEMEDIACION = ?");
			params.add(decision.getDemediacion());
		}

		if (decision != null && decision.getDebaja() != null) {
			where.append(" AND t1.DEBAJA = ?");
			params.add(decision.getDebaja());
		}
		if (decision != null && decision.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO = ?");
			params.add(decision.getPcodigo());
		}
		if (decision != null && decision.getDetiposolicitud() != null) {
			where.append(" AND t1.DETIPOSOLICITUD = ?");
			params.add(decision.getDetiposolicitud());
		}

		where.append(" AND t1.DEBAJA IS NULL");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Decision>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Decision> findAllActivosNoLaudo(Decision decision, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.DECODIGO DECODIGO,t1.DENOMBRE DENOMBRE,NVL(t1.DENOMBREE,t1.DENOMBRE) DENOMBREE,t1.DEMEDIACION DEMEDIACION,t1.DEBAJA DEBAJA, t1.PCODIGO PCODIGO, t1.DETIPOSOLICITUD DETIPOSOLICITUD "
						+ "FROM DECISION t1 ");

		if (decision != null && decision.getDecodigo() != null) {
			where.append(" AND t1.DECODIGO = ?");
			params.add(decision.getDecodigo());
		}

		if (decision != null && decision.getDenombre() != null) {
			where.append(" AND t1.DENOMBRE = ?");
			params.add(decision.getDenombre());
		}
		if (decision != null && decision.getDenombree() != null) {
			where.append(" AND t1.DENOMBREE = ?");
			params.add(decision.getDenombree());
		}
		if (decision != null && decision.getDemediacion() != null) {
			where.append(" AND t1.DEMEDIACION = ?");
			params.add(decision.getDemediacion());
		}

		if (decision != null && decision.getDebaja() != null) {
			where.append(" AND t1.DEBAJA = ?");
			params.add(decision.getDebaja());
		}
		if (decision != null && decision.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO = ?");
			params.add(decision.getPcodigo());
		}
		if (decision != null && decision.getDetiposolicitud() != null) {
			where.append(" AND t1.DETIPOSOLICITUD = ?");
			params.add(decision.getDetiposolicitud());
		}

		where.append(" AND t1.DEBAJA IS NULL");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Decision>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Decision decision) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  DECISION t1  ");
		if (decision != null && decision.getDecodigo() != null) {
			where.append(" AND t1.DECODIGO = ?");
			params.add(decision.getDecodigo());
		}
		if (decision != null && decision.getDenombre() != null) {
			where.append(" AND t1.DENOMBRE = ?");
			params.add(decision.getDenombre());
		}
		if (decision != null && decision.getDenombree() != null) {
			where.append(" AND t1.DENOMBREE = ?");
			params.add(decision.getDenombree());
		}
		if (decision != null && decision.getDemediacion() != null) {
			where.append(" AND t1.DEMEDIACION = ?");
			params.add(decision.getDemediacion());
		}

		if (decision != null && decision.getDebaja() != null) {
			where.append(" AND t1.DEBAJA = ?");
			params.add(decision.getDebaja());
		}
		if (decision != null && decision.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO = ?");
			params.add(decision.getPcodigo());
		}
		if (decision != null && decision.getDetiposolicitud() != null) {
			where.append(" AND t1.DETIPOSOLICITUD = ?");
			params.add(decision.getDetiposolicitud());
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Decision table using like.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Decision> findAllLike(Decision decision, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.DECODIGO DECODIGO,t1.DENOMBRE DENOMBRE,NVL(t1.DENOMBREE,t1.DENOMBRE) DENOMBREE,t1.DEMEDIACION DEMEDIACION,t1.DEBAJA DEBAJA,t1.PCODIGO PCODIGO, t1.DETIPOSOLICITUD DETIPOSOLICITUD "
						+ "FROM DECISION t1 ");

		if (decision != null && decision.getDecodigo() != null) {
			where.append(" AND UPPER(t1.DECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.DECODIGO IS NOT NULL");
		}
		if (decision != null && decision.getDenombre() != null) {
			where.append(" AND UPPER(t1.DENOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDenombre().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDenombre().toUpperCase() + "%");
			}
			where.append(" AND t1.DENOMBRE IS NOT NULL");
		}
		if (decision != null && decision.getDenombree() != null) {
			where.append(" AND UPPER(t1.DENOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDenombree().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDenombree().toUpperCase() + "%");
			}
			where.append(" AND t1.DENOMBREE IS NOT NULL");
		}

		if (decision != null && decision.getDemediacion() != null) {
			where.append(" AND UPPER(t1.DEMEDIACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDemediacion().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDemediacion().toUpperCase() + "%");
			}
			where.append(" AND t1.DEMEDIACION IS NOT NULL");
		}

		if (decision != null && decision.getDebaja() != null) {
			where.append(" AND t1.DEBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDebaja() + "%");
			} else {
				params.add("%" + decision.getDebaja() + "%");
			}
			where.append(" AND t1.DEBAJA IS NOT NULL");
		}
		if (decision != null && decision.getPcodigo() != null) {
			where.append(" AND UPPER(t1.PCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getPcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getPcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PCODIGO IS NOT NULL");
		}
		if (decision != null && decision.getDetiposolicitud() != null) {
			where.append(" AND UPPER(t1.DETIPOSOLICITUD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDetiposolicitud().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDetiposolicitud().toUpperCase() + "%");
			}
			where.append(" AND t1.DETIPOSOLICITUD IS NOT NULL");
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Decision>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Decision table using like.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Decision> findAllLikeDecision(Decision decision, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PCODIGO= t2.PCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.DECODIGO DECODIGO,t1.DENOMBRE DENOMBRE,NVL(t1.DENOMBREE,t1.DENOMBRE) DENOMBREE,t1.DEMEDIACION DEMEDIACION,t1.DEBAJA DEBAJA,t2.PCODIGO PCODIGO,t2.PNOMBRE PNOMBRE,t2.PNOMBREE PNOMBREE, t1.DETIPOSOLICITUD DETIPOSOLICITUD "
						+ "FROM DECISION t1,TIPO_PROCEDIMIENTO t2 ");

		if (decision != null && decision.getDecodigo() != null) {
			where.append(" AND UPPER(t1.DECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.DECODIGO IS NOT NULL");
		}
		if (decision != null && decision.getDenombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DENOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDenombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + decision.getDenombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DENOMBRE IS NOT NULL");
		}
		if (decision != null && decision.getDenombree() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DENOMBREE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDenombree().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + decision.getDenombree().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DENOMBREE IS NOT NULL");
		}
		if (decision != null && decision.getDemediacion() != null) {
			where.append(" AND UPPER(t1.DEMEDIACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDemediacion().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDemediacion().toUpperCase() + "%");
			}
			where.append(" AND t1.DEMEDIACION IS NOT NULL");
		}

		if (decision != null && decision.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO = ?");
			params.add(decision.getPcodigo());
		}
		if (decision != null && decision.getDetiposolicitud() != null) {
			where.append(" AND t1.DETIPOSOLICITUD = ?");
			params.add(decision.getDetiposolicitud());
		}

		where.append(" AND t1.ISKONTSUMONET IS NULL");

		where.append(" AND t1.DEBAJA IS NULL");

		where.append(" AND t1.DECODIGO != ?");
		params.add(Y41bConstantes.DECISION_INSPECCIONES_ARCHIVO_AIP);

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Decision>) this.jdbcTemplate.query(query.toString(), new RowMapper<Decision>() {
			public Decision mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Decision(resultSet.getString("DECODIGO"), resultSet.getString("DENOMBRE"),
						resultSet.getString("DENOMBREE"), resultSet.getString("DEMEDIACION"),
						resultSet.getDate("DEBAJA"), resultSet.getString("PCODIGO"), resultSet.getString("PNOMBRE"),
						resultSet.getString("PNOMBREE"), resultSet.getString("DETIPOSOLICITUD"));
			}
		}, params.toArray());
	}

	/**
	 * Counts rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeDecisionCount(Decision decision, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PCODIGO= t2.PCODIGO(+)  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM DECISION t1,TIPO_PROCEDIMIENTO t2  ");
		if (decision != null && decision.getDecodigo() != null) {
			where.append(" AND UPPER(t1.DECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.DECODIGO IS NOT NULL");
		}
		if (decision != null && decision.getDenombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DENOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDenombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + decision.getDenombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DENOMBRE IS NOT NULL");
		}
		if (decision != null && decision.getDenombree() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DENOMBREE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDenombree().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + decision.getDenombree().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DENOMBREE IS NOT NULL");
		}
		if (decision != null && decision.getDemediacion() != null) {
			where.append(" AND UPPER(t1.DEMEDIACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDemediacion().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDemediacion().toUpperCase() + "%");
			}
			where.append(" AND t1.DEMEDIACION IS NOT NULL");
		}

		if (decision != null && decision.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO = ?");
			params.add(decision.getPcodigo());
		}
		if (decision != null && decision.getDetiposolicitud() != null) {
			where.append(" AND t1.DETIPOSOLICITUD = ?");
			params.add(decision.getDetiposolicitud());
		}

		where.append(" AND t1.ISKONTSUMONET IS NULL");

		where.append(" AND t1.DEBAJA IS NULL");

		where.append(" AND t1.DECODIGO != ?");
		params.add(Y41bConstantes.DECISION_INSPECCIONES_ARCHIVO_AIP);

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT SEQ_L21R8T00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

}
