package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Decision;

/**
 * * DecisionDao  
 * 
 *  
 */

public interface DecisionDao {

	/**
	 * Inserts a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision add(Decision decision);

	/**
	 * Updates a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision update(Decision decision);

	/**
	 * Updates a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision updateFecha(Decision decision);

	/**
	 * Finds a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision find(Decision decision);

	/**
	 * Deletes a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return
	 */
	void remove(Decision decision);

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Decision> findAll(Decision decision, Pagination pagination);

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Decision> findAllActivos(Decision decision, Pagination pagination);

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Decision> findAllActivosNoLaudo(Decision decision,
			Pagination pagination);

	/**
	 * Counts rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return List
	 */
	Long findAllCount(Decision decision);

	/**
	 * Finds rows in the Decision table using like.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Decision> findAllLike(Decision decision, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Decision table using like.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Decision> findAllLikeDecision(Decision decision,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeDecisionCount(Decision decision, Boolean startsWith);

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Decision> findAllDecisionBusquedaSolicitud(Decision decision,
			Pagination pagination);
}
