package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.DatosMailSede;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Sede;

/**
 * DatosMailSedeDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DatosMailSedeDaoImpl implements DatosMailSedeDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<DatosMailSede> rwMap = new RowMapper<DatosMailSede>() {
		public DatosMailSede mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DatosMailSede(resultSet.getString("IDDATOMAIL"),
					resultSet.getString("IDDATOSEDE"),
					resultSet.getString("PCODIGO"),
					resultSet.getString("EMAIL"),
					resultSet.getString("DESCRIPCION"),
					resultSet.getString("DESCRIPCIONE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the DatosMailSede table.
	 * 
	 * @param datosmailsede
	 *            Pagination
	 * @return DatosMailSede
	 */
	public DatosMailSede add(DatosMailSede datosmailsede) {
		String query = "INSERT INTO DATOS_MAIL_SEDE (ID_DATOMAIL, ID_DATOSEDE, PCODIGO, EMAIL, DESCRIPCION, DESCRIPCIONE) VALUES (?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, datosmailsede.getIdDatomail(),
				datosmailsede.getIdDatosede(), datosmailsede.getPcodigo(),
				datosmailsede.getEmail(), datosmailsede.getDescripcion(),
				datosmailsede.getDescripcione());
		return datosmailsede;
	}

	/**
	 * Updates a single row in the DatosMailSede table.
	 * 
	 * @param datosmailsede
	 *            Pagination
	 * @return DatosMailSede
	 */
	public DatosMailSede update(DatosMailSede datosmailsede) {
		String query = "UPDATE DATOS_MAIL_SEDE SET ID_DATOSEDE=?, PCODIGO=?, EMAIL=?, DESCRIPCION=?, DESCRIPCIONE=? WHERE ID_DATOMAIL=?";
		this.jdbcTemplate.update(query, datosmailsede.getIdDatosede(),
				datosmailsede.getPcodigo(), datosmailsede.getEmail(),
				datosmailsede.getDescripcion(),
				datosmailsede.getDescripcione(), datosmailsede.getIdDatomail());
		return datosmailsede;
	}

	/**
	 * Finds a single row in the DatosMailSede table.
	 * 
	 * @param datosmailsede
	 *            Pagination
	 * @return DatosMailSede
	 */
	@Transactional(readOnly = true)
	public DatosMailSede find(DatosMailSede datosmailsede) {
		String query = "SELECT t1.ID_DATOMAIL IDDATOMAIL, t1.ID_DATOSEDE IDDATOSEDE, t1.PCODIGO PCODIGO, t1.EMAIL EMAIL, t1.DESCRIPCION DESCRIPCION, t1.DESCRIPCIONE DESCRIPCIONE FROM DATOS_MAIL_SEDE t1  WHERE t1.ID_DATOMAIL = ?  ";

		List<DatosMailSede> datosmailsedeList = this.jdbcTemplate.query(query,
				this.rwMap, datosmailsede.getIdDatomail());
		return (DatosMailSede) DataAccessUtils.uniqueResult(datosmailsedeList);
	}

	/**
	 * Removes a single row in the DatosMailSede table.
	 * 
	 * @param datosmailsede
	 *            Pagination
	 * @return
	 */
	public void remove(DatosMailSede datosmailsede) {
		String query = "DELETE FROM DATOS_MAIL_SEDE WHERE ID_DATOMAIL=?";
		this.jdbcTemplate.update(query, datosmailsede.getIdDatomail());
	}

	/**
	 * Finds a List of rows in the DatosMailSede table.
	 * 
	 * @param datosmailsede
	 *            DatosMailSede
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DatosMailSede> findAll(DatosMailSede datosmailsede,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DATOMAIL IDDATOMAIL,t1.ID_DATOSEDE IDDATOSEDE,t1.PCODIGO PCODIGO,t1.EMAIL EMAIL,t1.DESCRIPCION DESCRIPCION,t1.DESCRIPCIONE DESCRIPCIONE ");
		query.append("FROM DATOS_MAIL_SEDE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(datosmailsede);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DatosMailSede>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DatosMailSede table.
	 * 
	 * @param datosmailsede
	 *            DatosMailSede
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DatosMailSede datosmailsede) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DATOS_MAIL_SEDE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(datosmailsede);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the DatosMailSede table using like.
	 * 
	 * @param datosmailsede
	 *            DatosMailSede
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DatosMailSede> findAllLike(DatosMailSede datosmailsede,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DATOMAIL IDDATOMAIL,t1.ID_DATOSEDE IDDATOSEDE,t1.PCODIGO PCODIGO,t1.EMAIL EMAIL,t1.DESCRIPCION DESCRIPCION,t1.DESCRIPCIONE DESCRIPCIONE ");
		query.append("FROM DATOS_MAIL_SEDE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(datosmailsede,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DatosMailSede>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DatosMailSede table using like.
	 * 
	 * @param datosmailsede
	 *            DatosMailSede
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DatosMailSede datosmailsede, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DATOS_MAIL_SEDE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(datosmailsede,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DatosMailSede entity
	 * 
	 * @param datosmailsede
	 *            DatosMailSede Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DatosMailSede datosmailsede) {

		StringBuilder where = new StringBuilder(
				DatosMailSedeDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (datosmailsede != null && datosmailsede.getIdDatomail() != null) {
			where.append(" AND t1.ID_DATOMAIL = ?");
			params.add(datosmailsede.getIdDatomail());
		}
		if (datosmailsede != null && datosmailsede.getIdDatosede() != null) {
			where.append(" AND t1.ID_DATOSEDE = ?");
			params.add(datosmailsede.getIdDatosede());
		}
		if (datosmailsede != null && datosmailsede.getEscodigo() != null) {
			where.append(" AND t1.ID_DATOSEDE IN (SELECT t2.ID_DATOSEDE FROM SEDE t2 WHERE t2.ESCODIGO = ?)");
			params.add(datosmailsede.getEscodigo());
		}
		if (datosmailsede != null && datosmailsede.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO = ?");
			params.add(datosmailsede.getPcodigo());
		}
		if (datosmailsede != null && datosmailsede.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(datosmailsede.getEmail());
		}
		if (datosmailsede != null && datosmailsede.getDescripcion() != null) {
			where.append(" AND t1.DESCRIPCION = ?");
			params.add(datosmailsede.getDescripcion());
		}
		if (datosmailsede != null && datosmailsede.getDescripcione() != null) {
			where.append(" AND t1.DESCRIPCIONE = ?");
			params.add(datosmailsede.getDescripcione());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DatosMailSede entity
	 * 
	 * @param datosmailsede
	 *            DatosMailSede Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(DatosMailSede datosmailsede,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DatosMailSedeDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (datosmailsede != null && datosmailsede.getIdDatomail() != null) {
			where.append(" AND UPPER(t1.ID_DATOMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosmailsede.getIdDatomail().toUpperCase() + "%");
			} else {
				params.add("%" + datosmailsede.getIdDatomail().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ID_DATOMAIL IS NOT NULL");
		}
		if (datosmailsede != null && datosmailsede.getIdDatosede() != null) {
			where.append(" AND UPPER(t1.ID_DATOSEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosmailsede.getIdDatosede().toUpperCase() + "%");
			} else {
				params.add("%" + datosmailsede.getIdDatosede().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ID_DATOSEDE IS NOT NULL");
		}
		if (datosmailsede != null && datosmailsede.getPcodigo() != null) {
			where.append(" AND UPPER(t1.PCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosmailsede.getPcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + datosmailsede.getPcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PCODIGO IS NOT NULL");
		}
		if (datosmailsede != null && datosmailsede.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosmailsede.getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + datosmailsede.getEmail().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}
		if (datosmailsede != null && datosmailsede.getDescripcion() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosmailsede.getDescripcion().toUpperCase() + "%");
			} else {
				params.add("%" + datosmailsede.getDescripcion().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESCRIPCION IS NOT NULL");
		}
		if (datosmailsede != null && datosmailsede.getDescripcione() != null) {
			where.append(" AND UPPER(t1.DESCRIPCIONE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosmailsede.getDescripcione().toUpperCase() + "%");
			} else {
				params.add("%" + datosmailsede.getDescripcione().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESCRIPCIONE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Inserts a single row in the AdjunDatosMailEstablecSede table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param sedeAux
	 *            Sede
	 */
	public void addAdjunDatosMailEstablecSede(Establecimiento establecimiento,
			Sede sedeAux) {

		String query = "INSERT INTO ADJUN_DATOS_MAIL_SEDE (ID_DATOMAIL, ID_DATOSEDE, PCODIGO, EMAIL, DESCRIPCION, DESCRIPCIONE) SELECT t1.ID_DATOMAIL IDDATOMAIL, ? IDDATOSEDE, t1.PCODIGO PCODIGO, t1.EMAIL EMAIL, t1.DESCRIPCION DESCRIPCION, t1.DESCRIPCIONE DESCRIPCIONE FROM DATOS_MAIL_SEDE t1  WHERE t1.ID_DATOSEDE IN (SELECT t1.ID_DATOSEDE FROM SEDE t1  WHERE t1.ESCODIGO = ? ) ";
		this.jdbcTemplate.update(query, sedeAux.getIdDatosede(),
				establecimiento.getEscodigo());
	}

	/**
	 * Removes a single row in the DATOS_MAIL_SEDE table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeAllDatosMailSede(Establecimiento establecimiento) {
		String query = "DELETE FROM DATOS_MAIL_SEDE WHERE ID_DATOSEDE IN (SELECT t1.ID_DATOSEDE FROM SEDE t1  WHERE t1.ESCODIGO = ? ) ";
		this.jdbcTemplate.update(query, establecimiento.getEscodigo());
	}

	/**
	 * Inserts a single row in the DATOS_MAIL_SEDE table.
	 * 
	 * @param sede
	 *            Sede
	 * @param sedeAux
	 *            Sede
	 */
	public void addDatosMailSedeAdjunDatos(Sede sede, Sede sedeAux) {

		String query = "INSERT INTO DATOS_MAIL_SEDE	(ID_DATOMAIL, ID_DATOSEDE, PCODIGO, EMAIL, DESCRIPCION, DESCRIPCIONE) SELECT t1.ID_DATOMAIL IDDATOMAIL, ? IDDATOSEDE, t1.PCODIGO PCODIGO, t1.EMAIL EMAIL, t1.DESCRIPCION DESCRIPCION, t1.DESCRIPCIONE DESCRIPCIONE FROM ADJUN_DATOS_MAIL_SEDE t1  WHERE t1.ID_DATOSEDE = ? AND t1.PCODIGO = ? ";

		this.jdbcTemplate.update(query, sede.getIdDatosede(),
				sedeAux.getIdDatosede(), sede.getPcodigo());
	}

}
