package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.DatosMailSede;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Sede;

/**
 * DatosMailSedeDao  
 * 
 *  
 */

public interface DatosMailSedeDao {

	/**
	 * Inserts a single row in the DatosMailSede table.
	 * 
	 * @param datosmailsede
	 *            DatosMailSede
	 * @return DatosMailSede
	 */
	DatosMailSede add(DatosMailSede datosmailsede);

	/**
	 * Updates a single row in the DatosMailSede table.
	 * 
	 * @param datosmailsede
	 *            DatosMailSede
	 * @return DatosMailSede
	 */
	DatosMailSede update(DatosMailSede datosmailsede);

	/**
	 * Finds a single row in the DatosMailSede table.
	 * 
	 * @param datosmailsede
	 *            DatosMailSede
	 * @return DatosMailSede
	 */
	DatosMailSede find(DatosMailSede datosmailsede);

	/**
	 * Deletes a single row in the DatosMailSede table.
	 * 
	 * @param datosmailsede
	 *            DatosMailSede
	 * @return
	 */
	void remove(DatosMailSede datosmailsede);

	/**
	 * Finds a List of rows in the DatosMailSede table.
	 * 
	 * @param datosmailsede
	 *            DatosMailSede
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DatosMailSede> findAll(DatosMailSede datosmailsede,
			Pagination pagination);

	/**
	 * Counts rows in the DatosMailSede table.
	 * 
	 * @param datosmailsede
	 *            DatosMailSede
	 * @return Long
	 */
	Long findAllCount(DatosMailSede datosmailsede);

	/**
	 * Finds rows in the DatosMailSede table using like.
	 * 
	 * @param datosmailsede
	 *            DatosMailSede
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<DatosMailSede> findAllLike(DatosMailSede datosmailsede,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the DatosMailSede table using like.
	 * 
	 * @param datosmailsede
	 *            DatosMailSede
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(DatosMailSede datosmailsede, Boolean startsWith);

	/**
	 * Inserts a single row in the AdjunDatosMailEstablecSede table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param sedeAux
	 *            Sede
	 */
	public void addAdjunDatosMailEstablecSede(Establecimiento establecimiento,
			Sede sedeAux);

	/**
	 * Removes a single row in the DATOS_MAIL_SEDE table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeAllDatosMailSede(Establecimiento establecimiento);

	/**
	 * Inserts a single row in the DATOS_MAIL_SEDE table.
	 * 
	 * @param sede
	 *            Sede
	 * @param sedeAux
	 *            Sede
	 */
	public void addDatosMailSedeAdjunDatos(Sede sede, Sede sedeAux);

}
