package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.DatosMailEstablecimiento;
import com.ejie.y41b.model.Establecimiento;

/**
 * DatosMailEstablecimientoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DatosMailEstablecimientoDaoImpl implements
		DatosMailEstablecimientoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<DatosMailEstablecimiento> rwMap = new RowMapper<DatosMailEstablecimiento>() {
		public DatosMailEstablecimiento mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DatosMailEstablecimiento(
					resultSet.getString("IDDATOMAIL"),
					resultSet.getString("ESCODIGO"),
					resultSet.getString("EMAIL"),
					resultSet.getString("DESCRIPCION"),
					resultSet.getString("DESCRIPCIONE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the DatosMailEstablecimiento table.
	 * 
	 * @param datosmailestablecimiento
	 *            Pagination
	 * @return DatosMailEstablecimiento
	 */
	public DatosMailEstablecimiento add(
			DatosMailEstablecimiento datosmailestablecimiento) {
		String query = "INSERT INTO DATOS_MAIL_ESTABLECIMIENTO (ID_DATOMAIL, ESCODIGO, EMAIL, DESCRIPCION, DESCRIPCIONE) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query,
				datosmailestablecimiento.getIdDatomail(),
				datosmailestablecimiento.getEscodigo(),
				datosmailestablecimiento.getEmail(),
				datosmailestablecimiento.getDescripcion(),
				datosmailestablecimiento.getDescripcione());
		return datosmailestablecimiento;
	}

	/**
	 * Updates a single row in the DatosMailEstablecimiento table.
	 * 
	 * @param datosmailestablecimiento
	 *            Pagination
	 * @return DatosMailEstablecimiento
	 */
	public DatosMailEstablecimiento update(
			DatosMailEstablecimiento datosmailestablecimiento) {
		String query = "UPDATE DATOS_MAIL_ESTABLECIMIENTO SET ESCODIGO=?, EMAIL=?, DESCRIPCION=?, DESCRIPCIONE=? WHERE ID_DATOMAIL=?";
		this.jdbcTemplate.update(query, datosmailestablecimiento.getEscodigo(),
				datosmailestablecimiento.getEmail(),
				datosmailestablecimiento.getDescripcion(),
				datosmailestablecimiento.getDescripcione(),
				datosmailestablecimiento.getIdDatomail());
		return datosmailestablecimiento;
	}

	/**
	 * Finds a single row in the DatosMailEstablecimiento table.
	 * 
	 * @param datosmailestablecimiento
	 *            Pagination
	 * @return DatosMailEstablecimiento
	 */
	@Transactional(readOnly = true)
	public DatosMailEstablecimiento find(
			DatosMailEstablecimiento datosmailestablecimiento) {
		String query = "SELECT t1.ID_DATOMAIL IDDATOMAIL, t1.ESCODIGO ESCODIGO, t1.EMAIL EMAIL, t1.DESCRIPCION DESCRIPCION, t1.DESCRIPCIONE DESCRIPCIONE FROM DATOS_MAIL_ESTABLECIMIENTO t1  WHERE t1.ID_DATOMAIL = ?  ";

		List<DatosMailEstablecimiento> datosmailestablecimientoList = this.jdbcTemplate
				.query(query, this.rwMap,
						datosmailestablecimiento.getIdDatomail());
		return (DatosMailEstablecimiento) DataAccessUtils
				.uniqueResult(datosmailestablecimientoList);
	}

	/**
	 * Removes a single row in the DatosMailEstablecimiento table.
	 * 
	 * @param datosmailestablecimiento
	 *            Pagination
	 * @return
	 */
	public void remove(DatosMailEstablecimiento datosmailestablecimiento) {
		String query = "DELETE FROM DATOS_MAIL_ESTABLECIMIENTO WHERE ID_DATOMAIL=?";
		this.jdbcTemplate.update(query,
				datosmailestablecimiento.getIdDatomail());
	}

	/**
	 * Finds a List of rows in the DatosMailEstablecimiento table.
	 * 
	 * @param datosmailestablecimiento
	 *            DatosMailEstablecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DatosMailEstablecimiento> findAll(
			DatosMailEstablecimiento datosmailestablecimiento,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DATOMAIL IDDATOMAIL,t1.ESCODIGO ESCODIGO,t1.EMAIL EMAIL,t1.DESCRIPCION DESCRIPCION,t1.DESCRIPCIONE DESCRIPCIONE ");
		query.append("FROM DATOS_MAIL_ESTABLECIMIENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(datosmailestablecimiento);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DatosMailEstablecimiento>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DatosMailEstablecimiento table.
	 * 
	 * @param datosmailestablecimiento
	 *            DatosMailEstablecimiento
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DatosMailEstablecimiento datosmailestablecimiento) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DATOS_MAIL_ESTABLECIMIENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(datosmailestablecimiento);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the DatosMailEstablecimiento table using like.
	 * 
	 * @param datosmailestablecimiento
	 *            DatosMailEstablecimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DatosMailEstablecimiento> findAllLike(
			DatosMailEstablecimiento datosmailestablecimiento,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DATOMAIL IDDATOMAIL,t1.ESCODIGO ESCODIGO,t1.EMAIL EMAIL,t1.DESCRIPCION DESCRIPCION,t1.DESCRIPCIONE DESCRIPCIONE ");
		query.append("FROM DATOS_MAIL_ESTABLECIMIENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				datosmailestablecimiento, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<DatosMailEstablecimiento>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DatosMailEstablecimiento table using like.
	 * 
	 * @param datosmailestablecimiento
	 *            DatosMailEstablecimiento
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(
			DatosMailEstablecimiento datosmailestablecimiento,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DATOS_MAIL_ESTABLECIMIENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				datosmailestablecimiento, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DatosMailEstablecimiento entity
	 * 
	 * @param datosmailestablecimiento
	 *            DatosMailEstablecimiento Bean with the criteria values to
	 *            filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			DatosMailEstablecimiento datosmailestablecimiento) {

		StringBuilder where = new StringBuilder(
				DatosMailEstablecimientoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (datosmailestablecimiento != null
				&& datosmailestablecimiento.getIdDatomail() != null) {
			where.append(" AND t1.ID_DATOMAIL = ?");
			params.add(datosmailestablecimiento.getIdDatomail());
		}
		if (datosmailestablecimiento != null
				&& datosmailestablecimiento.getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(datosmailestablecimiento.getEscodigo());
		}
		if (datosmailestablecimiento != null
				&& datosmailestablecimiento.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(datosmailestablecimiento.getEmail());
		}
		if (datosmailestablecimiento != null
				&& datosmailestablecimiento.getDescripcion() != null) {
			where.append(" AND t1.DESCRIPCION = ?");
			params.add(datosmailestablecimiento.getDescripcion());
		}
		if (datosmailestablecimiento != null
				&& datosmailestablecimiento.getDescripcione() != null) {
			where.append(" AND t1.DESCRIPCIONE = ?");
			params.add(datosmailestablecimiento.getDescripcione());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DatosMailEstablecimiento entity
	 * 
	 * @param datosmailestablecimiento
	 *            DatosMailEstablecimiento Bean with the criteria values to
	 *            filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			DatosMailEstablecimiento datosmailestablecimiento,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DatosMailEstablecimientoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (datosmailestablecimiento != null
				&& datosmailestablecimiento.getIdDatomail() != null) {
			where.append(" AND UPPER(t1.ID_DATOMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosmailestablecimiento.getIdDatomail()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ datosmailestablecimiento.getIdDatomail()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.ID_DATOMAIL IS NOT NULL");
		}
		if (datosmailestablecimiento != null
				&& datosmailestablecimiento.getEscodigo() != null) {
			where.append(" AND UPPER(t1.ESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosmailestablecimiento.getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ datosmailestablecimiento.getEscodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESCODIGO IS NOT NULL");
		}
		if (datosmailestablecimiento != null
				&& datosmailestablecimiento.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosmailestablecimiento.getEmail().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ datosmailestablecimiento.getEmail().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}
		if (datosmailestablecimiento != null
				&& datosmailestablecimiento.getDescripcion() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosmailestablecimiento.getDescripcion()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ datosmailestablecimiento.getDescripcion()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION IS NOT NULL");
		}
		if (datosmailestablecimiento != null
				&& datosmailestablecimiento.getDescripcione() != null) {
			where.append(" AND UPPER(t1.DESCRIPCIONE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosmailestablecimiento.getDescripcione()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ datosmailestablecimiento.getDescripcione()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCIONE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Inserts a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 */
	public void addAdjunDatosMailEstablec(Establecimiento establecimiento) {

		String query = "INSERT INTO ADJUN_DATOS_MAIL_ESTABLEC (ID_DATOMAIL, ESCODIGO, EMAIL, DESCRIPCION, DESCRIPCIONE) SELECT t1.ID_DATOMAIL IDDATOMAIL, t1.ESCODIGO ESCODIGO, t1.EMAIL EMAIL, t1.DESCRIPCION DESCRIPCION, t1.DESCRIPCIONE DESCRIPCIONE FROM DATOS_MAIL_ESTABLECIMIENTO t1  WHERE t1.ESCODIGO = ?";
		this.jdbcTemplate.update(query, establecimiento.getEscodigo());
	}

	/**
	 * Removes a single row in the DATOS_MAIL_ESTABLECIMIENTO table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeAllDatosMailEstablec(Establecimiento establecimiento) {
		String query = "DELETE FROM DATOS_MAIL_ESTABLECIMIENTO WHERE ESCODIGO=?";
		this.jdbcTemplate.update(query, establecimiento.getEscodigo());
	}

	/**
	 * Inserts a single row in the DATOS_MAIL_ESTABLECIMIENTO table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 */
	public void addDatosMailEstablecAdjunDatos(Establecimiento establecimiento) {

		String query = "INSERT INTO DATOS_MAIL_ESTABLECIMIENTO	(ID_DATOMAIL, ESCODIGO, EMAIL, DESCRIPCION, DESCRIPCIONE) SELECT t1.ID_DATOMAIL IDDATOMAIL, t1.ESCODIGO ESCODIGO, t1.EMAIL EMAIL, t1.DESCRIPCION DESCRIPCION, t1.DESCRIPCIONE DESCRIPCIONE FROM ADJUN_DATOS_MAIL_ESTABLEC t1  WHERE t1.ESCODIGO = ?";
		this.jdbcTemplate.update(query, establecimiento.getEscodigo());
	}

}
