package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.DatosMailEstablecimiento;
import com.ejie.y41b.model.Establecimiento;

/**
 * DatosMailEstablecimientoDao  
 * 
 *  
 */

public interface DatosMailEstablecimientoDao {

	/**
	 * Inserts a single row in the DatosMailEstablecimiento table.
	 * 
	 * @param datosmailestablecimiento
	 *            DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	DatosMailEstablecimiento add(
			DatosMailEstablecimiento datosmailestablecimiento);

	/**
	 * Updates a single row in the DatosMailEstablecimiento table.
	 * 
	 * @param datosmailestablecimiento
	 *            DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	DatosMailEstablecimiento update(
			DatosMailEstablecimiento datosmailestablecimiento);

	/**
	 * Finds a single row in the DatosMailEstablecimiento table.
	 * 
	 * @param datosmailestablecimiento
	 *            DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	DatosMailEstablecimiento find(
			DatosMailEstablecimiento datosmailestablecimiento);

	/**
	 * Deletes a single row in the DatosMailEstablecimiento table.
	 * 
	 * @param datosmailestablecimiento
	 *            DatosMailEstablecimiento
	 * @return
	 */
	void remove(DatosMailEstablecimiento datosmailestablecimiento);

	/**
	 * Finds a List of rows in the DatosMailEstablecimiento table.
	 * 
	 * @param datosmailestablecimiento
	 *            DatosMailEstablecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DatosMailEstablecimiento> findAll(
			DatosMailEstablecimiento datosmailestablecimiento,
			Pagination pagination);

	/**
	 * Counts rows in the DatosMailEstablecimiento table.
	 * 
	 * @param datosmailestablecimiento
	 *            DatosMailEstablecimiento
	 * @return Long
	 */
	Long findAllCount(DatosMailEstablecimiento datosmailestablecimiento);

	/**
	 * Finds rows in the DatosMailEstablecimiento table using like.
	 * 
	 * @param datosmailestablecimiento
	 *            DatosMailEstablecimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<DatosMailEstablecimiento> findAllLike(
			DatosMailEstablecimiento datosmailestablecimiento,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the DatosMailEstablecimiento table using like.
	 * 
	 * @param datosmailestablecimiento
	 *            DatosMailEstablecimiento
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(DatosMailEstablecimiento datosmailestablecimiento,
			Boolean startsWith);

	/**
	 * Inserts a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 */
	public void addAdjunDatosMailEstablec(Establecimiento establecimiento);

	/**
	 * Removes a single row in the DATOS_MAIL_ESTABLECIMIENTO table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeAllDatosMailEstablec(Establecimiento establecimiento);

	/**
	 * Inserts a single row in the DATOS_MAIL_ESTABLECIMIENTO table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 */
	public void addDatosMailEstablecAdjunDatos(Establecimiento establecimiento);
}
