package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.CorrespondenciaDecisionL21;

/**
 * CorrespondenciaDecisionL21DaoImpl  
 *  
 */
 
@Repository
@Transactional
public class CorrespondenciaDecisionL21DaoImpl implements CorrespondenciaDecisionL21Dao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<CorrespondenciaDecisionL21> rwMap = new RowMapper<CorrespondenciaDecisionL21>() {
		public CorrespondenciaDecisionL21 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new CorrespondenciaDecisionL21(
               resultSet.getString("IDEQUIVALENCIA"), resultSet.getString("DECODIGOY41B"), resultSet.getString("DECODIGOL21")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the CorrespondenciaDecisionL21 table.
     *
     * @param correspondenciadecisionl21 Pagination
     * @return CorrespondenciaDecisionL21
     */
	public CorrespondenciaDecisionL21 add(CorrespondenciaDecisionL21 correspondenciadecisionl21) {
    	String query = "INSERT INTO CORRESPONDENCIA_DECISION_L21 (ID_EQUIVALENCIA, DECODIGOY41B, DECODIGOL21) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, correspondenciadecisionl21.getIdEquivalencia(), correspondenciadecisionl21.getDecodigoy41b(), correspondenciadecisionl21.getDecodigol21());
		return correspondenciadecisionl21;
	}

    /**
     * Updates a single row in the CorrespondenciaDecisionL21 table.
     *
     * @param correspondenciadecisionl21 Pagination
     * @return CorrespondenciaDecisionL21
     */
    public CorrespondenciaDecisionL21 update(CorrespondenciaDecisionL21 correspondenciadecisionl21) {
		String query = "UPDATE CORRESPONDENCIA_DECISION_L21 SET DECODIGOY41B=?, DECODIGOL21=? WHERE ID_EQUIVALENCIA=?";
		this.jdbcTemplate.update(query, correspondenciadecisionl21.getDecodigoy41b(), correspondenciadecisionl21.getDecodigol21(), correspondenciadecisionl21.getIdEquivalencia());
		return correspondenciadecisionl21;
	}

    /**
     * Finds a single row in the CorrespondenciaDecisionL21 table.
     *
     * @param correspondenciadecisionl21 Pagination
     * @return CorrespondenciaDecisionL21
     */
    @Transactional (readOnly = true)
    public CorrespondenciaDecisionL21 find(CorrespondenciaDecisionL21 correspondenciadecisionl21) {
		String query = "SELECT t1.ID_EQUIVALENCIA IDEQUIVALENCIA, t1.DECODIGOY41B DECODIGOY41B, t1.DECODIGOL21 DECODIGOL21 FROM CORRESPONDENCIA_DECISION_L21 t1  WHERE t1.ID_EQUIVALENCIA = ?  ";
		
		List<CorrespondenciaDecisionL21> correspondenciadecisionl21List = this.jdbcTemplate.query(query, this.rwMap, correspondenciadecisionl21.getIdEquivalencia());
		return (CorrespondenciaDecisionL21) DataAccessUtils.uniqueResult(correspondenciadecisionl21List);
    }

    /**
     * Removes a single row in the CorrespondenciaDecisionL21 table.
     *
     * @param correspondenciadecisionl21 Pagination
     * @return
     */
    public void remove(CorrespondenciaDecisionL21 correspondenciadecisionl21) {
		String query = "DELETE FROM CORRESPONDENCIA_DECISION_L21 WHERE ID_EQUIVALENCIA=?";
		this.jdbcTemplate.update(query, correspondenciadecisionl21.getIdEquivalencia());
    }
    
   /**
    * Finds a List of rows in the CorrespondenciaDecisionL21 table.
    * 
    * @param correspondenciadecisionl21 CorrespondenciaDecisionL21
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<CorrespondenciaDecisionL21> findAll(CorrespondenciaDecisionL21 correspondenciadecisionl21, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_EQUIVALENCIA IDEQUIVALENCIA,t1.DECODIGOY41B DECODIGOY41B,t1.DECODIGOL21 DECODIGOL21 "); 
		query.append("FROM CORRESPONDENCIA_DECISION_L21 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(correspondenciadecisionl21); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<CorrespondenciaDecisionL21>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the CorrespondenciaDecisionL21 table.
     * 
     * @param correspondenciadecisionl21 CorrespondenciaDecisionL21
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(CorrespondenciaDecisionL21 correspondenciadecisionl21) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM CORRESPONDENCIA_DECISION_L21 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(correspondenciadecisionl21); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the CorrespondenciaDecisionL21 table using like.
     * 
     * @param correspondenciadecisionl21 CorrespondenciaDecisionL21
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<CorrespondenciaDecisionL21> findAllLike(CorrespondenciaDecisionL21 correspondenciadecisionl21, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_EQUIVALENCIA IDEQUIVALENCIA,t1.DECODIGOY41B DECODIGOY41B,t1.DECODIGOL21 DECODIGOL21 "); 
        query.append("FROM CORRESPONDENCIA_DECISION_L21 t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(correspondenciadecisionl21,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<CorrespondenciaDecisionL21>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the CorrespondenciaDecisionL21 table using like.
     * 
     * @param correspondenciadecisionl21 CorrespondenciaDecisionL21
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(CorrespondenciaDecisionL21 correspondenciadecisionl21, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM CORRESPONDENCIA_DECISION_L21 t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(correspondenciadecisionl21,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the CorrespondenciaDecisionL21 entity 
	 * 
	 * @param correspondenciadecisionl21 CorrespondenciaDecisionL21
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (CorrespondenciaDecisionL21 correspondenciadecisionl21){
		
		StringBuilder where = new StringBuilder(CorrespondenciaDecisionL21DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (correspondenciadecisionl21  != null  && correspondenciadecisionl21.getIdEquivalencia() != null ) {
			where.append(" AND t1.ID_EQUIVALENCIA = ?");
			params.add(correspondenciadecisionl21.getIdEquivalencia());
		}
		if (correspondenciadecisionl21  != null  && correspondenciadecisionl21.getDecodigoy41b() != null ) {
			where.append(" AND t1.DECODIGOY41B = ?");
			params.add(correspondenciadecisionl21.getDecodigoy41b());
		}
		if (correspondenciadecisionl21  != null  && correspondenciadecisionl21.getDecodigol21() != null ) {
			where.append(" AND t1.DECODIGOL21 = ?");
			params.add(correspondenciadecisionl21.getDecodigol21());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the CorrespondenciaDecisionL21 entity 
	 * 
	 * @param correspondenciadecisionl21 CorrespondenciaDecisionL21
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (CorrespondenciaDecisionL21 correspondenciadecisionl21, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(CorrespondenciaDecisionL21DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (correspondenciadecisionl21  != null  && correspondenciadecisionl21.getIdEquivalencia() != null ) {
			where.append(" AND UPPER(t1.ID_EQUIVALENCIA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(correspondenciadecisionl21.getIdEquivalencia().toUpperCase() +"%");
			}else{
				params.add("%"+correspondenciadecisionl21.getIdEquivalencia().toUpperCase() +"%");
			}
			where.append(" AND t1.ID_EQUIVALENCIA IS NOT NULL");
	     }			
		if (correspondenciadecisionl21  != null  && correspondenciadecisionl21.getDecodigoy41b() != null ) {
			where.append(" AND UPPER(t1.DECODIGOY41B) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(correspondenciadecisionl21.getDecodigoy41b().toUpperCase() +"%");
			}else{
				params.add("%"+correspondenciadecisionl21.getDecodigoy41b().toUpperCase() +"%");
			}
			where.append(" AND t1.DECODIGOY41B IS NOT NULL");
	     }			
		if (correspondenciadecisionl21  != null  && correspondenciadecisionl21.getDecodigol21() != null ) {
			where.append(" AND UPPER(t1.DECODIGOL21) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(correspondenciadecisionl21.getDecodigol21().toUpperCase() +"%");
			}else{
				params.add("%"+correspondenciadecisionl21.getDecodigol21().toUpperCase() +"%");
			}
			where.append(" AND t1.DECODIGOL21 IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

